# This file is automatically generated. Do not modify it manually!
from functools import lru_cache

from .config import cond, Number, getMudim, getDiffeps
from .OneLoop import B0fin, B0del
from .T134 import T134fin


@lru_cache(maxsize=150)
def T11134(m1: Number, m2: Number, m3: Number, m4: Number, m5, mudim = None) -> Number:
	""" Computes the UV-finite part of the T11134 integral.

	Args:
		m1: internal mass
		m2: internal mass
		m3: internal mass
		m4: internal mass
		m5: internal mass
		mudim: squared renormalization scale (if `None`, the global value is used)

	Returns:
		finite part of the T11134 integral.
	"""

	try:

		if mudim is None:
			mudim = getMudim()

		# rescale masses for better numerical stability
		mass_scale = max([m1, m2, m3, m4, m5])
		if mass_scale <= getDiffeps():
			return 0
		m1 /= mass_scale
		m2 /= mass_scale
		m3 /= mass_scale
		m4 /= mass_scale
		m5 /= mass_scale
		mudim /= mass_scale**2
		m1, m2, m3 = sorted([m1, m2, m3])
		
		

		m1sq = m1**2
		m2sq = m2**2
		m3sq = m3**2
		m4sq = m4**2
		m5sq = m5**2

		def eval_1():
			return 0
		def eval_2():
			return T134fin(m3,0,0,mudim)/m3**4
		def eval_3():
			return (11 - 6*B0fin(0,0,m4sq,mudim))/(18.*m4**2)
		def eval_4():
			return (m4**6 + 3*m4sq*m5**4 + m5**6 + 3*m4**4*m5sq + 2*m4sq*m5sq*(m4sq + m5sq)*B0del(0,0,m4sq,mudim) + 2*m4sq*m5sq*(m4sq + m5sq)*B0del(0,0,m5sq,mudim) - 2*m4**6*B0fin(0,0,m4sq,mudim) + 6*m4**4*m5sq*B0fin(0,0,m4sq,mudim) + 6*m4sq*m5**4*B0fin(0,0,m5sq,mudim) - 2*m5**6*B0fin(0,0,m5sq,mudim) + 2*m4sq*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m4**4*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m4sq*m5sq*T134fin(m5,m4,0,mudim))/(2.*(m4sq - m5sq)**4)
		def eval_5():
			return (2*(m3sq - 2*m4sq)*B0del(0,0,m4sq,mudim) - 2*(3*m3sq + 2*m4sq)*B0fin(0,0,m4sq,mudim) + (m3sq - 2*m4sq)*B0fin(0,0,m4sq,mudim)**2 + 2*(3*m3sq - 2*m4sq + T134fin(m4,m4,m3,mudim)))/(2.*m3**4)
		def eval_6():
			return (1 - B0fin(0,0,m1sq,mudim))/m1**2
		def eval_7():
			return (1 - B0fin(0,0,m1sq,mudim))/m1**2
		def eval_8():
			return -0.5*(4*m2sq + 2*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) - 2*(m1sq - 3*m2sq)*B0fin(0,0,m2sq,mudim) + (m1sq + m2sq)*B0fin(0,0,m2sq,mudim)**2 - 2*T134fin(m2,m1,0,mudim))/(m1sq - m2sq)**2
		def eval_9():
			return -0.5*(4*m2sq + 2*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) - 2*(m1sq - 3*m2sq)*B0fin(0,0,m2sq,mudim) + (m1sq + m2sq)*B0fin(0,0,m2sq,mudim)**2 - 2*T134fin(m2,m1,0,mudim))/(m1sq - m2sq)**2
		def eval_10():
			return (-4*m1sq - 2*(m1sq + m3sq)*B0del(0,0,m1sq,mudim) + (-6*m1sq + 2*m3sq)*B0fin(0,0,m1sq,mudim) - (m1sq + m3sq)*B0fin(0,0,m1sq,mudim)**2 + 2*T134fin(m3,m1,0,mudim))/(2.*(m1sq - m3sq)**2)
		def eval_11():
			return (-4*m1sq - 2*(m1sq + m3sq)*B0del(0,0,m1sq,mudim) + (-6*m1sq + 2*m3sq)*B0fin(0,0,m1sq,mudim) - (m1sq + m3sq)*B0fin(0,0,m1sq,mudim)**2 + 2*T134fin(m3,m1,0,mudim))/(2.*(m1sq - m3sq)**2)
		def eval_12():
			return (m1**8 + 6*m1**4*m4**4 - 4*m1sq*m4**6 + m4**8 - 4*m1**6*m4sq + 6*m1**4*m5**4 + 6*m4**4*m5**4 + 8*m1sq*m4sq*m5**4 - 4*m1sq*m5**6 - 4*m4sq*m5**6 + m5**8 - 4*m1**6*m5sq + 8*m1sq*m4**4*m5sq - 4*m4**6*m5sq + 8*m1**4*m4sq*m5sq + 4*m1**4*m4sq*m5sq*B0del(0,0,m1sq,mudim) + 4*m1sq*m4**4*m5sq*B0del(0,0,m4sq,mudim) + 4*m1sq*m4sq*m5**4*B0del(0,0,m5sq,mudim) - 2*m1**8*B0fin(0,0,m1sq,mudim) - 9*m1**4*m4**4*B0fin(0,0,m1sq,mudim) + 5*m1sq*m4**6*B0fin(0,0,m1sq,mudim) - m4**8*B0fin(0,0,m1sq,mudim) + 7*m1**6*m4sq*B0fin(0,0,m1sq,mudim) - 9*m1**4*m5**4*B0fin(0,0,m1sq,mudim) - 6*m4**4*m5**4*B0fin(0,0,m1sq,mudim) - 5*m1sq*m4sq*m5**4*B0fin(0,0,m1sq,mudim) + 5*m1sq*m5**6*B0fin(0,0,m1sq,mudim) + 4*m4sq*m5**6*B0fin(0,0,m1sq,mudim) - m5**8*B0fin(0,0,m1sq,mudim) + 7*m1**6*m5sq*B0fin(0,0,m1sq,mudim) - 5*m1sq*m4**4*m5sq*B0fin(0,0,m1sq,mudim) + 4*m4**6*m5sq*B0fin(0,0,m1sq,mudim) - 2*m1**4*m4sq*m5sq*B0fin(0,0,m1sq,mudim) - 3*m1**4*m4**4*B0fin(0,0,m4sq,mudim) + 3*m1sq*m4**6*B0fin(0,0,m4sq,mudim) - m4**8*B0fin(0,0,m4sq,mudim) + m1**6*m4sq*B0fin(0,0,m4sq,mudim) - 3*m4**4*m5**4*B0fin(0,0,m4sq,mudim) - m1sq*m4sq*m5**4*B0fin(0,0,m4sq,mudim) + m4sq*m5**6*B0fin(0,0,m4sq,mudim) + 2*m1sq*m4**4*m5sq*B0fin(0,0,m4sq,mudim) + 3*m4**6*m5sq*B0fin(0,0,m4sq,mudim) - m1**4*m4sq*m5sq*B0fin(0,0,m4sq,mudim) - 2*m1sq*m4sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1sq*m4**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**4*m4sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 3*m1**4*m5**4*B0fin(0,0,m5sq,mudim) - 3*m4**4*m5**4*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4sq*m5**4*B0fin(0,0,m5sq,mudim) + 3*m1sq*m5**6*B0fin(0,0,m5sq,mudim) + 3*m4sq*m5**6*B0fin(0,0,m5sq,mudim) - m5**8*B0fin(0,0,m5sq,mudim) + m1**6*m5sq*B0fin(0,0,m5sq,mudim) - m1sq*m4**4*m5sq*B0fin(0,0,m5sq,mudim) + m4**6*m5sq*B0fin(0,0,m5sq,mudim) - m1**4*m4sq*m5sq*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m4**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m4sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4sq*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4**4*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 4*m1sq*m4sq*m5sq*T134fin(m5,m4,m1,mudim))/(2.*m1**2*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2)
		def eval_13():
			return (m1sq*m2**4 - m2**6 - m1sq*m4**4 + m2sq*m4**4 - m1sq*m5**4 + m2sq*m5**4 - 2*m1sq*m4sq*m5sq + 2*m2sq*m4sq*m5sq + (m1sq - m2sq)*(-(m4sq - m5sq)**2 + m2sq*(m4sq + m5sq))*B0del(0,0,m2sq,mudim) + (m1sq - m2sq)*m4sq*(m2sq - m4sq - m5sq)*B0del(0,0,m4sq,mudim) - m1sq*m5**4*B0del(0,0,m5sq,mudim) + m2sq*m5**4*B0del(0,0,m5sq,mudim) - m2**4*m5sq*B0del(0,0,m5sq,mudim) + m1sq*m2sq*m5sq*B0del(0,0,m5sq,mudim) - m1sq*m4sq*m5sq*B0del(0,0,m5sq,mudim) + m2sq*m4sq*m5sq*B0del(0,0,m5sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) - 2*m2**6*B0fin(0,0,m2sq,mudim) + m1sq*m4**4*B0fin(0,0,m2sq,mudim) - m2sq*m4**4*B0fin(0,0,m2sq,mudim) + 3*m2**4*m4sq*B0fin(0,0,m2sq,mudim) - 3*m1sq*m2sq*m4sq*B0fin(0,0,m2sq,mudim) + m1sq*m5**4*B0fin(0,0,m2sq,mudim) - m2sq*m5**4*B0fin(0,0,m2sq,mudim) + 3*m2**4*m5sq*B0fin(0,0,m2sq,mudim) - 3*m1sq*m2sq*m5sq*B0fin(0,0,m2sq,mudim) - 2*m1sq*m4sq*m5sq*B0fin(0,0,m2sq,mudim) + 2*m2sq*m4sq*m5sq*B0fin(0,0,m2sq,mudim) - m1sq*m4**4*B0fin(0,0,m4sq,mudim) + m2sq*m4**4*B0fin(0,0,m4sq,mudim) - m2**4*m4sq*B0fin(0,0,m4sq,mudim) + m1sq*m2sq*m4sq*B0fin(0,0,m4sq,mudim) - m1sq*m4sq*m5sq*B0fin(0,0,m4sq,mudim) + m2sq*m4sq*m5sq*B0fin(0,0,m4sq,mudim) - m1sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - m2**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - m2sq*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - m1sq*m5**4*B0fin(0,0,m5sq,mudim) + m2sq*m5**4*B0fin(0,0,m5sq,mudim) - m2**4*m5sq*B0fin(0,0,m5sq,mudim) + m1sq*m2sq*m5sq*B0fin(0,0,m5sq,mudim) - m1sq*m4sq*m5sq*B0fin(0,0,m5sq,mudim) + m2sq*m4sq*m5sq*B0fin(0,0,m5sq,mudim) - m1sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + m2sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + m1sq*m2sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + m1sq*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - m2sq*m4sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2sq*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + m2**4*T134fin(m5,m4,m1,mudim) + m4**4*T134fin(m5,m4,m1,mudim) - 2*m2sq*m4sq*T134fin(m5,m4,m1,mudim) + m5**4*T134fin(m5,m4,m1,mudim) - 2*m2sq*m5sq*T134fin(m5,m4,m1,mudim) - 2*m4sq*m5sq*T134fin(m5,m4,m1,mudim) - m1sq*m2sq*T134fin(m5,m4,m2,mudim) - m4**4*T134fin(m5,m4,m2,mudim) + m1sq*m4sq*T134fin(m5,m4,m2,mudim) + m2sq*m4sq*T134fin(m5,m4,m2,mudim) - m5**4*T134fin(m5,m4,m2,mudim) + m1sq*m5sq*T134fin(m5,m4,m2,mudim) + m2sq*m5sq*T134fin(m5,m4,m2,mudim) + 2*m4sq*m5sq*T134fin(m5,m4,m2,mudim))/((m1sq - m2sq)**2*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq)))
		def eval_14():
			return (-m1**6 + m1**4*m3sq + m1sq*m4**4 - m3sq*m4**4 + m1sq*m5**4 - m3sq*m5**4 + 2*m1sq*m4sq*m5sq - 2*m3sq*m4sq*m5sq - (m1sq - m3sq)*(-(m4sq - m5sq)**2 + m1sq*(m4sq + m5sq))*B0del(0,0,m1sq,mudim) - (m1sq - m3sq)*m4sq*(m1sq - m4sq - m5sq)*B0del(0,0,m4sq,mudim) + m1sq*m5**4*B0del(0,0,m5sq,mudim) - m3sq*m5**4*B0del(0,0,m5sq,mudim) - m1**4*m5sq*B0del(0,0,m5sq,mudim) + m1sq*m3sq*m5sq*B0del(0,0,m5sq,mudim) + m1sq*m4sq*m5sq*B0del(0,0,m5sq,mudim) - m3sq*m4sq*m5sq*B0del(0,0,m5sq,mudim) - 2*m1**6*B0fin(0,0,m1sq,mudim) + 2*m1**4*m3sq*B0fin(0,0,m1sq,mudim) - m1sq*m4**4*B0fin(0,0,m1sq,mudim) + m3sq*m4**4*B0fin(0,0,m1sq,mudim) + 3*m1**4*m4sq*B0fin(0,0,m1sq,mudim) - 3*m1sq*m3sq*m4sq*B0fin(0,0,m1sq,mudim) - m1sq*m5**4*B0fin(0,0,m1sq,mudim) + m3sq*m5**4*B0fin(0,0,m1sq,mudim) + 3*m1**4*m5sq*B0fin(0,0,m1sq,mudim) - 3*m1sq*m3sq*m5sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m4sq*m5sq*B0fin(0,0,m1sq,mudim) - 2*m3sq*m4sq*m5sq*B0fin(0,0,m1sq,mudim) + m1sq*m4**4*B0fin(0,0,m4sq,mudim) - m3sq*m4**4*B0fin(0,0,m4sq,mudim) - m1**4*m4sq*B0fin(0,0,m4sq,mudim) + m1sq*m3sq*m4sq*B0fin(0,0,m4sq,mudim) + m1sq*m4sq*m5sq*B0fin(0,0,m4sq,mudim) - m3sq*m4sq*m5sq*B0fin(0,0,m4sq,mudim) + m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m3sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*m3sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m1sq*m4sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m3sq*m4sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*m5**4*B0fin(0,0,m5sq,mudim) - m3sq*m5**4*B0fin(0,0,m5sq,mudim) - m1**4*m5sq*B0fin(0,0,m5sq,mudim) + m1sq*m3sq*m5sq*B0fin(0,0,m5sq,mudim) + m1sq*m4sq*m5sq*B0fin(0,0,m5sq,mudim) - m3sq*m4sq*m5sq*B0fin(0,0,m5sq,mudim) + m1sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m3sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m1sq*m3sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1sq*m4sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m3sq*m4sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m3sq*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - m1sq*m3sq*T134fin(m5,m4,m1,mudim) - m4**4*T134fin(m5,m4,m1,mudim) + m1sq*m4sq*T134fin(m5,m4,m1,mudim) + m3sq*m4sq*T134fin(m5,m4,m1,mudim) - m5**4*T134fin(m5,m4,m1,mudim) + m1sq*m5sq*T134fin(m5,m4,m1,mudim) + m3sq*m5sq*T134fin(m5,m4,m1,mudim) + 2*m4sq*m5sq*T134fin(m5,m4,m1,mudim) + m1**4*T134fin(m5,m4,m3,mudim) + m4**4*T134fin(m5,m4,m3,mudim) - 2*m1sq*m4sq*T134fin(m5,m4,m3,mudim) + m5**4*T134fin(m5,m4,m3,mudim) - 2*m1sq*m5sq*T134fin(m5,m4,m3,mudim) - 2*m4sq*m5sq*T134fin(m5,m4,m3,mudim))/((m1sq - m3sq)**2*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq)))
		def eval_15():
			return ((m2sq - m3sq)*T134fin(m5,m4,m1,mudim) + (-m1sq + m3sq)*T134fin(m5,m4,m2,mudim) + (m1sq - m2sq)*T134fin(m5,m4,m3,mudim))/((m1sq - m2sq)*(m1sq - m3sq)*(m2sq - m3sq))

		cond_m1_0 = cond(m1, 0)
		cond_m2_0 = cond(m2, 0)
		cond_m3_0 = cond(m3, 0)
		cond_m4_0 = cond(m4, 0)
		cond_m5_0 = cond(m5, 0)
		cond_m5_m4 = cond(m5, m4)
		cond_m5_m3 = cond(m5, m3)
		cond_m4_m3 = cond(m4, m3)
		cond_m5_m2 = cond(m5, m2)
		cond_m4_m2 = cond(m4, m2)
		cond_m3_m2 = cond(m3, m2)
		cond_m5_m1 = cond(m5, m1)
		cond_m4_m1 = cond(m4, m1)
		cond_m3_m1 = cond(m3, m1)
		cond_m2_m1 = cond(m2, m1)

		conditions = [
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_1()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_2()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_2()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_14()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_14()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_14()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0, lambda: eval_14()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0, lambda: eval_14()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_14()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_14()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_15()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_5()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_5()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_8()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_9()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_5()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_8()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_9()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_8()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_9()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_12()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4, lambda: eval_5()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4, lambda: eval_5()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0, lambda: eval_15()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3, lambda: eval_14()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2, lambda: eval_14()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0, lambda: eval_13()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0, lambda: eval_13()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_5()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_15()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_15()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_15()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_15()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_13()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1, lambda: eval_14()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1, lambda: eval_14()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0, lambda: eval_13()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0, lambda: eval_13()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0, lambda: eval_13()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0, lambda: eval_14()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_15()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_15()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_14()),
			(cond_m1_0 and cond_m2_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0, lambda: eval_14()),
			(cond_m1_0 and cond_m4_0, lambda: eval_15()),
			(cond_m1_0 and cond_m5_0, lambda: eval_15()),
			(cond_m2_0 and cond_m3_0, lambda: eval_14()),
			(cond_m2_0 and cond_m4_0, lambda: eval_15()),
			(cond_m2_0 and cond_m5_0, lambda: eval_15()),
			(cond_m3_0 and cond_m4_0, lambda: eval_15()),
			(cond_m3_0 and cond_m5_0, lambda: eval_15()),
			(cond_m4_0 and cond_m5_0, lambda: eval_15()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_13()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_6()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_7()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4, lambda: eval_13()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2, lambda: eval_13()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2, lambda: eval_13()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_15()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_15()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_15()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_8()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_9()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4, lambda: eval_13()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3, lambda: eval_15()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4, lambda: eval_13()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3, lambda: eval_14()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0, lambda: eval_14()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2, lambda: eval_15()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1, lambda: eval_15()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2, lambda: eval_14()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0, lambda: eval_14()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1, lambda: eval_13()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0, lambda: eval_13()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1, lambda: eval_13()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1, lambda: eval_13()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0, lambda: eval_12()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_10()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_11()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_15()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_10()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_11()),
			(cond_m1_0 and cond_m5_m4, lambda: eval_15()),
			(cond_m1_0 and cond_m4_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m5_m3, lambda: eval_15()),
			(cond_m1_0 and cond_m3_m2, lambda: eval_13()),
			(cond_m1_0 and cond_m4_m2, lambda: eval_15()),
			(cond_m1_0 and cond_m5_m2, lambda: eval_15()),
			(cond_m2_0 and cond_m5_m4, lambda: eval_15()),
			(cond_m2_0 and cond_m4_m3, lambda: eval_15()),
			(cond_m2_0 and cond_m5_m3, lambda: eval_15()),
			(cond_m3_0 and cond_m5_m4, lambda: eval_15()),
			(cond_m4_0 and cond_m5_m3, lambda: eval_15()),
			(cond_m4_m3 and cond_m5_0, lambda: eval_15()),
			(cond_m3_0 and cond_m4_m2, lambda: eval_15()),
			(cond_m3_0 and cond_m5_m2, lambda: eval_15()),
			(cond_m3_m2 and cond_m4_0, lambda: eval_13()),
			(cond_m3_m2 and cond_m5_0, lambda: eval_13()),
			(cond_m4_0 and cond_m5_m2, lambda: eval_15()),
			(cond_m4_m2 and cond_m5_0, lambda: eval_15()),
			(cond_m2_0 and cond_m3_m1, lambda: eval_13()),
			(cond_m2_0 and cond_m4_m1, lambda: eval_15()),
			(cond_m2_0 and cond_m5_m1, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0, lambda: eval_13()),
			(cond_m2_m1 and cond_m4_0, lambda: eval_14()),
			(cond_m3_0 and cond_m4_m1, lambda: eval_15()),
			(cond_m3_0 and cond_m5_m1, lambda: eval_15()),
			(cond_m3_m1 and cond_m4_0, lambda: eval_14()),
			(cond_m2_m1 and cond_m5_0, lambda: eval_14()),
			(cond_m3_m1 and cond_m5_0, lambda: eval_14()),
			(cond_m4_0 and cond_m5_m1, lambda: eval_15()),
			(cond_m4_m1 and cond_m5_0, lambda: eval_15()),
			(cond_m1_0, lambda: eval_15()),
			(cond_m2_0, lambda: eval_15()),
			(cond_m3_0, lambda: eval_15()),
			(cond_m4_0, lambda: eval_15()),
			(cond_m5_0, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_12()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_13()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3, lambda: eval_14()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2, lambda: eval_14()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2, lambda: eval_13()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4, lambda: eval_12()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3, lambda: eval_14()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1, lambda: eval_14()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2, lambda: eval_14()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1, lambda: eval_14()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1, lambda: eval_13()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1, lambda: eval_12()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1, lambda: eval_12()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_14()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_14()),
			(cond_m4_m3 and cond_m5_m3, lambda: eval_15()),
			(cond_m3_m2 and cond_m5_m4, lambda: eval_13()),
			(cond_m4_m2 and cond_m5_m3, lambda: eval_15()),
			(cond_m4_m3 and cond_m5_m2, lambda: eval_15()),
			(cond_m3_m2 and cond_m4_m2, lambda: eval_13()),
			(cond_m3_m2 and cond_m5_m2, lambda: eval_13()),
			(cond_m4_m2 and cond_m5_m2, lambda: eval_15()),
			(cond_m2_m1 and cond_m5_m4, lambda: eval_14()),
			(cond_m3_m1 and cond_m5_m4, lambda: eval_14()),
			(cond_m4_m1 and cond_m5_m3, lambda: eval_15()),
			(cond_m4_m3 and cond_m5_m1, lambda: eval_15()),
			(cond_m2_m1 and cond_m4_m3, lambda: eval_14()),
			(cond_m2_m1 and cond_m5_m3, lambda: eval_14()),
			(cond_m3_m1 and cond_m4_m2, lambda: eval_14()),
			(cond_m3_m1 and cond_m5_m2, lambda: eval_14()),
			(cond_m3_m2 and cond_m4_m1, lambda: eval_13()),
			(cond_m3_m2 and cond_m5_m1, lambda: eval_13()),
			(cond_m4_m1 and cond_m5_m2, lambda: eval_15()),
			(cond_m4_m2 and cond_m5_m1, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_m1, lambda: eval_12()),
			(cond_m2_m1 and cond_m4_m1, lambda: eval_14()),
			(cond_m2_m1 and cond_m5_m1, lambda: eval_14()),
			(cond_m3_m1 and cond_m4_m1, lambda: eval_14()),
			(cond_m3_m1 and cond_m5_m1, lambda: eval_14()),
			(cond_m4_m1 and cond_m5_m1, lambda: eval_15()),
			(cond_m5_m4, lambda: eval_15()),
			(cond_m4_m3, lambda: eval_15()),
			(cond_m5_m3, lambda: eval_15()),
			(cond_m3_m2, lambda: eval_13()),
			(cond_m4_m2, lambda: eval_15()),
			(cond_m5_m2, lambda: eval_15()),
			(cond_m2_m1, lambda: eval_14()),
			(cond_m3_m1, lambda: eval_14()),
			(cond_m4_m1, lambda: eval_15()),
			(cond_m5_m1, lambda: eval_15()),
			(True, lambda: eval_15())
		]

		for condition,action in conditions:
			if condition:
				res = action()
				return res * mass_scale**(-2.)

	except Exception as e:
		raise Exception(f"There was an error when evaluating the T11134 integral with masses {m1}, {m2}, {m3}, {m4}, {m5} from {e}")