# This file is automatically generated. Do not modify it manually!
from functools import lru_cache

from .config import cond, Number, getMudim, getDiffeps
from .OneLoop import B0fin, B0del
from .T134 import T134fin


@lru_cache(maxsize=150)
def T113(m1: Number, m2: Number, m3, mudim = None) -> Number:
	""" Computes the UV-finite part of the T113 integral.

	Args:
		m1: internal mass
		m2: internal mass
		m3: internal mass
		mudim: squared renormalization scale (if `None`, the global value is used)

	Returns:
		finite part of the T113 integral.
	"""

	try:

		if mudim is None:
			mudim = getMudim()

		# rescale masses for better numerical stability
		mass_scale = max([m1, m2, m3])
		if mass_scale <= getDiffeps():
			return 0
		m1 /= mass_scale
		m2 /= mass_scale
		m3 /= mass_scale
		mudim /= mass_scale**2
		m1, m2 = sorted([m1, m2])
		
		

		m1sq = m1**2
		m2sq = m2**2
		m3sq = m3**2

		def eval_1():
			return m3sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m3sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m3sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))
		def eval_2():
			return (m3sq*(m1sq*B0del(0,0,m1sq,mudim) - m2sq*B0del(0,0,m2sq,mudim) + m1sq*B0del(0,0,m3sq,mudim) - m2sq*B0del(0,0,m3sq,mudim) + m1sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m2sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim)))/(m1sq - m2sq)

		cond_m1_0 = cond(m1, 0)
		cond_m2_0 = cond(m2, 0)
		cond_m3_0 = cond(m3, 0)
		cond_m3_m2 = cond(m3, m2)
		cond_m3_m1 = cond(m3, m1)
		cond_m2_m1 = cond(m2, m1)

		conditions = [
			(cond_m1_0 and cond_m2_0 and cond_m3_0, lambda: eval_1()),
			(cond_m1_0 and cond_m2_0, lambda: eval_1()),
			(cond_m1_0 and cond_m3_0, lambda: eval_2()),
			(cond_m2_0 and cond_m3_0, lambda: eval_2()),
			(cond_m1_0 and cond_m3_m2, lambda: eval_2()),
			(cond_m2_0 and cond_m3_m1, lambda: eval_2()),
			(cond_m2_m1 and cond_m3_0, lambda: eval_1()),
			(cond_m1_0, lambda: eval_2()),
			(cond_m2_0, lambda: eval_2()),
			(cond_m3_0, lambda: eval_2()),
			(cond_m2_m1 and cond_m3_m1, lambda: eval_1()),
			(cond_m3_m2, lambda: eval_2()),
			(cond_m2_m1, lambda: eval_1()),
			(cond_m3_m1, lambda: eval_2()),
			(True, lambda: eval_2())
		]

		for condition,action in conditions:
			if condition:
				res = action()
				return res * mass_scale**(2.)

	except Exception as e:
		raise Exception(f"There was an error when evaluating the T113 integral with masses {m1}, {m2}, {m3} from {e}")