# This file is automatically generated. Do not modify it manually!
from functools import lru_cache

from .config import cond, Number, getMudim, getDiffeps
from .OneLoop import B0fin, B0del
from .T134 import T134fin


@lru_cache(maxsize=150)
def T113344(m1: Number, m2: Number, m3: Number, m4: Number, m5: Number, m6, mudim = None) -> Number:
	""" Computes the UV-finite part of the T113344 integral.

	Args:
		m1: internal mass
		m2: internal mass
		m3: internal mass
		m4: internal mass
		m5: internal mass
		m6: internal mass
		mudim: squared renormalization scale (if `None`, the global value is used)

	Returns:
		finite part of the T113344 integral.
	"""

	try:

		if mudim is None:
			mudim = getMudim()

		# rescale masses for better numerical stability
		mass_scale = max([m1, m2, m3, m4, m5, m6])
		if mass_scale <= getDiffeps():
			return 0
		m1 /= mass_scale
		m2 /= mass_scale
		m3 /= mass_scale
		m4 /= mass_scale
		m5 /= mass_scale
		m6 /= mass_scale
		mudim /= mass_scale**2
		m1, m2 = sorted([m1, m2])
		m3, m4 = sorted([m3, m4])
		m5, m6 = sorted([m5, m6])

		m1sq = m1**2
		m2sq = m2**2
		m3sq = m3**2
		m4sq = m4**2
		m5sq = m5**2
		m6sq = m6**2

		def eval_1():
			return 0
		def eval_2():
			return (3*m6sq + 2*m6sq*B0fin(0,0,m6sq,mudim) - 2*T134fin(m6,0,0,mudim))/m6**6
		def eval_3():
			return (3*m4sq + 2*m4sq*B0fin(0,0,m4sq,mudim) - 2*T134fin(m4,0,0,mudim))/m4**6
		def eval_4():
			return (3*m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - 2*T134fin(m2,0,0,mudim))/m2**6
		def eval_5():
			return -0.5*(10*m4sq + 2*m4sq*B0del(0,0,m4sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + m4sq*B0fin(0,0,m4sq,mudim)**2 - 4*T134fin(m4,0,0,mudim))/m4**6
		def eval_6():
			return -0.5*(10*m2sq + 2*m2sq*B0del(0,0,m2sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)**2 - 4*T134fin(m2,0,0,mudim))/m2**6
		def eval_7():
			return -0.5*(10*m2sq + 2*m2sq*B0del(0,0,m2sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) + m2sq*B0fin(0,0,m2sq,mudim)**2 - 4*T134fin(m2,0,0,mudim))/m2**6
		def eval_8():
			return (3*m5sq*m6**4 - 3*m5**4*m6sq + 2*m5sq*m6**4*B0fin(0,0,m5sq,mudim) - 2*m5**4*m6sq*B0fin(0,0,m6sq,mudim) - 2*m6**4*T134fin(m5,0,0,mudim) + 2*m5**4*T134fin(m6,0,0,mudim))/(m5**4*m6**4*(m5sq - m6sq))
		def eval_9():
			return (6*m4**4*m6**4 - m4sq*m6**6 - m4**6*m6sq + 2*m4**4*m6**4*B0del(0,0,m4sq,mudim) + 2*m4**4*m6**4*B0del(0,0,m6sq,mudim) + 4*m4**4*m6**4*B0fin(0,0,m4sq,mudim) - 2*m4sq*m6**6*B0fin(0,0,m4sq,mudim) + 4*m4**4*m6**4*B0fin(0,0,m6sq,mudim) - 2*m4**6*m6sq*B0fin(0,0,m6sq,mudim) + 2*m4**4*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m4sq*m6**4*T134fin(m4,0,0,mudim) + m6**6*T134fin(m4,0,0,mudim) + m4**4*m6sq*T134fin(m4,0,0,mudim) + m4**6*T134fin(m6,0,0,mudim) + m4sq*m6**4*T134fin(m6,0,0,mudim) - 2*m4**4*m6sq*T134fin(m6,0,0,mudim) - m4sq*m6**4*T134fin(m6,m4,0,mudim) - m4**4*m6sq*T134fin(m6,m4,0,mudim))/(m4**4*m6**4*(m4sq - m6sq)**2)
		def eval_10():
			return (3*m3sq*m4**4 - 3*m3**4*m4sq + 2*m3sq*m4**4*B0fin(0,0,m3sq,mudim) - 2*m3**4*m4sq*B0fin(0,0,m4sq,mudim) - 2*m4**4*T134fin(m3,0,0,mudim) + 2*m3**4*T134fin(m4,0,0,mudim))/(m3**4*m4**4*(m3sq - m4sq))
		def eval_11():
			return (6*m2**4*m6**4 - m2sq*m6**6 - m2**6*m6sq + 2*m2**4*m6**4*B0del(0,0,m2sq,mudim) + 2*m2**4*m6**4*B0del(0,0,m6sq,mudim) + 4*m2**4*m6**4*B0fin(0,0,m2sq,mudim) - 2*m2sq*m6**6*B0fin(0,0,m2sq,mudim) + 4*m2**4*m6**4*B0fin(0,0,m6sq,mudim) - 2*m2**6*m6sq*B0fin(0,0,m6sq,mudim) + 2*m2**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m2sq*m6**4*T134fin(m2,0,0,mudim) + m6**6*T134fin(m2,0,0,mudim) + m2**4*m6sq*T134fin(m2,0,0,mudim) + m2**6*T134fin(m6,0,0,mudim) + m2sq*m6**4*T134fin(m6,0,0,mudim) - 2*m2**4*m6sq*T134fin(m6,0,0,mudim) - m2sq*m6**4*T134fin(m6,m2,0,mudim) - m2**4*m6sq*T134fin(m6,m2,0,mudim))/(m2**4*m6**4*(m2sq - m6sq)**2)
		def eval_12():
			return (6*m2**4*m4**4 - m2sq*m4**6 - m2**6*m4sq + 2*m2**4*m4**4*B0del(0,0,m2sq,mudim) + 2*m2**4*m4**4*B0del(0,0,m4sq,mudim) + 4*m2**4*m4**4*B0fin(0,0,m2sq,mudim) - 2*m2sq*m4**6*B0fin(0,0,m2sq,mudim) + 4*m2**4*m4**4*B0fin(0,0,m4sq,mudim) - 2*m2**6*m4sq*B0fin(0,0,m4sq,mudim) + 2*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2sq*m4**4*T134fin(m2,0,0,mudim) + m4**6*T134fin(m2,0,0,mudim) + m2**4*m4sq*T134fin(m2,0,0,mudim) + m2**6*T134fin(m4,0,0,mudim) + m2sq*m4**4*T134fin(m4,0,0,mudim) - 2*m2**4*m4sq*T134fin(m4,0,0,mudim) - m2sq*m4**4*T134fin(m4,m2,0,mudim) - m2**4*m4sq*T134fin(m4,m2,0,mudim))/(m2**4*m4**4*(m2sq - m4sq)**2)
		def eval_13():
			return (3*m1sq*m2**4 - 3*m1**4*m2sq + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) - 2*m2**4*T134fin(m1,0,0,mudim) + 2*m1**4*T134fin(m2,0,0,mudim))/(m1**4*m2**4*(m1sq - m2sq))
		def eval_14():
			return -0.5*(1 + 2*B0fin(0,0,m3sq,mudim))/m3**4
		def eval_15():
			return -0.5*(1 + 2*B0fin(0,0,m1sq,mudim))/m1**4
		def eval_16():
			return -0.5*(1 + 2*B0fin(0,0,m1sq,mudim))/m1**4
		def eval_17():
			return (4*m3**4*m4**4*(B0del(0,0,m3sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m3sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim)) + m3sq*(m3sq - m4sq)**2*m4sq*(6 + 2*B0del(0,0,m4sq,mudim) - 6*B0fin(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2) - 2*(-(m3sq*m4) + m4**3)**2*(m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim)) + 2*(m3**3 - m3*m4sq)**2*(m4sq + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,0,0,mudim)) + 2*m3sq*m4sq*(m3sq + m4sq)*(m3sq + m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m3,0,mudim)))/(2.*m3**2*m4**4*(m3sq - m4sq)**3)
		def eval_18():
			return -0.5*(((m3sq - m4sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2))/m3**2 + 4*m4sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m3sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim)) + (2*(m3sq - m4sq)**2*(m3sq + 2*m3sq*B0fin(0,0,m3sq,mudim) - T134fin(m3,0,0,mudim)))/m3**4 - (2*(m3sq - m4sq)**2*(m4sq + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,0,0,mudim)))/(m3**2*m4**2) + (2*(m3sq + m4sq)*(m3sq + m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m3,0,mudim)))/m3**2)/(m3sq - m4sq)**3
		def eval_19():
			return (4*m1**4*m2**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + m1sq*(m1sq - m2sq)**2*m2sq*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) - 2*(-(m1sq*m2) + m2**3)**2*(m1sq + 2*m1sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)) + 2*(m1**3 - m1*m2sq)**2*(m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim)) + 2*m1sq*m2sq*(m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(2.*m1**2*m2**4*(m1sq - m2sq)**3)
		def eval_20():
			return (4*m1**4*m2**4*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + m1sq*(m1sq - m2sq)**2*m2sq*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) - 2*(-(m1sq*m2) + m2**3)**2*(m1sq + 2*m1sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)) + 2*(m1**3 - m1*m2sq)**2*(m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim)) + 2*m1sq*m2sq*(m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(2.*m1**2*m2**4*(m1sq - m2sq)**3)
		def eval_21():
			return -0.5*(((m1sq - m2sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/m1**2 + 4*m2sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + (2*(m1sq - m2sq)**2*(m1sq + 2*m1sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)))/m1**4 - (2*(m1sq - m2sq)**2*(m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim)))/(m1**2*m2**2) + (2*(m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/m1**2)/(m1sq - m2sq)**3
		def eval_22():
			return -0.5*(((m1sq - m2sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2))/m1**2 + 4*m2sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + (2*(m1sq - m2sq)**2*(m1sq + 2*m1sq*B0fin(0,0,m1sq,mudim) - T134fin(m1,0,0,mudim)))/m1**4 - (2*(m1sq - m2sq)**2*(m2sq + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,0,0,mudim)))/(m1**2*m2**2) + (2*(m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/m1**2)/(m1sq - m2sq)**3
		def eval_23():
			return (1 - 3*B0fin(0,0,m3sq,mudim))/(9.*m3**4)
		def eval_24():
			return (-6*m2sq - 6*m2sq*B0del(0,0,m2sq,mudim) - 6*m2sq*B0fin(0,0,m2sq,mudim) - 3*m2sq*B0fin(0,0,m2sq,mudim)**2 + 3*T134fin(m2,0,0,mudim) + T134fin(m2,m2,m2,mudim))/(3.*m2**6)
		def eval_25():
			return (-6*m2sq - 6*m2sq*B0del(0,0,m2sq,mudim) - 6*m2sq*B0fin(0,0,m2sq,mudim) - 3*m2sq*B0fin(0,0,m2sq,mudim)**2 + 3*T134fin(m2,0,0,mudim) + T134fin(m2,m2,m2,mudim))/(3.*m2**6)
		def eval_26():
			return (1 - 3*B0fin(0,0,m1sq,mudim))/(9.*m1**4)
		def eval_27():
			return (-6*m1sq - 6*m1sq*B0del(0,0,m1sq,mudim) - 6*m1sq*B0fin(0,0,m1sq,mudim) - 3*m1sq*B0fin(0,0,m1sq,mudim)**2 + 3*T134fin(m1,0,0,mudim) + T134fin(m1,m1,m1,mudim))/(3.*m1**6)
		def eval_28():
			return (1 - 3*B0fin(0,0,m1sq,mudim))/(9.*m1**4)
		def eval_29():
			return (3*m3**6 + 9*m3sq*m4**4 - m4**6 - 3*m3**4*m4sq + 2*m3sq*m4sq*(m3sq + m4sq)*B0del(0,0,m3sq,mudim) + 2*m3sq*m4sq*(m3sq + m4sq)*B0del(0,0,m4sq,mudim) + 2*m3sq*m4**4*B0fin(0,0,m3sq,mudim) + 2*m3**4*m4sq*B0fin(0,0,m3sq,mudim) - 2*m3**6*B0fin(0,0,m4sq,mudim) + 4*m3sq*m4**4*B0fin(0,0,m4sq,mudim) - 2*m4**6*B0fin(0,0,m4sq,mudim) + 4*m3**4*m4sq*B0fin(0,0,m4sq,mudim) + 2*m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m3**4*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m3sq*m4sq*T134fin(m4,m3,0,mudim))/(2.*m4**2*(m3sq - m4sq)**4)
		def eval_30():
			return -((2*m3**4 + 2*m5**4 + 4*m3sq*m5sq + (m3sq + m5sq)**2*B0del(0,0,m3sq,mudim) + (m3sq + m5sq)**2*B0del(0,0,m5sq,mudim) - 2*m3**4*B0fin(0,0,m3sq,mudim) + 6*m3sq*m5sq*B0fin(0,0,m3sq,mudim) - 2*m5**4*B0fin(0,0,m5sq,mudim) + 6*m3sq*m5sq*B0fin(0,0,m5sq,mudim) + m3**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m3sq*T134fin(m5,m3,0,mudim) - 2*m5sq*T134fin(m5,m3,0,mudim))/(m3sq - m5sq)**4)
		def eval_31():
			return -0.5*((m3sq - m4sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) + 8*m3sq*m4sq*(B0del(0,0,m3sq,mudim) + B0del(0,0,m4sq,mudim) - B0fin(0,0,m3sq,mudim) - B0fin(0,0,m4sq,mudim) + B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim)) + (m3sq - m4sq)**2*(6 + 2*B0del(0,0,m4sq,mudim) - 6*B0fin(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2) + 4*(m3sq + m4sq)*(m3sq + m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m3,0,mudim)))/(m3sq - m4sq)**4
		def eval_32():
			return (-m3**6 - 3*m3sq*m6**4 + 3*m6**6 + 9*m3**4*m6sq + 2*m3sq*m6sq*(m3sq + m6sq)*B0del(0,0,m3sq,mudim) + 2*m3sq*m6sq*(m3sq + m6sq)*B0del(0,0,m6sq,mudim) - 2*m3**6*B0fin(0,0,m3sq,mudim) + 4*m3sq*m6**4*B0fin(0,0,m3sq,mudim) - 2*m6**6*B0fin(0,0,m3sq,mudim) + 4*m3**4*m6sq*B0fin(0,0,m3sq,mudim) + 2*m3sq*m6**4*B0fin(0,0,m6sq,mudim) + 2*m3**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m3sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m3**4*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m3sq*m6sq*T134fin(m6,m3,0,mudim))/(2.*m3**2*(m3sq - m6sq)**4)
		def eval_33():
			return (-m3**6 - 3*m3sq*m4**4 + 3*m4**6 + 9*m3**4*m4sq + 2*m3sq*m4sq*(m3sq + m4sq)*B0del(0,0,m3sq,mudim) + 2*m3sq*m4sq*(m3sq + m4sq)*B0del(0,0,m4sq,mudim) - 2*m3**6*B0fin(0,0,m3sq,mudim) + 4*m3sq*m4**4*B0fin(0,0,m3sq,mudim) - 2*m4**6*B0fin(0,0,m3sq,mudim) + 4*m3**4*m4sq*B0fin(0,0,m3sq,mudim) + 2*m3sq*m4**4*B0fin(0,0,m4sq,mudim) + 2*m3**4*m4sq*B0fin(0,0,m4sq,mudim) + 2*m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m3**4*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m3sq*m4sq*T134fin(m4,m3,0,mudim))/(2.*m3**2*(m3sq - m4sq)**4)
		def eval_34():
			return (18*m2sq*m3**4 - 4*m3**6 - 2*m2**4*m3sq + 6*m2sq*m3**4*B0del(0,0,m2sq,mudim) - 2*m3sq*(m2**4 + 2*m3**4 - 6*m2sq*m3sq)*B0del(0,0,m3sq,mudim) + 6*m2sq*m3**4*B0fin(0,0,m2sq,mudim) + 12*m2sq*m3**4*B0fin(0,0,m3sq,mudim) - 4*m3**6*B0fin(0,0,m3sq,mudim) - 2*m2**4*m3sq*B0fin(0,0,m3sq,mudim) + 6*m2sq*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 3*m2sq*m3**4*B0fin(0,0,m3sq,mudim)**2 - 2*m3**6*B0fin(0,0,m3sq,mudim)**2 - m2**4*m3sq*B0fin(0,0,m3sq,mudim)**2 + 2*m2**4*T134fin(m3,0,0,mudim) + 8*m3**4*T134fin(m3,0,0,mudim) - 10*m2sq*m3sq*T134fin(m3,0,0,mudim) - 8*m3**4*T134fin(m3,m2,0,mudim) + 2*m2sq*m3sq*T134fin(m3,m2,0,mudim) + 2*m3**4*T134fin(m3,m3,m2,mudim) - 2*m2sq*m3sq*T134fin(m3,m3,m2,mudim))/(2.*m2**2*m3**4*(m2**4 + 4*m3**4 - 5*m2sq*m3sq))
		def eval_35():
			return (3*m1**6 + 9*m1sq*m2**4 - m2**6 - 3*m1**4*m2sq + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1**6*B0fin(0,0,m2sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m2sq,mudim) - 2*m2**6*B0fin(0,0,m2sq,mudim) + 4*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m2**2*(m1sq - m2sq)**4)
		def eval_36():
			return (3*m1**6 + 9*m1sq*m2**4 - m2**6 - 3*m1**4*m2sq + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim) - 2*m1**6*B0fin(0,0,m2sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m2sq,mudim) - 2*m2**6*B0fin(0,0,m2sq,mudim) + 4*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m2**2*(m1sq - m2sq)**4)
		def eval_37():
			return -((2*m1**4 + 2*m5**4 + 4*m1sq*m5sq + (m1sq + m5sq)**2*B0del(0,0,m1sq,mudim) + (m1sq + m5sq)**2*B0del(0,0,m5sq,mudim) - 2*m1**4*B0fin(0,0,m1sq,mudim) + 6*m1sq*m5sq*B0fin(0,0,m1sq,mudim) - 2*m5**4*B0fin(0,0,m5sq,mudim) + 6*m1sq*m5sq*B0fin(0,0,m5sq,mudim) + m1**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*T134fin(m5,m1,0,mudim) - 2*m5sq*T134fin(m5,m1,0,mudim))/(m1sq - m5sq)**4)
		def eval_38():
			return -((2*m1**4 + 2*m3**4 + 4*m1sq*m3sq + (m1sq + m3sq)**2*B0del(0,0,m1sq,mudim) + (m1sq + m3sq)**2*B0del(0,0,m3sq,mudim) - 2*m1**4*B0fin(0,0,m1sq,mudim) + 6*m1sq*m3sq*B0fin(0,0,m1sq,mudim) - 2*m3**4*B0fin(0,0,m3sq,mudim) + 6*m1sq*m3sq*B0fin(0,0,m3sq,mudim) + m1**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1sq*T134fin(m3,m1,0,mudim) - 2*m3sq*T134fin(m3,m1,0,mudim))/(m1sq - m3sq)**4)
		def eval_39():
			return -0.5*((m1sq - m2sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) + 8*m1sq*m2sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + 4*(m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(m1sq - m2sq)**4
		def eval_40():
			return -0.5*((m1sq - m2sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) + 8*m1sq*m2sq*(B0del(0,0,m1sq,mudim) + B0del(0,0,m2sq,mudim) - B0fin(0,0,m1sq,mudim) - B0fin(0,0,m2sq,mudim) + B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim)) + (m1sq - m2sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + 4*(m1sq + m2sq)*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)))/(m1sq - m2sq)**4
		def eval_41():
			return (-m1**6 - 3*m1sq*m6**4 + 3*m6**6 + 9*m1**4*m6sq + 2*m1sq*m6sq*(m1sq + m6sq)*B0del(0,0,m1sq,mudim) + 2*m1sq*m6sq*(m1sq + m6sq)*B0del(0,0,m6sq,mudim) - 2*m1**6*B0fin(0,0,m1sq,mudim) + 4*m1sq*m6**4*B0fin(0,0,m1sq,mudim) - 2*m6**6*B0fin(0,0,m1sq,mudim) + 4*m1**4*m6sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m6**4*B0fin(0,0,m6sq,mudim) + 2*m1**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1sq*m6sq*T134fin(m6,m1,0,mudim))/(2.*m1**2*(m1sq - m6sq)**4)
		def eval_42():
			return (-4*m1**6 - 2*m1sq*m6**4 + 18*m1**4*m6sq - 2*m1sq*(2*m1**4 + m6**4 - 6*m1sq*m6sq)*B0del(0,0,m1sq,mudim) + 6*m1**4*m6sq*B0del(0,0,m6sq,mudim) - 4*m1**6*B0fin(0,0,m1sq,mudim) - 2*m1sq*m6**4*B0fin(0,0,m1sq,mudim) + 12*m1**4*m6sq*B0fin(0,0,m1sq,mudim) - 2*m1**6*B0fin(0,0,m1sq,mudim)**2 - m1sq*m6**4*B0fin(0,0,m1sq,mudim)**2 + 3*m1**4*m6sq*B0fin(0,0,m1sq,mudim)**2 + 6*m1**4*m6sq*B0fin(0,0,m6sq,mudim) + 6*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1**4*T134fin(m1,0,0,mudim) + 2*m6**4*T134fin(m1,0,0,mudim) - 10*m1sq*m6sq*T134fin(m1,0,0,mudim) - 8*m1**4*T134fin(m6,m1,0,mudim) + 2*m1sq*m6sq*T134fin(m6,m1,0,mudim) + 2*m1**4*T134fin(m6,m1,m1,mudim) - 2*m1sq*m6sq*T134fin(m6,m1,m1,mudim))/(2.*m1**4*m6**2*(4*m1**4 + m6**4 - 5*m1sq*m6sq))
		def eval_43():
			return (-4*m1**6 - 2*m1sq*m4**4 + 18*m1**4*m4sq - 2*m1sq*(2*m1**4 + m4**4 - 6*m1sq*m4sq)*B0del(0,0,m1sq,mudim) + 6*m1**4*m4sq*B0del(0,0,m4sq,mudim) - 4*m1**6*B0fin(0,0,m1sq,mudim) - 2*m1sq*m4**4*B0fin(0,0,m1sq,mudim) + 12*m1**4*m4sq*B0fin(0,0,m1sq,mudim) - 2*m1**6*B0fin(0,0,m1sq,mudim)**2 - m1sq*m4**4*B0fin(0,0,m1sq,mudim)**2 + 3*m1**4*m4sq*B0fin(0,0,m1sq,mudim)**2 + 6*m1**4*m4sq*B0fin(0,0,m4sq,mudim) + 6*m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m1**4*T134fin(m1,0,0,mudim) + 2*m4**4*T134fin(m1,0,0,mudim) - 10*m1sq*m4sq*T134fin(m1,0,0,mudim) - 8*m1**4*T134fin(m4,m1,0,mudim) + 2*m1sq*m4sq*T134fin(m4,m1,0,mudim) + 2*m1**4*T134fin(m4,m1,m1,mudim) - 2*m1sq*m4sq*T134fin(m4,m1,m1,mudim))/(2.*m1**4*m4**2*(4*m1**4 + m4**4 - 5*m1sq*m4sq))
		def eval_44():
			return (-m1**6 - 3*m1sq*m4**4 + 3*m4**6 + 9*m1**4*m4sq + 2*m1sq*m4sq*(m1sq + m4sq)*B0del(0,0,m1sq,mudim) + 2*m1sq*m4sq*(m1sq + m4sq)*B0del(0,0,m4sq,mudim) - 2*m1**6*B0fin(0,0,m1sq,mudim) + 4*m1sq*m4**4*B0fin(0,0,m1sq,mudim) - 2*m4**6*B0fin(0,0,m1sq,mudim) + 4*m1**4*m4sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m4**4*B0fin(0,0,m4sq,mudim) + 2*m1**4*m4sq*B0fin(0,0,m4sq,mudim) + 2*m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4sq*T134fin(m4,m1,0,mudim))/(2.*m1**2*(m1sq - m4sq)**4)
		def eval_45():
			return (-m1**6 - 3*m1sq*m2**4 + 3*m2**6 + 9*m1**4*m2sq + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) - 2*m1**6*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 2*m2**6*B0fin(0,0,m1sq,mudim) + 4*m1**4*m2sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m1**2*(m1sq - m2sq)**4)
		def eval_46():
			return (-m1**6 - 3*m1sq*m2**4 + 3*m2**6 + 9*m1**4*m2sq + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m1sq,mudim) + 2*m1sq*m2sq*(m1sq + m2sq)*B0del(0,0,m2sq,mudim) - 2*m1**6*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2**4*B0fin(0,0,m1sq,mudim) - 2*m2**6*B0fin(0,0,m1sq,mudim) + 4*m1**4*m2sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m2sq,mudim) + 2*m1sq*m2**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1**4*m2sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 4*m1sq*m2sq*T134fin(m2,m1,0,mudim))/(2.*m1**2*(m1sq - m2sq)**4)
		def eval_47():
			return (-3*m3**6*m4**4 + 3*m3**4*m4**6 - m3**6*m5**4 - 9*m3sq*m4**4*m5**4 + m4**6*m5**4 + 9*m3**4*m4sq*m5**4 - 3*m3sq*m5**8 + 3*m4sq*m5**8 + m3sq*(m4sq - m5sq)**3*(m3sq + m5sq)*B0del(0,0,m3sq,mudim) - m4sq*(m3sq - m5sq)**3*(m4sq + m5sq)*B0del(0,0,m4sq,mudim) - m3**6*m4**4*B0del(0,0,m5sq,mudim) + m3**4*m4**6*B0del(0,0,m5sq,mudim) - 6*m3sq*m4**4*m5**4*B0del(0,0,m5sq,mudim) + 6*m3**4*m4sq*m5**4*B0del(0,0,m5sq,mudim) - m3**4*m5**6*B0del(0,0,m5sq,mudim) + m4**4*m5**6*B0del(0,0,m5sq,mudim) - m3sq*m5**8*B0del(0,0,m5sq,mudim) + m4sq*m5**8*B0del(0,0,m5sq,mudim) + m3sq*m4**6*m5sq*B0del(0,0,m5sq,mudim) - m3**6*m4sq*m5sq*B0del(0,0,m5sq,mudim) + m3**4*m4**6*B0fin(0,0,m3sq,mudim) - 3*m3sq*m4**4*m5**4*B0fin(0,0,m3sq,mudim) + 3*m3**4*m4sq*m5**4*B0fin(0,0,m3sq,mudim) - m3**4*m5**6*B0fin(0,0,m3sq,mudim) + 3*m3sq*m4sq*m5**6*B0fin(0,0,m3sq,mudim) - m3sq*m5**8*B0fin(0,0,m3sq,mudim) - 3*m3**4*m4**4*m5sq*B0fin(0,0,m3sq,mudim) + m3sq*m4**6*m5sq*B0fin(0,0,m3sq,mudim) - m3**6*m4**4*B0fin(0,0,m4sq,mudim) - 3*m3sq*m4**4*m5**4*B0fin(0,0,m4sq,mudim) + 3*m3**4*m4sq*m5**4*B0fin(0,0,m4sq,mudim) + m4**4*m5**6*B0fin(0,0,m4sq,mudim) - 3*m3sq*m4sq*m5**6*B0fin(0,0,m4sq,mudim) + m4sq*m5**8*B0fin(0,0,m4sq,mudim) + 3*m3**4*m4**4*m5sq*B0fin(0,0,m4sq,mudim) - m3**6*m4sq*m5sq*B0fin(0,0,m4sq,mudim) + m3**6*m4**4*B0fin(0,0,m5sq,mudim) - m3**4*m4**6*B0fin(0,0,m5sq,mudim) + 2*m3**6*m5**4*B0fin(0,0,m5sq,mudim) - 12*m3sq*m4**4*m5**4*B0fin(0,0,m5sq,mudim) - 2*m4**6*m5**4*B0fin(0,0,m5sq,mudim) + 12*m3**4*m4sq*m5**4*B0fin(0,0,m5sq,mudim) - 5*m3**4*m5**6*B0fin(0,0,m5sq,mudim) + 5*m4**4*m5**6*B0fin(0,0,m5sq,mudim) + m3sq*m5**8*B0fin(0,0,m5sq,mudim) - m4sq*m5**8*B0fin(0,0,m5sq,mudim) + 5*m3sq*m4**6*m5sq*B0fin(0,0,m5sq,mudim) - 5*m3**6*m4sq*m5sq*B0fin(0,0,m5sq,mudim) + m3**4*m4**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m3sq*m4**4*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m3**4*m4sq*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m3**4*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m3sq*m4sq*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m3sq*m5**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m3**4*m4**4*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m3sq*m4**6*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m3**6*m4**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m3sq*m4**4*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m3**4*m4sq*m5**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + m4**4*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m3sq*m4sq*m5**6*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + m4sq*m5**8*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m3**4*m4**4*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - m3**6*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m3sq*m4**6*T134fin(m5,m3,0,mudim) - 6*m3sq*m4sq*m5**4*T134fin(m5,m3,0,mudim) + 2*m3sq*m5**6*T134fin(m5,m3,0,mudim) + 6*m3sq*m4**4*m5sq*T134fin(m5,m3,0,mudim) + 2*m3**6*m4sq*T134fin(m5,m4,0,mudim) + 6*m3sq*m4sq*m5**4*T134fin(m5,m4,0,mudim) - 2*m4sq*m5**6*T134fin(m5,m4,0,mudim) - 6*m3**4*m4sq*m5sq*T134fin(m5,m4,0,mudim))/((m3sq - m4sq)*(m3sq - m5sq)**3*(m4sq - m5sq)**3)
		def eval_48():
			return ((m3sq - m4sq)**2*(m4sq - m6sq)**2*(6 + 2*B0del(0,0,m4sq,mudim) - 6*B0fin(0,0,m4sq,mudim) + B0fin(0,0,m4sq,mudim)**2) + 2*(m3sq - m4sq)**2*(m4sq - m6sq)**2*(-2*(m3sq*(m4sq/(m3sq - m4sq)**2 - m6sq/(m3sq - m6sq)**2)*B0fin(0,0,m3sq,mudim) + (m4sq*m6sq*(B0fin(0,0,m4sq,mudim) + B0fin(0,0,m6sq,mudim)))/(m4sq - m6sq)**2 + m3sq*((m4sq*B0fin(0,0,m4sq,mudim))/(m3sq - m4sq)**2 - (m6sq*B0fin(0,0,m6sq,mudim))/(m3sq - m6sq)**2)) + 2*(m3sq*(m4sq/(m3sq - m4sq)**2 - m6sq/(m3sq - m6sq)**2)*B0del(0,0,m3sq,mudim) + m3sq*((m4sq*B0del(0,0,m4sq,mudim))/(m3sq - m4sq)**2 - (m6sq*B0del(0,0,m6sq,mudim))/(m3sq - m6sq)**2) + m3sq*B0fin(0,0,m3sq,mudim)*((m4sq*B0fin(0,0,m4sq,mudim))/(m3sq - m4sq)**2 - (m6sq*B0fin(0,0,m6sq,mudim))/(m3sq - m6sq)**2) + (m4sq*m6sq*(B0del(0,0,m4sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim)))/(m4sq - m6sq)**2)) + 2*(m3sq + m4sq)*(m4sq - m6sq)**2*(m3sq + m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m3,0,mudim)) - (2*(m3sq - m4sq)**2*(m4sq - m6sq)**2*(m3sq + m6sq)*(m3sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) - T134fin(m6,m3,0,mudim)))/(m3sq - m6sq)**2 + 2*(m3sq - m4sq)**2*(m4sq + m6sq)*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) - T134fin(m6,m4,0,mudim)))/(2.*(m3sq - m4sq)**3*(m4sq - m6sq)**3)
		def eval_49():
			return -((m3**4*m5**6 + 3*m3**8*m5sq + 3*m5**6*m6**4 + 9*m3**4*m5sq*m6**4 - m3**4*m6**6 - 3*m5**4*m6**6 - 3*m3**8*m6sq - 9*m3**4*m5**4*m6sq + (m5sq - m6sq)*(m3**8 + m5**4*m6**4 - 6*m3**4*m5sq*m6sq + m3**6*(m5sq + m6sq) + m3sq*m5sq*m6sq*(m5sq + m6sq))*B0del(0,0,m3sq,mudim) + m5sq*(m3sq + m5sq)*(m3sq - m6sq)**3*B0del(0,0,m5sq,mudim) - m3**6*m6**4*B0del(0,0,m6sq,mudim) - 3*m3sq*m5**4*m6**4*B0del(0,0,m6sq,mudim) + m5**6*m6**4*B0del(0,0,m6sq,mudim) + 3*m3**4*m5sq*m6**4*B0del(0,0,m6sq,mudim) - m3**8*m6sq*B0del(0,0,m6sq,mudim) - 3*m3**4*m5**4*m6sq*B0del(0,0,m6sq,mudim) + m3sq*m5**6*m6sq*B0del(0,0,m6sq,mudim) + 3*m3**6*m5sq*m6sq*B0del(0,0,m6sq,mudim) + 5*m3**6*m5**4*B0fin(0,0,m3sq,mudim) - 2*m3**4*m5**6*B0fin(0,0,m3sq,mudim) - m3**8*m5sq*B0fin(0,0,m3sq,mudim) - 5*m3**6*m6**4*B0fin(0,0,m3sq,mudim) - m5**6*m6**4*B0fin(0,0,m3sq,mudim) + 12*m3**4*m5sq*m6**4*B0fin(0,0,m3sq,mudim) + 2*m3**4*m6**6*B0fin(0,0,m3sq,mudim) + m5**4*m6**6*B0fin(0,0,m3sq,mudim) - 5*m3sq*m5sq*m6**6*B0fin(0,0,m3sq,mudim) + m3**8*m6sq*B0fin(0,0,m3sq,mudim) - 12*m3**4*m5**4*m6sq*B0fin(0,0,m3sq,mudim) + 5*m3sq*m5**6*m6sq*B0fin(0,0,m3sq,mudim) + m3**6*m5**4*B0fin(0,0,m5sq,mudim) + m3**8*m5sq*B0fin(0,0,m5sq,mudim) + 3*m3sq*m5**4*m6**4*B0fin(0,0,m5sq,mudim) + 3*m3**4*m5sq*m6**4*B0fin(0,0,m5sq,mudim) - m5**4*m6**6*B0fin(0,0,m5sq,mudim) - m3sq*m5sq*m6**6*B0fin(0,0,m5sq,mudim) - 3*m3**4*m5**4*m6sq*B0fin(0,0,m5sq,mudim) - 3*m3**6*m5sq*m6sq*B0fin(0,0,m5sq,mudim) + m3**6*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m3**8*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m3sq*m5**4*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m3**4*m5sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m5**4*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m3sq*m5sq*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m3**4*m5**4*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m3**6*m5sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m3**6*m6**4*B0fin(0,0,m6sq,mudim) - 3*m3sq*m5**4*m6**4*B0fin(0,0,m6sq,mudim) + m5**6*m6**4*B0fin(0,0,m6sq,mudim) + 3*m3**4*m5sq*m6**4*B0fin(0,0,m6sq,mudim) - m3**8*m6sq*B0fin(0,0,m6sq,mudim) - 3*m3**4*m5**4*m6sq*B0fin(0,0,m6sq,mudim) + m3sq*m5**6*m6sq*B0fin(0,0,m6sq,mudim) + 3*m3**6*m5sq*m6sq*B0fin(0,0,m6sq,mudim) - m3**6*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 3*m3sq*m5**4*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m5**6*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 3*m3**4*m5sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - m3**8*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 3*m3**4*m5**4*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m3sq*m5**6*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 3*m3**6*m5sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m3**6*m5sq*T134fin(m5,m3,0,mudim) - 6*m3sq*m5sq*m6**4*T134fin(m5,m3,0,mudim) + 2*m5sq*m6**6*T134fin(m5,m3,0,mudim) + 6*m3**4*m5sq*m6sq*T134fin(m5,m3,0,mudim) + 2*m3**6*m6sq*T134fin(m6,m3,0,mudim) + 6*m3sq*m5**4*m6sq*T134fin(m6,m3,0,mudim) - 2*m5**6*m6sq*T134fin(m6,m3,0,mudim) - 6*m3**4*m5sq*m6sq*T134fin(m6,m3,0,mudim))/((m3sq - m5sq)**3*(m3sq - m6sq)**3*(m5sq - m6sq)))
		def eval_50():
			return -0.5*((m3sq - m4sq)**2*(m3sq - m6sq)**2*(6 + 2*B0del(0,0,m3sq,mudim) - 6*B0fin(0,0,m3sq,mudim) + B0fin(0,0,m3sq,mudim)**2) - 2*(m3sq - m4sq)**2*(m3sq - m6sq)**2*(-2*(m3sq*(-(m4sq/(m3sq - m4sq)**2) - m6sq/(m3sq - m6sq)**2)*B0fin(0,0,m3sq,mudim) + (m4sq*m6sq*(B0fin(0,0,m4sq,mudim) + B0fin(0,0,m6sq,mudim)))/(m4sq - m6sq)**2 + m3sq*(-((m4sq*B0fin(0,0,m4sq,mudim))/(m3sq - m4sq)**2) - (m6sq*B0fin(0,0,m6sq,mudim))/(m3sq - m6sq)**2)) + 2*(m3sq*(-(m4sq/(m3sq - m4sq)**2) - m6sq/(m3sq - m6sq)**2)*B0del(0,0,m3sq,mudim) + m3sq*(-((m4sq*B0del(0,0,m4sq,mudim))/(m3sq - m4sq)**2) - (m6sq*B0del(0,0,m6sq,mudim))/(m3sq - m6sq)**2) + m3sq*B0fin(0,0,m3sq,mudim)*(-((m4sq*B0fin(0,0,m4sq,mudim))/(m3sq - m4sq)**2) - (m6sq*B0fin(0,0,m6sq,mudim))/(m3sq - m6sq)**2) + (m4sq*m6sq*(B0del(0,0,m4sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim)))/(m4sq - m6sq)**2)) + 2*(m3sq + m4sq)*(m3sq - m6sq)**2*(m3sq + m4sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m3,0,mudim)) + 2*(m3sq - m4sq)**2*(m3sq + m6sq)*(m3sq + m6sq + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) - T134fin(m6,m3,0,mudim)) - (2*(m3sq - m4sq)**2*(m3sq - m6sq)**2*(m4sq + m6sq)*(m4sq + m6sq + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) - T134fin(m6,m4,0,mudim)))/(m4sq - m6sq)**2)/((m3sq - m4sq)**3*(m3sq - m6sq)**3)
		def eval_51():
			return (-3*m1**6*m2**4 + 3*m1**4*m2**6 - m1**6*m5**4 - 9*m1sq*m2**4*m5**4 + m2**6*m5**4 + 9*m1**4*m2sq*m5**4 - 3*m1sq*m5**8 + 3*m2sq*m5**8 + m1sq*(m2sq - m5sq)**3*(m1sq + m5sq)*B0del(0,0,m1sq,mudim) - m2sq*(m1sq - m5sq)**3*(m2sq + m5sq)*B0del(0,0,m2sq,mudim) - m1**6*m2**4*B0del(0,0,m5sq,mudim) + m1**4*m2**6*B0del(0,0,m5sq,mudim) - 6*m1sq*m2**4*m5**4*B0del(0,0,m5sq,mudim) + 6*m1**4*m2sq*m5**4*B0del(0,0,m5sq,mudim) - m1**4*m5**6*B0del(0,0,m5sq,mudim) + m2**4*m5**6*B0del(0,0,m5sq,mudim) - m1sq*m5**8*B0del(0,0,m5sq,mudim) + m2sq*m5**8*B0del(0,0,m5sq,mudim) + m1sq*m2**6*m5sq*B0del(0,0,m5sq,mudim) - m1**6*m2sq*m5sq*B0del(0,0,m5sq,mudim) + m1**4*m2**6*B0fin(0,0,m1sq,mudim) - 3*m1sq*m2**4*m5**4*B0fin(0,0,m1sq,mudim) + 3*m1**4*m2sq*m5**4*B0fin(0,0,m1sq,mudim) - m1**4*m5**6*B0fin(0,0,m1sq,mudim) + 3*m1sq*m2sq*m5**6*B0fin(0,0,m1sq,mudim) - m1sq*m5**8*B0fin(0,0,m1sq,mudim) - 3*m1**4*m2**4*m5sq*B0fin(0,0,m1sq,mudim) + m1sq*m2**6*m5sq*B0fin(0,0,m1sq,mudim) - m1**6*m2**4*B0fin(0,0,m2sq,mudim) - 3*m1sq*m2**4*m5**4*B0fin(0,0,m2sq,mudim) + 3*m1**4*m2sq*m5**4*B0fin(0,0,m2sq,mudim) + m2**4*m5**6*B0fin(0,0,m2sq,mudim) - 3*m1sq*m2sq*m5**6*B0fin(0,0,m2sq,mudim) + m2sq*m5**8*B0fin(0,0,m2sq,mudim) + 3*m1**4*m2**4*m5sq*B0fin(0,0,m2sq,mudim) - m1**6*m2sq*m5sq*B0fin(0,0,m2sq,mudim) + m1**6*m2**4*B0fin(0,0,m5sq,mudim) - m1**4*m2**6*B0fin(0,0,m5sq,mudim) + 2*m1**6*m5**4*B0fin(0,0,m5sq,mudim) - 12*m1sq*m2**4*m5**4*B0fin(0,0,m5sq,mudim) - 2*m2**6*m5**4*B0fin(0,0,m5sq,mudim) + 12*m1**4*m2sq*m5**4*B0fin(0,0,m5sq,mudim) - 5*m1**4*m5**6*B0fin(0,0,m5sq,mudim) + 5*m2**4*m5**6*B0fin(0,0,m5sq,mudim) + m1sq*m5**8*B0fin(0,0,m5sq,mudim) - m2sq*m5**8*B0fin(0,0,m5sq,mudim) + 5*m1sq*m2**6*m5sq*B0fin(0,0,m5sq,mudim) - 5*m1**6*m2sq*m5sq*B0fin(0,0,m5sq,mudim) + m1**4*m2**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m1sq*m2**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m1**4*m2sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**4*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m1sq*m2sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1sq*m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m1**4*m2**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m1sq*m2**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**6*m2**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m1sq*m2**4*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m1**4*m2sq*m5**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + m2**4*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m1sq*m2sq*m5**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + m2sq*m5**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m1**4*m2**4*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**6*m2sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m2**6*T134fin(m5,m1,0,mudim) - 6*m1sq*m2sq*m5**4*T134fin(m5,m1,0,mudim) + 2*m1sq*m5**6*T134fin(m5,m1,0,mudim) + 6*m1sq*m2**4*m5sq*T134fin(m5,m1,0,mudim) + 2*m1**6*m2sq*T134fin(m5,m2,0,mudim) + 6*m1sq*m2sq*m5**4*T134fin(m5,m2,0,mudim) - 2*m2sq*m5**6*T134fin(m5,m2,0,mudim) - 6*m1**4*m2sq*m5sq*T134fin(m5,m2,0,mudim))/((m1sq - m2sq)*(m1sq - m5sq)**3*(m2sq - m5sq)**3)
		def eval_52():
			return (-3*m1**6*m2**4 + 3*m1**4*m2**6 - m1**6*m3**4 - 9*m1sq*m2**4*m3**4 + m2**6*m3**4 + 9*m1**4*m2sq*m3**4 - 3*m1sq*m3**8 + 3*m2sq*m3**8 + m1sq*(m2sq - m3sq)**3*(m1sq + m3sq)*B0del(0,0,m1sq,mudim) - m2sq*(m1sq - m3sq)**3*(m2sq + m3sq)*B0del(0,0,m2sq,mudim) - m1**6*m2**4*B0del(0,0,m3sq,mudim) + m1**4*m2**6*B0del(0,0,m3sq,mudim) - 6*m1sq*m2**4*m3**4*B0del(0,0,m3sq,mudim) + 6*m1**4*m2sq*m3**4*B0del(0,0,m3sq,mudim) - m1**4*m3**6*B0del(0,0,m3sq,mudim) + m2**4*m3**6*B0del(0,0,m3sq,mudim) - m1sq*m3**8*B0del(0,0,m3sq,mudim) + m2sq*m3**8*B0del(0,0,m3sq,mudim) + m1sq*m2**6*m3sq*B0del(0,0,m3sq,mudim) - m1**6*m2sq*m3sq*B0del(0,0,m3sq,mudim) + m1**4*m2**6*B0fin(0,0,m1sq,mudim) - 3*m1sq*m2**4*m3**4*B0fin(0,0,m1sq,mudim) + 3*m1**4*m2sq*m3**4*B0fin(0,0,m1sq,mudim) - m1**4*m3**6*B0fin(0,0,m1sq,mudim) + 3*m1sq*m2sq*m3**6*B0fin(0,0,m1sq,mudim) - m1sq*m3**8*B0fin(0,0,m1sq,mudim) - 3*m1**4*m2**4*m3sq*B0fin(0,0,m1sq,mudim) + m1sq*m2**6*m3sq*B0fin(0,0,m1sq,mudim) - m1**6*m2**4*B0fin(0,0,m2sq,mudim) - 3*m1sq*m2**4*m3**4*B0fin(0,0,m2sq,mudim) + 3*m1**4*m2sq*m3**4*B0fin(0,0,m2sq,mudim) + m2**4*m3**6*B0fin(0,0,m2sq,mudim) - 3*m1sq*m2sq*m3**6*B0fin(0,0,m2sq,mudim) + m2sq*m3**8*B0fin(0,0,m2sq,mudim) + 3*m1**4*m2**4*m3sq*B0fin(0,0,m2sq,mudim) - m1**6*m2sq*m3sq*B0fin(0,0,m2sq,mudim) + m1**6*m2**4*B0fin(0,0,m3sq,mudim) - m1**4*m2**6*B0fin(0,0,m3sq,mudim) + 2*m1**6*m3**4*B0fin(0,0,m3sq,mudim) - 12*m1sq*m2**4*m3**4*B0fin(0,0,m3sq,mudim) - 2*m2**6*m3**4*B0fin(0,0,m3sq,mudim) + 12*m1**4*m2sq*m3**4*B0fin(0,0,m3sq,mudim) - 5*m1**4*m3**6*B0fin(0,0,m3sq,mudim) + 5*m2**4*m3**6*B0fin(0,0,m3sq,mudim) + m1sq*m3**8*B0fin(0,0,m3sq,mudim) - m2sq*m3**8*B0fin(0,0,m3sq,mudim) + 5*m1sq*m2**6*m3sq*B0fin(0,0,m3sq,mudim) - 5*m1**6*m2sq*m3sq*B0fin(0,0,m3sq,mudim) + m1**4*m2**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 3*m1sq*m2**4*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 3*m1**4*m2sq*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1**4*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 3*m1sq*m2sq*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1sq*m3**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 3*m1**4*m2**4*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m1sq*m2**6*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1**6*m2**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 3*m1sq*m2**4*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 3*m1**4*m2sq*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + m2**4*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 3*m1sq*m2sq*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + m2sq*m3**8*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 3*m1**4*m2**4*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - m1**6*m2sq*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1sq*m2**6*T134fin(m3,m1,0,mudim) - 6*m1sq*m2sq*m3**4*T134fin(m3,m1,0,mudim) + 2*m1sq*m3**6*T134fin(m3,m1,0,mudim) + 6*m1sq*m2**4*m3sq*T134fin(m3,m1,0,mudim) + 2*m1**6*m2sq*T134fin(m3,m2,0,mudim) + 6*m1sq*m2sq*m3**4*T134fin(m3,m2,0,mudim) - 2*m2sq*m3**6*T134fin(m3,m2,0,mudim) - 6*m1**4*m2sq*m3sq*T134fin(m3,m2,0,mudim))/((m1sq - m2sq)*(m1sq - m3sq)**3*(m2sq - m3sq)**3)
		def eval_53():
			return ((m1sq - m2sq)**2*(m2sq - m6sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + 2*(m1sq - m2sq)**2*(m2sq - m6sq)**2*(-2*(m1sq*(m2sq/(m1sq - m2sq)**2 - m6sq/(m1sq - m6sq)**2)*B0fin(0,0,m1sq,mudim) + (m2sq*m6sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m6sq,mudim)))/(m2sq - m6sq)**2 + m1sq*((m2sq*B0fin(0,0,m2sq,mudim))/(m1sq - m2sq)**2 - (m6sq*B0fin(0,0,m6sq,mudim))/(m1sq - m6sq)**2)) + 2*(m1sq*(m2sq/(m1sq - m2sq)**2 - m6sq/(m1sq - m6sq)**2)*B0del(0,0,m1sq,mudim) + m1sq*((m2sq*B0del(0,0,m2sq,mudim))/(m1sq - m2sq)**2 - (m6sq*B0del(0,0,m6sq,mudim))/(m1sq - m6sq)**2) + m1sq*B0fin(0,0,m1sq,mudim)*((m2sq*B0fin(0,0,m2sq,mudim))/(m1sq - m2sq)**2 - (m6sq*B0fin(0,0,m6sq,mudim))/(m1sq - m6sq)**2) + (m2sq*m6sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim)))/(m2sq - m6sq)**2)) + 2*(m1sq + m2sq)*(m2sq - m6sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) - (2*(m1sq - m2sq)**2*(m2sq - m6sq)**2*(m1sq + m6sq)*(m1sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) - T134fin(m6,m1,0,mudim)))/(m1sq - m6sq)**2 + 2*(m1sq - m2sq)**2*(m2sq + m6sq)*(m2sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) - T134fin(m6,m2,0,mudim)))/(2.*(m1sq - m2sq)**3*(m2sq - m6sq)**3)
		def eval_54():
			return ((m1sq - m2sq)**2*(m2sq - m4sq)**2*(6 + 2*B0del(0,0,m2sq,mudim) - 6*B0fin(0,0,m2sq,mudim) + B0fin(0,0,m2sq,mudim)**2) + 2*(m1sq - m2sq)**2*(m2sq - m4sq)**2*(-2*(m1sq*(m2sq/(m1sq - m2sq)**2 - m4sq/(m1sq - m4sq)**2)*B0fin(0,0,m1sq,mudim) + (m2sq*m4sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m4sq,mudim)))/(m2sq - m4sq)**2 + m1sq*((m2sq*B0fin(0,0,m2sq,mudim))/(m1sq - m2sq)**2 - (m4sq*B0fin(0,0,m4sq,mudim))/(m1sq - m4sq)**2)) + 2*(m1sq*(m2sq/(m1sq - m2sq)**2 - m4sq/(m1sq - m4sq)**2)*B0del(0,0,m1sq,mudim) + m1sq*((m2sq*B0del(0,0,m2sq,mudim))/(m1sq - m2sq)**2 - (m4sq*B0del(0,0,m4sq,mudim))/(m1sq - m4sq)**2) + m1sq*B0fin(0,0,m1sq,mudim)*((m2sq*B0fin(0,0,m2sq,mudim))/(m1sq - m2sq)**2 - (m4sq*B0fin(0,0,m4sq,mudim))/(m1sq - m4sq)**2) + (m2sq*m4sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/(m2sq - m4sq)**2)) + 2*(m1sq + m2sq)*(m2sq - m4sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) - (2*(m1sq - m2sq)**2*(m2sq - m4sq)**2*(m1sq + m4sq)*(m1sq + m4sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m1,0,mudim)))/(m1sq - m4sq)**2 + 2*(m1sq - m2sq)**2*(m2sq + m4sq)*(m2sq + m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m2,0,mudim)))/(2.*(m1sq - m2sq)**3*(m2sq - m4sq)**3)
		def eval_55():
			return -((m1**4*m5**6 + 3*m1**8*m5sq + 3*m5**6*m6**4 + 9*m1**4*m5sq*m6**4 - m1**4*m6**6 - 3*m5**4*m6**6 - 3*m1**8*m6sq - 9*m1**4*m5**4*m6sq + (m5sq - m6sq)*(m1**8 + m5**4*m6**4 - 6*m1**4*m5sq*m6sq + m1**6*(m5sq + m6sq) + m1sq*m5sq*m6sq*(m5sq + m6sq))*B0del(0,0,m1sq,mudim) + m5sq*(m1sq + m5sq)*(m1sq - m6sq)**3*B0del(0,0,m5sq,mudim) - m1**6*m6**4*B0del(0,0,m6sq,mudim) - 3*m1sq*m5**4*m6**4*B0del(0,0,m6sq,mudim) + m5**6*m6**4*B0del(0,0,m6sq,mudim) + 3*m1**4*m5sq*m6**4*B0del(0,0,m6sq,mudim) - m1**8*m6sq*B0del(0,0,m6sq,mudim) - 3*m1**4*m5**4*m6sq*B0del(0,0,m6sq,mudim) + m1sq*m5**6*m6sq*B0del(0,0,m6sq,mudim) + 3*m1**6*m5sq*m6sq*B0del(0,0,m6sq,mudim) + 5*m1**6*m5**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m5**6*B0fin(0,0,m1sq,mudim) - m1**8*m5sq*B0fin(0,0,m1sq,mudim) - 5*m1**6*m6**4*B0fin(0,0,m1sq,mudim) - m5**6*m6**4*B0fin(0,0,m1sq,mudim) + 12*m1**4*m5sq*m6**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*m6**6*B0fin(0,0,m1sq,mudim) + m5**4*m6**6*B0fin(0,0,m1sq,mudim) - 5*m1sq*m5sq*m6**6*B0fin(0,0,m1sq,mudim) + m1**8*m6sq*B0fin(0,0,m1sq,mudim) - 12*m1**4*m5**4*m6sq*B0fin(0,0,m1sq,mudim) + 5*m1sq*m5**6*m6sq*B0fin(0,0,m1sq,mudim) + m1**6*m5**4*B0fin(0,0,m5sq,mudim) + m1**8*m5sq*B0fin(0,0,m5sq,mudim) + 3*m1sq*m5**4*m6**4*B0fin(0,0,m5sq,mudim) + 3*m1**4*m5sq*m6**4*B0fin(0,0,m5sq,mudim) - m5**4*m6**6*B0fin(0,0,m5sq,mudim) - m1sq*m5sq*m6**6*B0fin(0,0,m5sq,mudim) - 3*m1**4*m5**4*m6sq*B0fin(0,0,m5sq,mudim) - 3*m1**6*m5sq*m6sq*B0fin(0,0,m5sq,mudim) + m1**6*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m1**8*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m1sq*m5**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 3*m1**4*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m5**4*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1sq*m5sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m1**4*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 3*m1**6*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**6*m6**4*B0fin(0,0,m6sq,mudim) - 3*m1sq*m5**4*m6**4*B0fin(0,0,m6sq,mudim) + m5**6*m6**4*B0fin(0,0,m6sq,mudim) + 3*m1**4*m5sq*m6**4*B0fin(0,0,m6sq,mudim) - m1**8*m6sq*B0fin(0,0,m6sq,mudim) - 3*m1**4*m5**4*m6sq*B0fin(0,0,m6sq,mudim) + m1sq*m5**6*m6sq*B0fin(0,0,m6sq,mudim) + 3*m1**6*m5sq*m6sq*B0fin(0,0,m6sq,mudim) - m1**6*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 3*m1sq*m5**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m5**6*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 3*m1**4*m5sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - m1**8*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 3*m1**4*m5**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1sq*m5**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 3*m1**6*m5sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**6*m5sq*T134fin(m5,m1,0,mudim) - 6*m1sq*m5sq*m6**4*T134fin(m5,m1,0,mudim) + 2*m5sq*m6**6*T134fin(m5,m1,0,mudim) + 6*m1**4*m5sq*m6sq*T134fin(m5,m1,0,mudim) + 2*m1**6*m6sq*T134fin(m6,m1,0,mudim) + 6*m1sq*m5**4*m6sq*T134fin(m6,m1,0,mudim) - 2*m5**6*m6sq*T134fin(m6,m1,0,mudim) - 6*m1**4*m5sq*m6sq*T134fin(m6,m1,0,mudim))/((m1sq - m5sq)**3*(m1sq - m6sq)**3*(m5sq - m6sq)))
		def eval_56():
			return -0.5*((m1sq - m2sq)**2*(m1sq - m6sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) - 2*(m1sq - m2sq)**2*(m1sq - m6sq)**2*(-2*(m1sq*(-(m2sq/(m1sq - m2sq)**2) - m6sq/(m1sq - m6sq)**2)*B0fin(0,0,m1sq,mudim) + (m2sq*m6sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m6sq,mudim)))/(m2sq - m6sq)**2 + m1sq*(-((m2sq*B0fin(0,0,m2sq,mudim))/(m1sq - m2sq)**2) - (m6sq*B0fin(0,0,m6sq,mudim))/(m1sq - m6sq)**2)) + 2*(m1sq*(-(m2sq/(m1sq - m2sq)**2) - m6sq/(m1sq - m6sq)**2)*B0del(0,0,m1sq,mudim) + m1sq*(-((m2sq*B0del(0,0,m2sq,mudim))/(m1sq - m2sq)**2) - (m6sq*B0del(0,0,m6sq,mudim))/(m1sq - m6sq)**2) + m1sq*B0fin(0,0,m1sq,mudim)*(-((m2sq*B0fin(0,0,m2sq,mudim))/(m1sq - m2sq)**2) - (m6sq*B0fin(0,0,m6sq,mudim))/(m1sq - m6sq)**2) + (m2sq*m6sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m6sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim)))/(m2sq - m6sq)**2)) + 2*(m1sq + m2sq)*(m1sq - m6sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m1sq + m6sq)*(m1sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) - T134fin(m6,m1,0,mudim)) - (2*(m1sq - m2sq)**2*(m1sq - m6sq)**2*(m2sq + m6sq)*(m2sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim) - T134fin(m6,m2,0,mudim)))/(m2sq - m6sq)**2)/((m1sq - m2sq)**3*(m1sq - m6sq)**3)
		def eval_57():
			return -((m1**4*m3**6 + 3*m1**8*m3sq + 3*m3**6*m4**4 + 9*m1**4*m3sq*m4**4 - m1**4*m4**6 - 3*m3**4*m4**6 - 3*m1**8*m4sq - 9*m1**4*m3**4*m4sq + (m3sq - m4sq)*(m1**8 + m3**4*m4**4 - 6*m1**4*m3sq*m4sq + m1**6*(m3sq + m4sq) + m1sq*m3sq*m4sq*(m3sq + m4sq))*B0del(0,0,m1sq,mudim) + m3sq*(m1sq + m3sq)*(m1sq - m4sq)**3*B0del(0,0,m3sq,mudim) - m1**6*m4**4*B0del(0,0,m4sq,mudim) - 3*m1sq*m3**4*m4**4*B0del(0,0,m4sq,mudim) + m3**6*m4**4*B0del(0,0,m4sq,mudim) + 3*m1**4*m3sq*m4**4*B0del(0,0,m4sq,mudim) - m1**8*m4sq*B0del(0,0,m4sq,mudim) - 3*m1**4*m3**4*m4sq*B0del(0,0,m4sq,mudim) + m1sq*m3**6*m4sq*B0del(0,0,m4sq,mudim) + 3*m1**6*m3sq*m4sq*B0del(0,0,m4sq,mudim) + 5*m1**6*m3**4*B0fin(0,0,m1sq,mudim) - 2*m1**4*m3**6*B0fin(0,0,m1sq,mudim) - m1**8*m3sq*B0fin(0,0,m1sq,mudim) - 5*m1**6*m4**4*B0fin(0,0,m1sq,mudim) - m3**6*m4**4*B0fin(0,0,m1sq,mudim) + 12*m1**4*m3sq*m4**4*B0fin(0,0,m1sq,mudim) + 2*m1**4*m4**6*B0fin(0,0,m1sq,mudim) + m3**4*m4**6*B0fin(0,0,m1sq,mudim) - 5*m1sq*m3sq*m4**6*B0fin(0,0,m1sq,mudim) + m1**8*m4sq*B0fin(0,0,m1sq,mudim) - 12*m1**4*m3**4*m4sq*B0fin(0,0,m1sq,mudim) + 5*m1sq*m3**6*m4sq*B0fin(0,0,m1sq,mudim) + m1**6*m3**4*B0fin(0,0,m3sq,mudim) + m1**8*m3sq*B0fin(0,0,m3sq,mudim) + 3*m1sq*m3**4*m4**4*B0fin(0,0,m3sq,mudim) + 3*m1**4*m3sq*m4**4*B0fin(0,0,m3sq,mudim) - m3**4*m4**6*B0fin(0,0,m3sq,mudim) - m1sq*m3sq*m4**6*B0fin(0,0,m3sq,mudim) - 3*m1**4*m3**4*m4sq*B0fin(0,0,m3sq,mudim) - 3*m1**6*m3sq*m4sq*B0fin(0,0,m3sq,mudim) + m1**6*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m1**8*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 3*m1sq*m3**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 3*m1**4*m3sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m3**4*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1sq*m3sq*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 3*m1**4*m3**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 3*m1**6*m3sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1**6*m4**4*B0fin(0,0,m4sq,mudim) - 3*m1sq*m3**4*m4**4*B0fin(0,0,m4sq,mudim) + m3**6*m4**4*B0fin(0,0,m4sq,mudim) + 3*m1**4*m3sq*m4**4*B0fin(0,0,m4sq,mudim) - m1**8*m4sq*B0fin(0,0,m4sq,mudim) - 3*m1**4*m3**4*m4sq*B0fin(0,0,m4sq,mudim) + m1sq*m3**6*m4sq*B0fin(0,0,m4sq,mudim) + 3*m1**6*m3sq*m4sq*B0fin(0,0,m4sq,mudim) - m1**6*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 3*m1sq*m3**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m3**6*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 3*m1**4*m3sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m1**8*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 3*m1**4*m3**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*m3**6*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 3*m1**6*m3sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1**6*m3sq*T134fin(m3,m1,0,mudim) - 6*m1sq*m3sq*m4**4*T134fin(m3,m1,0,mudim) + 2*m3sq*m4**6*T134fin(m3,m1,0,mudim) + 6*m1**4*m3sq*m4sq*T134fin(m3,m1,0,mudim) + 2*m1**6*m4sq*T134fin(m4,m1,0,mudim) + 6*m1sq*m3**4*m4sq*T134fin(m4,m1,0,mudim) - 2*m3**6*m4sq*T134fin(m4,m1,0,mudim) - 6*m1**4*m3sq*m4sq*T134fin(m4,m1,0,mudim))/((m1sq - m3sq)**3*(m1sq - m4sq)**3*(m3sq - m4sq)))
		def eval_58():
			return -0.5*((m1sq - m2sq)**2*(m1sq - m4sq)**2*(6 + 2*B0del(0,0,m1sq,mudim) - 6*B0fin(0,0,m1sq,mudim) + B0fin(0,0,m1sq,mudim)**2) - 2*(m1sq - m2sq)**2*(m1sq - m4sq)**2*(-2*(m1sq*(-(m2sq/(m1sq - m2sq)**2) - m4sq/(m1sq - m4sq)**2)*B0fin(0,0,m1sq,mudim) + (m2sq*m4sq*(B0fin(0,0,m2sq,mudim) + B0fin(0,0,m4sq,mudim)))/(m2sq - m4sq)**2 + m1sq*(-((m2sq*B0fin(0,0,m2sq,mudim))/(m1sq - m2sq)**2) - (m4sq*B0fin(0,0,m4sq,mudim))/(m1sq - m4sq)**2)) + 2*(m1sq*(-(m2sq/(m1sq - m2sq)**2) - m4sq/(m1sq - m4sq)**2)*B0del(0,0,m1sq,mudim) + m1sq*(-((m2sq*B0del(0,0,m2sq,mudim))/(m1sq - m2sq)**2) - (m4sq*B0del(0,0,m4sq,mudim))/(m1sq - m4sq)**2) + m1sq*B0fin(0,0,m1sq,mudim)*(-((m2sq*B0fin(0,0,m2sq,mudim))/(m1sq - m2sq)**2) - (m4sq*B0fin(0,0,m4sq,mudim))/(m1sq - m4sq)**2) + (m2sq*m4sq*(B0del(0,0,m2sq,mudim) + B0del(0,0,m4sq,mudim) + B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim)))/(m2sq - m4sq)**2)) + 2*(m1sq + m2sq)*(m1sq - m4sq)**2*(m1sq + m2sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*B0fin(0,0,m2sq,mudim) - T134fin(m2,m1,0,mudim)) + 2*(m1sq - m2sq)**2*(m1sq + m4sq)*(m1sq + m4sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m1,0,mudim)) - (2*(m1sq - m2sq)**2*(m1sq - m4sq)**2*(m2sq + m4sq)*(m2sq + m4sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) - T134fin(m4,m2,0,mudim)))/(m2sq - m4sq)**2)/((m1sq - m2sq)**3*(m1sq - m4sq)**3)
		def eval_59():
			return (m2**6 + 16*m2sq*m3**4 - 8*m3**6 - 6*m2**4*m3sq + 2*m2sq*(m2sq - 2*m3sq)*m3sq*B0del(0,0,m2sq,mudim) + 4*m3**4*(m2sq - 2*m3sq)*B0del(0,0,m3sq,mudim) + 4*m2sq*m3**4*B0fin(0,0,m2sq,mudim) - 4*m2sq*m3**4*B0fin(0,0,m3sq,mudim) - 8*m3**6*B0fin(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0fin(0,0,m3sq,mudim) - 4*m2sq*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m2**4*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 4*m2sq*m3**4*B0fin(0,0,m3sq,mudim)**2 - 4*m3**6*B0fin(0,0,m3sq,mudim)**2 - m2**4*m3sq*B0fin(0,0,m3sq,mudim)**2 + 4*m3**4*T134fin(m3,m3,m2,mudim) - 2*m2sq*m3sq*T134fin(m3,m3,m2,mudim))/(m2**4*m3**2*(m2sq - 4*m3sq)**2)
		def eval_60():
			return (-8*m2**8 - 10*m2**4*m3**4 + 34*m2sq*m3**6 - 4*m3**8 + 24*m2**6*m3sq + (-8*m2**8 - 8*m2**4*m3**4 + 6*m2sq*m3**6 + 28*m2**6*m3sq)*B0del(0,0,m2sq,mudim) - 2*(m2**4*m3**4 - 14*m2sq*m3**6 + 2*m3**8 + 2*m2**6*m3sq)*B0del(0,0,m3sq,mudim) - 8*m2**8*B0fin(0,0,m2sq,mudim) - 8*m2**4*m3**4*B0fin(0,0,m2sq,mudim) + 6*m2sq*m3**6*B0fin(0,0,m2sq,mudim) + 28*m2**6*m3sq*B0fin(0,0,m2sq,mudim) - 4*m2**8*B0fin(0,0,m2sq,mudim)**2 - 16*m2**4*m3**4*B0fin(0,0,m2sq,mudim)**2 + 20*m2**6*m3sq*B0fin(0,0,m2sq,mudim)**2 - 2*m2**4*m3**4*B0fin(0,0,m3sq,mudim) + 28*m2sq*m3**6*B0fin(0,0,m3sq,mudim) - 4*m3**8*B0fin(0,0,m3sq,mudim) - 4*m2**6*m3sq*B0fin(0,0,m3sq,mudim) + 24*m2**4*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 6*m2sq*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 12*m2**6*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 13*m2**4*m3**4*B0fin(0,0,m3sq,mudim)**2 + 11*m2sq*m3**6*B0fin(0,0,m3sq,mudim)**2 - 2*m3**8*B0fin(0,0,m3sq,mudim)**2 + 4*m2**6*m3sq*B0fin(0,0,m3sq,mudim)**2 - 34*m2sq*m3**4*T134fin(m3,m2,0,mudim) + 8*m3**6*T134fin(m3,m2,0,mudim) + 8*m2**4*m3sq*T134fin(m3,m2,0,mudim) + 4*m2**6*T134fin(m3,m2,m2,mudim) + 26*m2sq*m3**4*T134fin(m3,m2,m2,mudim) - 8*m3**6*T134fin(m3,m2,m2,mudim) - 22*m2**4*m3sq*T134fin(m3,m2,m2,mudim) - 10*m2sq*m3**4*T134fin(m3,m3,m2,mudim) + 2*m3**6*T134fin(m3,m3,m2,mudim) + 8*m2**4*m3sq*T134fin(m3,m3,m2,mudim))/(2.*m2**2*m3**2*(m2sq - m3sq)**2*(4*m2**4 + 4*m3**4 - 17*m2sq*m3sq))
		def eval_61():
			return (-8*m1**6 - 6*m1sq*m6**4 + m6**6 + 16*m1**4*m6sq + (-8*m1**6 + 4*m1**4*m6sq)*B0del(0,0,m1sq,mudim) + (2*m1sq*m6**4 - 4*m1**4*m6sq)*B0del(0,0,m6sq,mudim) - 8*m1**6*B0fin(0,0,m1sq,mudim) + 2*m1sq*m6**4*B0fin(0,0,m1sq,mudim) - 4*m1**4*m6sq*B0fin(0,0,m1sq,mudim) - 4*m1**6*B0fin(0,0,m1sq,mudim)**2 - m1sq*m6**4*B0fin(0,0,m1sq,mudim)**2 + 4*m1**4*m6sq*B0fin(0,0,m1sq,mudim)**2 + 4*m1**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m1**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1**4*T134fin(m6,m1,m1,mudim) - 2*m1sq*m6sq*T134fin(m6,m1,m1,mudim))/(m6**4*(-4*m1**3 + m1*m6sq)**2)
		def eval_62():
			return (-8*m1**6 - 6*m1sq*m4**4 + m4**6 + 16*m1**4*m4sq + (-8*m1**6 + 4*m1**4*m4sq)*B0del(0,0,m1sq,mudim) + (2*m1sq*m4**4 - 4*m1**4*m4sq)*B0del(0,0,m4sq,mudim) - 8*m1**6*B0fin(0,0,m1sq,mudim) + 2*m1sq*m4**4*B0fin(0,0,m1sq,mudim) - 4*m1**4*m4sq*B0fin(0,0,m1sq,mudim) - 4*m1**6*B0fin(0,0,m1sq,mudim)**2 - m1sq*m4**4*B0fin(0,0,m1sq,mudim)**2 + 4*m1**4*m4sq*B0fin(0,0,m1sq,mudim)**2 + 4*m1**4*m4sq*B0fin(0,0,m4sq,mudim) + 2*m1sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m1**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1**4*T134fin(m4,m1,m1,mudim) - 2*m1sq*m4sq*T134fin(m4,m1,m1,mudim))/(m4**4*(-4*m1**3 + m1*m4sq)**2)
		def eval_63():
			return -0.5*(-12*m2**4*m3**4 + 2*m2sq*m3**6 + 2*m2**6*m3sq - 20*m2**4*m4**4 - 12*m3**4*m4**4 + 22*m2sq*m3sq*m4**4 + 22*m2sq*m4**6 + 12*m3sq*m4**6 - 4*m4**8 + 2*m2**6*m4sq + 18*m2sq*m3**4*m4sq + 4*m3**6*m4sq - 2*m2sq*(3*m2sq - m3sq - 3*m4sq)*(m3sq - m4sq)**2*B0del(0,0,m2sq,mudim) + 2*m2sq*m3sq*(m2sq - 4*m4sq)*(m2sq - 3*m3sq - m4sq)*B0del(0,0,m3sq,mudim) - 14*m2**4*m4**4*B0del(0,0,m4sq,mudim) - 12*m3**4*m4**4*B0del(0,0,m4sq,mudim) + 24*m2sq*m3sq*m4**4*B0del(0,0,m4sq,mudim) + 16*m2sq*m4**6*B0del(0,0,m4sq,mudim) + 12*m3sq*m4**6*B0del(0,0,m4sq,mudim) - 4*m4**8*B0del(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0del(0,0,m4sq,mudim) - 8*m2sq*m3**4*m4sq*B0del(0,0,m4sq,mudim) + 4*m3**6*m4sq*B0del(0,0,m4sq,mudim) - 2*m2**4*m3sq*m4sq*B0del(0,0,m4sq,mudim) - 6*m2**4*m3**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 6*m2**4*m4**4*B0fin(0,0,m2sq,mudim) - 10*m2sq*m3sq*m4**4*B0fin(0,0,m2sq,mudim) + 6*m2sq*m4**6*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3**4*m4sq*B0fin(0,0,m2sq,mudim) + 12*m2**4*m3sq*m4sq*B0fin(0,0,m2sq,mudim) - 6*m2**4*m3**4*B0fin(0,0,m3sq,mudim) + 2*m2**6*m3sq*B0fin(0,0,m3sq,mudim) + 8*m2sq*m3sq*m4**4*B0fin(0,0,m3sq,mudim) + 24*m2sq*m3**4*m4sq*B0fin(0,0,m3sq,mudim) - 10*m2**4*m3sq*m4sq*B0fin(0,0,m3sq,mudim) - 4*m2**4*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 16*m2sq*m3sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 16*m2sq*m3**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 4*m2**4*m3sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 14*m2**4*m4**4*B0fin(0,0,m4sq,mudim) - 12*m3**4*m4**4*B0fin(0,0,m4sq,mudim) + 24*m2sq*m3sq*m4**4*B0fin(0,0,m4sq,mudim) + 16*m2sq*m4**6*B0fin(0,0,m4sq,mudim) + 12*m3sq*m4**6*B0fin(0,0,m4sq,mudim) - 4*m4**8*B0fin(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0fin(0,0,m4sq,mudim) - 8*m2sq*m3**4*m4sq*B0fin(0,0,m4sq,mudim) + 4*m3**6*m4sq*B0fin(0,0,m4sq,mudim) - 2*m2**4*m3sq*m4sq*B0fin(0,0,m4sq,mudim) - 2*m2**4*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2sq*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m2sq*m3sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m2sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 14*m2sq*m3**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m2**4*m3sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2**4*m3**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**6*m3sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m2sq*m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m2sq*m3**4*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 14*m2**4*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**4*m3**4*B0fin(0,0,m4sq,mudim)**2 - m2sq*m3**6*B0fin(0,0,m4sq,mudim)**2 - m2**6*m3sq*B0fin(0,0,m4sq,mudim)**2 - 4*m2**4*m4**4*B0fin(0,0,m4sq,mudim)**2 - 6*m3**4*m4**4*B0fin(0,0,m4sq,mudim)**2 - 3*m2sq*m3sq*m4**4*B0fin(0,0,m4sq,mudim)**2 + 5*m2sq*m4**6*B0fin(0,0,m4sq,mudim)**2 + 6*m3sq*m4**6*B0fin(0,0,m4sq,mudim)**2 - 2*m4**8*B0fin(0,0,m4sq,mudim)**2 + m2**6*m4sq*B0fin(0,0,m4sq,mudim)**2 - m2sq*m3**4*m4sq*B0fin(0,0,m4sq,mudim)**2 + 2*m3**6*m4sq*B0fin(0,0,m4sq,mudim)**2 + 2*m2**4*m3sq*m4sq*B0fin(0,0,m4sq,mudim)**2 - 2*m2**6*T134fin(m4,m3,0,mudim) - 2*m2sq*m3**4*T134fin(m4,m3,0,mudim) + 4*m2**4*m3sq*T134fin(m4,m3,0,mudim) - 18*m2sq*m4**4*T134fin(m4,m3,0,mudim) - 16*m3sq*m4**4*T134fin(m4,m3,0,mudim) + 8*m4**6*T134fin(m4,m3,0,mudim) + 12*m2**4*m4sq*T134fin(m4,m3,0,mudim) + 8*m3**4*m4sq*T134fin(m4,m3,0,mudim) - 12*m2sq*m3sq*m4sq*T134fin(m4,m3,0,mudim) + 2*m2sq*m3**4*T134fin(m4,m3,m2,mudim) + 2*m2**4*m3sq*T134fin(m4,m3,m2,mudim) + 10*m2sq*m4**4*T134fin(m4,m3,m2,mudim) + 16*m3sq*m4**4*T134fin(m4,m3,m2,mudim) - 8*m4**6*T134fin(m4,m3,m2,mudim) - 2*m2**4*m4sq*T134fin(m4,m3,m2,mudim) - 8*m3**4*m4sq*T134fin(m4,m3,m2,mudim) - 12*m2sq*m3sq*m4sq*T134fin(m4,m3,m2,mudim) + 4*m2sq*m3**4*T134fin(m4,m4,m2,mudim) - 2*m3**6*T134fin(m4,m4,m2,mudim) - 2*m2**4*m3sq*T134fin(m4,m4,m2,mudim) - 4*m2sq*m4**4*T134fin(m4,m4,m2,mudim) - 6*m3sq*m4**4*T134fin(m4,m4,m2,mudim) + 2*m4**6*T134fin(m4,m4,m2,mudim) + 2*m2**4*m4sq*T134fin(m4,m4,m2,mudim) + 6*m3**4*m4sq*T134fin(m4,m4,m2,mudim))/(m2**2*(m2sq - 4*m4sq)*(m3sq - m4sq)**2*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq)))
		def eval_64():
			return -0.5*(-20*m2**4*m3**4 + 22*m2sq*m3**6 - 4*m3**8 + 2*m2**6*m3sq - 12*m2**4*m6**4 - 12*m3**4*m6**4 + 18*m2sq*m3sq*m6**4 + 2*m2sq*m6**6 + 4*m3sq*m6**6 + 2*m2**6*m6sq + 22*m2sq*m3**4*m6sq + 12*m3**6*m6sq - 2*m2sq*(3*m2sq - 3*m3sq - m6sq)*(m3sq - m6sq)**2*B0del(0,0,m2sq,mudim) + 2*m3sq*(m2**6 - 2*(m3sq - m6sq)**3 - m2**4*(7*m3sq + m6sq) + 4*m2sq*(2*m3**4 - m6**4 + 3*m3sq*m6sq))*B0del(0,0,m3sq,mudim) - 6*m2**4*m6**4*B0del(0,0,m6sq,mudim) + 24*m2sq*m3sq*m6**4*B0del(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0del(0,0,m6sq,mudim) + 8*m2sq*m3**4*m6sq*B0del(0,0,m6sq,mudim) - 10*m2**4*m3sq*m6sq*B0del(0,0,m6sq,mudim) - 6*m2**4*m3**4*B0fin(0,0,m2sq,mudim) + 6*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 6*m2**4*m6**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3sq*m6**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m6**6*B0fin(0,0,m2sq,mudim) - 10*m2sq*m3**4*m6sq*B0fin(0,0,m2sq,mudim) + 12*m2**4*m3sq*m6sq*B0fin(0,0,m2sq,mudim) - 14*m2**4*m3**4*B0fin(0,0,m3sq,mudim) + 16*m2sq*m3**6*B0fin(0,0,m3sq,mudim) - 4*m3**8*B0fin(0,0,m3sq,mudim) + 2*m2**6*m3sq*B0fin(0,0,m3sq,mudim) - 12*m3**4*m6**4*B0fin(0,0,m3sq,mudim) - 8*m2sq*m3sq*m6**4*B0fin(0,0,m3sq,mudim) + 4*m3sq*m6**6*B0fin(0,0,m3sq,mudim) + 24*m2sq*m3**4*m6sq*B0fin(0,0,m3sq,mudim) + 12*m3**6*m6sq*B0fin(0,0,m3sq,mudim) - 2*m2**4*m3sq*m6sq*B0fin(0,0,m3sq,mudim) - 6*m2**4*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 6*m2sq*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m2**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 14*m2sq*m3sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m2sq*m6**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 6*m2sq*m3**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 8*m2**4*m3sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 4*m2**4*m3**4*B0fin(0,0,m3sq,mudim)**2 + 5*m2sq*m3**6*B0fin(0,0,m3sq,mudim)**2 - 2*m3**8*B0fin(0,0,m3sq,mudim)**2 + m2**6*m3sq*B0fin(0,0,m3sq,mudim)**2 + 2*m2**4*m6**4*B0fin(0,0,m3sq,mudim)**2 - 6*m3**4*m6**4*B0fin(0,0,m3sq,mudim)**2 - m2sq*m3sq*m6**4*B0fin(0,0,m3sq,mudim)**2 - m2sq*m6**6*B0fin(0,0,m3sq,mudim)**2 + 2*m3sq*m6**6*B0fin(0,0,m3sq,mudim)**2 - m2**6*m6sq*B0fin(0,0,m3sq,mudim)**2 - 3*m2sq*m3**4*m6sq*B0fin(0,0,m3sq,mudim)**2 + 6*m3**6*m6sq*B0fin(0,0,m3sq,mudim)**2 + 2*m2**4*m3sq*m6sq*B0fin(0,0,m3sq,mudim)**2 - 6*m2**4*m6**4*B0fin(0,0,m6sq,mudim) + 24*m2sq*m3sq*m6**4*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0fin(0,0,m6sq,mudim) + 8*m2sq*m3**4*m6sq*B0fin(0,0,m6sq,mudim) - 10*m2**4*m3sq*m6sq*B0fin(0,0,m6sq,mudim) - 4*m2**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 16*m2sq*m3sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m2sq*m3**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m2**4*m3sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m2**4*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m2sq*m3sq*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + 24*m2sq*m3**4*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 14*m2**4*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m2sq*m3**4*T134fin(m3,m3,m2,mudim) + 2*m3**6*T134fin(m3,m3,m2,mudim) + 2*m2**4*m3sq*T134fin(m3,m3,m2,mudim) + 4*m2sq*m6**4*T134fin(m3,m3,m2,mudim) + 6*m3sq*m6**4*T134fin(m3,m3,m2,mudim) - 2*m6**6*T134fin(m3,m3,m2,mudim) - 2*m2**4*m6sq*T134fin(m3,m3,m2,mudim) - 6*m3**4*m6sq*T134fin(m3,m3,m2,mudim) - 2*m2**6*T134fin(m6,m3,0,mudim) - 18*m2sq*m3**4*T134fin(m6,m3,0,mudim) + 8*m3**6*T134fin(m6,m3,0,mudim) + 12*m2**4*m3sq*T134fin(m6,m3,0,mudim) - 2*m2sq*m6**4*T134fin(m6,m3,0,mudim) + 8*m3sq*m6**4*T134fin(m6,m3,0,mudim) + 4*m2**4*m6sq*T134fin(m6,m3,0,mudim) - 16*m3**4*m6sq*T134fin(m6,m3,0,mudim) - 12*m2sq*m3sq*m6sq*T134fin(m6,m3,0,mudim) + 10*m2sq*m3**4*T134fin(m6,m3,m2,mudim) - 8*m3**6*T134fin(m6,m3,m2,mudim) - 2*m2**4*m3sq*T134fin(m6,m3,m2,mudim) + 2*m2sq*m6**4*T134fin(m6,m3,m2,mudim) - 8*m3sq*m6**4*T134fin(m6,m3,m2,mudim) + 2*m2**4*m6sq*T134fin(m6,m3,m2,mudim) + 16*m3**4*m6sq*T134fin(m6,m3,m2,mudim) - 12*m2sq*m3sq*m6sq*T134fin(m6,m3,m2,mudim))/(m2**2*(m2sq - 4*m3sq)*(m3sq - m6sq)**2*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq)))
		def eval_65():
			return -0.5*(-20*m2**4*m3**4 + 22*m2sq*m3**6 - 4*m3**8 + 2*m2**6*m3sq - 12*m2**4*m4**4 - 12*m3**4*m4**4 + 18*m2sq*m3sq*m4**4 + 2*m2sq*m4**6 + 4*m3sq*m4**6 + 2*m2**6*m4sq + 22*m2sq*m3**4*m4sq + 12*m3**6*m4sq - 2*m2sq*(3*m2sq - 3*m3sq - m4sq)*(m3sq - m4sq)**2*B0del(0,0,m2sq,mudim) + 2*m3sq*(m2**6 - 2*(m3sq - m4sq)**3 - m2**4*(7*m3sq + m4sq) + 4*m2sq*(2*m3**4 - m4**4 + 3*m3sq*m4sq))*B0del(0,0,m3sq,mudim) - 6*m2**4*m4**4*B0del(0,0,m4sq,mudim) + 24*m2sq*m3sq*m4**4*B0del(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0del(0,0,m4sq,mudim) + 8*m2sq*m3**4*m4sq*B0del(0,0,m4sq,mudim) - 10*m2**4*m3sq*m4sq*B0del(0,0,m4sq,mudim) - 6*m2**4*m3**4*B0fin(0,0,m2sq,mudim) + 6*m2sq*m3**6*B0fin(0,0,m2sq,mudim) - 6*m2**4*m4**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m3sq*m4**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m4**6*B0fin(0,0,m2sq,mudim) - 10*m2sq*m3**4*m4sq*B0fin(0,0,m2sq,mudim) + 12*m2**4*m3sq*m4sq*B0fin(0,0,m2sq,mudim) - 14*m2**4*m3**4*B0fin(0,0,m3sq,mudim) + 16*m2sq*m3**6*B0fin(0,0,m3sq,mudim) - 4*m3**8*B0fin(0,0,m3sq,mudim) + 2*m2**6*m3sq*B0fin(0,0,m3sq,mudim) - 12*m3**4*m4**4*B0fin(0,0,m3sq,mudim) - 8*m2sq*m3sq*m4**4*B0fin(0,0,m3sq,mudim) + 4*m3sq*m4**6*B0fin(0,0,m3sq,mudim) + 24*m2sq*m3**4*m4sq*B0fin(0,0,m3sq,mudim) + 12*m3**6*m4sq*B0fin(0,0,m3sq,mudim) - 2*m2**4*m3sq*m4sq*B0fin(0,0,m3sq,mudim) - 6*m2**4*m3**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 6*m2sq*m3**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 14*m2sq*m3sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m2sq*m4**6*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 6*m2sq*m3**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 8*m2**4*m3sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - 4*m2**4*m3**4*B0fin(0,0,m3sq,mudim)**2 + 5*m2sq*m3**6*B0fin(0,0,m3sq,mudim)**2 - 2*m3**8*B0fin(0,0,m3sq,mudim)**2 + m2**6*m3sq*B0fin(0,0,m3sq,mudim)**2 + 2*m2**4*m4**4*B0fin(0,0,m3sq,mudim)**2 - 6*m3**4*m4**4*B0fin(0,0,m3sq,mudim)**2 - m2sq*m3sq*m4**4*B0fin(0,0,m3sq,mudim)**2 - m2sq*m4**6*B0fin(0,0,m3sq,mudim)**2 + 2*m3sq*m4**6*B0fin(0,0,m3sq,mudim)**2 - m2**6*m4sq*B0fin(0,0,m3sq,mudim)**2 - 3*m2sq*m3**4*m4sq*B0fin(0,0,m3sq,mudim)**2 + 6*m3**6*m4sq*B0fin(0,0,m3sq,mudim)**2 + 2*m2**4*m3sq*m4sq*B0fin(0,0,m3sq,mudim)**2 - 6*m2**4*m4**4*B0fin(0,0,m4sq,mudim) + 24*m2sq*m3sq*m4**4*B0fin(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0fin(0,0,m4sq,mudim) + 8*m2sq*m3**4*m4sq*B0fin(0,0,m4sq,mudim) - 10*m2**4*m3sq*m4sq*B0fin(0,0,m4sq,mudim) - 4*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 16*m2sq*m3sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 16*m2sq*m3**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m2**4*m3sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2**4*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m2sq*m3sq*m4**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m2sq*m3**4*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 14*m2**4*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m2sq*m3**4*T134fin(m3,m3,m2,mudim) + 2*m3**6*T134fin(m3,m3,m2,mudim) + 2*m2**4*m3sq*T134fin(m3,m3,m2,mudim) + 4*m2sq*m4**4*T134fin(m3,m3,m2,mudim) + 6*m3sq*m4**4*T134fin(m3,m3,m2,mudim) - 2*m4**6*T134fin(m3,m3,m2,mudim) - 2*m2**4*m4sq*T134fin(m3,m3,m2,mudim) - 6*m3**4*m4sq*T134fin(m3,m3,m2,mudim) - 2*m2**6*T134fin(m4,m3,0,mudim) - 18*m2sq*m3**4*T134fin(m4,m3,0,mudim) + 8*m3**6*T134fin(m4,m3,0,mudim) + 12*m2**4*m3sq*T134fin(m4,m3,0,mudim) - 2*m2sq*m4**4*T134fin(m4,m3,0,mudim) + 8*m3sq*m4**4*T134fin(m4,m3,0,mudim) + 4*m2**4*m4sq*T134fin(m4,m3,0,mudim) - 16*m3**4*m4sq*T134fin(m4,m3,0,mudim) - 12*m2sq*m3sq*m4sq*T134fin(m4,m3,0,mudim) + 10*m2sq*m3**4*T134fin(m4,m3,m2,mudim) - 8*m3**6*T134fin(m4,m3,m2,mudim) - 2*m2**4*m3sq*T134fin(m4,m3,m2,mudim) + 2*m2sq*m4**4*T134fin(m4,m3,m2,mudim) - 8*m3sq*m4**4*T134fin(m4,m3,m2,mudim) + 2*m2**4*m4sq*T134fin(m4,m3,m2,mudim) + 16*m3**4*m4sq*T134fin(m4,m3,m2,mudim) - 12*m2sq*m3sq*m4sq*T134fin(m4,m3,m2,mudim))/(m2**2*(m2sq - 4*m3sq)*(m3sq - m4sq)**2*(m2**4 + (m3sq - m4sq)**2 - 2*m2sq*(m3sq + m4sq)))
		def eval_66():
			return (-12*m1**4*m2**4 + 12*m1sq*m2**6 - 4*m2**8 + 4*m1**6*m2sq - 12*m1**4*m6**4 - 20*m2**4*m6**4 + 2*m1sq*m6**6 + 2*m2sq*m6**6 + 2*m1**6*m6sq + 22*m1sq*m2**4*m6sq + 22*m2**6*m6sq + 18*m1**4*m2sq*m6sq - 2*m1sq*(3*m1sq + m2sq - m6sq)*m6sq*(-4*m2sq + m6sq)*B0del(0,0,m1sq,mudim) + 2*m2sq*(2*m1**6 - 2*m2**6 - 7*m2sq*m6**4 + m6**6 + 8*m2**4*m6sq - 2*m1**4*(3*m2sq + 2*m6sq) + m1sq*(6*m2**4 - m6**4 + 12*m2sq*m6sq))*B0del(0,0,m2sq,mudim) - 6*m1**4*m6**4*B0del(0,0,m6sq,mudim) - 6*m2**4*m6**4*B0del(0,0,m6sq,mudim) + 12*m1sq*m2sq*m6**4*B0del(0,0,m6sq,mudim) + 2*m1**6*m6sq*B0del(0,0,m6sq,mudim) - 10*m1sq*m2**4*m6sq*B0del(0,0,m6sq,mudim) + 6*m2**6*m6sq*B0del(0,0,m6sq,mudim) + 2*m1**4*m2sq*m6sq*B0del(0,0,m6sq,mudim) - 6*m1**4*m6**4*B0fin(0,0,m1sq,mudim) - 10*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m6**6*B0fin(0,0,m1sq,mudim) + 8*m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim) + 24*m1**4*m2sq*m6sq*B0fin(0,0,m1sq,mudim) - 12*m1**4*m2**4*B0fin(0,0,m2sq,mudim) + 12*m1sq*m2**6*B0fin(0,0,m2sq,mudim) - 4*m2**8*B0fin(0,0,m2sq,mudim) + 4*m1**6*m2sq*B0fin(0,0,m2sq,mudim) - 14*m2**4*m6**4*B0fin(0,0,m2sq,mudim) - 2*m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m6**6*B0fin(0,0,m2sq,mudim) + 24*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim) + 16*m2**6*m6sq*B0fin(0,0,m2sq,mudim) - 8*m1**4*m2sq*m6sq*B0fin(0,0,m2sq,mudim) - 2*m1**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 14*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 24*m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 8*m1**4*m2sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 6*m1**4*m2**4*B0fin(0,0,m2sq,mudim)**2 + 6*m1sq*m2**6*B0fin(0,0,m2sq,mudim)**2 - 2*m2**8*B0fin(0,0,m2sq,mudim)**2 + 2*m1**6*m2sq*B0fin(0,0,m2sq,mudim)**2 + 2*m1**4*m6**4*B0fin(0,0,m2sq,mudim)**2 - 4*m2**4*m6**4*B0fin(0,0,m2sq,mudim)**2 + 2*m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim)**2 - m1sq*m6**6*B0fin(0,0,m2sq,mudim)**2 + m2sq*m6**6*B0fin(0,0,m2sq,mudim)**2 - m1**6*m6sq*B0fin(0,0,m2sq,mudim)**2 - 3*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)**2 + 5*m2**6*m6sq*B0fin(0,0,m2sq,mudim)**2 - m1**4*m2sq*m6sq*B0fin(0,0,m2sq,mudim)**2 - 6*m1**4*m6**4*B0fin(0,0,m6sq,mudim) - 6*m2**4*m6**4*B0fin(0,0,m6sq,mudim) + 12*m1sq*m2sq*m6**4*B0fin(0,0,m6sq,mudim) + 2*m1**6*m6sq*B0fin(0,0,m6sq,mudim) - 10*m1sq*m2**4*m6sq*B0fin(0,0,m6sq,mudim) + 6*m2**6*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1**4*m2sq*m6sq*B0fin(0,0,m6sq,mudim) - 4*m1**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 16*m1**4*m2sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m1**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 6*m2**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m2**6*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 14*m1**4*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1sq*m2**4*T134fin(m2,m1,0,mudim) + 8*m2**6*T134fin(m2,m1,0,mudim) + 8*m1**4*m2sq*T134fin(m2,m1,0,mudim) + 4*m1sq*m6**4*T134fin(m2,m1,0,mudim) + 12*m2sq*m6**4*T134fin(m2,m1,0,mudim) - 2*m6**6*T134fin(m2,m1,0,mudim) - 2*m1**4*m6sq*T134fin(m2,m1,0,mudim) - 18*m2**4*m6sq*T134fin(m2,m1,0,mudim) - 12*m1sq*m2sq*m6sq*T134fin(m2,m1,0,mudim) + 16*m1sq*m2**4*T134fin(m6,m2,m1,mudim) - 8*m2**6*T134fin(m6,m2,m1,mudim) - 8*m1**4*m2sq*T134fin(m6,m2,m1,mudim) + 2*m1sq*m6**4*T134fin(m6,m2,m1,mudim) - 2*m2sq*m6**4*T134fin(m6,m2,m1,mudim) + 2*m1**4*m6sq*T134fin(m6,m2,m1,mudim) + 10*m2**4*m6sq*T134fin(m6,m2,m1,mudim) - 12*m1sq*m2sq*m6sq*T134fin(m6,m2,m1,mudim) - 2*m1**6*T134fin(m6,m2,m2,mudim) - 6*m1sq*m2**4*T134fin(m6,m2,m2,mudim) + 2*m2**6*T134fin(m6,m2,m2,mudim) + 6*m1**4*m2sq*T134fin(m6,m2,m2,mudim) - 2*m1sq*m6**4*T134fin(m6,m2,m2,mudim) + 2*m2sq*m6**4*T134fin(m6,m2,m2,mudim) + 4*m1**4*m6sq*T134fin(m6,m2,m2,mudim) - 4*m2**4*m6sq*T134fin(m6,m2,m2,mudim))/(2.*(m1sq - m2sq)**2*m6**2*(4*m2sq - m6sq)*(m1**4 + (m2sq - m6sq)**2 - 2*m1sq*(m2sq + m6sq)))
		def eval_67():
			return (-12*m1**4*m2**4 + 12*m1sq*m2**6 - 4*m2**8 + 4*m1**6*m2sq - 12*m1**4*m4**4 - 20*m2**4*m4**4 + 2*m1sq*m4**6 + 2*m2sq*m4**6 + 2*m1**6*m4sq + 22*m1sq*m2**4*m4sq + 22*m2**6*m4sq + 18*m1**4*m2sq*m4sq - 2*m1sq*(3*m1sq + m2sq - m4sq)*m4sq*(-4*m2sq + m4sq)*B0del(0,0,m1sq,mudim) + 2*m2sq*(2*m1**6 - 2*m2**6 - 7*m2sq*m4**4 + m4**6 + 8*m2**4*m4sq - 2*m1**4*(3*m2sq + 2*m4sq) + m1sq*(6*m2**4 - m4**4 + 12*m2sq*m4sq))*B0del(0,0,m2sq,mudim) - 6*m1**4*m4**4*B0del(0,0,m4sq,mudim) - 6*m2**4*m4**4*B0del(0,0,m4sq,mudim) + 12*m1sq*m2sq*m4**4*B0del(0,0,m4sq,mudim) + 2*m1**6*m4sq*B0del(0,0,m4sq,mudim) - 10*m1sq*m2**4*m4sq*B0del(0,0,m4sq,mudim) + 6*m2**6*m4sq*B0del(0,0,m4sq,mudim) + 2*m1**4*m2sq*m4sq*B0del(0,0,m4sq,mudim) - 6*m1**4*m4**4*B0fin(0,0,m1sq,mudim) - 10*m1sq*m2sq*m4**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m4**6*B0fin(0,0,m1sq,mudim) + 8*m1sq*m2**4*m4sq*B0fin(0,0,m1sq,mudim) + 24*m1**4*m2sq*m4sq*B0fin(0,0,m1sq,mudim) - 12*m1**4*m2**4*B0fin(0,0,m2sq,mudim) + 12*m1sq*m2**6*B0fin(0,0,m2sq,mudim) - 4*m2**8*B0fin(0,0,m2sq,mudim) + 4*m1**6*m2sq*B0fin(0,0,m2sq,mudim) - 14*m2**4*m4**4*B0fin(0,0,m2sq,mudim) - 2*m1sq*m2sq*m4**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m4**6*B0fin(0,0,m2sq,mudim) + 24*m1sq*m2**4*m4sq*B0fin(0,0,m2sq,mudim) + 16*m2**6*m4sq*B0fin(0,0,m2sq,mudim) - 8*m1**4*m2sq*m4sq*B0fin(0,0,m2sq,mudim) - 2*m1**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 14*m1sq*m2sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m1sq*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 24*m1sq*m2**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 8*m1**4*m2sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 6*m1**4*m2**4*B0fin(0,0,m2sq,mudim)**2 + 6*m1sq*m2**6*B0fin(0,0,m2sq,mudim)**2 - 2*m2**8*B0fin(0,0,m2sq,mudim)**2 + 2*m1**6*m2sq*B0fin(0,0,m2sq,mudim)**2 + 2*m1**4*m4**4*B0fin(0,0,m2sq,mudim)**2 - 4*m2**4*m4**4*B0fin(0,0,m2sq,mudim)**2 + 2*m1sq*m2sq*m4**4*B0fin(0,0,m2sq,mudim)**2 - m1sq*m4**6*B0fin(0,0,m2sq,mudim)**2 + m2sq*m4**6*B0fin(0,0,m2sq,mudim)**2 - m1**6*m4sq*B0fin(0,0,m2sq,mudim)**2 - 3*m1sq*m2**4*m4sq*B0fin(0,0,m2sq,mudim)**2 + 5*m2**6*m4sq*B0fin(0,0,m2sq,mudim)**2 - m1**4*m2sq*m4sq*B0fin(0,0,m2sq,mudim)**2 - 6*m1**4*m4**4*B0fin(0,0,m4sq,mudim) - 6*m2**4*m4**4*B0fin(0,0,m4sq,mudim) + 12*m1sq*m2sq*m4**4*B0fin(0,0,m4sq,mudim) + 2*m1**6*m4sq*B0fin(0,0,m4sq,mudim) - 10*m1sq*m2**4*m4sq*B0fin(0,0,m4sq,mudim) + 6*m2**6*m4sq*B0fin(0,0,m4sq,mudim) + 2*m1**4*m2sq*m4sq*B0fin(0,0,m4sq,mudim) - 4*m1**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1sq*m2sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 16*m1sq*m2**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 16*m1**4*m2sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m1**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m1sq*m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m1**6*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1sq*m2**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m2**6*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 14*m1**4*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 16*m1sq*m2**4*T134fin(m2,m1,0,mudim) + 8*m2**6*T134fin(m2,m1,0,mudim) + 8*m1**4*m2sq*T134fin(m2,m1,0,mudim) + 4*m1sq*m4**4*T134fin(m2,m1,0,mudim) + 12*m2sq*m4**4*T134fin(m2,m1,0,mudim) - 2*m4**6*T134fin(m2,m1,0,mudim) - 2*m1**4*m4sq*T134fin(m2,m1,0,mudim) - 18*m2**4*m4sq*T134fin(m2,m1,0,mudim) - 12*m1sq*m2sq*m4sq*T134fin(m2,m1,0,mudim) + 16*m1sq*m2**4*T134fin(m4,m2,m1,mudim) - 8*m2**6*T134fin(m4,m2,m1,mudim) - 8*m1**4*m2sq*T134fin(m4,m2,m1,mudim) + 2*m1sq*m4**4*T134fin(m4,m2,m1,mudim) - 2*m2sq*m4**4*T134fin(m4,m2,m1,mudim) + 2*m1**4*m4sq*T134fin(m4,m2,m1,mudim) + 10*m2**4*m4sq*T134fin(m4,m2,m1,mudim) - 12*m1sq*m2sq*m4sq*T134fin(m4,m2,m1,mudim) - 2*m1**6*T134fin(m4,m2,m2,mudim) - 6*m1sq*m2**4*T134fin(m4,m2,m2,mudim) + 2*m2**6*T134fin(m4,m2,m2,mudim) + 6*m1**4*m2sq*T134fin(m4,m2,m2,mudim) - 2*m1sq*m4**4*T134fin(m4,m2,m2,mudim) + 2*m2sq*m4**4*T134fin(m4,m2,m2,mudim) + 4*m1**4*m4sq*T134fin(m4,m2,m2,mudim) - 4*m2**4*m4sq*T134fin(m4,m2,m2,mudim))/(2.*(m1sq - m2sq)**2*m4**2*(4*m2sq - m4sq)*(m1**4 + (m2sq - m4sq)**2 - 2*m1sq*(m2sq + m4sq)))
		def eval_68():
			return -0.5*(-4*m1**8 - 20*m1**4*m4**4 + 2*m1sq*m4**6 + 22*m1**6*m4sq - 12*m1**4*m6**4 - 12*m4**4*m6**4 + 18*m1sq*m4sq*m6**4 + 4*m1sq*m6**6 + 2*m4sq*m6**6 + 12*m1**6*m6sq + 2*m4**6*m6sq + 22*m1**4*m4sq*m6sq - 2*m1sq*(2*m1**6 - m4**6 + 4*m4sq*m6**4 - 2*m6**6 + m4**4*m6sq - 2*m1**4*(4*m4sq + 3*m6sq) + m1sq*(7*m4**4 + 6*m6**4 - 12*m4sq*m6sq))*B0del(0,0,m1sq,mudim) + 2*m4sq*(m1sq - m6sq)**2*(3*m1sq - 3*m4sq + m6sq)*B0del(0,0,m4sq,mudim) - 6*m4**4*m6**4*B0del(0,0,m6sq,mudim) + 24*m1sq*m4sq*m6**4*B0del(0,0,m6sq,mudim) - 10*m1sq*m4**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m4**6*m6sq*B0del(0,0,m6sq,mudim) + 8*m1**4*m4sq*m6sq*B0del(0,0,m6sq,mudim) - 4*m1**8*B0fin(0,0,m1sq,mudim) - 14*m1**4*m4**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m4**6*B0fin(0,0,m1sq,mudim) + 16*m1**6*m4sq*B0fin(0,0,m1sq,mudim) - 12*m1**4*m6**4*B0fin(0,0,m1sq,mudim) - 8*m1sq*m4sq*m6**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m6**6*B0fin(0,0,m1sq,mudim) + 12*m1**6*m6sq*B0fin(0,0,m1sq,mudim) - 2*m1sq*m4**4*m6sq*B0fin(0,0,m1sq,mudim) + 24*m1**4*m4sq*m6sq*B0fin(0,0,m1sq,mudim) - 2*m1**8*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m4**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m4**6*B0fin(0,0,m1sq,mudim)**2 + 5*m1**6*m4sq*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m6**4*B0fin(0,0,m1sq,mudim)**2 + 2*m4**4*m6**4*B0fin(0,0,m1sq,mudim)**2 - m1sq*m4sq*m6**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m6**6*B0fin(0,0,m1sq,mudim)**2 - m4sq*m6**6*B0fin(0,0,m1sq,mudim)**2 + 6*m1**6*m6sq*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m4**4*m6sq*B0fin(0,0,m1sq,mudim)**2 - m4**6*m6sq*B0fin(0,0,m1sq,mudim)**2 - 3*m1**4*m4sq*m6sq*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m4**4*B0fin(0,0,m4sq,mudim) + 6*m1**6*m4sq*B0fin(0,0,m4sq,mudim) - 6*m4**4*m6**4*B0fin(0,0,m4sq,mudim) + 2*m1sq*m4sq*m6**4*B0fin(0,0,m4sq,mudim) + 2*m4sq*m6**6*B0fin(0,0,m4sq,mudim) + 12*m1sq*m4**4*m6sq*B0fin(0,0,m4sq,mudim) - 10*m1**4*m4sq*m6sq*B0fin(0,0,m4sq,mudim) - 6*m1**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**6*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m4**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 14*m1sq*m4sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m4sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m1sq*m4**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m4**4*m6**4*B0fin(0,0,m6sq,mudim) + 24*m1sq*m4sq*m6**4*B0fin(0,0,m6sq,mudim) - 10*m1sq*m4**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m4**6*m6sq*B0fin(0,0,m6sq,mudim) + 8*m1**4*m4sq*m6sq*B0fin(0,0,m6sq,mudim) - 2*m4**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1sq*m4sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 14*m1sq*m4**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m4**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 24*m1**4*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m4**4*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 16*m1sq*m4sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m4**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1**4*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1**6*T134fin(m4,m1,m1,mudim) + 2*m1sq*m4**4*T134fin(m4,m1,m1,mudim) - 4*m1**4*m4sq*T134fin(m4,m1,m1,mudim) + 6*m1sq*m6**4*T134fin(m4,m1,m1,mudim) + 4*m4sq*m6**4*T134fin(m4,m1,m1,mudim) - 2*m6**6*T134fin(m4,m1,m1,mudim) - 6*m1**4*m6sq*T134fin(m4,m1,m1,mudim) - 2*m4**4*m6sq*T134fin(m4,m1,m1,mudim) + 8*m1**6*T134fin(m6,m1,0,mudim) + 12*m1sq*m4**4*T134fin(m6,m1,0,mudim) - 2*m4**6*T134fin(m6,m1,0,mudim) - 18*m1**4*m4sq*T134fin(m6,m1,0,mudim) + 8*m1sq*m6**4*T134fin(m6,m1,0,mudim) - 2*m4sq*m6**4*T134fin(m6,m1,0,mudim) - 16*m1**4*m6sq*T134fin(m6,m1,0,mudim) + 4*m4**4*m6sq*T134fin(m6,m1,0,mudim) - 12*m1sq*m4sq*m6sq*T134fin(m6,m1,0,mudim) - 8*m1**6*T134fin(m6,m4,m1,mudim) - 2*m1sq*m4**4*T134fin(m6,m4,m1,mudim) + 10*m1**4*m4sq*T134fin(m6,m4,m1,mudim) - 8*m1sq*m6**4*T134fin(m6,m4,m1,mudim) + 2*m4sq*m6**4*T134fin(m6,m4,m1,mudim) + 16*m1**4*m6sq*T134fin(m6,m4,m1,mudim) + 2*m4**4*m6sq*T134fin(m6,m4,m1,mudim) - 12*m1sq*m4sq*m6sq*T134fin(m6,m4,m1,mudim))/(m4**2*(-4*m1sq + m4sq)*(m1sq - m6sq)**2*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq)))
		def eval_69():
			return (-4*m1**8 - 12*m1**4*m4**4 + 4*m1sq*m4**6 + 12*m1**6*m4sq - 20*m1**4*m6**4 - 12*m4**4*m6**4 + 2*m1sq*m6**6 + 2*m4sq*m6**6 + 22*m1**6*m6sq + 18*m1sq*m4**4*m6sq + 2*m4**6*m6sq + 22*m1**4*m4sq*m6sq - 2*m1sq*(2*m1**6 - 2*m4**6 + m4sq*m6**4 - m6**6 + 4*m4**4*m6sq - 2*m1**4*(3*m4sq + 4*m6sq) + m1sq*(6*m4**4 + 7*m6**4 - 12*m4sq*m6sq))*B0del(0,0,m1sq,mudim) - 2*m4sq*(m1sq + 3*m4sq - m6sq)*m6sq*(-4*m1sq + m6sq)*B0del(0,0,m4sq,mudim) - 6*m1**4*m6**4*B0del(0,0,m6sq,mudim) - 6*m4**4*m6**4*B0del(0,0,m6sq,mudim) + 12*m1sq*m4sq*m6**4*B0del(0,0,m6sq,mudim) + 6*m1**6*m6sq*B0del(0,0,m6sq,mudim) + 2*m1sq*m4**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m4**6*m6sq*B0del(0,0,m6sq,mudim) - 10*m1**4*m4sq*m6sq*B0del(0,0,m6sq,mudim) - 4*m1**8*B0fin(0,0,m1sq,mudim) - 12*m1**4*m4**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m4**6*B0fin(0,0,m1sq,mudim) + 12*m1**6*m4sq*B0fin(0,0,m1sq,mudim) - 14*m1**4*m6**4*B0fin(0,0,m1sq,mudim) - 2*m1sq*m4sq*m6**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m6**6*B0fin(0,0,m1sq,mudim) + 16*m1**6*m6sq*B0fin(0,0,m1sq,mudim) - 8*m1sq*m4**4*m6sq*B0fin(0,0,m1sq,mudim) + 24*m1**4*m4sq*m6sq*B0fin(0,0,m1sq,mudim) - 2*m1**8*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m4**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m4**6*B0fin(0,0,m1sq,mudim)**2 + 6*m1**6*m4sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m6**4*B0fin(0,0,m1sq,mudim)**2 + 2*m4**4*m6**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m4sq*m6**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m6**6*B0fin(0,0,m1sq,mudim)**2 - m4sq*m6**6*B0fin(0,0,m1sq,mudim)**2 + 5*m1**6*m6sq*B0fin(0,0,m1sq,mudim)**2 - m1sq*m4**4*m6sq*B0fin(0,0,m1sq,mudim)**2 - m4**6*m6sq*B0fin(0,0,m1sq,mudim)**2 - 3*m1**4*m4sq*m6sq*B0fin(0,0,m1sq,mudim)**2 - 6*m4**4*m6**4*B0fin(0,0,m4sq,mudim) - 10*m1sq*m4sq*m6**4*B0fin(0,0,m4sq,mudim) + 2*m4sq*m6**6*B0fin(0,0,m4sq,mudim) + 24*m1sq*m4**4*m6sq*B0fin(0,0,m4sq,mudim) + 8*m1**4*m4sq*m6sq*B0fin(0,0,m4sq,mudim) - 2*m4**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 14*m1sq*m4sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m4sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m1sq*m4**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 24*m1**4*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 6*m1**4*m6**4*B0fin(0,0,m6sq,mudim) - 6*m4**4*m6**4*B0fin(0,0,m6sq,mudim) + 12*m1sq*m4sq*m6**4*B0fin(0,0,m6sq,mudim) + 6*m1**6*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1sq*m4**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m4**6*m6sq*B0fin(0,0,m6sq,mudim) - 10*m1**4*m4sq*m6sq*B0fin(0,0,m6sq,mudim) - 6*m1**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m4**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1sq*m4sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 14*m1sq*m4**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m4**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m4sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m4**4*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m4sq*m6**4*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 16*m1sq*m4**4*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1**4*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1**6*T134fin(m4,m1,0,mudim) + 8*m1sq*m4**4*T134fin(m4,m1,0,mudim) - 16*m1**4*m4sq*T134fin(m4,m1,0,mudim) + 12*m1sq*m6**4*T134fin(m4,m1,0,mudim) + 4*m4sq*m6**4*T134fin(m4,m1,0,mudim) - 2*m6**6*T134fin(m4,m1,0,mudim) - 18*m1**4*m6sq*T134fin(m4,m1,0,mudim) - 2*m4**4*m6sq*T134fin(m4,m1,0,mudim) - 12*m1sq*m4sq*m6sq*T134fin(m4,m1,0,mudim) + 2*m1**6*T134fin(m6,m1,m1,mudim) + 6*m1sq*m4**4*T134fin(m6,m1,m1,mudim) - 2*m4**6*T134fin(m6,m1,m1,mudim) - 6*m1**4*m4sq*T134fin(m6,m1,m1,mudim) + 2*m1sq*m6**4*T134fin(m6,m1,m1,mudim) - 2*m4sq*m6**4*T134fin(m6,m1,m1,mudim) - 4*m1**4*m6sq*T134fin(m6,m1,m1,mudim) + 4*m4**4*m6sq*T134fin(m6,m1,m1,mudim) - 8*m1**6*T134fin(m6,m4,m1,mudim) - 8*m1sq*m4**4*T134fin(m6,m4,m1,mudim) + 16*m1**4*m4sq*T134fin(m6,m4,m1,mudim) - 2*m1sq*m6**4*T134fin(m6,m4,m1,mudim) + 2*m4sq*m6**4*T134fin(m6,m4,m1,mudim) + 10*m1**4*m6sq*T134fin(m6,m4,m1,mudim) + 2*m4**4*m6sq*T134fin(m6,m4,m1,mudim) - 12*m1sq*m4sq*m6sq*T134fin(m6,m4,m1,mudim))/(2.*(m1sq - m4sq)**2*m6**2*(4*m1sq - m6sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq)))
		def eval_70():
			return (-4*m1**8 - 12*m1**4*m2**4 + 4*m1sq*m2**6 + 12*m1**6*m2sq - 20*m1**4*m6**4 - 12*m2**4*m6**4 + 2*m1sq*m6**6 + 2*m2sq*m6**6 + 22*m1**6*m6sq + 18*m1sq*m2**4*m6sq + 2*m2**6*m6sq + 22*m1**4*m2sq*m6sq - 2*m1sq*(2*m1**6 - 2*m2**6 + m2sq*m6**4 - m6**6 + 4*m2**4*m6sq - 2*m1**4*(3*m2sq + 4*m6sq) + m1sq*(6*m2**4 + 7*m6**4 - 12*m2sq*m6sq))*B0del(0,0,m1sq,mudim) - 2*m2sq*(m1sq + 3*m2sq - m6sq)*m6sq*(-4*m1sq + m6sq)*B0del(0,0,m2sq,mudim) - 6*m1**4*m6**4*B0del(0,0,m6sq,mudim) - 6*m2**4*m6**4*B0del(0,0,m6sq,mudim) + 12*m1sq*m2sq*m6**4*B0del(0,0,m6sq,mudim) + 6*m1**6*m6sq*B0del(0,0,m6sq,mudim) + 2*m1sq*m2**4*m6sq*B0del(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0del(0,0,m6sq,mudim) - 10*m1**4*m2sq*m6sq*B0del(0,0,m6sq,mudim) - 4*m1**8*B0fin(0,0,m1sq,mudim) - 12*m1**4*m2**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2**6*B0fin(0,0,m1sq,mudim) + 12*m1**6*m2sq*B0fin(0,0,m1sq,mudim) - 14*m1**4*m6**4*B0fin(0,0,m1sq,mudim) - 2*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m6**6*B0fin(0,0,m1sq,mudim) + 16*m1**6*m6sq*B0fin(0,0,m1sq,mudim) - 8*m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim) + 24*m1**4*m2sq*m6sq*B0fin(0,0,m1sq,mudim) - 2*m1**8*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m2**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m2**6*B0fin(0,0,m1sq,mudim)**2 + 6*m1**6*m2sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m6**4*B0fin(0,0,m1sq,mudim)**2 + 2*m2**4*m6**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m6**6*B0fin(0,0,m1sq,mudim)**2 - m2sq*m6**6*B0fin(0,0,m1sq,mudim)**2 + 5*m1**6*m6sq*B0fin(0,0,m1sq,mudim)**2 - m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim)**2 - m2**6*m6sq*B0fin(0,0,m1sq,mudim)**2 - 3*m1**4*m2sq*m6sq*B0fin(0,0,m1sq,mudim)**2 - 6*m2**4*m6**4*B0fin(0,0,m2sq,mudim) - 10*m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m6**6*B0fin(0,0,m2sq,mudim) + 24*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim) + 8*m1**4*m2sq*m6sq*B0fin(0,0,m2sq,mudim) - 2*m2**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 14*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m2sq*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 8*m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 24*m1**4*m2sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 6*m1**4*m6**4*B0fin(0,0,m6sq,mudim) - 6*m2**4*m6**4*B0fin(0,0,m6sq,mudim) + 12*m1sq*m2sq*m6**4*B0fin(0,0,m6sq,mudim) + 6*m1**6*m6sq*B0fin(0,0,m6sq,mudim) + 2*m1sq*m2**4*m6sq*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0fin(0,0,m6sq,mudim) - 10*m1**4*m2sq*m6sq*B0fin(0,0,m6sq,mudim) - 6*m1**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m2**4*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1sq*m2sq*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 14*m1sq*m2**4*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m2**6*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 6*m1**4*m2sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - 4*m2**4*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 4*m1sq*m2sq*m6**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 16*m1sq*m2**4*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) - 16*m1**4*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim) + 8*m1**6*T134fin(m2,m1,0,mudim) + 8*m1sq*m2**4*T134fin(m2,m1,0,mudim) - 16*m1**4*m2sq*T134fin(m2,m1,0,mudim) + 12*m1sq*m6**4*T134fin(m2,m1,0,mudim) + 4*m2sq*m6**4*T134fin(m2,m1,0,mudim) - 2*m6**6*T134fin(m2,m1,0,mudim) - 18*m1**4*m6sq*T134fin(m2,m1,0,mudim) - 2*m2**4*m6sq*T134fin(m2,m1,0,mudim) - 12*m1sq*m2sq*m6sq*T134fin(m2,m1,0,mudim) + 2*m1**6*T134fin(m6,m1,m1,mudim) + 6*m1sq*m2**4*T134fin(m6,m1,m1,mudim) - 2*m2**6*T134fin(m6,m1,m1,mudim) - 6*m1**4*m2sq*T134fin(m6,m1,m1,mudim) + 2*m1sq*m6**4*T134fin(m6,m1,m1,mudim) - 2*m2sq*m6**4*T134fin(m6,m1,m1,mudim) - 4*m1**4*m6sq*T134fin(m6,m1,m1,mudim) + 4*m2**4*m6sq*T134fin(m6,m1,m1,mudim) - 8*m1**6*T134fin(m6,m2,m1,mudim) - 8*m1sq*m2**4*T134fin(m6,m2,m1,mudim) + 16*m1**4*m2sq*T134fin(m6,m2,m1,mudim) - 2*m1sq*m6**4*T134fin(m6,m2,m1,mudim) + 2*m2sq*m6**4*T134fin(m6,m2,m1,mudim) + 10*m1**4*m6sq*T134fin(m6,m2,m1,mudim) + 2*m2**4*m6sq*T134fin(m6,m2,m1,mudim) - 12*m1sq*m2sq*m6sq*T134fin(m6,m2,m1,mudim))/(2.*(m1sq - m2sq)**2*m6**2*(4*m1sq - m6sq)*(m1**4 + (m2sq - m6sq)**2 - 2*m1sq*(m2sq + m6sq)))
		def eval_71():
			return (-4*m1**8 - 12*m1**4*m2**4 + 4*m1sq*m2**6 + 12*m1**6*m2sq - 20*m1**4*m4**4 - 12*m2**4*m4**4 + 2*m1sq*m4**6 + 2*m2sq*m4**6 + 22*m1**6*m4sq + 18*m1sq*m2**4*m4sq + 2*m2**6*m4sq + 22*m1**4*m2sq*m4sq - 2*m1sq*(2*m1**6 - 2*m2**6 + m2sq*m4**4 - m4**6 + 4*m2**4*m4sq - 2*m1**4*(3*m2sq + 4*m4sq) + m1sq*(6*m2**4 + 7*m4**4 - 12*m2sq*m4sq))*B0del(0,0,m1sq,mudim) - 2*m2sq*(m1sq + 3*m2sq - m4sq)*m4sq*(-4*m1sq + m4sq)*B0del(0,0,m2sq,mudim) - 6*m1**4*m4**4*B0del(0,0,m4sq,mudim) - 6*m2**4*m4**4*B0del(0,0,m4sq,mudim) + 12*m1sq*m2sq*m4**4*B0del(0,0,m4sq,mudim) + 6*m1**6*m4sq*B0del(0,0,m4sq,mudim) + 2*m1sq*m2**4*m4sq*B0del(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0del(0,0,m4sq,mudim) - 10*m1**4*m2sq*m4sq*B0del(0,0,m4sq,mudim) - 4*m1**8*B0fin(0,0,m1sq,mudim) - 12*m1**4*m2**4*B0fin(0,0,m1sq,mudim) + 4*m1sq*m2**6*B0fin(0,0,m1sq,mudim) + 12*m1**6*m2sq*B0fin(0,0,m1sq,mudim) - 14*m1**4*m4**4*B0fin(0,0,m1sq,mudim) - 2*m1sq*m2sq*m4**4*B0fin(0,0,m1sq,mudim) + 2*m1sq*m4**6*B0fin(0,0,m1sq,mudim) + 16*m1**6*m4sq*B0fin(0,0,m1sq,mudim) - 8*m1sq*m2**4*m4sq*B0fin(0,0,m1sq,mudim) + 24*m1**4*m2sq*m4sq*B0fin(0,0,m1sq,mudim) - 2*m1**8*B0fin(0,0,m1sq,mudim)**2 - 6*m1**4*m2**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m2**6*B0fin(0,0,m1sq,mudim)**2 + 6*m1**6*m2sq*B0fin(0,0,m1sq,mudim)**2 - 4*m1**4*m4**4*B0fin(0,0,m1sq,mudim)**2 + 2*m2**4*m4**4*B0fin(0,0,m1sq,mudim)**2 + 2*m1sq*m2sq*m4**4*B0fin(0,0,m1sq,mudim)**2 + m1sq*m4**6*B0fin(0,0,m1sq,mudim)**2 - m2sq*m4**6*B0fin(0,0,m1sq,mudim)**2 + 5*m1**6*m4sq*B0fin(0,0,m1sq,mudim)**2 - m1sq*m2**4*m4sq*B0fin(0,0,m1sq,mudim)**2 - m2**6*m4sq*B0fin(0,0,m1sq,mudim)**2 - 3*m1**4*m2sq*m4sq*B0fin(0,0,m1sq,mudim)**2 - 6*m2**4*m4**4*B0fin(0,0,m2sq,mudim) - 10*m1sq*m2sq*m4**4*B0fin(0,0,m2sq,mudim) + 2*m2sq*m4**6*B0fin(0,0,m2sq,mudim) + 24*m1sq*m2**4*m4sq*B0fin(0,0,m2sq,mudim) + 8*m1**4*m2sq*m4sq*B0fin(0,0,m2sq,mudim) - 2*m2**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 14*m1sq*m2sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 2*m2sq*m4**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 8*m1sq*m2**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) + 24*m1**4*m2sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m2sq,mudim) - 6*m1**4*m4**4*B0fin(0,0,m4sq,mudim) - 6*m2**4*m4**4*B0fin(0,0,m4sq,mudim) + 12*m1sq*m2sq*m4**4*B0fin(0,0,m4sq,mudim) + 6*m1**6*m4sq*B0fin(0,0,m4sq,mudim) + 2*m1sq*m2**4*m4sq*B0fin(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0fin(0,0,m4sq,mudim) - 10*m1**4*m2sq*m4sq*B0fin(0,0,m4sq,mudim) - 6*m1**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 2*m2**4*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m1sq*m2sq*m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**6*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 14*m1sq*m2**4*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m2**6*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 6*m1**4*m2sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - 4*m2**4*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 4*m1sq*m2sq*m4**4*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 16*m1sq*m2**4*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) - 16*m1**4*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim) + 8*m1**6*T134fin(m2,m1,0,mudim) + 8*m1sq*m2**4*T134fin(m2,m1,0,mudim) - 16*m1**4*m2sq*T134fin(m2,m1,0,mudim) + 12*m1sq*m4**4*T134fin(m2,m1,0,mudim) + 4*m2sq*m4**4*T134fin(m2,m1,0,mudim) - 2*m4**6*T134fin(m2,m1,0,mudim) - 18*m1**4*m4sq*T134fin(m2,m1,0,mudim) - 2*m2**4*m4sq*T134fin(m2,m1,0,mudim) - 12*m1sq*m2sq*m4sq*T134fin(m2,m1,0,mudim) + 2*m1**6*T134fin(m4,m1,m1,mudim) + 6*m1sq*m2**4*T134fin(m4,m1,m1,mudim) - 2*m2**6*T134fin(m4,m1,m1,mudim) - 6*m1**4*m2sq*T134fin(m4,m1,m1,mudim) + 2*m1sq*m4**4*T134fin(m4,m1,m1,mudim) - 2*m2sq*m4**4*T134fin(m4,m1,m1,mudim) - 4*m1**4*m4sq*T134fin(m4,m1,m1,mudim) + 4*m2**4*m4sq*T134fin(m4,m1,m1,mudim) - 8*m1**6*T134fin(m4,m2,m1,mudim) - 8*m1sq*m2**4*T134fin(m4,m2,m1,mudim) + 16*m1**4*m2sq*T134fin(m4,m2,m1,mudim) - 2*m1sq*m4**4*T134fin(m4,m2,m1,mudim) + 2*m2sq*m4**4*T134fin(m4,m2,m1,mudim) + 10*m1**4*m4sq*T134fin(m4,m2,m1,mudim) + 2*m2**4*m4sq*T134fin(m4,m2,m1,mudim) - 12*m1sq*m2sq*m4sq*T134fin(m4,m2,m1,mudim))/(2.*(m1sq - m2sq)**2*m4**2*(4*m1sq - m4sq)*(m1**4 + (m2sq - m4sq)**2 - 2*m1sq*(m2sq + m4sq)))
		def eval_72():
			return -((-16*m1**4*m3**4 + 8*m1sq*m3**6 + 8*m1**6*m3sq - 16*m1**4*m5**4 - 16*m3**4*m5**4 + 8*m1sq*m5**6 + 8*m3sq*m5**6 + 8*m1**6*m5sq + 8*m3**6*m5sq + 2*(m1**8 - m1**6*(m3sq + m5sq) + m1sq*(m3sq - m5sq)**2*(m3sq + m5sq) - m1**4*(m3**4 + m5**4 - 6*m3sq*m5sq))*B0del(0,0,m1sq,mudim) + 2*m3sq*(m1**6 - m1**4*(m3sq + m5sq) + (m3sq - m5sq)**2*(m3sq + m5sq) - m1sq*(m3**4 + m5**4 - 6*m3sq*m5sq))*B0del(0,0,m3sq,mudim) - 2*m1**4*m5**4*B0del(0,0,m5sq,mudim) - 2*m3**4*m5**4*B0del(0,0,m5sq,mudim) + 12*m1sq*m3sq*m5**4*B0del(0,0,m5sq,mudim) - 2*m1sq*m5**6*B0del(0,0,m5sq,mudim) - 2*m3sq*m5**6*B0del(0,0,m5sq,mudim) + 2*m5**8*B0del(0,0,m5sq,mudim) + 2*m1**6*m5sq*B0del(0,0,m5sq,mudim) - 2*m1sq*m3**4*m5sq*B0del(0,0,m5sq,mudim) + 2*m3**6*m5sq*B0del(0,0,m5sq,mudim) - 2*m1**4*m3sq*m5sq*B0del(0,0,m5sq,mudim) - 2*m1**8*B0fin(0,0,m1sq,mudim) - 8*m1**4*m3**4*B0fin(0,0,m1sq,mudim) + 2*m3**8*B0fin(0,0,m1sq,mudim) + 8*m1**6*m3sq*B0fin(0,0,m1sq,mudim) - 8*m1**4*m5**4*B0fin(0,0,m1sq,mudim) + 12*m3**4*m5**4*B0fin(0,0,m1sq,mudim) - 8*m3sq*m5**6*B0fin(0,0,m1sq,mudim) + 2*m5**8*B0fin(0,0,m1sq,mudim) + 8*m1**6*m5sq*B0fin(0,0,m1sq,mudim) - 8*m3**6*m5sq*B0fin(0,0,m1sq,mudim) + 8*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim) + 2*m1**8*B0fin(0,0,m3sq,mudim) - 8*m1**4*m3**4*B0fin(0,0,m3sq,mudim) + 8*m1sq*m3**6*B0fin(0,0,m3sq,mudim) - 2*m3**8*B0fin(0,0,m3sq,mudim) + 12*m1**4*m5**4*B0fin(0,0,m3sq,mudim) - 8*m3**4*m5**4*B0fin(0,0,m3sq,mudim) - 8*m1sq*m5**6*B0fin(0,0,m3sq,mudim) + 2*m5**8*B0fin(0,0,m3sq,mudim) - 8*m1**6*m5sq*B0fin(0,0,m3sq,mudim) + 8*m1sq*m3**4*m5sq*B0fin(0,0,m3sq,mudim) + 8*m3**6*m5sq*B0fin(0,0,m3sq,mudim) + m1**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1**4*m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m3**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 8*m1sq*m3sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m3sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 6*m1sq*m3**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m3**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 6*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1**8*B0fin(0,0,m5sq,mudim) + 12*m1**4*m3**4*B0fin(0,0,m5sq,mudim) - 8*m1sq*m3**6*B0fin(0,0,m5sq,mudim) + 2*m3**8*B0fin(0,0,m5sq,mudim) - 8*m1**6*m3sq*B0fin(0,0,m5sq,mudim) - 8*m1**4*m5**4*B0fin(0,0,m5sq,mudim) - 8*m3**4*m5**4*B0fin(0,0,m5sq,mudim) + 8*m1sq*m3sq*m5**4*B0fin(0,0,m5sq,mudim) + 8*m1sq*m5**6*B0fin(0,0,m5sq,mudim) + 8*m3sq*m5**6*B0fin(0,0,m5sq,mudim) - 2*m5**8*B0fin(0,0,m5sq,mudim) + m1**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m3**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m3**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**6*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1sq*m3sq*m5**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m3sq*m5**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m5**8*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m1sq*m3**4*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m3**6*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1**4*m3sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m3**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m3**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**6*m3sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m3**4*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1sq*m3sq*m5**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m5**8*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**6*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 6*m1sq*m3**4*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 8*m1**4*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**6*T134fin(m5,m3,m1,mudim) + 2*m1sq*m3**4*T134fin(m5,m3,m1,mudim) - 2*m3**6*T134fin(m5,m3,m1,mudim) + 2*m1**4*m3sq*T134fin(m5,m3,m1,mudim) + 2*m1sq*m5**4*T134fin(m5,m3,m1,mudim) + 2*m3sq*m5**4*T134fin(m5,m3,m1,mudim) - 2*m5**6*T134fin(m5,m3,m1,mudim) + 2*m1**4*m5sq*T134fin(m5,m3,m1,mudim) + 2*m3**4*m5sq*T134fin(m5,m3,m1,mudim) - 12*m1sq*m3sq*m5sq*T134fin(m5,m3,m1,mudim))/(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))**3)
		def eval_73():
			return (-2*m2**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2 + 2*m2sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2 + 2*m2sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2 + 2*m1**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2 - 2*m1sq*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2 - 2*m1sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2 + 4*m2sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq - 4*m1sq*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq + 2*m1**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0del(0,0,m1sq,mudim) - 2*m1**4*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0del(0,0,m1sq,mudim) - 2*m1**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0del(0,0,m1sq,mudim) - 2*m2**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m2sq,mudim) + 2*m2**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m2sq,mudim) + 2*m2**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0del(0,0,m2sq,mudim) + 2*m2sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m3sq,mudim) - 2*m2**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m3sq,mudim) - 2*m1sq*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0del(0,0,m3sq,mudim) + 2*m1**4*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0del(0,0,m3sq,mudim) + 2*m2sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0del(0,0,m3sq,mudim) - 2*m1sq*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0del(0,0,m3sq,mudim) + 2*m2sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m5sq,mudim) - 2*m1sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0del(0,0,m5sq,mudim) - 2*m2**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0del(0,0,m5sq,mudim) + 2*m2sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0del(0,0,m5sq,mudim) + 2*m1**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0del(0,0,m5sq,mudim) - 2*m1sq*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0del(0,0,m5sq,mudim) - 2*m1sq*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) + 2*m1**4*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) - 2*m1sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) + 2*m1**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim) + 2*m2sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim) - 2*m2**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim) + 2*m2sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim) - 2*m2**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m2sq,mudim) - 4*m2sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m2sq,mudim) - m2**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + 3*m2sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) - m3**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) - m2**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) - 3*m2sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) - 3*m3sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + (m1 + m3 - m5)**2*m5**6*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + m1**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) - 3*m1sq*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + m3**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + m1**4*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + 3*m1sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + 3*m3sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) - (m2 + m3 - m5)**2*m5**6*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + 3*m2**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim) + 3*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim) + 4*m2sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim) - 3*m1**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim) - 3*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim) + m1**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1sq*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m1sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m2**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + m2sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - m2sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m2**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim) - m2**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m2sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + m3**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + 3*m2**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + 3*m2sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + 3*m3sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - (m1 + m3 - m5)**2*m5**6*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + m1**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + 3*m1sq*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - m3**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m1**4*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m1sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m3sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + (m2 + m3 - m5)**2*m5**6*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - m2**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) - 3*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) + 4*m2sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) + m1**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) + 3*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) - 4*m1sq*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) + m1**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m1sq*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m2**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) - m2sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + m2sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim) + m2**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m2sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m2sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**6*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m1sq*m3**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m1sq*(m2 + m3 - m5)**2*m5**4*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m2**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m2sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1**4*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*T134fin(m5,m3,m1,mudim) + 2*m1sq*m3sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*T134fin(m5,m3,m1,mudim) + 2*m1sq*(m2 + m3 - m5)**2*(m2 - m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2*m5sq*T134fin(m5,m3,m1,mudim) + 2*m2**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*T134fin(m5,m3,m2,mudim) - 2*m2sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*T134fin(m5,m3,m2,mudim) - 2*m2sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*T134fin(m5,m3,m2,mudim))/((m1sq - m2sq)*(m1 + m3 - m5)**2*(m2 + m3 - m5)**2*(m1 - m3 + m5)**2*(m2 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*(-m2 + m3 + m5)**2*(m2 + m3 + m5)**2)
		def eval_74():
			return (-2*m4**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2 + 2*m1**4*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2 + 2*m4sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2 + 2*m3**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2 - 2*m1**4*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2 - 2*m3sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2 + 4*m1sq*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq - 4*m1sq*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq - 2*m1sq*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m1sq,mudim) + 2*m1**4*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m1sq,mudim) + 2*m1sq*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0del(0,0,m1sq,mudim) - 2*m1**4*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0del(0,0,m1sq,mudim) + 2*m1sq*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0del(0,0,m1sq,mudim) - 2*m1sq*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0del(0,0,m1sq,mudim) - 2*m1sq*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0del(0,0,m3sq,mudim) + 2*m3**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0del(0,0,m3sq,mudim) - 2*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0del(0,0,m3sq,mudim) + 2*m1sq*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m4sq,mudim) - 2*m4**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m4sq,mudim) + 2*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0del(0,0,m4sq,mudim) + 2*m4sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0del(0,0,m5sq,mudim) - 2*m3sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0del(0,0,m5sq,mudim) - 2*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0del(0,0,m5sq,mudim) + 2*m1sq*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0del(0,0,m5sq,mudim) + 2*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0del(0,0,m5sq,mudim) - 2*m1sq*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0del(0,0,m5sq,mudim) - m1**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) - m1sq*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) - m4**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) + 3*m1**4*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) - 3*m1sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) - 3*m4sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) + (m1 + m3 - m5)**2*m5**6*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) + m1**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim) + m1sq*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim) + m3**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim) - 3*m1**4*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim) + 3*m1sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim) + 3*m3sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim) - (m1 + m4 - m5)**2*m5**6*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim) + 3*m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim) + 3*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim) - 3*m1**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim) - 3*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim) - 4*m1sq*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim) + 2*m1sq*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m3sq,mudim) - 2*m1**4*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m3sq,mudim) - 2*m3sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m3sq,mudim) + 2*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim) + 4*m1sq*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m3sq,mudim) + m3**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1**4*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m3sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1sq*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m4sq,mudim) + 2*m1**4*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m4sq,mudim) + 2*m4sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m4sq,mudim) - 2*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m4sq,mudim) - 4*m1sq*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m4sq,mudim) - m4**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**4*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m4sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + m1**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + 3*m1sq*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - m4**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m1**4*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + 3*m1sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) + 3*m4sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - (m1 + m3 - m5)**2*m5**6*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m5sq,mudim) - m1**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m1sq*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m5sq,mudim) + m3**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m5sq,mudim) + 3*m1**4*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m1sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m3sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m5sq,mudim) + (m1 + m4 - m5)**2*m5**6*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m5sq,mudim) - 3*m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) - m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) + 4*m1sq*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) + 3*m1**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) + m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) - 4*m1sq*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m5sq,mudim) - 2*m1sq*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m4**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m1**4*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m4sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m3**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**4*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m3sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m3**6*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m1**4*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m3sq*(m1 + m4 - m5)**2*m5**4*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + 2*m1sq*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - m4**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**4*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) + m4sq*(m1 + m3 - m5)**2*m5**4*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m3**4*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*T134fin(m5,m3,m1,mudim) + 2*m1sq*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*T134fin(m5,m3,m1,mudim) + 2*m3sq*(m1 + m4 - m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2*m5sq*T134fin(m5,m3,m1,mudim) + 2*m4**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*T134fin(m5,m4,m1,mudim) - 2*m1sq*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*T134fin(m5,m4,m1,mudim) - 2*m4sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m5sq*T134fin(m5,m4,m1,mudim))/((m3sq - m4sq)*(m1 + m3 - m5)**2*(m1 + m4 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*(m1 - m4 + m5)**2*(-m1 + m4 + m5)**2*(m1 + m4 + m5)**2)
		def eval_75():
			return (-2*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**6 + 2*m5**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2 - 2*m1**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2 - 2*m3**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2 - 4*m1sq*m3sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2 + 2*m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq + 2*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq + 4*m1sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq - 2*m1sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0del(0,0,m1sq,mudim) + 2*m1sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m1sq,mudim) - 2*m1**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m1sq,mudim) - 2*m1sq*m3sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m1sq,mudim) + 2*m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0del(0,0,m1sq,mudim) + 2*m1sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0del(0,0,m1sq,mudim) - 2*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0del(0,0,m3sq,mudim) + 2*m3sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m3sq,mudim) - 2*m3**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m3sq,mudim) - 2*m1sq*m3sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m3sq,mudim) + 2*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0del(0,0,m3sq,mudim) + 2*m1sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0del(0,0,m3sq,mudim) - 2*m1sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m5sq,mudim) - 2*m3sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m5sq,mudim) + 2*m5**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0del(0,0,m5sq,mudim) + 2*m1sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0del(0,0,m6sq,mudim) + 2*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0del(0,0,m6sq,mudim) - 2*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**6*B0del(0,0,m6sq,mudim) - m1**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) - 3*m1sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) + m3**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) + 3*m1**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m1sq,mudim) - m1sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m1sq,mudim) + 3*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m1sq,mudim) - (m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**6*B0fin(0,0,m1sq,mudim) + m1**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) + 3*m1sq*m3**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) - m3**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) - 3*m1**4*m3sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) + m1sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) - 3*m3sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) + m5**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) - 3*m1**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) + 3*m3**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) - 4*m1sq*m3sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim) + 3*m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m1sq,mudim) - 3*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m1sq,mudim) + 4*m1sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m1sq,mudim) + m1**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + 3*m1sq*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) - m3**6*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) - 3*m1**4*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*B0fin(0,0,m3sq,mudim) + 3*m1sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m3sq,mudim) - m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m3sq,mudim) - (m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**6*B0fin(0,0,m3sq,mudim) - m1**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) - 3*m1sq*m3**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) + m3**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) + 3*m1**4*m3sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) - 3*m1sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) + m3sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) + m5**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) + 3*m1**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) - 3*m3**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) - 4*m1sq*m3sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim) - 3*m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m3sq,mudim) + 3*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m3sq,mudim) + 4*m1sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m3sq,mudim) - 2*m1sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + (m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m3sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m5**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m3**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - 2*m1sq*m3sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + 2*m1sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m5sq,mudim) + 2*m3sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m5sq,mudim) - 2*m1**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m5sq,mudim) - 2*m3**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m5sq,mudim) + 4*m1sq*m3sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m5sq,mudim) - 2*m3sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m5**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - m1**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) + m3**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m5**6*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) + m1**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - m3**4*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim) - 2*m1sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m6sq,mudim) - 2*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m6sq,mudim) + 2*m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m6sq,mudim) - 4*m1sq*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m6sq,mudim) + 2*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - (m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**6*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) - m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim) + 2*m1sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - (m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**6*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - m1**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) + m3**4*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim) - 2*m5**4*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*T134fin(m5,m3,m1,mudim) + 2*m1sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*T134fin(m5,m3,m1,mudim) + 2*m3sq*m5sq*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*T134fin(m5,m3,m1,mudim) + 2*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6**4*T134fin(m6,m3,m1,mudim) - 2*m1sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*T134fin(m6,m3,m1,mudim) - 2*m3sq*(m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*m6sq*T134fin(m6,m3,m1,mudim))/((m1 + m3 - m5)**2*(m1 - m3 + m5)**2*(-m1 + m3 + m5)**2*(m1 + m3 + m5)**2*(m1 + m3 - m6)**2*(m1 - m3 + m6)**2*(-m1 + m3 + m6)**2*(m1 + m3 + m6)**2*(m5sq - m6sq))
		def eval_76():
			return (2*m1sq*m3sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*m1sq*m4sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) + (m1sq*(m1**4 + m3sq*m4sq - m5**4 - m1sq*(m3sq + m4sq - 4*m5sq))*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - (m1sq*m5sq*(2*m1sq - m3sq - m4sq + 2*m5sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - (2*m2sq*m3sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m2sq*m4sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m2sq*(m2**4 + m3sq*m4sq - m5**4 - m2sq*(m3sq + m4sq - 4*m5sq))*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m2sq*m5sq*(2*m2sq - m3sq - m4sq + 2*m5sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (2*m1sq*m3sq*B0del(0,0,m3sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*m2sq*m3sq*B0del(0,0,m3sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*(m3**4 + m1sq*(m2sq - m3sq) - m2sq*m3sq - m5**4 + 4*m3sq*m5sq)*B0del(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0del(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (2*m1sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) + (2*m2sq*m4sq*B0del(0,0,m4sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m4sq*(-m4**4 + m2sq*m4sq + m1sq*(-m2sq + m4sq) + m5**4 - 4*m4sq*m5sq)*B0del(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m4sq*m5sq*(m1sq + m2sq - 2*(m4sq + m5sq))*B0del(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0del(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (m1sq*m5sq*(2*m1sq - m3sq - m4sq + 2*m5sq)*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) + (m2sq*m5sq*(2*m2sq - m3sq - m4sq + 2*m5sq)*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m4sq*m5sq*(m1sq + m2sq - 2*(m4sq + m5sq))*B0del(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (2*m1sq*m3sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (2*m1sq*m4sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - (m1sq*(m1**4 + m3sq*m4sq - m5**4 - m1sq*(m3sq + m4sq - 4*m5sq))*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) + (m1sq*m5sq*(2*m1sq - m3sq - m4sq + 2*m5sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) + (2*m2sq*m3sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (2*m2sq*m4sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m2sq*(m2**4 + m3sq*m4sq - m5**4 - m2sq*(m3sq + m4sq - 4*m5sq))*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m2sq*m5sq*(2*m2sq - m3sq - m4sq + 2*m5sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (2*m1sq*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + (2*m2sq*m3sq*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (m3sq*(m3**4 + m1sq*(m2sq - m3sq) - m2sq*m3sq - m5**4 + 4*m3sq*m5sq)*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m1sq*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - (2*m2sq*m3sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (2*m1sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - (2*m2sq*m4sq*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m4sq*(m4**4 + m1sq*(m2sq - m4sq) - m2sq*m4sq - m5**4 + 4*m4sq*m5sq)*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m4sq*m5sq*(m1sq + m2sq - 2*(m4sq + m5sq))*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (2*m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) + (2*m2sq*m4sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m4sq,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m3sq*(m3**4 + m1sq*(m2sq - m3sq) - m2sq*m3sq - m5**4 + 4*m3sq*m5sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m1sq*(m1**4 + m3sq*m4sq - m5**4 - m1sq*(m3sq + m4sq - 4*m5sq))*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - (m2sq*(m2**4 + m3sq*m4sq - m5**4 - m2sq*(m3sq + m4sq - 4*m5sq))*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m4sq*(-m4**4 + m2sq*m4sq + m1sq*(-m2sq + m4sq) + m5**4 - 4*m4sq*m5sq)*(B0del(0,0,m5sq,mudim) - B0fin(0,0,m5sq,mudim)))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m1sq*m5sq*(2*m1sq - m3sq - m4sq + 2*m5sq)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - (m2sq*m5sq*(2*m2sq - m3sq - m4sq + 2*m5sq)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m4sq*m5sq*(m1sq + m2sq - 2*(m4sq + m5sq))*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m1sq*(m1**4 + m3sq*m4sq - m5**4 - m1sq*(m3sq + m4sq - 4*m5sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - (m1sq*m5sq*(2*m1sq - m3sq - m4sq + 2*m5sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - (m2sq*(m2**4 + m3sq*m4sq - m5**4 - m2sq*(m3sq + m4sq - 4*m5sq))*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m2sq*m5sq*(2*m2sq - m3sq - m4sq + 2*m5sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + (m3sq*(m3**4 + m1sq*(m2sq - m3sq) - m2sq*m3sq - m5**4 + 4*m3sq*m5sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + (m4sq*(-m4**4 + m2sq*m4sq + m1sq*(-m2sq + m4sq) + m5**4 - 4*m4sq*m5sq)*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - (m4sq*m5sq*(m1sq + m2sq - 2*(m4sq + m5sq))*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) + ((m1sq + m3sq - m5sq)*(m1sq + m3sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) - ((m2sq + m3sq - m5sq)*(m2sq + m3sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) - ((m1sq + m4sq - m5sq)*(m1sq + m4sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) + ((m2sq + m4sq - m5sq)*(m2sq + m4sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq))) - ((m1sq + m3sq - m5sq)*T134fin(m5,m3,m1,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))) + ((m2sq + m3sq - m5sq)*T134fin(m5,m3,m2,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))) + ((m1sq + m4sq - m5sq)*T134fin(m5,m4,m1,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))) - ((m2sq + m4sq - m5sq)*T134fin(m5,m4,m2,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m2**4 + (m4sq - m5sq)**2 - 2*m2sq*(m4sq + m5sq)))
		def eval_77():
			return (2*m1sq*m5sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (2*m1sq*m6sq*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m5sq - m6sq) + m5sq*m6sq)*B0del(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (2*m2sq*m5sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq - m6sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (2*m2sq*m6sq*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m5sq - m6sq) + m5sq*m6sq)*B0del(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0del(0,0,m3sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0del(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq - m6sq)*B0del(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (m3sq*m6sq*(m1sq + m2sq - 2*(m3sq + m6sq))*B0del(0,0,m3sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (2*m1sq*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) - (2*m2sq*m5sq*B0del(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m5sq*(-m3**4 + m5**4 + m1sq*(m2sq - m5sq) - m2sq*m5sq + 4*m3sq*m5sq)*B0del(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0del(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) - (2*m1sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (2*m2sq*m6sq*B0del(0,0,m6sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m6sq*(m3**4 - m6**4 + m2sq*m6sq - 4*m3sq*m6sq + m1sq*(-m2sq + m6sq))*B0del(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (m3sq*m6sq*(m1sq + m2sq - 2*(m3sq + m6sq))*B0del(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (2*m1sq*m5sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m5sq - m6sq) + m5sq*m6sq)*B0fin(0,0,m1sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (2*m2sq*m5sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) - (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (2*m2sq*m6sq*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m5sq - m6sq) + m5sq*m6sq)*B0fin(0,0,m2sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m5sq*(-m3**4 + m5**4 + m1sq*(m2sq - m5sq) - m2sq*m5sq + 4*m3sq*m5sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m5sq - m6sq) + m5sq*m6sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m5sq - m6sq) + m5sq*m6sq)*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m6sq*(m3**4 - m6**4 + m2sq*m6sq - 4*m3sq*m6sq + m1sq*(-m2sq + m6sq))*(B0del(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0fin(0,0,m3sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m3sq*m6sq*(m1sq + m2sq - 2*(m3sq + m6sq))*B0fin(0,0,m3sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (m1sq*(m1**4 - m3**4 + m1sq*(4*m3sq - m5sq - m6sq) + m5sq*m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (m2sq*m3sq*(2*m2sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (m2sq*(m2**4 - m3**4 + m2sq*(4*m3sq - m5sq - m6sq) + m5sq*m6sq)*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m3sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (2*m1sq*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) + (2*m2sq*m5sq*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) - (m5sq*(-m3**4 + m5**4 + m1sq*(m2sq - m5sq) - m2sq*m5sq + 4*m3sq*m5sq)*B0fin(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) - (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0fin(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (2*m1sq*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) - (2*m2sq*m5sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m5sq*(-m3**4 + m5**4 + m1sq*(m2sq - m5sq) - m2sq*m5sq + 4*m3sq*m5sq)*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m3sq*m5sq*(m1sq + m2sq - 2*(m3sq + m5sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + ((m1sq - m3sq + m5sq)*(m1sq + m3sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) - ((m2sq - m3sq + m5sq)*(m2sq + m3sq + m5sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + (2*m1sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (2*m2sq*m6sq*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m6sq*(-m3**4 + m6**4 + m1sq*(m2sq - m6sq) - m2sq*m6sq + 4*m3sq*m6sq)*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m3sq*m6sq*(m1sq + m2sq - 2*(m3sq + m6sq))*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (2*m1sq*m6sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (2*m2sq*m6sq*B0fin(0,0,m2sq,mudim)*B0fin(0,0,m6sq,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) + (m6sq*(m3**4 - m6**4 + m2sq*m6sq - 4*m3sq*m6sq + m1sq*(-m2sq + m6sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - (m3sq*m6sq*(m1sq + m2sq - 2*(m3sq + m6sq))*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - ((m1sq - m3sq + m6sq)*(m1sq + m3sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + ((m2sq - m3sq + m6sq)*(m2sq + m3sq + m6sq + 2*m2sq*B0fin(0,0,m2sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m1sq - m2sq)*(m5sq - m6sq)*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq))) - ((m1sq - m3sq + m5sq)*T134fin(m5,m3,m1,mudim))/((m1sq - m2sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) + ((m2sq - m3sq + m5sq)*T134fin(m5,m3,m2,mudim))/((m1sq - m2sq)*(m2**4 + (m3sq - m5sq)**2 - 2*m2sq*(m3sq + m5sq))*(m5sq - m6sq)) + ((m1sq - m3sq + m6sq)*T134fin(m6,m3,m1,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - ((m2sq - m3sq + m6sq)*T134fin(m6,m3,m2,mudim))/((m1sq - m2sq)*(m5sq - m6sq)*(m2**4 + (m3sq - m6sq)**2 - 2*m2sq*(m3sq + m6sq)))
		def eval_78():
			return (m1sq*(-2*m1sq + m3sq + m4sq - 2*m5sq)*m5sq*B0del(0,0,m1sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0del(0,0,m1sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (m1sq*m4sq*(2*m1sq + 2*m4sq - m5sq - m6sq)*B0del(0,0,m1sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m1sq*m6sq*(2*m1sq - m3sq - m4sq + 2*m6sq)*B0del(0,0,m1sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (2*m3sq*m5sq*B0del(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) + (m3sq*(-m1**4 + 4*m1sq*m3sq + (m3sq - m5sq)*(m3sq - m6sq))*B0del(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0del(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (2*m3sq*m6sq*B0del(0,0,m3sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (2*m4sq*m5sq*B0del(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (m4sq*(m1**4 - 4*m1sq*m4sq - (m4sq - m5sq)*(m4sq - m6sq))*B0del(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m1sq*m4sq*(2*m1sq + 2*m4sq - m5sq - m6sq)*B0del(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (2*m4sq*m6sq*B0del(0,0,m4sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (2*m3sq*m5sq*B0del(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) - (2*m4sq*m5sq*B0del(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (m1sq*(-2*m1sq + m3sq + m4sq - 2*m5sq)*m5sq*B0del(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) - (m5sq*(m1**4 - 4*m1sq*m5sq + (m3sq - m5sq)*(-m4sq + m5sq))*B0del(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) - (2*m3sq*m6sq*B0del(0,0,m6sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (2*m4sq*m6sq*B0del(0,0,m6sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m1sq*m6sq*(2*m1sq - m3sq - m4sq + 2*m6sq)*B0del(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m6sq*(m1**4 - 4*m1sq*m6sq + (m3sq - m6sq)*(-m4sq + m6sq))*B0del(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m5sq*(m1**4 - 4*m1sq*m5sq + (m3sq - m5sq)*(-m4sq + m5sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (m3sq*(-m1**4 + 4*m1sq*m3sq + (m3sq - m5sq)*(m3sq - m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (m4sq*(m1**4 - 4*m1sq*m4sq - (m4sq - m5sq)*(m4sq - m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m6sq*(m1**4 - 4*m1sq*m6sq + (m3sq - m6sq)*(-m4sq + m6sq))*(B0del(0,0,m1sq,mudim) - B0fin(0,0,m1sq,mudim)))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m1sq*(-2*m1sq + m3sq + m4sq - 2*m5sq)*m5sq*B0fin(0,0,m1sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (m1sq*m4sq*(2*m1sq + 2*m4sq - m5sq - m6sq)*B0fin(0,0,m1sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m1sq*m6sq*(2*m1sq - m3sq - m4sq + 2*m6sq)*B0fin(0,0,m1sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) - (m3sq*(-m1**4 + 4*m1sq*m3sq + (m3sq - m5sq)*(m3sq - m6sq))*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (m3sq*(-m1**4 + 4*m1sq*m3sq + (m3sq - m5sq)*(m3sq - m6sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (m1sq*m3sq*(2*m1sq + 2*m3sq - m5sq - m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (2*m4sq*m5sq*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (m4sq*(-m1**4 + 4*m1sq*m4sq + (m4sq - m5sq)*(m4sq - m6sq))*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m1sq*m4sq*(2*m1sq + 2*m4sq - m5sq - m6sq)*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m4sq*m6sq*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m4sq*(m1**4 - 4*m1sq*m4sq - (m4sq - m5sq)*(m4sq - m6sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m1sq*m4sq*(2*m1sq + 2*m4sq - m5sq - m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m3sq*m5sq*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) + (2*m4sq*m5sq*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) - (m1sq*(-2*m1sq + m3sq + m4sq - 2*m5sq)*m5sq*B0fin(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (m5sq*(m1**4 - 4*m1sq*m5sq + (m3sq - m5sq)*(-m4sq + m5sq))*B0fin(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (m1sq*(-2*m1sq + m3sq + m4sq - 2*m5sq)*m5sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) - (m5sq*(m1**4 - 4*m1sq*m5sq + (m3sq - m5sq)*(-m4sq + m5sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m5sq,mudim))/((m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (2*m3sq*m5sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) - (2*m4sq*m5sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m5sq,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + ((-m1sq + m3sq + m5sq)*(m1sq + m3sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) - ((-m1sq + m4sq + m5sq)*(m1sq + m4sq + m5sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m5sq*B0fin(0,0,m5sq,mudim)))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + (2*m3sq*m6sq*B0fin(0,0,m6sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - (2*m4sq*m6sq*B0fin(0,0,m6sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m1sq*m6sq*(2*m1sq - m3sq - m4sq + 2*m6sq)*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (m6sq*(m1**4 - 4*m1sq*m6sq + (m3sq - m6sq)*(-m4sq + m6sq))*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m1sq*m6sq*(2*m1sq - m3sq - m4sq + 2*m6sq)*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) + (m6sq*(m1**4 - 4*m1sq*m6sq + (m3sq - m6sq)*(-m4sq + m6sq))*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m6sq,mudim))/((m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - (2*m3sq*m6sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + (2*m4sq*m6sq*B0fin(0,0,m4sq,mudim)*B0fin(0,0,m6sq,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - ((-m1sq + m3sq + m6sq)*(m1sq + m3sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*B0fin(0,0,m3sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) + ((-m1sq + m4sq + m6sq)*(m1sq + m4sq + m6sq + 2*m1sq*B0fin(0,0,m1sq,mudim) + 2*m4sq*B0fin(0,0,m4sq,mudim) + 2*m6sq*B0fin(0,0,m6sq,mudim)))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq))) - ((-m1sq + m3sq + m5sq)*T134fin(m5,m3,m1,mudim))/((m3sq - m4sq)*(m1**4 + (m3sq - m5sq)**2 - 2*m1sq*(m3sq + m5sq))*(m5sq - m6sq)) + ((-m1sq + m4sq + m5sq)*T134fin(m5,m4,m1,mudim))/((m3sq - m4sq)*(m1**4 + (m4sq - m5sq)**2 - 2*m1sq*(m4sq + m5sq))*(m5sq - m6sq)) + ((-m1sq + m3sq + m6sq)*T134fin(m6,m3,m1,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m3sq - m6sq)**2 - 2*m1sq*(m3sq + m6sq))) - ((-m1sq + m4sq + m6sq)*T134fin(m6,m4,m1,mudim))/((m3sq - m4sq)*(m5sq - m6sq)*(m1**4 + (m4sq - m6sq)**2 - 2*m1sq*(m4sq + m6sq)))
		def eval_79():
			return (T134fin(m5,m3,m1,mudim) - T134fin(m5,m3,m2,mudim) - T134fin(m5,m4,m1,mudim) + T134fin(m5,m4,m2,mudim) - T134fin(m6,m3,m1,mudim) + T134fin(m6,m3,m2,mudim) + T134fin(m6,m4,m1,mudim) - T134fin(m6,m4,m2,mudim))/((m1sq - m2sq)*(m3sq - m4sq)*(m5sq - m6sq))

		cond_m1_0 = cond(m1, 0)
		cond_m2_0 = cond(m2, 0)
		cond_m3_0 = cond(m3, 0)
		cond_m4_0 = cond(m4, 0)
		cond_m5_0 = cond(m5, 0)
		cond_m6_0 = cond(m6, 0)
		cond_m6_m5 = cond(m6, m5)
		cond_m6_m4 = cond(m6, m4)
		cond_m5_m4 = cond(m5, m4)
		cond_m6_m3 = cond(m6, m3)
		cond_m5_m3 = cond(m5, m3)
		cond_m4_m3 = cond(m4, m3)
		cond_m6_m2 = cond(m6, m2)
		cond_m5_m2 = cond(m5, m2)
		cond_m4_m2 = cond(m4, m2)
		cond_m3_m2 = cond(m3, m2)
		cond_m6_m1 = cond(m6, m1)
		cond_m5_m1 = cond(m5, m1)
		cond_m4_m1 = cond(m4, m1)
		cond_m3_m1 = cond(m3, m1)
		cond_m2_m1 = cond(m2, m1)

		conditions = [
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_1()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_2()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_3()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_3()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_4()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_4()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_37()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_38()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_6()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_6()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_7()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_7()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_7()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_7()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_38()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_8()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_9()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_10()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_11()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_12()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_12()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_11()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_11()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_12()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_12()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_13()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_29()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_29()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_14()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_14()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_35()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_36()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_35()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_36()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_15()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_16()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_16()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_47()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_17()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_17()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_51()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_52()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_48()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_48()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_48()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_48()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_49()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_49()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_18()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_18()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_53()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_53()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_54()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_54()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_51()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_52()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_19()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_19()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_20()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_20()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_53()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_53()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_54()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_54()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_55()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_55()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_57()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_57()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_21()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_21()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_22()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_22()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m5_0, lambda: eval_78()),
			(cond_m1_0 and cond_m2_0 and cond_m6_0, lambda: eval_78()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0, lambda: eval_77()),
			(cond_m1_0 and cond_m3_0 and cond_m5_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m5_0 and cond_m6_0, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_77()),
			(cond_m2_0 and cond_m3_0 and cond_m5_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m5_0 and cond_m6_0, lambda: eval_76()),
			(cond_m3_0 and cond_m4_0 and cond_m5_0, lambda: eval_77()),
			(cond_m3_0 and cond_m4_0 and cond_m6_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0 and cond_m6_0, lambda: eval_76()),
			(cond_m4_0 and cond_m5_0 and cond_m6_0, lambda: eval_76()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_23()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_24()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_24()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_25()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_25()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_24()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_24()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_25()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_25()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_26()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_27()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_28()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_29()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_63()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_63()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_34()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_30()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_31()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_31()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_0, lambda: eval_77()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_32()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_32()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_33()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_67()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_66()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_0, lambda: eval_66()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_67()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_63()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_63()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_34()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_34()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_35()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_36()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_77()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_37()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_72()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_39()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_39()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_40()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_40()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_67()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_66()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_66()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_67()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_41()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_41()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_42()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_42()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_43()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_43()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_42()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_42()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_44()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_43()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_43()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_44()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_45()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_46()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m5, lambda: eval_47()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m4, lambda: eval_48()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m4, lambda: eval_48()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_0, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_0, lambda: eval_77()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3, lambda: eval_49()),
			(cond_m1_0 and cond_m2_0 and cond_m5_m3, lambda: eval_50()),
			(cond_m1_0 and cond_m2_0 and cond_m6_m3, lambda: eval_50()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m5_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_0, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m5_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_0, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_0, lambda: eval_77()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m5, lambda: eval_51()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_0, lambda: eval_52()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m2, lambda: eval_53()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m2, lambda: eval_53()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_0, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_0, lambda: eval_54()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_0, lambda: eval_54()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m5_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m5_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0, lambda: eval_55()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_0, lambda: eval_78()),
			(cond_m3_0 and cond_m4_0 and cond_m5_m1, lambda: eval_56()),
			(cond_m3_0 and cond_m4_0 and cond_m6_m1, lambda: eval_56()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_0, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m3_0 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_0, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_0, lambda: eval_57()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_0, lambda: eval_58()),
			(cond_m4_0 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_0, lambda: eval_58()),
			(cond_m1_0 and cond_m2_0, lambda: eval_78()),
			(cond_m1_0 and cond_m3_0, lambda: eval_79()),
			(cond_m1_0 and cond_m4_0, lambda: eval_79()),
			(cond_m1_0 and cond_m5_0, lambda: eval_79()),
			(cond_m1_0 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_0, lambda: eval_79()),
			(cond_m2_0 and cond_m4_0, lambda: eval_79()),
			(cond_m2_0 and cond_m5_0, lambda: eval_79()),
			(cond_m2_0 and cond_m6_0, lambda: eval_79()),
			(cond_m3_0 and cond_m4_0, lambda: eval_77()),
			(cond_m3_0 and cond_m5_0, lambda: eval_79()),
			(cond_m3_0 and cond_m6_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_0, lambda: eval_79()),
			(cond_m4_0 and cond_m6_0, lambda: eval_79()),
			(cond_m5_0 and cond_m6_0, lambda: eval_76()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_59()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_59()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_62()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_62()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_61()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_61()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_59()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m4, lambda: eval_63()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m3, lambda: eval_63()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m3, lambda: eval_60()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m2, lambda: eval_60()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m5, lambda: eval_73()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2 and cond_m6_m2, lambda: eval_73()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_64()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2 and cond_m6_m2, lambda: eval_64()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_65()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_65()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_59()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_67()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_67()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_66()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_63()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_63()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_60()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_60()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_74()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_74()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_75()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_67()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_67()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_66()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_73()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_74()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_74()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_64()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_65()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_62()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_61()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_61()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_62()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_70()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_63()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_73()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_64()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_64()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_65()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m3 and cond_m5_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m4_m3 and cond_m6_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2, lambda: eval_77()),
			(cond_m1_0 and cond_m3_m2 and cond_m5_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_63()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m5, lambda: eval_73()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m3, lambda: eval_64()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m3, lambda: eval_64()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_65()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m4, lambda: eval_76()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m3, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m3, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_0, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m2, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_0, lambda: eval_77()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_67()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_0, lambda: eval_66()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m2, lambda: eval_67()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m5, lambda: eval_74()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m3 and cond_m5_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m4_m3 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_74()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m4 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_78()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m3 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_0 and cond_m6_m1, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_0, lambda: eval_77()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_0, lambda: eval_75()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_0, lambda: eval_75()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_0, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1, lambda: eval_77()),
			(cond_m2_0 and cond_m3_m1 and cond_m5_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_0 and cond_m5_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_0 and cond_m6_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_68()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_69()),
			(cond_m3_0 and cond_m4_m1 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m1 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_71()),
			(cond_m3_m1 and cond_m4_0 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_0, lambda: eval_70()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_69()),
			(cond_m2_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_0, lambda: eval_70()),
			(cond_m3_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m1 and cond_m6_m1, lambda: eval_71()),
			(cond_m4_m1 and cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m1_0 and cond_m5_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m3, lambda: eval_77()),
			(cond_m1_0 and cond_m5_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m1_0 and cond_m3_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m4_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m5_m2, lambda: eval_79()),
			(cond_m1_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m2_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m2_0 and cond_m5_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m3, lambda: eval_77()),
			(cond_m2_0 and cond_m5_m3, lambda: eval_79()),
			(cond_m2_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m3_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_0 and cond_m5_m4, lambda: eval_79()),
			(cond_m3_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m4_0 and cond_m6_m5, lambda: eval_76()),
			(cond_m5_0 and cond_m6_m4, lambda: eval_79()),
			(cond_m5_m4 and cond_m6_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m3, lambda: eval_79()),
			(cond_m4_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_0, lambda: eval_77()),
			(cond_m4_m3 and cond_m6_0, lambda: eval_77()),
			(cond_m5_0 and cond_m6_m3, lambda: eval_79()),
			(cond_m5_m3 and cond_m6_0, lambda: eval_79()),
			(cond_m3_0 and cond_m4_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m2, lambda: eval_79()),
			(cond_m4_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_0, lambda: eval_79()),
			(cond_m3_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m4_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m5_0 and cond_m6_m2, lambda: eval_79()),
			(cond_m5_m2 and cond_m6_0, lambda: eval_79()),
			(cond_m2_0 and cond_m3_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m4_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m5_m1, lambda: eval_79()),
			(cond_m2_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_0, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_0, lambda: eval_78()),
			(cond_m3_0 and cond_m4_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m5_0, lambda: eval_78()),
			(cond_m3_m1 and cond_m5_0, lambda: eval_79()),
			(cond_m4_0 and cond_m5_m1, lambda: eval_79()),
			(cond_m4_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m6_0, lambda: eval_78()),
			(cond_m3_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m4_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m5_0 and cond_m6_m1, lambda: eval_79()),
			(cond_m5_m1 and cond_m6_0, lambda: eval_79()),
			(cond_m1_0, lambda: eval_79()),
			(cond_m2_0, lambda: eval_79()),
			(cond_m3_0, lambda: eval_79()),
			(cond_m4_0, lambda: eval_79()),
			(cond_m5_0, lambda: eval_79()),
			(cond_m6_0, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_73()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_74()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_74()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_75()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_75()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_73()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_72()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_74()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_74()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m3, lambda: eval_73()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m4, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m3, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m3, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m5, lambda: eval_73()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m2, lambda: eval_73()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_74()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m4, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_76()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m3, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m3 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m5, lambda: eval_72()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m3, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m4 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m3 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m2, lambda: eval_77()),
			(cond_m4_m3 and cond_m5_m2 and cond_m6_m1, lambda: eval_77()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m3, lambda: eval_75()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m3, lambda: eval_75()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m3, lambda: eval_74()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2 and cond_m5_m1, lambda: eval_77()),
			(cond_m3_m2 and cond_m4_m2 and cond_m6_m1, lambda: eval_77()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m5, lambda: eval_74()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_74()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m5, lambda: eval_73()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m4 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_m1 and cond_m6_m1, lambda: eval_73()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m3 and cond_m5_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m4_m3 and cond_m6_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m3 and cond_m6_m1, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m2, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m2, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m2 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m4_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1 and cond_m6_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1, lambda: eval_75()),
			(cond_m2_m1 and cond_m3_m1 and cond_m5_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m3_m1 and cond_m6_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_74()),
			(cond_m3_m1 and cond_m4_m1 and cond_m5_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m4_m1 and cond_m6_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m4_m1 and cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m5_m4 and cond_m6_m4, lambda: eval_76()),
			(cond_m4_m3 and cond_m6_m5, lambda: eval_73()),
			(cond_m5_m3 and cond_m6_m4, lambda: eval_79()),
			(cond_m5_m4 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_m3, lambda: eval_77()),
			(cond_m4_m3 and cond_m6_m3, lambda: eval_77()),
			(cond_m5_m3 and cond_m6_m3, lambda: eval_76()),
			(cond_m3_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m4_m2 and cond_m6_m5, lambda: eval_76()),
			(cond_m5_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m5_m4 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m4, lambda: eval_79()),
			(cond_m3_m2 and cond_m6_m4, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m3, lambda: eval_79()),
			(cond_m4_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_m2, lambda: eval_77()),
			(cond_m4_m3 and cond_m6_m2, lambda: eval_77()),
			(cond_m5_m2 and cond_m6_m3, lambda: eval_79()),
			(cond_m5_m3 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m2, lambda: eval_77()),
			(cond_m3_m2 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m6_m2, lambda: eval_79()),
			(cond_m5_m2 and cond_m6_m2, lambda: eval_76()),
			(cond_m2_m1 and cond_m6_m5, lambda: eval_74()),
			(cond_m3_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m4_m1 and cond_m6_m5, lambda: eval_76()),
			(cond_m5_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m5_m4 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m5_m4, lambda: eval_78()),
			(cond_m2_m1 and cond_m6_m4, lambda: eval_78()),
			(cond_m3_m1 and cond_m5_m4, lambda: eval_79()),
			(cond_m3_m1 and cond_m6_m4, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m3, lambda: eval_79()),
			(cond_m4_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m4_m3 and cond_m5_m1, lambda: eval_77()),
			(cond_m4_m3 and cond_m6_m1, lambda: eval_77()),
			(cond_m5_m1 and cond_m6_m3, lambda: eval_79()),
			(cond_m5_m3 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m4_m3, lambda: eval_75()),
			(cond_m2_m1 and cond_m5_m3, lambda: eval_78()),
			(cond_m2_m1 and cond_m6_m3, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m5_m2, lambda: eval_79()),
			(cond_m3_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m3_m2 and cond_m4_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m2, lambda: eval_79()),
			(cond_m4_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m4_m2 and cond_m5_m1, lambda: eval_79()),
			(cond_m4_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m5_m1 and cond_m6_m2, lambda: eval_79()),
			(cond_m5_m2 and cond_m6_m1, lambda: eval_79()),
			(cond_m2_m1 and cond_m3_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m4_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m5_m1, lambda: eval_78()),
			(cond_m2_m1 and cond_m6_m1, lambda: eval_78()),
			(cond_m3_m1 and cond_m4_m1, lambda: eval_77()),
			(cond_m3_m1 and cond_m5_m1, lambda: eval_79()),
			(cond_m3_m1 and cond_m6_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m5_m1, lambda: eval_79()),
			(cond_m4_m1 and cond_m6_m1, lambda: eval_79()),
			(cond_m5_m1 and cond_m6_m1, lambda: eval_76()),
			(cond_m6_m5, lambda: eval_76()),
			(cond_m5_m4, lambda: eval_79()),
			(cond_m6_m4, lambda: eval_79()),
			(cond_m4_m3, lambda: eval_77()),
			(cond_m5_m3, lambda: eval_79()),
			(cond_m6_m3, lambda: eval_79()),
			(cond_m3_m2, lambda: eval_79()),
			(cond_m4_m2, lambda: eval_79()),
			(cond_m5_m2, lambda: eval_79()),
			(cond_m6_m2, lambda: eval_79()),
			(cond_m2_m1, lambda: eval_78()),
			(cond_m3_m1, lambda: eval_79()),
			(cond_m4_m1, lambda: eval_79()),
			(cond_m5_m1, lambda: eval_79()),
			(cond_m6_m1, lambda: eval_79()),
			(True, lambda: eval_79())
		]

		for condition,action in conditions:
			if condition:
				res = action()
				return res * mass_scale**(-4.)

	except Exception as e:
		raise Exception(f"There was an error when evaluating the T113344 integral with masses {m1}, {m2}, {m3}, {m4}, {m5}, {m6} from {e}")