# This file is automatically generated. Do not modify it manually!
from functools import lru_cache

from .config import cond, Number, getMudim, getDiffeps
from .OneLoop import B0fin, B0del
from .T134 import T134fin


@lru_cache(maxsize=150)
def T1134(m1: Number, m2: Number, m3: Number, m4, mudim = None) -> Number:
	""" Computes the UV-finite part of the T1134 integral.

	Args:
		m1: internal mass
		m2: internal mass
		m3: internal mass
		m4: internal mass
		mudim: squared renormalization scale (if `None`, the global value is used)

	Returns:
		finite part of the T1134 integral.
	"""

	try:

		if mudim is None:
			mudim = getMudim()

		# rescale masses for better numerical stability
		mass_scale = max([m1, m2, m3, m4])
		if mass_scale <= getDiffeps():
			return 0
		m1 /= mass_scale
		m2 /= mass_scale
		m3 /= mass_scale
		m4 /= mass_scale
		mudim /= mass_scale**2
		m1, m2 = sorted([m1, m2])
		
		

		m1sq = m1**2
		m2sq = m2**2
		m3sq = m3**2
		m4sq = m4**2

		def eval_1():
			return 0
		def eval_2():
			return -3 - B0del(0,0,m3sq,mudim) + 3*B0fin(0,0,m3sq,mudim) - B0fin(0,0,m3sq,mudim)**2/2.
		def eval_3():
			return B0del(0,0,m1sq,mudim) + ((-2 + B0fin(0,0,m1sq,mudim))*B0fin(0,0,m1sq,mudim))/2.
		def eval_4():
			return B0del(0,0,m1sq,mudim) + ((-2 + B0fin(0,0,m1sq,mudim))*B0fin(0,0,m1sq,mudim))/2.
		def eval_5():
			return (-m1**4 + m3**4 + m4**4 + 2*m3sq*m4sq + ((m3sq - m4sq)**2 - m1sq*(m3sq + m4sq))*B0del(0,0,m1sq,mudim) + m3sq*(-m1sq + m3sq + m4sq)*B0del(0,0,m3sq,mudim) + m4**4*B0del(0,0,m4sq,mudim) - m1sq*m4sq*B0del(0,0,m4sq,mudim) + m3sq*m4sq*B0del(0,0,m4sq,mudim) - 2*m1**4*B0fin(0,0,m1sq,mudim) - m3**4*B0fin(0,0,m1sq,mudim) + 3*m1sq*m3sq*B0fin(0,0,m1sq,mudim) - m4**4*B0fin(0,0,m1sq,mudim) + 3*m1sq*m4sq*B0fin(0,0,m1sq,mudim) + 2*m3sq*m4sq*B0fin(0,0,m1sq,mudim) + m3**4*B0fin(0,0,m3sq,mudim) - m1sq*m3sq*B0fin(0,0,m3sq,mudim) + m3sq*m4sq*B0fin(0,0,m3sq,mudim) + m3**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m1sq*m3sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) - m3sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m3sq,mudim) + m4**4*B0fin(0,0,m4sq,mudim) - m1sq*m4sq*B0fin(0,0,m4sq,mudim) + m3sq*m4sq*B0fin(0,0,m4sq,mudim) + m4**4*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m1sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) - m3sq*m4sq*B0fin(0,0,m1sq,mudim)*B0fin(0,0,m4sq,mudim) + 2*m3sq*m4sq*B0fin(0,0,m3sq,mudim)*B0fin(0,0,m4sq,mudim) + m1sq*T134fin(m4,m3,m1,mudim) - m3sq*T134fin(m4,m3,m1,mudim) - m4sq*T134fin(m4,m3,m1,mudim))/(m1**4 + (m3sq - m4sq)**2 - 2*m1sq*(m3sq + m4sq))
		def eval_6():
			return (T134fin(m4,m3,m1,mudim) - T134fin(m4,m3,m2,mudim))/(m1sq - m2sq)

		cond_m1_0 = cond(m1, 0)
		cond_m2_0 = cond(m2, 0)
		cond_m3_0 = cond(m3, 0)
		cond_m4_0 = cond(m4, 0)
		cond_m4_m3 = cond(m4, m3)
		cond_m4_m2 = cond(m4, m2)
		cond_m3_m2 = cond(m3, m2)
		cond_m4_m1 = cond(m4, m1)
		cond_m3_m1 = cond(m3, m1)
		cond_m2_m1 = cond(m2, m1)

		conditions = [
			(cond_m1_0 and cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_1()),
			(cond_m1_0 and cond_m2_0 and cond_m3_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0 and cond_m4_0, lambda: eval_5()),
			(cond_m1_0 and cond_m3_0 and cond_m4_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_0, lambda: eval_6()),
			(cond_m1_0 and cond_m2_0 and cond_m4_m3, lambda: eval_2()),
			(cond_m1_0 and cond_m3_0 and cond_m4_m2, lambda: eval_6()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0 and cond_m4_m1, lambda: eval_6()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_0, lambda: eval_6()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_0, lambda: eval_5()),
			(cond_m1_0 and cond_m2_0, lambda: eval_5()),
			(cond_m1_0 and cond_m3_0, lambda: eval_6()),
			(cond_m1_0 and cond_m4_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_0, lambda: eval_6()),
			(cond_m2_0 and cond_m4_0, lambda: eval_6()),
			(cond_m3_0 and cond_m4_0, lambda: eval_6()),
			(cond_m1_0 and cond_m3_m2 and cond_m4_m2, lambda: eval_6()),
			(cond_m2_0 and cond_m3_m1 and cond_m4_m1, lambda: eval_6()),
			(cond_m2_m1 and cond_m3_0 and cond_m4_m1, lambda: eval_3()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_0, lambda: eval_4()),
			(cond_m1_0 and cond_m4_m3, lambda: eval_6()),
			(cond_m1_0 and cond_m3_m2, lambda: eval_6()),
			(cond_m1_0 and cond_m4_m2, lambda: eval_6()),
			(cond_m2_0 and cond_m4_m3, lambda: eval_6()),
			(cond_m3_0 and cond_m4_m2, lambda: eval_6()),
			(cond_m3_m2 and cond_m4_0, lambda: eval_6()),
			(cond_m2_0 and cond_m3_m1, lambda: eval_6()),
			(cond_m2_0 and cond_m4_m1, lambda: eval_6()),
			(cond_m2_m1 and cond_m3_0, lambda: eval_5()),
			(cond_m2_m1 and cond_m4_0, lambda: eval_5()),
			(cond_m3_0 and cond_m4_m1, lambda: eval_6()),
			(cond_m3_m1 and cond_m4_0, lambda: eval_6()),
			(cond_m1_0, lambda: eval_6()),
			(cond_m2_0, lambda: eval_6()),
			(cond_m3_0, lambda: eval_6()),
			(cond_m4_0, lambda: eval_6()),
			(cond_m2_m1 and cond_m3_m1 and cond_m4_m1, lambda: eval_5()),
			(cond_m3_m2 and cond_m4_m2, lambda: eval_6()),
			(cond_m2_m1 and cond_m4_m3, lambda: eval_5()),
			(cond_m3_m1 and cond_m4_m2, lambda: eval_6()),
			(cond_m3_m2 and cond_m4_m1, lambda: eval_6()),
			(cond_m2_m1 and cond_m3_m1, lambda: eval_5()),
			(cond_m2_m1 and cond_m4_m1, lambda: eval_5()),
			(cond_m3_m1 and cond_m4_m1, lambda: eval_6()),
			(cond_m4_m3, lambda: eval_6()),
			(cond_m3_m2, lambda: eval_6()),
			(cond_m4_m2, lambda: eval_6()),
			(cond_m2_m1, lambda: eval_5()),
			(cond_m3_m1, lambda: eval_6()),
			(cond_m4_m1, lambda: eval_6()),
			(True, lambda: eval_6())
		]

		for condition,action in conditions:
			if condition:
				res = action()
				return res * mass_scale**(0.)

	except Exception as e:
		raise Exception(f"There was an error when evaluating the T1134 integral with masses {m1}, {m2}, {m3}, {m4} from {e}")