# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOrganizationServiceAccountResult',
    'AwaitableGetOrganizationServiceAccountResult',
    'get_organization_service_account',
    'get_organization_service_account_output',
]

@pulumi.output_type
class GetOrganizationServiceAccountResult:
    """
    A collection of values returned by getOrganizationServiceAccount.
    """
    def __init__(__self__, account_email=None, id=None, name=None, organization_id=None):
        if account_email and not isinstance(account_email, str):
            raise TypeError("Expected argument 'account_email' to be a str")
        pulumi.set(__self__, "account_email", account_email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter(name="accountEmail")
    def account_email(self) -> str:
        """
        The email address of the service account. This value is
        often used to refer to the service account in order to grant IAM permissions.
        """
        return pulumi.get(self, "account_email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Access Approval service account resource name. Format is "organizations/{organization_id}/serviceAccount".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        return pulumi.get(self, "organization_id")


class AwaitableGetOrganizationServiceAccountResult(GetOrganizationServiceAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationServiceAccountResult(
            account_email=self.account_email,
            id=self.id,
            name=self.name,
            organization_id=self.organization_id)


def get_organization_service_account(organization_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationServiceAccountResult:
    """
    Get the email address of an organization's Access Approval service account.

    Each Google Cloud organization has a unique service account used by Access Approval.
    When using Access Approval with a
    [custom signing key](https://cloud.google.com/cloud-provider-access-management/access-approval/docs/review-approve-access-requests-custom-keys),
    this account needs to be granted the `cloudkms.signerVerifier` IAM role on the
    Cloud KMS key used to sign approvals.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    service_account = gcp.accessapproval.get_organization_service_account(organization_id="my-organization")
    iam = gcp.kms.CryptoKeyIAMMember("iam",
        crypto_key_id=crypto_key["id"],
        role="roles/cloudkms.signerVerifier",
        member=f"serviceAccount:{service_account.account_email}")
    ```


    :param str organization_id: The organization ID the service account was created for.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:accessapproval/getOrganizationServiceAccount:getOrganizationServiceAccount', __args__, opts=opts, typ=GetOrganizationServiceAccountResult).value

    return AwaitableGetOrganizationServiceAccountResult(
        account_email=pulumi.get(__ret__, 'account_email'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'))


@_utilities.lift_output_func(get_organization_service_account)
def get_organization_service_account_output(organization_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationServiceAccountResult]:
    """
    Get the email address of an organization's Access Approval service account.

    Each Google Cloud organization has a unique service account used by Access Approval.
    When using Access Approval with a
    [custom signing key](https://cloud.google.com/cloud-provider-access-management/access-approval/docs/review-approve-access-requests-custom-keys),
    this account needs to be granted the `cloudkms.signerVerifier` IAM role on the
    Cloud KMS key used to sign approvals.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    service_account = gcp.accessapproval.get_organization_service_account(organization_id="my-organization")
    iam = gcp.kms.CryptoKeyIAMMember("iam",
        crypto_key_id=crypto_key["id"],
        role="roles/cloudkms.signerVerifier",
        member=f"serviceAccount:{service_account.account_email}")
    ```


    :param str organization_id: The organization ID the service account was created for.
    """
    ...
