# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessLevelsArgs', 'AccessLevels']

@pulumi.input_type
class AccessLevelsArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[str],
                 access_levels: Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelsAccessLevelArgs']]]] = None):
        """
        The set of arguments for constructing a AccessLevels resource.
        :param pulumi.Input[str] parent: The AccessPolicy this AccessLevel lives in.
               Format: accessPolicies/{policy_id}
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['AccessLevelsAccessLevelArgs']]] access_levels: The desired Access Levels that should replace all existing Access Levels in the Access Policy.
               Structure is documented below.
        """
        pulumi.set(__self__, "parent", parent)
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[str]:
        """
        The AccessPolicy this AccessLevel lives in.
        Format: accessPolicies/{policy_id}


        - - -
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelsAccessLevelArgs']]]]:
        """
        The desired Access Levels that should replace all existing Access Levels in the Access Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "access_levels")

    @access_levels.setter
    def access_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelsAccessLevelArgs']]]]):
        pulumi.set(self, "access_levels", value)


@pulumi.input_type
class _AccessLevelsState:
    def __init__(__self__, *,
                 access_levels: Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelsAccessLevelArgs']]]] = None,
                 parent: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccessLevels resources.
        :param pulumi.Input[Sequence[pulumi.Input['AccessLevelsAccessLevelArgs']]] access_levels: The desired Access Levels that should replace all existing Access Levels in the Access Policy.
               Structure is documented below.
        :param pulumi.Input[str] parent: The AccessPolicy this AccessLevel lives in.
               Format: accessPolicies/{policy_id}
               
               
               - - -
        """
        if access_levels is not None:
            pulumi.set(__self__, "access_levels", access_levels)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelsAccessLevelArgs']]]]:
        """
        The desired Access Levels that should replace all existing Access Levels in the Access Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "access_levels")

    @access_levels.setter
    def access_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessLevelsAccessLevelArgs']]]]):
        pulumi.set(self, "access_levels", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The AccessPolicy this AccessLevel lives in.
        Format: accessPolicies/{policy_id}


        - - -
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)


class AccessLevels(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelsAccessLevelArgs', 'AccessLevelsAccessLevelArgsDict']]]]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Access Context Manager Access Levels Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="my policy")
        access_levels = gcp.accesscontextmanager.AccessLevels("access-levels",
            parent=access_policy.name.apply(lambda name: f"accessPolicies/{name}"),
            access_levels=[
                {
                    "name": access_policy.name.apply(lambda name: f"accessPolicies/{name}/accessLevels/chromeos_no_lock"),
                    "title": "chromeos_no_lock",
                    "basic": {
                        "conditions": [{
                            "device_policy": {
                                "require_screen_lock": True,
                                "os_constraints": [{
                                    "os_type": "DESKTOP_CHROME_OS",
                                }],
                            },
                            "regions": [
                                "CH",
                                "IT",
                                "US",
                            ],
                        }],
                    },
                },
                {
                    "name": access_policy.name.apply(lambda name: f"accessPolicies/{name}/accessLevels/mac_no_lock"),
                    "title": "mac_no_lock",
                    "basic": {
                        "conditions": [{
                            "device_policy": {
                                "require_screen_lock": True,
                                "os_constraints": [{
                                    "os_type": "DESKTOP_MAC",
                                }],
                            },
                            "regions": [
                                "CH",
                                "IT",
                                "US",
                            ],
                        }],
                    },
                },
            ])
        ```

        ## Import

        AccessLevels can be imported using any of these accepted formats:

        * `{{parent}}/accessLevels`

        * `{{parent}}`

        When using the `pulumi import` command, AccessLevels can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:accesscontextmanager/accessLevels:AccessLevels default {{parent}}/accessLevels
        ```

        ```sh
        $ pulumi import gcp:accesscontextmanager/accessLevels:AccessLevels default {{parent}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelsAccessLevelArgs', 'AccessLevelsAccessLevelArgsDict']]]] access_levels: The desired Access Levels that should replace all existing Access Levels in the Access Policy.
               Structure is documented below.
        :param pulumi.Input[str] parent: The AccessPolicy this AccessLevel lives in.
               Format: accessPolicies/{policy_id}
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessLevelsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Access Context Manager Access Levels Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        access_policy = gcp.accesscontextmanager.AccessPolicy("access-policy",
            parent="organizations/123456789",
            title="my policy")
        access_levels = gcp.accesscontextmanager.AccessLevels("access-levels",
            parent=access_policy.name.apply(lambda name: f"accessPolicies/{name}"),
            access_levels=[
                {
                    "name": access_policy.name.apply(lambda name: f"accessPolicies/{name}/accessLevels/chromeos_no_lock"),
                    "title": "chromeos_no_lock",
                    "basic": {
                        "conditions": [{
                            "device_policy": {
                                "require_screen_lock": True,
                                "os_constraints": [{
                                    "os_type": "DESKTOP_CHROME_OS",
                                }],
                            },
                            "regions": [
                                "CH",
                                "IT",
                                "US",
                            ],
                        }],
                    },
                },
                {
                    "name": access_policy.name.apply(lambda name: f"accessPolicies/{name}/accessLevels/mac_no_lock"),
                    "title": "mac_no_lock",
                    "basic": {
                        "conditions": [{
                            "device_policy": {
                                "require_screen_lock": True,
                                "os_constraints": [{
                                    "os_type": "DESKTOP_MAC",
                                }],
                            },
                            "regions": [
                                "CH",
                                "IT",
                                "US",
                            ],
                        }],
                    },
                },
            ])
        ```

        ## Import

        AccessLevels can be imported using any of these accepted formats:

        * `{{parent}}/accessLevels`

        * `{{parent}}`

        When using the `pulumi import` command, AccessLevels can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:accesscontextmanager/accessLevels:AccessLevels default {{parent}}/accessLevels
        ```

        ```sh
        $ pulumi import gcp:accesscontextmanager/accessLevels:AccessLevels default {{parent}}
        ```

        :param str resource_name: The name of the resource.
        :param AccessLevelsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessLevelsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelsAccessLevelArgs', 'AccessLevelsAccessLevelArgsDict']]]]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessLevelsArgs.__new__(AccessLevelsArgs)

            __props__.__dict__["access_levels"] = access_levels
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
        super(AccessLevels, __self__).__init__(
            'gcp:accesscontextmanager/accessLevels:AccessLevels',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelsAccessLevelArgs', 'AccessLevelsAccessLevelArgsDict']]]]] = None,
            parent: Optional[pulumi.Input[str]] = None) -> 'AccessLevels':
        """
        Get an existing AccessLevels resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessLevelsAccessLevelArgs', 'AccessLevelsAccessLevelArgsDict']]]] access_levels: The desired Access Levels that should replace all existing Access Levels in the Access Policy.
               Structure is documented below.
        :param pulumi.Input[str] parent: The AccessPolicy this AccessLevel lives in.
               Format: accessPolicies/{policy_id}
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessLevelsState.__new__(_AccessLevelsState)

        __props__.__dict__["access_levels"] = access_levels
        __props__.__dict__["parent"] = parent
        return AccessLevels(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLevels")
    def access_levels(self) -> pulumi.Output[Optional[Sequence['outputs.AccessLevelsAccessLevel']]]:
        """
        The desired Access Levels that should replace all existing Access Levels in the Access Policy.
        Structure is documented below.
        """
        return pulumi.get(self, "access_levels")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[str]:
        """
        The AccessPolicy this AccessLevel lives in.
        Format: accessPolicies/{policy_id}


        - - -
        """
        return pulumi.get(self, "parent")

