# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicePerimeterDryRunIngressPolicyArgs', 'ServicePerimeterDryRunIngressPolicy']

@pulumi.input_type
class ServicePerimeterDryRunIngressPolicyArgs:
    def __init__(__self__, *,
                 perimeter: pulumi.Input[str],
                 ingress_from: Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressFromArgs']] = None,
                 ingress_to: Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressToArgs']] = None):
        """
        The set of arguments for constructing a ServicePerimeterDryRunIngressPolicy resource.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        :param pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressFromArgs'] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressToArgs'] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        """
        pulumi.set(__self__, "perimeter", perimeter)
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)

    @property
    @pulumi.getter
    def perimeter(self) -> pulumi.Input[str]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: pulumi.Input[str]):
        pulumi.set(self, "perimeter", value)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressFromArgs']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @ingress_from.setter
    def ingress_from(self, value: Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressFromArgs']]):
        pulumi.set(self, "ingress_from", value)

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @ingress_to.setter
    def ingress_to(self, value: Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressToArgs']]):
        pulumi.set(self, "ingress_to", value)


@pulumi.input_type
class _ServicePerimeterDryRunIngressPolicyState:
    def __init__(__self__, *,
                 ingress_from: Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressFromArgs']] = None,
                 ingress_to: Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressToArgs']] = None,
                 perimeter: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServicePerimeterDryRunIngressPolicy resources.
        :param pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressFromArgs'] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressToArgs'] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)
        if perimeter is not None:
            pulumi.set(__self__, "perimeter", perimeter)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressFromArgs']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @ingress_from.setter
    def ingress_from(self, value: Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressFromArgs']]):
        pulumi.set(self, "ingress_from", value)

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @ingress_to.setter
    def ingress_to(self, value: Optional[pulumi.Input['ServicePerimeterDryRunIngressPolicyIngressToArgs']]):
        pulumi.set(self, "ingress_to", value)

    @property
    @pulumi.getter
    def perimeter(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "perimeter", value)


class ServicePerimeterDryRunIngressPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_from: Optional[pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressFromArgs', 'ServicePerimeterDryRunIngressPolicyIngressFromArgsDict']]] = None,
                 ingress_to: Optional[pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressToArgs', 'ServicePerimeterDryRunIngressPolicyIngressToArgsDict']]] = None,
                 perimeter: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manage a single IngressPolicy in the spec (dry-run) configuration for a service perimeter.
        IngressPolicies match requests based on ingressFrom and ingressTo stanzas. For an ingress policy to match,
        both the ingressFrom and ingressTo stanzas must be matched. If an IngressPolicy matches a request,
        the request is allowed through the perimeter boundary from outside the perimeter.
        For example, access from the internet can be allowed either based on an AccessLevel or,
        for traffic hosted on Google Cloud, the project of the source network.
        For access from private networks, using the project of the hosting network is required.
        Individual ingress policies can be limited by restricting which services and/
        or actions they match using the ingressTo field.

        > **Note:** By default, updates to this resource will remove the IngressPolicy from the
        from the perimeter and add it back in a non-atomic manner. To ensure that the new IngressPolicy
        is added before the old one is removed, add a `lifecycle` block with `create_before_destroy = true` to this resource.

        To get more information about ServicePerimeterDryRunIngressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#ingresspolicy)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressFromArgs', 'ServicePerimeterDryRunIngressPolicyIngressFromArgsDict']] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressToArgs', 'ServicePerimeterDryRunIngressPolicyIngressToArgsDict']] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePerimeterDryRunIngressPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a single IngressPolicy in the spec (dry-run) configuration for a service perimeter.
        IngressPolicies match requests based on ingressFrom and ingressTo stanzas. For an ingress policy to match,
        both the ingressFrom and ingressTo stanzas must be matched. If an IngressPolicy matches a request,
        the request is allowed through the perimeter boundary from outside the perimeter.
        For example, access from the internet can be allowed either based on an AccessLevel or,
        for traffic hosted on Google Cloud, the project of the source network.
        For access from private networks, using the project of the hosting network is required.
        Individual ingress policies can be limited by restricting which services and/
        or actions they match using the ingressTo field.

        > **Note:** By default, updates to this resource will remove the IngressPolicy from the
        from the perimeter and add it back in a non-atomic manner. To ensure that the new IngressPolicy
        is added before the old one is removed, add a `lifecycle` block with `create_before_destroy = true` to this resource.

        To get more information about ServicePerimeterDryRunIngressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#ingresspolicy)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ServicePerimeterDryRunIngressPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePerimeterDryRunIngressPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_from: Optional[pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressFromArgs', 'ServicePerimeterDryRunIngressPolicyIngressFromArgsDict']]] = None,
                 ingress_to: Optional[pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressToArgs', 'ServicePerimeterDryRunIngressPolicyIngressToArgsDict']]] = None,
                 perimeter: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePerimeterDryRunIngressPolicyArgs.__new__(ServicePerimeterDryRunIngressPolicyArgs)

            __props__.__dict__["ingress_from"] = ingress_from
            __props__.__dict__["ingress_to"] = ingress_to
            if perimeter is None and not opts.urn:
                raise TypeError("Missing required property 'perimeter'")
            __props__.__dict__["perimeter"] = perimeter
        super(ServicePerimeterDryRunIngressPolicy, __self__).__init__(
            'gcp:accesscontextmanager/servicePerimeterDryRunIngressPolicy:ServicePerimeterDryRunIngressPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ingress_from: Optional[pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressFromArgs', 'ServicePerimeterDryRunIngressPolicyIngressFromArgsDict']]] = None,
            ingress_to: Optional[pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressToArgs', 'ServicePerimeterDryRunIngressPolicyIngressToArgsDict']]] = None,
            perimeter: Optional[pulumi.Input[str]] = None) -> 'ServicePerimeterDryRunIngressPolicy':
        """
        Get an existing ServicePerimeterDryRunIngressPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressFromArgs', 'ServicePerimeterDryRunIngressPolicyIngressFromArgsDict']] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input[Union['ServicePerimeterDryRunIngressPolicyIngressToArgs', 'ServicePerimeterDryRunIngressPolicyIngressToArgsDict']] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[str] perimeter: The name of the Service Perimeter to add this resource to.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePerimeterDryRunIngressPolicyState.__new__(_ServicePerimeterDryRunIngressPolicyState)

        __props__.__dict__["ingress_from"] = ingress_from
        __props__.__dict__["ingress_to"] = ingress_to
        __props__.__dict__["perimeter"] = perimeter
        return ServicePerimeterDryRunIngressPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> pulumi.Output[Optional['outputs.ServicePerimeterDryRunIngressPolicyIngressFrom']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> pulumi.Output[Optional['outputs.ServicePerimeterDryRunIngressPolicyIngressTo']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @property
    @pulumi.getter
    def perimeter(self) -> pulumi.Output[str]:
        """
        The name of the Service Perimeter to add this resource to.


        - - -
        """
        return pulumi.get(self, "perimeter")

