# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BackupEncryptionConfigArgs',
    'BackupEncryptionConfigArgsDict',
    'BackupEncryptionInfoArgs',
    'BackupEncryptionInfoArgsDict',
    'BackupExpiryQuantityArgs',
    'BackupExpiryQuantityArgsDict',
    'ClusterAutomatedBackupPolicyArgs',
    'ClusterAutomatedBackupPolicyArgsDict',
    'ClusterAutomatedBackupPolicyEncryptionConfigArgs',
    'ClusterAutomatedBackupPolicyEncryptionConfigArgsDict',
    'ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs',
    'ClusterAutomatedBackupPolicyQuantityBasedRetentionArgsDict',
    'ClusterAutomatedBackupPolicyTimeBasedRetentionArgs',
    'ClusterAutomatedBackupPolicyTimeBasedRetentionArgsDict',
    'ClusterAutomatedBackupPolicyWeeklyScheduleArgs',
    'ClusterAutomatedBackupPolicyWeeklyScheduleArgsDict',
    'ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs',
    'ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgsDict',
    'ClusterBackupSourceArgs',
    'ClusterBackupSourceArgsDict',
    'ClusterContinuousBackupConfigArgs',
    'ClusterContinuousBackupConfigArgsDict',
    'ClusterContinuousBackupConfigEncryptionConfigArgs',
    'ClusterContinuousBackupConfigEncryptionConfigArgsDict',
    'ClusterContinuousBackupInfoArgs',
    'ClusterContinuousBackupInfoArgsDict',
    'ClusterContinuousBackupInfoEncryptionInfoArgs',
    'ClusterContinuousBackupInfoEncryptionInfoArgsDict',
    'ClusterEncryptionConfigArgs',
    'ClusterEncryptionConfigArgsDict',
    'ClusterEncryptionInfoArgs',
    'ClusterEncryptionInfoArgsDict',
    'ClusterInitialUserArgs',
    'ClusterInitialUserArgsDict',
    'ClusterMaintenanceUpdatePolicyArgs',
    'ClusterMaintenanceUpdatePolicyArgsDict',
    'ClusterMaintenanceUpdatePolicyMaintenanceWindowArgs',
    'ClusterMaintenanceUpdatePolicyMaintenanceWindowArgsDict',
    'ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs',
    'ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgsDict',
    'ClusterMigrationSourceArgs',
    'ClusterMigrationSourceArgsDict',
    'ClusterNetworkConfigArgs',
    'ClusterNetworkConfigArgsDict',
    'ClusterPscConfigArgs',
    'ClusterPscConfigArgsDict',
    'ClusterRestoreBackupSourceArgs',
    'ClusterRestoreBackupSourceArgsDict',
    'ClusterRestoreContinuousBackupSourceArgs',
    'ClusterRestoreContinuousBackupSourceArgsDict',
    'ClusterSecondaryConfigArgs',
    'ClusterSecondaryConfigArgsDict',
    'ClusterTrialMetadataArgs',
    'ClusterTrialMetadataArgsDict',
    'InstanceClientConnectionConfigArgs',
    'InstanceClientConnectionConfigArgsDict',
    'InstanceClientConnectionConfigSslConfigArgs',
    'InstanceClientConnectionConfigSslConfigArgsDict',
    'InstanceMachineConfigArgs',
    'InstanceMachineConfigArgsDict',
    'InstanceNetworkConfigArgs',
    'InstanceNetworkConfigArgsDict',
    'InstanceNetworkConfigAuthorizedExternalNetworkArgs',
    'InstanceNetworkConfigAuthorizedExternalNetworkArgsDict',
    'InstanceObservabilityConfigArgs',
    'InstanceObservabilityConfigArgsDict',
    'InstancePscInstanceConfigArgs',
    'InstancePscInstanceConfigArgsDict',
    'InstanceQueryInsightsConfigArgs',
    'InstanceQueryInsightsConfigArgsDict',
    'InstanceReadPoolConfigArgs',
    'InstanceReadPoolConfigArgsDict',
]

MYPY = False

if not MYPY:
    class BackupEncryptionConfigArgsDict(TypedDict):
        kms_key_name: NotRequired[pulumi.Input[str]]
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
elif False:
    BackupEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupEncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


if not MYPY:
    class BackupEncryptionInfoArgsDict(TypedDict):
        encryption_type: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. Type of encryption.
        """
        kms_key_versions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
elif False:
    BackupEncryptionInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupEncryptionInfoArgs:
    def __init__(__self__, *,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 kms_key_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] encryption_type: (Output)
               Output only. Type of encryption.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")

    @kms_key_versions.setter
    def kms_key_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kms_key_versions", value)


if not MYPY:
    class BackupExpiryQuantityArgsDict(TypedDict):
        retention_count: NotRequired[pulumi.Input[int]]
        """
        (Output)
        Output only. The backup's position among its backups with the same source cluster and type, by descending chronological order create time (i.e. newest first).
        """
        total_retention_count: NotRequired[pulumi.Input[int]]
        """
        (Output)
        Output only. The length of the quantity-based queue, specified by the backup's retention policy.
        """
elif False:
    BackupExpiryQuantityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupExpiryQuantityArgs:
    def __init__(__self__, *,
                 retention_count: Optional[pulumi.Input[int]] = None,
                 total_retention_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] retention_count: (Output)
               Output only. The backup's position among its backups with the same source cluster and type, by descending chronological order create time (i.e. newest first).
        :param pulumi.Input[int] total_retention_count: (Output)
               Output only. The length of the quantity-based queue, specified by the backup's retention policy.
        """
        if retention_count is not None:
            pulumi.set(__self__, "retention_count", retention_count)
        if total_retention_count is not None:
            pulumi.set(__self__, "total_retention_count", total_retention_count)

    @property
    @pulumi.getter(name="retentionCount")
    def retention_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Output)
        Output only. The backup's position among its backups with the same source cluster and type, by descending chronological order create time (i.e. newest first).
        """
        return pulumi.get(self, "retention_count")

    @retention_count.setter
    def retention_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_count", value)

    @property
    @pulumi.getter(name="totalRetentionCount")
    def total_retention_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Output)
        Output only. The length of the quantity-based queue, specified by the backup's retention policy.
        """
        return pulumi.get(self, "total_retention_count")

    @total_retention_count.setter
    def total_retention_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_retention_count", value)


if not MYPY:
    class ClusterAutomatedBackupPolicyArgsDict(TypedDict):
        backup_window: NotRequired[pulumi.Input[str]]
        """
        The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
        The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether automated backups are enabled.
        """
        encryption_config: NotRequired[pulumi.Input['ClusterAutomatedBackupPolicyEncryptionConfigArgsDict']]
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Labels to apply to backups created using this configuration.
        """
        location: NotRequired[pulumi.Input[str]]
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        quantity_based_retention: NotRequired[pulumi.Input['ClusterAutomatedBackupPolicyQuantityBasedRetentionArgsDict']]
        """
        Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
        Structure is documented below.
        """
        time_based_retention: NotRequired[pulumi.Input['ClusterAutomatedBackupPolicyTimeBasedRetentionArgsDict']]
        """
        Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
        Structure is documented below.
        """
        weekly_schedule: NotRequired[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleArgsDict']]
        """
        Weekly schedule for the Backup.
        Structure is documented below.
        """
elif False:
    ClusterAutomatedBackupPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAutomatedBackupPolicyArgs:
    def __init__(__self__, *,
                 backup_window: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterAutomatedBackupPolicyEncryptionConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 quantity_based_retention: Optional[pulumi.Input['ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs']] = None,
                 time_based_retention: Optional[pulumi.Input['ClusterAutomatedBackupPolicyTimeBasedRetentionArgs']] = None,
                 weekly_schedule: Optional[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleArgs']] = None):
        """
        :param pulumi.Input[str] backup_window: The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
               The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[bool] enabled: Whether automated backups are enabled.
        :param pulumi.Input['ClusterAutomatedBackupPolicyEncryptionConfigArgs'] encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to backups created using this configuration.
        :param pulumi.Input[str] location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param pulumi.Input['ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs'] quantity_based_retention: Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
               Structure is documented below.
        :param pulumi.Input['ClusterAutomatedBackupPolicyTimeBasedRetentionArgs'] time_based_retention: Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
               Structure is documented below.
        :param pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleArgs'] weekly_schedule: Weekly schedule for the Backup.
               Structure is documented below.
        """
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if quantity_based_retention is not None:
            pulumi.set(__self__, "quantity_based_retention", quantity_based_retention)
        if time_based_retention is not None:
            pulumi.set(__self__, "time_based_retention", time_based_retention)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
        The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "backup_window")

    @backup_window.setter
    def backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_window", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether automated backups are enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterAutomatedBackupPolicyEncryptionConfigArgs']]:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterAutomatedBackupPolicyEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="quantityBasedRetention")
    def quantity_based_retention(self) -> Optional[pulumi.Input['ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs']]:
        """
        Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "quantity_based_retention")

    @quantity_based_retention.setter
    def quantity_based_retention(self, value: Optional[pulumi.Input['ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs']]):
        pulumi.set(self, "quantity_based_retention", value)

    @property
    @pulumi.getter(name="timeBasedRetention")
    def time_based_retention(self) -> Optional[pulumi.Input['ClusterAutomatedBackupPolicyTimeBasedRetentionArgs']]:
        """
        Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "time_based_retention")

    @time_based_retention.setter
    def time_based_retention(self, value: Optional[pulumi.Input['ClusterAutomatedBackupPolicyTimeBasedRetentionArgs']]):
        pulumi.set(self, "time_based_retention", value)

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleArgs']]:
        """
        Weekly schedule for the Backup.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")

    @weekly_schedule.setter
    def weekly_schedule(self, value: Optional[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleArgs']]):
        pulumi.set(self, "weekly_schedule", value)


if not MYPY:
    class ClusterAutomatedBackupPolicyEncryptionConfigArgsDict(TypedDict):
        kms_key_name: NotRequired[pulumi.Input[str]]
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
elif False:
    ClusterAutomatedBackupPolicyEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAutomatedBackupPolicyEncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


if not MYPY:
    class ClusterAutomatedBackupPolicyQuantityBasedRetentionArgsDict(TypedDict):
        count: NotRequired[pulumi.Input[int]]
        """
        The number of backups to retain.
        """
elif False:
    ClusterAutomatedBackupPolicyQuantityBasedRetentionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] count: The number of backups to retain.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of backups to retain.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)


if not MYPY:
    class ClusterAutomatedBackupPolicyTimeBasedRetentionArgsDict(TypedDict):
        retention_period: NotRequired[pulumi.Input[str]]
        """
        The retention period.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
elif False:
    ClusterAutomatedBackupPolicyTimeBasedRetentionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAutomatedBackupPolicyTimeBasedRetentionArgs:
    def __init__(__self__, *,
                 retention_period: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] retention_period: The retention period.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[str]]:
        """
        The retention period.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_period", value)


if not MYPY:
    class ClusterAutomatedBackupPolicyWeeklyScheduleArgsDict(TypedDict):
        start_times: pulumi.Input[Sequence[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgsDict']]]
        """
        The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
        Structure is documented below.
        """
        days_of_weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The days of the week to perform a backup. At least one day of the week must be provided.
        Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
elif False:
    ClusterAutomatedBackupPolicyWeeklyScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAutomatedBackupPolicyWeeklyScheduleArgs:
    def __init__(__self__, *,
                 start_times: pulumi.Input[Sequence[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs']]],
                 days_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs']]] start_times: The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] days_of_weeks: The days of the week to perform a backup. At least one day of the week must be provided.
               Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        pulumi.set(__self__, "start_times", start_times)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs']]]:
        """
        The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
        Structure is documented below.
        """
        return pulumi.get(self, "start_times")

    @start_times.setter
    def start_times(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs']]]):
        pulumi.set(self, "start_times", value)

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The days of the week to perform a backup. At least one day of the week must be provided.
        Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "days_of_weeks")

    @days_of_weeks.setter
    def days_of_weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "days_of_weeks", value)


if not MYPY:
    class ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgsDict(TypedDict):
        hours: NotRequired[pulumi.Input[int]]
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        minutes: NotRequired[pulumi.Input[int]]
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        nanos: NotRequired[pulumi.Input[int]]
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        seconds: NotRequired[pulumi.Input[int]]
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
elif False:
    ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[int]] = None,
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param pulumi.Input[int] minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[int]]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


if not MYPY:
    class ClusterBackupSourceArgsDict(TypedDict):
        backup_name: NotRequired[pulumi.Input[str]]
        """
        The name of the backup resource.
        """
elif False:
    ClusterBackupSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterBackupSourceArgs:
    def __init__(__self__, *,
                 backup_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] backup_name: The name of the backup resource.
        """
        if backup_name is not None:
            pulumi.set(__self__, "backup_name", backup_name)

    @property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the backup resource.
        """
        return pulumi.get(self, "backup_name")

    @backup_name.setter
    def backup_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_name", value)


if not MYPY:
    class ClusterContinuousBackupConfigArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Whether continuous backup recovery is enabled. If not set, defaults to true.
        """
        encryption_config: NotRequired[pulumi.Input['ClusterContinuousBackupConfigEncryptionConfigArgsDict']]
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        recovery_window_days: NotRequired[pulumi.Input[int]]
        """
        The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
        If not set, defaults to 14 days.
        """
elif False:
    ClusterContinuousBackupConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterContinuousBackupConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterContinuousBackupConfigEncryptionConfigArgs']] = None,
                 recovery_window_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether continuous backup recovery is enabled. If not set, defaults to true.
        :param pulumi.Input['ClusterContinuousBackupConfigEncryptionConfigArgs'] encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param pulumi.Input[int] recovery_window_days: The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
               If not set, defaults to 14 days.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if recovery_window_days is not None:
            pulumi.set(__self__, "recovery_window_days", recovery_window_days)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether continuous backup recovery is enabled. If not set, defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterContinuousBackupConfigEncryptionConfigArgs']]:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterContinuousBackupConfigEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="recoveryWindowDays")
    def recovery_window_days(self) -> Optional[pulumi.Input[int]]:
        """
        The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
        If not set, defaults to 14 days.
        """
        return pulumi.get(self, "recovery_window_days")

    @recovery_window_days.setter
    def recovery_window_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_window_days", value)


if not MYPY:
    class ClusterContinuousBackupConfigEncryptionConfigArgsDict(TypedDict):
        kms_key_name: NotRequired[pulumi.Input[str]]
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
elif False:
    ClusterContinuousBackupConfigEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterContinuousBackupConfigEncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


if not MYPY:
    class ClusterContinuousBackupInfoArgsDict(TypedDict):
        earliest_restorable_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The earliest restorable time that can be restored to. Output only field.
        """
        enabled_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        """
        encryption_infos: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoEncryptionInfoArgsDict']]]]
        """
        (Output)
        Output only. The encryption information for the WALs and backups required for ContinuousBackup.
        Structure is documented below.
        """
        schedules: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Output)
        Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
elif False:
    ClusterContinuousBackupInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterContinuousBackupInfoArgs:
    def __init__(__self__, *,
                 earliest_restorable_time: Optional[pulumi.Input[str]] = None,
                 enabled_time: Optional[pulumi.Input[str]] = None,
                 encryption_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoEncryptionInfoArgs']]]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] earliest_restorable_time: (Output)
               The earliest restorable time that can be restored to. Output only field.
        :param pulumi.Input[str] enabled_time: (Output)
               When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoEncryptionInfoArgs']]] encryption_infos: (Output)
               Output only. The encryption information for the WALs and backups required for ContinuousBackup.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schedules: (Output)
               Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
        if earliest_restorable_time is not None:
            pulumi.set(__self__, "earliest_restorable_time", earliest_restorable_time)
        if enabled_time is not None:
            pulumi.set(__self__, "enabled_time", enabled_time)
        if encryption_infos is not None:
            pulumi.set(__self__, "encryption_infos", encryption_infos)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)

    @property
    @pulumi.getter(name="earliestRestorableTime")
    def earliest_restorable_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The earliest restorable time that can be restored to. Output only field.
        """
        return pulumi.get(self, "earliest_restorable_time")

    @earliest_restorable_time.setter
    def earliest_restorable_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "earliest_restorable_time", value)

    @property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        """
        return pulumi.get(self, "enabled_time")

    @enabled_time.setter
    def enabled_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enabled_time", value)

    @property
    @pulumi.getter(name="encryptionInfos")
    def encryption_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoEncryptionInfoArgs']]]]:
        """
        (Output)
        Output only. The encryption information for the WALs and backups required for ContinuousBackup.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_infos")

    @encryption_infos.setter
    def encryption_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterContinuousBackupInfoEncryptionInfoArgs']]]]):
        pulumi.set(self, "encryption_infos", value)

    @property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Output)
        Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schedules", value)


if not MYPY:
    class ClusterContinuousBackupInfoEncryptionInfoArgsDict(TypedDict):
        encryption_type: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. Type of encryption.
        """
        kms_key_versions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
elif False:
    ClusterContinuousBackupInfoEncryptionInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterContinuousBackupInfoEncryptionInfoArgs:
    def __init__(__self__, *,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 kms_key_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] encryption_type: (Output)
               Output only. Type of encryption.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")

    @kms_key_versions.setter
    def kms_key_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kms_key_versions", value)


if not MYPY:
    class ClusterEncryptionConfigArgsDict(TypedDict):
        kms_key_name: NotRequired[pulumi.Input[str]]
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
elif False:
    ClusterEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


if not MYPY:
    class ClusterEncryptionInfoArgsDict(TypedDict):
        encryption_type: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. Type of encryption.
        """
        kms_key_versions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
elif False:
    ClusterEncryptionInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionInfoArgs:
    def __init__(__self__, *,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 kms_key_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] encryption_type: (Output)
               Output only. Type of encryption.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")

    @kms_key_versions.setter
    def kms_key_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kms_key_versions", value)


if not MYPY:
    class ClusterInitialUserArgsDict(TypedDict):
        password: pulumi.Input[str]
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        user: NotRequired[pulumi.Input[str]]
        """
        The database username.
        """
elif False:
    ClusterInitialUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterInitialUserArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 user: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] password: The initial password for the user.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] user: The database username.
        """
        pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        The database username.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


if not MYPY:
    class ClusterMaintenanceUpdatePolicyArgsDict(TypedDict):
        maintenance_windows: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowArgsDict']]]]
        """
        Preferred windows to perform maintenance. Currently limited to 1.
        Structure is documented below.
        """
elif False:
    ClusterMaintenanceUpdatePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenanceUpdatePolicyArgs:
    def __init__(__self__, *,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowArgs']]] maintenance_windows: Preferred windows to perform maintenance. Currently limited to 1.
               Structure is documented below.
        """
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowArgs']]]]:
        """
        Preferred windows to perform maintenance. Currently limited to 1.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)


if not MYPY:
    class ClusterMaintenanceUpdatePolicyMaintenanceWindowArgsDict(TypedDict):
        day: pulumi.Input[str]
        """
        Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
        Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        start_time: pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgsDict']
        """
        Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
        Structure is documented below.
        """
elif False:
    ClusterMaintenanceUpdatePolicyMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenanceUpdatePolicyMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[str],
                 start_time: pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs']):
        """
        :param pulumi.Input[str] day: Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
               Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs'] start_time: Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
               Structure is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input[str]:
        """
        Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
        Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[str]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs']:
        """
        Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input['ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs']):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgsDict(TypedDict):
        hours: pulumi.Input[int]
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        """
        minutes: NotRequired[pulumi.Input[int]]
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        nanos: NotRequired[pulumi.Input[int]]
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        seconds: NotRequired[pulumi.Input[int]]
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
elif False:
    ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs:
    def __init__(__self__, *,
                 hours: pulumi.Input[int],
                 minutes: Optional[pulumi.Input[int]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23.
        :param pulumi.Input[int] minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> pulumi.Input[int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: pulumi.Input[int]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


if not MYPY:
    class ClusterMigrationSourceArgsDict(TypedDict):
        host_port: NotRequired[pulumi.Input[str]]
        """
        The host and port of the on-premises instance in host:port format
        """
        reference_id: NotRequired[pulumi.Input[str]]
        """
        Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        """
        source_type: NotRequired[pulumi.Input[str]]
        """
        Type of migration source.
        """
elif False:
    ClusterMigrationSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMigrationSourceArgs:
    def __init__(__self__, *,
                 host_port: Optional[pulumi.Input[str]] = None,
                 reference_id: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host_port: The host and port of the on-premises instance in host:port format
        :param pulumi.Input[str] reference_id: Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        :param pulumi.Input[str] source_type: Type of migration source.
        """
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[str]]:
        """
        The host and port of the on-premises instance in host:port format
        """
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_port", value)

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        """
        return pulumi.get(self, "reference_id")

    @reference_id.setter
    def reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_id", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of migration source.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)


if not MYPY:
    class ClusterNetworkConfigArgsDict(TypedDict):
        allocated_ip_range: NotRequired[pulumi.Input[str]]
        """
        The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
        If set, the instance IPs for this cluster will be created in the allocated range.
        """
        network: NotRequired[pulumi.Input[str]]
        """
        The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
elif False:
    ClusterNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNetworkConfigArgs:
    def __init__(__self__, *,
                 allocated_ip_range: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] allocated_ip_range: The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
               If set, the instance IPs for this cluster will be created in the allocated range.
        :param pulumi.Input[str] network: The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
               It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
        If set, the instance IPs for this cluster will be created in the allocated range.
        """
        return pulumi.get(self, "allocated_ip_range")

    @allocated_ip_range.setter
    def allocated_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allocated_ip_range", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)


if not MYPY:
    class ClusterPscConfigArgsDict(TypedDict):
        psc_enabled: NotRequired[pulumi.Input[bool]]
        """
        Create an instance that allows connections from Private Service Connect endpoints to the instance.
        """
elif False:
    ClusterPscConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPscConfigArgs:
    def __init__(__self__, *,
                 psc_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] psc_enabled: Create an instance that allows connections from Private Service Connect endpoints to the instance.
        """
        if psc_enabled is not None:
            pulumi.set(__self__, "psc_enabled", psc_enabled)

    @property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Create an instance that allows connections from Private Service Connect endpoints to the instance.
        """
        return pulumi.get(self, "psc_enabled")

    @psc_enabled.setter
    def psc_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "psc_enabled", value)


if not MYPY:
    class ClusterRestoreBackupSourceArgsDict(TypedDict):
        backup_name: pulumi.Input[str]
        """
        The name of the backup that this cluster is restored from.
        """
elif False:
    ClusterRestoreBackupSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterRestoreBackupSourceArgs:
    def __init__(__self__, *,
                 backup_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] backup_name: The name of the backup that this cluster is restored from.
        """
        pulumi.set(__self__, "backup_name", backup_name)

    @property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> pulumi.Input[str]:
        """
        The name of the backup that this cluster is restored from.
        """
        return pulumi.get(self, "backup_name")

    @backup_name.setter
    def backup_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_name", value)


if not MYPY:
    class ClusterRestoreContinuousBackupSourceArgsDict(TypedDict):
        cluster: pulumi.Input[str]
        """
        The name of the source cluster that this cluster is restored from.
        """
        point_in_time: pulumi.Input[str]
        """
        The point in time that this cluster is restored to, in RFC 3339 format.
        """
elif False:
    ClusterRestoreContinuousBackupSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterRestoreContinuousBackupSourceArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[str],
                 point_in_time: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cluster: The name of the source cluster that this cluster is restored from.
        :param pulumi.Input[str] point_in_time: The point in time that this cluster is restored to, in RFC 3339 format.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "point_in_time", point_in_time)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[str]:
        """
        The name of the source cluster that this cluster is restored from.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> pulumi.Input[str]:
        """
        The point in time that this cluster is restored to, in RFC 3339 format.
        """
        return pulumi.get(self, "point_in_time")

    @point_in_time.setter
    def point_in_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "point_in_time", value)


if not MYPY:
    class ClusterSecondaryConfigArgsDict(TypedDict):
        primary_cluster_name: pulumi.Input[str]
        """
        Name of the primary cluster must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
elif False:
    ClusterSecondaryConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSecondaryConfigArgs:
    def __init__(__self__, *,
                 primary_cluster_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] primary_cluster_name: Name of the primary cluster must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        pulumi.set(__self__, "primary_cluster_name", primary_cluster_name)

    @property
    @pulumi.getter(name="primaryClusterName")
    def primary_cluster_name(self) -> pulumi.Input[str]:
        """
        Name of the primary cluster must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "primary_cluster_name")

    @primary_cluster_name.setter
    def primary_cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_cluster_name", value)


if not MYPY:
    class ClusterTrialMetadataArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[str]]
        """
        End time of the trial cluster.
        """
        grace_end_time: NotRequired[pulumi.Input[str]]
        """
        Grace end time of the trial cluster.
        """
        start_time: NotRequired[pulumi.Input[str]]
        """
        Start time of the trial cluster.
        """
        upgrade_time: NotRequired[pulumi.Input[str]]
        """
        Upgrade time of the trial cluster to standard cluster.
        """
elif False:
    ClusterTrialMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterTrialMetadataArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 grace_end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 upgrade_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_time: End time of the trial cluster.
        :param pulumi.Input[str] grace_end_time: Grace end time of the trial cluster.
        :param pulumi.Input[str] start_time: Start time of the trial cluster.
        :param pulumi.Input[str] upgrade_time: Upgrade time of the trial cluster to standard cluster.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if grace_end_time is not None:
            pulumi.set(__self__, "grace_end_time", grace_end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        End time of the trial cluster.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="graceEndTime")
    def grace_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Grace end time of the trial cluster.
        """
        return pulumi.get(self, "grace_end_time")

    @grace_end_time.setter
    def grace_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grace_end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time of the trial cluster.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[pulumi.Input[str]]:
        """
        Upgrade time of the trial cluster to standard cluster.
        """
        return pulumi.get(self, "upgrade_time")

    @upgrade_time.setter
    def upgrade_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade_time", value)


if not MYPY:
    class InstanceClientConnectionConfigArgsDict(TypedDict):
        require_connectors: NotRequired[pulumi.Input[bool]]
        """
        Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        """
        ssl_config: NotRequired[pulumi.Input['InstanceClientConnectionConfigSslConfigArgsDict']]
        """
        SSL config option for this instance.
        Structure is documented below.
        """
elif False:
    InstanceClientConnectionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceClientConnectionConfigArgs:
    def __init__(__self__, *,
                 require_connectors: Optional[pulumi.Input[bool]] = None,
                 ssl_config: Optional[pulumi.Input['InstanceClientConnectionConfigSslConfigArgs']] = None):
        """
        :param pulumi.Input[bool] require_connectors: Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        :param pulumi.Input['InstanceClientConnectionConfigSslConfigArgs'] ssl_config: SSL config option for this instance.
               Structure is documented below.
        """
        if require_connectors is not None:
            pulumi.set(__self__, "require_connectors", require_connectors)
        if ssl_config is not None:
            pulumi.set(__self__, "ssl_config", ssl_config)

    @property
    @pulumi.getter(name="requireConnectors")
    def require_connectors(self) -> Optional[pulumi.Input[bool]]:
        """
        Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        """
        return pulumi.get(self, "require_connectors")

    @require_connectors.setter
    def require_connectors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_connectors", value)

    @property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> Optional[pulumi.Input['InstanceClientConnectionConfigSslConfigArgs']]:
        """
        SSL config option for this instance.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_config")

    @ssl_config.setter
    def ssl_config(self, value: Optional[pulumi.Input['InstanceClientConnectionConfigSslConfigArgs']]):
        pulumi.set(self, "ssl_config", value)


if not MYPY:
    class InstanceClientConnectionConfigSslConfigArgsDict(TypedDict):
        ssl_mode: NotRequired[pulumi.Input[str]]
        """
        SSL mode. Specifies client-server SSL/TLS connection behavior.
        Possible values are: `ENCRYPTED_ONLY`, `ALLOW_UNENCRYPTED_AND_ENCRYPTED`.
        """
elif False:
    InstanceClientConnectionConfigSslConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceClientConnectionConfigSslConfigArgs:
    def __init__(__self__, *,
                 ssl_mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ssl_mode: SSL mode. Specifies client-server SSL/TLS connection behavior.
               Possible values are: `ENCRYPTED_ONLY`, `ALLOW_UNENCRYPTED_AND_ENCRYPTED`.
        """
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[str]]:
        """
        SSL mode. Specifies client-server SSL/TLS connection behavior.
        Possible values are: `ENCRYPTED_ONLY`, `ALLOW_UNENCRYPTED_AND_ENCRYPTED`.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_mode", value)


if not MYPY:
    class InstanceMachineConfigArgsDict(TypedDict):
        cpu_count: NotRequired[pulumi.Input[int]]
        """
        The number of CPU's in the VM instance.
        """
elif False:
    InstanceMachineConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMachineConfigArgs:
    def __init__(__self__, *,
                 cpu_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] cpu_count: The number of CPU's in the VM instance.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_count", value)


if not MYPY:
    class InstanceNetworkConfigArgsDict(TypedDict):
        authorized_external_networks: NotRequired[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkConfigAuthorizedExternalNetworkArgsDict']]]]
        """
        A list of external networks authorized to access this instance. This
        field is only allowed to be set when `enable_public_ip` is set to
        true.
        Structure is documented below.
        """
        enable_outbound_public_ip: NotRequired[pulumi.Input[bool]]
        """
        Enabling outbound public ip for the instance.
        """
        enable_public_ip: NotRequired[pulumi.Input[bool]]
        """
        Enabling public ip for the instance. If a user wishes to disable this,
        please also clear the list of the authorized external networks set on
        the same instance.
        """
elif False:
    InstanceNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNetworkConfigArgs:
    def __init__(__self__, *,
                 authorized_external_networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkConfigAuthorizedExternalNetworkArgs']]]] = None,
                 enable_outbound_public_ip: Optional[pulumi.Input[bool]] = None,
                 enable_public_ip: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkConfigAuthorizedExternalNetworkArgs']]] authorized_external_networks: A list of external networks authorized to access this instance. This
               field is only allowed to be set when `enable_public_ip` is set to
               true.
               Structure is documented below.
        :param pulumi.Input[bool] enable_outbound_public_ip: Enabling outbound public ip for the instance.
        :param pulumi.Input[bool] enable_public_ip: Enabling public ip for the instance. If a user wishes to disable this,
               please also clear the list of the authorized external networks set on
               the same instance.
        """
        if authorized_external_networks is not None:
            pulumi.set(__self__, "authorized_external_networks", authorized_external_networks)
        if enable_outbound_public_ip is not None:
            pulumi.set(__self__, "enable_outbound_public_ip", enable_outbound_public_ip)
        if enable_public_ip is not None:
            pulumi.set(__self__, "enable_public_ip", enable_public_ip)

    @property
    @pulumi.getter(name="authorizedExternalNetworks")
    def authorized_external_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkConfigAuthorizedExternalNetworkArgs']]]]:
        """
        A list of external networks authorized to access this instance. This
        field is only allowed to be set when `enable_public_ip` is set to
        true.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_external_networks")

    @authorized_external_networks.setter
    def authorized_external_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkConfigAuthorizedExternalNetworkArgs']]]]):
        pulumi.set(self, "authorized_external_networks", value)

    @property
    @pulumi.getter(name="enableOutboundPublicIp")
    def enable_outbound_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling outbound public ip for the instance.
        """
        return pulumi.get(self, "enable_outbound_public_ip")

    @enable_outbound_public_ip.setter
    def enable_outbound_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_outbound_public_ip", value)

    @property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enabling public ip for the instance. If a user wishes to disable this,
        please also clear the list of the authorized external networks set on
        the same instance.
        """
        return pulumi.get(self, "enable_public_ip")

    @enable_public_ip.setter
    def enable_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_public_ip", value)


if not MYPY:
    class InstanceNetworkConfigAuthorizedExternalNetworkArgsDict(TypedDict):
        cidr_range: NotRequired[pulumi.Input[str]]
        """
        CIDR range for one authorized network of the instance.
        """
elif False:
    InstanceNetworkConfigAuthorizedExternalNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNetworkConfigAuthorizedExternalNetworkArgs:
    def __init__(__self__, *,
                 cidr_range: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cidr_range: CIDR range for one authorized network of the instance.
        """
        if cidr_range is not None:
            pulumi.set(__self__, "cidr_range", cidr_range)

    @property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR range for one authorized network of the instance.
        """
        return pulumi.get(self, "cidr_range")

    @cidr_range.setter
    def cidr_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_range", value)


if not MYPY:
    class InstanceObservabilityConfigArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Observability feature status for an instance.
        """
        max_query_string_length: NotRequired[pulumi.Input[int]]
        """
        Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        """
        preserve_comments: NotRequired[pulumi.Input[bool]]
        """
        Preserve comments in the query string.
        """
        query_plans_per_minute: NotRequired[pulumi.Input[int]]
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        """
        record_application_tags: NotRequired[pulumi.Input[bool]]
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        track_active_queries: NotRequired[pulumi.Input[bool]]
        """
        Track actively running queries. If not set, default value is "off".
        """
        track_wait_event_types: NotRequired[pulumi.Input[bool]]
        """
        Record wait event types during query execution for an instance.
        """
        track_wait_events: NotRequired[pulumi.Input[bool]]
        """
        Record wait events during query execution for an instance.
        """
elif False:
    InstanceObservabilityConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceObservabilityConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 max_query_string_length: Optional[pulumi.Input[int]] = None,
                 preserve_comments: Optional[pulumi.Input[bool]] = None,
                 query_plans_per_minute: Optional[pulumi.Input[int]] = None,
                 record_application_tags: Optional[pulumi.Input[bool]] = None,
                 track_active_queries: Optional[pulumi.Input[bool]] = None,
                 track_wait_event_types: Optional[pulumi.Input[bool]] = None,
                 track_wait_events: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Observability feature status for an instance.
        :param pulumi.Input[int] max_query_string_length: Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        :param pulumi.Input[bool] preserve_comments: Preserve comments in the query string.
        :param pulumi.Input[int] query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        :param pulumi.Input[bool] record_application_tags: Record application tags for an instance. This flag is turned "on" by default.
        :param pulumi.Input[bool] track_active_queries: Track actively running queries. If not set, default value is "off".
        :param pulumi.Input[bool] track_wait_event_types: Record wait event types during query execution for an instance.
        :param pulumi.Input[bool] track_wait_events: Record wait events during query execution for an instance.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_query_string_length is not None:
            pulumi.set(__self__, "max_query_string_length", max_query_string_length)
        if preserve_comments is not None:
            pulumi.set(__self__, "preserve_comments", preserve_comments)
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if track_active_queries is not None:
            pulumi.set(__self__, "track_active_queries", track_active_queries)
        if track_wait_event_types is not None:
            pulumi.set(__self__, "track_wait_event_types", track_wait_event_types)
        if track_wait_events is not None:
            pulumi.set(__self__, "track_wait_events", track_wait_events)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Observability feature status for an instance.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="maxQueryStringLength")
    def max_query_string_length(self) -> Optional[pulumi.Input[int]]:
        """
        Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        """
        return pulumi.get(self, "max_query_string_length")

    @max_query_string_length.setter
    def max_query_string_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_query_string_length", value)

    @property
    @pulumi.getter(name="preserveComments")
    def preserve_comments(self) -> Optional[pulumi.Input[bool]]:
        """
        Preserve comments in the query string.
        """
        return pulumi.get(self, "preserve_comments")

    @preserve_comments.setter
    def preserve_comments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_comments", value)

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[pulumi.Input[int]]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @query_plans_per_minute.setter
    def query_plans_per_minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_plans_per_minute", value)

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_application_tags")

    @record_application_tags.setter
    def record_application_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_application_tags", value)

    @property
    @pulumi.getter(name="trackActiveQueries")
    def track_active_queries(self) -> Optional[pulumi.Input[bool]]:
        """
        Track actively running queries. If not set, default value is "off".
        """
        return pulumi.get(self, "track_active_queries")

    @track_active_queries.setter
    def track_active_queries(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_active_queries", value)

    @property
    @pulumi.getter(name="trackWaitEventTypes")
    def track_wait_event_types(self) -> Optional[pulumi.Input[bool]]:
        """
        Record wait event types during query execution for an instance.
        """
        return pulumi.get(self, "track_wait_event_types")

    @track_wait_event_types.setter
    def track_wait_event_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_wait_event_types", value)

    @property
    @pulumi.getter(name="trackWaitEvents")
    def track_wait_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Record wait events during query execution for an instance.
        """
        return pulumi.get(self, "track_wait_events")

    @track_wait_events.setter
    def track_wait_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "track_wait_events", value)


if not MYPY:
    class InstancePscInstanceConfigArgsDict(TypedDict):
        allowed_consumer_projects: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
        These should be specified as project numbers only.
        """
        psc_dns_name: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The DNS name of the instance for PSC connectivity.
        Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        """
        service_attachment_link: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The service attachment created when Private Service Connect (PSC) is enabled for the instance.
        The name of the resource will be in the format of
        `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
        """
elif False:
    InstancePscInstanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePscInstanceConfigArgs:
    def __init__(__self__, *,
                 allowed_consumer_projects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 psc_dns_name: Optional[pulumi.Input[str]] = None,
                 service_attachment_link: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_consumer_projects: List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
               These should be specified as project numbers only.
        :param pulumi.Input[str] psc_dns_name: (Output)
               The DNS name of the instance for PSC connectivity.
               Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        :param pulumi.Input[str] service_attachment_link: (Output)
               The service attachment created when Private Service Connect (PSC) is enabled for the instance.
               The name of the resource will be in the format of
               `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
        """
        if allowed_consumer_projects is not None:
            pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        if psc_dns_name is not None:
            pulumi.set(__self__, "psc_dns_name", psc_dns_name)
        if service_attachment_link is not None:
            pulumi.set(__self__, "service_attachment_link", service_attachment_link)

    @property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
        These should be specified as project numbers only.
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @allowed_consumer_projects.setter
    def allowed_consumer_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_consumer_projects", value)

    @property
    @pulumi.getter(name="pscDnsName")
    def psc_dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The DNS name of the instance for PSC connectivity.
        Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        """
        return pulumi.get(self, "psc_dns_name")

    @psc_dns_name.setter
    def psc_dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psc_dns_name", value)

    @property
    @pulumi.getter(name="serviceAttachmentLink")
    def service_attachment_link(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The service attachment created when Private Service Connect (PSC) is enabled for the instance.
        The name of the resource will be in the format of
        `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
        """
        return pulumi.get(self, "service_attachment_link")

    @service_attachment_link.setter
    def service_attachment_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_attachment_link", value)


if not MYPY:
    class InstanceQueryInsightsConfigArgsDict(TypedDict):
        query_plans_per_minute: NotRequired[pulumi.Input[int]]
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        """
        query_string_length: NotRequired[pulumi.Input[int]]
        """
        Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        """
        record_application_tags: NotRequired[pulumi.Input[bool]]
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        record_client_address: NotRequired[pulumi.Input[bool]]
        """
        Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
elif False:
    InstanceQueryInsightsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceQueryInsightsConfigArgs:
    def __init__(__self__, *,
                 query_plans_per_minute: Optional[pulumi.Input[int]] = None,
                 query_string_length: Optional[pulumi.Input[int]] = None,
                 record_application_tags: Optional[pulumi.Input[bool]] = None,
                 record_client_address: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        :param pulumi.Input[int] query_string_length: Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        :param pulumi.Input[bool] record_application_tags: Record application tags for an instance. This flag is turned "on" by default.
        :param pulumi.Input[bool] record_client_address: Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[pulumi.Input[int]]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @query_plans_per_minute.setter
    def query_plans_per_minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_plans_per_minute", value)

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[pulumi.Input[int]]:
        """
        Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        """
        return pulumi.get(self, "query_string_length")

    @query_string_length.setter
    def query_string_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_string_length", value)

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_application_tags")

    @record_application_tags.setter
    def record_application_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_application_tags", value)

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_client_address")

    @record_client_address.setter
    def record_client_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_client_address", value)


if not MYPY:
    class InstanceReadPoolConfigArgsDict(TypedDict):
        node_count: NotRequired[pulumi.Input[int]]
        """
        Read capacity, i.e. number of nodes in a read pool instance.
        """
elif False:
    InstanceReadPoolConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceReadPoolConfigArgs:
    def __init__(__self__, *,
                 node_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] node_count: Read capacity, i.e. number of nodes in a read pool instance.
        """
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Read capacity, i.e. number of nodes in a read pool instance.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)


