# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupEncryptionConfig',
    'BackupEncryptionInfo',
    'BackupExpiryQuantity',
    'ClusterAutomatedBackupPolicy',
    'ClusterAutomatedBackupPolicyEncryptionConfig',
    'ClusterAutomatedBackupPolicyQuantityBasedRetention',
    'ClusterAutomatedBackupPolicyTimeBasedRetention',
    'ClusterAutomatedBackupPolicyWeeklySchedule',
    'ClusterAutomatedBackupPolicyWeeklyScheduleStartTime',
    'ClusterBackupSource',
    'ClusterContinuousBackupConfig',
    'ClusterContinuousBackupConfigEncryptionConfig',
    'ClusterContinuousBackupInfo',
    'ClusterContinuousBackupInfoEncryptionInfo',
    'ClusterEncryptionConfig',
    'ClusterEncryptionInfo',
    'ClusterInitialUser',
    'ClusterMaintenanceUpdatePolicy',
    'ClusterMaintenanceUpdatePolicyMaintenanceWindow',
    'ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTime',
    'ClusterMigrationSource',
    'ClusterNetworkConfig',
    'ClusterPscConfig',
    'ClusterRestoreBackupSource',
    'ClusterRestoreContinuousBackupSource',
    'ClusterSecondaryConfig',
    'ClusterTrialMetadata',
    'InstanceClientConnectionConfig',
    'InstanceClientConnectionConfigSslConfig',
    'InstanceMachineConfig',
    'InstanceNetworkConfig',
    'InstanceNetworkConfigAuthorizedExternalNetwork',
    'InstanceObservabilityConfig',
    'InstancePscInstanceConfig',
    'InstanceQueryInsightsConfig',
    'InstanceReadPoolConfig',
    'GetLocationsLocationResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult',
    'GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult',
]

@pulumi.output_type
class BackupEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class BackupEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersions":
            suggest = "kms_key_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[str] = None,
                 kms_key_versions: Optional[Sequence[str]] = None):
        """
        :param str encryption_type: (Output)
               Output only. Type of encryption.
        :param Sequence[str] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[str]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[Sequence[str]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class BackupExpiryQuantity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionCount":
            suggest = "retention_count"
        elif key == "totalRetentionCount":
            suggest = "total_retention_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupExpiryQuantity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupExpiryQuantity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupExpiryQuantity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_count: Optional[int] = None,
                 total_retention_count: Optional[int] = None):
        """
        :param int retention_count: (Output)
               Output only. The backup's position among its backups with the same source cluster and type, by descending chronological order create time (i.e. newest first).
        :param int total_retention_count: (Output)
               Output only. The length of the quantity-based queue, specified by the backup's retention policy.
        """
        if retention_count is not None:
            pulumi.set(__self__, "retention_count", retention_count)
        if total_retention_count is not None:
            pulumi.set(__self__, "total_retention_count", total_retention_count)

    @property
    @pulumi.getter(name="retentionCount")
    def retention_count(self) -> Optional[int]:
        """
        (Output)
        Output only. The backup's position among its backups with the same source cluster and type, by descending chronological order create time (i.e. newest first).
        """
        return pulumi.get(self, "retention_count")

    @property
    @pulumi.getter(name="totalRetentionCount")
    def total_retention_count(self) -> Optional[int]:
        """
        (Output)
        Output only. The length of the quantity-based queue, specified by the backup's retention policy.
        """
        return pulumi.get(self, "total_retention_count")


@pulumi.output_type
class ClusterAutomatedBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupWindow":
            suggest = "backup_window"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "quantityBasedRetention":
            suggest = "quantity_based_retention"
        elif key == "timeBasedRetention":
            suggest = "time_based_retention"
        elif key == "weeklySchedule":
            suggest = "weekly_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_window: Optional[str] = None,
                 enabled: Optional[bool] = None,
                 encryption_config: Optional['outputs.ClusterAutomatedBackupPolicyEncryptionConfig'] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 location: Optional[str] = None,
                 quantity_based_retention: Optional['outputs.ClusterAutomatedBackupPolicyQuantityBasedRetention'] = None,
                 time_based_retention: Optional['outputs.ClusterAutomatedBackupPolicyTimeBasedRetention'] = None,
                 weekly_schedule: Optional['outputs.ClusterAutomatedBackupPolicyWeeklySchedule'] = None):
        """
        :param str backup_window: The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
               The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param bool enabled: Whether automated backups are enabled.
        :param 'ClusterAutomatedBackupPolicyEncryptionConfigArgs' encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param Mapping[str, str] labels: Labels to apply to backups created using this configuration.
        :param str location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param 'ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs' quantity_based_retention: Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
               Structure is documented below.
        :param 'ClusterAutomatedBackupPolicyTimeBasedRetentionArgs' time_based_retention: Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
               Structure is documented below.
        :param 'ClusterAutomatedBackupPolicyWeeklyScheduleArgs' weekly_schedule: Weekly schedule for the Backup.
               Structure is documented below.
        """
        if backup_window is not None:
            pulumi.set(__self__, "backup_window", backup_window)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if quantity_based_retention is not None:
            pulumi.set(__self__, "quantity_based_retention", quantity_based_retention)
        if time_based_retention is not None:
            pulumi.set(__self__, "time_based_retention", time_based_retention)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> Optional[str]:
        """
        The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
        The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether automated backups are enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.ClusterAutomatedBackupPolicyEncryptionConfig']:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="quantityBasedRetention")
    def quantity_based_retention(self) -> Optional['outputs.ClusterAutomatedBackupPolicyQuantityBasedRetention']:
        """
        Quantity-based Backup retention policy to retain recent backups. Conflicts with 'time_based_retention', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "quantity_based_retention")

    @property
    @pulumi.getter(name="timeBasedRetention")
    def time_based_retention(self) -> Optional['outputs.ClusterAutomatedBackupPolicyTimeBasedRetention']:
        """
        Time-based Backup retention policy. Conflicts with 'quantity_based_retention', both can't be set together.
        Structure is documented below.
        """
        return pulumi.get(self, "time_based_retention")

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional['outputs.ClusterAutomatedBackupPolicyWeeklySchedule']:
        """
        Weekly schedule for the Backup.
        Structure is documented below.
        """
        return pulumi.get(self, "weekly_schedule")


@pulumi.output_type
class ClusterAutomatedBackupPolicyEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterAutomatedBackupPolicyQuantityBasedRetention(dict):
    def __init__(__self__, *,
                 count: Optional[int] = None):
        """
        :param int count: The number of backups to retain.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The number of backups to retain.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class ClusterAutomatedBackupPolicyTimeBasedRetention(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyTimeBasedRetention. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyTimeBasedRetention.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyTimeBasedRetention.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period: Optional[str] = None):
        """
        :param str retention_period: The retention period.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[str]:
        """
        The retention period.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class ClusterAutomatedBackupPolicyWeeklySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTimes":
            suggest = "start_times"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutomatedBackupPolicyWeeklySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutomatedBackupPolicyWeeklySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutomatedBackupPolicyWeeklySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_times: Sequence['outputs.ClusterAutomatedBackupPolicyWeeklyScheduleStartTime'],
                 days_of_weeks: Optional[Sequence[str]] = None):
        """
        :param Sequence['ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs'] start_times: The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
               Structure is documented below.
        :param Sequence[str] days_of_weeks: The days of the week to perform a backup. At least one day of the week must be provided.
               Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        pulumi.set(__self__, "start_times", start_times)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)

    @property
    @pulumi.getter(name="startTimes")
    def start_times(self) -> Sequence['outputs.ClusterAutomatedBackupPolicyWeeklyScheduleStartTime']:
        """
        The times during the day to start a backup. At least one start time must be provided. The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
        Structure is documented below.
        """
        return pulumi.get(self, "start_times")

    @property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[str]]:
        """
        The days of the week to perform a backup. At least one day of the week must be provided.
        Each value may be one of: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "days_of_weeks")


@pulumi.output_type
class ClusterAutomatedBackupPolicyWeeklyScheduleStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[int] = None,
                 minutes: Optional[int] = None,
                 nanos: Optional[int] = None,
                 seconds: Optional[int] = None):
        """
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param int nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param int seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> Optional[int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[int]:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ClusterBackupSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupName":
            suggest = "backup_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBackupSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBackupSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBackupSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_name: Optional[str] = None):
        """
        :param str backup_name: The name of the backup resource.
        """
        if backup_name is not None:
            pulumi.set(__self__, "backup_name", backup_name)

    @property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> Optional[str]:
        """
        The name of the backup resource.
        """
        return pulumi.get(self, "backup_name")


@pulumi.output_type
class ClusterContinuousBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "recoveryWindowDays":
            suggest = "recovery_window_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterContinuousBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterContinuousBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterContinuousBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 encryption_config: Optional['outputs.ClusterContinuousBackupConfigEncryptionConfig'] = None,
                 recovery_window_days: Optional[int] = None):
        """
        :param bool enabled: Whether continuous backup recovery is enabled. If not set, defaults to true.
        :param 'ClusterContinuousBackupConfigEncryptionConfigArgs' encryption_config: EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
               Structure is documented below.
        :param int recovery_window_days: The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
               If not set, defaults to 14 days.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if recovery_window_days is not None:
            pulumi.set(__self__, "recovery_window_days", recovery_window_days)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether continuous backup recovery is enabled. If not set, defaults to true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.ClusterContinuousBackupConfigEncryptionConfig']:
        """
        EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="recoveryWindowDays")
    def recovery_window_days(self) -> Optional[int]:
        """
        The numbers of days that are eligible to restore from using PITR. To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
        If not set, defaults to 14 days.
        """
        return pulumi.get(self, "recovery_window_days")


@pulumi.output_type
class ClusterContinuousBackupConfigEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterContinuousBackupConfigEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterContinuousBackupConfigEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterContinuousBackupConfigEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterContinuousBackupInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "earliestRestorableTime":
            suggest = "earliest_restorable_time"
        elif key == "enabledTime":
            suggest = "enabled_time"
        elif key == "encryptionInfos":
            suggest = "encryption_infos"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterContinuousBackupInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterContinuousBackupInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterContinuousBackupInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 earliest_restorable_time: Optional[str] = None,
                 enabled_time: Optional[str] = None,
                 encryption_infos: Optional[Sequence['outputs.ClusterContinuousBackupInfoEncryptionInfo']] = None,
                 schedules: Optional[Sequence[str]] = None):
        """
        :param str earliest_restorable_time: (Output)
               The earliest restorable time that can be restored to. Output only field.
        :param str enabled_time: (Output)
               When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        :param Sequence['ClusterContinuousBackupInfoEncryptionInfoArgs'] encryption_infos: (Output)
               Output only. The encryption information for the WALs and backups required for ContinuousBackup.
               Structure is documented below.
        :param Sequence[str] schedules: (Output)
               Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
        if earliest_restorable_time is not None:
            pulumi.set(__self__, "earliest_restorable_time", earliest_restorable_time)
        if enabled_time is not None:
            pulumi.set(__self__, "enabled_time", enabled_time)
        if encryption_infos is not None:
            pulumi.set(__self__, "encryption_infos", encryption_infos)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)

    @property
    @pulumi.getter(name="earliestRestorableTime")
    def earliest_restorable_time(self) -> Optional[str]:
        """
        (Output)
        The earliest restorable time that can be restored to. Output only field.
        """
        return pulumi.get(self, "earliest_restorable_time")

    @property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> Optional[str]:
        """
        (Output)
        When ContinuousBackup was most recently enabled. Set to null if ContinuousBackup is not enabled.
        """
        return pulumi.get(self, "enabled_time")

    @property
    @pulumi.getter(name="encryptionInfos")
    def encryption_infos(self) -> Optional[Sequence['outputs.ClusterContinuousBackupInfoEncryptionInfo']]:
        """
        (Output)
        Output only. The encryption information for the WALs and backups required for ContinuousBackup.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_infos")

    @property
    @pulumi.getter
    def schedules(self) -> Optional[Sequence[str]]:
        """
        (Output)
        Days of the week on which a continuous backup is taken. Output only field. Ignored if passed into the request.
        """
        return pulumi.get(self, "schedules")


@pulumi.output_type
class ClusterContinuousBackupInfoEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersions":
            suggest = "kms_key_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterContinuousBackupInfoEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterContinuousBackupInfoEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterContinuousBackupInfoEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[str] = None,
                 kms_key_versions: Optional[Sequence[str]] = None):
        """
        :param str encryption_type: (Output)
               Output only. Type of encryption.
        :param Sequence[str] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[str]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[Sequence[str]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class ClusterEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        The fully-qualified resource name of the KMS key. Each Cloud KMS key is regionalized and has the following format: projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ClusterEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersions":
            suggest = "kms_key_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: Optional[str] = None,
                 kms_key_versions: Optional[Sequence[str]] = None):
        """
        :param str encryption_type: (Output)
               Output only. Type of encryption.
        :param Sequence[str] kms_key_versions: (Output)
               Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_versions is not None:
            pulumi.set(__self__, "kms_key_versions", kms_key_versions)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[str]:
        """
        (Output)
        Output only. Type of encryption.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKeyVersions")
    def kms_key_versions(self) -> Optional[Sequence[str]]:
        """
        (Output)
        Output only. Cloud KMS key versions that are being used to protect the database or the backup.
        """
        return pulumi.get(self, "kms_key_versions")


@pulumi.output_type
class ClusterInitialUser(dict):
    def __init__(__self__, *,
                 password: str,
                 user: Optional[str] = None):
        """
        :param str password: The initial password for the user.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str user: The database username.
        """
        pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        The database username.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ClusterMaintenanceUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maintenanceWindows":
            suggest = "maintenance_windows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenanceUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenanceUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenanceUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maintenance_windows: Optional[Sequence['outputs.ClusterMaintenanceUpdatePolicyMaintenanceWindow']] = None):
        """
        :param Sequence['ClusterMaintenanceUpdatePolicyMaintenanceWindowArgs'] maintenance_windows: Preferred windows to perform maintenance. Currently limited to 1.
               Structure is documented below.
        """
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[Sequence['outputs.ClusterMaintenanceUpdatePolicyMaintenanceWindow']]:
        """
        Preferred windows to perform maintenance. Currently limited to 1.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_windows")


@pulumi.output_type
class ClusterMaintenanceUpdatePolicyMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenanceUpdatePolicyMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenanceUpdatePolicyMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenanceUpdatePolicyMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: str,
                 start_time: 'outputs.ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTime'):
        """
        :param str day: Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
               Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        :param 'ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTimeArgs' start_time: Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
               Structure is documented below.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY, etc.
        Possible values are: `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> 'outputs.ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTime':
        """
        Preferred time to start the maintenance operation on the specified day. Maintenance will start within 1 hour of this time.
        Structure is documented below.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterMaintenanceUpdatePolicyMaintenanceWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: int,
                 minutes: Optional[int] = None,
                 nanos: Optional[int] = None,
                 seconds: Optional[int] = None):
        """
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23.
        :param int minutes: Minutes of hour of day. Currently, only the value 0 is supported.
        :param int nanos: Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        :param int seconds: Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[int]:
        """
        Minutes of hour of day. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[int]:
        """
        Fractions of seconds in nanoseconds. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> Optional[int]:
        """
        Seconds of minutes of the time. Currently, only the value 0 is supported.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ClusterMigrationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostPort":
            suggest = "host_port"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMigrationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMigrationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMigrationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_port: Optional[str] = None,
                 reference_id: Optional[str] = None,
                 source_type: Optional[str] = None):
        """
        :param str host_port: The host and port of the on-premises instance in host:port format
        :param str reference_id: Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        :param str source_type: Type of migration source.
        """
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[str]:
        """
        The host and port of the on-premises instance in host:port format
        """
        return pulumi.get(self, "host_port")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[str]:
        """
        Place holder for the external source identifier(e.g DMS job name) that created the cluster.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        """
        Type of migration source.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class ClusterNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedIpRange":
            suggest = "allocated_ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_ip_range: Optional[str] = None,
                 network: Optional[str] = None):
        """
        :param str allocated_ip_range: The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
               If set, the instance IPs for this cluster will be created in the allocated range.
        :param str network: The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
               It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[str]:
        """
        The name of the allocated IP range for the private IP AlloyDB cluster. For example: "google-managed-services-default".
        If set, the instance IPs for this cluster will be created in the allocated range.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class ClusterPscConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pscEnabled":
            suggest = "psc_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPscConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPscConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPscConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 psc_enabled: Optional[bool] = None):
        """
        :param bool psc_enabled: Create an instance that allows connections from Private Service Connect endpoints to the instance.
        """
        if psc_enabled is not None:
            pulumi.set(__self__, "psc_enabled", psc_enabled)

    @property
    @pulumi.getter(name="pscEnabled")
    def psc_enabled(self) -> Optional[bool]:
        """
        Create an instance that allows connections from Private Service Connect endpoints to the instance.
        """
        return pulumi.get(self, "psc_enabled")


@pulumi.output_type
class ClusterRestoreBackupSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupName":
            suggest = "backup_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestoreBackupSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestoreBackupSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestoreBackupSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_name: str):
        """
        :param str backup_name: The name of the backup that this cluster is restored from.
        """
        pulumi.set(__self__, "backup_name", backup_name)

    @property
    @pulumi.getter(name="backupName")
    def backup_name(self) -> str:
        """
        The name of the backup that this cluster is restored from.
        """
        return pulumi.get(self, "backup_name")


@pulumi.output_type
class ClusterRestoreContinuousBackupSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pointInTime":
            suggest = "point_in_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestoreContinuousBackupSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestoreContinuousBackupSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestoreContinuousBackupSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: str,
                 point_in_time: str):
        """
        :param str cluster: The name of the source cluster that this cluster is restored from.
        :param str point_in_time: The point in time that this cluster is restored to, in RFC 3339 format.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "point_in_time", point_in_time)

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        The name of the source cluster that this cluster is restored from.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> str:
        """
        The point in time that this cluster is restored to, in RFC 3339 format.
        """
        return pulumi.get(self, "point_in_time")


@pulumi.output_type
class ClusterSecondaryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryClusterName":
            suggest = "primary_cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSecondaryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSecondaryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSecondaryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primary_cluster_name: str):
        """
        :param str primary_cluster_name: Name of the primary cluster must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        pulumi.set(__self__, "primary_cluster_name", primary_cluster_name)

    @property
    @pulumi.getter(name="primaryClusterName")
    def primary_cluster_name(self) -> str:
        """
        Name of the primary cluster must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "primary_cluster_name")


@pulumi.output_type
class ClusterTrialMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "graceEndTime":
            suggest = "grace_end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "upgradeTime":
            suggest = "upgrade_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTrialMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTrialMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTrialMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 grace_end_time: Optional[str] = None,
                 start_time: Optional[str] = None,
                 upgrade_time: Optional[str] = None):
        """
        :param str end_time: End time of the trial cluster.
        :param str grace_end_time: Grace end time of the trial cluster.
        :param str start_time: Start time of the trial cluster.
        :param str upgrade_time: Upgrade time of the trial cluster to standard cluster.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if grace_end_time is not None:
            pulumi.set(__self__, "grace_end_time", grace_end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if upgrade_time is not None:
            pulumi.set(__self__, "upgrade_time", upgrade_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        End time of the trial cluster.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="graceEndTime")
    def grace_end_time(self) -> Optional[str]:
        """
        Grace end time of the trial cluster.
        """
        return pulumi.get(self, "grace_end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Start time of the trial cluster.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="upgradeTime")
    def upgrade_time(self) -> Optional[str]:
        """
        Upgrade time of the trial cluster to standard cluster.
        """
        return pulumi.get(self, "upgrade_time")


@pulumi.output_type
class InstanceClientConnectionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requireConnectors":
            suggest = "require_connectors"
        elif key == "sslConfig":
            suggest = "ssl_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceClientConnectionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceClientConnectionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceClientConnectionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 require_connectors: Optional[bool] = None,
                 ssl_config: Optional['outputs.InstanceClientConnectionConfigSslConfig'] = None):
        """
        :param bool require_connectors: Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        :param 'InstanceClientConnectionConfigSslConfigArgs' ssl_config: SSL config option for this instance.
               Structure is documented below.
        """
        if require_connectors is not None:
            pulumi.set(__self__, "require_connectors", require_connectors)
        if ssl_config is not None:
            pulumi.set(__self__, "ssl_config", ssl_config)

    @property
    @pulumi.getter(name="requireConnectors")
    def require_connectors(self) -> Optional[bool]:
        """
        Configuration to enforce connectors only (ex: AuthProxy) connections to the database.
        """
        return pulumi.get(self, "require_connectors")

    @property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> Optional['outputs.InstanceClientConnectionConfigSslConfig']:
        """
        SSL config option for this instance.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_config")


@pulumi.output_type
class InstanceClientConnectionConfigSslConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslMode":
            suggest = "ssl_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceClientConnectionConfigSslConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceClientConnectionConfigSslConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceClientConnectionConfigSslConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssl_mode: Optional[str] = None):
        """
        :param str ssl_mode: SSL mode. Specifies client-server SSL/TLS connection behavior.
               Possible values are: `ENCRYPTED_ONLY`, `ALLOW_UNENCRYPTED_AND_ENCRYPTED`.
        """
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[str]:
        """
        SSL mode. Specifies client-server SSL/TLS connection behavior.
        Possible values are: `ENCRYPTED_ONLY`, `ALLOW_UNENCRYPTED_AND_ENCRYPTED`.
        """
        return pulumi.get(self, "ssl_mode")


@pulumi.output_type
class InstanceMachineConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMachineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMachineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMachineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: Optional[int] = None):
        """
        :param int cpu_count: The number of CPU's in the VM instance.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[int]:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")


@pulumi.output_type
class InstanceNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizedExternalNetworks":
            suggest = "authorized_external_networks"
        elif key == "enableOutboundPublicIp":
            suggest = "enable_outbound_public_ip"
        elif key == "enablePublicIp":
            suggest = "enable_public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorized_external_networks: Optional[Sequence['outputs.InstanceNetworkConfigAuthorizedExternalNetwork']] = None,
                 enable_outbound_public_ip: Optional[bool] = None,
                 enable_public_ip: Optional[bool] = None):
        """
        :param Sequence['InstanceNetworkConfigAuthorizedExternalNetworkArgs'] authorized_external_networks: A list of external networks authorized to access this instance. This
               field is only allowed to be set when `enable_public_ip` is set to
               true.
               Structure is documented below.
        :param bool enable_outbound_public_ip: Enabling outbound public ip for the instance.
        :param bool enable_public_ip: Enabling public ip for the instance. If a user wishes to disable this,
               please also clear the list of the authorized external networks set on
               the same instance.
        """
        if authorized_external_networks is not None:
            pulumi.set(__self__, "authorized_external_networks", authorized_external_networks)
        if enable_outbound_public_ip is not None:
            pulumi.set(__self__, "enable_outbound_public_ip", enable_outbound_public_ip)
        if enable_public_ip is not None:
            pulumi.set(__self__, "enable_public_ip", enable_public_ip)

    @property
    @pulumi.getter(name="authorizedExternalNetworks")
    def authorized_external_networks(self) -> Optional[Sequence['outputs.InstanceNetworkConfigAuthorizedExternalNetwork']]:
        """
        A list of external networks authorized to access this instance. This
        field is only allowed to be set when `enable_public_ip` is set to
        true.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_external_networks")

    @property
    @pulumi.getter(name="enableOutboundPublicIp")
    def enable_outbound_public_ip(self) -> Optional[bool]:
        """
        Enabling outbound public ip for the instance.
        """
        return pulumi.get(self, "enable_outbound_public_ip")

    @property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> Optional[bool]:
        """
        Enabling public ip for the instance. If a user wishes to disable this,
        please also clear the list of the authorized external networks set on
        the same instance.
        """
        return pulumi.get(self, "enable_public_ip")


@pulumi.output_type
class InstanceNetworkConfigAuthorizedExternalNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrRange":
            suggest = "cidr_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkConfigAuthorizedExternalNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkConfigAuthorizedExternalNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkConfigAuthorizedExternalNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_range: Optional[str] = None):
        """
        :param str cidr_range: CIDR range for one authorized network of the instance.
        """
        if cidr_range is not None:
            pulumi.set(__self__, "cidr_range", cidr_range)

    @property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> Optional[str]:
        """
        CIDR range for one authorized network of the instance.
        """
        return pulumi.get(self, "cidr_range")


@pulumi.output_type
class InstanceObservabilityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxQueryStringLength":
            suggest = "max_query_string_length"
        elif key == "preserveComments":
            suggest = "preserve_comments"
        elif key == "queryPlansPerMinute":
            suggest = "query_plans_per_minute"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "trackActiveQueries":
            suggest = "track_active_queries"
        elif key == "trackWaitEventTypes":
            suggest = "track_wait_event_types"
        elif key == "trackWaitEvents":
            suggest = "track_wait_events"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceObservabilityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceObservabilityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceObservabilityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 max_query_string_length: Optional[int] = None,
                 preserve_comments: Optional[bool] = None,
                 query_plans_per_minute: Optional[int] = None,
                 record_application_tags: Optional[bool] = None,
                 track_active_queries: Optional[bool] = None,
                 track_wait_event_types: Optional[bool] = None,
                 track_wait_events: Optional[bool] = None):
        """
        :param bool enabled: Observability feature status for an instance.
        :param int max_query_string_length: Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        :param bool preserve_comments: Preserve comments in the query string.
        :param int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        :param bool record_application_tags: Record application tags for an instance. This flag is turned "on" by default.
        :param bool track_active_queries: Track actively running queries. If not set, default value is "off".
        :param bool track_wait_event_types: Record wait event types during query execution for an instance.
        :param bool track_wait_events: Record wait events during query execution for an instance.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_query_string_length is not None:
            pulumi.set(__self__, "max_query_string_length", max_query_string_length)
        if preserve_comments is not None:
            pulumi.set(__self__, "preserve_comments", preserve_comments)
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if track_active_queries is not None:
            pulumi.set(__self__, "track_active_queries", track_active_queries)
        if track_wait_event_types is not None:
            pulumi.set(__self__, "track_wait_event_types", track_wait_event_types)
        if track_wait_events is not None:
            pulumi.set(__self__, "track_wait_events", track_wait_events)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Observability feature status for an instance.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="maxQueryStringLength")
    def max_query_string_length(self) -> Optional[int]:
        """
        Query string length. The default value is 10240. Any integer between 1024 and 100000 is considered valid.
        """
        return pulumi.get(self, "max_query_string_length")

    @property
    @pulumi.getter(name="preserveComments")
    def preserve_comments(self) -> Optional[bool]:
        """
        Preserve comments in the query string.
        """
        return pulumi.get(self, "preserve_comments")

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[int]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 200 is considered valid.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[bool]:
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="trackActiveQueries")
    def track_active_queries(self) -> Optional[bool]:
        """
        Track actively running queries. If not set, default value is "off".
        """
        return pulumi.get(self, "track_active_queries")

    @property
    @pulumi.getter(name="trackWaitEventTypes")
    def track_wait_event_types(self) -> Optional[bool]:
        """
        Record wait event types during query execution for an instance.
        """
        return pulumi.get(self, "track_wait_event_types")

    @property
    @pulumi.getter(name="trackWaitEvents")
    def track_wait_events(self) -> Optional[bool]:
        """
        Record wait events during query execution for an instance.
        """
        return pulumi.get(self, "track_wait_events")


@pulumi.output_type
class InstancePscInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedConsumerProjects":
            suggest = "allowed_consumer_projects"
        elif key == "pscDnsName":
            suggest = "psc_dns_name"
        elif key == "serviceAttachmentLink":
            suggest = "service_attachment_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePscInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePscInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePscInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_consumer_projects: Optional[Sequence[str]] = None,
                 psc_dns_name: Optional[str] = None,
                 service_attachment_link: Optional[str] = None):
        """
        :param Sequence[str] allowed_consumer_projects: List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
               These should be specified as project numbers only.
        :param str psc_dns_name: (Output)
               The DNS name of the instance for PSC connectivity.
               Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        :param str service_attachment_link: (Output)
               The service attachment created when Private Service Connect (PSC) is enabled for the instance.
               The name of the resource will be in the format of
               `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
        """
        if allowed_consumer_projects is not None:
            pulumi.set(__self__, "allowed_consumer_projects", allowed_consumer_projects)
        if psc_dns_name is not None:
            pulumi.set(__self__, "psc_dns_name", psc_dns_name)
        if service_attachment_link is not None:
            pulumi.set(__self__, "service_attachment_link", service_attachment_link)

    @property
    @pulumi.getter(name="allowedConsumerProjects")
    def allowed_consumer_projects(self) -> Optional[Sequence[str]]:
        """
        List of consumer projects that are allowed to create PSC endpoints to service-attachments to this instance.
        These should be specified as project numbers only.
        """
        return pulumi.get(self, "allowed_consumer_projects")

    @property
    @pulumi.getter(name="pscDnsName")
    def psc_dns_name(self) -> Optional[str]:
        """
        (Output)
        The DNS name of the instance for PSC connectivity.
        Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
        """
        return pulumi.get(self, "psc_dns_name")

    @property
    @pulumi.getter(name="serviceAttachmentLink")
    def service_attachment_link(self) -> Optional[str]:
        """
        (Output)
        The service attachment created when Private Service Connect (PSC) is enabled for the instance.
        The name of the resource will be in the format of
        `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
        """
        return pulumi.get(self, "service_attachment_link")


@pulumi.output_type
class InstanceQueryInsightsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryPlansPerMinute":
            suggest = "query_plans_per_minute"
        elif key == "queryStringLength":
            suggest = "query_string_length"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "recordClientAddress":
            suggest = "record_client_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceQueryInsightsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceQueryInsightsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceQueryInsightsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_plans_per_minute: Optional[int] = None,
                 query_string_length: Optional[int] = None,
                 record_application_tags: Optional[bool] = None,
                 record_client_address: Optional[bool] = None):
        """
        :param int query_plans_per_minute: Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        :param int query_string_length: Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        :param bool record_application_tags: Record application tags for an instance. This flag is turned "on" by default.
        :param bool record_client_address: Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
        if query_plans_per_minute is not None:
            pulumi.set(__self__, "query_plans_per_minute", query_plans_per_minute)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryPlansPerMinute")
    def query_plans_per_minute(self) -> Optional[int]:
        """
        Number of query execution plans captured by Insights per minute for all queries combined. The default value is 5. Any integer between 0 and 20 is considered valid.
        """
        return pulumi.get(self, "query_plans_per_minute")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[int]:
        """
        Query string length. The default value is 1024. Any integer between 256 and 4500 is considered valid.
        """
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[bool]:
        """
        Record application tags for an instance. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[bool]:
        """
        Record client address for an instance. Client address is PII information. This flag is turned "on" by default.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class InstanceReadPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceReadPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceReadPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceReadPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_count: Optional[int] = None):
        """
        :param int node_count: Read capacity, i.e. number of nodes in a read pool instance.
        """
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        Read capacity, i.e. number of nodes in a read pool instance.
        """
        return pulumi.get(self, "node_count")


@pulumi.output_type
class GetLocationsLocationResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 labels: Mapping[str, str],
                 location_id: str,
                 metadata: Mapping[str, str],
                 name: str):
        """
        :param str display_name: The friendly name for this location, typically a nearby city name. For example, "Tokyo".
        :param Mapping[str, str] labels: Cross-service attributes for the location. For example `{"cloud.googleapis.com/region": "us-east1"}`.
        :param str location_id: The canonical id for this location. For example: "us-east1"..
        :param Mapping[str, str] metadata: Service-specific metadata. For example the available capacity at the given location.
        :param str name: Resource name for the location, which may vary between implementations. For example: "projects/example-project/locations/us-east1".
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location_id", location_id)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The friendly name for this location, typically a nearby city name. For example, "Tokyo".
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Cross-service attributes for the location. For example `{"cloud.googleapis.com/region": "us-east1"}`.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> str:
        """
        The canonical id for this location. For example: "us-east1"..
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Service-specific metadata. For example the available capacity at the given location.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the location, which may vary between implementations. For example: "projects/example-project/locations/us-east1".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 accepts_multiple_values: bool,
                 flag_name: str,
                 integer_restrictions: 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult',
                 name: str,
                 requires_db_restart: bool,
                 string_restrictions: 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult',
                 supported_db_versions: Sequence[str],
                 value_type: str):
        """
        :param bool accepts_multiple_values: Whether the database flag accepts multiple values. If true, a comma-separated list of stringified values may be specified.
        :param str flag_name: The name of the database flag, e.g. "max_allowed_packets". The is a possibly key for the Instance.database_flags map field.
        :param 'GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsArgs' integer_restrictions: Restriction on `INTEGER` type value. Specifies the minimum value and the maximum value that can be specified, if applicable.
        :param str name: The name of the flag resource, following Google Cloud conventions, e.g.: * projects/{project}/locations/{location}/flags/{flag} This field currently has no semantic meaning.
        :param bool requires_db_restart: Whether setting or updating this flag on an Instance requires a database restart. If a flag that requires database restart is set, the backend will automatically restart the database (making sure to satisfy any availability SLO's).
        :param 'GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsArgs' string_restrictions: Restriction on `STRING` type value. The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        :param Sequence[str] supported_db_versions: Major database engine versions for which this flag is supported. The supported values are `POSTGRES_14` and `DATABASE_VERSION_UNSPECIFIED`.
        :param str value_type: ValueType describes the semantic type of the value that the flag accepts. Regardless of the ValueType, the Instance.database_flags field accepts the stringified version of the value, i.e. "20" or "3.14". The supported values are `VALUE_TYPE_UNSPECIFIED`, `STRING`, `INTEGER`, `FLOAT` and `NONE`.
        """
        pulumi.set(__self__, "accepts_multiple_values", accepts_multiple_values)
        pulumi.set(__self__, "flag_name", flag_name)
        pulumi.set(__self__, "integer_restrictions", integer_restrictions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "requires_db_restart", requires_db_restart)
        pulumi.set(__self__, "string_restrictions", string_restrictions)
        pulumi.set(__self__, "supported_db_versions", supported_db_versions)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="acceptsMultipleValues")
    def accepts_multiple_values(self) -> bool:
        """
        Whether the database flag accepts multiple values. If true, a comma-separated list of stringified values may be specified.
        """
        return pulumi.get(self, "accepts_multiple_values")

    @property
    @pulumi.getter(name="flagName")
    def flag_name(self) -> str:
        """
        The name of the database flag, e.g. "max_allowed_packets". The is a possibly key for the Instance.database_flags map field.
        """
        return pulumi.get(self, "flag_name")

    @property
    @pulumi.getter(name="integerRestrictions")
    def integer_restrictions(self) -> 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult':
        """
        Restriction on `INTEGER` type value. Specifies the minimum value and the maximum value that can be specified, if applicable.
        """
        return pulumi.get(self, "integer_restrictions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the flag resource, following Google Cloud conventions, e.g.: * projects/{project}/locations/{location}/flags/{flag} This field currently has no semantic meaning.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requiresDbRestart")
    def requires_db_restart(self) -> bool:
        """
        Whether setting or updating this flag on an Instance requires a database restart. If a flag that requires database restart is set, the backend will automatically restart the database (making sure to satisfy any availability SLO's).
        """
        return pulumi.get(self, "requires_db_restart")

    @property
    @pulumi.getter(name="stringRestrictions")
    def string_restrictions(self) -> 'outputs.GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult':
        """
        Restriction on `STRING` type value. The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        """
        return pulumi.get(self, "string_restrictions")

    @property
    @pulumi.getter(name="supportedDbVersions")
    def supported_db_versions(self) -> Sequence[str]:
        """
        Major database engine versions for which this flag is supported. The supported values are `POSTGRES_14` and `DATABASE_VERSION_UNSPECIFIED`.
        """
        return pulumi.get(self, "supported_db_versions")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        ValueType describes the semantic type of the value that the flag accepts. Regardless of the ValueType, the Instance.database_flags field accepts the stringified version of the value, i.e. "20" or "3.14". The supported values are `VALUE_TYPE_UNSPECIFIED`, `STRING`, `INTEGER`, `FLOAT` and `NONE`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagIntegerRestrictionsResult(dict):
    def __init__(__self__, *,
                 max_value: str,
                 min_value: str):
        """
        :param str max_value: The maximum value that can be specified, if applicable.
        :param str min_value: The minimum value that can be specified, if applicable.
        """
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> str:
        """
        The maximum value that can be specified, if applicable.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> str:
        """
        The minimum value that can be specified, if applicable.
        """
        return pulumi.get(self, "min_value")


@pulumi.output_type
class GetSupportedDatabaseFlagsSupportedDatabaseFlagStringRestrictionsResult(dict):
    def __init__(__self__, *,
                 allowed_values: Sequence[str]):
        """
        :param Sequence[str] allowed_values: The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        """
        pulumi.set(__self__, "allowed_values", allowed_values)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Sequence[str]:
        """
        The list of allowed values, if bounded. This field will be empty if there is a unbounded number of allowed values.
        """
        return pulumi.get(self, "allowed_values")


