# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvKeystoreArgs', 'EnvKeystore']

@pulumi.input_type
class EnvKeystoreArgs:
    def __init__(__self__, *,
                 env_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EnvKeystore resource.
        :param pulumi.Input[str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
               
               
               - - -
        :param pulumi.Input[str] name: The name of the newly created keystore.
        """
        pulumi.set(__self__, "env_id", env_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Input[str]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.


        - - -
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "env_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the newly created keystore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EnvKeystoreState:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 env_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EnvKeystore resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: Aliases in this keystore.
        :param pulumi.Input[str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
               
               
               - - -
        :param pulumi.Input[str] name: The name of the newly created keystore.
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if env_id is not None:
            pulumi.set(__self__, "env_id", env_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Aliases in this keystore.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.


        - - -
        """
        return pulumi.get(self, "env_id")

    @env_id.setter
    def env_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the newly created keystore.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class EnvKeystore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An `Environment KeyStore` in Apigee.

        To get more information about EnvKeystore, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.keystores/create)
        * How-to Guides
            * [Creating an environment](https://cloud.google.com/apigee/docs/api-platform/get-started/create-environment)

        ## Import

        EnvKeystore can be imported using any of these accepted formats:

        * `{{env_id}}/keystores/{{name}}`

        * `{{env_id}}/{{name}}`

        When using the `pulumi import` command, EnvKeystore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/envKeystore:EnvKeystore default {{env_id}}/keystores/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/envKeystore:EnvKeystore default {{env_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
               
               
               - - -
        :param pulumi.Input[str] name: The name of the newly created keystore.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvKeystoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An `Environment KeyStore` in Apigee.

        To get more information about EnvKeystore, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations.environments.keystores/create)
        * How-to Guides
            * [Creating an environment](https://cloud.google.com/apigee/docs/api-platform/get-started/create-environment)

        ## Import

        EnvKeystore can be imported using any of these accepted formats:

        * `{{env_id}}/keystores/{{name}}`

        * `{{env_id}}/{{name}}`

        When using the `pulumi import` command, EnvKeystore can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apigee/envKeystore:EnvKeystore default {{env_id}}/keystores/{{name}}
        ```

        ```sh
        $ pulumi import gcp:apigee/envKeystore:EnvKeystore default {{env_id}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EnvKeystoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvKeystoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 env_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvKeystoreArgs.__new__(EnvKeystoreArgs)

            if env_id is None and not opts.urn:
                raise TypeError("Missing required property 'env_id'")
            __props__.__dict__["env_id"] = env_id
            __props__.__dict__["name"] = name
            __props__.__dict__["aliases"] = None
        super(EnvKeystore, __self__).__init__(
            'gcp:apigee/envKeystore:EnvKeystore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            env_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'EnvKeystore':
        """
        Get an existing EnvKeystore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: Aliases in this keystore.
        :param pulumi.Input[str] env_id: The Apigee environment group associated with the Apigee environment,
               in the format `organizations/{{org_name}}/environments/{{env_name}}`.
               
               
               - - -
        :param pulumi.Input[str] name: The name of the newly created keystore.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvKeystoreState.__new__(_EnvKeystoreState)

        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["env_id"] = env_id
        __props__.__dict__["name"] = name
        return EnvKeystore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Sequence[str]]:
        """
        Aliases in this keystore.
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="envId")
    def env_id(self) -> pulumi.Output[str]:
        """
        The Apigee environment group associated with the Apigee environment,
        in the format `organizations/{{org_name}}/environments/{{env_name}}`.


        - - -
        """
        return pulumi.get(self, "env_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the newly created keystore.
        """
        return pulumi.get(self, "name")

