# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationUrlDispatchRulesArgs', 'ApplicationUrlDispatchRules']

@pulumi.input_type
class ApplicationUrlDispatchRulesArgs:
    def __init__(__self__, *,
                 dispatch_rules: pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]],
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApplicationUrlDispatchRules resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]] dispatch_rules: Rules to match an HTTP request and dispatch that request to a service.
               Structure is documented below.
        """
        pulumi.set(__self__, "dispatch_rules", dispatch_rules)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dispatchRules")
    def dispatch_rules(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]:
        """
        Rules to match an HTTP request and dispatch that request to a service.
        Structure is documented below.
        """
        return pulumi.get(self, "dispatch_rules")

    @dispatch_rules.setter
    def dispatch_rules(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]):
        pulumi.set(self, "dispatch_rules", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ApplicationUrlDispatchRulesState:
    def __init__(__self__, *,
                 dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplicationUrlDispatchRules resources.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]] dispatch_rules: Rules to match an HTTP request and dispatch that request to a service.
               Structure is documented below.
        """
        if dispatch_rules is not None:
            pulumi.set(__self__, "dispatch_rules", dispatch_rules)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dispatchRules")
    def dispatch_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]]:
        """
        Rules to match an HTTP request and dispatch that request to a service.
        Structure is documented below.
        """
        return pulumi.get(self, "dispatch_rules")

    @dispatch_rules.setter
    def dispatch_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationUrlDispatchRulesDispatchRuleArgs']]]]):
        pulumi.set(self, "dispatch_rules", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class ApplicationUrlDispatchRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUrlDispatchRulesDispatchRuleArgs', 'ApplicationUrlDispatchRulesDispatchRuleArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Rules to match an HTTP request and dispatch that request to a service.

        To get more information about ApplicationUrlDispatchRules, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps#UrlDispatchRule)

        ## Example Usage

        ### App Engine Application Url Dispatch Rules Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="appengine-test-bucket",
            location="US")
        object = gcp.storage.BucketObject("object",
            name="hello-world.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("./test-fixtures/hello-world.zip"))
        admin_v3 = gcp.appengine.StandardAppVersion("admin_v3",
            version_id="v3",
            service="admin",
            runtime="nodejs20",
            entrypoint={
                "shell": "node ./app.js",
            },
            deployment={
                "zip": {
                    "source_url": pulumi.Output.all(
                        bucketName=bucket.name,
                        objectName=object.name
        ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
        ,
                },
            },
            env_variables={
                "port": "8080",
            },
            delete_service_on_destroy=True)
        web_service = gcp.appengine.ApplicationUrlDispatchRules("web_service", dispatch_rules=[
            {
                "domain": "*",
                "path": "/*",
                "service": "default",
            },
            {
                "domain": "*",
                "path": "/admin/*",
                "service": admin_v3.service,
            },
        ])
        ```

        ## Import

        ApplicationUrlDispatchRules can be imported using any of these accepted formats:

        * `{{project}}`

        When using the `pulumi import` command, ApplicationUrlDispatchRules can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:appengine/applicationUrlDispatchRules:ApplicationUrlDispatchRules default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUrlDispatchRulesDispatchRuleArgs', 'ApplicationUrlDispatchRulesDispatchRuleArgsDict']]]] dispatch_rules: Rules to match an HTTP request and dispatch that request to a service.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationUrlDispatchRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Rules to match an HTTP request and dispatch that request to a service.

        To get more information about ApplicationUrlDispatchRules, see:

        * [API documentation](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps#UrlDispatchRule)

        ## Example Usage

        ### App Engine Application Url Dispatch Rules Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="appengine-test-bucket",
            location="US")
        object = gcp.storage.BucketObject("object",
            name="hello-world.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("./test-fixtures/hello-world.zip"))
        admin_v3 = gcp.appengine.StandardAppVersion("admin_v3",
            version_id="v3",
            service="admin",
            runtime="nodejs20",
            entrypoint={
                "shell": "node ./app.js",
            },
            deployment={
                "zip": {
                    "source_url": pulumi.Output.all(
                        bucketName=bucket.name,
                        objectName=object.name
        ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['bucketName']}/{resolved_outputs['objectName']}")
        ,
                },
            },
            env_variables={
                "port": "8080",
            },
            delete_service_on_destroy=True)
        web_service = gcp.appengine.ApplicationUrlDispatchRules("web_service", dispatch_rules=[
            {
                "domain": "*",
                "path": "/*",
                "service": "default",
            },
            {
                "domain": "*",
                "path": "/admin/*",
                "service": admin_v3.service,
            },
        ])
        ```

        ## Import

        ApplicationUrlDispatchRules can be imported using any of these accepted formats:

        * `{{project}}`

        When using the `pulumi import` command, ApplicationUrlDispatchRules can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:appengine/applicationUrlDispatchRules:ApplicationUrlDispatchRules default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationUrlDispatchRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationUrlDispatchRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUrlDispatchRulesDispatchRuleArgs', 'ApplicationUrlDispatchRulesDispatchRuleArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationUrlDispatchRulesArgs.__new__(ApplicationUrlDispatchRulesArgs)

            if dispatch_rules is None and not opts.urn:
                raise TypeError("Missing required property 'dispatch_rules'")
            __props__.__dict__["dispatch_rules"] = dispatch_rules
            __props__.__dict__["project"] = project
        super(ApplicationUrlDispatchRules, __self__).__init__(
            'gcp:appengine/applicationUrlDispatchRules:ApplicationUrlDispatchRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dispatch_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUrlDispatchRulesDispatchRuleArgs', 'ApplicationUrlDispatchRulesDispatchRuleArgsDict']]]]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'ApplicationUrlDispatchRules':
        """
        Get an existing ApplicationUrlDispatchRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationUrlDispatchRulesDispatchRuleArgs', 'ApplicationUrlDispatchRulesDispatchRuleArgsDict']]]] dispatch_rules: Rules to match an HTTP request and dispatch that request to a service.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationUrlDispatchRulesState.__new__(_ApplicationUrlDispatchRulesState)

        __props__.__dict__["dispatch_rules"] = dispatch_rules
        __props__.__dict__["project"] = project
        return ApplicationUrlDispatchRules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dispatchRules")
    def dispatch_rules(self) -> pulumi.Output[Sequence['outputs.ApplicationUrlDispatchRulesDispatchRule']]:
        """
        Rules to match an HTTP request and dispatch that request to a service.
        Structure is documented below.
        """
        return pulumi.get(self, "dispatch_rules")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

