# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiscoveredWorkloadResult',
    'AwaitableGetDiscoveredWorkloadResult',
    'get_discovered_workload',
    'get_discovered_workload_output',
]

@pulumi.output_type
class GetDiscoveredWorkloadResult:
    """
    A collection of values returned by getDiscoveredWorkload.
    """
    def __init__(__self__, id=None, location=None, name=None, project=None, workload_properties=None, workload_references=None, workload_uri=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if workload_properties and not isinstance(workload_properties, list):
            raise TypeError("Expected argument 'workload_properties' to be a list")
        pulumi.set(__self__, "workload_properties", workload_properties)
        if workload_references and not isinstance(workload_references, list):
            raise TypeError("Expected argument 'workload_references' to be a list")
        pulumi.set(__self__, "workload_references", workload_references)
        if workload_uri and not isinstance(workload_uri, str):
            raise TypeError("Expected argument 'workload_uri' to be a str")
        pulumi.set(__self__, "workload_uri", workload_uri)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location that the underlying resource resides in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of a Workload. Format: "projects/{host-project-id}/locations/{location}/applications/{application-id}/workloads/{workload-id}".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="workloadProperties")
    def workload_properties(self) -> Sequence['outputs.GetDiscoveredWorkloadWorkloadPropertyResult']:
        """
        Properties of an underlying compute resource that can comprise a Workload. Structure is documented below
        """
        return pulumi.get(self, "workload_properties")

    @property
    @pulumi.getter(name="workloadReferences")
    def workload_references(self) -> Sequence['outputs.GetDiscoveredWorkloadWorkloadReferenceResult']:
        """
        Reference to an underlying networking resource that can comprise a Workload. Structure is documented below
        """
        return pulumi.get(self, "workload_references")

    @property
    @pulumi.getter(name="workloadUri")
    def workload_uri(self) -> str:
        return pulumi.get(self, "workload_uri")


class AwaitableGetDiscoveredWorkloadResult(GetDiscoveredWorkloadResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoveredWorkloadResult(
            id=self.id,
            location=self.location,
            name=self.name,
            project=self.project,
            workload_properties=self.workload_properties,
            workload_references=self.workload_references,
            workload_uri=self.workload_uri)


def get_discovered_workload(location: Optional[str] = None,
                            project: Optional[str] = None,
                            workload_uri: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoveredWorkloadResult:
    """
    Get information about a discovered workload from its uri.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_workload = gcp.apphub.get_discovered_workload(location="us-central1",
        workload_uri="my-workload-uri")
    ```


    :param str location: The location of the discovered workload.
    :param str project: The host project of the discovered workload.
    :param str workload_uri: The uri of the workload (instance group managed by the Instance Group Manager). Example: "//compute.googleapis.com/projects/1/regions/us-east1/instanceGroups/id1"
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['workloadUri'] = workload_uri
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:apphub/getDiscoveredWorkload:getDiscoveredWorkload', __args__, opts=opts, typ=GetDiscoveredWorkloadResult).value

    return AwaitableGetDiscoveredWorkloadResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        workload_properties=pulumi.get(__ret__, 'workload_properties'),
        workload_references=pulumi.get(__ret__, 'workload_references'),
        workload_uri=pulumi.get(__ret__, 'workload_uri'))


@_utilities.lift_output_func(get_discovered_workload)
def get_discovered_workload_output(location: Optional[pulumi.Input[str]] = None,
                                   project: Optional[pulumi.Input[Optional[str]]] = None,
                                   workload_uri: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDiscoveredWorkloadResult]:
    """
    Get information about a discovered workload from its uri.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_workload = gcp.apphub.get_discovered_workload(location="us-central1",
        workload_uri="my-workload-uri")
    ```


    :param str location: The location of the discovered workload.
    :param str project: The host project of the discovered workload.
    :param str workload_uri: The uri of the workload (instance group managed by the Instance Group Manager). Example: "//compute.googleapis.com/projects/1/regions/us-east1/instanceGroups/id1"
    """
    ...
