# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 discovered_service: pulumi.Input[str],
                 location: pulumi.Input[str],
                 service_id: pulumi.Input[str],
                 attributes: Optional[pulumi.Input['ServiceAttributesArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[str] application_id: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[str] discovered_service: Immutable. The resource name of the original discovered service.
        :param pulumi.Input[str] location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[str] service_id: The Service identifier.
               
               
               - - -
        :param pulumi.Input['ServiceAttributesArgs'] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[str] description: User-defined description of a Service.
        :param pulumi.Input[str] display_name: User-defined name for the Service.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "discovered_service", discovered_service)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "service_id", service_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="discoveredService")
    def discovered_service(self) -> pulumi.Input[str]:
        """
        Immutable. The resource name of the original discovered service.
        """
        return pulumi.get(self, "discovered_service")

    @discovered_service.setter
    def discovered_service(self, value: pulumi.Input[str]):
        pulumi.set(self, "discovered_service", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The Service identifier.


        - - -
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['ServiceAttributesArgs']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['ServiceAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-defined description of a Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-defined name for the Service.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input['ServiceAttributesArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 discovered_service: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_properties: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServicePropertyArgs']]]] = None,
                 service_references: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceReferenceArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[str] application_id: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input['ServiceAttributesArgs'] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Output only. Create time.
        :param pulumi.Input[str] description: User-defined description of a Service.
        :param pulumi.Input[str] discovered_service: Immutable. The resource name of the original discovered service.
        :param pulumi.Input[str] display_name: User-defined name for the Service.
        :param pulumi.Input[str] location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[str] name: Identifier. The resource name of a Service. Format:
               "projects/{host-project-id}/locations/{location}/applications/{application-id}/services/{service-id}"
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] service_id: The Service identifier.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['ServiceServicePropertyArgs']]] service_properties: Properties of an underlying cloud resource that can comprise a Service.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceServiceReferenceArgs']]] service_references: Reference to an underlying networking resource that can comprise a Service.
               Structure is documented below.
        :param pulumi.Input[str] state: Output only. Service state. Possible values: STATE_UNSPECIFIED CREATING ACTIVE DELETING DETACHED
        :param pulumi.Input[str] uid: Output only. A universally unique identifier (UUID) for the `Service` in the UUID4
               format.
        :param pulumi.Input[str] update_time: Output only. Update time.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovered_service is not None:
            pulumi.set(__self__, "discovered_service", discovered_service)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if service_properties is not None:
            pulumi.set(__self__, "service_properties", service_properties)
        if service_references is not None:
            pulumi.set(__self__, "service_references", service_references)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['ServiceAttributesArgs']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['ServiceAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Create time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-defined description of a Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="discoveredService")
    def discovered_service(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The resource name of the original discovered service.
        """
        return pulumi.get(self, "discovered_service")

    @discovered_service.setter
    def discovered_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovered_service", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-defined name for the Service.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier. The resource name of a Service. Format:
        "projects/{host-project-id}/locations/{location}/applications/{application-id}/services/{service-id}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Service identifier.


        - - -
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="serviceProperties")
    def service_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServicePropertyArgs']]]]:
        """
        Properties of an underlying cloud resource that can comprise a Service.
        Structure is documented below.
        """
        return pulumi.get(self, "service_properties")

    @service_properties.setter
    def service_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServicePropertyArgs']]]]):
        pulumi.set(self, "service_properties", value)

    @property
    @pulumi.getter(name="serviceReferences")
    def service_references(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceReferenceArgs']]]]:
        """
        Reference to an underlying networking resource that can comprise a Service.
        Structure is documented below.
        """
        return pulumi.get(self, "service_references")

    @service_references.setter
    def service_references(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceReferenceArgs']]]]):
        pulumi.set(self, "service_references", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Service state. Possible values: STATE_UNSPECIFIED CREATING ACTIVE DELETING DETACHED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. A universally unique identifier (UUID) for the `Service` in the UUID4
        format.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Update time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Union['ServiceAttributesArgs', 'ServiceAttributesArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 discovered_service: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Service is a network/api interface that exposes some functionality to clients for consumption over the network. Service typically has one or more Workloads behind it. It registers identified service to the Application.

        ## Example Usage

        ### Apphub Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        application = gcp.apphub.Application("application",
            location="us-central1",
            application_id="example-application-1",
            scope={
                "type": "REGIONAL",
            })
        service_project = gcp.organizations.Project("service_project",
            project_id="project-1",
            name="Service Project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        # Enable Compute API
        compute_service_project = gcp.projects.Service("compute_service_project",
            project=service_project.project_id,
            service="compute.googleapis.com")
        wait120s = time.index.Sleep("wait_120s", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[compute_service_project]))
        service_project_attachment = gcp.apphub.ServiceProjectAttachment("service_project_attachment", service_project_attachment_id=service_project.project_id,
        opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # VPC network
        ilb_network = gcp.compute.Network("ilb_network",
            name="l7-ilb-network",
            project=service_project.project_id,
            auto_create_subnetworks=False,
            opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # backend subnet
        ilb_subnet = gcp.compute.Subnetwork("ilb_subnet",
            name="l7-ilb-subnet",
            project=service_project.project_id,
            ip_cidr_range="10.0.1.0/24",
            region="us-central1",
            network=ilb_network.id)
        # health check
        default = gcp.compute.HealthCheck("default",
            name="l7-ilb-hc",
            project=service_project.project_id,
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            },
            opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # backend service
        backend = gcp.compute.RegionBackendService("backend",
            name="l7-ilb-backend-subnet",
            project=service_project.project_id,
            region="us-central1",
            health_checks=default.id)
        # forwarding rule
        forwarding_rule = gcp.compute.ForwardingRule("forwarding_rule",
            name="l7-ilb-forwarding-rule",
            project=service_project.project_id,
            region="us-central1",
            ip_version="IPV4",
            load_balancing_scheme="INTERNAL",
            all_ports=True,
            backend_service=backend.id,
            network=ilb_network.id,
            subnetwork=ilb_subnet.id)
        # discovered service block
        catalog_service = gcp.apphub.get_discovered_service_output(location="us-central1",
            service_uri=forwarding_rule.id.apply(lambda id: f"//compute.googleapis.com/{id}"))
        wait120s_for_resource_ingestion = time.index.Sleep("wait_120s_for_resource_ingestion", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[forwarding_rule]))
        example = gcp.apphub.Service("example",
            location="us-central1",
            application_id=application.application_id,
            service_id=forwarding_rule.name,
            discovered_service=catalog_service.name)
        ```
        ### Apphub Service Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        application = gcp.apphub.Application("application",
            location="us-central1",
            application_id="example-application-1",
            scope={
                "type": "REGIONAL",
            })
        service_project = gcp.organizations.Project("service_project",
            project_id="project-1",
            name="Service Project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        # Enable Compute API
        compute_service_project = gcp.projects.Service("compute_service_project",
            project=service_project.project_id,
            service="compute.googleapis.com")
        wait120s = time.index.Sleep("wait_120s", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[compute_service_project]))
        service_project_attachment = gcp.apphub.ServiceProjectAttachment("service_project_attachment", service_project_attachment_id=service_project.project_id,
        opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # VPC network
        ilb_network = gcp.compute.Network("ilb_network",
            name="l7-ilb-network",
            project=service_project.project_id,
            auto_create_subnetworks=False,
            opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # backend subnet
        ilb_subnet = gcp.compute.Subnetwork("ilb_subnet",
            name="l7-ilb-subnet",
            project=service_project.project_id,
            ip_cidr_range="10.0.1.0/24",
            region="us-central1",
            network=ilb_network.id)
        # health check
        default = gcp.compute.HealthCheck("default",
            name="l7-ilb-hc",
            project=service_project.project_id,
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            },
            opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # backend service
        backend = gcp.compute.RegionBackendService("backend",
            name="l7-ilb-backend-subnet",
            project=service_project.project_id,
            region="us-central1",
            health_checks=default.id)
        # forwarding rule
        forwarding_rule = gcp.compute.ForwardingRule("forwarding_rule",
            name="l7-ilb-forwarding-rule",
            project=service_project.project_id,
            region="us-central1",
            ip_version="IPV4",
            load_balancing_scheme="INTERNAL",
            all_ports=True,
            backend_service=backend.id,
            network=ilb_network.id,
            subnetwork=ilb_subnet.id)
        # discovered service block
        catalog_service = gcp.apphub.get_discovered_service_output(location="us-central1",
            service_uri=forwarding_rule.id.apply(lambda id: f"//compute.googleapis.com/{id}"))
        wait120s_for_resource_ingestion = time.index.Sleep("wait_120s_for_resource_ingestion", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[forwarding_rule]))
        example = gcp.apphub.Service("example",
            location="us-central1",
            application_id=application.application_id,
            service_id=forwarding_rule.name,
            discovered_service=catalog_service.name,
            display_name="Example Service Full",
            description="Register service for testing",
            attributes={
                "environment": {
                    "type": "STAGING",
                },
                "criticality": {
                    "type": "MISSION_CRITICAL",
                },
                "business_owners": [{
                    "display_name": "Alice",
                    "email": "alice@google.com",
                }],
                "developer_owners": [{
                    "display_name": "Bob",
                    "email": "bob@google.com",
                }],
                "operator_owners": [{
                    "display_name": "Charlie",
                    "email": "charlie@google.com",
                }],
            })
        ```

        ## Import

        Service can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/applications/{{application_id}}/services/{{service_id}}`

        * `{{project}}/{{location}}/{{application_id}}/{{service_id}}`

        * `{{location}}/{{application_id}}/{{service_id}}`

        When using the `pulumi import` command, Service can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apphub/service:Service default projects/{{project}}/locations/{{location}}/applications/{{application_id}}/services/{{service_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/service:Service default {{project}}/{{location}}/{{application_id}}/{{service_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/service:Service default {{location}}/{{application_id}}/{{service_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[Union['ServiceAttributesArgs', 'ServiceAttributesArgsDict']] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[str] description: User-defined description of a Service.
        :param pulumi.Input[str] discovered_service: Immutable. The resource name of the original discovered service.
        :param pulumi.Input[str] display_name: User-defined name for the Service.
        :param pulumi.Input[str] location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] service_id: The Service identifier.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Service is a network/api interface that exposes some functionality to clients for consumption over the network. Service typically has one or more Workloads behind it. It registers identified service to the Application.

        ## Example Usage

        ### Apphub Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        application = gcp.apphub.Application("application",
            location="us-central1",
            application_id="example-application-1",
            scope={
                "type": "REGIONAL",
            })
        service_project = gcp.organizations.Project("service_project",
            project_id="project-1",
            name="Service Project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        # Enable Compute API
        compute_service_project = gcp.projects.Service("compute_service_project",
            project=service_project.project_id,
            service="compute.googleapis.com")
        wait120s = time.index.Sleep("wait_120s", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[compute_service_project]))
        service_project_attachment = gcp.apphub.ServiceProjectAttachment("service_project_attachment", service_project_attachment_id=service_project.project_id,
        opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # VPC network
        ilb_network = gcp.compute.Network("ilb_network",
            name="l7-ilb-network",
            project=service_project.project_id,
            auto_create_subnetworks=False,
            opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # backend subnet
        ilb_subnet = gcp.compute.Subnetwork("ilb_subnet",
            name="l7-ilb-subnet",
            project=service_project.project_id,
            ip_cidr_range="10.0.1.0/24",
            region="us-central1",
            network=ilb_network.id)
        # health check
        default = gcp.compute.HealthCheck("default",
            name="l7-ilb-hc",
            project=service_project.project_id,
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            },
            opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # backend service
        backend = gcp.compute.RegionBackendService("backend",
            name="l7-ilb-backend-subnet",
            project=service_project.project_id,
            region="us-central1",
            health_checks=default.id)
        # forwarding rule
        forwarding_rule = gcp.compute.ForwardingRule("forwarding_rule",
            name="l7-ilb-forwarding-rule",
            project=service_project.project_id,
            region="us-central1",
            ip_version="IPV4",
            load_balancing_scheme="INTERNAL",
            all_ports=True,
            backend_service=backend.id,
            network=ilb_network.id,
            subnetwork=ilb_subnet.id)
        # discovered service block
        catalog_service = gcp.apphub.get_discovered_service_output(location="us-central1",
            service_uri=forwarding_rule.id.apply(lambda id: f"//compute.googleapis.com/{id}"))
        wait120s_for_resource_ingestion = time.index.Sleep("wait_120s_for_resource_ingestion", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[forwarding_rule]))
        example = gcp.apphub.Service("example",
            location="us-central1",
            application_id=application.application_id,
            service_id=forwarding_rule.name,
            discovered_service=catalog_service.name)
        ```
        ### Apphub Service Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        application = gcp.apphub.Application("application",
            location="us-central1",
            application_id="example-application-1",
            scope={
                "type": "REGIONAL",
            })
        service_project = gcp.organizations.Project("service_project",
            project_id="project-1",
            name="Service Project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        # Enable Compute API
        compute_service_project = gcp.projects.Service("compute_service_project",
            project=service_project.project_id,
            service="compute.googleapis.com")
        wait120s = time.index.Sleep("wait_120s", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[compute_service_project]))
        service_project_attachment = gcp.apphub.ServiceProjectAttachment("service_project_attachment", service_project_attachment_id=service_project.project_id,
        opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # VPC network
        ilb_network = gcp.compute.Network("ilb_network",
            name="l7-ilb-network",
            project=service_project.project_id,
            auto_create_subnetworks=False,
            opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # backend subnet
        ilb_subnet = gcp.compute.Subnetwork("ilb_subnet",
            name="l7-ilb-subnet",
            project=service_project.project_id,
            ip_cidr_range="10.0.1.0/24",
            region="us-central1",
            network=ilb_network.id)
        # health check
        default = gcp.compute.HealthCheck("default",
            name="l7-ilb-hc",
            project=service_project.project_id,
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            },
            opts = pulumi.ResourceOptions(depends_on=[wait120s]))
        # backend service
        backend = gcp.compute.RegionBackendService("backend",
            name="l7-ilb-backend-subnet",
            project=service_project.project_id,
            region="us-central1",
            health_checks=default.id)
        # forwarding rule
        forwarding_rule = gcp.compute.ForwardingRule("forwarding_rule",
            name="l7-ilb-forwarding-rule",
            project=service_project.project_id,
            region="us-central1",
            ip_version="IPV4",
            load_balancing_scheme="INTERNAL",
            all_ports=True,
            backend_service=backend.id,
            network=ilb_network.id,
            subnetwork=ilb_subnet.id)
        # discovered service block
        catalog_service = gcp.apphub.get_discovered_service_output(location="us-central1",
            service_uri=forwarding_rule.id.apply(lambda id: f"//compute.googleapis.com/{id}"))
        wait120s_for_resource_ingestion = time.index.Sleep("wait_120s_for_resource_ingestion", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[forwarding_rule]))
        example = gcp.apphub.Service("example",
            location="us-central1",
            application_id=application.application_id,
            service_id=forwarding_rule.name,
            discovered_service=catalog_service.name,
            display_name="Example Service Full",
            description="Register service for testing",
            attributes={
                "environment": {
                    "type": "STAGING",
                },
                "criticality": {
                    "type": "MISSION_CRITICAL",
                },
                "business_owners": [{
                    "display_name": "Alice",
                    "email": "alice@google.com",
                }],
                "developer_owners": [{
                    "display_name": "Bob",
                    "email": "bob@google.com",
                }],
                "operator_owners": [{
                    "display_name": "Charlie",
                    "email": "charlie@google.com",
                }],
            })
        ```

        ## Import

        Service can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/applications/{{application_id}}/services/{{service_id}}`

        * `{{project}}/{{location}}/{{application_id}}/{{service_id}}`

        * `{{location}}/{{application_id}}/{{service_id}}`

        When using the `pulumi import` command, Service can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:apphub/service:Service default projects/{{project}}/locations/{{location}}/applications/{{application_id}}/services/{{service_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/service:Service default {{project}}/{{location}}/{{application_id}}/{{service_id}}
        ```

        ```sh
        $ pulumi import gcp:apphub/service:Service default {{location}}/{{application_id}}/{{service_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Union['ServiceAttributesArgs', 'ServiceAttributesArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 discovered_service: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["description"] = description
            if discovered_service is None and not opts.urn:
                raise TypeError("Missing required property 'discovered_service'")
            __props__.__dict__["discovered_service"] = discovered_service
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["service_properties"] = None
            __props__.__dict__["service_references"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(Service, __self__).__init__(
            'gcp:apphub/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            attributes: Optional[pulumi.Input[Union['ServiceAttributesArgs', 'ServiceAttributesArgsDict']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            discovered_service: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            service_properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceServicePropertyArgs', 'ServiceServicePropertyArgsDict']]]]] = None,
            service_references: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceServiceReferenceArgs', 'ServiceServiceReferenceArgsDict']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[Union['ServiceAttributesArgs', 'ServiceAttributesArgsDict']] attributes: Consumer provided attributes.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Output only. Create time.
        :param pulumi.Input[str] description: User-defined description of a Service.
        :param pulumi.Input[str] discovered_service: Immutable. The resource name of the original discovered service.
        :param pulumi.Input[str] display_name: User-defined name for the Service.
        :param pulumi.Input[str] location: Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        :param pulumi.Input[str] name: Identifier. The resource name of a Service. Format:
               "projects/{host-project-id}/locations/{location}/applications/{application-id}/services/{service-id}"
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] service_id: The Service identifier.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceServicePropertyArgs', 'ServiceServicePropertyArgsDict']]]] service_properties: Properties of an underlying cloud resource that can comprise a Service.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceServiceReferenceArgs', 'ServiceServiceReferenceArgsDict']]]] service_references: Reference to an underlying networking resource that can comprise a Service.
               Structure is documented below.
        :param pulumi.Input[str] state: Output only. Service state. Possible values: STATE_UNSPECIFIED CREATING ACTIVE DELETING DETACHED
        :param pulumi.Input[str] uid: Output only. A universally unique identifier (UUID) for the `Service` in the UUID4
               format.
        :param pulumi.Input[str] update_time: Output only. Update time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["discovered_service"] = discovered_service
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["service_properties"] = service_properties
        __props__.__dict__["service_references"] = service_references
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional['outputs.ServiceAttributes']]:
        """
        Consumer provided attributes.
        Structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. Create time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        User-defined description of a Service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discoveredService")
    def discovered_service(self) -> pulumi.Output[str]:
        """
        Immutable. The resource name of the original discovered service.
        """
        return pulumi.get(self, "discovered_service")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        User-defined name for the Service.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Part of `parent`.  Full resource name of a parent Application. Example: projects/{HOST_PROJECT_ID}/locations/{LOCATION}/applications/{APPLICATION_ID}
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Identifier. The resource name of a Service. Format:
        "projects/{host-project-id}/locations/{location}/applications/{application-id}/services/{service-id}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The Service identifier.


        - - -
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceProperties")
    def service_properties(self) -> pulumi.Output[Sequence['outputs.ServiceServiceProperty']]:
        """
        Properties of an underlying cloud resource that can comprise a Service.
        Structure is documented below.
        """
        return pulumi.get(self, "service_properties")

    @property
    @pulumi.getter(name="serviceReferences")
    def service_references(self) -> pulumi.Output[Sequence['outputs.ServiceServiceReference']]:
        """
        Reference to an underlying networking resource that can comprise a Service.
        Structure is documented below.
        """
        return pulumi.get(self, "service_references")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Output only. Service state. Possible values: STATE_UNSPECIFIED CREATING ACTIVE DELETING DETACHED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. A universally unique identifier (UUID) for the `Service` in the UUID4
        format.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. Update time.
        """
        return pulumi.get(self, "update_time")

