# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AuthConfigClientCertificateArgs',
    'AuthConfigClientCertificateArgsDict',
    'AuthConfigDecryptedCredentialArgs',
    'AuthConfigDecryptedCredentialArgsDict',
    'AuthConfigDecryptedCredentialAuthTokenArgs',
    'AuthConfigDecryptedCredentialAuthTokenArgsDict',
    'AuthConfigDecryptedCredentialJwtArgs',
    'AuthConfigDecryptedCredentialJwtArgsDict',
    'AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgs',
    'AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgsDict',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsArgs',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsArgsDict',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgs',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgsDict',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgs',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgsDict',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgs',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgsDict',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgs',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgsDict',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgs',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgsDict',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgs',
    'AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgsDict',
    'AuthConfigDecryptedCredentialOidcTokenArgs',
    'AuthConfigDecryptedCredentialOidcTokenArgsDict',
    'AuthConfigDecryptedCredentialServiceAccountCredentialsArgs',
    'AuthConfigDecryptedCredentialServiceAccountCredentialsArgsDict',
    'AuthConfigDecryptedCredentialUsernameAndPasswordArgs',
    'AuthConfigDecryptedCredentialUsernameAndPasswordArgsDict',
    'ClientCloudKmsConfigArgs',
    'ClientCloudKmsConfigArgsDict',
]

MYPY = False

if not MYPY:
    class AuthConfigClientCertificateArgsDict(TypedDict):
        encrypted_private_key: pulumi.Input[str]
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        """
        ssl_certificate: pulumi.Input[str]
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        """
        passphrase: NotRequired[pulumi.Input[str]]
        """
        'passphrase' should be left unset if private key is not encrypted.
        Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        """
elif False:
    AuthConfigClientCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigClientCertificateArgs:
    def __init__(__self__, *,
                 encrypted_private_key: pulumi.Input[str],
                 ssl_certificate: pulumi.Input[str],
                 passphrase: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] encrypted_private_key: The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        :param pulumi.Input[str] ssl_certificate: The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        :param pulumi.Input[str] passphrase: 'passphrase' should be left unset if private key is not encrypted.
               Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        """
        pulumi.set(__self__, "encrypted_private_key", encrypted_private_key)
        pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)

    @property
    @pulumi.getter(name="encryptedPrivateKey")
    def encrypted_private_key(self) -> pulumi.Input[str]:
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        """
        return pulumi.get(self, "encrypted_private_key")

    @encrypted_private_key.setter
    def encrypted_private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "encrypted_private_key", value)

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> pulumi.Input[str]:
        """
        The ssl certificate encoded in PEM format. This string must include the begin header and end footer lines.
        """
        return pulumi.get(self, "ssl_certificate")

    @ssl_certificate.setter
    def ssl_certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "ssl_certificate", value)

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        'passphrase' should be left unset if private key is not encrypted.
        Note that 'passphrase' is not the password for web server, but an extra layer of security to protected private key.
        """
        return pulumi.get(self, "passphrase")

    @passphrase.setter
    def passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passphrase", value)


if not MYPY:
    class AuthConfigDecryptedCredentialArgsDict(TypedDict):
        credential_type: pulumi.Input[str]
        """
        Credential type associated with auth configs.
        """
        auth_token: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialAuthTokenArgsDict']]
        """
        Auth token credential.
        Structure is documented below.
        """
        jwt: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialJwtArgsDict']]
        """
        JWT credential.
        Structure is documented below.
        """
        oauth2_authorization_code: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgsDict']]
        """
        OAuth2 authorization code credential.
        Structure is documented below.
        """
        oauth2_client_credentials: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsArgsDict']]
        """
        OAuth2 client credentials.
        Structure is documented below.
        """
        oidc_token: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialOidcTokenArgsDict']]
        """
        Google OIDC ID Token.
        Structure is documented below.
        """
        service_account_credentials: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialServiceAccountCredentialsArgsDict']]
        """
        Service account credential.
        Structure is documented below.
        """
        username_and_password: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialUsernameAndPasswordArgsDict']]
        """
        Username and password credential.
        Structure is documented below.
        """
elif False:
    AuthConfigDecryptedCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialArgs:
    def __init__(__self__, *,
                 credential_type: pulumi.Input[str],
                 auth_token: Optional[pulumi.Input['AuthConfigDecryptedCredentialAuthTokenArgs']] = None,
                 jwt: Optional[pulumi.Input['AuthConfigDecryptedCredentialJwtArgs']] = None,
                 oauth2_authorization_code: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgs']] = None,
                 oauth2_client_credentials: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsArgs']] = None,
                 oidc_token: Optional[pulumi.Input['AuthConfigDecryptedCredentialOidcTokenArgs']] = None,
                 service_account_credentials: Optional[pulumi.Input['AuthConfigDecryptedCredentialServiceAccountCredentialsArgs']] = None,
                 username_and_password: Optional[pulumi.Input['AuthConfigDecryptedCredentialUsernameAndPasswordArgs']] = None):
        """
        :param pulumi.Input[str] credential_type: Credential type associated with auth configs.
        :param pulumi.Input['AuthConfigDecryptedCredentialAuthTokenArgs'] auth_token: Auth token credential.
               Structure is documented below.
        :param pulumi.Input['AuthConfigDecryptedCredentialJwtArgs'] jwt: JWT credential.
               Structure is documented below.
        :param pulumi.Input['AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgs'] oauth2_authorization_code: OAuth2 authorization code credential.
               Structure is documented below.
        :param pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsArgs'] oauth2_client_credentials: OAuth2 client credentials.
               Structure is documented below.
        :param pulumi.Input['AuthConfigDecryptedCredentialOidcTokenArgs'] oidc_token: Google OIDC ID Token.
               Structure is documented below.
        :param pulumi.Input['AuthConfigDecryptedCredentialServiceAccountCredentialsArgs'] service_account_credentials: Service account credential.
               Structure is documented below.
        :param pulumi.Input['AuthConfigDecryptedCredentialUsernameAndPasswordArgs'] username_and_password: Username and password credential.
               Structure is documented below.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if oauth2_authorization_code is not None:
            pulumi.set(__self__, "oauth2_authorization_code", oauth2_authorization_code)
        if oauth2_client_credentials is not None:
            pulumi.set(__self__, "oauth2_client_credentials", oauth2_client_credentials)
        if oidc_token is not None:
            pulumi.set(__self__, "oidc_token", oidc_token)
        if service_account_credentials is not None:
            pulumi.set(__self__, "service_account_credentials", service_account_credentials)
        if username_and_password is not None:
            pulumi.set(__self__, "username_and_password", username_and_password)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Input[str]:
        """
        Credential type associated with auth configs.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialAuthTokenArgs']]:
        """
        Auth token credential.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialAuthTokenArgs']]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter
    def jwt(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialJwtArgs']]:
        """
        JWT credential.
        Structure is documented below.
        """
        return pulumi.get(self, "jwt")

    @jwt.setter
    def jwt(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialJwtArgs']]):
        pulumi.set(self, "jwt", value)

    @property
    @pulumi.getter(name="oauth2AuthorizationCode")
    def oauth2_authorization_code(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgs']]:
        """
        OAuth2 authorization code credential.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_authorization_code")

    @oauth2_authorization_code.setter
    def oauth2_authorization_code(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgs']]):
        pulumi.set(self, "oauth2_authorization_code", value)

    @property
    @pulumi.getter(name="oauth2ClientCredentials")
    def oauth2_client_credentials(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsArgs']]:
        """
        OAuth2 client credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_client_credentials")

    @oauth2_client_credentials.setter
    def oauth2_client_credentials(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsArgs']]):
        pulumi.set(self, "oauth2_client_credentials", value)

    @property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialOidcTokenArgs']]:
        """
        Google OIDC ID Token.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc_token")

    @oidc_token.setter
    def oidc_token(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOidcTokenArgs']]):
        pulumi.set(self, "oidc_token", value)

    @property
    @pulumi.getter(name="serviceAccountCredentials")
    def service_account_credentials(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialServiceAccountCredentialsArgs']]:
        """
        Service account credential.
        Structure is documented below.
        """
        return pulumi.get(self, "service_account_credentials")

    @service_account_credentials.setter
    def service_account_credentials(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialServiceAccountCredentialsArgs']]):
        pulumi.set(self, "service_account_credentials", value)

    @property
    @pulumi.getter(name="usernameAndPassword")
    def username_and_password(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialUsernameAndPasswordArgs']]:
        """
        Username and password credential.
        Structure is documented below.
        """
        return pulumi.get(self, "username_and_password")

    @username_and_password.setter
    def username_and_password(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialUsernameAndPasswordArgs']]):
        pulumi.set(self, "username_and_password", value)


if not MYPY:
    class AuthConfigDecryptedCredentialAuthTokenArgsDict(TypedDict):
        token: NotRequired[pulumi.Input[str]]
        """
        The token for the auth type.
        """
        type: NotRequired[pulumi.Input[str]]
        """
        Authentication type, e.g. "Basic", "Bearer", etc.
        """
elif False:
    AuthConfigDecryptedCredentialAuthTokenArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialAuthTokenArgs:
    def __init__(__self__, *,
                 token: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] token: The token for the auth type.
        :param pulumi.Input[str] type: Authentication type, e.g. "Basic", "Bearer", etc.
        """
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The token for the auth type.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication type, e.g. "Basic", "Bearer", etc.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AuthConfigDecryptedCredentialJwtArgsDict(TypedDict):
        jwt: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The token calculated by the header, payload and signature.
        """
        jwt_header: NotRequired[pulumi.Input[str]]
        """
        Identifies which algorithm is used to generate the signature.
        """
        jwt_payload: NotRequired[pulumi.Input[str]]
        """
        Contains a set of claims. The JWT specification defines seven Registered Claim Names which are the standard fields commonly included in tokens. Custom claims are usually also included, depending on the purpose of the token.
        """
        secret: NotRequired[pulumi.Input[str]]
        """
        User's pre-shared secret to sign the token.
        """
elif False:
    AuthConfigDecryptedCredentialJwtArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialJwtArgs:
    def __init__(__self__, *,
                 jwt: Optional[pulumi.Input[str]] = None,
                 jwt_header: Optional[pulumi.Input[str]] = None,
                 jwt_payload: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] jwt: (Output)
               The token calculated by the header, payload and signature.
        :param pulumi.Input[str] jwt_header: Identifies which algorithm is used to generate the signature.
        :param pulumi.Input[str] jwt_payload: Contains a set of claims. The JWT specification defines seven Registered Claim Names which are the standard fields commonly included in tokens. Custom claims are usually also included, depending on the purpose of the token.
        :param pulumi.Input[str] secret: User's pre-shared secret to sign the token.
        """
        if jwt is not None:
            pulumi.set(__self__, "jwt", jwt)
        if jwt_header is not None:
            pulumi.set(__self__, "jwt_header", jwt_header)
        if jwt_payload is not None:
            pulumi.set(__self__, "jwt_payload", jwt_payload)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def jwt(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The token calculated by the header, payload and signature.
        """
        return pulumi.get(self, "jwt")

    @jwt.setter
    def jwt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwt", value)

    @property
    @pulumi.getter(name="jwtHeader")
    def jwt_header(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies which algorithm is used to generate the signature.
        """
        return pulumi.get(self, "jwt_header")

    @jwt_header.setter
    def jwt_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwt_header", value)

    @property
    @pulumi.getter(name="jwtPayload")
    def jwt_payload(self) -> Optional[pulumi.Input[str]]:
        """
        Contains a set of claims. The JWT specification defines seven Registered Claim Names which are the standard fields commonly included in tokens. Custom claims are usually also included, depending on the purpose of the token.
        """
        return pulumi.get(self, "jwt_payload")

    @jwt_payload.setter
    def jwt_payload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwt_payload", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        User's pre-shared secret to sign the token.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgsDict(TypedDict):
        auth_endpoint: NotRequired[pulumi.Input[str]]
        """
        The auth url endpoint to send the auth code request to.
        """
        client_id: NotRequired[pulumi.Input[str]]
        """
        The client's id.
        """
        client_secret: NotRequired[pulumi.Input[str]]
        """
        The client's secret.
        """
        scope: NotRequired[pulumi.Input[str]]
        """
        A space-delimited list of requested scope permissions.
        """
        token_endpoint: NotRequired[pulumi.Input[str]]
        """
        The token url endpoint to send the token request to.
        """
elif False:
    AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOauth2AuthorizationCodeArgs:
    def __init__(__self__, *,
                 auth_endpoint: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 token_endpoint: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] auth_endpoint: The auth url endpoint to send the auth code request to.
        :param pulumi.Input[str] client_id: The client's id.
        :param pulumi.Input[str] client_secret: The client's secret.
        :param pulumi.Input[str] scope: A space-delimited list of requested scope permissions.
        :param pulumi.Input[str] token_endpoint: The token url endpoint to send the token request to.
        """
        if auth_endpoint is not None:
            pulumi.set(__self__, "auth_endpoint", auth_endpoint)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)

    @property
    @pulumi.getter(name="authEndpoint")
    def auth_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The auth url endpoint to send the auth code request to.
        """
        return pulumi.get(self, "auth_endpoint")

    @auth_endpoint.setter
    def auth_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_endpoint", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client's id.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The client's secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        A space-delimited list of requested scope permissions.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The token url endpoint to send the token request to.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_endpoint", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOauth2ClientCredentialsArgsDict(TypedDict):
        client_id: NotRequired[pulumi.Input[str]]
        """
        The client's ID.
        """
        client_secret: NotRequired[pulumi.Input[str]]
        """
        The client's secret.
        """
        request_type: NotRequired[pulumi.Input[str]]
        """
        Represent how to pass parameters to fetch access token Possible values: ["REQUEST_TYPE_UNSPECIFIED", "REQUEST_BODY", "QUERY_PARAMETERS", "ENCODED_HEADER"]
        """
        scope: NotRequired[pulumi.Input[str]]
        """
        A space-delimited list of requested scope permissions.
        """
        token_endpoint: NotRequired[pulumi.Input[str]]
        """
        The token endpoint is used by the client to obtain an access token by presenting its authorization grant or refresh token.
        """
        token_params: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgsDict']]
        """
        Token parameters for the auth request.
        """
elif False:
    AuthConfigDecryptedCredentialOauth2ClientCredentialsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 request_type: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 token_endpoint: Optional[pulumi.Input[str]] = None,
                 token_params: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgs']] = None):
        """
        :param pulumi.Input[str] client_id: The client's ID.
        :param pulumi.Input[str] client_secret: The client's secret.
        :param pulumi.Input[str] request_type: Represent how to pass parameters to fetch access token Possible values: ["REQUEST_TYPE_UNSPECIFIED", "REQUEST_BODY", "QUERY_PARAMETERS", "ENCODED_HEADER"]
        :param pulumi.Input[str] scope: A space-delimited list of requested scope permissions.
        :param pulumi.Input[str] token_endpoint: The token endpoint is used by the client to obtain an access token by presenting its authorization grant or refresh token.
        :param pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgs'] token_params: Token parameters for the auth request.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if token_params is not None:
            pulumi.set(__self__, "token_params", token_params)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client's ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The client's secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[str]]:
        """
        Represent how to pass parameters to fetch access token Possible values: ["REQUEST_TYPE_UNSPECIFIED", "REQUEST_BODY", "QUERY_PARAMETERS", "ENCODED_HEADER"]
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_type", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        A space-delimited list of requested scope permissions.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The token endpoint is used by the client to obtain an access token by presenting its authorization grant or refresh token.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="tokenParams")
    def token_params(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgs']]:
        """
        Token parameters for the auth request.
        """
        return pulumi.get(self, "token_params")

    @token_params.setter
    def token_params(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgs']]):
        pulumi.set(self, "token_params", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgsDict(TypedDict):
        entries: NotRequired[pulumi.Input[Sequence[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgsDict']]]]
        """
        A list of parameter map entries.
        Structure is documented below.
        """
elif False:
    AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsArgs:
    def __init__(__self__, *,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgs']]] entries: A list of parameter map entries.
               Structure is documented below.
        """
        if entries is not None:
            pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgs']]]]:
        """
        A list of parameter map entries.
        Structure is documented below.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgs']]]]):
        pulumi.set(self, "entries", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgsDict(TypedDict):
        key: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgsDict']]
        """
        Key of the map entry.
        Structure is documented below.
        """
        value: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgsDict']]
        """
        Value of the map entry.
        Structure is documented below.
        """
elif False:
    AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgs']] = None,
                 value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgs']] = None):
        """
        :param pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgs'] key: Key of the map entry.
               Structure is documented below.
        :param pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgs'] value: Value of the map entry.
               Structure is documented below.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgs']]:
        """
        Key of the map entry.
        Structure is documented below.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgs']]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgs']]:
        """
        Value of the map entry.
        Structure is documented below.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgs']]):
        pulumi.set(self, "value", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgsDict(TypedDict):
        literal_value: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgsDict']]
        """
        Passing a literal value
        Structure is documented below.
        """
elif False:
    AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyArgs:
    def __init__(__self__, *,
                 literal_value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgs']] = None):
        """
        :param pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgs'] literal_value: Passing a literal value
               Structure is documented below.
        """
        if literal_value is not None:
            pulumi.set(__self__, "literal_value", literal_value)

    @property
    @pulumi.getter(name="literalValue")
    def literal_value(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgs']]:
        """
        Passing a literal value
        Structure is documented below.
        """
        return pulumi.get(self, "literal_value")

    @literal_value.setter
    def literal_value(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgs']]):
        pulumi.set(self, "literal_value", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgsDict(TypedDict):
        string_value: NotRequired[pulumi.Input[str]]
        """
        String.
        """
elif False:
    AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryKeyLiteralValueArgs:
    def __init__(__self__, *,
                 string_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] string_value: String.
        """
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[str]]:
        """
        String.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string_value", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgsDict(TypedDict):
        literal_value: NotRequired[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgsDict']]
        """
        Passing a literal value
        Structure is documented below.
        """
elif False:
    AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueArgs:
    def __init__(__self__, *,
                 literal_value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgs']] = None):
        """
        :param pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgs'] literal_value: Passing a literal value
               Structure is documented below.
        """
        if literal_value is not None:
            pulumi.set(__self__, "literal_value", literal_value)

    @property
    @pulumi.getter(name="literalValue")
    def literal_value(self) -> Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgs']]:
        """
        Passing a literal value
        Structure is documented below.
        """
        return pulumi.get(self, "literal_value")

    @literal_value.setter
    def literal_value(self, value: Optional[pulumi.Input['AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgs']]):
        pulumi.set(self, "literal_value", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgsDict(TypedDict):
        string_value: NotRequired[pulumi.Input[str]]
        """
        String.
        """
elif False:
    AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOauth2ClientCredentialsTokenParamsEntryValueLiteralValueArgs:
    def __init__(__self__, *,
                 string_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] string_value: String.
        """
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[str]]:
        """
        String.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string_value", value)


if not MYPY:
    class AuthConfigDecryptedCredentialOidcTokenArgsDict(TypedDict):
        audience: NotRequired[pulumi.Input[str]]
        """
        Audience to be used when generating OIDC token. The audience claim identifies the recipients that the JWT is intended for.
        """
        service_account_email: NotRequired[pulumi.Input[str]]
        """
        The service account email to be used as the identity for the token.
        """
        token: NotRequired[pulumi.Input[str]]
        """
        (Output)
        ID token obtained for the service account.
        """
        token_expire_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The approximate time until the token retrieved is valid.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
elif False:
    AuthConfigDecryptedCredentialOidcTokenArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialOidcTokenArgs:
    def __init__(__self__, *,
                 audience: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 token_expire_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] audience: Audience to be used when generating OIDC token. The audience claim identifies the recipients that the JWT is intended for.
        :param pulumi.Input[str] service_account_email: The service account email to be used as the identity for the token.
        :param pulumi.Input[str] token: (Output)
               ID token obtained for the service account.
        :param pulumi.Input[str] token_expire_time: (Output)
               The approximate time until the token retrieved is valid.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_expire_time is not None:
            pulumi.set(__self__, "token_expire_time", token_expire_time)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Audience to be used when generating OIDC token. The audience claim identifies the recipients that the JWT is intended for.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        The service account email to be used as the identity for the token.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        ID token obtained for the service account.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="tokenExpireTime")
    def token_expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The approximate time until the token retrieved is valid.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "token_expire_time")

    @token_expire_time.setter
    def token_expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_expire_time", value)


if not MYPY:
    class AuthConfigDecryptedCredentialServiceAccountCredentialsArgsDict(TypedDict):
        scope: NotRequired[pulumi.Input[str]]
        """
        A space-delimited list of requested scope permissions.
        """
        service_account: NotRequired[pulumi.Input[str]]
        """
        Name of the service account that has the permission to make the request.
        """
elif False:
    AuthConfigDecryptedCredentialServiceAccountCredentialsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialServiceAccountCredentialsArgs:
    def __init__(__self__, *,
                 scope: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] scope: A space-delimited list of requested scope permissions.
        :param pulumi.Input[str] service_account: Name of the service account that has the permission to make the request.
        """
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        A space-delimited list of requested scope permissions.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service account that has the permission to make the request.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)


if not MYPY:
    class AuthConfigDecryptedCredentialUsernameAndPasswordArgsDict(TypedDict):
        password: NotRequired[pulumi.Input[str]]
        """
        Password to be used.

        <a name="nested_oauth2_authorization_code"></a>The `oauth2_authorization_code` block supports:
        """
        username: NotRequired[pulumi.Input[str]]
        """
        Username to be used.
        """
elif False:
    AuthConfigDecryptedCredentialUsernameAndPasswordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AuthConfigDecryptedCredentialUsernameAndPasswordArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] password: Password to be used.
               
               <a name="nested_oauth2_authorization_code"></a>The `oauth2_authorization_code` block supports:
        :param pulumi.Input[str] username: Username to be used.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to be used.

        <a name="nested_oauth2_authorization_code"></a>The `oauth2_authorization_code` block supports:
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username to be used.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ClientCloudKmsConfigArgsDict(TypedDict):
        key: pulumi.Input[str]
        """
        A Cloud KMS key is a named object containing one or more key versions, along
        with metadata for the key. A key exists on exactly one key ring tied to a
        specific location.
        """
        kms_location: pulumi.Input[str]
        """
        Location name of the key ring, e.g. "us-west1".
        """
        kms_ring: pulumi.Input[str]
        """
        A key ring organizes keys in a specific Google Cloud location and allows you to
        manage access control on groups of keys. A key ring's name does not need to be
        unique across a Google Cloud project, but must be unique within a given location.
        """
        key_version: NotRequired[pulumi.Input[str]]
        """
        Each version of a key contains key material used for encryption or signing.
        A key's version is represented by an integer, starting at 1. To decrypt data
        or verify a signature, you must use the same key version that was used to
        encrypt or sign the data.
        """
        kms_project_id: NotRequired[pulumi.Input[str]]
        """
        The Google Cloud project id of the project where the kms key stored. If empty,
        the kms key is stored at the same project as customer's project and ecrypted
        with CMEK, otherwise, the kms key is stored in the tenant project and
        encrypted with GMEK.
        """
elif False:
    ClientCloudKmsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClientCloudKmsConfigArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 kms_location: pulumi.Input[str],
                 kms_ring: pulumi.Input[str],
                 key_version: Optional[pulumi.Input[str]] = None,
                 kms_project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: A Cloud KMS key is a named object containing one or more key versions, along
               with metadata for the key. A key exists on exactly one key ring tied to a
               specific location.
        :param pulumi.Input[str] kms_location: Location name of the key ring, e.g. "us-west1".
        :param pulumi.Input[str] kms_ring: A key ring organizes keys in a specific Google Cloud location and allows you to
               manage access control on groups of keys. A key ring's name does not need to be
               unique across a Google Cloud project, but must be unique within a given location.
        :param pulumi.Input[str] key_version: Each version of a key contains key material used for encryption or signing.
               A key's version is represented by an integer, starting at 1. To decrypt data
               or verify a signature, you must use the same key version that was used to
               encrypt or sign the data.
        :param pulumi.Input[str] kms_project_id: The Google Cloud project id of the project where the kms key stored. If empty,
               the kms key is stored at the same project as customer's project and ecrypted
               with CMEK, otherwise, the kms key is stored in the tenant project and
               encrypted with GMEK.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "kms_location", kms_location)
        pulumi.set(__self__, "kms_ring", kms_ring)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if kms_project_id is not None:
            pulumi.set(__self__, "kms_project_id", kms_project_id)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        A Cloud KMS key is a named object containing one or more key versions, along
        with metadata for the key. A key exists on exactly one key ring tied to a
        specific location.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="kmsLocation")
    def kms_location(self) -> pulumi.Input[str]:
        """
        Location name of the key ring, e.g. "us-west1".
        """
        return pulumi.get(self, "kms_location")

    @kms_location.setter
    def kms_location(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_location", value)

    @property
    @pulumi.getter(name="kmsRing")
    def kms_ring(self) -> pulumi.Input[str]:
        """
        A key ring organizes keys in a specific Google Cloud location and allows you to
        manage access control on groups of keys. A key ring's name does not need to be
        unique across a Google Cloud project, but must be unique within a given location.
        """
        return pulumi.get(self, "kms_ring")

    @kms_ring.setter
    def kms_ring(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_ring", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        Each version of a key contains key material used for encryption or signing.
        A key's version is represented by an integer, starting at 1. To decrypt data
        or verify a signature, you must use the same key version that was used to
        encrypt or sign the data.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)

    @property
    @pulumi.getter(name="kmsProjectId")
    def kms_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud project id of the project where the kms key stored. If empty,
        the kms key is stored at the same project as customer's project and ecrypted
        with CMEK, otherwise, the kms key is stored in the tenant project and
        encrypted with GMEK.
        """
        return pulumi.get(self, "kms_project_id")

    @kms_project_id.setter
    def kms_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_project_id", value)


