# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClientArgs', 'Client']

@pulumi.input_type
class ClientArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 cloud_kms_config: Optional[pulumi.Input['ClientCloudKmsConfigArgs']] = None,
                 create_sample_integrations: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 run_as_service_account: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Client resource.
        :param pulumi.Input[str] location: Location in which client needs to be provisioned.
               
               
               - - -
        :param pulumi.Input['ClientCloudKmsConfigArgs'] cloud_kms_config: Cloud KMS config for AuthModule to encrypt/decrypt credentials.
               Structure is documented below.
        :param pulumi.Input[bool] create_sample_integrations: Indicates if sample integrations should be created along with provisioning.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] run_as_service_account: User input run-as service account, if empty, will bring up a new default service account.
        """
        pulumi.set(__self__, "location", location)
        if cloud_kms_config is not None:
            pulumi.set(__self__, "cloud_kms_config", cloud_kms_config)
        if create_sample_integrations is not None:
            pulumi.set(__self__, "create_sample_integrations", create_sample_integrations)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if run_as_service_account is not None:
            pulumi.set(__self__, "run_as_service_account", run_as_service_account)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Location in which client needs to be provisioned.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="cloudKmsConfig")
    def cloud_kms_config(self) -> Optional[pulumi.Input['ClientCloudKmsConfigArgs']]:
        """
        Cloud KMS config for AuthModule to encrypt/decrypt credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_kms_config")

    @cloud_kms_config.setter
    def cloud_kms_config(self, value: Optional[pulumi.Input['ClientCloudKmsConfigArgs']]):
        pulumi.set(self, "cloud_kms_config", value)

    @property
    @pulumi.getter(name="createSampleIntegrations")
    def create_sample_integrations(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if sample integrations should be created along with provisioning.
        """
        return pulumi.get(self, "create_sample_integrations")

    @create_sample_integrations.setter
    def create_sample_integrations(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_sample_integrations", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="runAsServiceAccount")
    def run_as_service_account(self) -> Optional[pulumi.Input[str]]:
        """
        User input run-as service account, if empty, will bring up a new default service account.
        """
        return pulumi.get(self, "run_as_service_account")

    @run_as_service_account.setter
    def run_as_service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_as_service_account", value)


@pulumi.input_type
class _ClientState:
    def __init__(__self__, *,
                 cloud_kms_config: Optional[pulumi.Input['ClientCloudKmsConfigArgs']] = None,
                 create_sample_integrations: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 run_as_service_account: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Client resources.
        :param pulumi.Input['ClientCloudKmsConfigArgs'] cloud_kms_config: Cloud KMS config for AuthModule to encrypt/decrypt credentials.
               Structure is documented below.
        :param pulumi.Input[bool] create_sample_integrations: Indicates if sample integrations should be created along with provisioning.
        :param pulumi.Input[str] location: Location in which client needs to be provisioned.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] run_as_service_account: User input run-as service account, if empty, will bring up a new default service account.
        """
        if cloud_kms_config is not None:
            pulumi.set(__self__, "cloud_kms_config", cloud_kms_config)
        if create_sample_integrations is not None:
            pulumi.set(__self__, "create_sample_integrations", create_sample_integrations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if run_as_service_account is not None:
            pulumi.set(__self__, "run_as_service_account", run_as_service_account)

    @property
    @pulumi.getter(name="cloudKmsConfig")
    def cloud_kms_config(self) -> Optional[pulumi.Input['ClientCloudKmsConfigArgs']]:
        """
        Cloud KMS config for AuthModule to encrypt/decrypt credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_kms_config")

    @cloud_kms_config.setter
    def cloud_kms_config(self, value: Optional[pulumi.Input['ClientCloudKmsConfigArgs']]):
        pulumi.set(self, "cloud_kms_config", value)

    @property
    @pulumi.getter(name="createSampleIntegrations")
    def create_sample_integrations(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if sample integrations should be created along with provisioning.
        """
        return pulumi.get(self, "create_sample_integrations")

    @create_sample_integrations.setter
    def create_sample_integrations(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_sample_integrations", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location in which client needs to be provisioned.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="runAsServiceAccount")
    def run_as_service_account(self) -> Optional[pulumi.Input[str]]:
        """
        User input run-as service account, if empty, will bring up a new default service account.
        """
        return pulumi.get(self, "run_as_service_account")

    @run_as_service_account.setter
    def run_as_service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_as_service_account", value)


class Client(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_kms_config: Optional[pulumi.Input[Union['ClientCloudKmsConfigArgs', 'ClientCloudKmsConfigArgsDict']]] = None,
                 create_sample_integrations: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 run_as_service_account: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Application Integration Client.

        To get more information about Client, see:

        * [API documentation](https://cloud.google.com/application-integration/docs/reference/rest/v1/projects.locations.clients)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/application-integration/docs/overview)
            * [Set up Application Integration](https://cloud.google.com/application-integration/docs/setup-application-integration)

        ## Example Usage

        ### Integrations Client Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.applicationintegration.Client("example", location="us-central1")
        ```
        ### Integrations Client Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project()
        keyring = gcp.kms.KeyRing("keyring",
            name="my-keyring",
            location="us-east1")
        cryptokey = gcp.kms.CryptoKey("cryptokey",
            name="crypto-key-example",
            key_ring=keyring.id,
            rotation_period="7776000s")
        test_key = gcp.kms.CryptoKeyVersion("test_key", crypto_key=cryptokey.id)
        service_account = gcp.serviceaccount.Account("service_account",
            account_id="service-acc",
            display_name="Service Account")
        example = gcp.applicationintegration.Client("example",
            location="us-east1",
            create_sample_integrations=True,
            run_as_service_account=service_account.email,
            cloud_kms_config={
                "kms_location": "us-east1",
                "kms_ring": keyring.id,
                "key": cryptokey.id,
                "key_version": test_key.id,
                "kms_project_id": test_project.project_id,
            })
        ```

        ## Import

        Client can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clients`

        * `{{project}}/{{location}}`

        * `{{location}}`

        When using the `pulumi import` command, Client can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:applicationintegration/client:Client default projects/{{project}}/locations/{{location}}/clients
        ```

        ```sh
        $ pulumi import gcp:applicationintegration/client:Client default {{project}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:applicationintegration/client:Client default {{location}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClientCloudKmsConfigArgs', 'ClientCloudKmsConfigArgsDict']] cloud_kms_config: Cloud KMS config for AuthModule to encrypt/decrypt credentials.
               Structure is documented below.
        :param pulumi.Input[bool] create_sample_integrations: Indicates if sample integrations should be created along with provisioning.
        :param pulumi.Input[str] location: Location in which client needs to be provisioned.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] run_as_service_account: User input run-as service account, if empty, will bring up a new default service account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Application Integration Client.

        To get more information about Client, see:

        * [API documentation](https://cloud.google.com/application-integration/docs/reference/rest/v1/projects.locations.clients)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/application-integration/docs/overview)
            * [Set up Application Integration](https://cloud.google.com/application-integration/docs/setup-application-integration)

        ## Example Usage

        ### Integrations Client Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.applicationintegration.Client("example", location="us-central1")
        ```
        ### Integrations Client Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_project = gcp.organizations.get_project()
        keyring = gcp.kms.KeyRing("keyring",
            name="my-keyring",
            location="us-east1")
        cryptokey = gcp.kms.CryptoKey("cryptokey",
            name="crypto-key-example",
            key_ring=keyring.id,
            rotation_period="7776000s")
        test_key = gcp.kms.CryptoKeyVersion("test_key", crypto_key=cryptokey.id)
        service_account = gcp.serviceaccount.Account("service_account",
            account_id="service-acc",
            display_name="Service Account")
        example = gcp.applicationintegration.Client("example",
            location="us-east1",
            create_sample_integrations=True,
            run_as_service_account=service_account.email,
            cloud_kms_config={
                "kms_location": "us-east1",
                "kms_ring": keyring.id,
                "key": cryptokey.id,
                "key_version": test_key.id,
                "kms_project_id": test_project.project_id,
            })
        ```

        ## Import

        Client can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/clients`

        * `{{project}}/{{location}}`

        * `{{location}}`

        When using the `pulumi import` command, Client can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:applicationintegration/client:Client default projects/{{project}}/locations/{{location}}/clients
        ```

        ```sh
        $ pulumi import gcp:applicationintegration/client:Client default {{project}}/{{location}}
        ```

        ```sh
        $ pulumi import gcp:applicationintegration/client:Client default {{location}}
        ```

        :param str resource_name: The name of the resource.
        :param ClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_kms_config: Optional[pulumi.Input[Union['ClientCloudKmsConfigArgs', 'ClientCloudKmsConfigArgsDict']]] = None,
                 create_sample_integrations: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 run_as_service_account: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientArgs.__new__(ClientArgs)

            __props__.__dict__["cloud_kms_config"] = cloud_kms_config
            __props__.__dict__["create_sample_integrations"] = create_sample_integrations
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["run_as_service_account"] = run_as_service_account
        super(Client, __self__).__init__(
            'gcp:applicationintegration/client:Client',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_kms_config: Optional[pulumi.Input[Union['ClientCloudKmsConfigArgs', 'ClientCloudKmsConfigArgsDict']]] = None,
            create_sample_integrations: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            run_as_service_account: Optional[pulumi.Input[str]] = None) -> 'Client':
        """
        Get an existing Client resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClientCloudKmsConfigArgs', 'ClientCloudKmsConfigArgsDict']] cloud_kms_config: Cloud KMS config for AuthModule to encrypt/decrypt credentials.
               Structure is documented below.
        :param pulumi.Input[bool] create_sample_integrations: Indicates if sample integrations should be created along with provisioning.
        :param pulumi.Input[str] location: Location in which client needs to be provisioned.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] run_as_service_account: User input run-as service account, if empty, will bring up a new default service account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientState.__new__(_ClientState)

        __props__.__dict__["cloud_kms_config"] = cloud_kms_config
        __props__.__dict__["create_sample_integrations"] = create_sample_integrations
        __props__.__dict__["location"] = location
        __props__.__dict__["project"] = project
        __props__.__dict__["run_as_service_account"] = run_as_service_account
        return Client(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudKmsConfig")
    def cloud_kms_config(self) -> pulumi.Output[Optional['outputs.ClientCloudKmsConfig']]:
        """
        Cloud KMS config for AuthModule to encrypt/decrypt credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_kms_config")

    @property
    @pulumi.getter(name="createSampleIntegrations")
    def create_sample_integrations(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if sample integrations should be created along with provisioning.
        """
        return pulumi.get(self, "create_sample_integrations")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Location in which client needs to be provisioned.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="runAsServiceAccount")
    def run_as_service_account(self) -> pulumi.Output[Optional[str]]:
        """
        User input run-as service account, if empty, will bring up a new default service account.
        """
        return pulumi.get(self, "run_as_service_account")

