# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLocationsResult',
    'AwaitableGetLocationsResult',
    'get_locations',
    'get_locations_output',
]

@pulumi.output_type
class GetLocationsResult:
    """
    A collection of values returned by getLocations.
    """
    def __init__(__self__, id=None, locations=None, project=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def locations(self) -> Sequence[str]:
        """
        The list of Artifact Registry locations available for the given project.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")


class AwaitableGetLocationsResult(GetLocationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationsResult(
            id=self.id,
            locations=self.locations,
            project=self.project)


def get_locations(project: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationsResult:
    """
    Get Artifact Registry locations available for a project.

    To get more information about Artifact Registry, see:

    * [API documentation](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations/list)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/artifact-registry/docs/overview)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.artifactregistry.get_locations()
    ```

    ### Multi-Regional Artifact Registry Deployment

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.artifactregistry.get_locations()
    repo_one = gcp.artifactregistry.Repository("repo_one",
        location=available.locations[0],
        repository_id="repo-one",
        format="apt")
    repo_two = gcp.artifactregistry.Repository("repo_two",
        location=available.locations[1],
        repository_id="repo-two",
        format="apt")
    ```


    :param str project: The project to list versions for. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getLocations:getLocations', __args__, opts=opts, typ=GetLocationsResult).value

    return AwaitableGetLocationsResult(
        id=pulumi.get(__ret__, 'id'),
        locations=pulumi.get(__ret__, 'locations'),
        project=pulumi.get(__ret__, 'project'))


@_utilities.lift_output_func(get_locations)
def get_locations_output(project: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLocationsResult]:
    """
    Get Artifact Registry locations available for a project.

    To get more information about Artifact Registry, see:

    * [API documentation](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations/list)
    * How-to Guides
        * [Official Documentation](https://cloud.google.com/artifact-registry/docs/overview)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.artifactregistry.get_locations()
    ```

    ### Multi-Regional Artifact Registry Deployment

    ```python
    import pulumi
    import pulumi_gcp as gcp

    available = gcp.artifactregistry.get_locations()
    repo_one = gcp.artifactregistry.Repository("repo_one",
        location=available.locations[0],
        repository_id="repo-one",
        format="apt")
    repo_two = gcp.artifactregistry.Repository("repo_two",
        location=available.locations[1],
        repository_id="repo-two",
        format="apt")
    ```


    :param str project: The project to list versions for. If it
           is not provided, the provider project is used.
    """
    ...
