# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RepositoryCleanupPolicy',
    'RepositoryCleanupPolicyCondition',
    'RepositoryCleanupPolicyMostRecentVersions',
    'RepositoryDockerConfig',
    'RepositoryIamBindingCondition',
    'RepositoryIamMemberCondition',
    'RepositoryMavenConfig',
    'RepositoryRemoteRepositoryConfig',
    'RepositoryRemoteRepositoryConfigAptRepository',
    'RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository',
    'RepositoryRemoteRepositoryConfigDockerRepository',
    'RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigMavenRepository',
    'RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigNpmRepository',
    'RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigPythonRepository',
    'RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository',
    'RepositoryRemoteRepositoryConfigUpstreamCredentials',
    'RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials',
    'RepositoryRemoteRepositoryConfigYumRepository',
    'RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository',
    'RepositoryVirtualRepositoryConfig',
    'RepositoryVirtualRepositoryConfigUpstreamPolicy',
    'GetRepositoryCleanupPolicyResult',
    'GetRepositoryCleanupPolicyConditionResult',
    'GetRepositoryCleanupPolicyMostRecentVersionResult',
    'GetRepositoryDockerConfigResult',
    'GetRepositoryMavenConfigResult',
    'GetRepositoryRemoteRepositoryConfigResult',
    'GetRepositoryRemoteRepositoryConfigAptRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigDockerRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigMavenRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigNpmRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigPythonRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult',
    'GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult',
    'GetRepositoryRemoteRepositoryConfigYumRepositoryResult',
    'GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult',
    'GetRepositoryVirtualRepositoryConfigResult',
    'GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult',
]

@pulumi.output_type
class RepositoryCleanupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mostRecentVersions":
            suggest = "most_recent_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 action: Optional[str] = None,
                 condition: Optional['outputs.RepositoryCleanupPolicyCondition'] = None,
                 most_recent_versions: Optional['outputs.RepositoryCleanupPolicyMostRecentVersions'] = None):
        """
        :param str id: The identifier for this object. Format specified above.
        :param str action: Policy action.
               Possible values are: `DELETE`, `KEEP`.
        :param 'RepositoryCleanupPolicyConditionArgs' condition: Policy condition for matching versions.
               Structure is documented below.
        :param 'RepositoryCleanupPolicyMostRecentVersionsArgs' most_recent_versions: Policy condition for retaining a minimum number of versions. May only be
               specified with a Keep action.
               Structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if most_recent_versions is not None:
            pulumi.set(__self__, "most_recent_versions", most_recent_versions)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Policy action.
        Possible values are: `DELETE`, `KEEP`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> Optional['outputs.RepositoryCleanupPolicyCondition']:
        """
        Policy condition for matching versions.
        Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="mostRecentVersions")
    def most_recent_versions(self) -> Optional['outputs.RepositoryCleanupPolicyMostRecentVersions']:
        """
        Policy condition for retaining a minimum number of versions. May only be
        specified with a Keep action.
        Structure is documented below.
        """
        return pulumi.get(self, "most_recent_versions")


@pulumi.output_type
class RepositoryCleanupPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newerThan":
            suggest = "newer_than"
        elif key == "olderThan":
            suggest = "older_than"
        elif key == "packageNamePrefixes":
            suggest = "package_name_prefixes"
        elif key == "tagPrefixes":
            suggest = "tag_prefixes"
        elif key == "tagState":
            suggest = "tag_state"
        elif key == "versionNamePrefixes":
            suggest = "version_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 newer_than: Optional[str] = None,
                 older_than: Optional[str] = None,
                 package_name_prefixes: Optional[Sequence[str]] = None,
                 tag_prefixes: Optional[Sequence[str]] = None,
                 tag_state: Optional[str] = None,
                 version_name_prefixes: Optional[Sequence[str]] = None):
        """
        :param str newer_than: Match versions newer than a duration.
        :param str older_than: Match versions older than a duration.
        :param Sequence[str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        :param Sequence[str] tag_prefixes: Match versions by tag prefix. Applied on any prefix match.
        :param str tag_state: Match versions by tag status.
               Default value is `ANY`.
               Possible values are: `TAGGED`, `UNTAGGED`, `ANY`.
        :param Sequence[str] version_name_prefixes: Match versions by version name prefix. Applied on any prefix match.
        """
        if newer_than is not None:
            pulumi.set(__self__, "newer_than", newer_than)
        if older_than is not None:
            pulumi.set(__self__, "older_than", older_than)
        if package_name_prefixes is not None:
            pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)
        if tag_prefixes is not None:
            pulumi.set(__self__, "tag_prefixes", tag_prefixes)
        if tag_state is not None:
            pulumi.set(__self__, "tag_state", tag_state)
        if version_name_prefixes is not None:
            pulumi.set(__self__, "version_name_prefixes", version_name_prefixes)

    @property
    @pulumi.getter(name="newerThan")
    def newer_than(self) -> Optional[str]:
        """
        Match versions newer than a duration.
        """
        return pulumi.get(self, "newer_than")

    @property
    @pulumi.getter(name="olderThan")
    def older_than(self) -> Optional[str]:
        """
        Match versions older than a duration.
        """
        return pulumi.get(self, "older_than")

    @property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Optional[Sequence[str]]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")

    @property
    @pulumi.getter(name="tagPrefixes")
    def tag_prefixes(self) -> Optional[Sequence[str]]:
        """
        Match versions by tag prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "tag_prefixes")

    @property
    @pulumi.getter(name="tagState")
    def tag_state(self) -> Optional[str]:
        """
        Match versions by tag status.
        Default value is `ANY`.
        Possible values are: `TAGGED`, `UNTAGGED`, `ANY`.
        """
        return pulumi.get(self, "tag_state")

    @property
    @pulumi.getter(name="versionNamePrefixes")
    def version_name_prefixes(self) -> Optional[Sequence[str]]:
        """
        Match versions by version name prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "version_name_prefixes")


@pulumi.output_type
class RepositoryCleanupPolicyMostRecentVersions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keepCount":
            suggest = "keep_count"
        elif key == "packageNamePrefixes":
            suggest = "package_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCleanupPolicyMostRecentVersions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCleanupPolicyMostRecentVersions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCleanupPolicyMostRecentVersions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 keep_count: Optional[int] = None,
                 package_name_prefixes: Optional[Sequence[str]] = None):
        """
        :param int keep_count: Minimum number of versions to keep.
        :param Sequence[str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        """
        if keep_count is not None:
            pulumi.set(__self__, "keep_count", keep_count)
        if package_name_prefixes is not None:
            pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)

    @property
    @pulumi.getter(name="keepCount")
    def keep_count(self) -> Optional[int]:
        """
        Minimum number of versions to keep.
        """
        return pulumi.get(self, "keep_count")

    @property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Optional[Sequence[str]]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")


@pulumi.output_type
class RepositoryDockerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immutableTags":
            suggest = "immutable_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryDockerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryDockerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryDockerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immutable_tags: Optional[bool] = None):
        """
        :param bool immutable_tags: The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        if immutable_tags is not None:
            pulumi.set(__self__, "immutable_tags", immutable_tags)

    @property
    @pulumi.getter(name="immutableTags")
    def immutable_tags(self) -> Optional[bool]:
        """
        The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        return pulumi.get(self, "immutable_tags")


@pulumi.output_type
class RepositoryIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class RepositoryMavenConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSnapshotOverwrites":
            suggest = "allow_snapshot_overwrites"
        elif key == "versionPolicy":
            suggest = "version_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryMavenConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryMavenConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryMavenConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_snapshot_overwrites: Optional[bool] = None,
                 version_policy: Optional[str] = None):
        """
        :param bool allow_snapshot_overwrites: The repository with this flag will allow publishing the same
               snapshot versions.
        :param str version_policy: Version policy defines the versions that the registry will accept.
               Default value is `VERSION_POLICY_UNSPECIFIED`.
               Possible values are: `VERSION_POLICY_UNSPECIFIED`, `RELEASE`, `SNAPSHOT`.
        """
        if allow_snapshot_overwrites is not None:
            pulumi.set(__self__, "allow_snapshot_overwrites", allow_snapshot_overwrites)
        if version_policy is not None:
            pulumi.set(__self__, "version_policy", version_policy)

    @property
    @pulumi.getter(name="allowSnapshotOverwrites")
    def allow_snapshot_overwrites(self) -> Optional[bool]:
        """
        The repository with this flag will allow publishing the same
        snapshot versions.
        """
        return pulumi.get(self, "allow_snapshot_overwrites")

    @property
    @pulumi.getter(name="versionPolicy")
    def version_policy(self) -> Optional[str]:
        """
        Version policy defines the versions that the registry will accept.
        Default value is `VERSION_POLICY_UNSPECIFIED`.
        Possible values are: `VERSION_POLICY_UNSPECIFIED`, `RELEASE`, `SNAPSHOT`.
        """
        return pulumi.get(self, "version_policy")


@pulumi.output_type
class RepositoryRemoteRepositoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aptRepository":
            suggest = "apt_repository"
        elif key == "disableUpstreamValidation":
            suggest = "disable_upstream_validation"
        elif key == "dockerRepository":
            suggest = "docker_repository"
        elif key == "mavenRepository":
            suggest = "maven_repository"
        elif key == "npmRepository":
            suggest = "npm_repository"
        elif key == "pythonRepository":
            suggest = "python_repository"
        elif key == "upstreamCredentials":
            suggest = "upstream_credentials"
        elif key == "yumRepository":
            suggest = "yum_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apt_repository: Optional['outputs.RepositoryRemoteRepositoryConfigAptRepository'] = None,
                 description: Optional[str] = None,
                 disable_upstream_validation: Optional[bool] = None,
                 docker_repository: Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepository'] = None,
                 maven_repository: Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepository'] = None,
                 npm_repository: Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepository'] = None,
                 python_repository: Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepository'] = None,
                 upstream_credentials: Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentials'] = None,
                 yum_repository: Optional['outputs.RepositoryRemoteRepositoryConfigYumRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigAptRepositoryArgs' apt_repository: Specific settings for an Apt remote repository.
               Structure is documented below.
        :param str description: The description of the remote source.
        :param bool disable_upstream_validation: If true, the remote repository upstream and upstream credentials will
               not be validated.
        :param 'RepositoryRemoteRepositoryConfigDockerRepositoryArgs' docker_repository: Specific settings for a Docker remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigMavenRepositoryArgs' maven_repository: Specific settings for a Maven remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigNpmRepositoryArgs' npm_repository: Specific settings for an Npm remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigPythonRepositoryArgs' python_repository: Specific settings for a Python remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigUpstreamCredentialsArgs' upstream_credentials: The credentials used to access the remote repository.
               Structure is documented below.
        :param 'RepositoryRemoteRepositoryConfigYumRepositoryArgs' yum_repository: Specific settings for an Yum remote repository.
               Structure is documented below.
        """
        if apt_repository is not None:
            pulumi.set(__self__, "apt_repository", apt_repository)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_upstream_validation is not None:
            pulumi.set(__self__, "disable_upstream_validation", disable_upstream_validation)
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if maven_repository is not None:
            pulumi.set(__self__, "maven_repository", maven_repository)
        if npm_repository is not None:
            pulumi.set(__self__, "npm_repository", npm_repository)
        if python_repository is not None:
            pulumi.set(__self__, "python_repository", python_repository)
        if upstream_credentials is not None:
            pulumi.set(__self__, "upstream_credentials", upstream_credentials)
        if yum_repository is not None:
            pulumi.set(__self__, "yum_repository", yum_repository)

    @property
    @pulumi.getter(name="aptRepository")
    def apt_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigAptRepository']:
        """
        Specific settings for an Apt remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "apt_repository")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the remote source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableUpstreamValidation")
    def disable_upstream_validation(self) -> Optional[bool]:
        """
        If true, the remote repository upstream and upstream credentials will
        not be validated.
        """
        return pulumi.get(self, "disable_upstream_validation")

    @property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepository']:
        """
        Specific settings for a Docker remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "docker_repository")

    @property
    @pulumi.getter(name="mavenRepository")
    def maven_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepository']:
        """
        Specific settings for a Maven remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "maven_repository")

    @property
    @pulumi.getter(name="npmRepository")
    def npm_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepository']:
        """
        Specific settings for an Npm remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "npm_repository")

    @property
    @pulumi.getter(name="pythonRepository")
    def python_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepository']:
        """
        Specific settings for a Python remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "python_repository")

    @property
    @pulumi.getter(name="upstreamCredentials")
    def upstream_credentials(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentials']:
        """
        The credentials used to access the remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "upstream_credentials")

    @property
    @pulumi.getter(name="yumRepository")
    def yum_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigYumRepository']:
        """
        Specific settings for an Yum remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "yum_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigAptRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigAptRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigAptRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigAptRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_repository: Optional['outputs.RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryArgs' public_repository: One of the publicly available Apt repositories supported by Artifact Registry.
               Structure is documented below.
        """
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository']:
        """
        One of the publicly available Apt repositories supported by Artifact Registry.
        Structure is documented below.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryBase":
            suggest = "repository_base"
        elif key == "repositoryPath":
            suggest = "repository_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigAptRepositoryPublicRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_base: str,
                 repository_path: str):
        """
        :param str repository_base: A common public repository base for Yum.
               Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        :param str repository_path: Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> str:
        """
        A common public repository base for Yum.
        Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        """
        return pulumi.get(self, "repository_base")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> str:
        """
        Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigDockerRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigDockerRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigDockerRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigDockerRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository'] = None,
                 public_repository: Optional[str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryArgs' custom_repository: Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param str public_repository: Address of the remote repository.
               Default value is `DOCKER_HUB`.
               Possible values are: `DOCKER_HUB`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository']:
        """
        Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[str]:
        """
        Address of the remote repository.
        Default value is `DOCKER_HUB`.
        Possible values are: `DOCKER_HUB`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigDockerRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        :param str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigMavenRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigMavenRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigMavenRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigMavenRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository'] = None,
                 public_repository: Optional[str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryArgs' custom_repository: Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param str public_repository: Address of the remote repository.
               Default value is `MAVEN_CENTRAL`.
               Possible values are: `MAVEN_CENTRAL`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository']:
        """
        Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[str]:
        """
        Address of the remote repository.
        Default value is `MAVEN_CENTRAL`.
        Possible values are: `MAVEN_CENTRAL`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigMavenRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        :param str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigNpmRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigNpmRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigNpmRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigNpmRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository'] = None,
                 public_repository: Optional[str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryArgs' custom_repository: Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param str public_repository: Address of the remote repository.
               Default value is `NPMJS`.
               Possible values are: `NPMJS`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository']:
        """
        Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[str]:
        """
        Address of the remote repository.
        Default value is `NPMJS`.
        Possible values are: `NPMJS`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigNpmRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        :param str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigPythonRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRepository":
            suggest = "custom_repository"
        elif key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigPythonRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigPythonRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigPythonRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_repository: Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository'] = None,
                 public_repository: Optional[str] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryArgs' custom_repository: Settings for a remote repository with a custom uri.
               Structure is documented below.
        :param str public_repository: Address of the remote repository.
               Default value is `PYPI`.
               Possible values are: `PYPI`.
        """
        if custom_repository is not None:
            pulumi.set(__self__, "custom_repository", custom_repository)
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepository")
    def custom_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository']:
        """
        Settings for a remote repository with a custom uri.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_repository")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional[str]:
        """
        Address of the remote repository.
        Default value is `PYPI`.
        Possible values are: `PYPI`.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigPythonRepositoryCustomRepository(dict):
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        :param str uri: Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Specific uri to the registry, e.g. `"https://pypi.io"`
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigUpstreamCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usernamePasswordCredentials":
            suggest = "username_password_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigUpstreamCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 username_password_credentials: Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentialsArgs' username_password_credentials: Use username and password to access the remote repository.
               Structure is documented below.
        """
        if username_password_credentials is not None:
            pulumi.set(__self__, "username_password_credentials", username_password_credentials)

    @property
    @pulumi.getter(name="usernamePasswordCredentials")
    def username_password_credentials(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials']:
        """
        Use username and password to access the remote repository.
        Structure is documented below.
        """
        return pulumi.get(self, "username_password_credentials")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretVersion":
            suggest = "password_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigUpstreamCredentialsUsernamePasswordCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_secret_version: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str password_secret_version: The Secret Manager key version that holds the password to access the
               remote repository. Must be in the format of
               `projects/{project}/secrets/{secret}/versions/{version}`.
        :param str username: The username to access the remote repository.
        """
        if password_secret_version is not None:
            pulumi.set(__self__, "password_secret_version", password_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> Optional[str]:
        """
        The Secret Manager key version that holds the password to access the
        remote repository. Must be in the format of
        `projects/{project}/secrets/{secret}/versions/{version}`.
        """
        return pulumi.get(self, "password_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username to access the remote repository.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigYumRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicRepository":
            suggest = "public_repository"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigYumRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigYumRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigYumRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_repository: Optional['outputs.RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository'] = None):
        """
        :param 'RepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryArgs' public_repository: One of the publicly available Yum repositories supported by Artifact Registry.
               Structure is documented below.
        """
        if public_repository is not None:
            pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> Optional['outputs.RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository']:
        """
        One of the publicly available Yum repositories supported by Artifact Registry.
        Structure is documented below.
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryBase":
            suggest = "repository_base"
        elif key == "repositoryPath":
            suggest = "repository_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryRemoteRepositoryConfigYumRepositoryPublicRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_base: str,
                 repository_path: str):
        """
        :param str repository_base: A common public repository base for Yum.
               Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        :param str repository_path: Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> str:
        """
        A common public repository base for Yum.
        Possible values are: `CENTOS`, `CENTOS_DEBUG`, `CENTOS_VAULT`, `CENTOS_STREAM`, `ROCKY`, `EPEL`.
        """
        return pulumi.get(self, "repository_base")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> str:
        """
        Specific repository from the base, e.g. `"pub/rocky/9/BaseOS/x86_64/os"`
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class RepositoryVirtualRepositoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "upstreamPolicies":
            suggest = "upstream_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryVirtualRepositoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryVirtualRepositoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryVirtualRepositoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 upstream_policies: Optional[Sequence['outputs.RepositoryVirtualRepositoryConfigUpstreamPolicy']] = None):
        """
        :param Sequence['RepositoryVirtualRepositoryConfigUpstreamPolicyArgs'] upstream_policies: Policies that configure the upstream artifacts distributed by the Virtual
               Repository. Upstream policies cannot be set on a standard repository.
               Structure is documented below.
        """
        if upstream_policies is not None:
            pulumi.set(__self__, "upstream_policies", upstream_policies)

    @property
    @pulumi.getter(name="upstreamPolicies")
    def upstream_policies(self) -> Optional[Sequence['outputs.RepositoryVirtualRepositoryConfigUpstreamPolicy']]:
        """
        Policies that configure the upstream artifacts distributed by the Virtual
        Repository. Upstream policies cannot be set on a standard repository.
        Structure is documented below.
        """
        return pulumi.get(self, "upstream_policies")


@pulumi.output_type
class RepositoryVirtualRepositoryConfigUpstreamPolicy(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 priority: Optional[int] = None,
                 repository: Optional[str] = None):
        """
        :param str id: The user-provided ID of the upstream policy.
        :param int priority: Entries with a greater priority value take precedence in the pull order.
        :param str repository: A reference to the repository resource, for example:
               "projects/p1/locations/us-central1/repository/repo1".
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The user-provided ID of the upstream policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Entries with a greater priority value take precedence in the pull order.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def repository(self) -> Optional[str]:
        """
        A reference to the repository resource, for example:
        "projects/p1/locations/us-central1/repository/repo1".
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class GetRepositoryCleanupPolicyResult(dict):
    def __init__(__self__, *,
                 action: str,
                 conditions: Sequence['outputs.GetRepositoryCleanupPolicyConditionResult'],
                 id: str,
                 most_recent_versions: Sequence['outputs.GetRepositoryCleanupPolicyMostRecentVersionResult']):
        """
        :param str action: Policy action. Possible values: ["DELETE", "KEEP"]
        :param Sequence['GetRepositoryCleanupPolicyConditionArgs'] conditions: Policy condition for matching versions.
        :param Sequence['GetRepositoryCleanupPolicyMostRecentVersionArgs'] most_recent_versions: Policy condition for retaining a minimum number of versions. May only be
               specified with a Keep action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "most_recent_versions", most_recent_versions)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Policy action. Possible values: ["DELETE", "KEEP"]
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetRepositoryCleanupPolicyConditionResult']:
        """
        Policy condition for matching versions.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mostRecentVersions")
    def most_recent_versions(self) -> Sequence['outputs.GetRepositoryCleanupPolicyMostRecentVersionResult']:
        """
        Policy condition for retaining a minimum number of versions. May only be
        specified with a Keep action.
        """
        return pulumi.get(self, "most_recent_versions")


@pulumi.output_type
class GetRepositoryCleanupPolicyConditionResult(dict):
    def __init__(__self__, *,
                 newer_than: str,
                 older_than: str,
                 package_name_prefixes: Sequence[str],
                 tag_prefixes: Sequence[str],
                 tag_state: str,
                 version_name_prefixes: Sequence[str]):
        """
        :param str newer_than: Match versions newer than a duration.
        :param str older_than: Match versions older than a duration.
        :param Sequence[str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        :param Sequence[str] tag_prefixes: Match versions by tag prefix. Applied on any prefix match.
        :param str tag_state: Match versions by tag status. Default value: "ANY" Possible values: ["TAGGED", "UNTAGGED", "ANY"]
        :param Sequence[str] version_name_prefixes: Match versions by version name prefix. Applied on any prefix match.
        """
        pulumi.set(__self__, "newer_than", newer_than)
        pulumi.set(__self__, "older_than", older_than)
        pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)
        pulumi.set(__self__, "tag_prefixes", tag_prefixes)
        pulumi.set(__self__, "tag_state", tag_state)
        pulumi.set(__self__, "version_name_prefixes", version_name_prefixes)

    @property
    @pulumi.getter(name="newerThan")
    def newer_than(self) -> str:
        """
        Match versions newer than a duration.
        """
        return pulumi.get(self, "newer_than")

    @property
    @pulumi.getter(name="olderThan")
    def older_than(self) -> str:
        """
        Match versions older than a duration.
        """
        return pulumi.get(self, "older_than")

    @property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Sequence[str]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")

    @property
    @pulumi.getter(name="tagPrefixes")
    def tag_prefixes(self) -> Sequence[str]:
        """
        Match versions by tag prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "tag_prefixes")

    @property
    @pulumi.getter(name="tagState")
    def tag_state(self) -> str:
        """
        Match versions by tag status. Default value: "ANY" Possible values: ["TAGGED", "UNTAGGED", "ANY"]
        """
        return pulumi.get(self, "tag_state")

    @property
    @pulumi.getter(name="versionNamePrefixes")
    def version_name_prefixes(self) -> Sequence[str]:
        """
        Match versions by version name prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "version_name_prefixes")


@pulumi.output_type
class GetRepositoryCleanupPolicyMostRecentVersionResult(dict):
    def __init__(__self__, *,
                 keep_count: int,
                 package_name_prefixes: Sequence[str]):
        """
        :param int keep_count: Minimum number of versions to keep.
        :param Sequence[str] package_name_prefixes: Match versions by package prefix. Applied on any prefix match.
        """
        pulumi.set(__self__, "keep_count", keep_count)
        pulumi.set(__self__, "package_name_prefixes", package_name_prefixes)

    @property
    @pulumi.getter(name="keepCount")
    def keep_count(self) -> int:
        """
        Minimum number of versions to keep.
        """
        return pulumi.get(self, "keep_count")

    @property
    @pulumi.getter(name="packageNamePrefixes")
    def package_name_prefixes(self) -> Sequence[str]:
        """
        Match versions by package prefix. Applied on any prefix match.
        """
        return pulumi.get(self, "package_name_prefixes")


@pulumi.output_type
class GetRepositoryDockerConfigResult(dict):
    def __init__(__self__, *,
                 immutable_tags: bool):
        """
        :param bool immutable_tags: The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        pulumi.set(__self__, "immutable_tags", immutable_tags)

    @property
    @pulumi.getter(name="immutableTags")
    def immutable_tags(self) -> bool:
        """
        The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
        """
        return pulumi.get(self, "immutable_tags")


@pulumi.output_type
class GetRepositoryMavenConfigResult(dict):
    def __init__(__self__, *,
                 allow_snapshot_overwrites: bool,
                 version_policy: str):
        """
        :param bool allow_snapshot_overwrites: The repository with this flag will allow publishing the same
               snapshot versions.
        :param str version_policy: Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
        """
        pulumi.set(__self__, "allow_snapshot_overwrites", allow_snapshot_overwrites)
        pulumi.set(__self__, "version_policy", version_policy)

    @property
    @pulumi.getter(name="allowSnapshotOverwrites")
    def allow_snapshot_overwrites(self) -> bool:
        """
        The repository with this flag will allow publishing the same
        snapshot versions.
        """
        return pulumi.get(self, "allow_snapshot_overwrites")

    @property
    @pulumi.getter(name="versionPolicy")
    def version_policy(self) -> str:
        """
        Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
        """
        return pulumi.get(self, "version_policy")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigResult(dict):
    def __init__(__self__, *,
                 apt_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryResult'],
                 description: str,
                 disable_upstream_validation: bool,
                 docker_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryResult'],
                 maven_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryResult'],
                 npm_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryResult'],
                 python_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryResult'],
                 upstream_credentials: Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult'],
                 yum_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigAptRepositoryArgs'] apt_repositories: Specific settings for an Apt remote repository.
        :param str description: The description of the remote source.
        :param bool disable_upstream_validation: If true, the remote repository upstream and upstream credentials will
               not be validated.
        :param Sequence['GetRepositoryRemoteRepositoryConfigDockerRepositoryArgs'] docker_repositories: Specific settings for a Docker remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigMavenRepositoryArgs'] maven_repositories: Specific settings for a Maven remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigNpmRepositoryArgs'] npm_repositories: Specific settings for an Npm remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigPythonRepositoryArgs'] python_repositories: Specific settings for a Python remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigUpstreamCredentialArgs'] upstream_credentials: The credentials used to access the remote repository.
        :param Sequence['GetRepositoryRemoteRepositoryConfigYumRepositoryArgs'] yum_repositories: Specific settings for an Yum remote repository.
        """
        pulumi.set(__self__, "apt_repositories", apt_repositories)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disable_upstream_validation", disable_upstream_validation)
        pulumi.set(__self__, "docker_repositories", docker_repositories)
        pulumi.set(__self__, "maven_repositories", maven_repositories)
        pulumi.set(__self__, "npm_repositories", npm_repositories)
        pulumi.set(__self__, "python_repositories", python_repositories)
        pulumi.set(__self__, "upstream_credentials", upstream_credentials)
        pulumi.set(__self__, "yum_repositories", yum_repositories)

    @property
    @pulumi.getter(name="aptRepositories")
    def apt_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryResult']:
        """
        Specific settings for an Apt remote repository.
        """
        return pulumi.get(self, "apt_repositories")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the remote source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableUpstreamValidation")
    def disable_upstream_validation(self) -> bool:
        """
        If true, the remote repository upstream and upstream credentials will
        not be validated.
        """
        return pulumi.get(self, "disable_upstream_validation")

    @property
    @pulumi.getter(name="dockerRepositories")
    def docker_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryResult']:
        """
        Specific settings for a Docker remote repository.
        """
        return pulumi.get(self, "docker_repositories")

    @property
    @pulumi.getter(name="mavenRepositories")
    def maven_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryResult']:
        """
        Specific settings for a Maven remote repository.
        """
        return pulumi.get(self, "maven_repositories")

    @property
    @pulumi.getter(name="npmRepositories")
    def npm_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryResult']:
        """
        Specific settings for an Npm remote repository.
        """
        return pulumi.get(self, "npm_repositories")

    @property
    @pulumi.getter(name="pythonRepositories")
    def python_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryResult']:
        """
        Specific settings for a Python remote repository.
        """
        return pulumi.get(self, "python_repositories")

    @property
    @pulumi.getter(name="upstreamCredentials")
    def upstream_credentials(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult']:
        """
        The credentials used to access the remote repository.
        """
        return pulumi.get(self, "upstream_credentials")

    @property
    @pulumi.getter(name="yumRepositories")
    def yum_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryResult']:
        """
        Specific settings for an Yum remote repository.
        """
        return pulumi.get(self, "yum_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigAptRepositoryResult(dict):
    def __init__(__self__, *,
                 public_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryArgs'] public_repositories: One of the publicly available Apt repositories supported by Artifact Registry.
        """
        pulumi.set(__self__, "public_repositories", public_repositories)

    @property
    @pulumi.getter(name="publicRepositories")
    def public_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult']:
        """
        One of the publicly available Apt repositories supported by Artifact Registry.
        """
        return pulumi.get(self, "public_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigAptRepositoryPublicRepositoryResult(dict):
    def __init__(__self__, *,
                 repository_base: str,
                 repository_path: str):
        """
        :param str repository_base: A common public repository base for Apt, e.g. '"debian/dists/buster"' Possible values: ["DEBIAN", "UBUNTU"]
        :param str repository_path: Specific repository from the base.
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> str:
        """
        A common public repository base for Apt, e.g. '"debian/dists/buster"' Possible values: ["DEBIAN", "UBUNTU"]
        """
        return pulumi.get(self, "repository_base")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> str:
        """
        Specific repository from the base.
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigDockerRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult'],
                 public_repository: str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryArgs'] custom_repositories: Settings for a remote repository with a custom uri.
        :param str public_repository: Address of the remote repository. Default value: "DOCKER_HUB" Possible values: ["DOCKER_HUB"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult']:
        """
        Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> str:
        """
        Address of the remote repository. Default value: "DOCKER_HUB" Possible values: ["DOCKER_HUB"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigDockerRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: str):
        """
        :param str uri: Specific uri to the registry, e.g. '"https://registry-1.docker.io"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Specific uri to the registry, e.g. '"https://registry-1.docker.io"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigMavenRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult'],
                 public_repository: str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryArgs'] custom_repositories: Settings for a remote repository with a custom uri.
        :param str public_repository: Address of the remote repository. Default value: "MAVEN_CENTRAL" Possible values: ["MAVEN_CENTRAL"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult']:
        """
        Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> str:
        """
        Address of the remote repository. Default value: "MAVEN_CENTRAL" Possible values: ["MAVEN_CENTRAL"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigMavenRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: str):
        """
        :param str uri: Specific uri to the registry, e.g. '"https://repo.maven.apache.org/maven2"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Specific uri to the registry, e.g. '"https://repo.maven.apache.org/maven2"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigNpmRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult'],
                 public_repository: str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryArgs'] custom_repositories: Settings for a remote repository with a custom uri.
        :param str public_repository: Address of the remote repository. Default value: "NPMJS" Possible values: ["NPMJS"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult']:
        """
        Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> str:
        """
        Address of the remote repository. Default value: "NPMJS" Possible values: ["NPMJS"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigNpmRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: str):
        """
        :param str uri: Specific uri to the registry, e.g. '"https://registry.npmjs.org"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Specific uri to the registry, e.g. '"https://registry.npmjs.org"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigPythonRepositoryResult(dict):
    def __init__(__self__, *,
                 custom_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult'],
                 public_repository: str):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryArgs'] custom_repositories: Settings for a remote repository with a custom uri.
        :param str public_repository: Address of the remote repository. Default value: "PYPI" Possible values: ["PYPI"]
        """
        pulumi.set(__self__, "custom_repositories", custom_repositories)
        pulumi.set(__self__, "public_repository", public_repository)

    @property
    @pulumi.getter(name="customRepositories")
    def custom_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult']:
        """
        Settings for a remote repository with a custom uri.
        """
        return pulumi.get(self, "custom_repositories")

    @property
    @pulumi.getter(name="publicRepository")
    def public_repository(self) -> str:
        """
        Address of the remote repository. Default value: "PYPI" Possible values: ["PYPI"]
        """
        return pulumi.get(self, "public_repository")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigPythonRepositoryCustomRepositoryResult(dict):
    def __init__(__self__, *,
                 uri: str):
        """
        :param str uri: Specific uri to the registry, e.g. '"https://pypi.io"'
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Specific uri to the registry, e.g. '"https://pypi.io"'
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigUpstreamCredentialResult(dict):
    def __init__(__self__, *,
                 username_password_credentials: Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialArgs'] username_password_credentials: Use username and password to access the remote repository.
        """
        pulumi.set(__self__, "username_password_credentials", username_password_credentials)

    @property
    @pulumi.getter(name="usernamePasswordCredentials")
    def username_password_credentials(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult']:
        """
        Use username and password to access the remote repository.
        """
        return pulumi.get(self, "username_password_credentials")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigUpstreamCredentialUsernamePasswordCredentialResult(dict):
    def __init__(__self__, *,
                 password_secret_version: str,
                 username: str):
        """
        :param str password_secret_version: The Secret Manager key version that holds the password to access the
               remote repository. Must be in the format of
               'projects/{project}/secrets/{secret}/versions/{version}'.
        :param str username: The username to access the remote repository.
        """
        pulumi.set(__self__, "password_secret_version", password_secret_version)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> str:
        """
        The Secret Manager key version that holds the password to access the
        remote repository. Must be in the format of
        'projects/{project}/secrets/{secret}/versions/{version}'.
        """
        return pulumi.get(self, "password_secret_version")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to access the remote repository.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigYumRepositoryResult(dict):
    def __init__(__self__, *,
                 public_repositories: Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult']):
        """
        :param Sequence['GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryArgs'] public_repositories: One of the publicly available Yum repositories supported by Artifact Registry.
        """
        pulumi.set(__self__, "public_repositories", public_repositories)

    @property
    @pulumi.getter(name="publicRepositories")
    def public_repositories(self) -> Sequence['outputs.GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult']:
        """
        One of the publicly available Yum repositories supported by Artifact Registry.
        """
        return pulumi.get(self, "public_repositories")


@pulumi.output_type
class GetRepositoryRemoteRepositoryConfigYumRepositoryPublicRepositoryResult(dict):
    def __init__(__self__, *,
                 repository_base: str,
                 repository_path: str):
        """
        :param str repository_base: A common public repository base for Yum. Possible values: ["CENTOS", "CENTOS_DEBUG", "CENTOS_VAULT", "CENTOS_STREAM", "ROCKY", "EPEL"]
        :param str repository_path: Specific repository from the base, e.g. '"pub/rocky/9/BaseOS/x86_64/os"'
        """
        pulumi.set(__self__, "repository_base", repository_base)
        pulumi.set(__self__, "repository_path", repository_path)

    @property
    @pulumi.getter(name="repositoryBase")
    def repository_base(self) -> str:
        """
        A common public repository base for Yum. Possible values: ["CENTOS", "CENTOS_DEBUG", "CENTOS_VAULT", "CENTOS_STREAM", "ROCKY", "EPEL"]
        """
        return pulumi.get(self, "repository_base")

    @property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> str:
        """
        Specific repository from the base, e.g. '"pub/rocky/9/BaseOS/x86_64/os"'
        """
        return pulumi.get(self, "repository_path")


@pulumi.output_type
class GetRepositoryVirtualRepositoryConfigResult(dict):
    def __init__(__self__, *,
                 upstream_policies: Sequence['outputs.GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult']):
        """
        :param Sequence['GetRepositoryVirtualRepositoryConfigUpstreamPolicyArgs'] upstream_policies: Policies that configure the upstream artifacts distributed by the Virtual
               Repository. Upstream policies cannot be set on a standard repository.
        """
        pulumi.set(__self__, "upstream_policies", upstream_policies)

    @property
    @pulumi.getter(name="upstreamPolicies")
    def upstream_policies(self) -> Sequence['outputs.GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult']:
        """
        Policies that configure the upstream artifacts distributed by the Virtual
        Repository. Upstream policies cannot be set on a standard repository.
        """
        return pulumi.get(self, "upstream_policies")


@pulumi.output_type
class GetRepositoryVirtualRepositoryConfigUpstreamPolicyResult(dict):
    def __init__(__self__, *,
                 id: str,
                 priority: int,
                 repository: str):
        """
        :param str id: The user-provided ID of the upstream policy.
        :param int priority: Entries with a greater priority value take precedence in the pull order.
        :param str repository: A reference to the repository resource, for example:
               "projects/p1/locations/us-central1/repository/repo1".
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The user-provided ID of the upstream policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Entries with a greater priority value take precedence in the pull order.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        A reference to the repository resource, for example:
        "projects/p1/locations/us-central1/repository/repo1".
        """
        return pulumi.get(self, "repository")


