# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 format: pulumi.Input[str],
                 repository_id: pulumi.Input[str],
                 cleanup_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCleanupPolicyArgs']]]] = None,
                 cleanup_policy_dry_run: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 docker_config: Optional[pulumi.Input['RepositoryDockerConfigArgs']] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maven_config: Optional[pulumi.Input['RepositoryMavenConfigArgs']] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_repository_config: Optional[pulumi.Input['RepositoryRemoteRepositoryConfigArgs']] = None,
                 virtual_repository_config: Optional[pulumi.Input['RepositoryVirtualRepositoryConfigArgs']] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[str] format: The format of packages that are stored in the repository. Supported formats
               can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
               You can only create alpha formats if you are a member of the
               [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).
               
               
               - - -
        :param pulumi.Input[str] repository_id: The last part of the repository name, for example:
               "repo1"
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryCleanupPolicyArgs']]] cleanup_policies: Cleanup policies for this repository. Cleanup policies indicate when
               certain package versions can be automatically deleted.
               Map keys are policy IDs supplied by users during policy creation. They must
               unique within a repository and be under 128 characters in length.
               Structure is documented below.
        :param pulumi.Input[bool] cleanup_policy_dry_run: If true, the cleanup pipeline is prevented from deleting versions in this
               repository.
        :param pulumi.Input[str] description: The user-provided description of the repository.
        :param pulumi.Input['RepositoryDockerConfigArgs'] docker_config: Docker repository config contains repository level configuration for the repositories of docker type.
               Structure is documented below.
        :param pulumi.Input[str] kms_key_name: The Cloud KMS resource name of the customer managed encryption key that’s
               used to encrypt the contents of the Repository. Has the form:
               `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
               This value may not be changed after the Repository has been created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata.
               This field may contain up to 64 entries. Label keys and values may be no
               longer than 63 characters. Label keys must begin with a lowercase letter
               and may only contain lowercase letters, numeric characters, underscores,
               and dashes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The name of the location this repository is located in.
        :param pulumi.Input['RepositoryMavenConfigArgs'] maven_config: MavenRepositoryConfig is maven related repository details.
               Provides additional configuration details for repositories of the maven
               format type.
               Structure is documented below.
        :param pulumi.Input[str] mode: The mode configures the repository to serve artifacts from different sources.
               Default value is `STANDARD_REPOSITORY`.
               Possible values are: `STANDARD_REPOSITORY`, `VIRTUAL_REPOSITORY`, `REMOTE_REPOSITORY`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['RepositoryRemoteRepositoryConfigArgs'] remote_repository_config: Configuration specific for a Remote Repository.
               Structure is documented below.
        :param pulumi.Input['RepositoryVirtualRepositoryConfigArgs'] virtual_repository_config: Configuration specific for a Virtual Repository.
               Structure is documented below.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "repository_id", repository_id)
        if cleanup_policies is not None:
            pulumi.set(__self__, "cleanup_policies", cleanup_policies)
        if cleanup_policy_dry_run is not None:
            pulumi.set(__self__, "cleanup_policy_dry_run", cleanup_policy_dry_run)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if docker_config is not None:
            pulumi.set(__self__, "docker_config", docker_config)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maven_config is not None:
            pulumi.set(__self__, "maven_config", maven_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if remote_repository_config is not None:
            pulumi.set(__self__, "remote_repository_config", remote_repository_config)
        if virtual_repository_config is not None:
            pulumi.set(__self__, "virtual_repository_config", virtual_repository_config)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[str]:
        """
        The format of packages that are stored in the repository. Supported formats
        can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
        You can only create alpha formats if you are a member of the
        [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).


        - - -
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[str]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[str]:
        """
        The last part of the repository name, for example:
        "repo1"
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="cleanupPolicies")
    def cleanup_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCleanupPolicyArgs']]]]:
        """
        Cleanup policies for this repository. Cleanup policies indicate when
        certain package versions can be automatically deleted.
        Map keys are policy IDs supplied by users during policy creation. They must
        unique within a repository and be under 128 characters in length.
        Structure is documented below.
        """
        return pulumi.get(self, "cleanup_policies")

    @cleanup_policies.setter
    def cleanup_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCleanupPolicyArgs']]]]):
        pulumi.set(self, "cleanup_policies", value)

    @property
    @pulumi.getter(name="cleanupPolicyDryRun")
    def cleanup_policy_dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the cleanup pipeline is prevented from deleting versions in this
        repository.
        """
        return pulumi.get(self, "cleanup_policy_dry_run")

    @cleanup_policy_dry_run.setter
    def cleanup_policy_dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cleanup_policy_dry_run", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The user-provided description of the repository.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dockerConfig")
    def docker_config(self) -> Optional[pulumi.Input['RepositoryDockerConfigArgs']]:
        """
        Docker repository config contains repository level configuration for the repositories of docker type.
        Structure is documented below.
        """
        return pulumi.get(self, "docker_config")

    @docker_config.setter
    def docker_config(self, value: Optional[pulumi.Input['RepositoryDockerConfigArgs']]):
        pulumi.set(self, "docker_config", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud KMS resource name of the customer managed encryption key that’s
        used to encrypt the contents of the Repository. Has the form:
        `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
        This value may not be changed after the Repository has been created.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels with user-defined metadata.
        This field may contain up to 64 entries. Label keys and values may be no
        longer than 63 characters. Label keys must begin with a lowercase letter
        and may only contain lowercase letters, numeric characters, underscores,
        and dashes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the location this repository is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mavenConfig")
    def maven_config(self) -> Optional[pulumi.Input['RepositoryMavenConfigArgs']]:
        """
        MavenRepositoryConfig is maven related repository details.
        Provides additional configuration details for repositories of the maven
        format type.
        Structure is documented below.
        """
        return pulumi.get(self, "maven_config")

    @maven_config.setter
    def maven_config(self, value: Optional[pulumi.Input['RepositoryMavenConfigArgs']]):
        pulumi.set(self, "maven_config", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode configures the repository to serve artifacts from different sources.
        Default value is `STANDARD_REPOSITORY`.
        Possible values are: `STANDARD_REPOSITORY`, `VIRTUAL_REPOSITORY`, `REMOTE_REPOSITORY`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="remoteRepositoryConfig")
    def remote_repository_config(self) -> Optional[pulumi.Input['RepositoryRemoteRepositoryConfigArgs']]:
        """
        Configuration specific for a Remote Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "remote_repository_config")

    @remote_repository_config.setter
    def remote_repository_config(self, value: Optional[pulumi.Input['RepositoryRemoteRepositoryConfigArgs']]):
        pulumi.set(self, "remote_repository_config", value)

    @property
    @pulumi.getter(name="virtualRepositoryConfig")
    def virtual_repository_config(self) -> Optional[pulumi.Input['RepositoryVirtualRepositoryConfigArgs']]:
        """
        Configuration specific for a Virtual Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_repository_config")

    @virtual_repository_config.setter
    def virtual_repository_config(self, value: Optional[pulumi.Input['RepositoryVirtualRepositoryConfigArgs']]):
        pulumi.set(self, "virtual_repository_config", value)


@pulumi.input_type
class _RepositoryState:
    def __init__(__self__, *,
                 cleanup_policies: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCleanupPolicyArgs']]]] = None,
                 cleanup_policy_dry_run: Optional[pulumi.Input[bool]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 docker_config: Optional[pulumi.Input['RepositoryDockerConfigArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maven_config: Optional[pulumi.Input['RepositoryMavenConfigArgs']] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 remote_repository_config: Optional[pulumi.Input['RepositoryRemoteRepositoryConfigArgs']] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 virtual_repository_config: Optional[pulumi.Input['RepositoryVirtualRepositoryConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Repository resources.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryCleanupPolicyArgs']]] cleanup_policies: Cleanup policies for this repository. Cleanup policies indicate when
               certain package versions can be automatically deleted.
               Map keys are policy IDs supplied by users during policy creation. They must
               unique within a repository and be under 128 characters in length.
               Structure is documented below.
        :param pulumi.Input[bool] cleanup_policy_dry_run: If true, the cleanup pipeline is prevented from deleting versions in this
               repository.
        :param pulumi.Input[str] create_time: The time when the repository was created.
        :param pulumi.Input[str] description: The user-provided description of the repository.
        :param pulumi.Input['RepositoryDockerConfigArgs'] docker_config: Docker repository config contains repository level configuration for the repositories of docker type.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] format: The format of packages that are stored in the repository. Supported formats
               can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
               You can only create alpha formats if you are a member of the
               [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).
               
               
               - - -
        :param pulumi.Input[str] kms_key_name: The Cloud KMS resource name of the customer managed encryption key that’s
               used to encrypt the contents of the Repository. Has the form:
               `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
               This value may not be changed after the Repository has been created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata.
               This field may contain up to 64 entries. Label keys and values may be no
               longer than 63 characters. Label keys must begin with a lowercase letter
               and may only contain lowercase letters, numeric characters, underscores,
               and dashes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The name of the location this repository is located in.
        :param pulumi.Input['RepositoryMavenConfigArgs'] maven_config: MavenRepositoryConfig is maven related repository details.
               Provides additional configuration details for repositories of the maven
               format type.
               Structure is documented below.
        :param pulumi.Input[str] mode: The mode configures the repository to serve artifacts from different sources.
               Default value is `STANDARD_REPOSITORY`.
               Possible values are: `STANDARD_REPOSITORY`, `VIRTUAL_REPOSITORY`, `REMOTE_REPOSITORY`.
        :param pulumi.Input[str] name: The name of the repository, for example:
               "repo1"
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['RepositoryRemoteRepositoryConfigArgs'] remote_repository_config: Configuration specific for a Remote Repository.
               Structure is documented below.
        :param pulumi.Input[str] repository_id: The last part of the repository name, for example:
               "repo1"
        :param pulumi.Input[str] update_time: The time when the repository was last updated.
        :param pulumi.Input['RepositoryVirtualRepositoryConfigArgs'] virtual_repository_config: Configuration specific for a Virtual Repository.
               Structure is documented below.
        """
        if cleanup_policies is not None:
            pulumi.set(__self__, "cleanup_policies", cleanup_policies)
        if cleanup_policy_dry_run is not None:
            pulumi.set(__self__, "cleanup_policy_dry_run", cleanup_policy_dry_run)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if docker_config is not None:
            pulumi.set(__self__, "docker_config", docker_config)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maven_config is not None:
            pulumi.set(__self__, "maven_config", maven_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if remote_repository_config is not None:
            pulumi.set(__self__, "remote_repository_config", remote_repository_config)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if virtual_repository_config is not None:
            pulumi.set(__self__, "virtual_repository_config", virtual_repository_config)

    @property
    @pulumi.getter(name="cleanupPolicies")
    def cleanup_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCleanupPolicyArgs']]]]:
        """
        Cleanup policies for this repository. Cleanup policies indicate when
        certain package versions can be automatically deleted.
        Map keys are policy IDs supplied by users during policy creation. They must
        unique within a repository and be under 128 characters in length.
        Structure is documented below.
        """
        return pulumi.get(self, "cleanup_policies")

    @cleanup_policies.setter
    def cleanup_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryCleanupPolicyArgs']]]]):
        pulumi.set(self, "cleanup_policies", value)

    @property
    @pulumi.getter(name="cleanupPolicyDryRun")
    def cleanup_policy_dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the cleanup pipeline is prevented from deleting versions in this
        repository.
        """
        return pulumi.get(self, "cleanup_policy_dry_run")

    @cleanup_policy_dry_run.setter
    def cleanup_policy_dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cleanup_policy_dry_run", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the repository was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The user-provided description of the repository.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dockerConfig")
    def docker_config(self) -> Optional[pulumi.Input['RepositoryDockerConfigArgs']]:
        """
        Docker repository config contains repository level configuration for the repositories of docker type.
        Structure is documented below.
        """
        return pulumi.get(self, "docker_config")

    @docker_config.setter
    def docker_config(self, value: Optional[pulumi.Input['RepositoryDockerConfigArgs']]):
        pulumi.set(self, "docker_config", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of packages that are stored in the repository. Supported formats
        can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
        You can only create alpha formats if you are a member of the
        [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).


        - - -
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud KMS resource name of the customer managed encryption key that’s
        used to encrypt the contents of the Repository. Has the form:
        `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
        This value may not be changed after the Repository has been created.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels with user-defined metadata.
        This field may contain up to 64 entries. Label keys and values may be no
        longer than 63 characters. Label keys must begin with a lowercase letter
        and may only contain lowercase letters, numeric characters, underscores,
        and dashes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the location this repository is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="mavenConfig")
    def maven_config(self) -> Optional[pulumi.Input['RepositoryMavenConfigArgs']]:
        """
        MavenRepositoryConfig is maven related repository details.
        Provides additional configuration details for repositories of the maven
        format type.
        Structure is documented below.
        """
        return pulumi.get(self, "maven_config")

    @maven_config.setter
    def maven_config(self, value: Optional[pulumi.Input['RepositoryMavenConfigArgs']]):
        pulumi.set(self, "maven_config", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode configures the repository to serve artifacts from different sources.
        Default value is `STANDARD_REPOSITORY`.
        Possible values are: `STANDARD_REPOSITORY`, `VIRTUAL_REPOSITORY`, `REMOTE_REPOSITORY`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repository, for example:
        "repo1"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="remoteRepositoryConfig")
    def remote_repository_config(self) -> Optional[pulumi.Input['RepositoryRemoteRepositoryConfigArgs']]:
        """
        Configuration specific for a Remote Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "remote_repository_config")

    @remote_repository_config.setter
    def remote_repository_config(self, value: Optional[pulumi.Input['RepositoryRemoteRepositoryConfigArgs']]):
        pulumi.set(self, "remote_repository_config", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[str]]:
        """
        The last part of the repository name, for example:
        "repo1"
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the repository was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="virtualRepositoryConfig")
    def virtual_repository_config(self) -> Optional[pulumi.Input['RepositoryVirtualRepositoryConfigArgs']]:
        """
        Configuration specific for a Virtual Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_repository_config")

    @virtual_repository_config.setter
    def virtual_repository_config(self, value: Optional[pulumi.Input['RepositoryVirtualRepositoryConfigArgs']]):
        pulumi.set(self, "virtual_repository_config", value)


class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCleanupPolicyArgs', 'RepositoryCleanupPolicyArgsDict']]]]] = None,
                 cleanup_policy_dry_run: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 docker_config: Optional[pulumi.Input[Union['RepositoryDockerConfigArgs', 'RepositoryDockerConfigArgsDict']]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maven_config: Optional[pulumi.Input[Union['RepositoryMavenConfigArgs', 'RepositoryMavenConfigArgsDict']]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_repository_config: Optional[pulumi.Input[Union['RepositoryRemoteRepositoryConfigArgs', 'RepositoryRemoteRepositoryConfigArgsDict']]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 virtual_repository_config: Optional[pulumi.Input[Union['RepositoryVirtualRepositoryConfigArgs', 'RepositoryVirtualRepositoryConfigArgsDict']]] = None,
                 __props__=None):
        """
        A repository for storing artifacts

        To get more information about Repository, see:

        * [API documentation](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/artifact-registry/docs/overview)

        ## Example Usage

        ### Artifact Registry Repository Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example docker repository",
            format="DOCKER")
        ```
        ### Artifact Registry Repository Docker

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example docker repository",
            format="DOCKER",
            docker_config={
                "immutable_tags": True,
            })
        ```
        ### Artifact Registry Repository Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        crypto_key = gcp.kms.CryptoKeyIAMMember("crypto_key",
            crypto_key_id="kms-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example docker repository with cmek",
            format="DOCKER",
            kms_key_name="kms-key",
            opts = pulumi.ResourceOptions(depends_on=[crypto_key]))
        ```
        ### Artifact Registry Repository Virtual

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo_upstream_1 = gcp.artifactregistry.Repository("my-repo-upstream-1",
            location="us-central1",
            repository_id="my-repository-upstream-1",
            description="example docker repository (upstream source) 1",
            format="DOCKER")
        my_repo_upstream_2 = gcp.artifactregistry.Repository("my-repo-upstream-2",
            location="us-central1",
            repository_id="my-repository-upstream-2",
            description="example docker repository (upstream source) 2",
            format="DOCKER")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example virtual docker repository",
            format="DOCKER",
            mode="VIRTUAL_REPOSITORY",
            virtual_repository_config={
                "upstream_policies": [
                    {
                        "id": "my-repository-upstream-1",
                        "repository": my_repo_upstream_1.id,
                        "priority": 20,
                    },
                    {
                        "id": "my-repository-upstream-2",
                        "repository": my_repo_upstream_2.id,
                        "priority": 10,
                    },
                ],
            })
        ```
        ### Artifact Registry Repository Remote

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example remote docker repository",
            format="DOCKER",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "docker hub",
                "docker_repository": {
                    "public_repository": "DOCKER_HUB",
                },
            })
        ```
        ### Artifact Registry Repository Remote Apt

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="debian-buster",
            description="example remote apt repository",
            format="APT",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "Debian buster remote repository",
                "apt_repository": {
                    "public_repository": {
                        "repository_base": "DEBIAN",
                        "repository_path": "debian/dists/buster",
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Yum

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="rocky-9",
            description="example remote yum repository",
            format="YUM",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "Rocky 9 remote repository",
                "yum_repository": {
                    "public_repository": {
                        "repository_base": "ROCKY",
                        "repository_path": "pub/rocky/9/BaseOS/x86_64/os",
                    },
                },
            })
        ```
        ### Artifact Registry Repository Cleanup

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example docker repository with cleanup policies",
            format="DOCKER",
            cleanup_policy_dry_run=False,
            cleanup_policies=[
                {
                    "id": "delete-prerelease",
                    "action": "DELETE",
                    "condition": {
                        "tag_state": "TAGGED",
                        "tag_prefixes": [
                            "alpha",
                            "v0",
                        ],
                        "older_than": "2592000s",
                    },
                },
                {
                    "id": "keep-tagged-release",
                    "action": "KEEP",
                    "condition": {
                        "tag_state": "TAGGED",
                        "tag_prefixes": ["release"],
                        "package_name_prefixes": [
                            "webapp",
                            "mobile",
                        ],
                    },
                },
                {
                    "id": "keep-minimum-versions",
                    "action": "KEEP",
                    "most_recent_versions": {
                        "package_name_prefixes": [
                            "webapp",
                            "mobile",
                            "sandbox",
                        ],
                        "keep_count": 5,
                    },
                },
            ])
        ```
        ### Artifact Registry Repository Remote Dockerhub Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-dockerhub-remote",
            description="example remote dockerhub repository with credentials",
            format="DOCKER",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "docker hub with custom credentials",
                "disable_upstream_validation": True,
                "docker_repository": {
                    "public_repository": "DOCKER_HUB",
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Docker Custom With Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-docker-custom-remote",
            description="example remote custom docker repository with credentials",
            format="DOCKER",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "custom docker remote with credentials",
                "disable_upstream_validation": True,
                "docker_repository": {
                    "custom_repository": {
                        "uri": "https://registry-1.docker.io",
                    },
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Maven Custom With Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-maven-custom-remote",
            description="example remote custom maven repository with credentials",
            format="MAVEN",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "custom maven remote with credentials",
                "disable_upstream_validation": True,
                "maven_repository": {
                    "custom_repository": {
                        "uri": "https://my.maven.registry",
                    },
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Npm Custom With Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-npm-custom-remote",
            description="example remote custom npm repository with credentials",
            format="NPM",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "custom npm with credentials",
                "disable_upstream_validation": True,
                "npm_repository": {
                    "custom_repository": {
                        "uri": "https://my.npm.registry",
                    },
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Python Custom With Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-python-custom-remote",
            description="example remote custom python repository with credentials",
            format="PYTHON",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "custom npm with credentials",
                "disable_upstream_validation": True,
                "python_repository": {
                    "custom_repository": {
                        "uri": "https://my.python.registry",
                    },
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```

        ## Import

        Repository can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}`

        * `{{project}}/{{location}}/{{repository_id}}`

        * `{{location}}/{{repository_id}}`

        * `{{repository_id}}`

        When using the `pulumi import` command, Repository can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:artifactregistry/repository:Repository default projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/repository:Repository default {{project}}/{{location}}/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/repository:Repository default {{location}}/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/repository:Repository default {{repository_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCleanupPolicyArgs', 'RepositoryCleanupPolicyArgsDict']]]] cleanup_policies: Cleanup policies for this repository. Cleanup policies indicate when
               certain package versions can be automatically deleted.
               Map keys are policy IDs supplied by users during policy creation. They must
               unique within a repository and be under 128 characters in length.
               Structure is documented below.
        :param pulumi.Input[bool] cleanup_policy_dry_run: If true, the cleanup pipeline is prevented from deleting versions in this
               repository.
        :param pulumi.Input[str] description: The user-provided description of the repository.
        :param pulumi.Input[Union['RepositoryDockerConfigArgs', 'RepositoryDockerConfigArgsDict']] docker_config: Docker repository config contains repository level configuration for the repositories of docker type.
               Structure is documented below.
        :param pulumi.Input[str] format: The format of packages that are stored in the repository. Supported formats
               can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
               You can only create alpha formats if you are a member of the
               [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).
               
               
               - - -
        :param pulumi.Input[str] kms_key_name: The Cloud KMS resource name of the customer managed encryption key that’s
               used to encrypt the contents of the Repository. Has the form:
               `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
               This value may not be changed after the Repository has been created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata.
               This field may contain up to 64 entries. Label keys and values may be no
               longer than 63 characters. Label keys must begin with a lowercase letter
               and may only contain lowercase letters, numeric characters, underscores,
               and dashes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The name of the location this repository is located in.
        :param pulumi.Input[Union['RepositoryMavenConfigArgs', 'RepositoryMavenConfigArgsDict']] maven_config: MavenRepositoryConfig is maven related repository details.
               Provides additional configuration details for repositories of the maven
               format type.
               Structure is documented below.
        :param pulumi.Input[str] mode: The mode configures the repository to serve artifacts from different sources.
               Default value is `STANDARD_REPOSITORY`.
               Possible values are: `STANDARD_REPOSITORY`, `VIRTUAL_REPOSITORY`, `REMOTE_REPOSITORY`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['RepositoryRemoteRepositoryConfigArgs', 'RepositoryRemoteRepositoryConfigArgsDict']] remote_repository_config: Configuration specific for a Remote Repository.
               Structure is documented below.
        :param pulumi.Input[str] repository_id: The last part of the repository name, for example:
               "repo1"
        :param pulumi.Input[Union['RepositoryVirtualRepositoryConfigArgs', 'RepositoryVirtualRepositoryConfigArgsDict']] virtual_repository_config: Configuration specific for a Virtual Repository.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A repository for storing artifacts

        To get more information about Repository, see:

        * [API documentation](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/artifact-registry/docs/overview)

        ## Example Usage

        ### Artifact Registry Repository Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example docker repository",
            format="DOCKER")
        ```
        ### Artifact Registry Repository Docker

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example docker repository",
            format="DOCKER",
            docker_config={
                "immutable_tags": True,
            })
        ```
        ### Artifact Registry Repository Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        crypto_key = gcp.kms.CryptoKeyIAMMember("crypto_key",
            crypto_key_id="kms-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example docker repository with cmek",
            format="DOCKER",
            kms_key_name="kms-key",
            opts = pulumi.ResourceOptions(depends_on=[crypto_key]))
        ```
        ### Artifact Registry Repository Virtual

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo_upstream_1 = gcp.artifactregistry.Repository("my-repo-upstream-1",
            location="us-central1",
            repository_id="my-repository-upstream-1",
            description="example docker repository (upstream source) 1",
            format="DOCKER")
        my_repo_upstream_2 = gcp.artifactregistry.Repository("my-repo-upstream-2",
            location="us-central1",
            repository_id="my-repository-upstream-2",
            description="example docker repository (upstream source) 2",
            format="DOCKER")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example virtual docker repository",
            format="DOCKER",
            mode="VIRTUAL_REPOSITORY",
            virtual_repository_config={
                "upstream_policies": [
                    {
                        "id": "my-repository-upstream-1",
                        "repository": my_repo_upstream_1.id,
                        "priority": 20,
                    },
                    {
                        "id": "my-repository-upstream-2",
                        "repository": my_repo_upstream_2.id,
                        "priority": 10,
                    },
                ],
            })
        ```
        ### Artifact Registry Repository Remote

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example remote docker repository",
            format="DOCKER",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "docker hub",
                "docker_repository": {
                    "public_repository": "DOCKER_HUB",
                },
            })
        ```
        ### Artifact Registry Repository Remote Apt

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="debian-buster",
            description="example remote apt repository",
            format="APT",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "Debian buster remote repository",
                "apt_repository": {
                    "public_repository": {
                        "repository_base": "DEBIAN",
                        "repository_path": "debian/dists/buster",
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Yum

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="rocky-9",
            description="example remote yum repository",
            format="YUM",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "Rocky 9 remote repository",
                "yum_repository": {
                    "public_repository": {
                        "repository_base": "ROCKY",
                        "repository_path": "pub/rocky/9/BaseOS/x86_64/os",
                    },
                },
            })
        ```
        ### Artifact Registry Repository Cleanup

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="my-repository",
            description="example docker repository with cleanup policies",
            format="DOCKER",
            cleanup_policy_dry_run=False,
            cleanup_policies=[
                {
                    "id": "delete-prerelease",
                    "action": "DELETE",
                    "condition": {
                        "tag_state": "TAGGED",
                        "tag_prefixes": [
                            "alpha",
                            "v0",
                        ],
                        "older_than": "2592000s",
                    },
                },
                {
                    "id": "keep-tagged-release",
                    "action": "KEEP",
                    "condition": {
                        "tag_state": "TAGGED",
                        "tag_prefixes": ["release"],
                        "package_name_prefixes": [
                            "webapp",
                            "mobile",
                        ],
                    },
                },
                {
                    "id": "keep-minimum-versions",
                    "action": "KEEP",
                    "most_recent_versions": {
                        "package_name_prefixes": [
                            "webapp",
                            "mobile",
                            "sandbox",
                        ],
                        "keep_count": 5,
                    },
                },
            ])
        ```
        ### Artifact Registry Repository Remote Dockerhub Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-dockerhub-remote",
            description="example remote dockerhub repository with credentials",
            format="DOCKER",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "docker hub with custom credentials",
                "disable_upstream_validation": True,
                "docker_repository": {
                    "public_repository": "DOCKER_HUB",
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Docker Custom With Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-docker-custom-remote",
            description="example remote custom docker repository with credentials",
            format="DOCKER",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "custom docker remote with credentials",
                "disable_upstream_validation": True,
                "docker_repository": {
                    "custom_repository": {
                        "uri": "https://registry-1.docker.io",
                    },
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Maven Custom With Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-maven-custom-remote",
            description="example remote custom maven repository with credentials",
            format="MAVEN",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "custom maven remote with credentials",
                "disable_upstream_validation": True,
                "maven_repository": {
                    "custom_repository": {
                        "uri": "https://my.maven.registry",
                    },
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Npm Custom With Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-npm-custom-remote",
            description="example remote custom npm repository with credentials",
            format="NPM",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "custom npm with credentials",
                "disable_upstream_validation": True,
                "npm_repository": {
                    "custom_repository": {
                        "uri": "https://my.npm.registry",
                    },
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```
        ### Artifact Registry Repository Remote Python Custom With Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_remote_secret = gcp.secretmanager.Secret("example-remote-secret",
            secret_id="example-secret",
            replication={
                "auto": {},
            })
        example_remote_secret_version = gcp.secretmanager.SecretVersion("example-remote-secret_version",
            secret=example_remote_secret.id,
            secret_data="remote-password")
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=example_remote_secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:service-{project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com")
        my_repo = gcp.artifactregistry.Repository("my-repo",
            location="us-central1",
            repository_id="example-python-custom-remote",
            description="example remote custom python repository with credentials",
            format="PYTHON",
            mode="REMOTE_REPOSITORY",
            remote_repository_config={
                "description": "custom npm with credentials",
                "disable_upstream_validation": True,
                "python_repository": {
                    "custom_repository": {
                        "uri": "https://my.python.registry",
                    },
                },
                "upstream_credentials": {
                    "username_password_credentials": {
                        "username": "remote-username",
                        "password_secret_version": example_remote_secret_version.name,
                    },
                },
            })
        ```

        ## Import

        Repository can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}`

        * `{{project}}/{{location}}/{{repository_id}}`

        * `{{location}}/{{repository_id}}`

        * `{{repository_id}}`

        When using the `pulumi import` command, Repository can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:artifactregistry/repository:Repository default projects/{{project}}/locations/{{location}}/repositories/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/repository:Repository default {{project}}/{{location}}/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/repository:Repository default {{location}}/{{repository_id}}
        ```

        ```sh
        $ pulumi import gcp:artifactregistry/repository:Repository default {{repository_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCleanupPolicyArgs', 'RepositoryCleanupPolicyArgsDict']]]]] = None,
                 cleanup_policy_dry_run: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 docker_config: Optional[pulumi.Input[Union['RepositoryDockerConfigArgs', 'RepositoryDockerConfigArgsDict']]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maven_config: Optional[pulumi.Input[Union['RepositoryMavenConfigArgs', 'RepositoryMavenConfigArgsDict']]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_repository_config: Optional[pulumi.Input[Union['RepositoryRemoteRepositoryConfigArgs', 'RepositoryRemoteRepositoryConfigArgsDict']]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 virtual_repository_config: Optional[pulumi.Input[Union['RepositoryVirtualRepositoryConfigArgs', 'RepositoryVirtualRepositoryConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["cleanup_policies"] = cleanup_policies
            __props__.__dict__["cleanup_policy_dry_run"] = cleanup_policy_dry_run
            __props__.__dict__["description"] = description
            __props__.__dict__["docker_config"] = docker_config
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["maven_config"] = maven_config
            __props__.__dict__["mode"] = mode
            __props__.__dict__["project"] = project
            __props__.__dict__["remote_repository_config"] = remote_repository_config
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["virtual_repository_config"] = virtual_repository_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Repository, __self__).__init__(
            'gcp:artifactregistry/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cleanup_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCleanupPolicyArgs', 'RepositoryCleanupPolicyArgsDict']]]]] = None,
            cleanup_policy_dry_run: Optional[pulumi.Input[bool]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            docker_config: Optional[pulumi.Input[Union['RepositoryDockerConfigArgs', 'RepositoryDockerConfigArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            format: Optional[pulumi.Input[str]] = None,
            kms_key_name: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            maven_config: Optional[pulumi.Input[Union['RepositoryMavenConfigArgs', 'RepositoryMavenConfigArgsDict']]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            remote_repository_config: Optional[pulumi.Input[Union['RepositoryRemoteRepositoryConfigArgs', 'RepositoryRemoteRepositoryConfigArgsDict']]] = None,
            repository_id: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            virtual_repository_config: Optional[pulumi.Input[Union['RepositoryVirtualRepositoryConfigArgs', 'RepositoryVirtualRepositoryConfigArgsDict']]] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RepositoryCleanupPolicyArgs', 'RepositoryCleanupPolicyArgsDict']]]] cleanup_policies: Cleanup policies for this repository. Cleanup policies indicate when
               certain package versions can be automatically deleted.
               Map keys are policy IDs supplied by users during policy creation. They must
               unique within a repository and be under 128 characters in length.
               Structure is documented below.
        :param pulumi.Input[bool] cleanup_policy_dry_run: If true, the cleanup pipeline is prevented from deleting versions in this
               repository.
        :param pulumi.Input[str] create_time: The time when the repository was created.
        :param pulumi.Input[str] description: The user-provided description of the repository.
        :param pulumi.Input[Union['RepositoryDockerConfigArgs', 'RepositoryDockerConfigArgsDict']] docker_config: Docker repository config contains repository level configuration for the repositories of docker type.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] format: The format of packages that are stored in the repository. Supported formats
               can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
               You can only create alpha formats if you are a member of the
               [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).
               
               
               - - -
        :param pulumi.Input[str] kms_key_name: The Cloud KMS resource name of the customer managed encryption key that’s
               used to encrypt the contents of the Repository. Has the form:
               `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
               This value may not be changed after the Repository has been created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user-defined metadata.
               This field may contain up to 64 entries. Label keys and values may be no
               longer than 63 characters. Label keys must begin with a lowercase letter
               and may only contain lowercase letters, numeric characters, underscores,
               and dashes.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The name of the location this repository is located in.
        :param pulumi.Input[Union['RepositoryMavenConfigArgs', 'RepositoryMavenConfigArgsDict']] maven_config: MavenRepositoryConfig is maven related repository details.
               Provides additional configuration details for repositories of the maven
               format type.
               Structure is documented below.
        :param pulumi.Input[str] mode: The mode configures the repository to serve artifacts from different sources.
               Default value is `STANDARD_REPOSITORY`.
               Possible values are: `STANDARD_REPOSITORY`, `VIRTUAL_REPOSITORY`, `REMOTE_REPOSITORY`.
        :param pulumi.Input[str] name: The name of the repository, for example:
               "repo1"
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['RepositoryRemoteRepositoryConfigArgs', 'RepositoryRemoteRepositoryConfigArgsDict']] remote_repository_config: Configuration specific for a Remote Repository.
               Structure is documented below.
        :param pulumi.Input[str] repository_id: The last part of the repository name, for example:
               "repo1"
        :param pulumi.Input[str] update_time: The time when the repository was last updated.
        :param pulumi.Input[Union['RepositoryVirtualRepositoryConfigArgs', 'RepositoryVirtualRepositoryConfigArgsDict']] virtual_repository_config: Configuration specific for a Virtual Repository.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryState.__new__(_RepositoryState)

        __props__.__dict__["cleanup_policies"] = cleanup_policies
        __props__.__dict__["cleanup_policy_dry_run"] = cleanup_policy_dry_run
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["docker_config"] = docker_config
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["format"] = format
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["maven_config"] = maven_config
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["remote_repository_config"] = remote_repository_config
        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["virtual_repository_config"] = virtual_repository_config
        return Repository(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cleanupPolicies")
    def cleanup_policies(self) -> pulumi.Output[Optional[Sequence['outputs.RepositoryCleanupPolicy']]]:
        """
        Cleanup policies for this repository. Cleanup policies indicate when
        certain package versions can be automatically deleted.
        Map keys are policy IDs supplied by users during policy creation. They must
        unique within a repository and be under 128 characters in length.
        Structure is documented below.
        """
        return pulumi.get(self, "cleanup_policies")

    @property
    @pulumi.getter(name="cleanupPolicyDryRun")
    def cleanup_policy_dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, the cleanup pipeline is prevented from deleting versions in this
        repository.
        """
        return pulumi.get(self, "cleanup_policy_dry_run")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the repository was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The user-provided description of the repository.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dockerConfig")
    def docker_config(self) -> pulumi.Output[Optional['outputs.RepositoryDockerConfig']]:
        """
        Docker repository config contains repository level configuration for the repositories of docker type.
        Structure is documented below.
        """
        return pulumi.get(self, "docker_config")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[str]:
        """
        The format of packages that are stored in the repository. Supported formats
        can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
        You can only create alpha formats if you are a member of the
        [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).


        - - -
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[str]]:
        """
        The Cloud KMS resource name of the customer managed encryption key that’s
        used to encrypt the contents of the Repository. Has the form:
        `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
        This value may not be changed after the Repository has been created.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels with user-defined metadata.
        This field may contain up to 64 entries. Label keys and values may be no
        longer than 63 characters. Label keys must begin with a lowercase letter
        and may only contain lowercase letters, numeric characters, underscores,
        and dashes.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The name of the location this repository is located in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mavenConfig")
    def maven_config(self) -> pulumi.Output[Optional['outputs.RepositoryMavenConfig']]:
        """
        MavenRepositoryConfig is maven related repository details.
        Provides additional configuration details for repositories of the maven
        format type.
        Structure is documented below.
        """
        return pulumi.get(self, "maven_config")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        The mode configures the repository to serve artifacts from different sources.
        Default value is `STANDARD_REPOSITORY`.
        Possible values are: `STANDARD_REPOSITORY`, `VIRTUAL_REPOSITORY`, `REMOTE_REPOSITORY`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the repository, for example:
        "repo1"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="remoteRepositoryConfig")
    def remote_repository_config(self) -> pulumi.Output[Optional['outputs.RepositoryRemoteRepositoryConfig']]:
        """
        Configuration specific for a Remote Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "remote_repository_config")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[str]:
        """
        The last part of the repository name, for example:
        "repo1"
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time when the repository was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="virtualRepositoryConfig")
    def virtual_repository_config(self) -> pulumi.Output[Optional['outputs.RepositoryVirtualRepositoryConfig']]:
        """
        Configuration specific for a Virtual Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "virtual_repository_config")

