# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseHiveOptions',
    'TableHiveOptions',
    'TableHiveOptionsStorageDescriptor',
]

@pulumi.output_type
class DatabaseHiveOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationUri":
            suggest = "location_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseHiveOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseHiveOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseHiveOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location_uri: Optional[str] = None,
                 parameters: Optional[Mapping[str, str]] = None):
        """
        :param str location_uri: Cloud Storage folder URI where the database data is stored, starting with "gs://".
        :param Mapping[str, str] parameters: Stores user supplied Hive database parameters. An object containing a
               list of"key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               - - -
        """
        if location_uri is not None:
            pulumi.set(__self__, "location_uri", location_uri)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[str]:
        """
        Cloud Storage folder URI where the database data is stored, starting with "gs://".
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Stores user supplied Hive database parameters. An object containing a
        list of"key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        - - -
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class TableHiveOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageDescriptor":
            suggest = "storage_descriptor"
        elif key == "tableType":
            suggest = "table_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableHiveOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableHiveOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableHiveOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameters: Optional[Mapping[str, str]] = None,
                 storage_descriptor: Optional['outputs.TableHiveOptionsStorageDescriptor'] = None,
                 table_type: Optional[str] = None):
        """
        :param Mapping[str, str] parameters: Stores user supplied Hive table parameters. An object containing a
               list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param 'TableHiveOptionsStorageDescriptorArgs' storage_descriptor: Stores physical storage information on the data.
               Structure is documented below.
        :param str table_type: Hive table type. For example, MANAGED_TABLE, EXTERNAL_TABLE.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if storage_descriptor is not None:
            pulumi.set(__self__, "storage_descriptor", storage_descriptor)
        if table_type is not None:
            pulumi.set(__self__, "table_type", table_type)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Stores user supplied Hive table parameters. An object containing a
        list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="storageDescriptor")
    def storage_descriptor(self) -> Optional['outputs.TableHiveOptionsStorageDescriptor']:
        """
        Stores physical storage information on the data.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_descriptor")

    @property
    @pulumi.getter(name="tableType")
    def table_type(self) -> Optional[str]:
        """
        Hive table type. For example, MANAGED_TABLE, EXTERNAL_TABLE.
        """
        return pulumi.get(self, "table_type")


@pulumi.output_type
class TableHiveOptionsStorageDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputFormat":
            suggest = "input_format"
        elif key == "locationUri":
            suggest = "location_uri"
        elif key == "outputFormat":
            suggest = "output_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableHiveOptionsStorageDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableHiveOptionsStorageDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableHiveOptionsStorageDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_format: Optional[str] = None,
                 location_uri: Optional[str] = None,
                 output_format: Optional[str] = None):
        """
        :param str input_format: The fully qualified Java class name of the input format.
        :param str location_uri: Cloud Storage folder URI where the table data is stored, starting with "gs://".
        :param str output_format: The fully qualified Java class name of the output format.
        """
        if input_format is not None:
            pulumi.set(__self__, "input_format", input_format)
        if location_uri is not None:
            pulumi.set(__self__, "location_uri", location_uri)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> Optional[str]:
        """
        The fully qualified Java class name of the input format.
        """
        return pulumi.get(self, "input_format")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[str]:
        """
        Cloud Storage folder URI where the table data is stored, starting with "gs://".
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[str]:
        """
        The fully qualified Java class name of the output format.
        """
        return pulumi.get(self, "output_format")


