# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppProfileDataBoostIsolationReadOnly',
    'AppProfileSingleClusterRouting',
    'AppProfileStandardIsolation',
    'BiReservationPreferredTable',
    'ConnectionAws',
    'ConnectionAwsAccessRole',
    'ConnectionAzure',
    'ConnectionCloudResource',
    'ConnectionCloudSpanner',
    'ConnectionCloudSql',
    'ConnectionCloudSqlCredential',
    'ConnectionIamBindingCondition',
    'ConnectionIamMemberCondition',
    'ConnectionSpark',
    'ConnectionSparkMetastoreServiceConfig',
    'ConnectionSparkSparkHistoryServerConfig',
    'DataTransferConfigEmailPreferences',
    'DataTransferConfigEncryptionConfiguration',
    'DataTransferConfigScheduleOptions',
    'DataTransferConfigSensitiveParams',
    'DatasetAccess',
    'DatasetAccessAuthorizedDataset',
    'DatasetAccessAuthorizedDatasetDataset',
    'DatasetAccessDataset',
    'DatasetAccessDatasetDataset',
    'DatasetAccessRoutine',
    'DatasetAccessView',
    'DatasetDefaultEncryptionConfiguration',
    'DatasetExternalDatasetReference',
    'DatasetIamBindingCondition',
    'DatasetIamMemberCondition',
    'IamBindingCondition',
    'IamMemberCondition',
    'JobCopy',
    'JobCopyDestinationEncryptionConfiguration',
    'JobCopyDestinationTable',
    'JobCopySourceTable',
    'JobExtract',
    'JobExtractSourceModel',
    'JobExtractSourceTable',
    'JobLoad',
    'JobLoadDestinationEncryptionConfiguration',
    'JobLoadDestinationTable',
    'JobLoadParquetOptions',
    'JobLoadTimePartitioning',
    'JobQuery',
    'JobQueryDefaultDataset',
    'JobQueryDestinationEncryptionConfiguration',
    'JobQueryDestinationTable',
    'JobQueryScriptOptions',
    'JobQueryUserDefinedFunctionResource',
    'JobStatus',
    'JobStatusError',
    'JobStatusErrorResult',
    'ReservationAutoscale',
    'RoutineArgument',
    'RoutineRemoteFunctionOptions',
    'RoutineSparkOptions',
    'TableBiglakeConfiguration',
    'TableEncryptionConfiguration',
    'TableExternalDataConfiguration',
    'TableExternalDataConfigurationAvroOptions',
    'TableExternalDataConfigurationBigtableOptions',
    'TableExternalDataConfigurationBigtableOptionsColumnFamily',
    'TableExternalDataConfigurationBigtableOptionsColumnFamilyColumn',
    'TableExternalDataConfigurationCsvOptions',
    'TableExternalDataConfigurationGoogleSheetsOptions',
    'TableExternalDataConfigurationHivePartitioningOptions',
    'TableExternalDataConfigurationJsonOptions',
    'TableExternalDataConfigurationParquetOptions',
    'TableMaterializedView',
    'TableRangePartitioning',
    'TableRangePartitioningRange',
    'TableTableConstraints',
    'TableTableConstraintsForeignKey',
    'TableTableConstraintsForeignKeyColumnReferences',
    'TableTableConstraintsForeignKeyReferencedTable',
    'TableTableConstraintsPrimaryKey',
    'TableTableReplicationInfo',
    'TableTimePartitioning',
    'TableView',
    'GetDatasetAccessResult',
    'GetDatasetAccessDatasetResult',
    'GetDatasetAccessDatasetDatasetResult',
    'GetDatasetAccessRoutineResult',
    'GetDatasetAccessViewResult',
    'GetDatasetDefaultEncryptionConfigurationResult',
    'GetDatasetExternalDatasetReferenceResult',
    'GetTablesTableResult',
]

@pulumi.output_type
class AppProfileDataBoostIsolationReadOnly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeBillingOwner":
            suggest = "compute_billing_owner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppProfileDataBoostIsolationReadOnly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppProfileDataBoostIsolationReadOnly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppProfileDataBoostIsolationReadOnly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_billing_owner: str):
        """
        :param str compute_billing_owner: The Compute Billing Owner for this Data Boost App Profile.
               Possible values are: `HOST_PAYS`.
        """
        pulumi.set(__self__, "compute_billing_owner", compute_billing_owner)

    @property
    @pulumi.getter(name="computeBillingOwner")
    def compute_billing_owner(self) -> str:
        """
        The Compute Billing Owner for this Data Boost App Profile.
        Possible values are: `HOST_PAYS`.
        """
        return pulumi.get(self, "compute_billing_owner")


@pulumi.output_type
class AppProfileSingleClusterRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "allowTransactionalWrites":
            suggest = "allow_transactional_writes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppProfileSingleClusterRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppProfileSingleClusterRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppProfileSingleClusterRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: str,
                 allow_transactional_writes: Optional[bool] = None):
        """
        :param str cluster_id: The cluster to which read/write requests should be routed.
        :param bool allow_transactional_writes: If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
               It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if allow_transactional_writes is not None:
            pulumi.set(__self__, "allow_transactional_writes", allow_transactional_writes)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The cluster to which read/write requests should be routed.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="allowTransactionalWrites")
    def allow_transactional_writes(self) -> Optional[bool]:
        """
        If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
        It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        return pulumi.get(self, "allow_transactional_writes")


@pulumi.output_type
class AppProfileStandardIsolation(dict):
    def __init__(__self__, *,
                 priority: str):
        """
        :param str priority: The priority of requests sent using this app profile.
               Possible values are: `PRIORITY_LOW`, `PRIORITY_MEDIUM`, `PRIORITY_HIGH`.
        """
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def priority(self) -> str:
        """
        The priority of requests sent using this app profile.
        Possible values are: `PRIORITY_LOW`, `PRIORITY_MEDIUM`, `PRIORITY_HIGH`.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class BiReservationPreferredTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BiReservationPreferredTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BiReservationPreferredTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BiReservationPreferredTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: Optional[str] = None,
                 project_id: Optional[str] = None,
                 table_id: Optional[str] = None):
        """
        :param str dataset_id: The ID of the dataset in the above project.
        :param str project_id: The assigned project ID of the project.
        :param str table_id: The ID of the table in the above dataset.
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        The ID of the dataset in the above project.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The assigned project ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[str]:
        """
        The ID of the table in the above dataset.
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class ConnectionAws(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessRole":
            suggest = "access_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAws. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAws.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAws.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_role: 'outputs.ConnectionAwsAccessRole'):
        """
        :param 'ConnectionAwsAccessRoleArgs' access_role: Authentication using Google owned service account to assume into customer's AWS IAM Role.
               Structure is documented below.
        """
        pulumi.set(__self__, "access_role", access_role)

    @property
    @pulumi.getter(name="accessRole")
    def access_role(self) -> 'outputs.ConnectionAwsAccessRole':
        """
        Authentication using Google owned service account to assume into customer's AWS IAM Role.
        Structure is documented below.
        """
        return pulumi.get(self, "access_role")


@pulumi.output_type
class ConnectionAwsAccessRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iamRoleId":
            suggest = "iam_role_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAwsAccessRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAwsAccessRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAwsAccessRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iam_role_id: str,
                 identity: Optional[str] = None):
        """
        :param str iam_role_id: The user’s AWS IAM Role that trusts the Google-owned AWS IAM user Connection.
        :param str identity: (Output)
               A unique Google-owned and Google-generated identity for the Connection. This identity will be used to access the user's AWS IAM Role.
        """
        pulumi.set(__self__, "iam_role_id", iam_role_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="iamRoleId")
    def iam_role_id(self) -> str:
        """
        The user’s AWS IAM Role that trusts the Google-owned AWS IAM user Connection.
        """
        return pulumi.get(self, "iam_role_id")

    @property
    @pulumi.getter
    def identity(self) -> Optional[str]:
        """
        (Output)
        A unique Google-owned and Google-generated identity for the Connection. This identity will be used to access the user's AWS IAM Role.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class ConnectionAzure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerTenantId":
            suggest = "customer_tenant_id"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "federatedApplicationClientId":
            suggest = "federated_application_client_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "redirectUri":
            suggest = "redirect_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAzure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAzure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAzure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_tenant_id: str,
                 application: Optional[str] = None,
                 client_id: Optional[str] = None,
                 federated_application_client_id: Optional[str] = None,
                 identity: Optional[str] = None,
                 object_id: Optional[str] = None,
                 redirect_uri: Optional[str] = None):
        """
        :param str customer_tenant_id: The id of customer's directory that host the data.
        :param str application: (Output)
               The name of the Azure Active Directory Application.
        :param str client_id: (Output)
               The client id of the Azure Active Directory Application.
        :param str federated_application_client_id: The Azure Application (client) ID where the federated credentials will be hosted.
        :param str identity: (Output)
               A unique Google-owned and Google-generated identity for the Connection. This identity will be used to access the user's Azure Active Directory Application.
        :param str object_id: (Output)
               The object id of the Azure Active Directory Application.
        :param str redirect_uri: (Output)
               The URL user will be redirected to after granting consent during connection setup.
        """
        pulumi.set(__self__, "customer_tenant_id", customer_tenant_id)
        if application is not None:
            pulumi.set(__self__, "application", application)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if federated_application_client_id is not None:
            pulumi.set(__self__, "federated_application_client_id", federated_application_client_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if redirect_uri is not None:
            pulumi.set(__self__, "redirect_uri", redirect_uri)

    @property
    @pulumi.getter(name="customerTenantId")
    def customer_tenant_id(self) -> str:
        """
        The id of customer's directory that host the data.
        """
        return pulumi.get(self, "customer_tenant_id")

    @property
    @pulumi.getter
    def application(self) -> Optional[str]:
        """
        (Output)
        The name of the Azure Active Directory Application.
        """
        return pulumi.get(self, "application")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        (Output)
        The client id of the Azure Active Directory Application.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="federatedApplicationClientId")
    def federated_application_client_id(self) -> Optional[str]:
        """
        The Azure Application (client) ID where the federated credentials will be hosted.
        """
        return pulumi.get(self, "federated_application_client_id")

    @property
    @pulumi.getter
    def identity(self) -> Optional[str]:
        """
        (Output)
        A unique Google-owned and Google-generated identity for the Connection. This identity will be used to access the user's Azure Active Directory Application.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        (Output)
        The object id of the Azure Active Directory Application.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> Optional[str]:
        """
        (Output)
        The URL user will be redirected to after granting consent during connection setup.
        """
        return pulumi.get(self, "redirect_uri")


@pulumi.output_type
class ConnectionCloudResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionCloudResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionCloudResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionCloudResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account_id: Optional[str] = None):
        """
        :param str service_account_id: (Output)
               The account ID of the service created for the purpose of this connection.
        """
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[str]:
        """
        (Output)
        The account ID of the service created for the purpose of this connection.
        """
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class ConnectionCloudSpanner(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseRole":
            suggest = "database_role"
        elif key == "maxParallelism":
            suggest = "max_parallelism"
        elif key == "useDataBoost":
            suggest = "use_data_boost"
        elif key == "useParallelism":
            suggest = "use_parallelism"
        elif key == "useServerlessAnalytics":
            suggest = "use_serverless_analytics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionCloudSpanner. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionCloudSpanner.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionCloudSpanner.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 database_role: Optional[str] = None,
                 max_parallelism: Optional[int] = None,
                 use_data_boost: Optional[bool] = None,
                 use_parallelism: Optional[bool] = None,
                 use_serverless_analytics: Optional[bool] = None):
        """
        :param str database: Cloud Spanner database in the form `project/instance/database'.
        :param str database_role: Cloud Spanner database role for fine-grained access control. The Cloud Spanner admin should have provisioned the database role with appropriate permissions, such as `SELECT` and `INSERT`. Other users should only use roles provided by their Cloud Spanner admins. The database role name must start with a letter, and can only contain letters, numbers, and underscores. For more details, see https://cloud.google.com/spanner/docs/fgac-about.
        :param int max_parallelism: Allows setting max parallelism per query when executing on Spanner independent compute resources. If unspecified, default values of parallelism are chosen that are dependent on the Cloud Spanner instance configuration. `useParallelism` and `useDataBoost` must be set when setting max parallelism.
        :param bool use_data_boost: If set, the request will be executed via Spanner independent compute resources. `use_parallelism` must be set when using data boost.
        :param bool use_parallelism: If parallelism should be used when reading from Cloud Spanner.
        :param bool use_serverless_analytics: (Optional, Deprecated)
               If the serverless analytics service should be used to read data from Cloud Spanner. `useParallelism` must be set when using serverless analytics.
               
               > **Warning:** `useServerlessAnalytics` is deprecated and will be removed in a future major release. Use `useDataBoost` instead.
        """
        pulumi.set(__self__, "database", database)
        if database_role is not None:
            pulumi.set(__self__, "database_role", database_role)
        if max_parallelism is not None:
            pulumi.set(__self__, "max_parallelism", max_parallelism)
        if use_data_boost is not None:
            pulumi.set(__self__, "use_data_boost", use_data_boost)
        if use_parallelism is not None:
            pulumi.set(__self__, "use_parallelism", use_parallelism)
        if use_serverless_analytics is not None:
            pulumi.set(__self__, "use_serverless_analytics", use_serverless_analytics)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Cloud Spanner database in the form `project/instance/database'.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="databaseRole")
    def database_role(self) -> Optional[str]:
        """
        Cloud Spanner database role for fine-grained access control. The Cloud Spanner admin should have provisioned the database role with appropriate permissions, such as `SELECT` and `INSERT`. Other users should only use roles provided by their Cloud Spanner admins. The database role name must start with a letter, and can only contain letters, numbers, and underscores. For more details, see https://cloud.google.com/spanner/docs/fgac-about.
        """
        return pulumi.get(self, "database_role")

    @property
    @pulumi.getter(name="maxParallelism")
    def max_parallelism(self) -> Optional[int]:
        """
        Allows setting max parallelism per query when executing on Spanner independent compute resources. If unspecified, default values of parallelism are chosen that are dependent on the Cloud Spanner instance configuration. `useParallelism` and `useDataBoost` must be set when setting max parallelism.
        """
        return pulumi.get(self, "max_parallelism")

    @property
    @pulumi.getter(name="useDataBoost")
    def use_data_boost(self) -> Optional[bool]:
        """
        If set, the request will be executed via Spanner independent compute resources. `use_parallelism` must be set when using data boost.
        """
        return pulumi.get(self, "use_data_boost")

    @property
    @pulumi.getter(name="useParallelism")
    def use_parallelism(self) -> Optional[bool]:
        """
        If parallelism should be used when reading from Cloud Spanner.
        """
        return pulumi.get(self, "use_parallelism")

    @property
    @pulumi.getter(name="useServerlessAnalytics")
    @_utilities.deprecated("""`useServerlessAnalytics` is deprecated and will be removed in a future major release. Use `useDataBoost` instead.""")
    def use_serverless_analytics(self) -> Optional[bool]:
        """
        (Optional, Deprecated)
        If the serverless analytics service should be used to read data from Cloud Spanner. `useParallelism` must be set when using serverless analytics.

        > **Warning:** `useServerlessAnalytics` is deprecated and will be removed in a future major release. Use `useDataBoost` instead.
        """
        return pulumi.get(self, "use_serverless_analytics")


@pulumi.output_type
class ConnectionCloudSql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionCloudSql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionCloudSql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionCloudSql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential: 'outputs.ConnectionCloudSqlCredential',
                 database: str,
                 instance_id: str,
                 type: str,
                 service_account_id: Optional[str] = None):
        """
        :param 'ConnectionCloudSqlCredentialArgs' credential: Cloud SQL properties.
               Structure is documented below.
        :param str database: Database name.
        :param str instance_id: Cloud SQL instance ID in the form project:location:instance.
        :param str type: Type of the Cloud SQL database.
               Possible values are: `DATABASE_TYPE_UNSPECIFIED`, `POSTGRES`, `MYSQL`.
        :param str service_account_id: (Output)
               When the connection is used in the context of an operation in BigQuery, this service account will serve as the identity being used for connecting to the CloudSQL instance specified in this connection.
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "type", type)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter
    def credential(self) -> 'outputs.ConnectionCloudSqlCredential':
        """
        Cloud SQL properties.
        Structure is documented below.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Cloud SQL instance ID in the form project:location:instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Cloud SQL database.
        Possible values are: `DATABASE_TYPE_UNSPECIFIED`, `POSTGRES`, `MYSQL`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[str]:
        """
        (Output)
        When the connection is used in the context of an operation in BigQuery, this service account will serve as the identity being used for connecting to the CloudSQL instance specified in this connection.
        """
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class ConnectionCloudSqlCredential(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: Password for database.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: Username for database.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for database.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for database.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ConnectionIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ConnectionSpark(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metastoreServiceConfig":
            suggest = "metastore_service_config"
        elif key == "serviceAccountId":
            suggest = "service_account_id"
        elif key == "sparkHistoryServerConfig":
            suggest = "spark_history_server_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSpark. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSpark.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSpark.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metastore_service_config: Optional['outputs.ConnectionSparkMetastoreServiceConfig'] = None,
                 service_account_id: Optional[str] = None,
                 spark_history_server_config: Optional['outputs.ConnectionSparkSparkHistoryServerConfig'] = None):
        """
        :param 'ConnectionSparkMetastoreServiceConfigArgs' metastore_service_config: Dataproc Metastore Service configuration for the connection.
               Structure is documented below.
        :param str service_account_id: (Output)
               The account ID of the service created for the purpose of this connection.
        :param 'ConnectionSparkSparkHistoryServerConfigArgs' spark_history_server_config: Spark History Server configuration for the connection.
               Structure is documented below.
        """
        if metastore_service_config is not None:
            pulumi.set(__self__, "metastore_service_config", metastore_service_config)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if spark_history_server_config is not None:
            pulumi.set(__self__, "spark_history_server_config", spark_history_server_config)

    @property
    @pulumi.getter(name="metastoreServiceConfig")
    def metastore_service_config(self) -> Optional['outputs.ConnectionSparkMetastoreServiceConfig']:
        """
        Dataproc Metastore Service configuration for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "metastore_service_config")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[str]:
        """
        (Output)
        The account ID of the service created for the purpose of this connection.
        """
        return pulumi.get(self, "service_account_id")

    @property
    @pulumi.getter(name="sparkHistoryServerConfig")
    def spark_history_server_config(self) -> Optional['outputs.ConnectionSparkSparkHistoryServerConfig']:
        """
        Spark History Server configuration for the connection.
        Structure is documented below.
        """
        return pulumi.get(self, "spark_history_server_config")


@pulumi.output_type
class ConnectionSparkMetastoreServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metastoreService":
            suggest = "metastore_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSparkMetastoreServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSparkMetastoreServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSparkMetastoreServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metastore_service: Optional[str] = None):
        """
        :param str metastore_service: Resource name of an existing Dataproc Metastore service in the form of projects/[projectId]/locations/[region]/services/[serviceId].
        """
        if metastore_service is not None:
            pulumi.set(__self__, "metastore_service", metastore_service)

    @property
    @pulumi.getter(name="metastoreService")
    def metastore_service(self) -> Optional[str]:
        """
        Resource name of an existing Dataproc Metastore service in the form of projects/[projectId]/locations/[region]/services/[serviceId].
        """
        return pulumi.get(self, "metastore_service")


@pulumi.output_type
class ConnectionSparkSparkHistoryServerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocCluster":
            suggest = "dataproc_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSparkSparkHistoryServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSparkSparkHistoryServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSparkSparkHistoryServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_cluster: Optional[str] = None):
        """
        :param str dataproc_cluster: Resource name of an existing Dataproc Cluster to act as a Spark History Server for the connection if the form of projects/[projectId]/regions/[region]/clusters/[cluster_name].
        """
        if dataproc_cluster is not None:
            pulumi.set(__self__, "dataproc_cluster", dataproc_cluster)

    @property
    @pulumi.getter(name="dataprocCluster")
    def dataproc_cluster(self) -> Optional[str]:
        """
        Resource name of an existing Dataproc Cluster to act as a Spark History Server for the connection if the form of projects/[projectId]/regions/[region]/clusters/[cluster_name].
        """
        return pulumi.get(self, "dataproc_cluster")


@pulumi.output_type
class DataTransferConfigEmailPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableFailureEmail":
            suggest = "enable_failure_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataTransferConfigEmailPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataTransferConfigEmailPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataTransferConfigEmailPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_failure_email: bool):
        """
        :param bool enable_failure_email: If true, email notifications will be sent on transfer run failures.
        """
        pulumi.set(__self__, "enable_failure_email", enable_failure_email)

    @property
    @pulumi.getter(name="enableFailureEmail")
    def enable_failure_email(self) -> bool:
        """
        If true, email notifications will be sent on transfer run failures.
        """
        return pulumi.get(self, "enable_failure_email")


@pulumi.output_type
class DataTransferConfigEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataTransferConfigEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataTransferConfigEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataTransferConfigEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: The name of the KMS key used for encrypting BigQuery data.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The name of the KMS key used for encrypting BigQuery data.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class DataTransferConfigScheduleOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAutoScheduling":
            suggest = "disable_auto_scheduling"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataTransferConfigScheduleOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataTransferConfigScheduleOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataTransferConfigScheduleOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_auto_scheduling: Optional[bool] = None,
                 end_time: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        :param bool disable_auto_scheduling: If true, automatic scheduling of data transfer runs for this
               configuration will be disabled. The runs can be started on ad-hoc
               basis using transferConfigs.startManualRuns API. When automatic
               scheduling is disabled, the TransferConfig.schedule field will
               be ignored.
        :param str end_time: Defines time to stop scheduling transfer runs. A transfer run cannot be
               scheduled at or after the end time. The end time can be changed at any
               moment. The time when a data transfer can be triggered manually is not
               limited by this option.
        :param str start_time: Specifies time to start scheduling transfer runs. The first run will be
               scheduled at or after the start time according to a recurrence pattern
               defined in the schedule string. The start time can be changed at any
               moment. The time when a data transfer can be triggered manually is not
               limited by this option.
        """
        if disable_auto_scheduling is not None:
            pulumi.set(__self__, "disable_auto_scheduling", disable_auto_scheduling)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="disableAutoScheduling")
    def disable_auto_scheduling(self) -> Optional[bool]:
        """
        If true, automatic scheduling of data transfer runs for this
        configuration will be disabled. The runs can be started on ad-hoc
        basis using transferConfigs.startManualRuns API. When automatic
        scheduling is disabled, the TransferConfig.schedule field will
        be ignored.
        """
        return pulumi.get(self, "disable_auto_scheduling")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Defines time to stop scheduling transfer runs. A transfer run cannot be
        scheduled at or after the end time. The end time can be changed at any
        moment. The time when a data transfer can be triggered manually is not
        limited by this option.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Specifies time to start scheduling transfer runs. The first run will be
        scheduled at or after the start time according to a recurrence pattern
        defined in the schedule string. The start time can be changed at any
        moment. The time when a data transfer can be triggered manually is not
        limited by this option.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class DataTransferConfigSensitiveParams(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretAccessKey":
            suggest = "secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataTransferConfigSensitiveParams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataTransferConfigSensitiveParams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataTransferConfigSensitiveParams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_access_key: str):
        """
        :param str secret_access_key: The Secret Access Key of the AWS account transferring data from.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        The Secret Access Key of the AWS account transferring data from.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret_access_key")


@pulumi.output_type
class DatasetAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupByEmail":
            suggest = "group_by_email"
        elif key == "iamMember":
            suggest = "iam_member"
        elif key == "specialGroup":
            suggest = "special_group"
        elif key == "userByEmail":
            suggest = "user_by_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: Optional['outputs.DatasetAccessDataset'] = None,
                 domain: Optional[str] = None,
                 group_by_email: Optional[str] = None,
                 iam_member: Optional[str] = None,
                 role: Optional[str] = None,
                 routine: Optional['outputs.DatasetAccessRoutine'] = None,
                 special_group: Optional[str] = None,
                 user_by_email: Optional[str] = None,
                 view: Optional['outputs.DatasetAccessView'] = None):
        """
        :param 'DatasetAccessDatasetArgs' dataset: Grants all resources of particular types in a particular dataset read access to the current dataset.
               Structure is documented below.
        :param str domain: A domain to grant access to. Any users signed in with the
               domain specified will be granted the specified access
        :param str group_by_email: An email address of a Google Group to grant access to.
        :param str iam_member: Some other type of member that appears in the IAM Policy but isn't a user,
               group, domain, or special group. For example: `allUsers`
        :param str role: Describes the rights granted to the user specified by the other
               member of the access object. Basic, predefined, and custom roles
               are supported. Predefined roles that have equivalent basic roles
               are swapped by the API to their basic counterparts. See
               [official docs](https://cloud.google.com/bigquery/docs/access-control).
        :param 'DatasetAccessRoutineArgs' routine: A routine from a different dataset to grant access to. Queries
               executed against that routine will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that routine is updated by any user, access to the routine
               needs to be granted again via an update operation.
               Structure is documented below.
        :param str special_group: A special group to grant access to. Possible values include:
               * `projectOwners`: Owners of the enclosing project.
               * `projectReaders`: Readers of the enclosing project.
               * `projectWriters`: Writers of the enclosing project.
               * `allAuthenticatedUsers`: All authenticated BigQuery users.
        :param str user_by_email: An email address of a user to grant access to. For example:
               fred@example.com
        :param 'DatasetAccessViewArgs' view: A view from a different dataset to grant access to. Queries
               executed against that view will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that view is updated by any user, access to the view
               needs to be granted again via an update operation.
               Structure is documented below.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if group_by_email is not None:
            pulumi.set(__self__, "group_by_email", group_by_email)
        if iam_member is not None:
            pulumi.set(__self__, "iam_member", iam_member)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if routine is not None:
            pulumi.set(__self__, "routine", routine)
        if special_group is not None:
            pulumi.set(__self__, "special_group", special_group)
        if user_by_email is not None:
            pulumi.set(__self__, "user_by_email", user_by_email)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter
    def dataset(self) -> Optional['outputs.DatasetAccessDataset']:
        """
        Grants all resources of particular types in a particular dataset read access to the current dataset.
        Structure is documented below.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        A domain to grant access to. Any users signed in with the
        domain specified will be granted the specified access
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="groupByEmail")
    def group_by_email(self) -> Optional[str]:
        """
        An email address of a Google Group to grant access to.
        """
        return pulumi.get(self, "group_by_email")

    @property
    @pulumi.getter(name="iamMember")
    def iam_member(self) -> Optional[str]:
        """
        Some other type of member that appears in the IAM Policy but isn't a user,
        group, domain, or special group. For example: `allUsers`
        """
        return pulumi.get(self, "iam_member")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Describes the rights granted to the user specified by the other
        member of the access object. Basic, predefined, and custom roles
        are supported. Predefined roles that have equivalent basic roles
        are swapped by the API to their basic counterparts. See
        [official docs](https://cloud.google.com/bigquery/docs/access-control).
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def routine(self) -> Optional['outputs.DatasetAccessRoutine']:
        """
        A routine from a different dataset to grant access to. Queries
        executed against that routine will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that routine is updated by any user, access to the routine
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "routine")

    @property
    @pulumi.getter(name="specialGroup")
    def special_group(self) -> Optional[str]:
        """
        A special group to grant access to. Possible values include:
        * `projectOwners`: Owners of the enclosing project.
        * `projectReaders`: Readers of the enclosing project.
        * `projectWriters`: Writers of the enclosing project.
        * `allAuthenticatedUsers`: All authenticated BigQuery users.
        """
        return pulumi.get(self, "special_group")

    @property
    @pulumi.getter(name="userByEmail")
    def user_by_email(self) -> Optional[str]:
        """
        An email address of a user to grant access to. For example:
        fred@example.com
        """
        return pulumi.get(self, "user_by_email")

    @property
    @pulumi.getter
    def view(self) -> Optional['outputs.DatasetAccessView']:
        """
        A view from a different dataset to grant access to. Queries
        executed against that view will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that view is updated by any user, access to the view
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "view")


@pulumi.output_type
class DatasetAccessAuthorizedDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetTypes":
            suggest = "target_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccessAuthorizedDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccessAuthorizedDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccessAuthorizedDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: 'outputs.DatasetAccessAuthorizedDatasetDataset',
                 target_types: Sequence[str]):
        """
        :param 'DatasetAccessAuthorizedDatasetDatasetArgs' dataset: The dataset this entry applies to
               Structure is documented below.
        :param Sequence[str] target_types: Which resources in the dataset this entry applies to. Currently, only views are supported,
               but additional target types may be added in the future. Possible values: VIEWS
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "target_types", target_types)

    @property
    @pulumi.getter
    def dataset(self) -> 'outputs.DatasetAccessAuthorizedDatasetDataset':
        """
        The dataset this entry applies to
        Structure is documented below.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="targetTypes")
    def target_types(self) -> Sequence[str]:
        """
        Which resources in the dataset this entry applies to. Currently, only views are supported,
        but additional target types may be added in the future. Possible values: VIEWS
        """
        return pulumi.get(self, "target_types")


@pulumi.output_type
class DatasetAccessAuthorizedDatasetDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccessAuthorizedDatasetDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccessAuthorizedDatasetDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccessAuthorizedDatasetDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: str):
        """
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class DatasetAccessDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetTypes":
            suggest = "target_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccessDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccessDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccessDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: 'outputs.DatasetAccessDatasetDataset',
                 target_types: Sequence[str]):
        """
        :param 'DatasetAccessDatasetDatasetArgs' dataset: The dataset this entry applies to
               Structure is documented below.
        :param Sequence[str] target_types: Which resources in the dataset this entry applies to. Currently, only views are supported,
               but additional target types may be added in the future. Possible values: VIEWS
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "target_types", target_types)

    @property
    @pulumi.getter
    def dataset(self) -> 'outputs.DatasetAccessDatasetDataset':
        """
        The dataset this entry applies to
        Structure is documented below.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="targetTypes")
    def target_types(self) -> Sequence[str]:
        """
        Which resources in the dataset this entry applies to. Currently, only views are supported,
        but additional target types may be added in the future. Possible values: VIEWS
        """
        return pulumi.get(self, "target_types")


@pulumi.output_type
class DatasetAccessDatasetDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccessDatasetDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccessDatasetDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccessDatasetDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: str):
        """
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class DatasetAccessRoutine(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "routineId":
            suggest = "routine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccessRoutine. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccessRoutine.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccessRoutine.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: str,
                 routine_id: str):
        """
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        :param str routine_id: The ID of the routine. The ID must contain only letters (a-z,
               A-Z), numbers (0-9), or underscores (_). The maximum length
               is 256 characters.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "routine_id", routine_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="routineId")
    def routine_id(self) -> str:
        """
        The ID of the routine. The ID must contain only letters (a-z,
        A-Z), numbers (0-9), or underscores (_). The maximum length
        is 256 characters.
        """
        return pulumi.get(self, "routine_id")


@pulumi.output_type
class DatasetAccessView(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAccessView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAccessView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAccessView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: str,
                 table_id: str):
        """
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        :param str table_id: The ID of the table. The ID must contain only letters (a-z,
               A-Z), numbers (0-9), or underscores (_). The maximum length
               is 1,024 characters.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The ID of the table. The ID must contain only letters (a-z,
        A-Z), numbers (0-9), or underscores (_). The maximum length
        is 1,024 characters.
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class DatasetDefaultEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetDefaultEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetDefaultEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetDefaultEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination
               BigQuery table. The BigQuery Service Account associated with your project requires
               access to this encryption key.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination
        BigQuery table. The BigQuery Service Account associated with your project requires
        access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class DatasetExternalDatasetReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalSource":
            suggest = "external_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetExternalDatasetReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetExternalDatasetReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetExternalDatasetReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection: str,
                 external_source: str):
        """
        :param str connection: The connection id that is used to access the externalSource.
               Format: projects/{projectId}/locations/{locationId}/connections/{connectionId}
        :param str external_source: External source that backs this dataset.
        """
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "external_source", external_source)

    @property
    @pulumi.getter
    def connection(self) -> str:
        """
        The connection id that is used to access the externalSource.
        Format: projects/{projectId}/locations/{locationId}/connections/{connectionId}
        """
        return pulumi.get(self, "connection")

    @property
    @pulumi.getter(name="externalSource")
    def external_source(self) -> str:
        """
        External source that backs this dataset.
        """
        return pulumi.get(self, "external_source")


@pulumi.output_type
class DatasetIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DatasetIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class IamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class IamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobCopy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceTables":
            suggest = "source_tables"
        elif key == "createDisposition":
            suggest = "create_disposition"
        elif key == "destinationEncryptionConfiguration":
            suggest = "destination_encryption_configuration"
        elif key == "destinationTable":
            suggest = "destination_table"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCopy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCopy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCopy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_tables: Sequence['outputs.JobCopySourceTable'],
                 create_disposition: Optional[str] = None,
                 destination_encryption_configuration: Optional['outputs.JobCopyDestinationEncryptionConfiguration'] = None,
                 destination_table: Optional['outputs.JobCopyDestinationTable'] = None,
                 write_disposition: Optional[str] = None):
        """
        :param Sequence['JobCopySourceTableArgs'] source_tables: Source tables to copy.
               Structure is documented below.
        :param str create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported:
               CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
               CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
               Creation, truncation and append actions occur as one atomic update upon job completion
               Default value is `CREATE_IF_NEEDED`.
               Possible values are: `CREATE_IF_NEEDED`, `CREATE_NEVER`.
        :param 'JobCopyDestinationEncryptionConfigurationArgs' destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys)
               Structure is documented below.
        :param 'JobCopyDestinationTableArgs' destination_table: The destination table.
               Structure is documented below.
        :param str write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported:
               WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
               WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
               WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
               Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
               Creation, truncation and append actions occur as one atomic update upon job completion.
               Default value is `WRITE_EMPTY`.
               Possible values are: `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
        """
        pulumi.set(__self__, "source_tables", source_tables)
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if destination_table is not None:
            pulumi.set(__self__, "destination_table", destination_table)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="sourceTables")
    def source_tables(self) -> Sequence['outputs.JobCopySourceTable']:
        """
        Source tables to copy.
        Structure is documented below.
        """
        return pulumi.get(self, "source_tables")

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[str]:
        """
        Specifies whether the job is allowed to create new tables. The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion
        Default value is `CREATE_IF_NEEDED`.
        Possible values are: `CREATE_IF_NEEDED`, `CREATE_NEVER`.
        """
        return pulumi.get(self, "create_disposition")

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional['outputs.JobCopyDestinationEncryptionConfiguration']:
        """
        Custom encryption configuration (e.g., Cloud KMS keys)
        Structure is documented below.
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> Optional['outputs.JobCopyDestinationTable']:
        """
        The destination table.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_table")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[str]:
        """
        Specifies the action that occurs if the destination table already exists. The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion.
        Default value is `WRITE_EMPTY`.
        Possible values are: `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class JobCopyDestinationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersion":
            suggest = "kms_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCopyDestinationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCopyDestinationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCopyDestinationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_version: Optional[str] = None):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
               The BigQuery Service Account associated with your project requires access to this encryption key.
        :param str kms_key_version: (Output)
               Describes the Cloud KMS encryption key version used to protect destination BigQuery table.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version is not None:
            pulumi.set(__self__, "kms_key_version", kms_key_version)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> Optional[str]:
        """
        (Output)
        Describes the Cloud KMS encryption key version used to protect destination BigQuery table.
        """
        return pulumi.get(self, "kms_key_version")


@pulumi.output_type
class JobCopyDestinationTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableId":
            suggest = "table_id"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCopyDestinationTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCopyDestinationTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCopyDestinationTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_id: str,
                 dataset_id: Optional[str] = None,
                 project_id: Optional[str] = None):
        """
        :param str table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class JobCopySourceTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableId":
            suggest = "table_id"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCopySourceTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCopySourceTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCopySourceTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_id: str,
                 dataset_id: Optional[str] = None,
                 project_id: Optional[str] = None):
        """
        :param str table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class JobExtract(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationUris":
            suggest = "destination_uris"
        elif key == "destinationFormat":
            suggest = "destination_format"
        elif key == "fieldDelimiter":
            suggest = "field_delimiter"
        elif key == "printHeader":
            suggest = "print_header"
        elif key == "sourceModel":
            suggest = "source_model"
        elif key == "sourceTable":
            suggest = "source_table"
        elif key == "useAvroLogicalTypes":
            suggest = "use_avro_logical_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobExtract. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobExtract.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobExtract.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_uris: Sequence[str],
                 compression: Optional[str] = None,
                 destination_format: Optional[str] = None,
                 field_delimiter: Optional[str] = None,
                 print_header: Optional[bool] = None,
                 source_model: Optional['outputs.JobExtractSourceModel'] = None,
                 source_table: Optional['outputs.JobExtractSourceTable'] = None,
                 use_avro_logical_types: Optional[bool] = None):
        """
        :param Sequence[str] destination_uris: A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        :param str compression: The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
               The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
        :param str destination_format: The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
               The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
               The default value for models is SAVED_MODEL.
        :param str field_delimiter: When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
               Default is ','
        :param bool print_header: Whether to print out a header row in the results. Default is true.
        :param 'JobExtractSourceModelArgs' source_model: A reference to the model being exported.
               Structure is documented below.
        :param 'JobExtractSourceTableArgs' source_table: A reference to the table being exported.
               Structure is documented below.
        :param bool use_avro_logical_types: Whether to use logical types when extracting to AVRO format.
        """
        pulumi.set(__self__, "destination_uris", destination_uris)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if destination_format is not None:
            pulumi.set(__self__, "destination_format", destination_format)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if print_header is not None:
            pulumi.set(__self__, "print_header", print_header)
        if source_model is not None:
            pulumi.set(__self__, "source_model", source_model)
        if source_table is not None:
            pulumi.set(__self__, "source_table", source_table)
        if use_avro_logical_types is not None:
            pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)

    @property
    @pulumi.getter(name="destinationUris")
    def destination_uris(self) -> Sequence[str]:
        """
        A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        """
        return pulumi.get(self, "destination_uris")

    @property
    @pulumi.getter
    def compression(self) -> Optional[str]:
        """
        The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
        The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="destinationFormat")
    def destination_format(self) -> Optional[str]:
        """
        The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
        The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
        The default value for models is SAVED_MODEL.
        """
        return pulumi.get(self, "destination_format")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[str]:
        """
        When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
        Default is ','
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="printHeader")
    def print_header(self) -> Optional[bool]:
        """
        Whether to print out a header row in the results. Default is true.
        """
        return pulumi.get(self, "print_header")

    @property
    @pulumi.getter(name="sourceModel")
    def source_model(self) -> Optional['outputs.JobExtractSourceModel']:
        """
        A reference to the model being exported.
        Structure is documented below.
        """
        return pulumi.get(self, "source_model")

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> Optional['outputs.JobExtractSourceTable']:
        """
        A reference to the table being exported.
        Structure is documented below.
        """
        return pulumi.get(self, "source_table")

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> Optional[bool]:
        """
        Whether to use logical types when extracting to AVRO format.
        """
        return pulumi.get(self, "use_avro_logical_types")


@pulumi.output_type
class JobExtractSourceModel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "modelId":
            suggest = "model_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobExtractSourceModel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobExtractSourceModel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobExtractSourceModel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 model_id: str,
                 project_id: str):
        """
        :param str dataset_id: The ID of the dataset containing this model.
        :param str model_id: The ID of the model.
               
               - - -
        :param str project_id: The ID of the project containing this model.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        The ID of the model.

        - - -
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this model.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class JobExtractSourceTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableId":
            suggest = "table_id"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobExtractSourceTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobExtractSourceTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobExtractSourceTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_id: str,
                 dataset_id: Optional[str] = None,
                 project_id: Optional[str] = None):
        """
        :param str table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class JobLoad(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationTable":
            suggest = "destination_table"
        elif key == "sourceUris":
            suggest = "source_uris"
        elif key == "allowJaggedRows":
            suggest = "allow_jagged_rows"
        elif key == "allowQuotedNewlines":
            suggest = "allow_quoted_newlines"
        elif key == "createDisposition":
            suggest = "create_disposition"
        elif key == "destinationEncryptionConfiguration":
            suggest = "destination_encryption_configuration"
        elif key == "fieldDelimiter":
            suggest = "field_delimiter"
        elif key == "ignoreUnknownValues":
            suggest = "ignore_unknown_values"
        elif key == "jsonExtension":
            suggest = "json_extension"
        elif key == "maxBadRecords":
            suggest = "max_bad_records"
        elif key == "nullMarker":
            suggest = "null_marker"
        elif key == "parquetOptions":
            suggest = "parquet_options"
        elif key == "projectionFields":
            suggest = "projection_fields"
        elif key == "schemaUpdateOptions":
            suggest = "schema_update_options"
        elif key == "skipLeadingRows":
            suggest = "skip_leading_rows"
        elif key == "sourceFormat":
            suggest = "source_format"
        elif key == "timePartitioning":
            suggest = "time_partitioning"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobLoad. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobLoad.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobLoad.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_table: 'outputs.JobLoadDestinationTable',
                 source_uris: Sequence[str],
                 allow_jagged_rows: Optional[bool] = None,
                 allow_quoted_newlines: Optional[bool] = None,
                 autodetect: Optional[bool] = None,
                 create_disposition: Optional[str] = None,
                 destination_encryption_configuration: Optional['outputs.JobLoadDestinationEncryptionConfiguration'] = None,
                 encoding: Optional[str] = None,
                 field_delimiter: Optional[str] = None,
                 ignore_unknown_values: Optional[bool] = None,
                 json_extension: Optional[str] = None,
                 max_bad_records: Optional[int] = None,
                 null_marker: Optional[str] = None,
                 parquet_options: Optional['outputs.JobLoadParquetOptions'] = None,
                 projection_fields: Optional[Sequence[str]] = None,
                 quote: Optional[str] = None,
                 schema_update_options: Optional[Sequence[str]] = None,
                 skip_leading_rows: Optional[int] = None,
                 source_format: Optional[str] = None,
                 time_partitioning: Optional['outputs.JobLoadTimePartitioning'] = None,
                 write_disposition: Optional[str] = None):
        """
        :param 'JobLoadDestinationTableArgs' destination_table: The destination table to load the data into.
               Structure is documented below.
        :param Sequence[str] source_uris: The fully-qualified URIs that point to your data in Google Cloud.
               For Google Cloud Storage URIs: Each URI can contain one '\\*' wildcard character
               and it must come after the 'bucket' name. Size limits related to load jobs apply
               to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
               specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
               For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '\\*' wildcard character is not allowed.
        :param bool allow_jagged_rows: Accept rows that are missing trailing optional columns. The missing values are treated as nulls.
               If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
               an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        :param bool allow_quoted_newlines: Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
               The default value is false.
        :param bool autodetect: Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        :param str create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported:
               CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
               CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
               Creation, truncation and append actions occur as one atomic update upon job completion
               Default value is `CREATE_IF_NEEDED`.
               Possible values are: `CREATE_IF_NEEDED`, `CREATE_NEVER`.
        :param 'JobLoadDestinationEncryptionConfigurationArgs' destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys)
               Structure is documented below.
        :param str encoding: The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
               The default value is UTF-8. BigQuery decodes the data after the raw, binary data
               has been split using the values of the quote and fieldDelimiter properties.
        :param str field_delimiter: The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character.
               To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts
               the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
               data in its raw, binary state. BigQuery also supports the escape sequence "\\t" to specify a tab separator.
               The default value is a comma (',').
        :param bool ignore_unknown_values: Indicates if BigQuery should allow extra values that are not represented in the table schema.
               If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
               and if there are too many bad records, an invalid error is returned in the job result.
               The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
               CSV: Trailing columns
               JSON: Named values that don't match any column names
        :param str json_extension: If sourceFormat is set to newline-delimited JSON, indicates whether it should be processed as a JSON variant such as GeoJSON.
               For a sourceFormat other than JSON, omit this field. If the sourceFormat is newline-delimited JSON: - for newline-delimited
               GeoJSON: set to GEOJSON.
        :param int max_bad_records: The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value,
               an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
        :param str null_marker: Specifies a string that represents a null value in a CSV file. The default value is the empty string. If you set this
               property to a custom value, BigQuery throws an error if an
               empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
               an empty value.
        :param 'JobLoadParquetOptionsArgs' parquet_options: Parquet Options for load and make external tables.
               Structure is documented below.
        :param Sequence[str] projection_fields: If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.
               Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
               If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        :param str quote: The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding,
               and then uses the first byte of the encoded string to split the data in its raw, binary state.
               The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
               If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        :param Sequence[str] schema_update_options: Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or
               supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
               when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
               For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
               ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
               ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param int skip_leading_rows: The number of rows at the top of a CSV file that BigQuery will skip when loading the data.
               The default value is 0. This property is useful if you have header rows in the file that should be skipped.
               When autodetect is on, the behavior is the following:
               skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
               the row is read as data. Otherwise data is read starting from the second row.
               skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
               skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
               row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        :param str source_format: The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
               For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
               For orc, specify "ORC". [Beta] For Bigtable, specify "BIGTABLE".
               The default value is CSV.
        :param 'JobLoadTimePartitioningArgs' time_partitioning: Time-based partitioning specification for the destination table.
               Structure is documented below.
        :param str write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported:
               WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
               WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
               WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
               Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
               Creation, truncation and append actions occur as one atomic update upon job completion.
               Default value is `WRITE_EMPTY`.
               Possible values are: `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
        """
        pulumi.set(__self__, "destination_table", destination_table)
        pulumi.set(__self__, "source_uris", source_uris)
        if allow_jagged_rows is not None:
            pulumi.set(__self__, "allow_jagged_rows", allow_jagged_rows)
        if allow_quoted_newlines is not None:
            pulumi.set(__self__, "allow_quoted_newlines", allow_quoted_newlines)
        if autodetect is not None:
            pulumi.set(__self__, "autodetect", autodetect)
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if ignore_unknown_values is not None:
            pulumi.set(__self__, "ignore_unknown_values", ignore_unknown_values)
        if json_extension is not None:
            pulumi.set(__self__, "json_extension", json_extension)
        if max_bad_records is not None:
            pulumi.set(__self__, "max_bad_records", max_bad_records)
        if null_marker is not None:
            pulumi.set(__self__, "null_marker", null_marker)
        if parquet_options is not None:
            pulumi.set(__self__, "parquet_options", parquet_options)
        if projection_fields is not None:
            pulumi.set(__self__, "projection_fields", projection_fields)
        if quote is not None:
            pulumi.set(__self__, "quote", quote)
        if schema_update_options is not None:
            pulumi.set(__self__, "schema_update_options", schema_update_options)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)
        if source_format is not None:
            pulumi.set(__self__, "source_format", source_format)
        if time_partitioning is not None:
            pulumi.set(__self__, "time_partitioning", time_partitioning)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> 'outputs.JobLoadDestinationTable':
        """
        The destination table to load the data into.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_table")

    @property
    @pulumi.getter(name="sourceUris")
    def source_uris(self) -> Sequence[str]:
        """
        The fully-qualified URIs that point to your data in Google Cloud.
        For Google Cloud Storage URIs: Each URI can contain one '\\*' wildcard character
        and it must come after the 'bucket' name. Size limits related to load jobs apply
        to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
        specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
        For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '\\*' wildcard character is not allowed.
        """
        return pulumi.get(self, "source_uris")

    @property
    @pulumi.getter(name="allowJaggedRows")
    def allow_jagged_rows(self) -> Optional[bool]:
        """
        Accept rows that are missing trailing optional columns. The missing values are treated as nulls.
        If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
        an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        """
        return pulumi.get(self, "allow_jagged_rows")

    @property
    @pulumi.getter(name="allowQuotedNewlines")
    def allow_quoted_newlines(self) -> Optional[bool]:
        """
        Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
        The default value is false.
        """
        return pulumi.get(self, "allow_quoted_newlines")

    @property
    @pulumi.getter
    def autodetect(self) -> Optional[bool]:
        """
        Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        """
        return pulumi.get(self, "autodetect")

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[str]:
        """
        Specifies whether the job is allowed to create new tables. The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion
        Default value is `CREATE_IF_NEEDED`.
        Possible values are: `CREATE_IF_NEEDED`, `CREATE_NEVER`.
        """
        return pulumi.get(self, "create_disposition")

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional['outputs.JobLoadDestinationEncryptionConfiguration']:
        """
        Custom encryption configuration (e.g., Cloud KMS keys)
        Structure is documented below.
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
        The default value is UTF-8. BigQuery decodes the data after the raw, binary data
        has been split using the values of the quote and fieldDelimiter properties.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[str]:
        """
        The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character.
        To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts
        the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
        data in its raw, binary state. BigQuery also supports the escape sequence "\\t" to specify a tab separator.
        The default value is a comma (',').
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="ignoreUnknownValues")
    def ignore_unknown_values(self) -> Optional[bool]:
        """
        Indicates if BigQuery should allow extra values that are not represented in the table schema.
        If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
        and if there are too many bad records, an invalid error is returned in the job result.
        The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
        CSV: Trailing columns
        JSON: Named values that don't match any column names
        """
        return pulumi.get(self, "ignore_unknown_values")

    @property
    @pulumi.getter(name="jsonExtension")
    def json_extension(self) -> Optional[str]:
        """
        If sourceFormat is set to newline-delimited JSON, indicates whether it should be processed as a JSON variant such as GeoJSON.
        For a sourceFormat other than JSON, omit this field. If the sourceFormat is newline-delimited JSON: - for newline-delimited
        GeoJSON: set to GEOJSON.
        """
        return pulumi.get(self, "json_extension")

    @property
    @pulumi.getter(name="maxBadRecords")
    def max_bad_records(self) -> Optional[int]:
        """
        The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value,
        an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
        """
        return pulumi.get(self, "max_bad_records")

    @property
    @pulumi.getter(name="nullMarker")
    def null_marker(self) -> Optional[str]:
        """
        Specifies a string that represents a null value in a CSV file. The default value is the empty string. If you set this
        property to a custom value, BigQuery throws an error if an
        empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
        an empty value.
        """
        return pulumi.get(self, "null_marker")

    @property
    @pulumi.getter(name="parquetOptions")
    def parquet_options(self) -> Optional['outputs.JobLoadParquetOptions']:
        """
        Parquet Options for load and make external tables.
        Structure is documented below.
        """
        return pulumi.get(self, "parquet_options")

    @property
    @pulumi.getter(name="projectionFields")
    def projection_fields(self) -> Optional[Sequence[str]]:
        """
        If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.
        Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
        If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        """
        return pulumi.get(self, "projection_fields")

    @property
    @pulumi.getter
    def quote(self) -> Optional[str]:
        """
        The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding,
        and then uses the first byte of the encoded string to split the data in its raw, binary state.
        The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
        If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        """
        return pulumi.get(self, "quote")

    @property
    @pulumi.getter(name="schemaUpdateOptions")
    def schema_update_options(self) -> Optional[Sequence[str]]:
        """
        Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or
        supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
        when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
        For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
        ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
        ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return pulumi.get(self, "schema_update_options")

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[int]:
        """
        The number of rows at the top of a CSV file that BigQuery will skip when loading the data.
        The default value is 0. This property is useful if you have header rows in the file that should be skipped.
        When autodetect is on, the behavior is the following:
        skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
        the row is read as data. Otherwise data is read starting from the second row.
        skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
        skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
        row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        return pulumi.get(self, "skip_leading_rows")

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> Optional[str]:
        """
        The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
        For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
        For orc, specify "ORC". [Beta] For Bigtable, specify "BIGTABLE".
        The default value is CSV.
        """
        return pulumi.get(self, "source_format")

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> Optional['outputs.JobLoadTimePartitioning']:
        """
        Time-based partitioning specification for the destination table.
        Structure is documented below.
        """
        return pulumi.get(self, "time_partitioning")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[str]:
        """
        Specifies the action that occurs if the destination table already exists. The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion.
        Default value is `WRITE_EMPTY`.
        Possible values are: `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class JobLoadDestinationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersion":
            suggest = "kms_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobLoadDestinationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobLoadDestinationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobLoadDestinationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_version: Optional[str] = None):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
               The BigQuery Service Account associated with your project requires access to this encryption key.
        :param str kms_key_version: (Output)
               Describes the Cloud KMS encryption key version used to protect destination BigQuery table.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version is not None:
            pulumi.set(__self__, "kms_key_version", kms_key_version)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> Optional[str]:
        """
        (Output)
        Describes the Cloud KMS encryption key version used to protect destination BigQuery table.
        """
        return pulumi.get(self, "kms_key_version")


@pulumi.output_type
class JobLoadDestinationTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableId":
            suggest = "table_id"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobLoadDestinationTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobLoadDestinationTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobLoadDestinationTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_id: str,
                 dataset_id: Optional[str] = None,
                 project_id: Optional[str] = None):
        """
        :param str table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class JobLoadParquetOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableListInference":
            suggest = "enable_list_inference"
        elif key == "enumAsString":
            suggest = "enum_as_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobLoadParquetOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobLoadParquetOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobLoadParquetOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_list_inference: Optional[bool] = None,
                 enum_as_string: Optional[bool] = None):
        """
        :param bool enable_list_inference: If sourceFormat is set to PARQUET, indicates whether to use schema inference specifically for Parquet LIST logical type.
        :param bool enum_as_string: If sourceFormat is set to PARQUET, indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
        """
        if enable_list_inference is not None:
            pulumi.set(__self__, "enable_list_inference", enable_list_inference)
        if enum_as_string is not None:
            pulumi.set(__self__, "enum_as_string", enum_as_string)

    @property
    @pulumi.getter(name="enableListInference")
    def enable_list_inference(self) -> Optional[bool]:
        """
        If sourceFormat is set to PARQUET, indicates whether to use schema inference specifically for Parquet LIST logical type.
        """
        return pulumi.get(self, "enable_list_inference")

    @property
    @pulumi.getter(name="enumAsString")
    def enum_as_string(self) -> Optional[bool]:
        """
        If sourceFormat is set to PARQUET, indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
        """
        return pulumi.get(self, "enum_as_string")


@pulumi.output_type
class JobLoadTimePartitioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationMs":
            suggest = "expiration_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobLoadTimePartitioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobLoadTimePartitioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobLoadTimePartitioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 expiration_ms: Optional[str] = None,
                 field: Optional[str] = None):
        """
        :param str type: The only type supported is DAY, which will generate one partition per day. Providing an empty string used to cause an error,
               but in OnePlatform the field will be treated as unset.
        :param str expiration_ms: Number of milliseconds for which to keep the storage for a partition. A wrapper is used here because 0 is an invalid value.
        :param str field: If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the table is partitioned by this field.
               The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
               A wrapper is used here because an empty string is an invalid value.
        """
        pulumi.set(__self__, "type", type)
        if expiration_ms is not None:
            pulumi.set(__self__, "expiration_ms", expiration_ms)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The only type supported is DAY, which will generate one partition per day. Providing an empty string used to cause an error,
        but in OnePlatform the field will be treated as unset.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="expirationMs")
    def expiration_ms(self) -> Optional[str]:
        """
        Number of milliseconds for which to keep the storage for a partition. A wrapper is used here because 0 is an invalid value.
        """
        return pulumi.get(self, "expiration_ms")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the table is partitioned by this field.
        The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
        A wrapper is used here because an empty string is an invalid value.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class JobQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowLargeResults":
            suggest = "allow_large_results"
        elif key == "createDisposition":
            suggest = "create_disposition"
        elif key == "defaultDataset":
            suggest = "default_dataset"
        elif key == "destinationEncryptionConfiguration":
            suggest = "destination_encryption_configuration"
        elif key == "destinationTable":
            suggest = "destination_table"
        elif key == "flattenResults":
            suggest = "flatten_results"
        elif key == "maximumBillingTier":
            suggest = "maximum_billing_tier"
        elif key == "maximumBytesBilled":
            suggest = "maximum_bytes_billed"
        elif key == "parameterMode":
            suggest = "parameter_mode"
        elif key == "schemaUpdateOptions":
            suggest = "schema_update_options"
        elif key == "scriptOptions":
            suggest = "script_options"
        elif key == "useLegacySql":
            suggest = "use_legacy_sql"
        elif key == "useQueryCache":
            suggest = "use_query_cache"
        elif key == "userDefinedFunctionResources":
            suggest = "user_defined_function_resources"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: str,
                 allow_large_results: Optional[bool] = None,
                 create_disposition: Optional[str] = None,
                 default_dataset: Optional['outputs.JobQueryDefaultDataset'] = None,
                 destination_encryption_configuration: Optional['outputs.JobQueryDestinationEncryptionConfiguration'] = None,
                 destination_table: Optional['outputs.JobQueryDestinationTable'] = None,
                 flatten_results: Optional[bool] = None,
                 maximum_billing_tier: Optional[int] = None,
                 maximum_bytes_billed: Optional[str] = None,
                 parameter_mode: Optional[str] = None,
                 priority: Optional[str] = None,
                 schema_update_options: Optional[Sequence[str]] = None,
                 script_options: Optional['outputs.JobQueryScriptOptions'] = None,
                 use_legacy_sql: Optional[bool] = None,
                 use_query_cache: Optional[bool] = None,
                 user_defined_function_resources: Optional[Sequence['outputs.JobQueryUserDefinedFunctionResource']] = None,
                 write_disposition: Optional[str] = None):
        """
        :param str query: SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
               *NOTE*: queries containing [DML language](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language)
               (`DELETE`, `UPDATE`, `MERGE`, `INSERT`) must specify `create_disposition = ""` and `write_disposition = ""`.
        :param bool allow_large_results: If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
               Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
               However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        :param str create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported:
               CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
               CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
               Creation, truncation and append actions occur as one atomic update upon job completion
               Default value is `CREATE_IF_NEEDED`.
               Possible values are: `CREATE_IF_NEEDED`, `CREATE_NEVER`.
        :param 'JobQueryDefaultDatasetArgs' default_dataset: Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
               Structure is documented below.
        :param 'JobQueryDestinationEncryptionConfigurationArgs' destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys)
               Structure is documented below.
        :param 'JobQueryDestinationTableArgs' destination_table: Describes the table where the query results should be stored.
               This property must be set for large results that exceed the maximum response size.
               For queries that produce anonymous (cached) results, this field will be populated by BigQuery.
               Structure is documented below.
        :param bool flatten_results: If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
               allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        :param int maximum_billing_tier: Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge).
               If unspecified, this will be set to your project default.
        :param str maximum_bytes_billed: Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
               If unspecified, this will be set to your project default.
        :param str parameter_mode: Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        :param str priority: Specifies a priority for the query.
               Default value is `INTERACTIVE`.
               Possible values are: `INTERACTIVE`, `BATCH`.
        :param Sequence[str] schema_update_options: Allows the schema of the destination table to be updated as a side effect of the query job.
               Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
               when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
               specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
               One or more of the following values are specified:
               ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
               ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param 'JobQueryScriptOptionsArgs' script_options: Options controlling the execution of scripts.
               Structure is documented below.
        :param bool use_legacy_sql: Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true.
               If set to false, the query will use BigQuery's standard SQL.
        :param bool use_query_cache: Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever
               tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
               The default value is true.
        :param Sequence['JobQueryUserDefinedFunctionResourceArgs'] user_defined_function_resources: Describes user-defined function resources used in the query.
               Structure is documented below.
        :param str write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported:
               WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
               WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
               WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
               Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
               Creation, truncation and append actions occur as one atomic update upon job completion.
               Default value is `WRITE_EMPTY`.
               Possible values are: `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
        """
        pulumi.set(__self__, "query", query)
        if allow_large_results is not None:
            pulumi.set(__self__, "allow_large_results", allow_large_results)
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if default_dataset is not None:
            pulumi.set(__self__, "default_dataset", default_dataset)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if destination_table is not None:
            pulumi.set(__self__, "destination_table", destination_table)
        if flatten_results is not None:
            pulumi.set(__self__, "flatten_results", flatten_results)
        if maximum_billing_tier is not None:
            pulumi.set(__self__, "maximum_billing_tier", maximum_billing_tier)
        if maximum_bytes_billed is not None:
            pulumi.set(__self__, "maximum_bytes_billed", maximum_bytes_billed)
        if parameter_mode is not None:
            pulumi.set(__self__, "parameter_mode", parameter_mode)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if schema_update_options is not None:
            pulumi.set(__self__, "schema_update_options", schema_update_options)
        if script_options is not None:
            pulumi.set(__self__, "script_options", script_options)
        if use_legacy_sql is not None:
            pulumi.set(__self__, "use_legacy_sql", use_legacy_sql)
        if use_query_cache is not None:
            pulumi.set(__self__, "use_query_cache", use_query_cache)
        if user_defined_function_resources is not None:
            pulumi.set(__self__, "user_defined_function_resources", user_defined_function_resources)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
        *NOTE*: queries containing [DML language](https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language)
        (`DELETE`, `UPDATE`, `MERGE`, `INSERT`) must specify `create_disposition = ""` and `write_disposition = ""`.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="allowLargeResults")
    def allow_large_results(self) -> Optional[bool]:
        """
        If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
        Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
        However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        """
        return pulumi.get(self, "allow_large_results")

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[str]:
        """
        Specifies whether the job is allowed to create new tables. The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion
        Default value is `CREATE_IF_NEEDED`.
        Possible values are: `CREATE_IF_NEEDED`, `CREATE_NEVER`.
        """
        return pulumi.get(self, "create_disposition")

    @property
    @pulumi.getter(name="defaultDataset")
    def default_dataset(self) -> Optional['outputs.JobQueryDefaultDataset']:
        """
        Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
        Structure is documented below.
        """
        return pulumi.get(self, "default_dataset")

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional['outputs.JobQueryDestinationEncryptionConfiguration']:
        """
        Custom encryption configuration (e.g., Cloud KMS keys)
        Structure is documented below.
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> Optional['outputs.JobQueryDestinationTable']:
        """
        Describes the table where the query results should be stored.
        This property must be set for large results that exceed the maximum response size.
        For queries that produce anonymous (cached) results, this field will be populated by BigQuery.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_table")

    @property
    @pulumi.getter(name="flattenResults")
    def flatten_results(self) -> Optional[bool]:
        """
        If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
        allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        """
        return pulumi.get(self, "flatten_results")

    @property
    @pulumi.getter(name="maximumBillingTier")
    def maximum_billing_tier(self) -> Optional[int]:
        """
        Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge).
        If unspecified, this will be set to your project default.
        """
        return pulumi.get(self, "maximum_billing_tier")

    @property
    @pulumi.getter(name="maximumBytesBilled")
    def maximum_bytes_billed(self) -> Optional[str]:
        """
        Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
        If unspecified, this will be set to your project default.
        """
        return pulumi.get(self, "maximum_bytes_billed")

    @property
    @pulumi.getter(name="parameterMode")
    def parameter_mode(self) -> Optional[str]:
        """
        Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        """
        return pulumi.get(self, "parameter_mode")

    @property
    @pulumi.getter
    def priority(self) -> Optional[str]:
        """
        Specifies a priority for the query.
        Default value is `INTERACTIVE`.
        Possible values are: `INTERACTIVE`, `BATCH`.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="schemaUpdateOptions")
    def schema_update_options(self) -> Optional[Sequence[str]]:
        """
        Allows the schema of the destination table to be updated as a side effect of the query job.
        Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
        when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
        specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
        One or more of the following values are specified:
        ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
        ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return pulumi.get(self, "schema_update_options")

    @property
    @pulumi.getter(name="scriptOptions")
    def script_options(self) -> Optional['outputs.JobQueryScriptOptions']:
        """
        Options controlling the execution of scripts.
        Structure is documented below.
        """
        return pulumi.get(self, "script_options")

    @property
    @pulumi.getter(name="useLegacySql")
    def use_legacy_sql(self) -> Optional[bool]:
        """
        Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true.
        If set to false, the query will use BigQuery's standard SQL.
        """
        return pulumi.get(self, "use_legacy_sql")

    @property
    @pulumi.getter(name="useQueryCache")
    def use_query_cache(self) -> Optional[bool]:
        """
        Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever
        tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
        The default value is true.
        """
        return pulumi.get(self, "use_query_cache")

    @property
    @pulumi.getter(name="userDefinedFunctionResources")
    def user_defined_function_resources(self) -> Optional[Sequence['outputs.JobQueryUserDefinedFunctionResource']]:
        """
        Describes user-defined function resources used in the query.
        Structure is documented below.
        """
        return pulumi.get(self, "user_defined_function_resources")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[str]:
        """
        Specifies the action that occurs if the destination table already exists. The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion.
        Default value is `WRITE_EMPTY`.
        Possible values are: `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class JobQueryDefaultDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueryDefaultDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueryDefaultDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueryDefaultDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: Optional[str] = None):
        """
        :param str dataset_id: The dataset. Can be specified `{{dataset_id}}` if `project_id` is also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}` if not.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The dataset. Can be specified `{{dataset_id}}` if `project_id` is also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}` if not.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class JobQueryDestinationEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersion":
            suggest = "kms_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueryDestinationEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueryDestinationEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueryDestinationEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_version: Optional[str] = None):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
               The BigQuery Service Account associated with your project requires access to this encryption key.
        :param str kms_key_version: (Output)
               Describes the Cloud KMS encryption key version used to protect destination BigQuery table.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version is not None:
            pulumi.set(__self__, "kms_key_version", kms_key_version)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> Optional[str]:
        """
        (Output)
        Describes the Cloud KMS encryption key version used to protect destination BigQuery table.
        """
        return pulumi.get(self, "kms_key_version")


@pulumi.output_type
class JobQueryDestinationTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableId":
            suggest = "table_id"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueryDestinationTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueryDestinationTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueryDestinationTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_id: str,
                 dataset_id: Optional[str] = None,
                 project_id: Optional[str] = None):
        """
        :param str table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class JobQueryScriptOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyResultStatement":
            suggest = "key_result_statement"
        elif key == "statementByteBudget":
            suggest = "statement_byte_budget"
        elif key == "statementTimeoutMs":
            suggest = "statement_timeout_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueryScriptOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueryScriptOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueryScriptOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_result_statement: Optional[str] = None,
                 statement_byte_budget: Optional[str] = None,
                 statement_timeout_ms: Optional[str] = None):
        """
        :param str key_result_statement: Determines which statement in the script represents the "key result",
               used to populate the schema and query results of the script job.
               Possible values are: `LAST`, `FIRST_SELECT`.
        :param str statement_byte_budget: Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
        :param str statement_timeout_ms: Timeout period for each statement in a script.
        """
        if key_result_statement is not None:
            pulumi.set(__self__, "key_result_statement", key_result_statement)
        if statement_byte_budget is not None:
            pulumi.set(__self__, "statement_byte_budget", statement_byte_budget)
        if statement_timeout_ms is not None:
            pulumi.set(__self__, "statement_timeout_ms", statement_timeout_ms)

    @property
    @pulumi.getter(name="keyResultStatement")
    def key_result_statement(self) -> Optional[str]:
        """
        Determines which statement in the script represents the "key result",
        used to populate the schema and query results of the script job.
        Possible values are: `LAST`, `FIRST_SELECT`.
        """
        return pulumi.get(self, "key_result_statement")

    @property
    @pulumi.getter(name="statementByteBudget")
    def statement_byte_budget(self) -> Optional[str]:
        """
        Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
        """
        return pulumi.get(self, "statement_byte_budget")

    @property
    @pulumi.getter(name="statementTimeoutMs")
    def statement_timeout_ms(self) -> Optional[str]:
        """
        Timeout period for each statement in a script.
        """
        return pulumi.get(self, "statement_timeout_ms")


@pulumi.output_type
class JobQueryUserDefinedFunctionResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inlineCode":
            suggest = "inline_code"
        elif key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueryUserDefinedFunctionResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueryUserDefinedFunctionResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueryUserDefinedFunctionResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inline_code: Optional[str] = None,
                 resource_uri: Optional[str] = None):
        """
        :param str inline_code: An inline resource that contains code for a user-defined function (UDF).
               Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        :param str resource_uri: A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        if inline_code is not None:
            pulumi.set(__self__, "inline_code", inline_code)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="inlineCode")
    def inline_code(self) -> Optional[str]:
        """
        An inline resource that contains code for a user-defined function (UDF).
        Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        """
        return pulumi.get(self, "inline_code")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class JobStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorResults":
            suggest = "error_results"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_results: Optional[Sequence['outputs.JobStatusErrorResult']] = None,
                 errors: Optional[Sequence['outputs.JobStatusError']] = None,
                 state: Optional[str] = None):
        """
        :param Sequence['JobStatusErrorResultArgs'] error_results: (Output)
               Final error result of the job. If present, indicates that the job has completed and was unsuccessful.
               Structure is documented below.
        :param Sequence['JobStatusErrorArgs'] errors: (Output)
               The first errors encountered during the running of the job. The final message
               includes the number of errors that caused the process to stop. Errors here do
               not necessarily mean that the job has not completed or was unsuccessful.
               Structure is documented below.
        :param str state: (Output)
               Running state of the job. Valid states include 'PENDING', 'RUNNING', and 'DONE'.
        """
        if error_results is not None:
            pulumi.set(__self__, "error_results", error_results)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="errorResults")
    def error_results(self) -> Optional[Sequence['outputs.JobStatusErrorResult']]:
        """
        (Output)
        Final error result of the job. If present, indicates that the job has completed and was unsuccessful.
        Structure is documented below.
        """
        return pulumi.get(self, "error_results")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.JobStatusError']]:
        """
        (Output)
        The first errors encountered during the running of the job. The final message
        includes the number of errors that caused the process to stop. Errors here do
        not necessarily mean that the job has not completed or was unsuccessful.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        Running state of the job. Valid states include 'PENDING', 'RUNNING', and 'DONE'.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class JobStatusError(dict):
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        :param str location: Specifies where the error occurred, if present.
        :param str message: A human-readable description of the error.
        :param str reason: A short error code that summarizes the error.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies where the error occurred, if present.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A human-readable description of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        A short error code that summarizes the error.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class JobStatusErrorResult(dict):
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        :param str location: Specifies where the error occurred, if present.
        :param str message: A human-readable description of the error.
        :param str reason: A short error code that summarizes the error.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies where the error occurred, if present.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A human-readable description of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        A short error code that summarizes the error.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ReservationAutoscale(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentSlots":
            suggest = "current_slots"
        elif key == "maxSlots":
            suggest = "max_slots"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservationAutoscale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservationAutoscale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservationAutoscale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_slots: Optional[int] = None,
                 max_slots: Optional[int] = None):
        """
        :param int current_slots: (Output)
               The slot capacity added to this reservation when autoscale happens. Will be between [0, max_slots].
        :param int max_slots: Number of slots to be scaled when needed.
        """
        if current_slots is not None:
            pulumi.set(__self__, "current_slots", current_slots)
        if max_slots is not None:
            pulumi.set(__self__, "max_slots", max_slots)

    @property
    @pulumi.getter(name="currentSlots")
    def current_slots(self) -> Optional[int]:
        """
        (Output)
        The slot capacity added to this reservation when autoscale happens. Will be between [0, max_slots].
        """
        return pulumi.get(self, "current_slots")

    @property
    @pulumi.getter(name="maxSlots")
    def max_slots(self) -> Optional[int]:
        """
        Number of slots to be scaled when needed.
        """
        return pulumi.get(self, "max_slots")


@pulumi.output_type
class RoutineArgument(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "argumentKind":
            suggest = "argument_kind"
        elif key == "dataType":
            suggest = "data_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutineArgument. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutineArgument.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutineArgument.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 argument_kind: Optional[str] = None,
                 data_type: Optional[str] = None,
                 mode: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str argument_kind: Defaults to FIXED_TYPE.
               Default value is `FIXED_TYPE`.
               Possible values are: `FIXED_TYPE`, `ANY_TYPE`.
        :param str data_type: A JSON schema for the data type. Required unless argumentKind = ANY_TYPE.
               ~>**NOTE**: Because this field expects a JSON string, any changes to the string
               will create a diff, even if the JSON itself hasn't changed. If the API returns
               a different value for the same schema, e.g. it switched the order of values
               or replaced STRUCT field type with RECORD field type, we currently cannot
               suppress the recurring diff this causes. As a workaround, we recommend using
               the schema as returned by the API.
        :param str mode: Specifies whether the argument is input or output. Can be set for procedures only.
               Possible values are: `IN`, `OUT`, `INOUT`.
        :param str name: The name of this argument. Can be absent for function return argument.
        """
        if argument_kind is not None:
            pulumi.set(__self__, "argument_kind", argument_kind)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="argumentKind")
    def argument_kind(self) -> Optional[str]:
        """
        Defaults to FIXED_TYPE.
        Default value is `FIXED_TYPE`.
        Possible values are: `FIXED_TYPE`, `ANY_TYPE`.
        """
        return pulumi.get(self, "argument_kind")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        A JSON schema for the data type. Required unless argumentKind = ANY_TYPE.
        ~>**NOTE**: Because this field expects a JSON string, any changes to the string
        will create a diff, even if the JSON itself hasn't changed. If the API returns
        a different value for the same schema, e.g. it switched the order of values
        or replaced STRUCT field type with RECORD field type, we currently cannot
        suppress the recurring diff this causes. As a workaround, we recommend using
        the schema as returned by the API.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Specifies whether the argument is input or output. Can be set for procedures only.
        Possible values are: `IN`, `OUT`, `INOUT`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of this argument. Can be absent for function return argument.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RoutineRemoteFunctionOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBatchingRows":
            suggest = "max_batching_rows"
        elif key == "userDefinedContext":
            suggest = "user_defined_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutineRemoteFunctionOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutineRemoteFunctionOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutineRemoteFunctionOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 max_batching_rows: Optional[str] = None,
                 user_defined_context: Optional[Mapping[str, str]] = None):
        """
        :param str connection: Fully qualified name of the user-provided connection object which holds
               the authentication information to send requests to the remote service.
               Format: "projects/{projectId}/locations/{locationId}/connections/{connectionId}"
        :param str endpoint: Endpoint of the user-provided remote service, e.g.
               `https://us-east1-my_gcf_project.cloudfunctions.net/remote_add`
        :param str max_batching_rows: Max number of rows in each batch sent to the remote service. If absent or if 0,
               BigQuery dynamically decides the number of rows in a batch.
        :param Mapping[str, str] user_defined_context: User-defined context as a set of key/value pairs, which will be sent as function
               invocation context together with batched arguments in the requests to the remote
               service. The total number of bytes of keys and values must be less than 8KB.
               An object containing a list of "key": value pairs. Example:
               `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        """
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if max_batching_rows is not None:
            pulumi.set(__self__, "max_batching_rows", max_batching_rows)
        if user_defined_context is not None:
            pulumi.set(__self__, "user_defined_context", user_defined_context)

    @property
    @pulumi.getter
    def connection(self) -> Optional[str]:
        """
        Fully qualified name of the user-provided connection object which holds
        the authentication information to send requests to the remote service.
        Format: "projects/{projectId}/locations/{locationId}/connections/{connectionId}"
        """
        return pulumi.get(self, "connection")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Endpoint of the user-provided remote service, e.g.
        `https://us-east1-my_gcf_project.cloudfunctions.net/remote_add`
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="maxBatchingRows")
    def max_batching_rows(self) -> Optional[str]:
        """
        Max number of rows in each batch sent to the remote service. If absent or if 0,
        BigQuery dynamically decides the number of rows in a batch.
        """
        return pulumi.get(self, "max_batching_rows")

    @property
    @pulumi.getter(name="userDefinedContext")
    def user_defined_context(self) -> Optional[Mapping[str, str]]:
        """
        User-defined context as a set of key/value pairs, which will be sent as function
        invocation context together with batched arguments in the requests to the remote
        service. The total number of bytes of keys and values must be less than 8KB.
        An object containing a list of "key": value pairs. Example:
        `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        """
        return pulumi.get(self, "user_defined_context")


@pulumi.output_type
class RoutineSparkOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "containerImage":
            suggest = "container_image"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarUris":
            suggest = "jar_uris"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainFileUri":
            suggest = "main_file_uri"
        elif key == "pyFileUris":
            suggest = "py_file_uris"
        elif key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutineSparkOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutineSparkOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutineSparkOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Optional[Sequence[str]] = None,
                 connection: Optional[str] = None,
                 container_image: Optional[str] = None,
                 file_uris: Optional[Sequence[str]] = None,
                 jar_uris: Optional[Sequence[str]] = None,
                 main_class: Optional[str] = None,
                 main_file_uri: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 py_file_uris: Optional[Sequence[str]] = None,
                 runtime_version: Optional[str] = None):
        """
        :param Sequence[str] archive_uris: Archive files to be extracted into the working directory of each executor. For more information about Apache Spark, see Apache Spark.
        :param str connection: Fully qualified name of the user-provided Spark connection object.
               Format: "projects/{projectId}/locations/{locationId}/connections/{connectionId}"
        :param str container_image: Custom container image for the runtime environment.
        :param Sequence[str] file_uris: Files to be placed in the working directory of each executor. For more information about Apache Spark, see Apache Spark.
        :param Sequence[str] jar_uris: JARs to include on the driver and executor CLASSPATH. For more information about Apache Spark, see Apache Spark.
        :param str main_class: The fully qualified name of a class in jarUris, for example, com.example.wordcount.
               Exactly one of mainClass and main_jar_uri field should be set for Java/Scala language type.
        :param str main_file_uri: The main file/jar URI of the Spark application.
               Exactly one of the definitionBody field and the mainFileUri field must be set for Python.
               Exactly one of mainClass and mainFileUri field should be set for Java/Scala language type.
        :param Mapping[str, str] properties: Configuration properties as a set of key/value pairs, which will be passed on to the Spark application.
               For more information, see Apache Spark and the procedure option list.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param Sequence[str] py_file_uris: Python files to be placed on the PYTHONPATH for PySpark application. Supported file types: .py, .egg, and .zip. For more information about Apache Spark, see Apache Spark.
        :param str runtime_version: Runtime version. If not specified, the default runtime version is used.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_uris is not None:
            pulumi.set(__self__, "jar_uris", jar_uris)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_file_uri is not None:
            pulumi.set(__self__, "main_file_uri", main_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if py_file_uris is not None:
            pulumi.set(__self__, "py_file_uris", py_file_uris)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[Sequence[str]]:
        """
        Archive files to be extracted into the working directory of each executor. For more information about Apache Spark, see Apache Spark.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def connection(self) -> Optional[str]:
        """
        Fully qualified name of the user-provided Spark connection object.
        Format: "projects/{projectId}/locations/{locationId}/connections/{connectionId}"
        """
        return pulumi.get(self, "connection")

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[str]:
        """
        Custom container image for the runtime environment.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[Sequence[str]]:
        """
        Files to be placed in the working directory of each executor. For more information about Apache Spark, see Apache Spark.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarUris")
    def jar_uris(self) -> Optional[Sequence[str]]:
        """
        JARs to include on the driver and executor CLASSPATH. For more information about Apache Spark, see Apache Spark.
        """
        return pulumi.get(self, "jar_uris")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[str]:
        """
        The fully qualified name of a class in jarUris, for example, com.example.wordcount.
        Exactly one of mainClass and main_jar_uri field should be set for Java/Scala language type.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainFileUri")
    def main_file_uri(self) -> Optional[str]:
        """
        The main file/jar URI of the Spark application.
        Exactly one of the definitionBody field and the mainFileUri field must be set for Python.
        Exactly one of mainClass and mainFileUri field should be set for Java/Scala language type.
        """
        return pulumi.get(self, "main_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Configuration properties as a set of key/value pairs, which will be passed on to the Spark application.
        For more information, see Apache Spark and the procedure option list.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="pyFileUris")
    def py_file_uris(self) -> Optional[Sequence[str]]:
        """
        Python files to be placed on the PYTHONPATH for PySpark application. Supported file types: .py, .egg, and .zip. For more information about Apache Spark, see Apache Spark.
        """
        return pulumi.get(self, "py_file_uris")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[str]:
        """
        Runtime version. If not specified, the default runtime version is used.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class TableBiglakeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionId":
            suggest = "connection_id"
        elif key == "fileFormat":
            suggest = "file_format"
        elif key == "storageUri":
            suggest = "storage_uri"
        elif key == "tableFormat":
            suggest = "table_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableBiglakeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableBiglakeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableBiglakeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_id: str,
                 file_format: str,
                 storage_uri: str,
                 table_format: str):
        """
        :param str connection_id: The connection specifying the credentials to be used to
               read and write to external storage, such as Cloud Storage. The connection_id can
               have the form "&lt;project\\_id&gt;.&lt;location\\_id&gt;.&lt;connection\\_id&gt;" or
               projects/&lt;project\\_id&gt;/locations/&lt;location\\_id&gt;/connections/&lt;connection\\_id&gt;".
        :param str file_format: The file format the table data is stored in.
        :param str storage_uri: The fully qualified location prefix of the external folder where table data
               is stored. The '*' wildcard character is not allowed. The URI should be in the format "gs://bucket/path_to_table/"
        :param str table_format: The table format the metadata only snapshots are stored in.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "file_format", file_format)
        pulumi.set(__self__, "storage_uri", storage_uri)
        pulumi.set(__self__, "table_format", table_format)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> str:
        """
        The connection specifying the credentials to be used to
        read and write to external storage, such as Cloud Storage. The connection_id can
        have the form "&lt;project\\_id&gt;.&lt;location\\_id&gt;.&lt;connection\\_id&gt;" or
        projects/&lt;project\\_id&gt;/locations/&lt;location\\_id&gt;/connections/&lt;connection\\_id&gt;".
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> str:
        """
        The file format the table data is stored in.
        """
        return pulumi.get(self, "file_format")

    @property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> str:
        """
        The fully qualified location prefix of the external folder where table data
        is stored. The '*' wildcard character is not allowed. The URI should be in the format "gs://bucket/path_to_table/"
        """
        return pulumi.get(self, "storage_uri")

    @property
    @pulumi.getter(name="tableFormat")
    def table_format(self) -> str:
        """
        The table format the metadata only snapshots are stored in.
        """
        return pulumi.get(self, "table_format")


@pulumi.output_type
class TableEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersion":
            suggest = "kms_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 kms_key_version: Optional[str] = None):
        """
        :param str kms_key_name: The self link or full name of a key which should be used to
               encrypt this table.  Note that the default bigquery service account will need to have
               encrypt/decrypt permissions on this key - you may want to see the
               `bigquery_get_default_service_account` datasource and the
               `kms.CryptoKeyIAMBinding` resource.
        :param str kms_key_version: The self link or full name of the kms key version used to encrypt this table.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version is not None:
            pulumi.set(__self__, "kms_key_version", kms_key_version)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The self link or full name of a key which should be used to
        encrypt this table.  Note that the default bigquery service account will need to have
        encrypt/decrypt permissions on this key - you may want to see the
        `bigquery_get_default_service_account` datasource and the
        `kms.CryptoKeyIAMBinding` resource.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> Optional[str]:
        """
        The self link or full name of the kms key version used to encrypt this table.
        """
        return pulumi.get(self, "kms_key_version")


@pulumi.output_type
class TableExternalDataConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceUris":
            suggest = "source_uris"
        elif key == "avroOptions":
            suggest = "avro_options"
        elif key == "bigtableOptions":
            suggest = "bigtable_options"
        elif key == "connectionId":
            suggest = "connection_id"
        elif key == "csvOptions":
            suggest = "csv_options"
        elif key == "fileSetSpecType":
            suggest = "file_set_spec_type"
        elif key == "googleSheetsOptions":
            suggest = "google_sheets_options"
        elif key == "hivePartitioningOptions":
            suggest = "hive_partitioning_options"
        elif key == "ignoreUnknownValues":
            suggest = "ignore_unknown_values"
        elif key == "jsonExtension":
            suggest = "json_extension"
        elif key == "jsonOptions":
            suggest = "json_options"
        elif key == "maxBadRecords":
            suggest = "max_bad_records"
        elif key == "metadataCacheMode":
            suggest = "metadata_cache_mode"
        elif key == "objectMetadata":
            suggest = "object_metadata"
        elif key == "parquetOptions":
            suggest = "parquet_options"
        elif key == "referenceFileSchemaUri":
            suggest = "reference_file_schema_uri"
        elif key == "sourceFormat":
            suggest = "source_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autodetect: bool,
                 source_uris: Sequence[str],
                 avro_options: Optional['outputs.TableExternalDataConfigurationAvroOptions'] = None,
                 bigtable_options: Optional['outputs.TableExternalDataConfigurationBigtableOptions'] = None,
                 compression: Optional[str] = None,
                 connection_id: Optional[str] = None,
                 csv_options: Optional['outputs.TableExternalDataConfigurationCsvOptions'] = None,
                 file_set_spec_type: Optional[str] = None,
                 google_sheets_options: Optional['outputs.TableExternalDataConfigurationGoogleSheetsOptions'] = None,
                 hive_partitioning_options: Optional['outputs.TableExternalDataConfigurationHivePartitioningOptions'] = None,
                 ignore_unknown_values: Optional[bool] = None,
                 json_extension: Optional[str] = None,
                 json_options: Optional['outputs.TableExternalDataConfigurationJsonOptions'] = None,
                 max_bad_records: Optional[int] = None,
                 metadata_cache_mode: Optional[str] = None,
                 object_metadata: Optional[str] = None,
                 parquet_options: Optional['outputs.TableExternalDataConfigurationParquetOptions'] = None,
                 reference_file_schema_uri: Optional[str] = None,
                 schema: Optional[str] = None,
                 source_format: Optional[str] = None):
        """
        :param bool autodetect: Let BigQuery try to autodetect the schema
               and format of the table.
        :param Sequence[str] source_uris: A list of the fully-qualified URIs that point to
               your data in Google Cloud.
        :param 'TableExternalDataConfigurationAvroOptionsArgs' avro_options: Additional options if `source_format` is set to
               "AVRO".  Structure is documented below.
        :param 'TableExternalDataConfigurationBigtableOptionsArgs' bigtable_options: Additional properties to set if
               `source_format` is set to "BIGTABLE". Structure is documented below.
        :param str compression: The compression type of the data source.
               Valid values are "NONE" or "GZIP".
        :param str connection_id: The connection specifying the credentials to be used to read
               external storage, such as Azure Blob, Cloud Storage, or S3. The `connection_id` can have
               the form `{{project}}.{{location}}.{{connection_id}}`
               or `projects/{{project}}/locations/{{location}}/connections/{{connection_id}}`.
               
               ~>**NOTE:** If you set `external_data_configuration.connection_id`, the
               table schema must be specified using the top-level `schema` field
               documented above.
        :param 'TableExternalDataConfigurationCsvOptionsArgs' csv_options: Additional properties to set if
               `source_format` is set to "CSV". Structure is documented below.
        :param str file_set_spec_type: Specifies how source URIs are interpreted for constructing the file set to load.
               By default source URIs are expanded against the underlying storage.
               Other options include specifying manifest files. Only applicable to object storage systems. Docs
        :param 'TableExternalDataConfigurationGoogleSheetsOptionsArgs' google_sheets_options: Additional options if
               `source_format` is set to "GOOGLE_SHEETS". Structure is
               documented below.
        :param 'TableExternalDataConfigurationHivePartitioningOptionsArgs' hive_partitioning_options: When set, configures hive partitioning
               support. Not all storage formats support hive partitioning -- requesting hive
               partitioning on an unsupported format will lead to an error, as will providing
               an invalid specification. Structure is documented below.
        :param bool ignore_unknown_values: Indicates if BigQuery should
               allow extra values that are not represented in the table schema.
               If true, the extra values are ignored. If false, records with
               extra columns are treated as bad records, and if there are too
               many bad records, an invalid error is returned in the job result.
               The default value is false.
        :param str json_extension: Used to indicate that a JSON variant, rather than normal JSON, is being used as the sourceFormat. This should only be used in combination with the `JSON` source format. Valid values are: `GEOJSON`.
        :param 'TableExternalDataConfigurationJsonOptionsArgs' json_options: Additional properties to set if
               `source_format` is set to "JSON". Structure is documented below.
        :param int max_bad_records: The maximum number of bad records that
               BigQuery can ignore when reading data.
        :param str metadata_cache_mode: Metadata Cache Mode for the table. Set this to enable caching of metadata from external data source. Valid values are `AUTOMATIC` and `MANUAL`.
        :param str object_metadata: Object Metadata is used to create Object Tables. Object Tables contain a listing of objects (with their metadata) found at the sourceUris. If `object_metadata` is set, `source_format` should be omitted.
        :param 'TableExternalDataConfigurationParquetOptionsArgs' parquet_options: Additional properties to set if
               `source_format` is set to "PARQUET". Structure is documented below.
        :param str reference_file_schema_uri: When creating an external table, the user can provide a reference file with the table schema. This is enabled for the following formats: AVRO, PARQUET, ORC.
        :param str schema: A JSON schema for the external table. Schema is required
               for CSV and JSON formats if autodetect is not on. Schema is disallowed
               for Google Cloud Bigtable, Cloud Datastore backups, Avro, Iceberg, ORC and Parquet formats.
               ~>**NOTE:** Because this field expects a JSON string, any changes to the
               string will create a diff, even if the JSON itself hasn't changed.
               Furthermore drift for this field cannot not be detected because BigQuery
               only uses this schema to compute the effective schema for the table, therefore
               any changes on the configured value will force the table to be recreated.
               This schema is effectively only applied when creating a table from an external
               datasource, after creation the computed schema will be stored in
               `google_bigquery_table.schema`
               
               ~>**NOTE:** If you set `external_data_configuration.connection_id`, the
               table schema must be specified using the top-level `schema` field
               documented above.
        :param str source_format: The data format. Please see sourceFormat under
               [ExternalDataConfiguration](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#externaldataconfiguration)
               in Bigquery's public API documentation for supported formats. To use "GOOGLE_SHEETS"
               the `scopes` must include "https://www.googleapis.com/auth/drive.readonly".
        """
        pulumi.set(__self__, "autodetect", autodetect)
        pulumi.set(__self__, "source_uris", source_uris)
        if avro_options is not None:
            pulumi.set(__self__, "avro_options", avro_options)
        if bigtable_options is not None:
            pulumi.set(__self__, "bigtable_options", bigtable_options)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if csv_options is not None:
            pulumi.set(__self__, "csv_options", csv_options)
        if file_set_spec_type is not None:
            pulumi.set(__self__, "file_set_spec_type", file_set_spec_type)
        if google_sheets_options is not None:
            pulumi.set(__self__, "google_sheets_options", google_sheets_options)
        if hive_partitioning_options is not None:
            pulumi.set(__self__, "hive_partitioning_options", hive_partitioning_options)
        if ignore_unknown_values is not None:
            pulumi.set(__self__, "ignore_unknown_values", ignore_unknown_values)
        if json_extension is not None:
            pulumi.set(__self__, "json_extension", json_extension)
        if json_options is not None:
            pulumi.set(__self__, "json_options", json_options)
        if max_bad_records is not None:
            pulumi.set(__self__, "max_bad_records", max_bad_records)
        if metadata_cache_mode is not None:
            pulumi.set(__self__, "metadata_cache_mode", metadata_cache_mode)
        if object_metadata is not None:
            pulumi.set(__self__, "object_metadata", object_metadata)
        if parquet_options is not None:
            pulumi.set(__self__, "parquet_options", parquet_options)
        if reference_file_schema_uri is not None:
            pulumi.set(__self__, "reference_file_schema_uri", reference_file_schema_uri)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if source_format is not None:
            pulumi.set(__self__, "source_format", source_format)

    @property
    @pulumi.getter
    def autodetect(self) -> bool:
        """
        Let BigQuery try to autodetect the schema
        and format of the table.
        """
        return pulumi.get(self, "autodetect")

    @property
    @pulumi.getter(name="sourceUris")
    def source_uris(self) -> Sequence[str]:
        """
        A list of the fully-qualified URIs that point to
        your data in Google Cloud.
        """
        return pulumi.get(self, "source_uris")

    @property
    @pulumi.getter(name="avroOptions")
    def avro_options(self) -> Optional['outputs.TableExternalDataConfigurationAvroOptions']:
        """
        Additional options if `source_format` is set to
        "AVRO".  Structure is documented below.
        """
        return pulumi.get(self, "avro_options")

    @property
    @pulumi.getter(name="bigtableOptions")
    def bigtable_options(self) -> Optional['outputs.TableExternalDataConfigurationBigtableOptions']:
        """
        Additional properties to set if
        `source_format` is set to "BIGTABLE". Structure is documented below.
        """
        return pulumi.get(self, "bigtable_options")

    @property
    @pulumi.getter
    def compression(self) -> Optional[str]:
        """
        The compression type of the data source.
        Valid values are "NONE" or "GZIP".
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[str]:
        """
        The connection specifying the credentials to be used to read
        external storage, such as Azure Blob, Cloud Storage, or S3. The `connection_id` can have
        the form `{{project}}.{{location}}.{{connection_id}}`
        or `projects/{{project}}/locations/{{location}}/connections/{{connection_id}}`.

        ~>**NOTE:** If you set `external_data_configuration.connection_id`, the
        table schema must be specified using the top-level `schema` field
        documented above.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> Optional['outputs.TableExternalDataConfigurationCsvOptions']:
        """
        Additional properties to set if
        `source_format` is set to "CSV". Structure is documented below.
        """
        return pulumi.get(self, "csv_options")

    @property
    @pulumi.getter(name="fileSetSpecType")
    def file_set_spec_type(self) -> Optional[str]:
        """
        Specifies how source URIs are interpreted for constructing the file set to load.
        By default source URIs are expanded against the underlying storage.
        Other options include specifying manifest files. Only applicable to object storage systems. Docs
        """
        return pulumi.get(self, "file_set_spec_type")

    @property
    @pulumi.getter(name="googleSheetsOptions")
    def google_sheets_options(self) -> Optional['outputs.TableExternalDataConfigurationGoogleSheetsOptions']:
        """
        Additional options if
        `source_format` is set to "GOOGLE_SHEETS". Structure is
        documented below.
        """
        return pulumi.get(self, "google_sheets_options")

    @property
    @pulumi.getter(name="hivePartitioningOptions")
    def hive_partitioning_options(self) -> Optional['outputs.TableExternalDataConfigurationHivePartitioningOptions']:
        """
        When set, configures hive partitioning
        support. Not all storage formats support hive partitioning -- requesting hive
        partitioning on an unsupported format will lead to an error, as will providing
        an invalid specification. Structure is documented below.
        """
        return pulumi.get(self, "hive_partitioning_options")

    @property
    @pulumi.getter(name="ignoreUnknownValues")
    def ignore_unknown_values(self) -> Optional[bool]:
        """
        Indicates if BigQuery should
        allow extra values that are not represented in the table schema.
        If true, the extra values are ignored. If false, records with
        extra columns are treated as bad records, and if there are too
        many bad records, an invalid error is returned in the job result.
        The default value is false.
        """
        return pulumi.get(self, "ignore_unknown_values")

    @property
    @pulumi.getter(name="jsonExtension")
    def json_extension(self) -> Optional[str]:
        """
        Used to indicate that a JSON variant, rather than normal JSON, is being used as the sourceFormat. This should only be used in combination with the `JSON` source format. Valid values are: `GEOJSON`.
        """
        return pulumi.get(self, "json_extension")

    @property
    @pulumi.getter(name="jsonOptions")
    def json_options(self) -> Optional['outputs.TableExternalDataConfigurationJsonOptions']:
        """
        Additional properties to set if
        `source_format` is set to "JSON". Structure is documented below.
        """
        return pulumi.get(self, "json_options")

    @property
    @pulumi.getter(name="maxBadRecords")
    def max_bad_records(self) -> Optional[int]:
        """
        The maximum number of bad records that
        BigQuery can ignore when reading data.
        """
        return pulumi.get(self, "max_bad_records")

    @property
    @pulumi.getter(name="metadataCacheMode")
    def metadata_cache_mode(self) -> Optional[str]:
        """
        Metadata Cache Mode for the table. Set this to enable caching of metadata from external data source. Valid values are `AUTOMATIC` and `MANUAL`.
        """
        return pulumi.get(self, "metadata_cache_mode")

    @property
    @pulumi.getter(name="objectMetadata")
    def object_metadata(self) -> Optional[str]:
        """
        Object Metadata is used to create Object Tables. Object Tables contain a listing of objects (with their metadata) found at the sourceUris. If `object_metadata` is set, `source_format` should be omitted.
        """
        return pulumi.get(self, "object_metadata")

    @property
    @pulumi.getter(name="parquetOptions")
    def parquet_options(self) -> Optional['outputs.TableExternalDataConfigurationParquetOptions']:
        """
        Additional properties to set if
        `source_format` is set to "PARQUET". Structure is documented below.
        """
        return pulumi.get(self, "parquet_options")

    @property
    @pulumi.getter(name="referenceFileSchemaUri")
    def reference_file_schema_uri(self) -> Optional[str]:
        """
        When creating an external table, the user can provide a reference file with the table schema. This is enabled for the following formats: AVRO, PARQUET, ORC.
        """
        return pulumi.get(self, "reference_file_schema_uri")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        A JSON schema for the external table. Schema is required
        for CSV and JSON formats if autodetect is not on. Schema is disallowed
        for Google Cloud Bigtable, Cloud Datastore backups, Avro, Iceberg, ORC and Parquet formats.
        ~>**NOTE:** Because this field expects a JSON string, any changes to the
        string will create a diff, even if the JSON itself hasn't changed.
        Furthermore drift for this field cannot not be detected because BigQuery
        only uses this schema to compute the effective schema for the table, therefore
        any changes on the configured value will force the table to be recreated.
        This schema is effectively only applied when creating a table from an external
        datasource, after creation the computed schema will be stored in
        `google_bigquery_table.schema`

        ~>**NOTE:** If you set `external_data_configuration.connection_id`, the
        table schema must be specified using the top-level `schema` field
        documented above.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> Optional[str]:
        """
        The data format. Please see sourceFormat under
        [ExternalDataConfiguration](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#externaldataconfiguration)
        in Bigquery's public API documentation for supported formats. To use "GOOGLE_SHEETS"
        the `scopes` must include "https://www.googleapis.com/auth/drive.readonly".
        """
        return pulumi.get(self, "source_format")


@pulumi.output_type
class TableExternalDataConfigurationAvroOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useAvroLogicalTypes":
            suggest = "use_avro_logical_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfigurationAvroOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfigurationAvroOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfigurationAvroOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_avro_logical_types: bool):
        """
        :param bool use_avro_logical_types: If is set to true, indicates whether
               to interpret logical types as the corresponding BigQuery data type
               (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        """
        pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> bool:
        """
        If is set to true, indicates whether
        to interpret logical types as the corresponding BigQuery data type
        (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
        """
        return pulumi.get(self, "use_avro_logical_types")


@pulumi.output_type
class TableExternalDataConfigurationBigtableOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnFamilies":
            suggest = "column_families"
        elif key == "ignoreUnspecifiedColumnFamilies":
            suggest = "ignore_unspecified_column_families"
        elif key == "outputColumnFamiliesAsJson":
            suggest = "output_column_families_as_json"
        elif key == "readRowkeyAsString":
            suggest = "read_rowkey_as_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfigurationBigtableOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfigurationBigtableOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfigurationBigtableOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_families: Optional[Sequence['outputs.TableExternalDataConfigurationBigtableOptionsColumnFamily']] = None,
                 ignore_unspecified_column_families: Optional[bool] = None,
                 output_column_families_as_json: Optional[bool] = None,
                 read_rowkey_as_string: Optional[bool] = None):
        """
        :param Sequence['TableExternalDataConfigurationBigtableOptionsColumnFamilyArgs'] column_families: A list of column families to expose in the table schema along with their types. This list restricts the column families that can be referenced in queries and specifies their value types. You can use this list to do type conversions - see the 'type' field for more details. If you leave this list empty, all column families are present in the table schema and their values are read as BYTES. During a query only the column families referenced in that query are read from Bigtable.  Structure is documented below.
        :param bool ignore_unspecified_column_families: If field is true, then the column families that are not specified in columnFamilies list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The default value is false.
        :param bool output_column_families_as_json: If field is true, then each column family will be read as a single JSON column. Otherwise they are read as a repeated cell structure containing timestamp/value tuples. The default value is false.
        :param bool read_rowkey_as_string: If field is true, then the rowkey column families will be read and converted to string. Otherwise they are read with BYTES type values and users need to manually cast them with CAST if necessary. The default value is false.
        """
        if column_families is not None:
            pulumi.set(__self__, "column_families", column_families)
        if ignore_unspecified_column_families is not None:
            pulumi.set(__self__, "ignore_unspecified_column_families", ignore_unspecified_column_families)
        if output_column_families_as_json is not None:
            pulumi.set(__self__, "output_column_families_as_json", output_column_families_as_json)
        if read_rowkey_as_string is not None:
            pulumi.set(__self__, "read_rowkey_as_string", read_rowkey_as_string)

    @property
    @pulumi.getter(name="columnFamilies")
    def column_families(self) -> Optional[Sequence['outputs.TableExternalDataConfigurationBigtableOptionsColumnFamily']]:
        """
        A list of column families to expose in the table schema along with their types. This list restricts the column families that can be referenced in queries and specifies their value types. You can use this list to do type conversions - see the 'type' field for more details. If you leave this list empty, all column families are present in the table schema and their values are read as BYTES. During a query only the column families referenced in that query are read from Bigtable.  Structure is documented below.
        """
        return pulumi.get(self, "column_families")

    @property
    @pulumi.getter(name="ignoreUnspecifiedColumnFamilies")
    def ignore_unspecified_column_families(self) -> Optional[bool]:
        """
        If field is true, then the column families that are not specified in columnFamilies list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The default value is false.
        """
        return pulumi.get(self, "ignore_unspecified_column_families")

    @property
    @pulumi.getter(name="outputColumnFamiliesAsJson")
    def output_column_families_as_json(self) -> Optional[bool]:
        """
        If field is true, then each column family will be read as a single JSON column. Otherwise they are read as a repeated cell structure containing timestamp/value tuples. The default value is false.
        """
        return pulumi.get(self, "output_column_families_as_json")

    @property
    @pulumi.getter(name="readRowkeyAsString")
    def read_rowkey_as_string(self) -> Optional[bool]:
        """
        If field is true, then the rowkey column families will be read and converted to string. Otherwise they are read with BYTES type values and users need to manually cast them with CAST if necessary. The default value is false.
        """
        return pulumi.get(self, "read_rowkey_as_string")


@pulumi.output_type
class TableExternalDataConfigurationBigtableOptionsColumnFamily(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "familyId":
            suggest = "family_id"
        elif key == "onlyReadLatest":
            suggest = "only_read_latest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfigurationBigtableOptionsColumnFamily. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfigurationBigtableOptionsColumnFamily.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfigurationBigtableOptionsColumnFamily.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.TableExternalDataConfigurationBigtableOptionsColumnFamilyColumn']] = None,
                 encoding: Optional[str] = None,
                 family_id: Optional[str] = None,
                 only_read_latest: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param Sequence['TableExternalDataConfigurationBigtableOptionsColumnFamilyColumnArgs'] columns: A List of columns that should be exposed as individual fields as opposed to a list of (column name, value) pairs. All columns whose qualifier matches a qualifier in this list can be accessed as Other columns can be accessed as a list through column field.  Structure is documented below.
        :param str encoding: The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. This can be overridden for a specific column by listing that column in 'columns' and specifying an encoding for it.
        :param str family_id: Identifier of the column family.
        :param bool only_read_latest: If this is set only the latest version of value are exposed for all columns in this column family. This can be overridden for a specific column by listing that column in 'columns' and specifying a different setting for that column.
        :param str type: The type to convert the value in cells of this column family. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive): "BYTES", "STRING", "INTEGER", "FLOAT", "BOOLEAN", "JSON". Default type is BYTES. This can be overridden for a specific column by listing that column in 'columns' and specifying a type for it.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if family_id is not None:
            pulumi.set(__self__, "family_id", family_id)
        if only_read_latest is not None:
            pulumi.set(__self__, "only_read_latest", only_read_latest)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.TableExternalDataConfigurationBigtableOptionsColumnFamilyColumn']]:
        """
        A List of columns that should be exposed as individual fields as opposed to a list of (column name, value) pairs. All columns whose qualifier matches a qualifier in this list can be accessed as Other columns can be accessed as a list through column field.  Structure is documented below.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. This can be overridden for a specific column by listing that column in 'columns' and specifying an encoding for it.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="familyId")
    def family_id(self) -> Optional[str]:
        """
        Identifier of the column family.
        """
        return pulumi.get(self, "family_id")

    @property
    @pulumi.getter(name="onlyReadLatest")
    def only_read_latest(self) -> Optional[bool]:
        """
        If this is set only the latest version of value are exposed for all columns in this column family. This can be overridden for a specific column by listing that column in 'columns' and specifying a different setting for that column.
        """
        return pulumi.get(self, "only_read_latest")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type to convert the value in cells of this column family. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive): "BYTES", "STRING", "INTEGER", "FLOAT", "BOOLEAN", "JSON". Default type is BYTES. This can be overridden for a specific column by listing that column in 'columns' and specifying a type for it.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableExternalDataConfigurationBigtableOptionsColumnFamilyColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldName":
            suggest = "field_name"
        elif key == "onlyReadLatest":
            suggest = "only_read_latest"
        elif key == "qualifierEncoded":
            suggest = "qualifier_encoded"
        elif key == "qualifierString":
            suggest = "qualifier_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfigurationBigtableOptionsColumnFamilyColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfigurationBigtableOptionsColumnFamilyColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfigurationBigtableOptionsColumnFamilyColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoding: Optional[str] = None,
                 field_name: Optional[str] = None,
                 only_read_latest: Optional[bool] = None,
                 qualifier_encoded: Optional[str] = None,
                 qualifier_string: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str encoding: The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. 'encoding' can also be set at the column family level. However, the setting at this level takes precedence if 'encoding' is set at both levels.
        :param str field_name: If the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as the column field name and is used as field name in queries.
        :param bool only_read_latest: If this is set, only the latest version of value in this column are exposed. 'onlyReadLatest' can also be set at the column family level. However, the setting at this level takes precedence if 'onlyReadLatest' is set at both levels.
        :param str qualifier_encoded: Qualifier of the column. Columns in the parent column family that has this exact qualifier are exposed as . field. If the qualifier is valid UTF-8 string, it can be specified in the qualifierString field. Otherwise, a base-64 encoded value must be set to qualifierEncoded. The column field name is the same as the column qualifier. However, if the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as fieldName.
        :param str qualifier_string: Qualifier string.
        :param str type: The type to convert the value in cells of this column. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive): "BYTES", "STRING", "INTEGER", "FLOAT", "BOOLEAN", "JSON", Default type is "BYTES". 'type' can also be set at the column family level. However, the setting at this level takes precedence if 'type' is set at both levels.
        """
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_name is not None:
            pulumi.set(__self__, "field_name", field_name)
        if only_read_latest is not None:
            pulumi.set(__self__, "only_read_latest", only_read_latest)
        if qualifier_encoded is not None:
            pulumi.set(__self__, "qualifier_encoded", qualifier_encoded)
        if qualifier_string is not None:
            pulumi.set(__self__, "qualifier_string", qualifier_string)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. 'encoding' can also be set at the column family level. However, the setting at this level takes precedence if 'encoding' is set at both levels.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> Optional[str]:
        """
        If the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as the column field name and is used as field name in queries.
        """
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter(name="onlyReadLatest")
    def only_read_latest(self) -> Optional[bool]:
        """
        If this is set, only the latest version of value in this column are exposed. 'onlyReadLatest' can also be set at the column family level. However, the setting at this level takes precedence if 'onlyReadLatest' is set at both levels.
        """
        return pulumi.get(self, "only_read_latest")

    @property
    @pulumi.getter(name="qualifierEncoded")
    def qualifier_encoded(self) -> Optional[str]:
        """
        Qualifier of the column. Columns in the parent column family that has this exact qualifier are exposed as . field. If the qualifier is valid UTF-8 string, it can be specified in the qualifierString field. Otherwise, a base-64 encoded value must be set to qualifierEncoded. The column field name is the same as the column qualifier. However, if the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as fieldName.
        """
        return pulumi.get(self, "qualifier_encoded")

    @property
    @pulumi.getter(name="qualifierString")
    def qualifier_string(self) -> Optional[str]:
        """
        Qualifier string.
        """
        return pulumi.get(self, "qualifier_string")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type to convert the value in cells of this column. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive): "BYTES", "STRING", "INTEGER", "FLOAT", "BOOLEAN", "JSON", Default type is "BYTES". 'type' can also be set at the column family level. However, the setting at this level takes precedence if 'type' is set at both levels.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableExternalDataConfigurationCsvOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowJaggedRows":
            suggest = "allow_jagged_rows"
        elif key == "allowQuotedNewlines":
            suggest = "allow_quoted_newlines"
        elif key == "fieldDelimiter":
            suggest = "field_delimiter"
        elif key == "skipLeadingRows":
            suggest = "skip_leading_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfigurationCsvOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfigurationCsvOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfigurationCsvOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quote: str,
                 allow_jagged_rows: Optional[bool] = None,
                 allow_quoted_newlines: Optional[bool] = None,
                 encoding: Optional[str] = None,
                 field_delimiter: Optional[str] = None,
                 skip_leading_rows: Optional[int] = None):
        """
        :param str quote: The value that is used to quote data sections in a
               CSV file. If your data does not contain quoted sections, set the
               property value to an empty string. If your data contains quoted newline
               characters, you must also set the `allow_quoted_newlines` property to true.
               The API-side default is `"`, specified in the provider escaped as `\\"`. Due to
               limitations with default values, this value is required to be
               explicitly set.
        :param bool allow_jagged_rows: Indicates if BigQuery should accept rows
               that are missing trailing optional columns.
        :param bool allow_quoted_newlines: Indicates if BigQuery should allow
               quoted data sections that contain newline characters in a CSV file.
               The default value is false.
        :param str encoding: The character encoding of the data. The supported
               values are UTF-8 or ISO-8859-1.
        :param str field_delimiter: The separator for fields in a CSV file.
        :param int skip_leading_rows: The number of rows at the top of a CSV
               file that BigQuery will skip when reading the data.
        """
        pulumi.set(__self__, "quote", quote)
        if allow_jagged_rows is not None:
            pulumi.set(__self__, "allow_jagged_rows", allow_jagged_rows)
        if allow_quoted_newlines is not None:
            pulumi.set(__self__, "allow_quoted_newlines", allow_quoted_newlines)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)

    @property
    @pulumi.getter
    def quote(self) -> str:
        """
        The value that is used to quote data sections in a
        CSV file. If your data does not contain quoted sections, set the
        property value to an empty string. If your data contains quoted newline
        characters, you must also set the `allow_quoted_newlines` property to true.
        The API-side default is `"`, specified in the provider escaped as `\\"`. Due to
        limitations with default values, this value is required to be
        explicitly set.
        """
        return pulumi.get(self, "quote")

    @property
    @pulumi.getter(name="allowJaggedRows")
    def allow_jagged_rows(self) -> Optional[bool]:
        """
        Indicates if BigQuery should accept rows
        that are missing trailing optional columns.
        """
        return pulumi.get(self, "allow_jagged_rows")

    @property
    @pulumi.getter(name="allowQuotedNewlines")
    def allow_quoted_newlines(self) -> Optional[bool]:
        """
        Indicates if BigQuery should allow
        quoted data sections that contain newline characters in a CSV file.
        The default value is false.
        """
        return pulumi.get(self, "allow_quoted_newlines")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        The character encoding of the data. The supported
        values are UTF-8 or ISO-8859-1.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[str]:
        """
        The separator for fields in a CSV file.
        """
        return pulumi.get(self, "field_delimiter")

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[int]:
        """
        The number of rows at the top of a CSV
        file that BigQuery will skip when reading the data.
        """
        return pulumi.get(self, "skip_leading_rows")


@pulumi.output_type
class TableExternalDataConfigurationGoogleSheetsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "skipLeadingRows":
            suggest = "skip_leading_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfigurationGoogleSheetsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfigurationGoogleSheetsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfigurationGoogleSheetsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 range: Optional[str] = None,
                 skip_leading_rows: Optional[int] = None):
        """
        :param str range: Range of a sheet to query from. Only used when
               non-empty. At least one of `range` or `skip_leading_rows` must be set.
               Typical format: "sheet_name!top_left_cell_id:bottom_right_cell_id"
               For example: "sheet1!A1:B20"
        :param int skip_leading_rows: The number of rows at the top of the sheet
               that BigQuery will skip when reading the data. At least one of `range` or
               `skip_leading_rows` must be set.
        """
        if range is not None:
            pulumi.set(__self__, "range", range)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)

    @property
    @pulumi.getter
    def range(self) -> Optional[str]:
        """
        Range of a sheet to query from. Only used when
        non-empty. At least one of `range` or `skip_leading_rows` must be set.
        Typical format: "sheet_name!top_left_cell_id:bottom_right_cell_id"
        For example: "sheet1!A1:B20"
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[int]:
        """
        The number of rows at the top of the sheet
        that BigQuery will skip when reading the data. At least one of `range` or
        `skip_leading_rows` must be set.
        """
        return pulumi.get(self, "skip_leading_rows")


@pulumi.output_type
class TableExternalDataConfigurationHivePartitioningOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requirePartitionFilter":
            suggest = "require_partition_filter"
        elif key == "sourceUriPrefix":
            suggest = "source_uri_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfigurationHivePartitioningOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfigurationHivePartitioningOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfigurationHivePartitioningOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 require_partition_filter: Optional[bool] = None,
                 source_uri_prefix: Optional[str] = None):
        """
        :param str mode: When set, what mode of hive partitioning to use when
               reading data. The following modes are supported.
               * AUTO: automatically infer partition key name(s) and type(s).
               * STRINGS: automatically infer partition key name(s). All types are
               Not all storage formats support hive partitioning. Requesting hive
               partitioning on an unsupported format will lead to an error.
               Currently supported formats are: JSON, CSV, ORC, Avro and Parquet.
               * CUSTOM: when set to `CUSTOM`, you must encode the partition key schema within the `source_uri_prefix` by setting `source_uri_prefix` to `gs://bucket/path_to_table/{key1:TYPE1}/{key2:TYPE2}/{key3:TYPE3}`.
        :param bool require_partition_filter: If set to true, queries over this table
               require a partition filter that can be used for partition elimination to be
               specified.
        :param str source_uri_prefix: When hive partition detection is requested,
               a common for all source uris must be required. The prefix must end immediately
               before the partition key encoding begins. For example, consider files following
               this data layout. `gs://bucket/path_to_table/dt=2019-06-01/country=USA/id=7/file.avro`
               `gs://bucket/path_to_table/dt=2019-05-31/country=CA/id=3/file.avro` When hive
               partitioning is requested with either AUTO or STRINGS detection, the common prefix
               can be either of `gs://bucket/path_to_table` or `gs://bucket/path_to_table/`.
               Note that when `mode` is set to `CUSTOM`, you must encode the partition key schema within the `source_uri_prefix` by setting `source_uri_prefix` to `gs://bucket/path_to_table/{key1:TYPE1}/{key2:TYPE2}/{key3:TYPE3}`.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if require_partition_filter is not None:
            pulumi.set(__self__, "require_partition_filter", require_partition_filter)
        if source_uri_prefix is not None:
            pulumi.set(__self__, "source_uri_prefix", source_uri_prefix)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        When set, what mode of hive partitioning to use when
        reading data. The following modes are supported.
        * AUTO: automatically infer partition key name(s) and type(s).
        * STRINGS: automatically infer partition key name(s). All types are
        Not all storage formats support hive partitioning. Requesting hive
        partitioning on an unsupported format will lead to an error.
        Currently supported formats are: JSON, CSV, ORC, Avro and Parquet.
        * CUSTOM: when set to `CUSTOM`, you must encode the partition key schema within the `source_uri_prefix` by setting `source_uri_prefix` to `gs://bucket/path_to_table/{key1:TYPE1}/{key2:TYPE2}/{key3:TYPE3}`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> Optional[bool]:
        """
        If set to true, queries over this table
        require a partition filter that can be used for partition elimination to be
        specified.
        """
        return pulumi.get(self, "require_partition_filter")

    @property
    @pulumi.getter(name="sourceUriPrefix")
    def source_uri_prefix(self) -> Optional[str]:
        """
        When hive partition detection is requested,
        a common for all source uris must be required. The prefix must end immediately
        before the partition key encoding begins. For example, consider files following
        this data layout. `gs://bucket/path_to_table/dt=2019-06-01/country=USA/id=7/file.avro`
        `gs://bucket/path_to_table/dt=2019-05-31/country=CA/id=3/file.avro` When hive
        partitioning is requested with either AUTO or STRINGS detection, the common prefix
        can be either of `gs://bucket/path_to_table` or `gs://bucket/path_to_table/`.
        Note that when `mode` is set to `CUSTOM`, you must encode the partition key schema within the `source_uri_prefix` by setting `source_uri_prefix` to `gs://bucket/path_to_table/{key1:TYPE1}/{key2:TYPE2}/{key3:TYPE3}`.
        """
        return pulumi.get(self, "source_uri_prefix")


@pulumi.output_type
class TableExternalDataConfigurationJsonOptions(dict):
    def __init__(__self__, *,
                 encoding: Optional[str] = None):
        """
        :param str encoding: The character encoding of the data. The supported values are UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The default value is UTF-8.
        """
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        The character encoding of the data. The supported values are UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The default value is UTF-8.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class TableExternalDataConfigurationParquetOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableListInference":
            suggest = "enable_list_inference"
        elif key == "enumAsString":
            suggest = "enum_as_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableExternalDataConfigurationParquetOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableExternalDataConfigurationParquetOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableExternalDataConfigurationParquetOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_list_inference: Optional[bool] = None,
                 enum_as_string: Optional[bool] = None):
        """
        :param bool enable_list_inference: Indicates whether to use schema inference specifically for Parquet LIST logical type.
        :param bool enum_as_string: Indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
        """
        if enable_list_inference is not None:
            pulumi.set(__self__, "enable_list_inference", enable_list_inference)
        if enum_as_string is not None:
            pulumi.set(__self__, "enum_as_string", enum_as_string)

    @property
    @pulumi.getter(name="enableListInference")
    def enable_list_inference(self) -> Optional[bool]:
        """
        Indicates whether to use schema inference specifically for Parquet LIST logical type.
        """
        return pulumi.get(self, "enable_list_inference")

    @property
    @pulumi.getter(name="enumAsString")
    def enum_as_string(self) -> Optional[bool]:
        """
        Indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
        """
        return pulumi.get(self, "enum_as_string")


@pulumi.output_type
class TableMaterializedView(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowNonIncrementalDefinition":
            suggest = "allow_non_incremental_definition"
        elif key == "enableRefresh":
            suggest = "enable_refresh"
        elif key == "refreshIntervalMs":
            suggest = "refresh_interval_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableMaterializedView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableMaterializedView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableMaterializedView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: str,
                 allow_non_incremental_definition: Optional[bool] = None,
                 enable_refresh: Optional[bool] = None,
                 refresh_interval_ms: Optional[int] = None):
        """
        :param str query: A query whose result is persisted.
        :param bool allow_non_incremental_definition: Allow non incremental materialized view definition.
               The default value is false.
        :param bool enable_refresh: Specifies whether to use BigQuery's automatic refresh for this materialized view when the base table is updated.
               The default value is true.
        :param int refresh_interval_ms: The maximum frequency at which this materialized view will be refreshed.
               The default value is 1800000
        """
        pulumi.set(__self__, "query", query)
        if allow_non_incremental_definition is not None:
            pulumi.set(__self__, "allow_non_incremental_definition", allow_non_incremental_definition)
        if enable_refresh is not None:
            pulumi.set(__self__, "enable_refresh", enable_refresh)
        if refresh_interval_ms is not None:
            pulumi.set(__self__, "refresh_interval_ms", refresh_interval_ms)

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        A query whose result is persisted.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="allowNonIncrementalDefinition")
    def allow_non_incremental_definition(self) -> Optional[bool]:
        """
        Allow non incremental materialized view definition.
        The default value is false.
        """
        return pulumi.get(self, "allow_non_incremental_definition")

    @property
    @pulumi.getter(name="enableRefresh")
    def enable_refresh(self) -> Optional[bool]:
        """
        Specifies whether to use BigQuery's automatic refresh for this materialized view when the base table is updated.
        The default value is true.
        """
        return pulumi.get(self, "enable_refresh")

    @property
    @pulumi.getter(name="refreshIntervalMs")
    def refresh_interval_ms(self) -> Optional[int]:
        """
        The maximum frequency at which this materialized view will be refreshed.
        The default value is 1800000
        """
        return pulumi.get(self, "refresh_interval_ms")


@pulumi.output_type
class TableRangePartitioning(dict):
    def __init__(__self__, *,
                 field: str,
                 range: 'outputs.TableRangePartitioningRange'):
        """
        :param str field: The field used to determine how to create a range-based
               partition.
        :param 'TableRangePartitioningRangeArgs' range: Information required to partition based on ranges.
               Structure is documented below.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter
    def field(self) -> str:
        """
        The field used to determine how to create a range-based
        partition.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def range(self) -> 'outputs.TableRangePartitioningRange':
        """
        Information required to partition based on ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "range")


@pulumi.output_type
class TableRangePartitioningRange(dict):
    def __init__(__self__, *,
                 end: int,
                 interval: int,
                 start: int):
        """
        :param int end: End of the range partitioning, exclusive.
        :param int interval: The width of each range within the partition.
        :param int start: Start of the range partitioning, inclusive.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> int:
        """
        End of the range partitioning, exclusive.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        The width of each range within the partition.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def start(self) -> int:
        """
        Start of the range partitioning, inclusive.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class TableTableConstraints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "foreignKeys":
            suggest = "foreign_keys"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTableConstraints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTableConstraints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTableConstraints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 foreign_keys: Optional[Sequence['outputs.TableTableConstraintsForeignKey']] = None,
                 primary_key: Optional['outputs.TableTableConstraintsPrimaryKey'] = None):
        """
        :param Sequence['TableTableConstraintsForeignKeyArgs'] foreign_keys: Present only if the table has a foreign key.
               The foreign key is not enforced.
               Structure is documented below.
        :param 'TableTableConstraintsPrimaryKeyArgs' primary_key: Represents the primary key constraint
               on a table's columns. Present only if the table has a primary key.
               The primary key is not enforced.
               Structure is documented below.
        """
        if foreign_keys is not None:
            pulumi.set(__self__, "foreign_keys", foreign_keys)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)

    @property
    @pulumi.getter(name="foreignKeys")
    def foreign_keys(self) -> Optional[Sequence['outputs.TableTableConstraintsForeignKey']]:
        """
        Present only if the table has a foreign key.
        The foreign key is not enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "foreign_keys")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional['outputs.TableTableConstraintsPrimaryKey']:
        """
        Represents the primary key constraint
        on a table's columns. Present only if the table has a primary key.
        The primary key is not enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "primary_key")


@pulumi.output_type
class TableTableConstraintsForeignKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnReferences":
            suggest = "column_references"
        elif key == "referencedTable":
            suggest = "referenced_table"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTableConstraintsForeignKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTableConstraintsForeignKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTableConstraintsForeignKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_references: 'outputs.TableTableConstraintsForeignKeyColumnReferences',
                 referenced_table: 'outputs.TableTableConstraintsForeignKeyReferencedTable',
                 name: Optional[str] = None):
        """
        :param 'TableTableConstraintsForeignKeyColumnReferencesArgs' column_references: The pair of the foreign key column and primary key column.
               Structure is documented below.
        :param 'TableTableConstraintsForeignKeyReferencedTableArgs' referenced_table: The table that holds the primary key
               and is referenced by this foreign key.
               Structure is documented below.
        :param str name: Set only if the foreign key constraint is named.
        """
        pulumi.set(__self__, "column_references", column_references)
        pulumi.set(__self__, "referenced_table", referenced_table)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="columnReferences")
    def column_references(self) -> 'outputs.TableTableConstraintsForeignKeyColumnReferences':
        """
        The pair of the foreign key column and primary key column.
        Structure is documented below.
        """
        return pulumi.get(self, "column_references")

    @property
    @pulumi.getter(name="referencedTable")
    def referenced_table(self) -> 'outputs.TableTableConstraintsForeignKeyReferencedTable':
        """
        The table that holds the primary key
        and is referenced by this foreign key.
        Structure is documented below.
        """
        return pulumi.get(self, "referenced_table")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Set only if the foreign key constraint is named.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TableTableConstraintsForeignKeyColumnReferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referencedColumn":
            suggest = "referenced_column"
        elif key == "referencingColumn":
            suggest = "referencing_column"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTableConstraintsForeignKeyColumnReferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTableConstraintsForeignKeyColumnReferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTableConstraintsForeignKeyColumnReferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 referenced_column: str,
                 referencing_column: str):
        """
        :param str referenced_column: The column in the primary key that are
               referenced by the referencingColumn
        :param str referencing_column: The column that composes the foreign key.
        """
        pulumi.set(__self__, "referenced_column", referenced_column)
        pulumi.set(__self__, "referencing_column", referencing_column)

    @property
    @pulumi.getter(name="referencedColumn")
    def referenced_column(self) -> str:
        """
        The column in the primary key that are
        referenced by the referencingColumn
        """
        return pulumi.get(self, "referenced_column")

    @property
    @pulumi.getter(name="referencingColumn")
    def referencing_column(self) -> str:
        """
        The column that composes the foreign key.
        """
        return pulumi.get(self, "referencing_column")


@pulumi.output_type
class TableTableConstraintsForeignKeyReferencedTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTableConstraintsForeignKeyReferencedTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTableConstraintsForeignKeyReferencedTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTableConstraintsForeignKeyReferencedTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: str,
                 table_id: str):
        """
        :param str dataset_id: The ID of the dataset containing this table.
        :param str project_id: The ID of the project containing this table.
        :param str table_id: The ID of the table. The ID must contain only
               letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
               length is 1,024 characters. Certain operations allow suffixing of
               the table ID with a partition decorator, such as
               sample_table$20190123.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The ID of the table. The ID must contain only
        letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
        length is 1,024 characters. Certain operations allow suffixing of
        the table ID with a partition decorator, such as
        sample_table$20190123.
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class TableTableConstraintsPrimaryKey(dict):
    def __init__(__self__, *,
                 columns: Sequence[str]):
        """
        :param Sequence[str] columns: The columns that are composed of the primary key constraint.
        """
        pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Sequence[str]:
        """
        The columns that are composed of the primary key constraint.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class TableTableReplicationInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceDatasetId":
            suggest = "source_dataset_id"
        elif key == "sourceProjectId":
            suggest = "source_project_id"
        elif key == "sourceTableId":
            suggest = "source_table_id"
        elif key == "replicationIntervalMs":
            suggest = "replication_interval_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTableReplicationInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTableReplicationInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTableReplicationInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_dataset_id: str,
                 source_project_id: str,
                 source_table_id: str,
                 replication_interval_ms: Optional[int] = None):
        """
        :param str source_dataset_id: The ID of the source dataset.
        :param str source_project_id: The ID of the source project.
        :param str source_table_id: The ID of the source materialized view.
        :param int replication_interval_ms: The interval at which the source
               materialized view is polled for updates. The default is 300000.
        """
        pulumi.set(__self__, "source_dataset_id", source_dataset_id)
        pulumi.set(__self__, "source_project_id", source_project_id)
        pulumi.set(__self__, "source_table_id", source_table_id)
        if replication_interval_ms is not None:
            pulumi.set(__self__, "replication_interval_ms", replication_interval_ms)

    @property
    @pulumi.getter(name="sourceDatasetId")
    def source_dataset_id(self) -> str:
        """
        The ID of the source dataset.
        """
        return pulumi.get(self, "source_dataset_id")

    @property
    @pulumi.getter(name="sourceProjectId")
    def source_project_id(self) -> str:
        """
        The ID of the source project.
        """
        return pulumi.get(self, "source_project_id")

    @property
    @pulumi.getter(name="sourceTableId")
    def source_table_id(self) -> str:
        """
        The ID of the source materialized view.
        """
        return pulumi.get(self, "source_table_id")

    @property
    @pulumi.getter(name="replicationIntervalMs")
    def replication_interval_ms(self) -> Optional[int]:
        """
        The interval at which the source
        materialized view is polled for updates. The default is 300000.
        """
        return pulumi.get(self, "replication_interval_ms")


@pulumi.output_type
class TableTimePartitioning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationMs":
            suggest = "expiration_ms"
        elif key == "requirePartitionFilter":
            suggest = "require_partition_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTimePartitioning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTimePartitioning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTimePartitioning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 expiration_ms: Optional[int] = None,
                 field: Optional[str] = None,
                 require_partition_filter: Optional[bool] = None):
        """
        :param str type: The supported types are DAY, HOUR, MONTH, and YEAR,
               which will generate one partition per day, hour, month, and year, respectively.
        :param int expiration_ms: Number of milliseconds for which to keep the
               storage for a partition.
        :param str field: The field used to determine how to create a time-based
               partition. If time-based partitioning is enabled without this value, the
               table is partitioned based on the load time.
        :param bool require_partition_filter: If set to true, queries over this table
               require a partition filter that can be used for partition elimination to be
               specified. `require_partition_filter` is deprecated and will be removed in
               a future major release. Use the top level field with the same name instead.
        """
        pulumi.set(__self__, "type", type)
        if expiration_ms is not None:
            pulumi.set(__self__, "expiration_ms", expiration_ms)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if require_partition_filter is not None:
            pulumi.set(__self__, "require_partition_filter", require_partition_filter)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The supported types are DAY, HOUR, MONTH, and YEAR,
        which will generate one partition per day, hour, month, and year, respectively.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="expirationMs")
    def expiration_ms(self) -> Optional[int]:
        """
        Number of milliseconds for which to keep the
        storage for a partition.
        """
        return pulumi.get(self, "expiration_ms")

    @property
    @pulumi.getter
    def field(self) -> Optional[str]:
        """
        The field used to determine how to create a time-based
        partition. If time-based partitioning is enabled without this value, the
        table is partitioned based on the load time.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter(name="requirePartitionFilter")
    @_utilities.deprecated("""This field is deprecated and will be removed in a future major release; please use the top level field with the same name instead.""")
    def require_partition_filter(self) -> Optional[bool]:
        """
        If set to true, queries over this table
        require a partition filter that can be used for partition elimination to be
        specified. `require_partition_filter` is deprecated and will be removed in
        a future major release. Use the top level field with the same name instead.
        """
        return pulumi.get(self, "require_partition_filter")


@pulumi.output_type
class TableView(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useLegacySql":
            suggest = "use_legacy_sql"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: str,
                 use_legacy_sql: Optional[bool] = None):
        """
        :param str query: A query that BigQuery executes when the view is referenced.
        :param bool use_legacy_sql: Specifies whether to use BigQuery's legacy SQL for this view.
               The default value is true. If set to false, the view will use BigQuery's standard SQL.
        """
        pulumi.set(__self__, "query", query)
        if use_legacy_sql is not None:
            pulumi.set(__self__, "use_legacy_sql", use_legacy_sql)

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        A query that BigQuery executes when the view is referenced.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="useLegacySql")
    def use_legacy_sql(self) -> Optional[bool]:
        """
        Specifies whether to use BigQuery's legacy SQL for this view.
        The default value is true. If set to false, the view will use BigQuery's standard SQL.
        """
        return pulumi.get(self, "use_legacy_sql")


@pulumi.output_type
class GetDatasetAccessResult(dict):
    def __init__(__self__, *,
                 datasets: Sequence['outputs.GetDatasetAccessDatasetResult'],
                 domain: str,
                 group_by_email: str,
                 iam_member: str,
                 role: str,
                 routines: Sequence['outputs.GetDatasetAccessRoutineResult'],
                 special_group: str,
                 user_by_email: str,
                 views: Sequence['outputs.GetDatasetAccessViewResult']):
        """
        :param Sequence['GetDatasetAccessDatasetArgs'] datasets: Grants all resources of particular types in a particular dataset read access to the current dataset.
        :param str domain: A domain to grant access to. Any users signed in with the
               domain specified will be granted the specified access
        :param str group_by_email: An email address of a Google Group to grant access to.
        :param str iam_member: Some other type of member that appears in the IAM Policy but isn't a user,
               group, domain, or special group. For example: 'allUsers'
        :param str role: Describes the rights granted to the user specified by the other
               member of the access object. Basic, predefined, and custom roles
               are supported. Predefined roles that have equivalent basic roles
               are swapped by the API to their basic counterparts. See
               [official docs](https://cloud.google.com/bigquery/docs/access-control).
        :param Sequence['GetDatasetAccessRoutineArgs'] routines: A routine from a different dataset to grant access to. Queries
               executed against that routine will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that routine is updated by any user, access to the routine
               needs to be granted again via an update operation.
        :param str special_group: A special group to grant access to. Possible values include:
               * 'projectOwners': Owners of the enclosing project.
               * 'projectReaders': Readers of the enclosing project.
               * 'projectWriters': Writers of the enclosing project.
               * 'allAuthenticatedUsers': All authenticated BigQuery users.
        :param str user_by_email: An email address of a user to grant access to. For example:
               fred@example.com
        :param Sequence['GetDatasetAccessViewArgs'] views: A view from a different dataset to grant access to. Queries
               executed against that view will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that view is updated by any user, access to the view
               needs to be granted again via an update operation.
        """
        pulumi.set(__self__, "datasets", datasets)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "group_by_email", group_by_email)
        pulumi.set(__self__, "iam_member", iam_member)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "routines", routines)
        pulumi.set(__self__, "special_group", special_group)
        pulumi.set(__self__, "user_by_email", user_by_email)
        pulumi.set(__self__, "views", views)

    @property
    @pulumi.getter
    def datasets(self) -> Sequence['outputs.GetDatasetAccessDatasetResult']:
        """
        Grants all resources of particular types in a particular dataset read access to the current dataset.
        """
        return pulumi.get(self, "datasets")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        A domain to grant access to. Any users signed in with the
        domain specified will be granted the specified access
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="groupByEmail")
    def group_by_email(self) -> str:
        """
        An email address of a Google Group to grant access to.
        """
        return pulumi.get(self, "group_by_email")

    @property
    @pulumi.getter(name="iamMember")
    def iam_member(self) -> str:
        """
        Some other type of member that appears in the IAM Policy but isn't a user,
        group, domain, or special group. For example: 'allUsers'
        """
        return pulumi.get(self, "iam_member")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Describes the rights granted to the user specified by the other
        member of the access object. Basic, predefined, and custom roles
        are supported. Predefined roles that have equivalent basic roles
        are swapped by the API to their basic counterparts. See
        [official docs](https://cloud.google.com/bigquery/docs/access-control).
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def routines(self) -> Sequence['outputs.GetDatasetAccessRoutineResult']:
        """
        A routine from a different dataset to grant access to. Queries
        executed against that routine will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that routine is updated by any user, access to the routine
        needs to be granted again via an update operation.
        """
        return pulumi.get(self, "routines")

    @property
    @pulumi.getter(name="specialGroup")
    def special_group(self) -> str:
        """
        A special group to grant access to. Possible values include:
        * 'projectOwners': Owners of the enclosing project.
        * 'projectReaders': Readers of the enclosing project.
        * 'projectWriters': Writers of the enclosing project.
        * 'allAuthenticatedUsers': All authenticated BigQuery users.
        """
        return pulumi.get(self, "special_group")

    @property
    @pulumi.getter(name="userByEmail")
    def user_by_email(self) -> str:
        """
        An email address of a user to grant access to. For example:
        fred@example.com
        """
        return pulumi.get(self, "user_by_email")

    @property
    @pulumi.getter
    def views(self) -> Sequence['outputs.GetDatasetAccessViewResult']:
        """
        A view from a different dataset to grant access to. Queries
        executed against that view will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that view is updated by any user, access to the view
        needs to be granted again via an update operation.
        """
        return pulumi.get(self, "views")


@pulumi.output_type
class GetDatasetAccessDatasetResult(dict):
    def __init__(__self__, *,
                 datasets: Sequence['outputs.GetDatasetAccessDatasetDatasetResult'],
                 target_types: Sequence[str]):
        """
        :param Sequence['GetDatasetAccessDatasetDatasetArgs'] datasets: The dataset this entry applies to
        :param Sequence[str] target_types: Which resources in the dataset this entry applies to. Currently, only views are supported,
               but additional target types may be added in the future. Possible values: VIEWS
        """
        pulumi.set(__self__, "datasets", datasets)
        pulumi.set(__self__, "target_types", target_types)

    @property
    @pulumi.getter
    def datasets(self) -> Sequence['outputs.GetDatasetAccessDatasetDatasetResult']:
        """
        The dataset this entry applies to
        """
        return pulumi.get(self, "datasets")

    @property
    @pulumi.getter(name="targetTypes")
    def target_types(self) -> Sequence[str]:
        """
        Which resources in the dataset this entry applies to. Currently, only views are supported,
        but additional target types may be added in the future. Possible values: VIEWS
        """
        return pulumi.get(self, "target_types")


@pulumi.output_type
class GetDatasetAccessDatasetDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: str):
        """
        :param str dataset_id: The dataset ID.
        :param str project_id: The ID of the project containing this table.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The dataset ID.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetDatasetAccessRoutineResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: str,
                 routine_id: str):
        """
        :param str dataset_id: The dataset ID.
        :param str project_id: The ID of the project containing this table.
        :param str routine_id: The ID of the routine. The ID must contain only letters (a-z,
               A-Z), numbers (0-9), or underscores (_). The maximum length
               is 256 characters.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "routine_id", routine_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The dataset ID.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="routineId")
    def routine_id(self) -> str:
        """
        The ID of the routine. The ID must contain only letters (a-z,
        A-Z), numbers (0-9), or underscores (_). The maximum length
        is 256 characters.
        """
        return pulumi.get(self, "routine_id")


@pulumi.output_type
class GetDatasetAccessViewResult(dict):
    def __init__(__self__, *,
                 dataset_id: str,
                 project_id: str,
                 table_id: str):
        """
        :param str dataset_id: The dataset ID.
        :param str project_id: The ID of the project containing this table.
        :param str table_id: The ID of the table. The ID must contain only letters (a-z,
               A-Z), numbers (0-9), or underscores (_). The maximum length
               is 1,024 characters.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The dataset ID.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The ID of the table. The ID must contain only letters (a-z,
        A-Z), numbers (0-9), or underscores (_). The maximum length
        is 1,024 characters.
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class GetDatasetDefaultEncryptionConfigurationResult(dict):
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination
               BigQuery table. The BigQuery Service Account associated with your project requires
               access to this encryption key.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination
        BigQuery table. The BigQuery Service Account associated with your project requires
        access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class GetDatasetExternalDatasetReferenceResult(dict):
    def __init__(__self__, *,
                 connection: str,
                 external_source: str):
        """
        :param str connection: The connection id that is used to access the externalSource.
               Format: projects/{projectId}/locations/{locationId}/connections/{connectionId}
        :param str external_source: External source that backs this dataset.
        """
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "external_source", external_source)

    @property
    @pulumi.getter
    def connection(self) -> str:
        """
        The connection id that is used to access the externalSource.
        Format: projects/{projectId}/locations/{locationId}/connections/{connectionId}
        """
        return pulumi.get(self, "connection")

    @property
    @pulumi.getter(name="externalSource")
    def external_source(self) -> str:
        """
        External source that backs this dataset.
        """
        return pulumi.get(self, "external_source")


@pulumi.output_type
class GetTablesTableResult(dict):
    def __init__(__self__, *,
                 labels: Mapping[str, str],
                 table_id: str):
        """
        :param Mapping[str, str] labels: User-provided table labels, in key/value pairs.
        :param str table_id: The name of the table.
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        User-provided table labels, in key/value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        The name of the table.
        """
        return pulumi.get(self, "table_id")


