# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificatesResult',
    'AwaitableGetCertificatesResult',
    'get_certificates',
    'get_certificates_output',
]

@pulumi.output_type
class GetCertificatesResult:
    """
    A collection of values returned by getCertificates.
    """
    def __init__(__self__, certificates=None, filter=None, id=None, region=None):
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.GetCertificatesCertificateResult']:
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


class AwaitableGetCertificatesResult(GetCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificatesResult(
            certificates=self.certificates,
            filter=self.filter,
            id=self.id,
            region=self.region)


def get_certificates(filter: Optional[str] = None,
                     region: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificatesResult:
    """
    List all certificates within Google Certificate Manager for a given project, region or filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.certificatemanager.get_certificates()
    ```

    ### With A Filter

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.certificatemanager.get_certificates(filter="name:projects/PROJECT_ID/locations/REGION/certificates/certificate-name-*")
    ```


    :param str filter: Filter expression to restrict the certificates returned.
    :param str region: The region in which the resource belongs. If it is not provided, `GLOBAL` is used.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:certificatemanager/getCertificates:getCertificates', __args__, opts=opts, typ=GetCertificatesResult).value

    return AwaitableGetCertificatesResult(
        certificates=pulumi.get(__ret__, 'certificates'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))


@_utilities.lift_output_func(get_certificates)
def get_certificates_output(filter: Optional[pulumi.Input[Optional[str]]] = None,
                            region: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificatesResult]:
    """
    List all certificates within Google Certificate Manager for a given project, region or filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.certificatemanager.get_certificates()
    ```

    ### With A Filter

    ```python
    import pulumi
    import pulumi_gcp as gcp

    default = gcp.certificatemanager.get_certificates(filter="name:projects/PROJECT_ID/locations/REGION/certificates/certificate-name-*")
    ```


    :param str filter: Filter expression to restrict the certificates returned.
    :param str region: The region in which the resource belongs. If it is not provided, `GLOBAL` is used.
    """
    ...
