# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegistrationArgs', 'Registration']

@pulumi.input_type
class RegistrationArgs:
    def __init__(__self__, *,
                 contact_settings: pulumi.Input['RegistrationContactSettingsArgs'],
                 domain_name: pulumi.Input[str],
                 location: pulumi.Input[str],
                 yearly_price: pulumi.Input['RegistrationYearlyPriceArgs'],
                 contact_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_settings: Optional[pulumi.Input['RegistrationDnsSettingsArgs']] = None,
                 domain_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 management_settings: Optional[pulumi.Input['RegistrationManagementSettingsArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Registration resource.
        :param pulumi.Input['RegistrationContactSettingsArgs'] contact_settings: Required. Settings for contact information linked to the Registration.
               Structure is documented below.
        :param pulumi.Input[str] domain_name: Required. The domain name. Unicode domain names must be expressed in Punycode format.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input['RegistrationYearlyPriceArgs'] yearly_price: Required. Yearly price to register or renew the domain. The value that should be put here can be obtained from
               registrations.retrieveRegisterParameters or registrations.searchDomains calls.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_notices: The list of contact notices that the caller acknowledges. Possible value is PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT
        :param pulumi.Input['RegistrationDnsSettingsArgs'] dns_settings: Settings controlling the DNS configuration of the Registration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_notices: The list of domain notices that you acknowledge. Possible value is HSTS_PRELOADED
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with the Registration. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input['RegistrationManagementSettingsArgs'] management_settings: Settings for management of the Registration, including renewal, billing, and transfer
        """
        pulumi.set(__self__, "contact_settings", contact_settings)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "yearly_price", yearly_price)
        if contact_notices is not None:
            pulumi.set(__self__, "contact_notices", contact_notices)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if domain_notices is not None:
            pulumi.set(__self__, "domain_notices", domain_notices)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if management_settings is not None:
            pulumi.set(__self__, "management_settings", management_settings)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="contactSettings")
    def contact_settings(self) -> pulumi.Input['RegistrationContactSettingsArgs']:
        """
        Required. Settings for contact information linked to the Registration.
        Structure is documented below.
        """
        return pulumi.get(self, "contact_settings")

    @contact_settings.setter
    def contact_settings(self, value: pulumi.Input['RegistrationContactSettingsArgs']):
        pulumi.set(self, "contact_settings", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Required. The domain name. Unicode domain names must be expressed in Punycode format.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="yearlyPrice")
    def yearly_price(self) -> pulumi.Input['RegistrationYearlyPriceArgs']:
        """
        Required. Yearly price to register or renew the domain. The value that should be put here can be obtained from
        registrations.retrieveRegisterParameters or registrations.searchDomains calls.
        Structure is documented below.
        """
        return pulumi.get(self, "yearly_price")

    @yearly_price.setter
    def yearly_price(self, value: pulumi.Input['RegistrationYearlyPriceArgs']):
        pulumi.set(self, "yearly_price", value)

    @property
    @pulumi.getter(name="contactNotices")
    def contact_notices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of contact notices that the caller acknowledges. Possible value is PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT
        """
        return pulumi.get(self, "contact_notices")

    @contact_notices.setter
    def contact_notices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contact_notices", value)

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['RegistrationDnsSettingsArgs']]:
        """
        Settings controlling the DNS configuration of the Registration.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['RegistrationDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @property
    @pulumi.getter(name="domainNotices")
    def domain_notices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of domain notices that you acknowledge. Possible value is HSTS_PRELOADED
        """
        return pulumi.get(self, "domain_notices")

    @domain_notices.setter
    def domain_notices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domain_notices", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of labels associated with the Registration. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="managementSettings")
    def management_settings(self) -> Optional[pulumi.Input['RegistrationManagementSettingsArgs']]:
        """
        Settings for management of the Registration, including renewal, billing, and transfer
        """
        return pulumi.get(self, "management_settings")

    @management_settings.setter
    def management_settings(self, value: Optional[pulumi.Input['RegistrationManagementSettingsArgs']]):
        pulumi.set(self, "management_settings", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RegistrationState:
    def __init__(__self__, *,
                 contact_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 contact_settings: Optional[pulumi.Input['RegistrationContactSettingsArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 dns_settings: Optional[pulumi.Input['RegistrationDnsSettingsArgs']] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 issues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management_settings: Optional[pulumi.Input['RegistrationManagementSettingsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 register_failure_reason: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 supported_privacies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 yearly_price: Optional[pulumi.Input['RegistrationYearlyPriceArgs']] = None):
        """
        Input properties used for looking up and filtering Registration resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_notices: The list of contact notices that the caller acknowledges. Possible value is PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT
        :param pulumi.Input['RegistrationContactSettingsArgs'] contact_settings: Required. Settings for contact information linked to the Registration.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Output only. Time at which the automation was created.
        :param pulumi.Input['RegistrationDnsSettingsArgs'] dns_settings: Settings controlling the DNS configuration of the Registration.
        :param pulumi.Input[str] domain_name: Required. The domain name. Unicode domain names must be expressed in Punycode format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_notices: The list of domain notices that you acknowledge. Possible value is HSTS_PRELOADED
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] expire_time: Output only. Time at which the automation was updated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] issues: Output only. The set of issues with the Registration that require attention.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with the Registration. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input['RegistrationManagementSettingsArgs'] management_settings: Settings for management of the Registration, including renewal, billing, and transfer
        :param pulumi.Input[str] name: Output only. Name of the Registration resource, in the format projects/*/locations/*/registrations/<domain_name>.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] register_failure_reason: Output only. The reason the domain registration failed. Only set for domains in REGISTRATION_FAILED state.
        :param pulumi.Input[str] state: Output only. The current state of the Registration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_privacies: Output only. Set of options for the contactSettings.privacy field that this Registration supports.
        :param pulumi.Input['RegistrationYearlyPriceArgs'] yearly_price: Required. Yearly price to register or renew the domain. The value that should be put here can be obtained from
               registrations.retrieveRegisterParameters or registrations.searchDomains calls.
               Structure is documented below.
        """
        if contact_notices is not None:
            pulumi.set(__self__, "contact_notices", contact_notices)
        if contact_settings is not None:
            pulumi.set(__self__, "contact_settings", contact_settings)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_notices is not None:
            pulumi.set(__self__, "domain_notices", domain_notices)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if issues is not None:
            pulumi.set(__self__, "issues", issues)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management_settings is not None:
            pulumi.set(__self__, "management_settings", management_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if register_failure_reason is not None:
            pulumi.set(__self__, "register_failure_reason", register_failure_reason)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if supported_privacies is not None:
            pulumi.set(__self__, "supported_privacies", supported_privacies)
        if yearly_price is not None:
            pulumi.set(__self__, "yearly_price", yearly_price)

    @property
    @pulumi.getter(name="contactNotices")
    def contact_notices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of contact notices that the caller acknowledges. Possible value is PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT
        """
        return pulumi.get(self, "contact_notices")

    @contact_notices.setter
    def contact_notices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contact_notices", value)

    @property
    @pulumi.getter(name="contactSettings")
    def contact_settings(self) -> Optional[pulumi.Input['RegistrationContactSettingsArgs']]:
        """
        Required. Settings for contact information linked to the Registration.
        Structure is documented below.
        """
        return pulumi.get(self, "contact_settings")

    @contact_settings.setter
    def contact_settings(self, value: Optional[pulumi.Input['RegistrationContactSettingsArgs']]):
        pulumi.set(self, "contact_settings", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Time at which the automation was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional[pulumi.Input['RegistrationDnsSettingsArgs']]:
        """
        Settings controlling the DNS configuration of the Registration.
        """
        return pulumi.get(self, "dns_settings")

    @dns_settings.setter
    def dns_settings(self, value: Optional[pulumi.Input['RegistrationDnsSettingsArgs']]):
        pulumi.set(self, "dns_settings", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The domain name. Unicode domain names must be expressed in Punycode format.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="domainNotices")
    def domain_notices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of domain notices that you acknowledge. Possible value is HSTS_PRELOADED
        """
        return pulumi.get(self, "domain_notices")

    @domain_notices.setter
    def domain_notices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domain_notices", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Time at which the automation was updated.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def issues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Output only. The set of issues with the Registration that require attention.
        """
        return pulumi.get(self, "issues")

    @issues.setter
    def issues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "issues", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of labels associated with the Registration. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managementSettings")
    def management_settings(self) -> Optional[pulumi.Input['RegistrationManagementSettingsArgs']]:
        """
        Settings for management of the Registration, including renewal, billing, and transfer
        """
        return pulumi.get(self, "management_settings")

    @management_settings.setter
    def management_settings(self, value: Optional[pulumi.Input['RegistrationManagementSettingsArgs']]):
        pulumi.set(self, "management_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Name of the Registration resource, in the format projects/*/locations/*/registrations/<domain_name>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="registerFailureReason")
    def register_failure_reason(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The reason the domain registration failed. Only set for domains in REGISTRATION_FAILED state.
        """
        return pulumi.get(self, "register_failure_reason")

    @register_failure_reason.setter
    def register_failure_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "register_failure_reason", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The current state of the Registration.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="supportedPrivacies")
    def supported_privacies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Output only. Set of options for the contactSettings.privacy field that this Registration supports.
        """
        return pulumi.get(self, "supported_privacies")

    @supported_privacies.setter
    def supported_privacies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "supported_privacies", value)

    @property
    @pulumi.getter(name="yearlyPrice")
    def yearly_price(self) -> Optional[pulumi.Input['RegistrationYearlyPriceArgs']]:
        """
        Required. Yearly price to register or renew the domain. The value that should be put here can be obtained from
        registrations.retrieveRegisterParameters or registrations.searchDomains calls.
        Structure is documented below.
        """
        return pulumi.get(self, "yearly_price")

    @yearly_price.setter
    def yearly_price(self, value: Optional[pulumi.Input['RegistrationYearlyPriceArgs']]):
        pulumi.set(self, "yearly_price", value)


class Registration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 contact_settings: Optional[pulumi.Input[Union['RegistrationContactSettingsArgs', 'RegistrationContactSettingsArgsDict']]] = None,
                 dns_settings: Optional[pulumi.Input[Union['RegistrationDnsSettingsArgs', 'RegistrationDnsSettingsArgsDict']]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management_settings: Optional[pulumi.Input[Union['RegistrationManagementSettingsArgs', 'RegistrationManagementSettingsArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 yearly_price: Optional[pulumi.Input[Union['RegistrationYearlyPriceArgs', 'RegistrationYearlyPriceArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Clouddomains Registration Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_registration = gcp.clouddomains.Registration("my_registration",
            domain_name="example-domain.com",
            location="global",
            labels={
                "labelkey": "labelvalue",
            },
            yearly_price={
                "currency_code": "USD",
                "units": "12",
            },
            dns_settings={
                "custom_dns": {
                    "name_servers": [
                        "ns-cloud-a1.googledomains.com.",
                        "ns-cloud-a2.googledomains.com.",
                        "ns-cloud-a3.googledomains.com.",
                        "ns-cloud-a4.googledomains.com.",
                    ],
                },
            },
            contact_settings={
                "privacy": "REDACTED_CONTACT_DATA",
                "registrant_contact": {
                    "phone_number": "+12345000000",
                    "email": "user@example.com",
                    "postal_address": {
                        "region_code": "US",
                        "postal_code": "95050",
                        "administrative_area": "CA",
                        "locality": "Example City",
                        "address_lines": ["1234 Example street"],
                        "recipients": ["example recipient"],
                    },
                },
                "admin_contact": {
                    "phone_number": "+12345000000",
                    "email": "user@example.com",
                    "postal_address": {
                        "region_code": "US",
                        "postal_code": "95050",
                        "administrative_area": "CA",
                        "locality": "Example City",
                        "address_lines": ["1234 Example street"],
                        "recipients": ["example recipient"],
                    },
                },
                "technical_contact": {
                    "phone_number": "+12345000000",
                    "email": "user@example.com",
                    "postal_address": {
                        "region_code": "US",
                        "postal_code": "95050",
                        "administrative_area": "CA",
                        "locality": "Example City",
                        "address_lines": ["1234 Example street"],
                        "recipients": ["example recipient"],
                    },
                },
            })
        ```

        ## Import

        Registration can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/registrations/{{domain_name}}`

        * `{{project}}/{{location}}/{{domain_name}}`

        * `{{location}}/{{domain_name}}`

        When using the `pulumi import` command, Registration can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:clouddomains/registration:Registration default projects/{{project}}/locations/{{location}}/registrations/{{domain_name}}
        ```

        ```sh
        $ pulumi import gcp:clouddomains/registration:Registration default {{project}}/{{location}}/{{domain_name}}
        ```

        ```sh
        $ pulumi import gcp:clouddomains/registration:Registration default {{location}}/{{domain_name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_notices: The list of contact notices that the caller acknowledges. Possible value is PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT
        :param pulumi.Input[Union['RegistrationContactSettingsArgs', 'RegistrationContactSettingsArgsDict']] contact_settings: Required. Settings for contact information linked to the Registration.
               Structure is documented below.
        :param pulumi.Input[Union['RegistrationDnsSettingsArgs', 'RegistrationDnsSettingsArgsDict']] dns_settings: Settings controlling the DNS configuration of the Registration.
        :param pulumi.Input[str] domain_name: Required. The domain name. Unicode domain names must be expressed in Punycode format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_notices: The list of domain notices that you acknowledge. Possible value is HSTS_PRELOADED
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with the Registration. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[Union['RegistrationManagementSettingsArgs', 'RegistrationManagementSettingsArgsDict']] management_settings: Settings for management of the Registration, including renewal, billing, and transfer
        :param pulumi.Input[Union['RegistrationYearlyPriceArgs', 'RegistrationYearlyPriceArgsDict']] yearly_price: Required. Yearly price to register or renew the domain. The value that should be put here can be obtained from
               registrations.retrieveRegisterParameters or registrations.searchDomains calls.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Clouddomains Registration Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_registration = gcp.clouddomains.Registration("my_registration",
            domain_name="example-domain.com",
            location="global",
            labels={
                "labelkey": "labelvalue",
            },
            yearly_price={
                "currency_code": "USD",
                "units": "12",
            },
            dns_settings={
                "custom_dns": {
                    "name_servers": [
                        "ns-cloud-a1.googledomains.com.",
                        "ns-cloud-a2.googledomains.com.",
                        "ns-cloud-a3.googledomains.com.",
                        "ns-cloud-a4.googledomains.com.",
                    ],
                },
            },
            contact_settings={
                "privacy": "REDACTED_CONTACT_DATA",
                "registrant_contact": {
                    "phone_number": "+12345000000",
                    "email": "user@example.com",
                    "postal_address": {
                        "region_code": "US",
                        "postal_code": "95050",
                        "administrative_area": "CA",
                        "locality": "Example City",
                        "address_lines": ["1234 Example street"],
                        "recipients": ["example recipient"],
                    },
                },
                "admin_contact": {
                    "phone_number": "+12345000000",
                    "email": "user@example.com",
                    "postal_address": {
                        "region_code": "US",
                        "postal_code": "95050",
                        "administrative_area": "CA",
                        "locality": "Example City",
                        "address_lines": ["1234 Example street"],
                        "recipients": ["example recipient"],
                    },
                },
                "technical_contact": {
                    "phone_number": "+12345000000",
                    "email": "user@example.com",
                    "postal_address": {
                        "region_code": "US",
                        "postal_code": "95050",
                        "administrative_area": "CA",
                        "locality": "Example City",
                        "address_lines": ["1234 Example street"],
                        "recipients": ["example recipient"],
                    },
                },
            })
        ```

        ## Import

        Registration can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/registrations/{{domain_name}}`

        * `{{project}}/{{location}}/{{domain_name}}`

        * `{{location}}/{{domain_name}}`

        When using the `pulumi import` command, Registration can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:clouddomains/registration:Registration default projects/{{project}}/locations/{{location}}/registrations/{{domain_name}}
        ```

        ```sh
        $ pulumi import gcp:clouddomains/registration:Registration default {{project}}/{{location}}/{{domain_name}}
        ```

        ```sh
        $ pulumi import gcp:clouddomains/registration:Registration default {{location}}/{{domain_name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 contact_settings: Optional[pulumi.Input[Union['RegistrationContactSettingsArgs', 'RegistrationContactSettingsArgsDict']]] = None,
                 dns_settings: Optional[pulumi.Input[Union['RegistrationDnsSettingsArgs', 'RegistrationDnsSettingsArgsDict']]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management_settings: Optional[pulumi.Input[Union['RegistrationManagementSettingsArgs', 'RegistrationManagementSettingsArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 yearly_price: Optional[pulumi.Input[Union['RegistrationYearlyPriceArgs', 'RegistrationYearlyPriceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistrationArgs.__new__(RegistrationArgs)

            __props__.__dict__["contact_notices"] = contact_notices
            if contact_settings is None and not opts.urn:
                raise TypeError("Missing required property 'contact_settings'")
            __props__.__dict__["contact_settings"] = contact_settings
            __props__.__dict__["dns_settings"] = dns_settings
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["domain_notices"] = domain_notices
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["management_settings"] = management_settings
            __props__.__dict__["project"] = project
            if yearly_price is None and not opts.urn:
                raise TypeError("Missing required property 'yearly_price'")
            __props__.__dict__["yearly_price"] = yearly_price
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["issues"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["register_failure_reason"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["supported_privacies"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Registration, __self__).__init__(
            'gcp:clouddomains/registration:Registration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contact_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            contact_settings: Optional[pulumi.Input[Union['RegistrationContactSettingsArgs', 'RegistrationContactSettingsArgsDict']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            dns_settings: Optional[pulumi.Input[Union['RegistrationDnsSettingsArgs', 'RegistrationDnsSettingsArgsDict']]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            domain_notices: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            expire_time: Optional[pulumi.Input[str]] = None,
            issues: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            management_settings: Optional[pulumi.Input[Union['RegistrationManagementSettingsArgs', 'RegistrationManagementSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            register_failure_reason: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            supported_privacies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            yearly_price: Optional[pulumi.Input[Union['RegistrationYearlyPriceArgs', 'RegistrationYearlyPriceArgsDict']]] = None) -> 'Registration':
        """
        Get an existing Registration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contact_notices: The list of contact notices that the caller acknowledges. Possible value is PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT
        :param pulumi.Input[Union['RegistrationContactSettingsArgs', 'RegistrationContactSettingsArgsDict']] contact_settings: Required. Settings for contact information linked to the Registration.
               Structure is documented below.
        :param pulumi.Input[str] create_time: Output only. Time at which the automation was created.
        :param pulumi.Input[Union['RegistrationDnsSettingsArgs', 'RegistrationDnsSettingsArgsDict']] dns_settings: Settings controlling the DNS configuration of the Registration.
        :param pulumi.Input[str] domain_name: Required. The domain name. Unicode domain names must be expressed in Punycode format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domain_notices: The list of domain notices that you acknowledge. Possible value is HSTS_PRELOADED
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] expire_time: Output only. Time at which the automation was updated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] issues: Output only. The set of issues with the Registration that require attention.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with the Registration. **Note**: This field is non-authoritative, and will only manage the
               labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
               resource.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[Union['RegistrationManagementSettingsArgs', 'RegistrationManagementSettingsArgsDict']] management_settings: Settings for management of the Registration, including renewal, billing, and transfer
        :param pulumi.Input[str] name: Output only. Name of the Registration resource, in the format projects/*/locations/*/registrations/<domain_name>.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] register_failure_reason: Output only. The reason the domain registration failed. Only set for domains in REGISTRATION_FAILED state.
        :param pulumi.Input[str] state: Output only. The current state of the Registration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_privacies: Output only. Set of options for the contactSettings.privacy field that this Registration supports.
        :param pulumi.Input[Union['RegistrationYearlyPriceArgs', 'RegistrationYearlyPriceArgsDict']] yearly_price: Required. Yearly price to register or renew the domain. The value that should be put here can be obtained from
               registrations.retrieveRegisterParameters or registrations.searchDomains calls.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistrationState.__new__(_RegistrationState)

        __props__.__dict__["contact_notices"] = contact_notices
        __props__.__dict__["contact_settings"] = contact_settings
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dns_settings"] = dns_settings
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["domain_notices"] = domain_notices
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["issues"] = issues
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["management_settings"] = management_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["register_failure_reason"] = register_failure_reason
        __props__.__dict__["state"] = state
        __props__.__dict__["supported_privacies"] = supported_privacies
        __props__.__dict__["yearly_price"] = yearly_price
        return Registration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contactNotices")
    def contact_notices(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of contact notices that the caller acknowledges. Possible value is PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT
        """
        return pulumi.get(self, "contact_notices")

    @property
    @pulumi.getter(name="contactSettings")
    def contact_settings(self) -> pulumi.Output['outputs.RegistrationContactSettings']:
        """
        Required. Settings for contact information linked to the Registration.
        Structure is documented below.
        """
        return pulumi.get(self, "contact_settings")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. Time at which the automation was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> pulumi.Output[Optional['outputs.RegistrationDnsSettings']]:
        """
        Settings controlling the DNS configuration of the Registration.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Required. The domain name. Unicode domain names must be expressed in Punycode format.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainNotices")
    def domain_notices(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of domain notices that you acknowledge. Possible value is HSTS_PRELOADED
        """
        return pulumi.get(self, "domain_notices")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[str]:
        """
        Output only. Time at which the automation was updated.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def issues(self) -> pulumi.Output[Sequence[str]]:
        """
        Output only. The set of issues with the Registration that require attention.
        """
        return pulumi.get(self, "issues")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Set of labels associated with the Registration. **Note**: This field is non-authoritative, and will only manage the
        labels present in your configuration. Please refer to the field 'effective_labels' for all of the labels present on the
        resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managementSettings")
    def management_settings(self) -> pulumi.Output['outputs.RegistrationManagementSettings']:
        """
        Settings for management of the Registration, including renewal, billing, and transfer
        """
        return pulumi.get(self, "management_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Output only. Name of the Registration resource, in the format projects/*/locations/*/registrations/<domain_name>.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="registerFailureReason")
    def register_failure_reason(self) -> pulumi.Output[str]:
        """
        Output only. The reason the domain registration failed. Only set for domains in REGISTRATION_FAILED state.
        """
        return pulumi.get(self, "register_failure_reason")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Output only. The current state of the Registration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportedPrivacies")
    def supported_privacies(self) -> pulumi.Output[Sequence[str]]:
        """
        Output only. Set of options for the contactSettings.privacy field that this Registration supports.
        """
        return pulumi.get(self, "supported_privacies")

    @property
    @pulumi.getter(name="yearlyPrice")
    def yearly_price(self) -> pulumi.Output['outputs.RegistrationYearlyPrice']:
        """
        Required. Yearly price to register or renew the domain. The value that should be put here can be obtained from
        registrations.retrieveRegisterParameters or registrations.searchDomains calls.
        Structure is documented below.
        """
        return pulumi.get(self, "yearly_price")

