# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 build_config: Optional[pulumi.Input['FunctionBuildConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_trigger: Optional[pulumi.Input['FunctionEventTriggerArgs']] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_config: Optional[pulumi.Input['FunctionServiceConfigArgs']] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[str] location: The location of this cloud function.
               
               
               - - -
        :param pulumi.Input['FunctionBuildConfigArgs'] build_config: Describes the Build step of the function that builds a container
               from the given source.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input['FunctionEventTriggerArgs'] event_trigger: An Eventarc trigger managed by Google Cloud Functions that fires events in
               response to a condition in another service.
               Structure is documented below.
        :param pulumi.Input[str] kms_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
               It must match the pattern projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs associated with this Cloud Function.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must
               be unique globally and match pattern `projects/*/locations/*/functions/*`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['FunctionServiceConfigArgs'] service_config: Describes the Service being deployed.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        if build_config is not None:
            pulumi.set(__self__, "build_config", build_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_config is not None:
            pulumi.set(__self__, "service_config", service_config)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location of this cloud function.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> Optional[pulumi.Input['FunctionBuildConfigArgs']]:
        """
        Describes the Build step of the function that builds a container
        from the given source.
        Structure is documented below.
        """
        return pulumi.get(self, "build_config")

    @build_config.setter
    def build_config(self, value: Optional[pulumi.Input['FunctionBuildConfigArgs']]):
        pulumi.set(self, "build_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description of a function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['FunctionEventTriggerArgs']]:
        """
        An Eventarc trigger managed by Google Cloud Functions that fires events in
        response to a condition in another service.
        Structure is documented below.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['FunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
        It must match the pattern projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs associated with this Cloud Function.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the function. Function names must
        be unique globally and match pattern `projects/*/locations/*/functions/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> Optional[pulumi.Input['FunctionServiceConfigArgs']]:
        """
        Describes the Service being deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "service_config")

    @service_config.setter
    def service_config(self, value: Optional[pulumi.Input['FunctionServiceConfigArgs']]):
        pulumi.set(self, "service_config", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 build_config: Optional[pulumi.Input['FunctionBuildConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 event_trigger: Optional[pulumi.Input['FunctionEventTriggerArgs']] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 service_config: Optional[pulumi.Input['FunctionServiceConfigArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input['FunctionBuildConfigArgs'] build_config: Describes the Build step of the function that builds a container
               from the given source.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] environment: The environment the function is hosted on.
        :param pulumi.Input['FunctionEventTriggerArgs'] event_trigger: An Eventarc trigger managed by Google Cloud Functions that fires events in
               response to a condition in another service.
               Structure is documented below.
        :param pulumi.Input[str] kms_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
               It must match the pattern projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs associated with this Cloud Function.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location of this cloud function.
               
               
               - - -
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must
               be unique globally and match pattern `projects/*/locations/*/functions/*`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['FunctionServiceConfigArgs'] service_config: Describes the Service being deployed.
               Structure is documented below.
        :param pulumi.Input[str] state: Describes the current state of the function.
        :param pulumi.Input[str] update_time: The last update timestamp of a Cloud Function.
        :param pulumi.Input[str] url: Output only. The deployed url for the function.
        """
        if build_config is not None:
            pulumi.set(__self__, "build_config", build_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if service_config is not None:
            pulumi.set(__self__, "service_config", service_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> Optional[pulumi.Input['FunctionBuildConfigArgs']]:
        """
        Describes the Build step of the function that builds a container
        from the given source.
        Structure is documented below.
        """
        return pulumi.get(self, "build_config")

    @build_config.setter
    def build_config(self, value: Optional[pulumi.Input['FunctionBuildConfigArgs']]):
        pulumi.set(self, "build_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description of a function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The environment the function is hosted on.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['FunctionEventTriggerArgs']]:
        """
        An Eventarc trigger managed by Google Cloud Functions that fires events in
        response to a condition in another service.
        Structure is documented below.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['FunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
        It must match the pattern projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs associated with this Cloud Function.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of this cloud function.


        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the function. Function names must
        be unique globally and match pattern `projects/*/locations/*/functions/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> Optional[pulumi.Input['FunctionServiceConfigArgs']]:
        """
        Describes the Service being deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "service_config")

    @service_config.setter
    def service_config(self, value: Optional[pulumi.Input['FunctionServiceConfigArgs']]):
        pulumi.set(self, "service_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the current state of the function.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last update timestamp of a Cloud Function.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The deployed url for the function.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_config: Optional[pulumi.Input[Union['FunctionBuildConfigArgs', 'FunctionBuildConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_trigger: Optional[pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_config: Optional[pulumi.Input[Union['FunctionServiceConfigArgs', 'FunctionServiceConfigArgsDict']]] = None,
                 __props__=None):
        """
        A Cloud Function that contains user computation executed in response to an event.

        To get more information about function, see:

        * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v2beta/projects.locations.functions)

        ## Example Usage

        ### Cloudfunctions2 Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-v2",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            })
        ```
        ### Cloudfunctions2 Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        topic = gcp.pubsub.Topic("topic", name="functions2-topic")
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloPubSub",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "4Gi",
                "timeout_seconds": 60,
                "max_instance_request_concurrency": 80,
                "available_cpu": "4",
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                    "servic_e__confi_g__dif_f__test": account.email,
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "trigger_region": "us-central1",
                "event_type": "google.cloud.pubsub.topic.v1.messagePublished",
                "pubsub_topic": topic.id,
                "retry_policy": "RETRY_POLICY_RETRY",
            })
        ```
        ### Cloudfunctions2 Scheduler Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "min_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "service_account_email": account.email,
            })
        invoker = gcp.cloudfunctionsv2.FunctionIamMember("invoker",
            project=function.project,
            location=function.location,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        cloud_run_invoker = gcp.cloudrun.IamMember("cloud_run_invoker",
            project=function.project,
            location=function.location,
            service=function.name,
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        invoke_cloud_function = gcp.cloudscheduler.Job("invoke_cloud_function",
            name="invoke-gcf-function",
            description="Schedule the HTTPS trigger for cloud function",
            schedule="0 0 * * *",
            project=function.project,
            region=function.location,
            http_target={
                "uri": function.service_config.uri,
                "http_method": "POST",
                "oidc_token": {
                    "audience": function.service_config.apply(lambda service_config: f"{service_config.uri}/"),
                    "service_account_email": account.email,
                },
            })
        ```
        ### Cloudfunctions2 Basic Gcs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source_bucket = gcp.storage.Bucket("source-bucket",
            name="gcf-source-bucket",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=source_bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        trigger_bucket = gcp.storage.Bucket("trigger-bucket",
            name="gcf-trigger-bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        gcs_account = gcp.storage.get_project_service_account()
        # To use GCS CloudEvent triggers, the GCS service account requires the Pub/Sub Publisher(roles/pubsub.publisher) IAM role in the specified project.
        # (See https://cloud.google.com/eventarc/docs/run/quickstart-storage#before-you-begin)
        gcs_pubsub_publishing = gcp.projects.IAMMember("gcs-pubsub-publishing",
            project="my-project-name",
            role="roles/pubsub.publisher",
            member=f"serviceAccount:{gcs_account.email_address}")
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account - used for both the cloud function and eventarc trigger in the test")
        # Permissions on the service account used by the function and Eventarc trigger
        invoking = gcp.projects.IAMMember("invoking",
            project="my-project-name",
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[gcs_pubsub_publishing]))
        event_receiving = gcp.projects.IAMMember("event-receiving",
            project="my-project-name",
            role="roles/eventarc.eventReceiver",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[invoking]))
        artifactregistry_reader = gcp.projects.IAMMember("artifactregistry-reader",
            project="my-project-name",
            role="roles/artifactregistry.reader",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[event_receiving]))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs12",
                "entry_point": "entryPoint",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": source_bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "event_type": "google.cloud.storage.object.v1.finalized",
                "retry_policy": "RETRY_POLICY_RETRY",
                "service_account_email": account.email,
                "event_filters": [{
                    "attribute": "bucket",
                    "value": trigger_bucket.name,
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    event_receiving,
                    artifactregistry_reader,
                ]))
        ```
        ### Cloudfunctions2 Basic Auditlogs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example follows the examples shown in this Google Cloud Community blog post
        # https://medium.com/google-cloud/applying-a-path-pattern-when-filtering-in-eventarc-f06b937b4c34
        # and the docs:
        # https://cloud.google.com/eventarc/docs/path-patterns
        source_bucket = gcp.storage.Bucket("source-bucket",
            name="gcf-source-bucket",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=source_bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account - used for both the cloud function and eventarc trigger in the test")
        # Note: The right way of listening for Cloud Storage events is to use a Cloud Storage trigger.
        # Here we use Audit Logs to monitor the bucket so path patterns can be used in the example of
        # google_cloudfunctions2_function below (Audit Log events have path pattern support)
        audit_log_bucket = gcp.storage.Bucket("audit-log-bucket",
            name="gcf-auditlog-bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        # Permissions on the service account used by the function and Eventarc trigger
        invoking = gcp.projects.IAMMember("invoking",
            project="my-project-name",
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        event_receiving = gcp.projects.IAMMember("event-receiving",
            project="my-project-name",
            role="roles/eventarc.eventReceiver",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[invoking]))
        artifactregistry_reader = gcp.projects.IAMMember("artifactregistry-reader",
            project="my-project-name",
            role="roles/artifactregistry.reader",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[event_receiving]))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs12",
                "entry_point": "entryPoint",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": source_bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "trigger_region": "us-central1",
                "event_type": "google.cloud.audit.log.v1.written",
                "retry_policy": "RETRY_POLICY_RETRY",
                "service_account_email": account.email,
                "event_filters": [
                    {
                        "attribute": "serviceName",
                        "value": "storage.googleapis.com",
                    },
                    {
                        "attribute": "methodName",
                        "value": "storage.objects.create",
                    },
                    {
                        "attribute": "resourceName",
                        "value": audit_log_bucket.name.apply(lambda name: f"/projects/_/buckets/{name}/objects/*.txt"),
                        "operator": "match-path-pattern",
                    },
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    event_receiving,
                    artifactregistry_reader,
                ]))
        ```
        ### Cloudfunctions2 Basic Builder

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        log_writer = gcp.projects.IAMMember("log_writer",
            project=account.project,
            role="roles/logging.logWriter",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        artifact_registry_writer = gcp.projects.IAMMember("artifact_registry_writer",
            project=account.project,
            role="roles/artifactregistry.writer",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        storage_object_admin = gcp.projects.IAMMember("storage_object_admin",
            project=account.project,
            role="roles/storage.objectAdmin",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        # builder permissions need to stablize before it can pull the source zip
        wait60s = time.index.Sleep("wait_60s", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[
                log_writer,
                artifact_registry_writer,
                storage_object_admin,
            ]))
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-v2",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
                "service_account": account.id,
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            },
            opts = pulumi.ResourceOptions(depends_on=[wait60s]))
        ```
        ### Cloudfunctions2 Secret Env

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_secret_version = gcp.secretmanager.SecretVersion("secret",
            secret=secret.name,
            secret_data="secret",
            enabled=True)
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-secret",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "secret_environment_variables": [{
                    "key": "TEST",
                    "project_id": project,
                    "secret": secret.secret_id,
                    "version": "latest",
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[secret_secret_version]))
        ```
        ### Cloudfunctions2 Secret Volume

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_secret_version = gcp.secretmanager.SecretVersion("secret",
            secret=secret.name,
            secret_data="secret",
            enabled=True)
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-secret",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "secret_volumes": [{
                    "mount_path": "/etc/secrets",
                    "project_id": project,
                    "secret": secret.secret_id,
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[secret_secret_version]))
        ```
        ### Cloudfunctions2 Private Workerpool

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        pool = gcp.cloudbuild.WorkerPool("pool",
            name="workerpool",
            location="us-central1",
            worker_config={
                "disk_size_gb": 100,
                "machine_type": "e2-standard-8",
                "no_external_ip": False,
            })
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-workerpool",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
                "worker_pool": pool.id,
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            })
        ```
        ### Cloudfunctions2 Cmek Docs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        project_get_project = gcp.organizations.get_project()
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        ea_sa = gcp.projects.ServiceIdentity("ea_sa",
            project=project_get_project.project_id,
            service="eventarc.googleapis.com")
        unencoded_ar_repo = gcp.artifactregistry.Repository("unencoded-ar-repo",
            repository_id="ar-repo",
            location="us-central1",
            format="DOCKER")
        gcf_cmek_keyuser = gcp.kms.CryptoKeyIAMBinding("gcf_cmek_keyuser",
            crypto_key_id="cmek-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[
                f"serviceAccount:service-{project_get_project.number}@gcf-admin-robot.iam.gserviceaccount.com",
                f"serviceAccount:service-{project_get_project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com",
                f"serviceAccount:service-{project_get_project.number}@gs-project-accounts.iam.gserviceaccount.com",
                f"serviceAccount:service-{project_get_project.number}@serverless-robot-prod.iam.gserviceaccount.com",
                ea_sa.member,
            ],
            opts = pulumi.ResourceOptions(depends_on=[ea_sa]))
        encoded_ar_repo = gcp.artifactregistry.Repository("encoded-ar-repo",
            location="us-central1",
            repository_id="cmek-repo",
            format="DOCKER",
            kms_key_name="cmek-key",
            opts = pulumi.ResourceOptions(depends_on=[gcf_cmek_keyuser]))
        binding = gcp.artifactregistry.RepositoryIamBinding("binding",
            location=encoded_ar_repo.location,
            repository=encoded_ar_repo.name,
            role="roles/artifactregistry.admin",
            members=[f"serviceAccount:service-{project_get_project.number}@gcf-admin-robot.iam.gserviceaccount.com"])
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-cmek",
            location="us-central1",
            description="CMEK function",
            kms_key_name="cmek-key",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "docker_repository": encoded_ar_repo.id,
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            },
            opts = pulumi.ResourceOptions(depends_on=[gcf_cmek_keyuser]))
        ```
        ### Cloudfunctions2 Abiu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        topic = gcp.pubsub.Topic("topic", name="functions2-topic")
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="europe-west6",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloPubSub",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
                "automatic_update_policy": {},
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "4Gi",
                "timeout_seconds": 60,
                "max_instance_request_concurrency": 80,
                "available_cpu": "4",
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "trigger_region": "us-central1",
                "event_type": "google.cloud.pubsub.topic.v1.messagePublished",
                "pubsub_topic": topic.id,
                "retry_policy": "RETRY_POLICY_RETRY",
            })
        ```
        ### Cloudfunctions2 Abiu On Deploy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        topic = gcp.pubsub.Topic("topic", name="functions2-topic")
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="europe-west6",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloPubSub",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
                "on_deploy_update_policy": {},
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "4Gi",
                "timeout_seconds": 60,
                "max_instance_request_concurrency": 80,
                "available_cpu": "4",
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "trigger_region": "us-central1",
                "event_type": "google.cloud.pubsub.topic.v1.messagePublished",
                "pubsub_topic": topic.id,
                "retry_policy": "RETRY_POLICY_RETRY",
            })
        ```

        ## Import

        function can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/functions/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, function can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudfunctionsv2/function:Function default projects/{{project}}/locations/{{location}}/functions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudfunctionsv2/function:Function default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudfunctionsv2/function:Function default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionBuildConfigArgs', 'FunctionBuildConfigArgsDict']] build_config: Describes the Build step of the function that builds a container
               from the given source.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']] event_trigger: An Eventarc trigger managed by Google Cloud Functions that fires events in
               response to a condition in another service.
               Structure is documented below.
        :param pulumi.Input[str] kms_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
               It must match the pattern projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs associated with this Cloud Function.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location of this cloud function.
               
               
               - - -
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must
               be unique globally and match pattern `projects/*/locations/*/functions/*`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['FunctionServiceConfigArgs', 'FunctionServiceConfigArgsDict']] service_config: Describes the Service being deployed.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Function that contains user computation executed in response to an event.

        To get more information about function, see:

        * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v2beta/projects.locations.functions)

        ## Example Usage

        ### Cloudfunctions2 Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-v2",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            })
        ```
        ### Cloudfunctions2 Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        topic = gcp.pubsub.Topic("topic", name="functions2-topic")
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloPubSub",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "4Gi",
                "timeout_seconds": 60,
                "max_instance_request_concurrency": 80,
                "available_cpu": "4",
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                    "servic_e__confi_g__dif_f__test": account.email,
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "trigger_region": "us-central1",
                "event_type": "google.cloud.pubsub.topic.v1.messagePublished",
                "pubsub_topic": topic.id,
                "retry_policy": "RETRY_POLICY_RETRY",
            })
        ```
        ### Cloudfunctions2 Scheduler Auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "min_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "service_account_email": account.email,
            })
        invoker = gcp.cloudfunctionsv2.FunctionIamMember("invoker",
            project=function.project,
            location=function.location,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        cloud_run_invoker = gcp.cloudrun.IamMember("cloud_run_invoker",
            project=function.project,
            location=function.location,
            service=function.name,
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        invoke_cloud_function = gcp.cloudscheduler.Job("invoke_cloud_function",
            name="invoke-gcf-function",
            description="Schedule the HTTPS trigger for cloud function",
            schedule="0 0 * * *",
            project=function.project,
            region=function.location,
            http_target={
                "uri": function.service_config.uri,
                "http_method": "POST",
                "oidc_token": {
                    "audience": function.service_config.apply(lambda service_config: f"{service_config.uri}/"),
                    "service_account_email": account.email,
                },
            })
        ```
        ### Cloudfunctions2 Basic Gcs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        source_bucket = gcp.storage.Bucket("source-bucket",
            name="gcf-source-bucket",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=source_bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        trigger_bucket = gcp.storage.Bucket("trigger-bucket",
            name="gcf-trigger-bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        gcs_account = gcp.storage.get_project_service_account()
        # To use GCS CloudEvent triggers, the GCS service account requires the Pub/Sub Publisher(roles/pubsub.publisher) IAM role in the specified project.
        # (See https://cloud.google.com/eventarc/docs/run/quickstart-storage#before-you-begin)
        gcs_pubsub_publishing = gcp.projects.IAMMember("gcs-pubsub-publishing",
            project="my-project-name",
            role="roles/pubsub.publisher",
            member=f"serviceAccount:{gcs_account.email_address}")
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account - used for both the cloud function and eventarc trigger in the test")
        # Permissions on the service account used by the function and Eventarc trigger
        invoking = gcp.projects.IAMMember("invoking",
            project="my-project-name",
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[gcs_pubsub_publishing]))
        event_receiving = gcp.projects.IAMMember("event-receiving",
            project="my-project-name",
            role="roles/eventarc.eventReceiver",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[invoking]))
        artifactregistry_reader = gcp.projects.IAMMember("artifactregistry-reader",
            project="my-project-name",
            role="roles/artifactregistry.reader",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[event_receiving]))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs12",
                "entry_point": "entryPoint",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": source_bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "event_type": "google.cloud.storage.object.v1.finalized",
                "retry_policy": "RETRY_POLICY_RETRY",
                "service_account_email": account.email,
                "event_filters": [{
                    "attribute": "bucket",
                    "value": trigger_bucket.name,
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    event_receiving,
                    artifactregistry_reader,
                ]))
        ```
        ### Cloudfunctions2 Basic Auditlogs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example follows the examples shown in this Google Cloud Community blog post
        # https://medium.com/google-cloud/applying-a-path-pattern-when-filtering-in-eventarc-f06b937b4c34
        # and the docs:
        # https://cloud.google.com/eventarc/docs/path-patterns
        source_bucket = gcp.storage.Bucket("source-bucket",
            name="gcf-source-bucket",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=source_bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account - used for both the cloud function and eventarc trigger in the test")
        # Note: The right way of listening for Cloud Storage events is to use a Cloud Storage trigger.
        # Here we use Audit Logs to monitor the bucket so path patterns can be used in the example of
        # google_cloudfunctions2_function below (Audit Log events have path pattern support)
        audit_log_bucket = gcp.storage.Bucket("audit-log-bucket",
            name="gcf-auditlog-bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        # Permissions on the service account used by the function and Eventarc trigger
        invoking = gcp.projects.IAMMember("invoking",
            project="my-project-name",
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        event_receiving = gcp.projects.IAMMember("event-receiving",
            project="my-project-name",
            role="roles/eventarc.eventReceiver",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[invoking]))
        artifactregistry_reader = gcp.projects.IAMMember("artifactregistry-reader",
            project="my-project-name",
            role="roles/artifactregistry.reader",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts = pulumi.ResourceOptions(depends_on=[event_receiving]))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs12",
                "entry_point": "entryPoint",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": source_bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "trigger_region": "us-central1",
                "event_type": "google.cloud.audit.log.v1.written",
                "retry_policy": "RETRY_POLICY_RETRY",
                "service_account_email": account.email,
                "event_filters": [
                    {
                        "attribute": "serviceName",
                        "value": "storage.googleapis.com",
                    },
                    {
                        "attribute": "methodName",
                        "value": "storage.objects.create",
                    },
                    {
                        "attribute": "resourceName",
                        "value": audit_log_bucket.name.apply(lambda name: f"/projects/_/buckets/{name}/objects/*.txt"),
                        "operator": "match-path-pattern",
                    },
                ],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    event_receiving,
                    artifactregistry_reader,
                ]))
        ```
        ### Cloudfunctions2 Basic Builder

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        log_writer = gcp.projects.IAMMember("log_writer",
            project=account.project,
            role="roles/logging.logWriter",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        artifact_registry_writer = gcp.projects.IAMMember("artifact_registry_writer",
            project=account.project,
            role="roles/artifactregistry.writer",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        storage_object_admin = gcp.projects.IAMMember("storage_object_admin",
            project=account.project,
            role="roles/storage.objectAdmin",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        # builder permissions need to stablize before it can pull the source zip
        wait60s = time.index.Sleep("wait_60s", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[
                log_writer,
                artifact_registry_writer,
                storage_object_admin,
            ]))
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-v2",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
                "service_account": account.id,
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            },
            opts = pulumi.ResourceOptions(depends_on=[wait60s]))
        ```
        ### Cloudfunctions2 Secret Env

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_secret_version = gcp.secretmanager.SecretVersion("secret",
            secret=secret.name,
            secret_data="secret",
            enabled=True)
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-secret",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "secret_environment_variables": [{
                    "key": "TEST",
                    "project_id": project,
                    "secret": secret.secret_id,
                    "version": "latest",
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[secret_secret_version]))
        ```
        ### Cloudfunctions2 Secret Volume

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "user_managed": {
                    "replicas": [{
                        "location": "us-central1",
                    }],
                },
            })
        secret_secret_version = gcp.secretmanager.SecretVersion("secret",
            secret=secret.name,
            secret_data="secret",
            enabled=True)
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-secret",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
                "secret_volumes": [{
                    "mount_path": "/etc/secrets",
                    "project_id": project,
                    "secret": secret.secret_id,
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[secret_secret_version]))
        ```
        ### Cloudfunctions2 Private Workerpool

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        pool = gcp.cloudbuild.WorkerPool("pool",
            name="workerpool",
            location="us-central1",
            worker_config={
                "disk_size_gb": 100,
                "machine_type": "e2-standard-8",
                "no_external_ip": False,
            })
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-workerpool",
            location="us-central1",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
                "worker_pool": pool.id,
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            })
        ```
        ### Cloudfunctions2 Cmek Docs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        project_get_project = gcp.organizations.get_project()
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        ea_sa = gcp.projects.ServiceIdentity("ea_sa",
            project=project_get_project.project_id,
            service="eventarc.googleapis.com")
        unencoded_ar_repo = gcp.artifactregistry.Repository("unencoded-ar-repo",
            repository_id="ar-repo",
            location="us-central1",
            format="DOCKER")
        gcf_cmek_keyuser = gcp.kms.CryptoKeyIAMBinding("gcf_cmek_keyuser",
            crypto_key_id="cmek-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            members=[
                f"serviceAccount:service-{project_get_project.number}@gcf-admin-robot.iam.gserviceaccount.com",
                f"serviceAccount:service-{project_get_project.number}@gcp-sa-artifactregistry.iam.gserviceaccount.com",
                f"serviceAccount:service-{project_get_project.number}@gs-project-accounts.iam.gserviceaccount.com",
                f"serviceAccount:service-{project_get_project.number}@serverless-robot-prod.iam.gserviceaccount.com",
                ea_sa.member,
            ],
            opts = pulumi.ResourceOptions(depends_on=[ea_sa]))
        encoded_ar_repo = gcp.artifactregistry.Repository("encoded-ar-repo",
            location="us-central1",
            repository_id="cmek-repo",
            format="DOCKER",
            kms_key_name="cmek-key",
            opts = pulumi.ResourceOptions(depends_on=[gcf_cmek_keyuser]))
        binding = gcp.artifactregistry.RepositoryIamBinding("binding",
            location=encoded_ar_repo.location,
            repository=encoded_ar_repo.name,
            role="roles/artifactregistry.admin",
            members=[f"serviceAccount:service-{project_get_project.number}@gcf-admin-robot.iam.gserviceaccount.com"])
        function = gcp.cloudfunctionsv2.Function("function",
            name="function-cmek",
            location="us-central1",
            description="CMEK function",
            kms_key_name="cmek-key",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloHttp",
                "docker_repository": encoded_ar_repo.id,
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
            },
            service_config={
                "max_instance_count": 1,
                "available_memory": "256M",
                "timeout_seconds": 60,
            },
            opts = pulumi.ResourceOptions(depends_on=[gcf_cmek_keyuser]))
        ```
        ### Cloudfunctions2 Abiu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        topic = gcp.pubsub.Topic("topic", name="functions2-topic")
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="europe-west6",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloPubSub",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
                "automatic_update_policy": {},
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "4Gi",
                "timeout_seconds": 60,
                "max_instance_request_concurrency": 80,
                "available_cpu": "4",
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "trigger_region": "us-central1",
                "event_type": "google.cloud.pubsub.topic.v1.messagePublished",
                "pubsub_topic": topic.id,
                "retry_policy": "RETRY_POLICY_RETRY",
            })
        ```
        ### Cloudfunctions2 Abiu On Deploy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = "my-project-name"
        account = gcp.serviceaccount.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account")
        topic = gcp.pubsub.Topic("topic", name="functions2-topic")
        bucket = gcp.storage.Bucket("bucket",
            name=f"{project}-gcf-source",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            name="function-source.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        function = gcp.cloudfunctionsv2.Function("function",
            name="gcf-function",
            location="europe-west6",
            description="a new function",
            build_config={
                "runtime": "nodejs16",
                "entry_point": "helloPubSub",
                "environment_variables": {
                    "buil_d__confi_g__test": "build_test",
                },
                "source": {
                    "storage_source": {
                        "bucket": bucket.name,
                        "object": object.name,
                    },
                },
                "on_deploy_update_policy": {},
            },
            service_config={
                "max_instance_count": 3,
                "min_instance_count": 1,
                "available_memory": "4Gi",
                "timeout_seconds": 60,
                "max_instance_request_concurrency": 80,
                "available_cpu": "4",
                "environment_variables": {
                    "servic_e__confi_g__test": "config_test",
                },
                "ingress_settings": "ALLOW_INTERNAL_ONLY",
                "all_traffic_on_latest_revision": True,
                "service_account_email": account.email,
            },
            event_trigger={
                "trigger_region": "us-central1",
                "event_type": "google.cloud.pubsub.topic.v1.messagePublished",
                "pubsub_topic": topic.id,
                "retry_policy": "RETRY_POLICY_RETRY",
            })
        ```

        ## Import

        function can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/functions/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, function can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudfunctionsv2/function:Function default projects/{{project}}/locations/{{location}}/functions/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudfunctionsv2/function:Function default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudfunctionsv2/function:Function default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_config: Optional[pulumi.Input[Union['FunctionBuildConfigArgs', 'FunctionBuildConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_trigger: Optional[pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_config: Optional[pulumi.Input[Union['FunctionServiceConfigArgs', 'FunctionServiceConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["build_config"] = build_config
            __props__.__dict__["description"] = description
            __props__.__dict__["event_trigger"] = event_trigger
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["service_config"] = service_config
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["environment"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Function, __self__).__init__(
            'gcp:cloudfunctionsv2/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            build_config: Optional[pulumi.Input[Union['FunctionBuildConfigArgs', 'FunctionBuildConfigArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            event_trigger: Optional[pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']]] = None,
            kms_key_name: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            service_config: Optional[pulumi.Input[Union['FunctionServiceConfigArgs', 'FunctionServiceConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionBuildConfigArgs', 'FunctionBuildConfigArgsDict']] build_config: Describes the Build step of the function that builds a container
               from the given source.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[str] environment: The environment the function is hosted on.
        :param pulumi.Input[Union['FunctionEventTriggerArgs', 'FunctionEventTriggerArgsDict']] event_trigger: An Eventarc trigger managed by Google Cloud Functions that fires events in
               response to a condition in another service.
               Structure is documented below.
        :param pulumi.Input[str] kms_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
               It must match the pattern projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs associated with this Cloud Function.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location of this cloud function.
               
               
               - - -
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must
               be unique globally and match pattern `projects/*/locations/*/functions/*`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['FunctionServiceConfigArgs', 'FunctionServiceConfigArgsDict']] service_config: Describes the Service being deployed.
               Structure is documented below.
        :param pulumi.Input[str] state: Describes the current state of the function.
        :param pulumi.Input[str] update_time: The last update timestamp of a Cloud Function.
        :param pulumi.Input[str] url: Output only. The deployed url for the function.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["build_config"] = build_config
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["environment"] = environment
        __props__.__dict__["event_trigger"] = event_trigger
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["service_config"] = service_config
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["url"] = url
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> pulumi.Output[Optional['outputs.FunctionBuildConfig']]:
        """
        Describes the Build step of the function that builds a container
        from the given source.
        Structure is documented below.
        """
        return pulumi.get(self, "build_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        User-provided description of a function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[str]:
        """
        The environment the function is hosted on.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> pulumi.Output[Optional['outputs.FunctionEventTrigger']]:
        """
        An Eventarc trigger managed by Google Cloud Functions that fires events in
        response to a condition in another service.
        Structure is documented below.
        """
        return pulumi.get(self, "event_trigger")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
        It must match the pattern projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs associated with this Cloud Function.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of this cloud function.


        - - -
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-defined name of the function. Function names must
        be unique globally and match pattern `projects/*/locations/*/functions/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> pulumi.Output[Optional['outputs.FunctionServiceConfig']]:
        """
        Describes the Service being deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "service_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Describes the current state of the function.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The last update timestamp of a Cloud Function.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        Output only. The deployed url for the function.
        """
        return pulumi.get(self, "url")

