# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGroupLookupResult',
    'AwaitableGetGroupLookupResult',
    'get_group_lookup',
    'get_group_lookup_output',
]

@pulumi.output_type
class GetGroupLookupResult:
    """
    A collection of values returned by getGroupLookup.
    """
    def __init__(__self__, group_key=None, id=None, name=None):
        if group_key and not isinstance(group_key, dict):
            raise TypeError("Expected argument 'group_key' to be a dict")
        pulumi.set(__self__, "group_key", group_key)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="groupKey")
    def group_key(self) -> 'outputs.GetGroupLookupGroupKeyResult':
        return pulumi.get(self, "group_key")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the Group in the format: groups/{group_id}, where `group_id` is the unique ID assigned to the Group.
        """
        return pulumi.get(self, "name")


class AwaitableGetGroupLookupResult(GetGroupLookupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupLookupResult(
            group_key=self.group_key,
            id=self.id,
            name=self.name)


def get_group_lookup(group_key: Optional[Union['GetGroupLookupGroupKeyArgs', 'GetGroupLookupGroupKeyArgsDict']] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupLookupResult:
    """
    Use this data source to look up the resource name of a Cloud Identity Group by its [EntityKey](https://cloud.google.com/identity/docs/reference/rest/v1/EntityKey), i.e. the group's email.

    https://cloud.google.com/identity/docs/concepts/overview#groups

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    group = gcp.cloudidentity.get_group_lookup(group_key={
        "id": "my-group@example.com",
    })
    ```


    :param Union['GetGroupLookupGroupKeyArgs', 'GetGroupLookupGroupKeyArgsDict'] group_key: The EntityKey of the Group to lookup. A unique identifier for an entity in the Cloud Identity Groups API.
           An entity can represent either a group with an optional namespace or a user without a namespace.
           The combination of id and namespace must be unique; however, the same id can be used with different namespaces. Structure is documented below.
    """
    __args__ = dict()
    __args__['groupKey'] = group_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:cloudidentity/getGroupLookup:getGroupLookup', __args__, opts=opts, typ=GetGroupLookupResult).value

    return AwaitableGetGroupLookupResult(
        group_key=pulumi.get(__ret__, 'group_key'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_group_lookup)
def get_group_lookup_output(group_key: Optional[pulumi.Input[Union['GetGroupLookupGroupKeyArgs', 'GetGroupLookupGroupKeyArgsDict']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGroupLookupResult]:
    """
    Use this data source to look up the resource name of a Cloud Identity Group by its [EntityKey](https://cloud.google.com/identity/docs/reference/rest/v1/EntityKey), i.e. the group's email.

    https://cloud.google.com/identity/docs/concepts/overview#groups

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    group = gcp.cloudidentity.get_group_lookup(group_key={
        "id": "my-group@example.com",
    })
    ```


    :param Union['GetGroupLookupGroupKeyArgs', 'GetGroupLookupGroupKeyArgsDict'] group_key: The EntityKey of the Group to lookup. A unique identifier for an entity in the Cloud Identity Groups API.
           An entity can represent either a group with an optional namespace or a user without a namespace.
           The combination of id and namespace must be unique; however, the same id can be used with different namespaces. Structure is documented below.
    """
    ...
