# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'JobBinaryAuthorization',
    'JobCondition',
    'JobIamBindingCondition',
    'JobIamMemberCondition',
    'JobLatestCreatedExecution',
    'JobTemplate',
    'JobTemplateTemplate',
    'JobTemplateTemplateContainer',
    'JobTemplateTemplateContainerEnv',
    'JobTemplateTemplateContainerEnvValueSource',
    'JobTemplateTemplateContainerEnvValueSourceSecretKeyRef',
    'JobTemplateTemplateContainerPort',
    'JobTemplateTemplateContainerResources',
    'JobTemplateTemplateContainerVolumeMount',
    'JobTemplateTemplateVolume',
    'JobTemplateTemplateVolumeCloudSqlInstance',
    'JobTemplateTemplateVolumeEmptyDir',
    'JobTemplateTemplateVolumeGcs',
    'JobTemplateTemplateVolumeNfs',
    'JobTemplateTemplateVolumeSecret',
    'JobTemplateTemplateVolumeSecretItem',
    'JobTemplateTemplateVpcAccess',
    'JobTemplateTemplateVpcAccessNetworkInterface',
    'JobTerminalCondition',
    'ServiceBinaryAuthorization',
    'ServiceCondition',
    'ServiceIamBindingCondition',
    'ServiceIamMemberCondition',
    'ServiceScaling',
    'ServiceTemplate',
    'ServiceTemplateContainer',
    'ServiceTemplateContainerEnv',
    'ServiceTemplateContainerEnvValueSource',
    'ServiceTemplateContainerEnvValueSourceSecretKeyRef',
    'ServiceTemplateContainerLivenessProbe',
    'ServiceTemplateContainerLivenessProbeGrpc',
    'ServiceTemplateContainerLivenessProbeHttpGet',
    'ServiceTemplateContainerLivenessProbeHttpGetHttpHeader',
    'ServiceTemplateContainerLivenessProbeTcpSocket',
    'ServiceTemplateContainerPorts',
    'ServiceTemplateContainerResources',
    'ServiceTemplateContainerStartupProbe',
    'ServiceTemplateContainerStartupProbeGrpc',
    'ServiceTemplateContainerStartupProbeHttpGet',
    'ServiceTemplateContainerStartupProbeHttpGetHttpHeader',
    'ServiceTemplateContainerStartupProbeTcpSocket',
    'ServiceTemplateContainerVolumeMount',
    'ServiceTemplateNodeSelector',
    'ServiceTemplateScaling',
    'ServiceTemplateServiceMesh',
    'ServiceTemplateVolume',
    'ServiceTemplateVolumeCloudSqlInstance',
    'ServiceTemplateVolumeEmptyDir',
    'ServiceTemplateVolumeGcs',
    'ServiceTemplateVolumeNfs',
    'ServiceTemplateVolumeSecret',
    'ServiceTemplateVolumeSecretItem',
    'ServiceTemplateVpcAccess',
    'ServiceTemplateVpcAccessNetworkInterface',
    'ServiceTerminalCondition',
    'ServiceTraffic',
    'ServiceTrafficStatus',
    'GetJobBinaryAuthorizationResult',
    'GetJobConditionResult',
    'GetJobLatestCreatedExecutionResult',
    'GetJobTemplateResult',
    'GetJobTemplateTemplateResult',
    'GetJobTemplateTemplateContainerResult',
    'GetJobTemplateTemplateContainerEnvResult',
    'GetJobTemplateTemplateContainerEnvValueSourceResult',
    'GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefResult',
    'GetJobTemplateTemplateContainerPortResult',
    'GetJobTemplateTemplateContainerResourceResult',
    'GetJobTemplateTemplateContainerVolumeMountResult',
    'GetJobTemplateTemplateVolumeResult',
    'GetJobTemplateTemplateVolumeCloudSqlInstanceResult',
    'GetJobTemplateTemplateVolumeEmptyDirResult',
    'GetJobTemplateTemplateVolumeGcResult',
    'GetJobTemplateTemplateVolumeNfResult',
    'GetJobTemplateTemplateVolumeSecretResult',
    'GetJobTemplateTemplateVolumeSecretItemResult',
    'GetJobTemplateTemplateVpcAccessResult',
    'GetJobTemplateTemplateVpcAccessNetworkInterfaceResult',
    'GetJobTerminalConditionResult',
    'GetServiceBinaryAuthorizationResult',
    'GetServiceConditionResult',
    'GetServiceScalingResult',
    'GetServiceTemplateResult',
    'GetServiceTemplateContainerResult',
    'GetServiceTemplateContainerEnvResult',
    'GetServiceTemplateContainerEnvValueSourceResult',
    'GetServiceTemplateContainerEnvValueSourceSecretKeyRefResult',
    'GetServiceTemplateContainerLivenessProbeResult',
    'GetServiceTemplateContainerLivenessProbeGrpcResult',
    'GetServiceTemplateContainerLivenessProbeHttpGetResult',
    'GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderResult',
    'GetServiceTemplateContainerLivenessProbeTcpSocketResult',
    'GetServiceTemplateContainerPortResult',
    'GetServiceTemplateContainerResourceResult',
    'GetServiceTemplateContainerStartupProbeResult',
    'GetServiceTemplateContainerStartupProbeGrpcResult',
    'GetServiceTemplateContainerStartupProbeHttpGetResult',
    'GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderResult',
    'GetServiceTemplateContainerStartupProbeTcpSocketResult',
    'GetServiceTemplateContainerVolumeMountResult',
    'GetServiceTemplateNodeSelectorResult',
    'GetServiceTemplateScalingResult',
    'GetServiceTemplateServiceMeshResult',
    'GetServiceTemplateVolumeResult',
    'GetServiceTemplateVolumeCloudSqlInstanceResult',
    'GetServiceTemplateVolumeEmptyDirResult',
    'GetServiceTemplateVolumeGcResult',
    'GetServiceTemplateVolumeNfResult',
    'GetServiceTemplateVolumeSecretResult',
    'GetServiceTemplateVolumeSecretItemResult',
    'GetServiceTemplateVpcAccessResult',
    'GetServiceTemplateVpcAccessNetworkInterfaceResult',
    'GetServiceTerminalConditionResult',
    'GetServiceTrafficResult',
    'GetServiceTrafficStatusResult',
]

@pulumi.output_type
class JobBinaryAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakglassJustification":
            suggest = "breakglass_justification"
        elif key == "useDefault":
            suggest = "use_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobBinaryAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobBinaryAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobBinaryAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakglass_justification: Optional[str] = None,
                 policy: Optional[str] = None,
                 use_default: Optional[bool] = None):
        """
        :param str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[str]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[bool]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class JobCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[str] = None,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 revision_reason: Optional[str] = None,
                 severity: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str execution_reason: (Output)
               A reason for the execution condition.
        :param str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: (Output)
               Human readable message indicating details about the current status.
        :param str reason: (Output)
               A common (service-level) reason for this condition.
        :param str revision_reason: (Output)
               A reason for the revision condition.
        :param str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: (Output)
               State of the condition.
        :param str type: (Output)
               type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobLatestCreatedExecution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTime":
            suggest = "completion_time"
        elif key == "createTime":
            suggest = "create_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobLatestCreatedExecution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobLatestCreatedExecution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobLatestCreatedExecution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time: Optional[str] = None,
                 create_time: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str completion_time: (Output)
               Completion timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str create_time: (Output)
               Creation timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str name: Name of the Job.
        """
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[str]:
        """
        (Output)
        Completion timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        (Output)
        Creation timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template: 'outputs.JobTemplateTemplate',
                 annotations: Optional[Mapping[str, str]] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 parallelism: Optional[int] = None,
                 task_count: Optional[int] = None):
        """
        :param 'JobTemplateTemplateArgs' template: Describes the task(s) that will be created when executing an execution
               Structure is documented below.
        :param Mapping[str, str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Mapping[str, str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        :param int parallelism: Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        :param int task_count: Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        pulumi.set(__self__, "template", template)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter
    def template(self) -> 'outputs.JobTemplateTemplate':
        """
        Describes the task(s) that will be created when executing an execution
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
        or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[int]:
        """
        Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[int]:
        """
        Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class JobTemplateTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "executionEnvironment":
            suggest = "execution_environment"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.JobTemplateTemplateContainer']] = None,
                 encryption_key: Optional[str] = None,
                 execution_environment: Optional[str] = None,
                 max_retries: Optional[int] = None,
                 service_account: Optional[str] = None,
                 timeout: Optional[str] = None,
                 volumes: Optional[Sequence['outputs.JobTemplateTemplateVolume']] = None,
                 vpc_access: Optional['outputs.JobTemplateTemplateVpcAccess'] = None):
        """
        :param Sequence['JobTemplateTemplateContainerArgs'] containers: Holds the single container that defines the unit of execution for this task.
               Structure is documented below.
        :param str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param str execution_environment: The execution environment being used to host this Task.
               Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        :param int max_retries: Number of retries allowed per Task, before marking this Task failed.
        :param str service_account: Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        :param str timeout: Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['JobTemplateTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param 'JobTemplateTemplateVpcAccessArgs' vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if execution_environment is not None:
            pulumi.set(__self__, "execution_environment", execution_environment)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainer']]:
        """
        Holds the single container that defines the unit of execution for this task.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[str]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> Optional[str]:
        """
        The execution environment being used to host this Task.
        Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        """
        return pulumi.get(self, "execution_environment")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[int]:
        """
        Number of retries allowed per Task, before marking this Task failed.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobTemplateTemplateVolume']]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional['outputs.JobTemplateTemplateVpcAccess']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class JobTemplateTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 envs: Optional[Sequence['outputs.JobTemplateTemplateContainerEnv']] = None,
                 name: Optional[str] = None,
                 ports: Optional[Sequence['outputs.JobTemplateTemplateContainerPort']] = None,
                 resources: Optional['outputs.JobTemplateTemplateContainerResources'] = None,
                 volume_mounts: Optional[Sequence['outputs.JobTemplateTemplateContainerVolumeMount']] = None,
                 working_dir: Optional[str] = None):
        """
        :param str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['JobTemplateTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param str name: Name of the container specified as a DNS_LABEL.
        :param Sequence['JobTemplateTemplateContainerPortArgs'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
               Structure is documented below.
        :param 'JobTemplateTemplateContainerResourcesArgs' resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param Sequence['JobTemplateTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerPort']]:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobTemplateTemplateContainerResources']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerVolumeMount']]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class JobTemplateTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_source: Optional['outputs.JobTemplateTemplateContainerEnvValueSource'] = None):
        """
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        :param str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param 'JobTemplateTemplateContainerEnvValueSourceArgs' value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional['outputs.JobTemplateTemplateContainerEnvValueSource']:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class JobTemplateTemplateContainerEnvValueSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerEnvValueSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerEnvValueSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerEnvValueSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: Optional['outputs.JobTemplateTemplateContainerEnvValueSourceSecretKeyRef'] = None):
        """
        :param 'JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs' secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.JobTemplateTemplateContainerEnvValueSourceSecretKeyRef']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class JobTemplateTemplateContainerEnvValueSourceSecretKeyRef(dict):
    def __init__(__self__, *,
                 secret: str,
                 version: str):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class JobTemplateTemplateContainerPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param str name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplateTemplateContainerResources(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] limits: Only memory and CPU are supported. Use key `cpu` for CPU limit and `memory` for memory limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        """
        Only memory and CPU are supported. Use key `cpu` for CPU limit and `memory` for memory limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class JobTemplateTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str):
        """
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplateTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "emptyDir":
            suggest = "empty_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 cloud_sql_instance: Optional['outputs.JobTemplateTemplateVolumeCloudSqlInstance'] = None,
                 empty_dir: Optional['outputs.JobTemplateTemplateVolumeEmptyDir'] = None,
                 gcs: Optional['outputs.JobTemplateTemplateVolumeGcs'] = None,
                 nfs: Optional['outputs.JobTemplateTemplateVolumeNfs'] = None,
                 secret: Optional['outputs.JobTemplateTemplateVolumeSecret'] = None):
        """
        :param str name: Volume's name.
        :param 'JobTemplateTemplateVolumeCloudSqlInstanceArgs' cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeEmptyDirArgs' empty_dir: Ephemeral storage used as a shared volume.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeGcsArgs' gcs: Cloud Storage bucket mounted as a volume using GCSFuse.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeNfsArgs' nfs: NFS share mounted as a volume.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeSecretArgs' secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional['outputs.JobTemplateTemplateVolumeCloudSqlInstance']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.JobTemplateTemplateVolumeEmptyDir']:
        """
        Ephemeral storage used as a shared volume.
        Structure is documented below.
        """
        return pulumi.get(self, "empty_dir")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.JobTemplateTemplateVolumeGcs']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.JobTemplateTemplateVolumeNfs']:
        """
        NFS share mounted as a volume.
        Structure is documented below.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def secret(self) -> Optional['outputs.JobTemplateTemplateVolumeSecret']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class JobTemplateTemplateVolumeCloudSqlInstance(dict):
    def __init__(__self__, *,
                 instances: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[str]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class JobTemplateTemplateVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[str] = None,
                 size_limit: Optional[str] = None):
        """
        :param str medium: The different types of medium supported for EmptyDir.
               Default value is `MEMORY`.
               Possible values are: `MEMORY`.
        :param str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> Optional[str]:
        """
        The different types of medium supported for EmptyDir.
        Default value is `MEMORY`.
        Possible values are: `MEMORY`.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[str]:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class JobTemplateTemplateVolumeGcs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeGcs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeGcs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeGcs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 read_only: Optional[bool] = None):
        """
        :param str bucket: Name of the cloud storage bucket to back the volume. The resource service account must have permission to access the bucket.
        :param bool read_only: If true, mount this volume as read-only in all mounts. If false, mount this volume as read-write.
        """
        pulumi.set(__self__, "bucket", bucket)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the cloud storage bucket to back the volume. The resource service account must have permission to access the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        If true, mount this volume as read-only in all mounts. If false, mount this volume as read-write.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class JobTemplateTemplateVolumeNfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server: str,
                 path: Optional[str] = None,
                 read_only: Optional[bool] = None):
        """
        :param str server: Hostname or IP address of the NFS server.
        :param str path: Path that is exported by the NFS server.
        :param bool read_only: If true, mount this volume as read-only in all mounts.
        """
        pulumi.set(__self__, "server", server)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def server(self) -> str:
        """
        Hostname or IP address of the NFS server.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        If true, mount this volume as read-only in all mounts.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class JobTemplateTemplateVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret: str,
                 default_mode: Optional[int] = None,
                 items: Optional[Sequence['outputs.JobTemplateTemplateVolumeSecretItem']] = None):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['JobTemplateTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[int]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.JobTemplateTemplateVolumeSecretItem']]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class JobTemplateTemplateVolumeSecretItem(dict):
    def __init__(__self__, *,
                 path: str,
                 version: str,
                 mode: Optional[int] = None):
        """
        :param str path: The relative path of the secret in the container.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        :param int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def mode(self) -> Optional[int]:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class JobTemplateTemplateVpcAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVpcAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVpcAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVpcAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector: Optional[str] = None,
                 egress: Optional[str] = None,
                 network_interfaces: Optional[Sequence['outputs.JobTemplateTemplateVpcAccessNetworkInterface']] = None):
        """
        :param str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param str egress: Traffic VPC egress settings.
               Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        :param Sequence['JobTemplateTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
               Structure is documented below.
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter
    def connector(self) -> Optional[str]:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def egress(self) -> Optional[str]:
        """
        Traffic VPC egress settings.
        Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "egress")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.JobTemplateTemplateVpcAccessNetworkInterface']]:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class JobTemplateTemplateVpcAccessNetworkInterface(dict):
    def __init__(__self__, *,
                 network: Optional[str] = None,
                 subnetwork: Optional[str] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[str] tags: Network tags applied to this Cloud Run job.
               
               - - -
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[str]:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Network tags applied to this Cloud Run job.

        - - -
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class JobTerminalCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTerminalCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTerminalCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTerminalCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[str] = None,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 revision_reason: Optional[str] = None,
                 severity: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str execution_reason: (Output)
               A reason for the execution condition.
        :param str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: (Output)
               Human readable message indicating details about the current status.
        :param str reason: (Output)
               A common (service-level) reason for this condition.
        :param str revision_reason: (Output)
               A reason for the revision condition.
        :param str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: (Output)
               State of the condition.
        :param str type: (Output)
               type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceBinaryAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakglassJustification":
            suggest = "breakglass_justification"
        elif key == "useDefault":
            suggest = "use_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBinaryAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBinaryAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBinaryAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakglass_justification: Optional[str] = None,
                 policy: Optional[str] = None,
                 use_default: Optional[bool] = None):
        """
        :param str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[str]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[bool]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class ServiceCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[str] = None,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 revision_reason: Optional[str] = None,
                 severity: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str execution_reason: (Output)
               A reason for the execution condition.
        :param str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: (Output)
               Human readable message indicating details about the current status.
        :param str reason: (Output)
               A common (service-level) reason for this condition.
        :param str revision_reason: (Output)
               A reason for the revision condition.
        :param str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: (Output)
               State of the condition.
        :param str type: (Output)
               The allocation type for this traffic target.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_instance_count: Optional[int] = None):
        """
        :param int min_instance_count: Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[int]:
        """
        Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class ServiceTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "executionEnvironment":
            suggest = "execution_environment"
        elif key == "maxInstanceRequestConcurrency":
            suggest = "max_instance_request_concurrency"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "serviceMesh":
            suggest = "service_mesh"
        elif key == "sessionAffinity":
            suggest = "session_affinity"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, str]] = None,
                 containers: Optional[Sequence['outputs.ServiceTemplateContainer']] = None,
                 encryption_key: Optional[str] = None,
                 execution_environment: Optional[str] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 max_instance_request_concurrency: Optional[int] = None,
                 node_selector: Optional['outputs.ServiceTemplateNodeSelector'] = None,
                 revision: Optional[str] = None,
                 scaling: Optional['outputs.ServiceTemplateScaling'] = None,
                 service_account: Optional[str] = None,
                 service_mesh: Optional['outputs.ServiceTemplateServiceMesh'] = None,
                 session_affinity: Optional[bool] = None,
                 timeout: Optional[str] = None,
                 volumes: Optional[Sequence['outputs.ServiceTemplateVolume']] = None,
                 vpc_access: Optional['outputs.ServiceTemplateVpcAccess'] = None):
        """
        :param Mapping[str, str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Sequence['ServiceTemplateContainerArgs'] containers: Holds the containers that define the unit of execution for this Service.
               Structure is documented below.
        :param str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param str execution_environment: The sandbox environment to host this Revision.
               Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        :param Mapping[str, str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
               For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        :param int max_instance_request_concurrency: Sets the maximum number of requests that each serving instance can receive.
               If not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        :param 'ServiceTemplateNodeSelectorArgs' node_selector: Node Selector describes the hardware requirements of the resources.
               Structure is documented below.
        :param str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        :param 'ServiceTemplateScalingArgs' scaling: Scaling settings for this Revision.
               Structure is documented below.
        :param str service_account: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param 'ServiceTemplateServiceMeshArgs' service_mesh: Enables Cloud Service Mesh for this Revision.
               Structure is documented below.
        :param bool session_affinity: Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        :param str timeout: Max allowed time for an instance to respond to a request.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['ServiceTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param 'ServiceTemplateVpcAccessArgs' vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if execution_environment is not None:
            pulumi.set(__self__, "execution_environment", execution_environment)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instance_request_concurrency is not None:
            pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_mesh is not None:
            pulumi.set(__self__, "service_mesh", service_mesh)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, str]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.ServiceTemplateContainer']]:
        """
        Holds the containers that define the unit of execution for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[str]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> Optional[str]:
        """
        The sandbox environment to host this Revision.
        Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        """
        return pulumi.get(self, "execution_environment")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
        For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> Optional[int]:
        """
        Sets the maximum number of requests that each serving instance can receive.
        If not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['outputs.ServiceTemplateNodeSelector']:
        """
        Node Selector describes the hardware requirements of the resources.
        Structure is documented below.
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def scaling(self) -> Optional['outputs.ServiceTemplateScaling']:
        """
        Scaling settings for this Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceMesh")
    def service_mesh(self) -> Optional['outputs.ServiceTemplateServiceMesh']:
        """
        Enables Cloud Service Mesh for this Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "service_mesh")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[bool]:
        """
        Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Max allowed time for an instance to respond to a request.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.ServiceTemplateVolume']]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional['outputs.ServiceTemplateVpcAccess']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class ServiceTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOns":
            suggest = "depends_ons"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 depends_ons: Optional[Sequence[str]] = None,
                 envs: Optional[Sequence['outputs.ServiceTemplateContainerEnv']] = None,
                 liveness_probe: Optional['outputs.ServiceTemplateContainerLivenessProbe'] = None,
                 name: Optional[str] = None,
                 ports: Optional['outputs.ServiceTemplateContainerPorts'] = None,
                 resources: Optional['outputs.ServiceTemplateContainerResources'] = None,
                 startup_probe: Optional['outputs.ServiceTemplateContainerStartupProbe'] = None,
                 volume_mounts: Optional[Sequence['outputs.ServiceTemplateContainerVolumeMount']] = None,
                 working_dir: Optional[str] = None):
        """
        :param str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[str] depends_ons: Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        :param Sequence['ServiceTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param 'ServiceTemplateContainerLivenessProbeArgs' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param str name: Name of the container specified as a DNS_LABEL.
        :param 'ServiceTemplateContainerPortsArgs' ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
               Structure is documented below.
        :param 'ServiceTemplateContainerResourcesArgs' resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param 'ServiceTemplateContainerStartupProbeArgs' startup_probe: Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param Sequence['ServiceTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if depends_ons is not None:
            pulumi.set(__self__, "depends_ons", depends_ons)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Optional[Sequence[str]]:
        """
        Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        """
        return pulumi.get(self, "depends_ons")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.ServiceTemplateContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbe']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Optional['outputs.ServiceTemplateContainerPorts']:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ServiceTemplateContainerResources']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.ServiceTemplateContainerStartupProbe']:
        """
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "startup_probe")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ServiceTemplateContainerVolumeMount']]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ServiceTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None,
                 value_source: Optional['outputs.ServiceTemplateContainerEnvValueSource'] = None):
        """
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER, and may not exceed 32768 characters.
        :param str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param 'ServiceTemplateContainerEnvValueSourceArgs' value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and may not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional['outputs.ServiceTemplateContainerEnvValueSource']:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class ServiceTemplateContainerEnvValueSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerEnvValueSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerEnvValueSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerEnvValueSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: Optional['outputs.ServiceTemplateContainerEnvValueSourceSecretKeyRef'] = None):
        """
        :param 'ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs' secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.ServiceTemplateContainerEnvValueSourceSecretKeyRef']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class ServiceTemplateContainerEnvValueSourceSecretKeyRef(dict):
    def __init__(__self__, *,
                 secret: str,
                 version: Optional[str] = None):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 grpc: Optional['outputs.ServiceTemplateContainerLivenessProbeGrpc'] = None,
                 http_get: Optional['outputs.ServiceTemplateContainerLivenessProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 tcp_socket: Optional['outputs.ServiceTemplateContainerLivenessProbeTcpSocket'] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'ServiceTemplateContainerLivenessProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'ServiceTemplateContainerLivenessProbeHttpGetArgs' http_get: HTTPGet specifies the http request to perform.
               Structure is documented below.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param 'ServiceTemplateContainerLivenessProbeTcpSocketArgs' tcp_socket: TCPSocketAction describes an action based on opening a socket
               Structure is documented below.
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeHttpGet']:
        """
        HTTPGet specifies the http request to perform.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeTcpSocket']:
        """
        TCPSocketAction describes an action based on opening a socket
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None,
                 service: Optional[str] = None):
        """
        :param int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerLivenessProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerLivenessProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerLivenessProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.ServiceTemplateContainerLivenessProbeHttpGetHttpHeader']] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param Sequence['ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param str path: Path to access on the HTTP server. Defaults to '/'.
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ServiceTemplateContainerLivenessProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: int):
        """
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerPorts(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerPorts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerPorts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerPorts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[int] = None,
                 name: Optional[str] = None):
        """
        :param int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param str name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateContainerResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuIdle":
            suggest = "cpu_idle"
        elif key == "startupCpuBoost":
            suggest = "startup_cpu_boost"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_idle: Optional[bool] = None,
                 limits: Optional[Mapping[str, str]] = None,
                 startup_cpu_boost: Optional[bool] = None):
        """
        :param bool cpu_idle: Determines whether CPU is only allocated during requests. True by default if the parent `resources` field is not set. However, if
               `resources` is set, this field must be explicitly set to true to preserve the default behavior.
        :param Mapping[str, str] limits: Only memory, CPU, and nvidia.com/gpu are supported. Use key `cpu` for CPU limit, `memory` for memory limit, `nvidia.com/gpu` for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param bool startup_cpu_boost: Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        if cpu_idle is not None:
            pulumi.set(__self__, "cpu_idle", cpu_idle)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if startup_cpu_boost is not None:
            pulumi.set(__self__, "startup_cpu_boost", startup_cpu_boost)

    @property
    @pulumi.getter(name="cpuIdle")
    def cpu_idle(self) -> Optional[bool]:
        """
        Determines whether CPU is only allocated during requests. True by default if the parent `resources` field is not set. However, if
        `resources` is set, this field must be explicitly set to true to preserve the default behavior.
        """
        return pulumi.get(self, "cpu_idle")

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        """
        Only memory, CPU, and nvidia.com/gpu are supported. Use key `cpu` for CPU limit, `memory` for memory limit, `nvidia.com/gpu` for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="startupCpuBoost")
    def startup_cpu_boost(self) -> Optional[bool]:
        """
        Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        return pulumi.get(self, "startup_cpu_boost")


@pulumi.output_type
class ServiceTemplateContainerStartupProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerStartupProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerStartupProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerStartupProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 grpc: Optional['outputs.ServiceTemplateContainerStartupProbeGrpc'] = None,
                 http_get: Optional['outputs.ServiceTemplateContainerStartupProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 tcp_socket: Optional['outputs.ServiceTemplateContainerStartupProbeTcpSocket'] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'ServiceTemplateContainerStartupProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'ServiceTemplateContainerStartupProbeHttpGetArgs' http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param 'ServiceTemplateContainerStartupProbeTcpSocketArgs' tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeHttpGet']:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeTcpSocket']:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None,
                 service: Optional[str] = None):
        """
        :param int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerStartupProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.ServiceTemplateContainerStartupProbeHttpGetHttpHeader']] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param Sequence['ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param str path: Path to access on the HTTP server. Defaults to '/'.
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ServiceTemplateContainerStartupProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: str,
                 value: Optional[str] = None):
        """
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None):
        """
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str):
        """
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateNodeSelector(dict):
    def __init__(__self__, *,
                 accelerator: str):
        """
        :param str accelerator: The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
               
               - - -
        """
        pulumi.set(__self__, "accelerator", accelerator)

    @property
    @pulumi.getter
    def accelerator(self) -> str:
        """
        The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.

        - - -
        """
        return pulumi.get(self, "accelerator")


@pulumi.output_type
class ServiceTemplateScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: Optional[int] = None,
                 min_instance_count: Optional[int] = None):
        """
        :param int max_instance_count: Maximum number of serving instances that this resource should have.
        :param int min_instance_count: Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[int]:
        """
        Maximum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[int]:
        """
        Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class ServiceTemplateServiceMesh(dict):
    def __init__(__self__, *,
                 mesh: Optional[str] = None):
        """
        :param str mesh: The Mesh resource name. For more information see https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.meshes#resource:-mesh.
        """
        if mesh is not None:
            pulumi.set(__self__, "mesh", mesh)

    @property
    @pulumi.getter
    def mesh(self) -> Optional[str]:
        """
        The Mesh resource name. For more information see https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.meshes#resource:-mesh.
        """
        return pulumi.get(self, "mesh")


@pulumi.output_type
class ServiceTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "emptyDir":
            suggest = "empty_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 cloud_sql_instance: Optional['outputs.ServiceTemplateVolumeCloudSqlInstance'] = None,
                 empty_dir: Optional['outputs.ServiceTemplateVolumeEmptyDir'] = None,
                 gcs: Optional['outputs.ServiceTemplateVolumeGcs'] = None,
                 nfs: Optional['outputs.ServiceTemplateVolumeNfs'] = None,
                 secret: Optional['outputs.ServiceTemplateVolumeSecret'] = None):
        """
        :param str name: Volume's name.
        :param 'ServiceTemplateVolumeCloudSqlInstanceArgs' cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param 'ServiceTemplateVolumeEmptyDirArgs' empty_dir: Ephemeral storage used as a shared volume.
               Structure is documented below.
        :param 'ServiceTemplateVolumeGcsArgs' gcs: Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
               Structure is documented below.
        :param 'ServiceTemplateVolumeNfsArgs' nfs: Represents an NFS mount.
               Structure is documented below.
        :param 'ServiceTemplateVolumeSecretArgs' secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional['outputs.ServiceTemplateVolumeCloudSqlInstance']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.ServiceTemplateVolumeEmptyDir']:
        """
        Ephemeral storage used as a shared volume.
        Structure is documented below.
        """
        return pulumi.get(self, "empty_dir")

    @property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.ServiceTemplateVolumeGcs']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.ServiceTemplateVolumeNfs']:
        """
        Represents an NFS mount.
        Structure is documented below.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def secret(self) -> Optional['outputs.ServiceTemplateVolumeSecret']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class ServiceTemplateVolumeCloudSqlInstance(dict):
    def __init__(__self__, *,
                 instances: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[str]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class ServiceTemplateVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[str] = None,
                 size_limit: Optional[str] = None):
        """
        :param str medium: The different types of medium supported for EmptyDir.
               Default value is `MEMORY`.
               Possible values are: `MEMORY`.
        :param str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> Optional[str]:
        """
        The different types of medium supported for EmptyDir.
        Default value is `MEMORY`.
        Possible values are: `MEMORY`.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[str]:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class ServiceTemplateVolumeGcs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeGcs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeGcs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeGcs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 read_only: Optional[bool] = None):
        """
        :param str bucket: GCS Bucket name
        :param bool read_only: If true, mount the GCS bucket as read-only
        """
        pulumi.set(__self__, "bucket", bucket)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        GCS Bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        If true, mount the GCS bucket as read-only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class ServiceTemplateVolumeNfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 server: str,
                 read_only: Optional[bool] = None):
        """
        :param str path: Path that is exported by the NFS server.
        :param str server: Hostname or IP address of the NFS server
        :param bool read_only: If true, mount the NFS volume as read only
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "server", server)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def server(self) -> str:
        """
        Hostname or IP address of the NFS server
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        If true, mount the NFS volume as read only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class ServiceTemplateVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret: str,
                 default_mode: Optional[int] = None,
                 items: Optional[Sequence['outputs.ServiceTemplateVolumeSecretItem']] = None):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['ServiceTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[int]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ServiceTemplateVolumeSecretItem']]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ServiceTemplateVolumeSecretItem(dict):
    def __init__(__self__, *,
                 path: str,
                 mode: Optional[int] = None,
                 version: Optional[str] = None):
        """
        :param str path: The relative path of the secret in the container.
        :param int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "path", path)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def mode(self) -> Optional[int]:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServiceTemplateVpcAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVpcAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVpcAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVpcAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector: Optional[str] = None,
                 egress: Optional[str] = None,
                 network_interfaces: Optional[Sequence['outputs.ServiceTemplateVpcAccessNetworkInterface']] = None):
        """
        :param str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param str egress: Traffic VPC egress settings.
               Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        :param Sequence['ServiceTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
               Structure is documented below.
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter
    def connector(self) -> Optional[str]:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def egress(self) -> Optional[str]:
        """
        Traffic VPC egress settings.
        Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "egress")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.ServiceTemplateVpcAccessNetworkInterface']]:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class ServiceTemplateVpcAccessNetworkInterface(dict):
    def __init__(__self__, *,
                 network: Optional[str] = None,
                 subnetwork: Optional[str] = None,
                 tags: Optional[Sequence[str]] = None):
        """
        :param str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[str] tags: Network tags applied to this Cloud Run service.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[str]:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Network tags applied to this Cloud Run service.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ServiceTerminalCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTerminalCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTerminalCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTerminalCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[str] = None,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 revision_reason: Optional[str] = None,
                 severity: Optional[str] = None,
                 state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str execution_reason: (Output)
               A reason for the execution condition.
        :param str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: (Output)
               Human readable message indicating details about the current status.
        :param str reason: (Output)
               A common (service-level) reason for this condition.
        :param str revision_reason: (Output)
               A reason for the revision condition.
        :param str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: (Output)
               State of the condition.
        :param str type: (Output)
               The allocation type for this traffic target.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceTraffic(dict):
    def __init__(__self__, *,
                 percent: Optional[int] = None,
                 revision: Optional[str] = None,
                 tag: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param int percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param str revision: Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param str tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param str type: The allocation type for this traffic target.
               Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def percent(self) -> Optional[int]:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The allocation type for this traffic target.
        Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceTrafficStatus(dict):
    def __init__(__self__, *,
                 percent: Optional[int] = None,
                 revision: Optional[str] = None,
                 tag: Optional[str] = None,
                 type: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param int percent: (Output)
               Specifies percent of the traffic to this Revision.
        :param str revision: (Output)
               Revision to which this traffic is sent.
        :param str tag: (Output)
               Indicates the string used in the URI to exclusively reference this target.
        :param str type: (Output)
               The allocation type for this traffic target.
        :param str uri: (Output)
               Displays the target URI.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def percent(self) -> Optional[int]:
        """
        (Output)
        Specifies percent of the traffic to this Revision.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        (Output)
        Revision to which this traffic is sent.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        (Output)
        Indicates the string used in the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        (Output)
        Displays the target URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetJobBinaryAuthorizationResult(dict):
    def __init__(__self__, *,
                 breakglass_justification: str,
                 policy: str,
                 use_default: bool):
        """
        :param str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> str:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> bool:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class GetJobConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: str,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 revision_reason: str,
                 severity: str,
                 state: str,
                 type: str):
        """
        :param str execution_reason: A reason for the execution condition.
        :param str last_transition_time: Last time the condition transitioned from one status to another.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: Human readable message indicating details about the current status.
        :param str reason: A common (service-level) reason for this condition.
        :param str revision_reason: A reason for the revision condition.
        :param str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: State of the condition.
        :param str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Last time the condition transitioned from one status to another.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetJobLatestCreatedExecutionResult(dict):
    def __init__(__self__, *,
                 completion_time: str,
                 create_time: str,
                 name: str):
        """
        :param str completion_time: Completion timestamp of the execution.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str create_time: Creation timestamp of the execution.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str name: The name of the Cloud Run v2 Job.
        """
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> str:
        """
        Completion timestamp of the execution.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation timestamp of the execution.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetJobTemplateResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 labels: Mapping[str, str],
                 parallelism: int,
                 task_count: int,
                 templates: Sequence['outputs.GetJobTemplateTemplateResult']):
        """
        :param Mapping[str, str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               
               Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Mapping[str, str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               
               Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        :param int parallelism: Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        :param int task_count: Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param Sequence['GetJobTemplateTemplateArgs'] templates: Describes the task(s) that will be created when executing an execution
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "parallelism", parallelism)
        pulumi.set(__self__, "task_count", task_count)
        pulumi.set(__self__, "templates", templates)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.

        Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.

        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
        or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels.

        Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def parallelism(self) -> int:
        """
        Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> int:
        """
        Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "task_count")

    @property
    @pulumi.getter
    def templates(self) -> Sequence['outputs.GetJobTemplateTemplateResult']:
        """
        Describes the task(s) that will be created when executing an execution
        """
        return pulumi.get(self, "templates")


@pulumi.output_type
class GetJobTemplateTemplateResult(dict):
    def __init__(__self__, *,
                 containers: Sequence['outputs.GetJobTemplateTemplateContainerResult'],
                 encryption_key: str,
                 execution_environment: str,
                 max_retries: int,
                 service_account: str,
                 timeout: str,
                 volumes: Sequence['outputs.GetJobTemplateTemplateVolumeResult'],
                 vpc_accesses: Sequence['outputs.GetJobTemplateTemplateVpcAccessResult']):
        """
        :param Sequence['GetJobTemplateTemplateContainerArgs'] containers: Holds the single container that defines the unit of execution for this task.
        :param str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param str execution_environment: The execution environment being used to host this Task. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
        :param int max_retries: Number of retries allowed per Task, before marking this Task failed.
        :param str service_account: Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        :param str timeout: Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
               
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['GetJobTemplateTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
        :param Sequence['GetJobTemplateTemplateVpcAccessArgs'] vpc_accesses: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "execution_environment", execution_environment)
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_accesses", vpc_accesses)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetJobTemplateTemplateContainerResult']:
        """
        Holds the single container that defines the unit of execution for this task.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> str:
        """
        The execution environment being used to host this Task. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
        """
        return pulumi.get(self, "execution_environment")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> int:
        """
        Number of retries allowed per Task, before marking this Task failed.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.

        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeResult']:
        """
        A list of Volumes to make available to containers.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcAccesses")
    def vpc_accesses(self) -> Sequence['outputs.GetJobTemplateTemplateVpcAccessResult']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        return pulumi.get(self, "vpc_accesses")


@pulumi.output_type
class GetJobTemplateTemplateContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[str],
                 commands: Sequence[str],
                 envs: Sequence['outputs.GetJobTemplateTemplateContainerEnvResult'],
                 image: str,
                 name: str,
                 ports: Sequence['outputs.GetJobTemplateTemplateContainerPortResult'],
                 resources: Sequence['outputs.GetJobTemplateTemplateContainerResourceResult'],
                 volume_mounts: Sequence['outputs.GetJobTemplateTemplateContainerVolumeMountResult'],
                 working_dir: str):
        """
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['GetJobTemplateTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
        :param str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param str name: The name of the Cloud Run v2 Job.
        :param Sequence['GetJobTemplateTemplateContainerPortArgs'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        :param Sequence['GetJobTemplateTemplateContainerResourceArgs'] resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param Sequence['GetJobTemplateTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetJobTemplateTemplateContainerEnvResult']:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GetJobTemplateTemplateContainerPortResult']:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.

        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetJobTemplateTemplateContainerResourceResult']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetJobTemplateTemplateContainerVolumeMountResult']:
        """
        Volume to mount into the container's filesystem.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetJobTemplateTemplateContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 value_sources: Sequence['outputs.GetJobTemplateTemplateContainerEnvValueSourceResult']):
        """
        :param str name: The name of the Cloud Run v2 Job.
        :param str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param Sequence['GetJobTemplateTemplateContainerEnvValueSourceArgs'] value_sources: Source for the environment variable's value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_sources", value_sources)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueSources")
    def value_sources(self) -> Sequence['outputs.GetJobTemplateTemplateContainerEnvValueSourceResult']:
        """
        Source for the environment variable's value.
        """
        return pulumi.get(self, "value_sources")


@pulumi.output_type
class GetJobTemplateTemplateContainerEnvValueSourceResult(dict):
    def __init__(__self__, *,
                 secret_key_reves: Sequence['outputs.GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefResult']):
        """
        :param Sequence['GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs'] secret_key_reves: Selects a secret and a specific version from Cloud Secret Manager.
        """
        pulumi.set(__self__, "secret_key_reves", secret_key_reves)

    @property
    @pulumi.getter(name="secretKeyReves")
    def secret_key_reves(self) -> Sequence['outputs.GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefResult']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        """
        return pulumi.get(self, "secret_key_reves")


@pulumi.output_type
class GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefResult(dict):
    def __init__(__self__, *,
                 secret: str,
                 version: str):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetJobTemplateTemplateContainerPortResult(dict):
    def __init__(__self__, *,
                 container_port: int,
                 name: str):
        """
        :param int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param str name: The name of the Cloud Run v2 Job.
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetJobTemplateTemplateContainerResourceResult(dict):
    def __init__(__self__, *,
                 limits: Mapping[str, str]):
        """
        :param Mapping[str, str] limits: Only memory and CPU are supported. Use key 'cpu' for CPU limit and 'memory' for memory limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        Only memory and CPU are supported. Use key 'cpu' for CPU limit and 'memory' for memory limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class GetJobTemplateTemplateContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: str,
                 name: str):
        """
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param str name: The name of the Cloud Run v2 Job.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetJobTemplateTemplateVolumeResult(dict):
    def __init__(__self__, *,
                 cloud_sql_instances: Sequence['outputs.GetJobTemplateTemplateVolumeCloudSqlInstanceResult'],
                 empty_dirs: Sequence['outputs.GetJobTemplateTemplateVolumeEmptyDirResult'],
                 gcs: Sequence['outputs.GetJobTemplateTemplateVolumeGcResult'],
                 name: str,
                 nfs: Sequence['outputs.GetJobTemplateTemplateVolumeNfResult'],
                 secrets: Sequence['outputs.GetJobTemplateTemplateVolumeSecretResult']):
        """
        :param Sequence['GetJobTemplateTemplateVolumeCloudSqlInstanceArgs'] cloud_sql_instances: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        :param Sequence['GetJobTemplateTemplateVolumeEmptyDirArgs'] empty_dirs: Ephemeral storage used as a shared volume.
        :param Sequence['GetJobTemplateTemplateVolumeGcArgs'] gcs: Cloud Storage bucket mounted as a volume using GCSFuse.
        :param str name: The name of the Cloud Run v2 Job.
        :param Sequence['GetJobTemplateTemplateVolumeNfArgs'] nfs: NFS share mounted as a volume.
        :param Sequence['GetJobTemplateTemplateVolumeSecretArgs'] secrets: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        pulumi.set(__self__, "cloud_sql_instances", cloud_sql_instances)
        pulumi.set(__self__, "empty_dirs", empty_dirs)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs", nfs)
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="cloudSqlInstances")
    def cloud_sql_instances(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeCloudSqlInstanceResult']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        """
        return pulumi.get(self, "cloud_sql_instances")

    @property
    @pulumi.getter(name="emptyDirs")
    def empty_dirs(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeEmptyDirResult']:
        """
        Ephemeral storage used as a shared volume.
        """
        return pulumi.get(self, "empty_dirs")

    @property
    @pulumi.getter
    def gcs(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeGcResult']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nfs(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeNfResult']:
        """
        NFS share mounted as a volume.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeSecretResult']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class GetJobTemplateTemplateVolumeCloudSqlInstanceResult(dict):
    def __init__(__self__, *,
                 instances: Sequence[str]):
        """
        :param Sequence[str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Sequence[str]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class GetJobTemplateTemplateVolumeEmptyDirResult(dict):
    def __init__(__self__, *,
                 medium: str,
                 size_limit: str):
        """
        :param str medium: The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        :param str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        pulumi.set(__self__, "medium", medium)
        pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> str:
        """
        The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> str:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class GetJobTemplateTemplateVolumeGcResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 read_only: bool):
        """
        :param str bucket: Name of the cloud storage bucket to back the volume. The resource service account must have permission to access the bucket.
        :param bool read_only: If true, mount this volume as read-only in all mounts. If false, mount this volume as read-write.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the cloud storage bucket to back the volume. The resource service account must have permission to access the bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        If true, mount this volume as read-only in all mounts. If false, mount this volume as read-write.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetJobTemplateTemplateVolumeNfResult(dict):
    def __init__(__self__, *,
                 path: str,
                 read_only: bool,
                 server: str):
        """
        :param str path: Path that is exported by the NFS server.
        :param bool read_only: If true, mount this volume as read-only in all mounts.
        :param str server: Hostname or IP address of the NFS server.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        If true, mount this volume as read-only in all mounts.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def server(self) -> str:
        """
        Hostname or IP address of the NFS server.
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetJobTemplateTemplateVolumeSecretResult(dict):
    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.GetJobTemplateTemplateVolumeSecretItemResult'],
                 secret: str):
        """
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['GetJobTemplateTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeSecretItemResult']:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetJobTemplateTemplateVolumeSecretItemResult(dict):
    def __init__(__self__, *,
                 mode: int,
                 path: str,
                 version: str):
        """
        :param int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param str path: The relative path of the secret in the container.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetJobTemplateTemplateVpcAccessResult(dict):
    def __init__(__self__, *,
                 connector: str,
                 egress: str,
                 network_interfaces: Sequence['outputs.GetJobTemplateTemplateVpcAccessNetworkInterfaceResult']):
        """
        :param str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param str egress: Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        :param Sequence['GetJobTemplateTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
        """
        pulumi.set(__self__, "connector", connector)
        pulumi.set(__self__, "egress", egress)
        pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter
    def connector(self) -> str:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def egress(self) -> str:
        """
        Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        """
        return pulumi.get(self, "egress")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetJobTemplateTemplateVpcAccessNetworkInterfaceResult']:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class GetJobTemplateTemplateVpcAccessNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 network: str,
                 subnetwork: str,
                 tags: Sequence[str]):
        """
        :param str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[str] tags: Network tags applied to this Cloud Run job.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Network tags applied to this Cloud Run job.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetJobTerminalConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: str,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 revision_reason: str,
                 severity: str,
                 state: str,
                 type: str):
        """
        :param str execution_reason: A reason for the execution condition.
        :param str last_transition_time: Last time the condition transitioned from one status to another.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: Human readable message indicating details about the current status.
        :param str reason: A common (service-level) reason for this condition.
        :param str revision_reason: A reason for the revision condition.
        :param str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: State of the condition.
        :param str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Last time the condition transitioned from one status to another.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceBinaryAuthorizationResult(dict):
    def __init__(__self__, *,
                 breakglass_justification: str,
                 policy: str,
                 use_default: bool):
        """
        :param str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> str:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> bool:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class GetServiceConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: str,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 revision_reason: str,
                 severity: str,
                 state: str,
                 type: str):
        """
        :param str execution_reason: A reason for the execution condition.
        :param str last_transition_time: Last time the condition transitioned from one status to another.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str message: Human readable message indicating details about the current status.
        :param str reason: A common (service-level) reason for this condition.
        :param str revision_reason: A reason for the revision condition.
        :param str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: State of the condition.
        :param str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Last time the condition transitioned from one status to another.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceScalingResult(dict):
    def __init__(__self__, *,
                 min_instance_count: int):
        """
        :param int min_instance_count: Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> int:
        """
        Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class GetServiceTemplateResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 containers: Sequence['outputs.GetServiceTemplateContainerResult'],
                 encryption_key: str,
                 execution_environment: str,
                 labels: Mapping[str, str],
                 max_instance_request_concurrency: int,
                 node_selectors: Sequence['outputs.GetServiceTemplateNodeSelectorResult'],
                 revision: str,
                 scalings: Sequence['outputs.GetServiceTemplateScalingResult'],
                 service_account: str,
                 service_meshes: Sequence['outputs.GetServiceTemplateServiceMeshResult'],
                 session_affinity: bool,
                 timeout: str,
                 volumes: Sequence['outputs.GetServiceTemplateVolumeResult'],
                 vpc_accesses: Sequence['outputs.GetServiceTemplateVpcAccessResult']):
        """
        :param Mapping[str, str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               
               Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
               
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Sequence['GetServiceTemplateContainerArgs'] containers: Holds the containers that define the unit of execution for this Service.
        :param str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param str execution_environment: The sandbox environment to host this Revision. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
        :param Mapping[str, str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
               For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               
               Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        :param int max_instance_request_concurrency: Sets the maximum number of requests that each serving instance can receive.
               If not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        :param Sequence['GetServiceTemplateNodeSelectorArgs'] node_selectors: Node Selector describes the hardware requirements of the resources.
        :param str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        :param Sequence['GetServiceTemplateScalingArgs'] scalings: Scaling settings for this Revision.
        :param str service_account: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param Sequence['GetServiceTemplateServiceMeshArgs'] service_meshes: Enables Cloud Service Mesh for this Revision.
        :param bool session_affinity: Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        :param str timeout: Max allowed time for an instance to respond to a request.
               
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['GetServiceTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
        :param Sequence['GetServiceTemplateVpcAccessArgs'] vpc_accesses: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "execution_environment", execution_environment)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        pulumi.set(__self__, "node_selectors", node_selectors)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "scalings", scalings)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "service_meshes", service_meshes)
        pulumi.set(__self__, "session_affinity", session_affinity)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_accesses", vpc_accesses)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.

        Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.

        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetServiceTemplateContainerResult']:
        """
        Holds the containers that define the unit of execution for this Service.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> str:
        """
        The sandbox environment to host this Revision. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
        """
        return pulumi.get(self, "execution_environment")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
        For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.

        Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> int:
        """
        Sets the maximum number of requests that each serving instance can receive.
        If not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @property
    @pulumi.getter(name="nodeSelectors")
    def node_selectors(self) -> Sequence['outputs.GetServiceTemplateNodeSelectorResult']:
        """
        Node Selector describes the hardware requirements of the resources.
        """
        return pulumi.get(self, "node_selectors")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def scalings(self) -> Sequence['outputs.GetServiceTemplateScalingResult']:
        """
        Scaling settings for this Revision.
        """
        return pulumi.get(self, "scalings")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceMeshes")
    def service_meshes(self) -> Sequence['outputs.GetServiceTemplateServiceMeshResult']:
        """
        Enables Cloud Service Mesh for this Revision.
        """
        return pulumi.get(self, "service_meshes")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> bool:
        """
        Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Max allowed time for an instance to respond to a request.

        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetServiceTemplateVolumeResult']:
        """
        A list of Volumes to make available to containers.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcAccesses")
    def vpc_accesses(self) -> Sequence['outputs.GetServiceTemplateVpcAccessResult']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        return pulumi.get(self, "vpc_accesses")


@pulumi.output_type
class GetServiceTemplateContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[str],
                 commands: Sequence[str],
                 depends_ons: Sequence[str],
                 envs: Sequence['outputs.GetServiceTemplateContainerEnvResult'],
                 image: str,
                 liveness_probes: Sequence['outputs.GetServiceTemplateContainerLivenessProbeResult'],
                 name: str,
                 ports: Sequence['outputs.GetServiceTemplateContainerPortResult'],
                 resources: Sequence['outputs.GetServiceTemplateContainerResourceResult'],
                 startup_probes: Sequence['outputs.GetServiceTemplateContainerStartupProbeResult'],
                 volume_mounts: Sequence['outputs.GetServiceTemplateContainerVolumeMountResult'],
                 working_dir: str):
        """
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[str] depends_ons: Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        :param Sequence['GetServiceTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
        :param str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence['GetServiceTemplateContainerLivenessProbeArgs'] liveness_probes: Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param str name: The name of the Cloud Run v2 Service.
        :param Sequence['GetServiceTemplateContainerPortArgs'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        :param Sequence['GetServiceTemplateContainerResourceArgs'] resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param Sequence['GetServiceTemplateContainerStartupProbeArgs'] startup_probes: Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param Sequence['GetServiceTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "depends_ons", depends_ons)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "liveness_probes", liveness_probes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "startup_probes", startup_probes)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Sequence[str]:
        """
        Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        """
        return pulumi.get(self, "depends_ons")

    @property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetServiceTemplateContainerEnvResult']:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeResult']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "liveness_probes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GetServiceTemplateContainerPortResult']:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.

        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetServiceTemplateContainerResourceResult']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeResult']:
        """
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "startup_probes")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetServiceTemplateContainerVolumeMountResult']:
        """
        Volume to mount into the container's filesystem.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetServiceTemplateContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 value_sources: Sequence['outputs.GetServiceTemplateContainerEnvValueSourceResult']):
        """
        :param str name: The name of the Cloud Run v2 Service.
        :param str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param Sequence['GetServiceTemplateContainerEnvValueSourceArgs'] value_sources: Source for the environment variable's value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_sources", value_sources)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueSources")
    def value_sources(self) -> Sequence['outputs.GetServiceTemplateContainerEnvValueSourceResult']:
        """
        Source for the environment variable's value.
        """
        return pulumi.get(self, "value_sources")


@pulumi.output_type
class GetServiceTemplateContainerEnvValueSourceResult(dict):
    def __init__(__self__, *,
                 secret_key_reves: Sequence['outputs.GetServiceTemplateContainerEnvValueSourceSecretKeyRefResult']):
        """
        :param Sequence['GetServiceTemplateContainerEnvValueSourceSecretKeyRefArgs'] secret_key_reves: Selects a secret and a specific version from Cloud Secret Manager.
        """
        pulumi.set(__self__, "secret_key_reves", secret_key_reves)

    @property
    @pulumi.getter(name="secretKeyReves")
    def secret_key_reves(self) -> Sequence['outputs.GetServiceTemplateContainerEnvValueSourceSecretKeyRefResult']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        """
        return pulumi.get(self, "secret_key_reves")


@pulumi.output_type
class GetServiceTemplateContainerEnvValueSourceSecretKeyRefResult(dict):
    def __init__(__self__, *,
                 secret: str,
                 version: str):
        """
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeResult(dict):
    def __init__(__self__, *,
                 failure_threshold: int,
                 grpcs: Sequence['outputs.GetServiceTemplateContainerLivenessProbeGrpcResult'],
                 http_gets: Sequence['outputs.GetServiceTemplateContainerLivenessProbeHttpGetResult'],
                 initial_delay_seconds: int,
                 period_seconds: int,
                 tcp_sockets: Sequence['outputs.GetServiceTemplateContainerLivenessProbeTcpSocketResult'],
                 timeout_seconds: int):
        """
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param Sequence['GetServiceTemplateContainerLivenessProbeGrpcArgs'] grpcs: GRPC specifies an action involving a GRPC port.
        :param Sequence['GetServiceTemplateContainerLivenessProbeHttpGetArgs'] http_gets: HTTPGet specifies the http request to perform.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param Sequence['GetServiceTemplateContainerLivenessProbeTcpSocketArgs'] tcp_sockets: TCPSocketAction describes an action based on opening a socket
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "grpcs", grpcs)
        pulumi.set(__self__, "http_gets", http_gets)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> int:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpcs(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeGrpcResult']:
        """
        GRPC specifies an action involving a GRPC port.
        """
        return pulumi.get(self, "grpcs")

    @property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeHttpGetResult']:
        """
        HTTPGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_gets")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> int:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> int:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeTcpSocketResult']:
        """
        TCPSocketAction describes an action based on opening a socket
        """
        return pulumi.get(self, "tcp_sockets")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeGrpcResult(dict):
    def __init__(__self__, *,
                 port: int,
                 service: str):
        """
        :param int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeHttpGetResult(dict):
    def __init__(__self__, *,
                 http_headers: Sequence['outputs.GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderResult'],
                 path: str,
                 port: int):
        """
        :param Sequence['GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param str path: Path to access on the HTTP server. Defaults to '/'.
        :param int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderResult']:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the Cloud Run v2 Service.
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeTcpSocketResult(dict):
    def __init__(__self__, *,
                 port: int):
        """
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the exposed port of the container, which
               is the value of container.ports[0].containerPort.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the exposed port of the container, which
        is the value of container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateContainerPortResult(dict):
    def __init__(__self__, *,
                 container_port: int,
                 name: str):
        """
        :param int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param str name: The name of the Cloud Run v2 Service.
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateContainerResourceResult(dict):
    def __init__(__self__, *,
                 cpu_idle: bool,
                 limits: Mapping[str, str],
                 startup_cpu_boost: bool):
        """
        :param bool cpu_idle: Determines whether CPU is only allocated during requests. True by default if the parent 'resources' field is not set. However, if
               'resources' is set, this field must be explicitly set to true to preserve the default behavior.
        :param Mapping[str, str] limits: Only memory, CPU, and nvidia.com/gpu are supported. Use key 'cpu' for CPU limit, 'memory' for memory limit, 'nvidia.com/gpu' for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param bool startup_cpu_boost: Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        pulumi.set(__self__, "cpu_idle", cpu_idle)
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "startup_cpu_boost", startup_cpu_boost)

    @property
    @pulumi.getter(name="cpuIdle")
    def cpu_idle(self) -> bool:
        """
        Determines whether CPU is only allocated during requests. True by default if the parent 'resources' field is not set. However, if
        'resources' is set, this field must be explicitly set to true to preserve the default behavior.
        """
        return pulumi.get(self, "cpu_idle")

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        Only memory, CPU, and nvidia.com/gpu are supported. Use key 'cpu' for CPU limit, 'memory' for memory limit, 'nvidia.com/gpu' for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="startupCpuBoost")
    def startup_cpu_boost(self) -> bool:
        """
        Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        return pulumi.get(self, "startup_cpu_boost")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeResult(dict):
    def __init__(__self__, *,
                 failure_threshold: int,
                 grpcs: Sequence['outputs.GetServiceTemplateContainerStartupProbeGrpcResult'],
                 http_gets: Sequence['outputs.GetServiceTemplateContainerStartupProbeHttpGetResult'],
                 initial_delay_seconds: int,
                 period_seconds: int,
                 tcp_sockets: Sequence['outputs.GetServiceTemplateContainerStartupProbeTcpSocketResult'],
                 timeout_seconds: int):
        """
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param Sequence['GetServiceTemplateContainerStartupProbeGrpcArgs'] grpcs: GRPC specifies an action involving a GRPC port.
        :param Sequence['GetServiceTemplateContainerStartupProbeHttpGetArgs'] http_gets: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param Sequence['GetServiceTemplateContainerStartupProbeTcpSocketArgs'] tcp_sockets: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "grpcs", grpcs)
        pulumi.set(__self__, "http_gets", http_gets)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> int:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpcs(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeGrpcResult']:
        """
        GRPC specifies an action involving a GRPC port.
        """
        return pulumi.get(self, "grpcs")

    @property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeHttpGetResult']:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        """
        return pulumi.get(self, "http_gets")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> int:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> int:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeTcpSocketResult']:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        """
        return pulumi.get(self, "tcp_sockets")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeGrpcResult(dict):
    def __init__(__self__, *,
                 port: int,
                 service: str):
        """
        :param int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeHttpGetResult(dict):
    def __init__(__self__, *,
                 http_headers: Sequence['outputs.GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderResult'],
                 path: str,
                 port: int):
        """
        :param Sequence['GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param str path: Path to access on the HTTP server. Defaults to '/'.
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderResult']:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the Cloud Run v2 Service.
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeTcpSocketResult(dict):
    def __init__(__self__, *,
                 port: int):
        """
        :param int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: str,
                 name: str):
        """
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param str name: The name of the Cloud Run v2 Service.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateNodeSelectorResult(dict):
    def __init__(__self__, *,
                 accelerator: str):
        """
        :param str accelerator: The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        pulumi.set(__self__, "accelerator", accelerator)

    @property
    @pulumi.getter
    def accelerator(self) -> str:
        """
        The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        return pulumi.get(self, "accelerator")


@pulumi.output_type
class GetServiceTemplateScalingResult(dict):
    def __init__(__self__, *,
                 max_instance_count: int,
                 min_instance_count: int):
        """
        :param int max_instance_count: Maximum number of serving instances that this resource should have.
        :param int min_instance_count: Minimum number of serving instances that this resource should have.
        """
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> int:
        """
        Maximum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> int:
        """
        Minimum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class GetServiceTemplateServiceMeshResult(dict):
    def __init__(__self__, *,
                 mesh: str):
        """
        :param str mesh: The Mesh resource name. For more information see https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.meshes#resource:-mesh.
        """
        pulumi.set(__self__, "mesh", mesh)

    @property
    @pulumi.getter
    def mesh(self) -> str:
        """
        The Mesh resource name. For more information see https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.meshes#resource:-mesh.
        """
        return pulumi.get(self, "mesh")


@pulumi.output_type
class GetServiceTemplateVolumeResult(dict):
    def __init__(__self__, *,
                 cloud_sql_instances: Sequence['outputs.GetServiceTemplateVolumeCloudSqlInstanceResult'],
                 empty_dirs: Sequence['outputs.GetServiceTemplateVolumeEmptyDirResult'],
                 gcs: Sequence['outputs.GetServiceTemplateVolumeGcResult'],
                 name: str,
                 nfs: Sequence['outputs.GetServiceTemplateVolumeNfResult'],
                 secrets: Sequence['outputs.GetServiceTemplateVolumeSecretResult']):
        """
        :param Sequence['GetServiceTemplateVolumeCloudSqlInstanceArgs'] cloud_sql_instances: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        :param Sequence['GetServiceTemplateVolumeEmptyDirArgs'] empty_dirs: Ephemeral storage used as a shared volume.
        :param Sequence['GetServiceTemplateVolumeGcArgs'] gcs: Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        :param str name: The name of the Cloud Run v2 Service.
        :param Sequence['GetServiceTemplateVolumeNfArgs'] nfs: Represents an NFS mount.
        :param Sequence['GetServiceTemplateVolumeSecretArgs'] secrets: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        pulumi.set(__self__, "cloud_sql_instances", cloud_sql_instances)
        pulumi.set(__self__, "empty_dirs", empty_dirs)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs", nfs)
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="cloudSqlInstances")
    def cloud_sql_instances(self) -> Sequence['outputs.GetServiceTemplateVolumeCloudSqlInstanceResult']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        """
        return pulumi.get(self, "cloud_sql_instances")

    @property
    @pulumi.getter(name="emptyDirs")
    def empty_dirs(self) -> Sequence['outputs.GetServiceTemplateVolumeEmptyDirResult']:
        """
        Ephemeral storage used as a shared volume.
        """
        return pulumi.get(self, "empty_dirs")

    @property
    @pulumi.getter
    def gcs(self) -> Sequence['outputs.GetServiceTemplateVolumeGcResult']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nfs(self) -> Sequence['outputs.GetServiceTemplateVolumeNfResult']:
        """
        Represents an NFS mount.
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetServiceTemplateVolumeSecretResult']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class GetServiceTemplateVolumeCloudSqlInstanceResult(dict):
    def __init__(__self__, *,
                 instances: Sequence[str]):
        """
        :param Sequence[str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Sequence[str]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class GetServiceTemplateVolumeEmptyDirResult(dict):
    def __init__(__self__, *,
                 medium: str,
                 size_limit: str):
        """
        :param str medium: The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        :param str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        pulumi.set(__self__, "medium", medium)
        pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> str:
        """
        The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> str:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class GetServiceTemplateVolumeGcResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 read_only: bool):
        """
        :param str bucket: GCS Bucket name
        :param bool read_only: If true, mount the GCS bucket as read-only
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        GCS Bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        If true, mount the GCS bucket as read-only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetServiceTemplateVolumeNfResult(dict):
    def __init__(__self__, *,
                 path: str,
                 read_only: bool,
                 server: str):
        """
        :param str path: Path that is exported by the NFS server.
        :param bool read_only: If true, mount the NFS volume as read only
        :param str server: Hostname or IP address of the NFS server
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        If true, mount the NFS volume as read only
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def server(self) -> str:
        """
        Hostname or IP address of the NFS server
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetServiceTemplateVolumeSecretResult(dict):
    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.GetServiceTemplateVolumeSecretItemResult'],
                 secret: str):
        """
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['GetServiceTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        :param str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceTemplateVolumeSecretItemResult']:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetServiceTemplateVolumeSecretItemResult(dict):
    def __init__(__self__, *,
                 mode: int,
                 path: str,
                 version: str):
        """
        :param int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param str path: The relative path of the secret in the container.
        :param str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServiceTemplateVpcAccessResult(dict):
    def __init__(__self__, *,
                 connector: str,
                 egress: str,
                 network_interfaces: Sequence['outputs.GetServiceTemplateVpcAccessNetworkInterfaceResult']):
        """
        :param str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param str egress: Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        :param Sequence['GetServiceTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
        """
        pulumi.set(__self__, "connector", connector)
        pulumi.set(__self__, "egress", egress)
        pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter
    def connector(self) -> str:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def egress(self) -> str:
        """
        Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        """
        return pulumi.get(self, "egress")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetServiceTemplateVpcAccessNetworkInterfaceResult']:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class GetServiceTemplateVpcAccessNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 network: str,
                 subnetwork: str,
                 tags: Sequence[str]):
        """
        :param str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[str] tags: Network tags applied to this Cloud Run service.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Network tags applied to this Cloud Run service.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetServiceTerminalConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: str,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 revision_reason: str,
                 severity: str,
                 state: str,
                 type: str):
        """
        :param str execution_reason: A reason for the execution condition.
        :param str last_transition_time: Last time the condition transitioned from one status to another.
        :param str message: Human readable message indicating details about the current status.
        :param str reason: A common (service-level) reason for this condition.
        :param str revision_reason: A reason for the revision condition.
        :param str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param str state: State of the condition.
        :param str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceTrafficResult(dict):
    def __init__(__self__, *,
                 percent: int,
                 revision: str,
                 tag: str,
                 type: str):
        """
        :param int percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param str revision: Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param str tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param str type: The allocation type for this traffic target. Possible values: ["TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST", "TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION"]
        """
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The allocation type for this traffic target. Possible values: ["TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST", "TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION"]
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceTrafficStatusResult(dict):
    def __init__(__self__, *,
                 percent: int,
                 revision: str,
                 tag: str,
                 type: str,
                 uri: str):
        """
        :param int percent: Specifies percent of the traffic to this Revision.
        :param str revision: Revision to which this traffic is sent.
        :param str tag: Indicates the string used in the URI to exclusively reference this target.
        :param str type: The allocation type for this traffic target.
        :param str uri: Displays the target URI.
        """
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies percent of the traffic to this Revision.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        Revision to which this traffic is sent.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Indicates the string used in the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Displays the target URI.
        """
        return pulumi.get(self, "uri")


