# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EnvironmentConfigArgs',
    'EnvironmentConfigArgsDict',
    'EnvironmentConfigDataRetentionConfigArgs',
    'EnvironmentConfigDataRetentionConfigArgsDict',
    'EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgs',
    'EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgsDict',
    'EnvironmentConfigDatabaseConfigArgs',
    'EnvironmentConfigDatabaseConfigArgsDict',
    'EnvironmentConfigEncryptionConfigArgs',
    'EnvironmentConfigEncryptionConfigArgsDict',
    'EnvironmentConfigMaintenanceWindowArgs',
    'EnvironmentConfigMaintenanceWindowArgsDict',
    'EnvironmentConfigMasterAuthorizedNetworksConfigArgs',
    'EnvironmentConfigMasterAuthorizedNetworksConfigArgsDict',
    'EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgs',
    'EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgsDict',
    'EnvironmentConfigNodeConfigArgs',
    'EnvironmentConfigNodeConfigArgsDict',
    'EnvironmentConfigNodeConfigIpAllocationPolicyArgs',
    'EnvironmentConfigNodeConfigIpAllocationPolicyArgsDict',
    'EnvironmentConfigPrivateEnvironmentConfigArgs',
    'EnvironmentConfigPrivateEnvironmentConfigArgsDict',
    'EnvironmentConfigRecoveryConfigArgs',
    'EnvironmentConfigRecoveryConfigArgsDict',
    'EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgs',
    'EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgsDict',
    'EnvironmentConfigSoftwareConfigArgs',
    'EnvironmentConfigSoftwareConfigArgsDict',
    'EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgs',
    'EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgsDict',
    'EnvironmentConfigWebServerConfigArgs',
    'EnvironmentConfigWebServerConfigArgsDict',
    'EnvironmentConfigWebServerNetworkAccessControlArgs',
    'EnvironmentConfigWebServerNetworkAccessControlArgsDict',
    'EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgs',
    'EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgsDict',
    'EnvironmentConfigWorkloadsConfigArgs',
    'EnvironmentConfigWorkloadsConfigArgsDict',
    'EnvironmentConfigWorkloadsConfigDagProcessorArgs',
    'EnvironmentConfigWorkloadsConfigDagProcessorArgsDict',
    'EnvironmentConfigWorkloadsConfigSchedulerArgs',
    'EnvironmentConfigWorkloadsConfigSchedulerArgsDict',
    'EnvironmentConfigWorkloadsConfigTriggererArgs',
    'EnvironmentConfigWorkloadsConfigTriggererArgsDict',
    'EnvironmentConfigWorkloadsConfigWebServerArgs',
    'EnvironmentConfigWorkloadsConfigWebServerArgsDict',
    'EnvironmentConfigWorkloadsConfigWorkerArgs',
    'EnvironmentConfigWorkloadsConfigWorkerArgsDict',
    'EnvironmentStorageConfigArgs',
    'EnvironmentStorageConfigArgsDict',
]

MYPY = False

if not MYPY:
    class EnvironmentConfigArgsDict(TypedDict):
        airflow_uri: NotRequired[pulumi.Input[str]]
        """
        The URI of the Apache Airflow Web UI hosted within this
        environment.
        """
        dag_gcs_prefix: NotRequired[pulumi.Input[str]]
        """
        The Cloud Storage prefix of the DAGs for this environment.
        Although Cloud Storage objects reside in a flat namespace, a
        hierarchical file tree can be simulated using '/'-delimited
        object name prefixes. DAG objects for this environment
        reside in a simulated directory with this prefix.
        """
        data_retention_config: NotRequired[pulumi.Input['EnvironmentConfigDataRetentionConfigArgsDict']]
        """
        The configuration setting for Airflow data retention mechanism. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4. or newer
        """
        database_config: NotRequired[pulumi.Input['EnvironmentConfigDatabaseConfigArgsDict']]
        """
        The configuration of Cloud SQL instance that is used by the Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        enable_private_builds_only: NotRequired[pulumi.Input[bool]]
        """
        Optional. If true, builds performed during operations that install Python packages have only private connectivity to Google services. If false, the builds also have access to the internet.
        """
        enable_private_environment: NotRequired[pulumi.Input[bool]]
        """
        Optional. If true, a private Composer environment will be created.
        """
        encryption_config: NotRequired[pulumi.Input['EnvironmentConfigEncryptionConfigArgsDict']]
        """
        The encryption options for the Composer environment and its dependencies.
        """
        environment_size: NotRequired[pulumi.Input[str]]
        """
        The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        gke_cluster: NotRequired[pulumi.Input[str]]
        """
        The Kubernetes Engine cluster used to run this environment.
        """
        maintenance_window: NotRequired[pulumi.Input['EnvironmentConfigMaintenanceWindowArgsDict']]
        """
        The configuration for Cloud Composer maintenance window.
        """
        master_authorized_networks_config: NotRequired[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigArgsDict']]
        """
        Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        """
        node_config: NotRequired[pulumi.Input['EnvironmentConfigNodeConfigArgsDict']]
        """
        The configuration used for the Kubernetes Engine cluster.
        """
        node_count: NotRequired[pulumi.Input[int]]
        """
        The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        private_environment_config: NotRequired[pulumi.Input['EnvironmentConfigPrivateEnvironmentConfigArgsDict']]
        """
        The configuration used for the Private IP Cloud Composer environment.
        """
        recovery_config: NotRequired[pulumi.Input['EnvironmentConfigRecoveryConfigArgsDict']]
        """
        The recovery configuration settings for the Cloud Composer environment
        """
        resilience_mode: NotRequired[pulumi.Input[str]]
        """
        Whether high resilience is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.1.15-airflow-*.*.* and newer.
        """
        software_config: NotRequired[pulumi.Input['EnvironmentConfigSoftwareConfigArgsDict']]
        """
        The configuration settings for software inside the environment.
        """
        web_server_config: NotRequired[pulumi.Input['EnvironmentConfigWebServerConfigArgsDict']]
        """
        The configuration settings for the Airflow web server App Engine instance. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        web_server_network_access_control: NotRequired[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlArgsDict']]
        """
        Network-level access control policy for the Airflow web server.
        """
        workloads_config: NotRequired[pulumi.Input['EnvironmentConfigWorkloadsConfigArgsDict']]
        """
        The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. Supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
elif False:
    EnvironmentConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigArgs:
    def __init__(__self__, *,
                 airflow_uri: Optional[pulumi.Input[str]] = None,
                 dag_gcs_prefix: Optional[pulumi.Input[str]] = None,
                 data_retention_config: Optional[pulumi.Input['EnvironmentConfigDataRetentionConfigArgs']] = None,
                 database_config: Optional[pulumi.Input['EnvironmentConfigDatabaseConfigArgs']] = None,
                 enable_private_builds_only: Optional[pulumi.Input[bool]] = None,
                 enable_private_environment: Optional[pulumi.Input[bool]] = None,
                 encryption_config: Optional[pulumi.Input['EnvironmentConfigEncryptionConfigArgs']] = None,
                 environment_size: Optional[pulumi.Input[str]] = None,
                 gke_cluster: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['EnvironmentConfigMaintenanceWindowArgs']] = None,
                 master_authorized_networks_config: Optional[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigArgs']] = None,
                 node_config: Optional[pulumi.Input['EnvironmentConfigNodeConfigArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 private_environment_config: Optional[pulumi.Input['EnvironmentConfigPrivateEnvironmentConfigArgs']] = None,
                 recovery_config: Optional[pulumi.Input['EnvironmentConfigRecoveryConfigArgs']] = None,
                 resilience_mode: Optional[pulumi.Input[str]] = None,
                 software_config: Optional[pulumi.Input['EnvironmentConfigSoftwareConfigArgs']] = None,
                 web_server_config: Optional[pulumi.Input['EnvironmentConfigWebServerConfigArgs']] = None,
                 web_server_network_access_control: Optional[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlArgs']] = None,
                 workloads_config: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigArgs']] = None):
        """
        :param pulumi.Input[str] airflow_uri: The URI of the Apache Airflow Web UI hosted within this
               environment.
        :param pulumi.Input[str] dag_gcs_prefix: The Cloud Storage prefix of the DAGs for this environment.
               Although Cloud Storage objects reside in a flat namespace, a
               hierarchical file tree can be simulated using '/'-delimited
               object name prefixes. DAG objects for this environment
               reside in a simulated directory with this prefix.
        :param pulumi.Input['EnvironmentConfigDataRetentionConfigArgs'] data_retention_config: The configuration setting for Airflow data retention mechanism. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4. or newer
        :param pulumi.Input['EnvironmentConfigDatabaseConfigArgs'] database_config: The configuration of Cloud SQL instance that is used by the Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[bool] enable_private_builds_only: Optional. If true, builds performed during operations that install Python packages have only private connectivity to Google services. If false, the builds also have access to the internet.
        :param pulumi.Input[bool] enable_private_environment: Optional. If true, a private Composer environment will be created.
        :param pulumi.Input['EnvironmentConfigEncryptionConfigArgs'] encryption_config: The encryption options for the Composer environment and its dependencies.
        :param pulumi.Input[str] environment_size: The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param pulumi.Input[str] gke_cluster: The Kubernetes Engine cluster used to run this environment.
        :param pulumi.Input['EnvironmentConfigMaintenanceWindowArgs'] maintenance_window: The configuration for Cloud Composer maintenance window.
        :param pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigArgs'] master_authorized_networks_config: Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        :param pulumi.Input['EnvironmentConfigNodeConfigArgs'] node_config: The configuration used for the Kubernetes Engine cluster.
        :param pulumi.Input[int] node_count: The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input['EnvironmentConfigPrivateEnvironmentConfigArgs'] private_environment_config: The configuration used for the Private IP Cloud Composer environment.
        :param pulumi.Input['EnvironmentConfigRecoveryConfigArgs'] recovery_config: The recovery configuration settings for the Cloud Composer environment
        :param pulumi.Input[str] resilience_mode: Whether high resilience is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.1.15-airflow-*.*.* and newer.
        :param pulumi.Input['EnvironmentConfigSoftwareConfigArgs'] software_config: The configuration settings for software inside the environment.
        :param pulumi.Input['EnvironmentConfigWebServerConfigArgs'] web_server_config: The configuration settings for the Airflow web server App Engine instance. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlArgs'] web_server_network_access_control: Network-level access control policy for the Airflow web server.
        :param pulumi.Input['EnvironmentConfigWorkloadsConfigArgs'] workloads_config: The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. Supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        if airflow_uri is not None:
            pulumi.set(__self__, "airflow_uri", airflow_uri)
        if dag_gcs_prefix is not None:
            pulumi.set(__self__, "dag_gcs_prefix", dag_gcs_prefix)
        if data_retention_config is not None:
            pulumi.set(__self__, "data_retention_config", data_retention_config)
        if database_config is not None:
            pulumi.set(__self__, "database_config", database_config)
        if enable_private_builds_only is not None:
            pulumi.set(__self__, "enable_private_builds_only", enable_private_builds_only)
        if enable_private_environment is not None:
            pulumi.set(__self__, "enable_private_environment", enable_private_environment)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if environment_size is not None:
            pulumi.set(__self__, "environment_size", environment_size)
        if gke_cluster is not None:
            pulumi.set(__self__, "gke_cluster", gke_cluster)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if master_authorized_networks_config is not None:
            pulumi.set(__self__, "master_authorized_networks_config", master_authorized_networks_config)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if private_environment_config is not None:
            pulumi.set(__self__, "private_environment_config", private_environment_config)
        if recovery_config is not None:
            pulumi.set(__self__, "recovery_config", recovery_config)
        if resilience_mode is not None:
            pulumi.set(__self__, "resilience_mode", resilience_mode)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if web_server_config is not None:
            pulumi.set(__self__, "web_server_config", web_server_config)
        if web_server_network_access_control is not None:
            pulumi.set(__self__, "web_server_network_access_control", web_server_network_access_control)
        if workloads_config is not None:
            pulumi.set(__self__, "workloads_config", workloads_config)

    @property
    @pulumi.getter(name="airflowUri")
    def airflow_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the Apache Airflow Web UI hosted within this
        environment.
        """
        return pulumi.get(self, "airflow_uri")

    @airflow_uri.setter
    def airflow_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "airflow_uri", value)

    @property
    @pulumi.getter(name="dagGcsPrefix")
    def dag_gcs_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage prefix of the DAGs for this environment.
        Although Cloud Storage objects reside in a flat namespace, a
        hierarchical file tree can be simulated using '/'-delimited
        object name prefixes. DAG objects for this environment
        reside in a simulated directory with this prefix.
        """
        return pulumi.get(self, "dag_gcs_prefix")

    @dag_gcs_prefix.setter
    def dag_gcs_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dag_gcs_prefix", value)

    @property
    @pulumi.getter(name="dataRetentionConfig")
    def data_retention_config(self) -> Optional[pulumi.Input['EnvironmentConfigDataRetentionConfigArgs']]:
        """
        The configuration setting for Airflow data retention mechanism. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4. or newer
        """
        return pulumi.get(self, "data_retention_config")

    @data_retention_config.setter
    def data_retention_config(self, value: Optional[pulumi.Input['EnvironmentConfigDataRetentionConfigArgs']]):
        pulumi.set(self, "data_retention_config", value)

    @property
    @pulumi.getter(name="databaseConfig")
    def database_config(self) -> Optional[pulumi.Input['EnvironmentConfigDatabaseConfigArgs']]:
        """
        The configuration of Cloud SQL instance that is used by the Apache Airflow software. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "database_config")

    @database_config.setter
    def database_config(self, value: Optional[pulumi.Input['EnvironmentConfigDatabaseConfigArgs']]):
        pulumi.set(self, "database_config", value)

    @property
    @pulumi.getter(name="enablePrivateBuildsOnly")
    def enable_private_builds_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, builds performed during operations that install Python packages have only private connectivity to Google services. If false, the builds also have access to the internet.
        """
        return pulumi.get(self, "enable_private_builds_only")

    @enable_private_builds_only.setter
    def enable_private_builds_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_builds_only", value)

    @property
    @pulumi.getter(name="enablePrivateEnvironment")
    def enable_private_environment(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, a private Composer environment will be created.
        """
        return pulumi.get(self, "enable_private_environment")

    @enable_private_environment.setter
    def enable_private_environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_environment", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['EnvironmentConfigEncryptionConfigArgs']]:
        """
        The encryption options for the Composer environment and its dependencies.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['EnvironmentConfigEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="environmentSize")
    def environment_size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "environment_size")

    @environment_size.setter
    def environment_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_size", value)

    @property
    @pulumi.getter(name="gkeCluster")
    def gke_cluster(self) -> Optional[pulumi.Input[str]]:
        """
        The Kubernetes Engine cluster used to run this environment.
        """
        return pulumi.get(self, "gke_cluster")

    @gke_cluster.setter
    def gke_cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gke_cluster", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['EnvironmentConfigMaintenanceWindowArgs']]:
        """
        The configuration for Cloud Composer maintenance window.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['EnvironmentConfigMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="masterAuthorizedNetworksConfig")
    def master_authorized_networks_config(self) -> Optional[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigArgs']]:
        """
        Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        """
        return pulumi.get(self, "master_authorized_networks_config")

    @master_authorized_networks_config.setter
    def master_authorized_networks_config(self, value: Optional[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigArgs']]):
        pulumi.set(self, "master_authorized_networks_config", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['EnvironmentConfigNodeConfigArgs']]:
        """
        The configuration used for the Kubernetes Engine cluster.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['EnvironmentConfigNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="privateEnvironmentConfig")
    def private_environment_config(self) -> Optional[pulumi.Input['EnvironmentConfigPrivateEnvironmentConfigArgs']]:
        """
        The configuration used for the Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_environment_config")

    @private_environment_config.setter
    def private_environment_config(self, value: Optional[pulumi.Input['EnvironmentConfigPrivateEnvironmentConfigArgs']]):
        pulumi.set(self, "private_environment_config", value)

    @property
    @pulumi.getter(name="recoveryConfig")
    def recovery_config(self) -> Optional[pulumi.Input['EnvironmentConfigRecoveryConfigArgs']]:
        """
        The recovery configuration settings for the Cloud Composer environment
        """
        return pulumi.get(self, "recovery_config")

    @recovery_config.setter
    def recovery_config(self, value: Optional[pulumi.Input['EnvironmentConfigRecoveryConfigArgs']]):
        pulumi.set(self, "recovery_config", value)

    @property
    @pulumi.getter(name="resilienceMode")
    def resilience_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Whether high resilience is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.1.15-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "resilience_mode")

    @resilience_mode.setter
    def resilience_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resilience_mode", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['EnvironmentConfigSoftwareConfigArgs']]:
        """
        The configuration settings for software inside the environment.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['EnvironmentConfigSoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter(name="webServerConfig")
    def web_server_config(self) -> Optional[pulumi.Input['EnvironmentConfigWebServerConfigArgs']]:
        """
        The configuration settings for the Airflow web server App Engine instance. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "web_server_config")

    @web_server_config.setter
    def web_server_config(self, value: Optional[pulumi.Input['EnvironmentConfigWebServerConfigArgs']]):
        pulumi.set(self, "web_server_config", value)

    @property
    @pulumi.getter(name="webServerNetworkAccessControl")
    def web_server_network_access_control(self) -> Optional[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlArgs']]:
        """
        Network-level access control policy for the Airflow web server.
        """
        return pulumi.get(self, "web_server_network_access_control")

    @web_server_network_access_control.setter
    def web_server_network_access_control(self, value: Optional[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlArgs']]):
        pulumi.set(self, "web_server_network_access_control", value)

    @property
    @pulumi.getter(name="workloadsConfig")
    def workloads_config(self) -> Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigArgs']]:
        """
        The workloads configuration settings for the GKE cluster associated with the Cloud Composer environment. Supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "workloads_config")

    @workloads_config.setter
    def workloads_config(self, value: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigArgs']]):
        pulumi.set(self, "workloads_config", value)


if not MYPY:
    class EnvironmentConfigDataRetentionConfigArgsDict(TypedDict):
        task_logs_retention_configs: pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgsDict']]]
        """
        Optional. The configuration setting for Task Logs.
        """
elif False:
    EnvironmentConfigDataRetentionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigDataRetentionConfigArgs:
    def __init__(__self__, *,
                 task_logs_retention_configs: pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgs']]] task_logs_retention_configs: Optional. The configuration setting for Task Logs.
        """
        pulumi.set(__self__, "task_logs_retention_configs", task_logs_retention_configs)

    @property
    @pulumi.getter(name="taskLogsRetentionConfigs")
    def task_logs_retention_configs(self) -> pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgs']]]:
        """
        Optional. The configuration setting for Task Logs.
        """
        return pulumi.get(self, "task_logs_retention_configs")

    @task_logs_retention_configs.setter
    def task_logs_retention_configs(self, value: pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgs']]]):
        pulumi.set(self, "task_logs_retention_configs", value)


if not MYPY:
    class EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgsDict(TypedDict):
        storage_mode: NotRequired[pulumi.Input[str]]
        """
        Whether logs in cloud logging only is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4 and newer.
        """
elif False:
    EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigArgs:
    def __init__(__self__, *,
                 storage_mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] storage_mode: Whether logs in cloud logging only is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4 and newer.
        """
        if storage_mode is not None:
            pulumi.set(__self__, "storage_mode", storage_mode)

    @property
    @pulumi.getter(name="storageMode")
    def storage_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Whether logs in cloud logging only is enabled or not. This field is supported for Cloud Composer environments in versions composer-2.0.32-airflow-2.1.4 and newer.
        """
        return pulumi.get(self, "storage_mode")

    @storage_mode.setter
    def storage_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_mode", value)


if not MYPY:
    class EnvironmentConfigDatabaseConfigArgsDict(TypedDict):
        machine_type: NotRequired[pulumi.Input[str]]
        """
        Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        zone: NotRequired[pulumi.Input[str]]
        """
        Optional. Cloud SQL database preferred zone.
        """
elif False:
    EnvironmentConfigDatabaseConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigDatabaseConfigArgs:
    def __init__(__self__, *,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] machine_type: Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        :param pulumi.Input[str] zone: Optional. Cloud SQL database preferred zone.
        """
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Cloud SQL database preferred zone.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class EnvironmentConfigEncryptionConfigArgsDict(TypedDict):
        kms_key_name: pulumi.Input[str]
        """
        Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated.
        """
elif False:
    EnvironmentConfigEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigEncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


if not MYPY:
    class EnvironmentConfigMaintenanceWindowArgsDict(TypedDict):
        end_time: pulumi.Input[str]
        """
        Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to 'start_time'.
        """
        recurrence: pulumi.Input[str]
        """
        Maintenance window recurrence. Format is a subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) 'RRULE'. The only allowed values for 'FREQ' field are 'FREQ=DAILY' and 'FREQ=WEEKLY;BYDAY=...'. Example values: 'FREQ=WEEKLY;BYDAY=TU,WE', 'FREQ=DAILY'.
        """
        start_time: pulumi.Input[str]
        """
        Start time of the first recurrence of the maintenance window.
        """
elif False:
    EnvironmentConfigMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigMaintenanceWindowArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[str],
                 recurrence: pulumi.Input[str],
                 start_time: pulumi.Input[str]):
        """
        :param pulumi.Input[str] end_time: Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to 'start_time'.
        :param pulumi.Input[str] recurrence: Maintenance window recurrence. Format is a subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) 'RRULE'. The only allowed values for 'FREQ' field are 'FREQ=DAILY' and 'FREQ=WEEKLY;BYDAY=...'. Example values: 'FREQ=WEEKLY;BYDAY=TU,WE', 'FREQ=DAILY'.
        :param pulumi.Input[str] start_time: Start time of the first recurrence of the maintenance window.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[str]:
        """
        Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to 'start_time'.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def recurrence(self) -> pulumi.Input[str]:
        """
        Maintenance window recurrence. Format is a subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) 'RRULE'. The only allowed values for 'FREQ' field are 'FREQ=DAILY' and 'FREQ=WEEKLY;BYDAY=...'. Example values: 'FREQ=WEEKLY;BYDAY=TU,WE', 'FREQ=DAILY'.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: pulumi.Input[str]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Start time of the first recurrence of the maintenance window.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class EnvironmentConfigMasterAuthorizedNetworksConfigArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        Whether or not master authorized networks is enabled.
        """
        cidr_blocks: NotRequired[pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgsDict']]]]
        """
        cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        """
elif False:
    EnvironmentConfigMasterAuthorizedNetworksConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigMasterAuthorizedNetworksConfigArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgs']]]] = None):
        """
        :param pulumi.Input[bool] enabled: Whether or not master authorized networks is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgs']]] cidr_blocks: cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        """
        pulumi.set(__self__, "enabled", enabled)
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether or not master authorized networks is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgs']]]]:
        """
        cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        """
        return pulumi.get(self, "cidr_blocks")

    @cidr_blocks.setter
    def cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgs']]]]):
        pulumi.set(self, "cidr_blocks", value)


if not MYPY:
    class EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgsDict(TypedDict):
        cidr_block: pulumi.Input[str]
        """
        cidr_block must be specified in CIDR notation.
        """
        display_name: NotRequired[pulumi.Input[str]]
        """
        display_name is a field for users to identify CIDR blocks.
        """
elif False:
    EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigMasterAuthorizedNetworksConfigCidrBlockArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cidr_block: cidr_block must be specified in CIDR notation.
        :param pulumi.Input[str] display_name: display_name is a field for users to identify CIDR blocks.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[str]:
        """
        cidr_block must be specified in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        display_name is a field for users to identify CIDR blocks.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)


if not MYPY:
    class EnvironmentConfigNodeConfigArgsDict(TypedDict):
        composer_internal_ipv4_cidr_block: NotRequired[pulumi.Input[str]]
        """
        IPv4 cidr range that will be used by Composer internal components.
        """
        composer_network_attachment: NotRequired[pulumi.Input[str]]
        """
        PSC (Private Service Connect) Network entry point. Customers can pre-create the Network Attachment and point Cloud Composer environment to use. It is possible to share network attachment among many environments, provided enough IP addresses are available.
        """
        disk_size_gb: NotRequired[pulumi.Input[int]]
        """
        The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        enable_ip_masq_agent: NotRequired[pulumi.Input[bool]]
        """
        Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for all destination addresses, except between pods traffic. See: https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
        """
        ip_allocation_policy: NotRequired[pulumi.Input['EnvironmentConfigNodeConfigIpAllocationPolicyArgsDict']]
        """
        Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
        """
        machine_type: NotRequired[pulumi.Input[str]]
        """
        The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        max_pods_per_node: NotRequired[pulumi.Input[int]]
        """
        The maximum pods per node in the GKE cluster allocated during environment creation. Lowering this value reduces IP address consumption by the Cloud Composer Kubernetes cluster. This value can only be set during environment creation, and only if the environment is VPC-Native. The range of possible values is 8-110, and the default is 32. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        network: NotRequired[pulumi.Input[str]]
        """
        The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
        """
        oauth_scopes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The set of Google API scopes to be made available on all node VMs. Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        service_account: NotRequired[pulumi.Input[str]]
        """
        The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
        """
        subnetwork: NotRequired[pulumi.Input[str]]
        """
        The Compute Engine subnetwork to be used for machine communications, specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated.
        """
        zone: NotRequired[pulumi.Input[str]]
        """
        The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
elif False:
    EnvironmentConfigNodeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigNodeConfigArgs:
    def __init__(__self__, *,
                 composer_internal_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 composer_network_attachment: Optional[pulumi.Input[str]] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 enable_ip_masq_agent: Optional[pulumi.Input[bool]] = None,
                 ip_allocation_policy: Optional[pulumi.Input['EnvironmentConfigNodeConfigIpAllocationPolicyArgs']] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] composer_internal_ipv4_cidr_block: IPv4 cidr range that will be used by Composer internal components.
        :param pulumi.Input[str] composer_network_attachment: PSC (Private Service Connect) Network entry point. Customers can pre-create the Network Attachment and point Cloud Composer environment to use. It is possible to share network attachment among many environments, provided enough IP addresses are available.
        :param pulumi.Input[int] disk_size_gb: The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[bool] enable_ip_masq_agent: Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for all destination addresses, except between pods traffic. See: https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
        :param pulumi.Input['EnvironmentConfigNodeConfigIpAllocationPolicyArgs'] ip_allocation_policy: Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
        :param pulumi.Input[str] machine_type: The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[int] max_pods_per_node: The maximum pods per node in the GKE cluster allocated during environment creation. Lowering this value reduces IP address consumption by the Cloud Composer Kubernetes cluster. This value can only be set during environment creation, and only if the environment is VPC-Native. The range of possible values is 8-110, and the default is 32. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[str] network: The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: The set of Google API scopes to be made available on all node VMs. Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[str] service_account: The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
        :param pulumi.Input[str] subnetwork: The Compute Engine subnetwork to be used for machine communications, specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated.
        :param pulumi.Input[str] zone: The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        if composer_internal_ipv4_cidr_block is not None:
            pulumi.set(__self__, "composer_internal_ipv4_cidr_block", composer_internal_ipv4_cidr_block)
        if composer_network_attachment is not None:
            pulumi.set(__self__, "composer_network_attachment", composer_network_attachment)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if enable_ip_masq_agent is not None:
            pulumi.set(__self__, "enable_ip_masq_agent", enable_ip_masq_agent)
        if ip_allocation_policy is not None:
            pulumi.set(__self__, "ip_allocation_policy", ip_allocation_policy)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="composerInternalIpv4CidrBlock")
    def composer_internal_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 cidr range that will be used by Composer internal components.
        """
        return pulumi.get(self, "composer_internal_ipv4_cidr_block")

    @composer_internal_ipv4_cidr_block.setter
    def composer_internal_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "composer_internal_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="composerNetworkAttachment")
    def composer_network_attachment(self) -> Optional[pulumi.Input[str]]:
        """
        PSC (Private Service Connect) Network entry point. Customers can pre-create the Network Attachment and point Cloud Composer environment to use. It is possible to share network attachment among many environments, provided enough IP addresses are available.
        """
        return pulumi.get(self, "composer_network_attachment")

    @composer_network_attachment.setter
    def composer_network_attachment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "composer_network_attachment", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="enableIpMasqAgent")
    def enable_ip_masq_agent(self) -> Optional[pulumi.Input[bool]]:
        """
        Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for all destination addresses, except between pods traffic. See: https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
        """
        return pulumi.get(self, "enable_ip_masq_agent")

    @enable_ip_masq_agent.setter
    def enable_ip_masq_agent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ip_masq_agent", value)

    @property
    @pulumi.getter(name="ipAllocationPolicy")
    def ip_allocation_policy(self) -> Optional[pulumi.Input['EnvironmentConfigNodeConfigIpAllocationPolicyArgs']]:
        """
        Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
        """
        return pulumi.get(self, "ip_allocation_policy")

    @ip_allocation_policy.setter
    def ip_allocation_policy(self, value: Optional[pulumi.Input['EnvironmentConfigNodeConfigIpAllocationPolicyArgs']]):
        pulumi.set(self, "ip_allocation_policy", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum pods per node in the GKE cluster allocated during environment creation. Lowering this value reduces IP address consumption by the Cloud Composer Kubernetes cluster. This value can only be set during environment creation, and only if the environment is VPC-Native. The range of possible values is 8-110, and the default is 32. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of Google API scopes to be made available on all node VMs. Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine subnetwork to be used for machine communications, specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class EnvironmentConfigNodeConfigIpAllocationPolicyArgsDict(TypedDict):
        cluster_ipv4_cidr_block: NotRequired[pulumi.Input[str]]
        """
        The IP address range used to allocate IP addresses to pods in the cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both.
        """
        cluster_secondary_range_name: NotRequired[pulumi.Input[str]]
        """
        The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        """
        services_ipv4_cidr_block: NotRequired[pulumi.Input[str]]
        """
        The IP address range used to allocate IP addresses in this cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both.
        """
        services_secondary_range_name: NotRequired[pulumi.Input[str]]
        """
        The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        """
        use_ip_aliases: NotRequired[pulumi.Input[bool]]
        """
        Whether or not to enable Alias IPs in the GKE cluster. If true, a VPC-native cluster is created. Defaults to true if the ip_allocation_policy block is present in config. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
elif False:
    EnvironmentConfigNodeConfigIpAllocationPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigNodeConfigIpAllocationPolicyArgs:
    def __init__(__self__, *,
                 cluster_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 cluster_secondary_range_name: Optional[pulumi.Input[str]] = None,
                 services_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 services_secondary_range_name: Optional[pulumi.Input[str]] = None,
                 use_ip_aliases: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] cluster_ipv4_cidr_block: The IP address range used to allocate IP addresses to pods in the cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both.
        :param pulumi.Input[str] cluster_secondary_range_name: The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        :param pulumi.Input[str] services_ipv4_cidr_block: The IP address range used to allocate IP addresses in this cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both.
        :param pulumi.Input[str] services_secondary_range_name: The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        :param pulumi.Input[bool] use_ip_aliases: Whether or not to enable Alias IPs in the GKE cluster. If true, a VPC-native cluster is created. Defaults to true if the ip_allocation_policy block is present in config. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
        if cluster_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        if cluster_secondary_range_name is not None:
            pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        if services_ipv4_cidr_block is not None:
            pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        if services_secondary_range_name is not None:
            pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        if use_ip_aliases is not None:
            pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address range used to allocate IP addresses to pods in the cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @cluster_ipv4_cidr_block.setter
    def cluster_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either cluster_secondary_range_name or cluster_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @cluster_secondary_range_name.setter
    def cluster_secondary_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_secondary_range_name", value)

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address range used to allocate IP addresses in this cluster. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. /14) to have GKE choose a range with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @services_ipv4_cidr_block.setter
    def services_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either services_secondary_range_name or services_ipv4_cidr_block but not both. For Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*, this field is applicable only when use_ip_aliases is true.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @services_secondary_range_name.setter
    def services_secondary_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_secondary_range_name", value)

    @property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable Alias IPs in the GKE cluster. If true, a VPC-native cluster is created. Defaults to true if the ip_allocation_policy block is present in config. This field is only supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use VPC-native GKE clusters.
        """
        return pulumi.get(self, "use_ip_aliases")

    @use_ip_aliases.setter
    def use_ip_aliases(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ip_aliases", value)


if not MYPY:
    class EnvironmentConfigPrivateEnvironmentConfigArgsDict(TypedDict):
        cloud_composer_connection_subnetwork: NotRequired[pulumi.Input[str]]
        """
        When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        cloud_composer_network_ipv4_cidr_block: NotRequired[pulumi.Input[str]]
        """
        The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        cloud_sql_ipv4_cidr_block: NotRequired[pulumi.Input[str]]
        """
        The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block.
        """
        connection_type: NotRequired[pulumi.Input[str]]
        """
        Mode of internal communication within the Composer environment. Must be one of "VPC_PEERING" or "PRIVATE_SERVICE_CONNECT".
        """
        enable_private_endpoint: NotRequired[pulumi.Input[bool]]
        """
        If true, access to the public endpoint of the GKE cluster is denied. If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        enable_privately_used_public_ips: NotRequired[pulumi.Input[bool]]
        """
        When enabled, IPs from public (non-RFC1918) ranges can be used for ip_allocation_policy.cluster_ipv4_cidr_block and ip_allocation_policy.service_ipv4_cidr_block.
        """
        master_ipv4_cidr_block: NotRequired[pulumi.Input[str]]
        """
        The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
        """
        web_server_ipv4_cidr_block: NotRequired[pulumi.Input[str]]
        """
        The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
elif False:
    EnvironmentConfigPrivateEnvironmentConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigPrivateEnvironmentConfigArgs:
    def __init__(__self__, *,
                 cloud_composer_connection_subnetwork: Optional[pulumi.Input[str]] = None,
                 cloud_composer_network_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 cloud_sql_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 enable_private_endpoint: Optional[pulumi.Input[bool]] = None,
                 enable_privately_used_public_ips: Optional[pulumi.Input[bool]] = None,
                 master_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 web_server_ipv4_cidr_block: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cloud_composer_connection_subnetwork: When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param pulumi.Input[str] cloud_composer_network_ipv4_cidr_block: The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        :param pulumi.Input[str] cloud_sql_ipv4_cidr_block: The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block.
        :param pulumi.Input[str] connection_type: Mode of internal communication within the Composer environment. Must be one of "VPC_PEERING" or "PRIVATE_SERVICE_CONNECT".
        :param pulumi.Input[bool] enable_private_endpoint: If true, access to the public endpoint of the GKE cluster is denied. If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        :param pulumi.Input[bool] enable_privately_used_public_ips: When enabled, IPs from public (non-RFC1918) ranges can be used for ip_allocation_policy.cluster_ipv4_cidr_block and ip_allocation_policy.service_ipv4_cidr_block.
        :param pulumi.Input[str] master_ipv4_cidr_block: The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
        :param pulumi.Input[str] web_server_ipv4_cidr_block: The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        if cloud_composer_connection_subnetwork is not None:
            pulumi.set(__self__, "cloud_composer_connection_subnetwork", cloud_composer_connection_subnetwork)
        if cloud_composer_network_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cloud_composer_network_ipv4_cidr_block", cloud_composer_network_ipv4_cidr_block)
        if cloud_sql_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cloud_sql_ipv4_cidr_block", cloud_sql_ipv4_cidr_block)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if enable_private_endpoint is not None:
            pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        if enable_privately_used_public_ips is not None:
            pulumi.set(__self__, "enable_privately_used_public_ips", enable_privately_used_public_ips)
        if master_ipv4_cidr_block is not None:
            pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        if web_server_ipv4_cidr_block is not None:
            pulumi.set(__self__, "web_server_ipv4_cidr_block", web_server_ipv4_cidr_block)

    @property
    @pulumi.getter(name="cloudComposerConnectionSubnetwork")
    def cloud_composer_connection_subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "cloud_composer_connection_subnetwork")

    @cloud_composer_connection_subnetwork.setter
    def cloud_composer_connection_subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_composer_connection_subnetwork", value)

    @property
    @pulumi.getter(name="cloudComposerNetworkIpv4CidrBlock")
    def cloud_composer_network_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
        """
        return pulumi.get(self, "cloud_composer_network_ipv4_cidr_block")

    @cloud_composer_network_ipv4_cidr_block.setter
    def cloud_composer_network_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_composer_network_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="cloudSqlIpv4CidrBlock")
    def cloud_sql_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block.
        """
        return pulumi.get(self, "cloud_sql_ipv4_cidr_block")

    @cloud_sql_ipv4_cidr_block.setter
    def cloud_sql_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_sql_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Mode of internal communication within the Composer environment. Must be one of "VPC_PEERING" or "PRIVATE_SERVICE_CONNECT".
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, access to the public endpoint of the GKE cluster is denied. If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @enable_private_endpoint.setter
    def enable_private_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_endpoint", value)

    @property
    @pulumi.getter(name="enablePrivatelyUsedPublicIps")
    def enable_privately_used_public_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, IPs from public (non-RFC1918) ranges can be used for ip_allocation_policy.cluster_ipv4_cidr_block and ip_allocation_policy.service_ipv4_cidr_block.
        """
        return pulumi.get(self, "enable_privately_used_public_ips")

    @enable_privately_used_public_ips.setter
    def enable_privately_used_public_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_privately_used_public_ips", value)

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @master_ipv4_cidr_block.setter
    def master_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="webServerIpv4CidrBlock")
    def web_server_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
        """
        return pulumi.get(self, "web_server_ipv4_cidr_block")

    @web_server_ipv4_cidr_block.setter
    def web_server_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_server_ipv4_cidr_block", value)


if not MYPY:
    class EnvironmentConfigRecoveryConfigArgsDict(TypedDict):
        scheduled_snapshots_config: NotRequired[pulumi.Input['EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgsDict']]
        """
        The configuration settings for scheduled snapshots.
        """
elif False:
    EnvironmentConfigRecoveryConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigRecoveryConfigArgs:
    def __init__(__self__, *,
                 scheduled_snapshots_config: Optional[pulumi.Input['EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgs']] = None):
        """
        :param pulumi.Input['EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgs'] scheduled_snapshots_config: The configuration settings for scheduled snapshots.
        """
        if scheduled_snapshots_config is not None:
            pulumi.set(__self__, "scheduled_snapshots_config", scheduled_snapshots_config)

    @property
    @pulumi.getter(name="scheduledSnapshotsConfig")
    def scheduled_snapshots_config(self) -> Optional[pulumi.Input['EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgs']]:
        """
        The configuration settings for scheduled snapshots.
        """
        return pulumi.get(self, "scheduled_snapshots_config")

    @scheduled_snapshots_config.setter
    def scheduled_snapshots_config(self, value: Optional[pulumi.Input['EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgs']]):
        pulumi.set(self, "scheduled_snapshots_config", value)


if not MYPY:
    class EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        When enabled, Cloud Composer periodically saves snapshots of your environment to a Cloud Storage bucket.
        """
        snapshot_creation_schedule: NotRequired[pulumi.Input[str]]
        """
        Snapshot schedule, in the unix-cron format.
        """
        snapshot_location: NotRequired[pulumi.Input[str]]
        """
        the URI of a bucket folder where to save the snapshot.
        """
        time_zone: NotRequired[pulumi.Input[str]]
        """
        A time zone for the schedule. This value is a time offset and does not take into account daylight saving time changes. Valid values are from UTC-12 to UTC+12. Examples: UTC, UTC-01, UTC+03.
        """
elif False:
    EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigRecoveryConfigScheduledSnapshotsConfigArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 snapshot_creation_schedule: Optional[pulumi.Input[str]] = None,
                 snapshot_location: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: When enabled, Cloud Composer periodically saves snapshots of your environment to a Cloud Storage bucket.
        :param pulumi.Input[str] snapshot_creation_schedule: Snapshot schedule, in the unix-cron format.
        :param pulumi.Input[str] snapshot_location: the URI of a bucket folder where to save the snapshot.
        :param pulumi.Input[str] time_zone: A time zone for the schedule. This value is a time offset and does not take into account daylight saving time changes. Valid values are from UTC-12 to UTC+12. Examples: UTC, UTC-01, UTC+03.
        """
        pulumi.set(__self__, "enabled", enabled)
        if snapshot_creation_schedule is not None:
            pulumi.set(__self__, "snapshot_creation_schedule", snapshot_creation_schedule)
        if snapshot_location is not None:
            pulumi.set(__self__, "snapshot_location", snapshot_location)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        When enabled, Cloud Composer periodically saves snapshots of your environment to a Cloud Storage bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="snapshotCreationSchedule")
    def snapshot_creation_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Snapshot schedule, in the unix-cron format.
        """
        return pulumi.get(self, "snapshot_creation_schedule")

    @snapshot_creation_schedule.setter
    def snapshot_creation_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_creation_schedule", value)

    @property
    @pulumi.getter(name="snapshotLocation")
    def snapshot_location(self) -> Optional[pulumi.Input[str]]:
        """
        the URI of a bucket folder where to save the snapshot.
        """
        return pulumi.get(self, "snapshot_location")

    @snapshot_location.setter
    def snapshot_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_location", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        A time zone for the schedule. This value is a time offset and does not take into account daylight saving time changes. Valid values are from UTC-12 to UTC+12. Examples: UTC, UTC-01, UTC+03.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


if not MYPY:
    class EnvironmentConfigSoftwareConfigArgsDict(TypedDict):
        airflow_config_overrides: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
        """
        cloud_data_lineage_integration: NotRequired[pulumi.Input['EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgsDict']]
        """
        The configuration for Cloud Data Lineage integration. Supported for Cloud Composer environments in versions composer-2.1.2-airflow-*.*.* and newer
        """
        env_variables: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
        """
        image_version: NotRequired[pulumi.Input[str]]
        """
        The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-([0-9]+(\\.[0-9]+\\.[0-9]+(-preview\\.[0-9]+)?)?|latest)-airflow-([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?). The Cloud Composer portion of the image version is a full semantic version, or an alias in the form of major version number or 'latest'. The Apache Airflow portion of the image version is a full semantic version that points to one of the supported Apache Airflow versions, or an alias in the form of only major or major.minor versions specified. See documentation for more details and version list.
        """
        pypi_packages: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
        """
        python_version: NotRequired[pulumi.Input[str]]
        """
        The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        """
        scheduler_count: NotRequired[pulumi.Input[int]]
        """
        The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        """
        web_server_plugins_mode: NotRequired[pulumi.Input[str]]
        """
        Should be either 'ENABLED' or 'DISABLED'. Defaults to 'ENABLED'. Used in Composer 3.
        """
elif False:
    EnvironmentConfigSoftwareConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigSoftwareConfigArgs:
    def __init__(__self__, *,
                 airflow_config_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cloud_data_lineage_integration: Optional[pulumi.Input['EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgs']] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 pypi_packages: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_version: Optional[pulumi.Input[str]] = None,
                 scheduler_count: Optional[pulumi.Input[int]] = None,
                 web_server_plugins_mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] airflow_config_overrides: Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
        :param pulumi.Input['EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgs'] cloud_data_lineage_integration: The configuration for Cloud Data Lineage integration. Supported for Cloud Composer environments in versions composer-2.1.2-airflow-*.*.* and newer
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_variables: Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
        :param pulumi.Input[str] image_version: The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-([0-9]+(\\.[0-9]+\\.[0-9]+(-preview\\.[0-9]+)?)?|latest)-airflow-([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?). The Cloud Composer portion of the image version is a full semantic version, or an alias in the form of major version number or 'latest'. The Apache Airflow portion of the image version is a full semantic version that points to one of the supported Apache Airflow versions, or an alias in the form of only major or major.minor versions specified. See documentation for more details and version list.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pypi_packages: Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
        :param pulumi.Input[str] python_version: The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        :param pulumi.Input[int] scheduler_count: The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        :param pulumi.Input[str] web_server_plugins_mode: Should be either 'ENABLED' or 'DISABLED'. Defaults to 'ENABLED'. Used in Composer 3.
        """
        if airflow_config_overrides is not None:
            pulumi.set(__self__, "airflow_config_overrides", airflow_config_overrides)
        if cloud_data_lineage_integration is not None:
            pulumi.set(__self__, "cloud_data_lineage_integration", cloud_data_lineage_integration)
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if pypi_packages is not None:
            pulumi.set(__self__, "pypi_packages", pypi_packages)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)
        if scheduler_count is not None:
            pulumi.set(__self__, "scheduler_count", scheduler_count)
        if web_server_plugins_mode is not None:
            pulumi.set(__self__, "web_server_plugins_mode", web_server_plugins_mode)

    @property
    @pulumi.getter(name="airflowConfigOverrides")
    def airflow_config_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
        """
        return pulumi.get(self, "airflow_config_overrides")

    @airflow_config_overrides.setter
    def airflow_config_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "airflow_config_overrides", value)

    @property
    @pulumi.getter(name="cloudDataLineageIntegration")
    def cloud_data_lineage_integration(self) -> Optional[pulumi.Input['EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgs']]:
        """
        The configuration for Cloud Data Lineage integration. Supported for Cloud Composer environments in versions composer-2.1.2-airflow-*.*.* and newer
        """
        return pulumi.get(self, "cloud_data_lineage_integration")

    @cloud_data_lineage_integration.setter
    def cloud_data_lineage_integration(self, value: Optional[pulumi.Input['EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgs']]):
        pulumi.set(self, "cloud_data_lineage_integration", value)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
        """
        return pulumi.get(self, "env_variables")

    @env_variables.setter
    def env_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env_variables", value)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-([0-9]+(\\.[0-9]+\\.[0-9]+(-preview\\.[0-9]+)?)?|latest)-airflow-([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?). The Cloud Composer portion of the image version is a full semantic version, or an alias in the form of major version number or 'latest'. The Apache Airflow portion of the image version is a full semantic version that points to one of the supported Apache Airflow versions, or an alias in the form of only major or major.minor versions specified. See documentation for more details and version list.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="pypiPackages")
    def pypi_packages(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
        """
        return pulumi.get(self, "pypi_packages")

    @pypi_packages.setter
    def pypi_packages(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pypi_packages", value)

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[pulumi.Input[str]]:
        """
        The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
        """
        return pulumi.get(self, "python_version")

    @python_version.setter
    def python_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "python_version", value)

    @property
    @pulumi.getter(name="schedulerCount")
    def scheduler_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
        """
        return pulumi.get(self, "scheduler_count")

    @scheduler_count.setter
    def scheduler_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scheduler_count", value)

    @property
    @pulumi.getter(name="webServerPluginsMode")
    def web_server_plugins_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Should be either 'ENABLED' or 'DISABLED'. Defaults to 'ENABLED'. Used in Composer 3.
        """
        return pulumi.get(self, "web_server_plugins_mode")

    @web_server_plugins_mode.setter
    def web_server_plugins_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_server_plugins_mode", value)


if not MYPY:
    class EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgsDict(TypedDict):
        enabled: pulumi.Input[bool]
        """
        Whether or not Cloud Data Lineage integration is enabled.
        """
elif False:
    EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigSoftwareConfigCloudDataLineageIntegrationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: Whether or not Cloud Data Lineage integration is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether or not Cloud Data Lineage integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class EnvironmentConfigWebServerConfigArgsDict(TypedDict):
        machine_type: pulumi.Input[str]
        """
        Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
elif False:
    EnvironmentConfigWebServerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWebServerConfigArgs:
    def __init__(__self__, *,
                 machine_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] machine_type: Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[str]:
        """
        Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_type", value)


if not MYPY:
    class EnvironmentConfigWebServerNetworkAccessControlArgsDict(TypedDict):
        allowed_ip_ranges: NotRequired[pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgsDict']]]]
        """
        A collection of allowed IP ranges with descriptions.
        """
elif False:
    EnvironmentConfigWebServerNetworkAccessControlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWebServerNetworkAccessControlArgs:
    def __init__(__self__, *,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgs']]] allowed_ip_ranges: A collection of allowed IP ranges with descriptions.
        """
        if allowed_ip_ranges is not None:
            pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)

    @property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgs']]]]:
        """
        A collection of allowed IP ranges with descriptions.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @allowed_ip_ranges.setter
    def allowed_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgs']]]]):
        pulumi.set(self, "allowed_ip_ranges", value)


if not MYPY:
    class EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgsDict(TypedDict):
        value: pulumi.Input[str]
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. IP range prefixes should be properly truncated. For example, 1.2.3.4/24 should be truncated to 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 should be truncated to 2001:db8::/32.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        A description of this ip range.
        """
elif False:
    EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. IP range prefixes should be properly truncated. For example, 1.2.3.4/24 should be truncated to 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 should be truncated to 2001:db8::/32.
        :param pulumi.Input[str] description: A description of this ip range.
        """
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. IP range prefixes should be properly truncated. For example, 1.2.3.4/24 should be truncated to 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 should be truncated to 2001:db8::/32.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of this ip range.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class EnvironmentConfigWorkloadsConfigArgsDict(TypedDict):
        dag_processor: NotRequired[pulumi.Input['EnvironmentConfigWorkloadsConfigDagProcessorArgsDict']]
        """
        Configuration for resources used by DAG processor.
        """
        scheduler: NotRequired[pulumi.Input['EnvironmentConfigWorkloadsConfigSchedulerArgsDict']]
        """
        Configuration for resources used by Airflow schedulers.
        """
        triggerer: NotRequired[pulumi.Input['EnvironmentConfigWorkloadsConfigTriggererArgsDict']]
        """
        Configuration for resources used by Airflow triggerers.
        """
        web_server: NotRequired[pulumi.Input['EnvironmentConfigWorkloadsConfigWebServerArgsDict']]
        """
        Configuration for resources used by Airflow web server.
        """
        worker: NotRequired[pulumi.Input['EnvironmentConfigWorkloadsConfigWorkerArgsDict']]
        """
        Configuration for resources used by Airflow workers.
        """
elif False:
    EnvironmentConfigWorkloadsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWorkloadsConfigArgs:
    def __init__(__self__, *,
                 dag_processor: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigDagProcessorArgs']] = None,
                 scheduler: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigSchedulerArgs']] = None,
                 triggerer: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigTriggererArgs']] = None,
                 web_server: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigWebServerArgs']] = None,
                 worker: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigWorkerArgs']] = None):
        """
        :param pulumi.Input['EnvironmentConfigWorkloadsConfigDagProcessorArgs'] dag_processor: Configuration for resources used by DAG processor.
        :param pulumi.Input['EnvironmentConfigWorkloadsConfigSchedulerArgs'] scheduler: Configuration for resources used by Airflow schedulers.
        :param pulumi.Input['EnvironmentConfigWorkloadsConfigTriggererArgs'] triggerer: Configuration for resources used by Airflow triggerers.
        :param pulumi.Input['EnvironmentConfigWorkloadsConfigWebServerArgs'] web_server: Configuration for resources used by Airflow web server.
        :param pulumi.Input['EnvironmentConfigWorkloadsConfigWorkerArgs'] worker: Configuration for resources used by Airflow workers.
        """
        if dag_processor is not None:
            pulumi.set(__self__, "dag_processor", dag_processor)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if triggerer is not None:
            pulumi.set(__self__, "triggerer", triggerer)
        if web_server is not None:
            pulumi.set(__self__, "web_server", web_server)
        if worker is not None:
            pulumi.set(__self__, "worker", worker)

    @property
    @pulumi.getter(name="dagProcessor")
    def dag_processor(self) -> Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigDagProcessorArgs']]:
        """
        Configuration for resources used by DAG processor.
        """
        return pulumi.get(self, "dag_processor")

    @dag_processor.setter
    def dag_processor(self, value: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigDagProcessorArgs']]):
        pulumi.set(self, "dag_processor", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigSchedulerArgs']]:
        """
        Configuration for resources used by Airflow schedulers.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigSchedulerArgs']]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter
    def triggerer(self) -> Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigTriggererArgs']]:
        """
        Configuration for resources used by Airflow triggerers.
        """
        return pulumi.get(self, "triggerer")

    @triggerer.setter
    def triggerer(self, value: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigTriggererArgs']]):
        pulumi.set(self, "triggerer", value)

    @property
    @pulumi.getter(name="webServer")
    def web_server(self) -> Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigWebServerArgs']]:
        """
        Configuration for resources used by Airflow web server.
        """
        return pulumi.get(self, "web_server")

    @web_server.setter
    def web_server(self, value: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigWebServerArgs']]):
        pulumi.set(self, "web_server", value)

    @property
    @pulumi.getter
    def worker(self) -> Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigWorkerArgs']]:
        """
        Configuration for resources used by Airflow workers.
        """
        return pulumi.get(self, "worker")

    @worker.setter
    def worker(self, value: Optional[pulumi.Input['EnvironmentConfigWorkloadsConfigWorkerArgs']]):
        pulumi.set(self, "worker", value)


if not MYPY:
    class EnvironmentConfigWorkloadsConfigDagProcessorArgsDict(TypedDict):
        count: NotRequired[pulumi.Input[int]]
        """
        Number of DAG processors.
        """
        cpu: NotRequired[pulumi.Input[float]]
        """
        CPU request and limit for DAG processor.
        """
        memory_gb: NotRequired[pulumi.Input[float]]
        """
        Memory (GB) request and limit for DAG processor.
        """
        storage_gb: NotRequired[pulumi.Input[float]]
        """
        Storage (GB) request and limit for DAG processor.
        """
elif False:
    EnvironmentConfigWorkloadsConfigDagProcessorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWorkloadsConfigDagProcessorArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 memory_gb: Optional[pulumi.Input[float]] = None,
                 storage_gb: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[int] count: Number of DAG processors.
        :param pulumi.Input[float] cpu: CPU request and limit for DAG processor.
        :param pulumi.Input[float] memory_gb: Memory (GB) request and limit for DAG processor.
        :param pulumi.Input[float] storage_gb: Storage (GB) request and limit for DAG processor.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of DAG processors.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        CPU request and limit for DAG processor.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Memory (GB) request and limit for DAG processor.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Storage (GB) request and limit for DAG processor.
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_gb", value)


if not MYPY:
    class EnvironmentConfigWorkloadsConfigSchedulerArgsDict(TypedDict):
        count: NotRequired[pulumi.Input[int]]
        """
        The number of schedulers.
        """
        cpu: NotRequired[pulumi.Input[float]]
        """
        CPU request and limit for a single Airflow scheduler replica
        """
        memory_gb: NotRequired[pulumi.Input[float]]
        """
        Memory (GB) request and limit for a single Airflow scheduler replica.
        """
        storage_gb: NotRequired[pulumi.Input[float]]
        """
        Storage (GB) request and limit for a single Airflow scheduler replica.
        """
elif False:
    EnvironmentConfigWorkloadsConfigSchedulerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWorkloadsConfigSchedulerArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 memory_gb: Optional[pulumi.Input[float]] = None,
                 storage_gb: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[int] count: The number of schedulers.
        :param pulumi.Input[float] cpu: CPU request and limit for a single Airflow scheduler replica
        :param pulumi.Input[float] memory_gb: Memory (GB) request and limit for a single Airflow scheduler replica.
        :param pulumi.Input[float] storage_gb: Storage (GB) request and limit for a single Airflow scheduler replica.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of schedulers.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        CPU request and limit for a single Airflow scheduler replica
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Memory (GB) request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Storage (GB) request and limit for a single Airflow scheduler replica.
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_gb", value)


if not MYPY:
    class EnvironmentConfigWorkloadsConfigTriggererArgsDict(TypedDict):
        count: pulumi.Input[int]
        """
        The number of triggerers.
        """
        cpu: pulumi.Input[float]
        """
        CPU request and limit for a single Airflow triggerer replica.
        """
        memory_gb: pulumi.Input[float]
        """
        Memory (GB) request and limit for a single Airflow triggerer replica.
        """
elif False:
    EnvironmentConfigWorkloadsConfigTriggererArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWorkloadsConfigTriggererArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[int],
                 cpu: pulumi.Input[float],
                 memory_gb: pulumi.Input[float]):
        """
        :param pulumi.Input[int] count: The number of triggerers.
        :param pulumi.Input[float] cpu: CPU request and limit for a single Airflow triggerer replica.
        :param pulumi.Input[float] memory_gb: Memory (GB) request and limit for a single Airflow triggerer replica.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory_gb", memory_gb)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[int]:
        """
        The number of triggerers.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Input[float]:
        """
        CPU request and limit for a single Airflow triggerer replica.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: pulumi.Input[float]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> pulumi.Input[float]:
        """
        Memory (GB) request and limit for a single Airflow triggerer replica.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: pulumi.Input[float]):
        pulumi.set(self, "memory_gb", value)


if not MYPY:
    class EnvironmentConfigWorkloadsConfigWebServerArgsDict(TypedDict):
        cpu: NotRequired[pulumi.Input[float]]
        """
        CPU request and limit for Airflow web server.
        """
        memory_gb: NotRequired[pulumi.Input[float]]
        """
        Memory (GB) request and limit for Airflow web server.
        """
        storage_gb: NotRequired[pulumi.Input[float]]
        """
        Storage (GB) request and limit for Airflow web server.
        """
elif False:
    EnvironmentConfigWorkloadsConfigWebServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWorkloadsConfigWebServerArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 memory_gb: Optional[pulumi.Input[float]] = None,
                 storage_gb: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] cpu: CPU request and limit for Airflow web server.
        :param pulumi.Input[float] memory_gb: Memory (GB) request and limit for Airflow web server.
        :param pulumi.Input[float] storage_gb: Storage (GB) request and limit for Airflow web server.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        CPU request and limit for Airflow web server.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Memory (GB) request and limit for Airflow web server.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Storage (GB) request and limit for Airflow web server.
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_gb", value)


if not MYPY:
    class EnvironmentConfigWorkloadsConfigWorkerArgsDict(TypedDict):
        cpu: NotRequired[pulumi.Input[float]]
        """
        CPU request and limit for a single Airflow worker replica.
        """
        max_count: NotRequired[pulumi.Input[int]]
        """
        Maximum number of workers for autoscaling.
        """
        memory_gb: NotRequired[pulumi.Input[float]]
        """
        Memory (GB) request and limit for a single Airflow worker replica.
        """
        min_count: NotRequired[pulumi.Input[int]]
        """
        Minimum number of workers for autoscaling.
        """
        storage_gb: NotRequired[pulumi.Input[float]]
        """
        Storage (GB) request and limit for a single Airflow worker replica.
        """
elif False:
    EnvironmentConfigWorkloadsConfigWorkerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentConfigWorkloadsConfigWorkerArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 memory_gb: Optional[pulumi.Input[float]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 storage_gb: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] cpu: CPU request and limit for a single Airflow worker replica.
        :param pulumi.Input[int] max_count: Maximum number of workers for autoscaling.
        :param pulumi.Input[float] memory_gb: Memory (GB) request and limit for a single Airflow worker replica.
        :param pulumi.Input[int] min_count: Minimum number of workers for autoscaling.
        :param pulumi.Input[float] storage_gb: Storage (GB) request and limit for a single Airflow worker replica.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if storage_gb is not None:
            pulumi.set(__self__, "storage_gb", storage_gb)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        CPU request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of workers for autoscaling.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Memory (GB) request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "memory_gb")

    @memory_gb.setter
    def memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_gb", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of workers for autoscaling.
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter(name="storageGb")
    def storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        Storage (GB) request and limit for a single Airflow worker replica.
        """
        return pulumi.get(self, "storage_gb")

    @storage_gb.setter
    def storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_gb", value)


if not MYPY:
    class EnvironmentStorageConfigArgsDict(TypedDict):
        bucket: pulumi.Input[str]
        """
        Optional. Name of an existing Cloud Storage bucket to be used by the environment.
        """
elif False:
    EnvironmentStorageConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentStorageConfigArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str]):
        """
        :param pulumi.Input[str] bucket: Optional. Name of an existing Cloud Storage bucket to be used by the environment.
        """
        pulumi.set(__self__, "bucket", bucket)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Optional. Name of an existing Cloud Storage bucket to be used by the environment.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)


