# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUserWorkloadsConfigMapResult',
    'AwaitableGetUserWorkloadsConfigMapResult',
    'get_user_workloads_config_map',
    'get_user_workloads_config_map_output',
]

@pulumi.output_type
class GetUserWorkloadsConfigMapResult:
    """
    A collection of values returned by getUserWorkloadsConfigMap.
    """
    def __init__(__self__, data=None, environment=None, id=None, name=None, project=None, region=None):
        if data and not isinstance(data, dict):
            raise TypeError("Expected argument 'data' to be a dict")
        pulumi.set(__self__, "data", data)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def data(self) -> Mapping[str, str]:
        """
        The "data" field of Kubernetes ConfigMap, organized in key-value pairs.
        For details see: https://kubernetes.io/docs/concepts/configuration/configmap/
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def environment(self) -> str:
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


class AwaitableGetUserWorkloadsConfigMapResult(GetUserWorkloadsConfigMapResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserWorkloadsConfigMapResult(
            data=self.data,
            environment=self.environment,
            id=self.id,
            name=self.name,
            project=self.project,
            region=self.region)


def get_user_workloads_config_map(environment: Optional[str] = None,
                                  name: Optional[str] = None,
                                  project: Optional[str] = None,
                                  region: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserWorkloadsConfigMapResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example_environment = gcp.composer.Environment("example",
        name="example-environment",
        config={
            "software_config": {
                "image_version": "composer-3-airflow-2",
            },
        })
    example_user_workloads_config_map = gcp.composer.UserWorkloadsConfigMap("example",
        environment=example_environment.name,
        name="example-config-map",
        data={
            "db_host": "dbhost:5432",
            "api_host": "apihost:443",
        })
    example = example_environment.name.apply(lambda name: gcp.composer.get_user_workloads_config_map_output(environment=name,
        name=google_composer_user_workloads_config_map["example"]["name"]))
    pulumi.export("debug", example)
    ```


    :param str environment: Environment where the ConfigMap is stored.
    :param str name: Name of the ConfigMap.
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param str region: The location or Compute Engine region of the environment.
    """
    __args__ = dict()
    __args__['environment'] = environment
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:composer/getUserWorkloadsConfigMap:getUserWorkloadsConfigMap', __args__, opts=opts, typ=GetUserWorkloadsConfigMapResult).value

    return AwaitableGetUserWorkloadsConfigMapResult(
        data=pulumi.get(__ret__, 'data'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'))


@_utilities.lift_output_func(get_user_workloads_config_map)
def get_user_workloads_config_map_output(environment: Optional[pulumi.Input[str]] = None,
                                         name: Optional[pulumi.Input[str]] = None,
                                         project: Optional[pulumi.Input[Optional[str]]] = None,
                                         region: Optional[pulumi.Input[Optional[str]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserWorkloadsConfigMapResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example_environment = gcp.composer.Environment("example",
        name="example-environment",
        config={
            "software_config": {
                "image_version": "composer-3-airflow-2",
            },
        })
    example_user_workloads_config_map = gcp.composer.UserWorkloadsConfigMap("example",
        environment=example_environment.name,
        name="example-config-map",
        data={
            "db_host": "dbhost:5432",
            "api_host": "apihost:443",
        })
    example = example_environment.name.apply(lambda name: gcp.composer.get_user_workloads_config_map_output(environment=name,
        name=google_composer_user_workloads_config_map["example"]["name"]))
    pulumi.export("debug", example)
    ```


    :param str environment: Environment where the ConfigMap is stored.
    :param str name: Name of the ConfigMap.
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param str region: The location or Compute Engine region of the environment.
    """
    ...
