# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUserWorkloadsSecretResult',
    'AwaitableGetUserWorkloadsSecretResult',
    'get_user_workloads_secret',
    'get_user_workloads_secret_output',
]

@pulumi.output_type
class GetUserWorkloadsSecretResult:
    """
    A collection of values returned by getUserWorkloadsSecret.
    """
    def __init__(__self__, data=None, environment=None, id=None, name=None, project=None, region=None):
        if data and not isinstance(data, dict):
            raise TypeError("Expected argument 'data' to be a dict")
        pulumi.set(__self__, "data", data)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def data(self) -> Mapping[str, str]:
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def environment(self) -> str:
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


class AwaitableGetUserWorkloadsSecretResult(GetUserWorkloadsSecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserWorkloadsSecretResult(
            data=self.data,
            environment=self.environment,
            id=self.id,
            name=self.name,
            project=self.project,
            region=self.region)


def get_user_workloads_secret(environment: Optional[str] = None,
                              name: Optional[str] = None,
                              project: Optional[str] = None,
                              region: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserWorkloadsSecretResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    example_environment = gcp.composer.Environment("example",
        name="example-environment",
        config={
            "software_config": {
                "image_version": "composer-3-airflow-2",
            },
        })
    example_user_workloads_secret = gcp.composer.UserWorkloadsSecret("example",
        environment=example_environment.name,
        name="example-secret",
        data={
            "username": std.base64encode(input="username").result,
            "password": std.base64encode(input="password").result,
        })
    example = example_environment.name.apply(lambda name: gcp.composer.get_user_workloads_secret_output(environment=name,
        name=google_composer_user_workloads_secret["example"]["name"]))
    pulumi.export("debug", example)
    ```


    :param str environment: Environment where the Secret is stored.
    :param str name: Name of the Secret.
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param str region: The location or Compute Engine region of the environment.
    """
    __args__ = dict()
    __args__['environment'] = environment
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:composer/getUserWorkloadsSecret:getUserWorkloadsSecret', __args__, opts=opts, typ=GetUserWorkloadsSecretResult).value

    return AwaitableGetUserWorkloadsSecretResult(
        data=pulumi.get(__ret__, 'data'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'))


@_utilities.lift_output_func(get_user_workloads_secret)
def get_user_workloads_secret_output(environment: Optional[pulumi.Input[str]] = None,
                                     name: Optional[pulumi.Input[str]] = None,
                                     project: Optional[pulumi.Input[Optional[str]]] = None,
                                     region: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserWorkloadsSecretResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_std as std

    example_environment = gcp.composer.Environment("example",
        name="example-environment",
        config={
            "software_config": {
                "image_version": "composer-3-airflow-2",
            },
        })
    example_user_workloads_secret = gcp.composer.UserWorkloadsSecret("example",
        environment=example_environment.name,
        name="example-secret",
        data={
            "username": std.base64encode(input="username").result,
            "password": std.base64encode(input="password").result,
        })
    example = example_environment.name.apply(lambda name: gcp.composer.get_user_workloads_secret_output(environment=name,
        name=google_composer_user_workloads_secret["example"]["name"]))
    pulumi.export("debug", example)
    ```


    :param str environment: Environment where the Secret is stored.
    :param str name: Name of the Secret.
    :param str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param str region: The location or Compute Engine region of the environment.
    """
    ...
