# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DiskArgs', 'Disk']

@pulumi.input_type
class DiskArgs:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 async_primary_disk: Optional[pulumi.Input['DiskAsyncPrimaryDiskArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key: Optional[pulumi.Input['DiskDiskEncryptionKeyArgs']] = None,
                 enable_confidential_compute: Optional[pulumi.Input[bool]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input['DiskGuestOsFeatureArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multi_writer: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 physical_block_size_bytes: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 provisioned_iops: Optional[pulumi.Input[int]] = None,
                 provisioned_throughput: Optional[pulumi.Input[int]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot: Optional[pulumi.Input[str]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input['DiskSourceImageEncryptionKeyArgs']] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input['DiskSourceSnapshotEncryptionKeyArgs']] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Disk resource.
        :param pulumi.Input[str] access_mode: The accessMode of the disk.
               For example:
               * READ_WRITE_SINGLE
               * READ_WRITE_MANY
               * READ_ONLY_SINGLE
        :param pulumi.Input['DiskAsyncPrimaryDiskArgs'] async_primary_disk: A nested object resource
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input['DiskDiskEncryptionKeyArgs'] disk_encryption_key: Encrypts the disk using a customer-supplied encryption key.
               After you encrypt a disk with a customer-supplied key, you must
               provide the same key if you use the disk later (e.g. to create a disk
               snapshot or an image, or to attach the disk to a virtual machine).
               Customer-supplied encryption keys do not protect access to metadata of
               the disk.
               If you do not provide an encryption key when creating the disk, then
               the disk will be encrypted using an automatically generated key and
               you do not need to provide a key to use the disk later.
               Structure is documented below.
        :param pulumi.Input[bool] enable_confidential_compute: Whether this disk is using confidential compute mode.
               Note: Only supported on hyperdisk skus, disk_encryption_key is required when setting to true
        :param pulumi.Input[Sequence[pulumi.Input['DiskGuestOsFeatureArgs']]] guest_os_features: A list of features to enable on the guest operating system.
               Applicable only for bootable disks.
               Structure is documented below.
        :param pulumi.Input[str] image: The image from which to initialize this disk. This can be
               one of: the image's `self_link`, `projects/{project}/global/images/{image}`,
               `projects/{project}/global/images/family/{family}`, `global/images/{image}`,
               `global/images/family/{family}`, `family/{family}`, `{project}/{family}`,
               `{project}/{image}`, `{family}`, or `{image}`. If referred by family, the
               images names must include the family name. If they don't, use the
               [compute.Image data source](https://www.terraform.io/docs/providers/google/d/compute_image.html).
               For instance, the image `centos-6-v20180104` includes its family name `centos-6`.
               These images can be referred by family name here.
        :param pulumi.Input[str] interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
               
               > **Warning:** `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this disk.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] licenses: Any applicable license URI.
        :param pulumi.Input[bool] multi_writer: Indicates whether or not the disk can be read/write attached to more than one instance.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[int] physical_block_size_bytes: Physical block size of the persistent disk, in bytes. If not present
               in a request, a default value is used. Currently supported sizes
               are 4096 and 16384, other sizes may be added in the future.
               If an unsupported value is requested, the error message will list
               the supported values for the caller's project.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] provisioned_iops: Indicates how many IOPS must be provisioned for the disk.
               Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
               allows for an update of IOPS every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        :param pulumi.Input[int] provisioned_throughput: Indicates how much Throughput must be provisioned for the disk.
               Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
               allows for an update of Throughput every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies applied to this disk for automatic snapshot creations.
               ~>**NOTE** This value does not support updating the
               resource policy, as resource policies can not be updated more than
               one at a time. Use
               `compute.DiskResourcePolicyAttachment`
               to allow for updating the resource policy attached to the disk.
        :param pulumi.Input[int] size: Size of the persistent disk, specified in GB. You can specify this
               field when creating a persistent disk using the `image` or
               `snapshot` parameter, or specify it alone to create an empty
               persistent disk.
               If you specify this field along with `image` or `snapshot`,
               the value must not be less than the size of the image
               or the size of the snapshot.
               ~>**NOTE** If you change the size, the provider updates the disk size
               if upsizing is detected but recreates the disk if downsizing is requested.
               You can add `lifecycle.prevent_destroy` in the config to prevent destroying
               and recreating.
        :param pulumi.Input[str] snapshot: The source snapshot used to create this disk. You can provide this as
               a partial or full URL to the resource. If the snapshot is in another
               project than this disk, you must supply a full URL. For example, the
               following are valid values:
               * `https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot`
               * `projects/project/global/snapshots/snapshot`
               * `global/snapshots/snapshot`
        :param pulumi.Input[str] source_disk: The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
               For example, the following are valid values:
               * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
               * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
               * projects/{project}/zones/{zone}/disks/{disk}
               * projects/{project}/regions/{region}/disks/{disk}
               * zones/{zone}/disks/{disk}
               * regions/{region}/disks/{disk}
        :param pulumi.Input['DiskSourceImageEncryptionKeyArgs'] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if
               the source image is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input['DiskSourceSnapshotEncryptionKeyArgs'] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required
               if the source snapshot is protected by a customer-supplied encryption
               key.
               Structure is documented below.
        :param pulumi.Input[str] storage_pool: The URL of the storage pool in which the new disk is created.
               For example:
               * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}
               * /projects/{project}/zones/{zone}/storagePools/{storagePool}
        :param pulumi.Input[str] type: URL of the disk type resource describing which disk type to use to
               create the disk. Provide this when creating the disk.
        :param pulumi.Input[str] zone: A reference to the zone where the disk resides.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if async_primary_disk is not None:
            pulumi.set(__self__, "async_primary_disk", async_primary_disk)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if enable_confidential_compute is not None:
            pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)
        if guest_os_features is not None:
            pulumi.set(__self__, "guest_os_features", guest_os_features)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if interface is not None:
            warnings.warn("""`interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.""", DeprecationWarning)
            pulumi.log.warn("""interface is deprecated: `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.""")
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if licenses is not None:
            pulumi.set(__self__, "licenses", licenses)
        if multi_writer is not None:
            pulumi.set(__self__, "multi_writer", multi_writer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if physical_block_size_bytes is not None:
            pulumi.set(__self__, "physical_block_size_bytes", physical_block_size_bytes)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if provisioned_iops is not None:
            pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_image_encryption_key is not None:
            pulumi.set(__self__, "source_image_encryption_key", source_image_encryption_key)
        if source_snapshot_encryption_key is not None:
            pulumi.set(__self__, "source_snapshot_encryption_key", source_snapshot_encryption_key)
        if storage_pool is not None:
            pulumi.set(__self__, "storage_pool", storage_pool)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The accessMode of the disk.
        For example:
        * READ_WRITE_SINGLE
        * READ_WRITE_MANY
        * READ_ONLY_SINGLE
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="asyncPrimaryDisk")
    def async_primary_disk(self) -> Optional[pulumi.Input['DiskAsyncPrimaryDiskArgs']]:
        """
        A nested object resource
        Structure is documented below.
        """
        return pulumi.get(self, "async_primary_disk")

    @async_primary_disk.setter
    def async_primary_disk(self, value: Optional[pulumi.Input['DiskAsyncPrimaryDiskArgs']]):
        pulumi.set(self, "async_primary_disk", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional[pulumi.Input['DiskDiskEncryptionKeyArgs']]:
        """
        Encrypts the disk using a customer-supplied encryption key.
        After you encrypt a disk with a customer-supplied key, you must
        provide the same key if you use the disk later (e.g. to create a disk
        snapshot or an image, or to attach the disk to a virtual machine).
        Customer-supplied encryption keys do not protect access to metadata of
        the disk.
        If you do not provide an encryption key when creating the disk, then
        the disk will be encrypted using an automatically generated key and
        you do not need to provide a key to use the disk later.
        Structure is documented below.
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: Optional[pulumi.Input['DiskDiskEncryptionKeyArgs']]):
        pulumi.set(self, "disk_encryption_key", value)

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this disk is using confidential compute mode.
        Note: Only supported on hyperdisk skus, disk_encryption_key is required when setting to true
        """
        return pulumi.get(self, "enable_confidential_compute")

    @enable_confidential_compute.setter
    def enable_confidential_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_confidential_compute", value)

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskGuestOsFeatureArgs']]]]:
        """
        A list of features to enable on the guest operating system.
        Applicable only for bootable disks.
        Structure is documented below.
        """
        return pulumi.get(self, "guest_os_features")

    @guest_os_features.setter
    def guest_os_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskGuestOsFeatureArgs']]]]):
        pulumi.set(self, "guest_os_features", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The image from which to initialize this disk. This can be
        one of: the image's `self_link`, `projects/{project}/global/images/{image}`,
        `projects/{project}/global/images/family/{family}`, `global/images/{image}`,
        `global/images/family/{family}`, `family/{family}`, `{project}/{family}`,
        `{project}/{image}`, `{family}`, or `{image}`. If referred by family, the
        images names must include the family name. If they don't, use the
        [compute.Image data source](https://www.terraform.io/docs/providers/google/d/compute_image.html).
        For instance, the image `centos-6-v20180104` includes its family name `centos-6`.
        These images can be referred by family name here.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.""")
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.

        > **Warning:** `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this disk.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Any applicable license URI.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "licenses", value)

    @property
    @pulumi.getter(name="multiWriter")
    def multi_writer(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not the disk can be read/write attached to more than one instance.
        """
        return pulumi.get(self, "multi_writer")

    @multi_writer.setter
    def multi_writer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_writer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="physicalBlockSizeBytes")
    def physical_block_size_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        Physical block size of the persistent disk, in bytes. If not present
        in a request, a default value is used. Currently supported sizes
        are 4096 and 16384, other sizes may be added in the future.
        If an unsupported value is requested, the error message will list
        the supported values for the caller's project.
        """
        return pulumi.get(self, "physical_block_size_bytes")

    @physical_block_size_bytes.setter
    def physical_block_size_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "physical_block_size_bytes", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates how many IOPS must be provisioned for the disk.
        Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
        allows for an update of IOPS every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        """
        return pulumi.get(self, "provisioned_iops")

    @provisioned_iops.setter
    def provisioned_iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_iops", value)

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates how much Throughput must be provisioned for the disk.
        Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
        allows for an update of Throughput every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        """
        return pulumi.get(self, "provisioned_throughput")

    @provisioned_throughput.setter
    def provisioned_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_throughput", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource policies applied to this disk for automatic snapshot creations.
        ~>**NOTE** This value does not support updating the
        resource policy, as resource policies can not be updated more than
        one at a time. Use
        `compute.DiskResourcePolicyAttachment`
        to allow for updating the resource policy attached to the disk.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the persistent disk, specified in GB. You can specify this
        field when creating a persistent disk using the `image` or
        `snapshot` parameter, or specify it alone to create an empty
        persistent disk.
        If you specify this field along with `image` or `snapshot`,
        the value must not be less than the size of the image
        or the size of the snapshot.
        ~>**NOTE** If you change the size, the provider updates the disk size
        if upsizing is detected but recreates the disk if downsizing is requested.
        You can add `lifecycle.prevent_destroy` in the config to prevent destroying
        and recreating.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        The source snapshot used to create this disk. You can provide this as
        a partial or full URL to the resource. If the snapshot is in another
        project than this disk, you must supply a full URL. For example, the
        following are valid values:
        * `https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot`
        * `projects/project/global/snapshots/snapshot`
        * `global/snapshots/snapshot`
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[str]]:
        """
        The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
        For example, the following are valid values:
        * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
        * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
        * projects/{project}/zones/{zone}/disks/{disk}
        * projects/{project}/regions/{region}/disks/{disk}
        * zones/{zone}/disks/{disk}
        * regions/{region}/disks/{disk}
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk", value)

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> Optional[pulumi.Input['DiskSourceImageEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source image. Required if
        the source image is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @source_image_encryption_key.setter
    def source_image_encryption_key(self, value: Optional[pulumi.Input['DiskSourceImageEncryptionKeyArgs']]):
        pulumi.set(self, "source_image_encryption_key", value)

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> Optional[pulumi.Input['DiskSourceSnapshotEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source snapshot. Required
        if the source snapshot is protected by a customer-supplied encryption
        key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @source_snapshot_encryption_key.setter
    def source_snapshot_encryption_key(self, value: Optional[pulumi.Input['DiskSourceSnapshotEncryptionKeyArgs']]):
        pulumi.set(self, "source_snapshot_encryption_key", value)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the storage pool in which the new disk is created.
        For example:
        * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}
        * /projects/{project}/zones/{zone}/storagePools/{storagePool}
        """
        return pulumi.get(self, "storage_pool")

    @storage_pool.setter
    def storage_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_pool", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the disk type resource describing which disk type to use to
        create the disk. Provide this when creating the disk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the zone where the disk resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _DiskState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 async_primary_disk: Optional[pulumi.Input['DiskAsyncPrimaryDiskArgs']] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key: Optional[pulumi.Input['DiskDiskEncryptionKeyArgs']] = None,
                 disk_id: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enable_confidential_compute: Optional[pulumi.Input[bool]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input['DiskGuestOsFeatureArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 last_attach_timestamp: Optional[pulumi.Input[str]] = None,
                 last_detach_timestamp: Optional[pulumi.Input[str]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multi_writer: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 physical_block_size_bytes: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 provisioned_iops: Optional[pulumi.Input[int]] = None,
                 provisioned_throughput: Optional[pulumi.Input[int]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot: Optional[pulumi.Input[str]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_disk_id: Optional[pulumi.Input[str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input['DiskSourceImageEncryptionKeyArgs']] = None,
                 source_image_id: Optional[pulumi.Input[str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input['DiskSourceSnapshotEncryptionKeyArgs']] = None,
                 source_snapshot_id: Optional[pulumi.Input[str]] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Disk resources.
        :param pulumi.Input[str] access_mode: The accessMode of the disk.
               For example:
               * READ_WRITE_SINGLE
               * READ_WRITE_MANY
               * READ_ONLY_SINGLE
        :param pulumi.Input['DiskAsyncPrimaryDiskArgs'] async_primary_disk: A nested object resource
               Structure is documented below.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input['DiskDiskEncryptionKeyArgs'] disk_encryption_key: Encrypts the disk using a customer-supplied encryption key.
               After you encrypt a disk with a customer-supplied key, you must
               provide the same key if you use the disk later (e.g. to create a disk
               snapshot or an image, or to attach the disk to a virtual machine).
               Customer-supplied encryption keys do not protect access to metadata of
               the disk.
               If you do not provide an encryption key when creating the disk, then
               the disk will be encrypted using an automatically generated key and
               you do not need to provide a key to use the disk later.
               Structure is documented below.
        :param pulumi.Input[str] disk_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[bool] enable_confidential_compute: Whether this disk is using confidential compute mode.
               Note: Only supported on hyperdisk skus, disk_encryption_key is required when setting to true
        :param pulumi.Input[Sequence[pulumi.Input['DiskGuestOsFeatureArgs']]] guest_os_features: A list of features to enable on the guest operating system.
               Applicable only for bootable disks.
               Structure is documented below.
        :param pulumi.Input[str] image: The image from which to initialize this disk. This can be
               one of: the image's `self_link`, `projects/{project}/global/images/{image}`,
               `projects/{project}/global/images/family/{family}`, `global/images/{image}`,
               `global/images/family/{family}`, `family/{family}`, `{project}/{family}`,
               `{project}/{image}`, `{family}`, or `{image}`. If referred by family, the
               images names must include the family name. If they don't, use the
               [compute.Image data source](https://www.terraform.io/docs/providers/google/d/compute_image.html).
               For instance, the image `centos-6-v20180104` includes its family name `centos-6`.
               These images can be referred by family name here.
        :param pulumi.Input[str] interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
               
               > **Warning:** `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.
        :param pulumi.Input[str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this disk.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] last_attach_timestamp: Last attach timestamp in RFC3339 text format.
        :param pulumi.Input[str] last_detach_timestamp: Last detach timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] licenses: Any applicable license URI.
        :param pulumi.Input[bool] multi_writer: Indicates whether or not the disk can be read/write attached to more than one instance.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[int] physical_block_size_bytes: Physical block size of the persistent disk, in bytes. If not present
               in a request, a default value is used. Currently supported sizes
               are 4096 and 16384, other sizes may be added in the future.
               If an unsupported value is requested, the error message will list
               the supported values for the caller's project.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] provisioned_iops: Indicates how many IOPS must be provisioned for the disk.
               Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
               allows for an update of IOPS every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        :param pulumi.Input[int] provisioned_throughput: Indicates how much Throughput must be provisioned for the disk.
               Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
               allows for an update of Throughput every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies applied to this disk for automatic snapshot creations.
               ~>**NOTE** This value does not support updating the
               resource policy, as resource policies can not be updated more than
               one at a time. Use
               `compute.DiskResourcePolicyAttachment`
               to allow for updating the resource policy attached to the disk.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[int] size: Size of the persistent disk, specified in GB. You can specify this
               field when creating a persistent disk using the `image` or
               `snapshot` parameter, or specify it alone to create an empty
               persistent disk.
               If you specify this field along with `image` or `snapshot`,
               the value must not be less than the size of the image
               or the size of the snapshot.
               ~>**NOTE** If you change the size, the provider updates the disk size
               if upsizing is detected but recreates the disk if downsizing is requested.
               You can add `lifecycle.prevent_destroy` in the config to prevent destroying
               and recreating.
        :param pulumi.Input[str] snapshot: The source snapshot used to create this disk. You can provide this as
               a partial or full URL to the resource. If the snapshot is in another
               project than this disk, you must supply a full URL. For example, the
               following are valid values:
               * `https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot`
               * `projects/project/global/snapshots/snapshot`
               * `global/snapshots/snapshot`
        :param pulumi.Input[str] source_disk: The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
               For example, the following are valid values:
               * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
               * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
               * projects/{project}/zones/{zone}/disks/{disk}
               * projects/{project}/regions/{region}/disks/{disk}
               * zones/{zone}/disks/{disk}
               * regions/{region}/disks/{disk}
        :param pulumi.Input[str] source_disk_id: The ID value of the disk used to create this image. This value may
               be used to determine whether the image was taken from the current
               or a previous instance of a given disk name.
        :param pulumi.Input['DiskSourceImageEncryptionKeyArgs'] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if
               the source image is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[str] source_image_id: The ID value of the image used to create this disk. This value
               identifies the exact image that was used to create this persistent
               disk. For example, if you created the persistent disk from an image
               that was later deleted and recreated under the same name, the source
               image ID would identify the exact version of the image that was used.
        :param pulumi.Input['DiskSourceSnapshotEncryptionKeyArgs'] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required
               if the source snapshot is protected by a customer-supplied encryption
               key.
               Structure is documented below.
        :param pulumi.Input[str] source_snapshot_id: The unique ID of the snapshot used to create this disk. This value
               identifies the exact snapshot that was used to create this persistent
               disk. For example, if you created the persistent disk from a snapshot
               that was later deleted and recreated under the same name, the source
               snapshot ID would identify the exact version of the snapshot that was
               used.
        :param pulumi.Input[str] storage_pool: The URL of the storage pool in which the new disk is created.
               For example:
               * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}
               * /projects/{project}/zones/{zone}/storagePools/{storagePool}
        :param pulumi.Input[str] type: URL of the disk type resource describing which disk type to use to
               create the disk. Provide this when creating the disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: Links to the users of the disk (attached instances) in form:
               project/zones/zone/instances/instance
        :param pulumi.Input[str] zone: A reference to the zone where the disk resides.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if async_primary_disk is not None:
            pulumi.set(__self__, "async_primary_disk", async_primary_disk)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_confidential_compute is not None:
            pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)
        if guest_os_features is not None:
            pulumi.set(__self__, "guest_os_features", guest_os_features)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if interface is not None:
            warnings.warn("""`interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.""", DeprecationWarning)
            pulumi.log.warn("""interface is deprecated: `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.""")
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if last_attach_timestamp is not None:
            pulumi.set(__self__, "last_attach_timestamp", last_attach_timestamp)
        if last_detach_timestamp is not None:
            pulumi.set(__self__, "last_detach_timestamp", last_detach_timestamp)
        if licenses is not None:
            pulumi.set(__self__, "licenses", licenses)
        if multi_writer is not None:
            pulumi.set(__self__, "multi_writer", multi_writer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if physical_block_size_bytes is not None:
            pulumi.set(__self__, "physical_block_size_bytes", physical_block_size_bytes)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if provisioned_iops is not None:
            pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_disk_id is not None:
            pulumi.set(__self__, "source_disk_id", source_disk_id)
        if source_image_encryption_key is not None:
            pulumi.set(__self__, "source_image_encryption_key", source_image_encryption_key)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if source_snapshot_encryption_key is not None:
            pulumi.set(__self__, "source_snapshot_encryption_key", source_snapshot_encryption_key)
        if source_snapshot_id is not None:
            pulumi.set(__self__, "source_snapshot_id", source_snapshot_id)
        if storage_pool is not None:
            pulumi.set(__self__, "storage_pool", storage_pool)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The accessMode of the disk.
        For example:
        * READ_WRITE_SINGLE
        * READ_WRITE_MANY
        * READ_ONLY_SINGLE
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="asyncPrimaryDisk")
    def async_primary_disk(self) -> Optional[pulumi.Input['DiskAsyncPrimaryDiskArgs']]:
        """
        A nested object resource
        Structure is documented below.
        """
        return pulumi.get(self, "async_primary_disk")

    @async_primary_disk.setter
    def async_primary_disk(self, value: Optional[pulumi.Input['DiskAsyncPrimaryDiskArgs']]):
        pulumi.set(self, "async_primary_disk", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional[pulumi.Input['DiskDiskEncryptionKeyArgs']]:
        """
        Encrypts the disk using a customer-supplied encryption key.
        After you encrypt a disk with a customer-supplied key, you must
        provide the same key if you use the disk later (e.g. to create a disk
        snapshot or an image, or to attach the disk to a virtual machine).
        Customer-supplied encryption keys do not protect access to metadata of
        the disk.
        If you do not provide an encryption key when creating the disk, then
        the disk will be encrypted using an automatically generated key and
        you do not need to provide a key to use the disk later.
        Structure is documented below.
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: Optional[pulumi.Input['DiskDiskEncryptionKeyArgs']]):
        pulumi.set(self, "disk_encryption_key", value)

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_id", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this disk is using confidential compute mode.
        Note: Only supported on hyperdisk skus, disk_encryption_key is required when setting to true
        """
        return pulumi.get(self, "enable_confidential_compute")

    @enable_confidential_compute.setter
    def enable_confidential_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_confidential_compute", value)

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskGuestOsFeatureArgs']]]]:
        """
        A list of features to enable on the guest operating system.
        Applicable only for bootable disks.
        Structure is documented below.
        """
        return pulumi.get(self, "guest_os_features")

    @guest_os_features.setter
    def guest_os_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskGuestOsFeatureArgs']]]]):
        pulumi.set(self, "guest_os_features", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The image from which to initialize this disk. This can be
        one of: the image's `self_link`, `projects/{project}/global/images/{image}`,
        `projects/{project}/global/images/family/{family}`, `global/images/{image}`,
        `global/images/family/{family}`, `family/{family}`, `{project}/{family}`,
        `{project}/{image}`, `{family}`, or `{image}`. If referred by family, the
        images names must include the family name. If they don't, use the
        [compute.Image data source](https://www.terraform.io/docs/providers/google/d/compute_image.html).
        For instance, the image `centos-6-v20180104` includes its family name `centos-6`.
        These images can be referred by family name here.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.""")
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.

        > **Warning:** `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this disk.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lastAttachTimestamp")
    def last_attach_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Last attach timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_attach_timestamp")

    @last_attach_timestamp.setter
    def last_attach_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_attach_timestamp", value)

    @property
    @pulumi.getter(name="lastDetachTimestamp")
    def last_detach_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Last detach timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_detach_timestamp")

    @last_detach_timestamp.setter
    def last_detach_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_detach_timestamp", value)

    @property
    @pulumi.getter
    def licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Any applicable license URI.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "licenses", value)

    @property
    @pulumi.getter(name="multiWriter")
    def multi_writer(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not the disk can be read/write attached to more than one instance.
        """
        return pulumi.get(self, "multi_writer")

    @multi_writer.setter
    def multi_writer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_writer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="physicalBlockSizeBytes")
    def physical_block_size_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        Physical block size of the persistent disk, in bytes. If not present
        in a request, a default value is used. Currently supported sizes
        are 4096 and 16384, other sizes may be added in the future.
        If an unsupported value is requested, the error message will list
        the supported values for the caller's project.
        """
        return pulumi.get(self, "physical_block_size_bytes")

    @physical_block_size_bytes.setter
    def physical_block_size_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "physical_block_size_bytes", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates how many IOPS must be provisioned for the disk.
        Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
        allows for an update of IOPS every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        """
        return pulumi.get(self, "provisioned_iops")

    @provisioned_iops.setter
    def provisioned_iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_iops", value)

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates how much Throughput must be provisioned for the disk.
        Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
        allows for an update of Throughput every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        """
        return pulumi.get(self, "provisioned_throughput")

    @provisioned_throughput.setter
    def provisioned_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_throughput", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource policies applied to this disk for automatic snapshot creations.
        ~>**NOTE** This value does not support updating the
        resource policy, as resource policies can not be updated more than
        one at a time. Use
        `compute.DiskResourcePolicyAttachment`
        to allow for updating the resource policy attached to the disk.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the persistent disk, specified in GB. You can specify this
        field when creating a persistent disk using the `image` or
        `snapshot` parameter, or specify it alone to create an empty
        persistent disk.
        If you specify this field along with `image` or `snapshot`,
        the value must not be less than the size of the image
        or the size of the snapshot.
        ~>**NOTE** If you change the size, the provider updates the disk size
        if upsizing is detected but recreates the disk if downsizing is requested.
        You can add `lifecycle.prevent_destroy` in the config to prevent destroying
        and recreating.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        The source snapshot used to create this disk. You can provide this as
        a partial or full URL to the resource. If the snapshot is in another
        project than this disk, you must supply a full URL. For example, the
        following are valid values:
        * `https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot`
        * `projects/project/global/snapshots/snapshot`
        * `global/snapshots/snapshot`
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[str]]:
        """
        The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
        For example, the following are valid values:
        * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
        * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
        * projects/{project}/zones/{zone}/disks/{disk}
        * projects/{project}/regions/{region}/disks/{disk}
        * zones/{zone}/disks/{disk}
        * regions/{region}/disks/{disk}
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk", value)

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID value of the disk used to create this image. This value may
        be used to determine whether the image was taken from the current
        or a previous instance of a given disk name.
        """
        return pulumi.get(self, "source_disk_id")

    @source_disk_id.setter
    def source_disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk_id", value)

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> Optional[pulumi.Input['DiskSourceImageEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source image. Required if
        the source image is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @source_image_encryption_key.setter
    def source_image_encryption_key(self, value: Optional[pulumi.Input['DiskSourceImageEncryptionKeyArgs']]):
        pulumi.set(self, "source_image_encryption_key", value)

    @property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID value of the image used to create this disk. This value
        identifies the exact image that was used to create this persistent
        disk. For example, if you created the persistent disk from an image
        that was later deleted and recreated under the same name, the source
        image ID would identify the exact version of the image that was used.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_image_id", value)

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> Optional[pulumi.Input['DiskSourceSnapshotEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source snapshot. Required
        if the source snapshot is protected by a customer-supplied encryption
        key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @source_snapshot_encryption_key.setter
    def source_snapshot_encryption_key(self, value: Optional[pulumi.Input['DiskSourceSnapshotEncryptionKeyArgs']]):
        pulumi.set(self, "source_snapshot_encryption_key", value)

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID of the snapshot used to create this disk. This value
        identifies the exact snapshot that was used to create this persistent
        disk. For example, if you created the persistent disk from a snapshot
        that was later deleted and recreated under the same name, the source
        snapshot ID would identify the exact version of the snapshot that was
        used.
        """
        return pulumi.get(self, "source_snapshot_id")

    @source_snapshot_id.setter
    def source_snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot_id", value)

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the storage pool in which the new disk is created.
        For example:
        * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}
        * /projects/{project}/zones/{zone}/storagePools/{storagePool}
        """
        return pulumi.get(self, "storage_pool")

    @storage_pool.setter
    def storage_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_pool", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the disk type resource describing which disk type to use to
        create the disk. Provide this when creating the disk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Links to the users of the disk (attached instances) in form:
        project/zones/zone/instances/instance
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the zone where the disk resides.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Disk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 async_primary_disk: Optional[pulumi.Input[Union['DiskAsyncPrimaryDiskArgs', 'DiskAsyncPrimaryDiskArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key: Optional[pulumi.Input[Union['DiskDiskEncryptionKeyArgs', 'DiskDiskEncryptionKeyArgsDict']]] = None,
                 enable_confidential_compute: Optional[pulumi.Input[bool]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiskGuestOsFeatureArgs', 'DiskGuestOsFeatureArgsDict']]]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multi_writer: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 physical_block_size_bytes: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 provisioned_iops: Optional[pulumi.Input[int]] = None,
                 provisioned_throughput: Optional[pulumi.Input[int]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot: Optional[pulumi.Input[str]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input[Union['DiskSourceImageEncryptionKeyArgs', 'DiskSourceImageEncryptionKeyArgsDict']]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input[Union['DiskSourceSnapshotEncryptionKeyArgs', 'DiskSourceSnapshotEncryptionKeyArgsDict']]] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Persistent disks are durable storage devices that function similarly to
        the physical disks in a desktop or a server. Compute Engine manages the
        hardware behind these devices to ensure data redundancy and optimize
        performance for you. Persistent disks are available as either standard
        hard disk drives (HDD) or solid-state drives (SSD).

        Persistent disks are located independently from your virtual machine
        instances, so you can detach or move persistent disks to keep your data
        even after you delete your instances. Persistent disk performance scales
        automatically with size, so you can resize your existing persistent disks
        or add more persistent disks to an instance to meet your performance and
        storage space requirements.

        Add a persistent disk to your instance when you need reliable and
        affordable storage with consistent performance characteristics.

        To get more information about Disk, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/disks)
        * How-to Guides
            * [Adding a persistent disk](https://cloud.google.com/compute/docs/disks/add-persistent-disk)

        ## Example Usage

        ### Disk Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Disk("default",
            name="test-disk",
            type="pd-ssd",
            zone="us-central1-a",
            image="debian-11-bullseye-v20220719",
            labels={
                "environment": "dev",
            },
            physical_block_size_bytes=4096)
        ```
        ### Disk Async

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.compute.Disk("primary",
            name="async-test-disk",
            type="pd-ssd",
            zone="us-central1-a",
            physical_block_size_bytes=4096)
        secondary = gcp.compute.Disk("secondary",
            name="async-secondary-test-disk",
            type="pd-ssd",
            zone="us-east1-c",
            async_primary_disk={
                "disk": primary.id,
            },
            physical_block_size_bytes=4096)
        ```
        ### Disk Features

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Disk("default",
            name="test-disk-features",
            type="pd-ssd",
            zone="us-central1-a",
            labels={
                "environment": "dev",
            },
            guest_os_features=[
                {
                    "type": "SECURE_BOOT",
                },
                {
                    "type": "MULTI_IP_SUBNET",
                },
                {
                    "type": "WINDOWS",
                },
            ],
            licenses=["https://www.googleapis.com/compute/v1/projects/windows-cloud/global/licenses/windows-server-core"],
            physical_block_size_bytes=4096)
        ```

        ## Import

        Disk can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/disks/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Disk can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/disk:Disk default projects/{{project}}/zones/{{zone}}/disks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/disk:Disk default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/disk:Disk default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/disk:Disk default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: The accessMode of the disk.
               For example:
               * READ_WRITE_SINGLE
               * READ_WRITE_MANY
               * READ_ONLY_SINGLE
        :param pulumi.Input[Union['DiskAsyncPrimaryDiskArgs', 'DiskAsyncPrimaryDiskArgsDict']] async_primary_disk: A nested object resource
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Union['DiskDiskEncryptionKeyArgs', 'DiskDiskEncryptionKeyArgsDict']] disk_encryption_key: Encrypts the disk using a customer-supplied encryption key.
               After you encrypt a disk with a customer-supplied key, you must
               provide the same key if you use the disk later (e.g. to create a disk
               snapshot or an image, or to attach the disk to a virtual machine).
               Customer-supplied encryption keys do not protect access to metadata of
               the disk.
               If you do not provide an encryption key when creating the disk, then
               the disk will be encrypted using an automatically generated key and
               you do not need to provide a key to use the disk later.
               Structure is documented below.
        :param pulumi.Input[bool] enable_confidential_compute: Whether this disk is using confidential compute mode.
               Note: Only supported on hyperdisk skus, disk_encryption_key is required when setting to true
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiskGuestOsFeatureArgs', 'DiskGuestOsFeatureArgsDict']]]] guest_os_features: A list of features to enable on the guest operating system.
               Applicable only for bootable disks.
               Structure is documented below.
        :param pulumi.Input[str] image: The image from which to initialize this disk. This can be
               one of: the image's `self_link`, `projects/{project}/global/images/{image}`,
               `projects/{project}/global/images/family/{family}`, `global/images/{image}`,
               `global/images/family/{family}`, `family/{family}`, `{project}/{family}`,
               `{project}/{image}`, `{family}`, or `{image}`. If referred by family, the
               images names must include the family name. If they don't, use the
               [compute.Image data source](https://www.terraform.io/docs/providers/google/d/compute_image.html).
               For instance, the image `centos-6-v20180104` includes its family name `centos-6`.
               These images can be referred by family name here.
        :param pulumi.Input[str] interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
               
               > **Warning:** `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this disk.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] licenses: Any applicable license URI.
        :param pulumi.Input[bool] multi_writer: Indicates whether or not the disk can be read/write attached to more than one instance.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[int] physical_block_size_bytes: Physical block size of the persistent disk, in bytes. If not present
               in a request, a default value is used. Currently supported sizes
               are 4096 and 16384, other sizes may be added in the future.
               If an unsupported value is requested, the error message will list
               the supported values for the caller's project.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] provisioned_iops: Indicates how many IOPS must be provisioned for the disk.
               Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
               allows for an update of IOPS every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        :param pulumi.Input[int] provisioned_throughput: Indicates how much Throughput must be provisioned for the disk.
               Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
               allows for an update of Throughput every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies applied to this disk for automatic snapshot creations.
               ~>**NOTE** This value does not support updating the
               resource policy, as resource policies can not be updated more than
               one at a time. Use
               `compute.DiskResourcePolicyAttachment`
               to allow for updating the resource policy attached to the disk.
        :param pulumi.Input[int] size: Size of the persistent disk, specified in GB. You can specify this
               field when creating a persistent disk using the `image` or
               `snapshot` parameter, or specify it alone to create an empty
               persistent disk.
               If you specify this field along with `image` or `snapshot`,
               the value must not be less than the size of the image
               or the size of the snapshot.
               ~>**NOTE** If you change the size, the provider updates the disk size
               if upsizing is detected but recreates the disk if downsizing is requested.
               You can add `lifecycle.prevent_destroy` in the config to prevent destroying
               and recreating.
        :param pulumi.Input[str] snapshot: The source snapshot used to create this disk. You can provide this as
               a partial or full URL to the resource. If the snapshot is in another
               project than this disk, you must supply a full URL. For example, the
               following are valid values:
               * `https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot`
               * `projects/project/global/snapshots/snapshot`
               * `global/snapshots/snapshot`
        :param pulumi.Input[str] source_disk: The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
               For example, the following are valid values:
               * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
               * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
               * projects/{project}/zones/{zone}/disks/{disk}
               * projects/{project}/regions/{region}/disks/{disk}
               * zones/{zone}/disks/{disk}
               * regions/{region}/disks/{disk}
        :param pulumi.Input[Union['DiskSourceImageEncryptionKeyArgs', 'DiskSourceImageEncryptionKeyArgsDict']] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if
               the source image is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[Union['DiskSourceSnapshotEncryptionKeyArgs', 'DiskSourceSnapshotEncryptionKeyArgsDict']] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required
               if the source snapshot is protected by a customer-supplied encryption
               key.
               Structure is documented below.
        :param pulumi.Input[str] storage_pool: The URL of the storage pool in which the new disk is created.
               For example:
               * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}
               * /projects/{project}/zones/{zone}/storagePools/{storagePool}
        :param pulumi.Input[str] type: URL of the disk type resource describing which disk type to use to
               create the disk. Provide this when creating the disk.
        :param pulumi.Input[str] zone: A reference to the zone where the disk resides.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DiskArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Persistent disks are durable storage devices that function similarly to
        the physical disks in a desktop or a server. Compute Engine manages the
        hardware behind these devices to ensure data redundancy and optimize
        performance for you. Persistent disks are available as either standard
        hard disk drives (HDD) or solid-state drives (SSD).

        Persistent disks are located independently from your virtual machine
        instances, so you can detach or move persistent disks to keep your data
        even after you delete your instances. Persistent disk performance scales
        automatically with size, so you can resize your existing persistent disks
        or add more persistent disks to an instance to meet your performance and
        storage space requirements.

        Add a persistent disk to your instance when you need reliable and
        affordable storage with consistent performance characteristics.

        To get more information about Disk, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/disks)
        * How-to Guides
            * [Adding a persistent disk](https://cloud.google.com/compute/docs/disks/add-persistent-disk)

        ## Example Usage

        ### Disk Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Disk("default",
            name="test-disk",
            type="pd-ssd",
            zone="us-central1-a",
            image="debian-11-bullseye-v20220719",
            labels={
                "environment": "dev",
            },
            physical_block_size_bytes=4096)
        ```
        ### Disk Async

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.compute.Disk("primary",
            name="async-test-disk",
            type="pd-ssd",
            zone="us-central1-a",
            physical_block_size_bytes=4096)
        secondary = gcp.compute.Disk("secondary",
            name="async-secondary-test-disk",
            type="pd-ssd",
            zone="us-east1-c",
            async_primary_disk={
                "disk": primary.id,
            },
            physical_block_size_bytes=4096)
        ```
        ### Disk Features

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Disk("default",
            name="test-disk-features",
            type="pd-ssd",
            zone="us-central1-a",
            labels={
                "environment": "dev",
            },
            guest_os_features=[
                {
                    "type": "SECURE_BOOT",
                },
                {
                    "type": "MULTI_IP_SUBNET",
                },
                {
                    "type": "WINDOWS",
                },
            ],
            licenses=["https://www.googleapis.com/compute/v1/projects/windows-cloud/global/licenses/windows-server-core"],
            physical_block_size_bytes=4096)
        ```

        ## Import

        Disk can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/disks/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Disk can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/disk:Disk default projects/{{project}}/zones/{{zone}}/disks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/disk:Disk default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/disk:Disk default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/disk:Disk default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param DiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[str]] = None,
                 async_primary_disk: Optional[pulumi.Input[Union['DiskAsyncPrimaryDiskArgs', 'DiskAsyncPrimaryDiskArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key: Optional[pulumi.Input[Union['DiskDiskEncryptionKeyArgs', 'DiskDiskEncryptionKeyArgsDict']]] = None,
                 enable_confidential_compute: Optional[pulumi.Input[bool]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiskGuestOsFeatureArgs', 'DiskGuestOsFeatureArgsDict']]]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multi_writer: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 physical_block_size_bytes: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 provisioned_iops: Optional[pulumi.Input[int]] = None,
                 provisioned_throughput: Optional[pulumi.Input[int]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot: Optional[pulumi.Input[str]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input[Union['DiskSourceImageEncryptionKeyArgs', 'DiskSourceImageEncryptionKeyArgsDict']]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input[Union['DiskSourceSnapshotEncryptionKeyArgs', 'DiskSourceSnapshotEncryptionKeyArgsDict']]] = None,
                 storage_pool: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskArgs.__new__(DiskArgs)

            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["async_primary_disk"] = async_primary_disk
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_key"] = disk_encryption_key
            __props__.__dict__["enable_confidential_compute"] = enable_confidential_compute
            __props__.__dict__["guest_os_features"] = guest_os_features
            __props__.__dict__["image"] = image
            __props__.__dict__["interface"] = interface
            __props__.__dict__["labels"] = labels
            __props__.__dict__["licenses"] = licenses
            __props__.__dict__["multi_writer"] = multi_writer
            __props__.__dict__["name"] = name
            __props__.__dict__["physical_block_size_bytes"] = physical_block_size_bytes
            __props__.__dict__["project"] = project
            __props__.__dict__["provisioned_iops"] = provisioned_iops
            __props__.__dict__["provisioned_throughput"] = provisioned_throughput
            __props__.__dict__["resource_policies"] = resource_policies
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot"] = snapshot
            __props__.__dict__["source_disk"] = source_disk
            __props__.__dict__["source_image_encryption_key"] = source_image_encryption_key
            __props__.__dict__["source_snapshot_encryption_key"] = source_snapshot_encryption_key
            __props__.__dict__["storage_pool"] = storage_pool
            __props__.__dict__["type"] = type
            __props__.__dict__["zone"] = zone
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["disk_id"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["last_attach_timestamp"] = None
            __props__.__dict__["last_detach_timestamp"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["source_disk_id"] = None
            __props__.__dict__["source_image_id"] = None
            __props__.__dict__["source_snapshot_id"] = None
            __props__.__dict__["users"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Disk, __self__).__init__(
            'gcp:compute/disk:Disk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[str]] = None,
            async_primary_disk: Optional[pulumi.Input[Union['DiskAsyncPrimaryDiskArgs', 'DiskAsyncPrimaryDiskArgsDict']]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_encryption_key: Optional[pulumi.Input[Union['DiskDiskEncryptionKeyArgs', 'DiskDiskEncryptionKeyArgsDict']]] = None,
            disk_id: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            enable_confidential_compute: Optional[pulumi.Input[bool]] = None,
            guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DiskGuestOsFeatureArgs', 'DiskGuestOsFeatureArgsDict']]]]] = None,
            image: Optional[pulumi.Input[str]] = None,
            interface: Optional[pulumi.Input[str]] = None,
            label_fingerprint: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            last_attach_timestamp: Optional[pulumi.Input[str]] = None,
            last_detach_timestamp: Optional[pulumi.Input[str]] = None,
            licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            multi_writer: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            physical_block_size_bytes: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            provisioned_iops: Optional[pulumi.Input[int]] = None,
            provisioned_throughput: Optional[pulumi.Input[int]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            snapshot: Optional[pulumi.Input[str]] = None,
            source_disk: Optional[pulumi.Input[str]] = None,
            source_disk_id: Optional[pulumi.Input[str]] = None,
            source_image_encryption_key: Optional[pulumi.Input[Union['DiskSourceImageEncryptionKeyArgs', 'DiskSourceImageEncryptionKeyArgsDict']]] = None,
            source_image_id: Optional[pulumi.Input[str]] = None,
            source_snapshot_encryption_key: Optional[pulumi.Input[Union['DiskSourceSnapshotEncryptionKeyArgs', 'DiskSourceSnapshotEncryptionKeyArgsDict']]] = None,
            source_snapshot_id: Optional[pulumi.Input[str]] = None,
            storage_pool: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Disk':
        """
        Get an existing Disk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_mode: The accessMode of the disk.
               For example:
               * READ_WRITE_SINGLE
               * READ_WRITE_MANY
               * READ_ONLY_SINGLE
        :param pulumi.Input[Union['DiskAsyncPrimaryDiskArgs', 'DiskAsyncPrimaryDiskArgsDict']] async_primary_disk: A nested object resource
               Structure is documented below.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Union['DiskDiskEncryptionKeyArgs', 'DiskDiskEncryptionKeyArgsDict']] disk_encryption_key: Encrypts the disk using a customer-supplied encryption key.
               After you encrypt a disk with a customer-supplied key, you must
               provide the same key if you use the disk later (e.g. to create a disk
               snapshot or an image, or to attach the disk to a virtual machine).
               Customer-supplied encryption keys do not protect access to metadata of
               the disk.
               If you do not provide an encryption key when creating the disk, then
               the disk will be encrypted using an automatically generated key and
               you do not need to provide a key to use the disk later.
               Structure is documented below.
        :param pulumi.Input[str] disk_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[bool] enable_confidential_compute: Whether this disk is using confidential compute mode.
               Note: Only supported on hyperdisk skus, disk_encryption_key is required when setting to true
        :param pulumi.Input[Sequence[pulumi.Input[Union['DiskGuestOsFeatureArgs', 'DiskGuestOsFeatureArgsDict']]]] guest_os_features: A list of features to enable on the guest operating system.
               Applicable only for bootable disks.
               Structure is documented below.
        :param pulumi.Input[str] image: The image from which to initialize this disk. This can be
               one of: the image's `self_link`, `projects/{project}/global/images/{image}`,
               `projects/{project}/global/images/family/{family}`, `global/images/{image}`,
               `global/images/family/{family}`, `family/{family}`, `{project}/{family}`,
               `{project}/{image}`, `{family}`, or `{image}`. If referred by family, the
               images names must include the family name. If they don't, use the
               [compute.Image data source](https://www.terraform.io/docs/providers/google/d/compute_image.html).
               For instance, the image `centos-6-v20180104` includes its family name `centos-6`.
               These images can be referred by family name here.
        :param pulumi.Input[str] interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
               
               > **Warning:** `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.
        :param pulumi.Input[str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this disk.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] last_attach_timestamp: Last attach timestamp in RFC3339 text format.
        :param pulumi.Input[str] last_detach_timestamp: Last detach timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] licenses: Any applicable license URI.
        :param pulumi.Input[bool] multi_writer: Indicates whether or not the disk can be read/write attached to more than one instance.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               
               
               - - -
        :param pulumi.Input[int] physical_block_size_bytes: Physical block size of the persistent disk, in bytes. If not present
               in a request, a default value is used. Currently supported sizes
               are 4096 and 16384, other sizes may be added in the future.
               If an unsupported value is requested, the error message will list
               the supported values for the caller's project.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] provisioned_iops: Indicates how many IOPS must be provisioned for the disk.
               Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
               allows for an update of IOPS every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        :param pulumi.Input[int] provisioned_throughput: Indicates how much Throughput must be provisioned for the disk.
               Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
               allows for an update of Throughput every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies applied to this disk for automatic snapshot creations.
               ~>**NOTE** This value does not support updating the
               resource policy, as resource policies can not be updated more than
               one at a time. Use
               `compute.DiskResourcePolicyAttachment`
               to allow for updating the resource policy attached to the disk.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[int] size: Size of the persistent disk, specified in GB. You can specify this
               field when creating a persistent disk using the `image` or
               `snapshot` parameter, or specify it alone to create an empty
               persistent disk.
               If you specify this field along with `image` or `snapshot`,
               the value must not be less than the size of the image
               or the size of the snapshot.
               ~>**NOTE** If you change the size, the provider updates the disk size
               if upsizing is detected but recreates the disk if downsizing is requested.
               You can add `lifecycle.prevent_destroy` in the config to prevent destroying
               and recreating.
        :param pulumi.Input[str] snapshot: The source snapshot used to create this disk. You can provide this as
               a partial or full URL to the resource. If the snapshot is in another
               project than this disk, you must supply a full URL. For example, the
               following are valid values:
               * `https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot`
               * `projects/project/global/snapshots/snapshot`
               * `global/snapshots/snapshot`
        :param pulumi.Input[str] source_disk: The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
               For example, the following are valid values:
               * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
               * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
               * projects/{project}/zones/{zone}/disks/{disk}
               * projects/{project}/regions/{region}/disks/{disk}
               * zones/{zone}/disks/{disk}
               * regions/{region}/disks/{disk}
        :param pulumi.Input[str] source_disk_id: The ID value of the disk used to create this image. This value may
               be used to determine whether the image was taken from the current
               or a previous instance of a given disk name.
        :param pulumi.Input[Union['DiskSourceImageEncryptionKeyArgs', 'DiskSourceImageEncryptionKeyArgsDict']] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if
               the source image is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[str] source_image_id: The ID value of the image used to create this disk. This value
               identifies the exact image that was used to create this persistent
               disk. For example, if you created the persistent disk from an image
               that was later deleted and recreated under the same name, the source
               image ID would identify the exact version of the image that was used.
        :param pulumi.Input[Union['DiskSourceSnapshotEncryptionKeyArgs', 'DiskSourceSnapshotEncryptionKeyArgsDict']] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required
               if the source snapshot is protected by a customer-supplied encryption
               key.
               Structure is documented below.
        :param pulumi.Input[str] source_snapshot_id: The unique ID of the snapshot used to create this disk. This value
               identifies the exact snapshot that was used to create this persistent
               disk. For example, if you created the persistent disk from a snapshot
               that was later deleted and recreated under the same name, the source
               snapshot ID would identify the exact version of the snapshot that was
               used.
        :param pulumi.Input[str] storage_pool: The URL of the storage pool in which the new disk is created.
               For example:
               * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}
               * /projects/{project}/zones/{zone}/storagePools/{storagePool}
        :param pulumi.Input[str] type: URL of the disk type resource describing which disk type to use to
               create the disk. Provide this when creating the disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: Links to the users of the disk (attached instances) in form:
               project/zones/zone/instances/instance
        :param pulumi.Input[str] zone: A reference to the zone where the disk resides.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskState.__new__(_DiskState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["async_primary_disk"] = async_primary_disk
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_encryption_key"] = disk_encryption_key
        __props__.__dict__["disk_id"] = disk_id
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_confidential_compute"] = enable_confidential_compute
        __props__.__dict__["guest_os_features"] = guest_os_features
        __props__.__dict__["image"] = image
        __props__.__dict__["interface"] = interface
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["last_attach_timestamp"] = last_attach_timestamp
        __props__.__dict__["last_detach_timestamp"] = last_detach_timestamp
        __props__.__dict__["licenses"] = licenses
        __props__.__dict__["multi_writer"] = multi_writer
        __props__.__dict__["name"] = name
        __props__.__dict__["physical_block_size_bytes"] = physical_block_size_bytes
        __props__.__dict__["project"] = project
        __props__.__dict__["provisioned_iops"] = provisioned_iops
        __props__.__dict__["provisioned_throughput"] = provisioned_throughput
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["resource_policies"] = resource_policies
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot"] = snapshot
        __props__.__dict__["source_disk"] = source_disk
        __props__.__dict__["source_disk_id"] = source_disk_id
        __props__.__dict__["source_image_encryption_key"] = source_image_encryption_key
        __props__.__dict__["source_image_id"] = source_image_id
        __props__.__dict__["source_snapshot_encryption_key"] = source_snapshot_encryption_key
        __props__.__dict__["source_snapshot_id"] = source_snapshot_id
        __props__.__dict__["storage_pool"] = storage_pool
        __props__.__dict__["type"] = type
        __props__.__dict__["users"] = users
        __props__.__dict__["zone"] = zone
        return Disk(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output[str]:
        """
        The accessMode of the disk.
        For example:
        * READ_WRITE_SINGLE
        * READ_WRITE_MANY
        * READ_ONLY_SINGLE
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="asyncPrimaryDisk")
    def async_primary_disk(self) -> pulumi.Output[Optional['outputs.DiskAsyncPrimaryDisk']]:
        """
        A nested object resource
        Structure is documented below.
        """
        return pulumi.get(self, "async_primary_disk")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> pulumi.Output[Optional['outputs.DiskDiskEncryptionKey']]:
        """
        Encrypts the disk using a customer-supplied encryption key.
        After you encrypt a disk with a customer-supplied key, you must
        provide the same key if you use the disk later (e.g. to create a disk
        snapshot or an image, or to attach the disk to a virtual machine).
        Customer-supplied encryption keys do not protect access to metadata of
        the disk.
        If you do not provide an encryption key when creating the disk, then
        the disk will be encrypted using an automatically generated key and
        you do not need to provide a key to use the disk later.
        Structure is documented below.
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Output[str]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> pulumi.Output[bool]:
        """
        Whether this disk is using confidential compute mode.
        Note: Only supported on hyperdisk skus, disk_encryption_key is required when setting to true
        """
        return pulumi.get(self, "enable_confidential_compute")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> pulumi.Output[Sequence['outputs.DiskGuestOsFeature']]:
        """
        A list of features to enable on the guest operating system.
        Applicable only for bootable disks.
        Structure is documented below.
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[Optional[str]]:
        """
        The image from which to initialize this disk. This can be
        one of: the image's `self_link`, `projects/{project}/global/images/{image}`,
        `projects/{project}/global/images/family/{family}`, `global/images/{image}`,
        `global/images/family/{family}`, `family/{family}`, `{project}/{family}`,
        `{project}/{image}`, `{family}`, or `{image}`. If referred by family, the
        images names must include the family name. If they don't, use the
        [compute.Image data source](https://www.terraform.io/docs/providers/google/d/compute_image.html).
        For instance, the image `centos-6-v20180104` includes its family name `centos-6`.
        These images can be referred by family name here.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    @_utilities.deprecated("""`interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.""")
    def interface(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.

        > **Warning:** `interface` is deprecated and will be removed in a future major release. This field is no longer used and can be safely removed from your configurations; disk interfaces are automatically determined on attachment.
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels to apply to this disk.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastAttachTimestamp")
    def last_attach_timestamp(self) -> pulumi.Output[str]:
        """
        Last attach timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_attach_timestamp")

    @property
    @pulumi.getter(name="lastDetachTimestamp")
    def last_detach_timestamp(self) -> pulumi.Output[str]:
        """
        Last detach timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_detach_timestamp")

    @property
    @pulumi.getter
    def licenses(self) -> pulumi.Output[Sequence[str]]:
        """
        Any applicable license URI.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter(name="multiWriter")
    def multi_writer(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether or not the disk can be read/write attached to more than one instance.
        """
        return pulumi.get(self, "multi_writer")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="physicalBlockSizeBytes")
    def physical_block_size_bytes(self) -> pulumi.Output[int]:
        """
        Physical block size of the persistent disk, in bytes. If not present
        in a request, a default value is used. Currently supported sizes
        are 4096 and 16384, other sizes may be added in the future.
        If an unsupported value is requested, the error message will list
        the supported values for the caller's project.
        """
        return pulumi.get(self, "physical_block_size_bytes")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> pulumi.Output[int]:
        """
        Indicates how many IOPS must be provisioned for the disk.
        Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
        allows for an update of IOPS every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        """
        return pulumi.get(self, "provisioned_iops")

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> pulumi.Output[int]:
        """
        Indicates how much Throughput must be provisioned for the disk.
        Note: Updating currently is only supported by hyperdisk skus without the need to delete and recreate the disk, hyperdisk
        allows for an update of Throughput every 4 hours. To update your hyperdisk more frequently, you'll need to manually delete and recreate it
        """
        return pulumi.get(self, "provisioned_throughput")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> pulumi.Output[Sequence[str]]:
        """
        Resource policies applied to this disk for automatic snapshot creations.
        ~>**NOTE** This value does not support updating the
        resource policy, as resource policies can not be updated more than
        one at a time. Use
        `compute.DiskResourcePolicyAttachment`
        to allow for updating the resource policy attached to the disk.
        """
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Size of the persistent disk, specified in GB. You can specify this
        field when creating a persistent disk using the `image` or
        `snapshot` parameter, or specify it alone to create an empty
        persistent disk.
        If you specify this field along with `image` or `snapshot`,
        the value must not be less than the size of the image
        or the size of the snapshot.
        ~>**NOTE** If you change the size, the provider updates the disk size
        if upsizing is detected but recreates the disk if downsizing is requested.
        You can add `lifecycle.prevent_destroy` in the config to prevent destroying
        and recreating.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def snapshot(self) -> pulumi.Output[Optional[str]]:
        """
        The source snapshot used to create this disk. You can provide this as
        a partial or full URL to the resource. If the snapshot is in another
        project than this disk, you must supply a full URL. For example, the
        following are valid values:
        * `https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot`
        * `projects/project/global/snapshots/snapshot`
        * `global/snapshots/snapshot`
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> pulumi.Output[Optional[str]]:
        """
        The source disk used to create this disk. You can provide this as a partial or full URL to the resource.
        For example, the following are valid values:
        * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/disks/{disk}
        * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}
        * projects/{project}/zones/{zone}/disks/{disk}
        * projects/{project}/regions/{region}/disks/{disk}
        * zones/{zone}/disks/{disk}
        * regions/{region}/disks/{disk}
        """
        return pulumi.get(self, "source_disk")

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> pulumi.Output[str]:
        """
        The ID value of the disk used to create this image. This value may
        be used to determine whether the image was taken from the current
        or a previous instance of a given disk name.
        """
        return pulumi.get(self, "source_disk_id")

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> pulumi.Output[Optional['outputs.DiskSourceImageEncryptionKey']]:
        """
        The customer-supplied encryption key of the source image. Required if
        the source image is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> pulumi.Output[str]:
        """
        The ID value of the image used to create this disk. This value
        identifies the exact image that was used to create this persistent
        disk. For example, if you created the persistent disk from an image
        that was later deleted and recreated under the same name, the source
        image ID would identify the exact version of the image that was used.
        """
        return pulumi.get(self, "source_image_id")

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> pulumi.Output[Optional['outputs.DiskSourceSnapshotEncryptionKey']]:
        """
        The customer-supplied encryption key of the source snapshot. Required
        if the source snapshot is protected by a customer-supplied encryption
        key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> pulumi.Output[str]:
        """
        The unique ID of the snapshot used to create this disk. This value
        identifies the exact snapshot that was used to create this persistent
        disk. For example, if you created the persistent disk from a snapshot
        that was later deleted and recreated under the same name, the source
        snapshot ID would identify the exact version of the snapshot that was
        used.
        """
        return pulumi.get(self, "source_snapshot_id")

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the storage pool in which the new disk is created.
        For example:
        * https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}
        * /projects/{project}/zones/{zone}/storagePools/{storagePool}
        """
        return pulumi.get(self, "storage_pool")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        URL of the disk type resource describing which disk type to use to
        create the disk. Provide this when creating the disk.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence[str]]:
        """
        Links to the users of the disk (attached instances) in form:
        project/zones/zone/instances/instance
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        A reference to the zone where the disk resides.
        """
        return pulumi.get(self, "zone")

