# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InterconnectArgs', 'Interconnect']

@pulumi.input_type
class InterconnectArgs:
    def __init__(__self__, *,
                 interconnect_type: pulumi.Input[str],
                 link_type: pulumi.Input[str],
                 requested_link_count: pulumi.Input[int],
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 macsec: Optional[pulumi.Input['InterconnectMacsecArgs']] = None,
                 macsec_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 noc_contact_email: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_location: Optional[pulumi.Input[str]] = None,
                 requested_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Interconnect resource.
        :param pulumi.Input[str] interconnect_type: Type of interconnect. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
               Can take one of the following values:
               - PARTNER: A partner-managed interconnection shared between customers though a partner.
               - DEDICATED: A dedicated physical interconnection with the customer.
               Possible values are: `DEDICATED`, `PARTNER`, `IT_PRIVATE`.
               
               
               - - -
        :param pulumi.Input[str] link_type: Type of link requested. Note that this field indicates the speed of each of the links in the
               bundle, not the speed of the entire bundle. Can take one of the following values:
               - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics.
               - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
               Possible values are: `LINK_TYPE_ETHERNET_10G_LR`, `LINK_TYPE_ETHERNET_100G_LR`.
        :param pulumi.Input[int] requested_link_count: Target number of physical links in the link bundle, as requested by the customer.
        :param pulumi.Input[bool] admin_enabled: Administrative status of the interconnect. When this is set to true, the Interconnect is
               functional and can carry traffic. When set to false, no packets can be carried over the
               interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
        :param pulumi.Input[str] customer_name: Customer name, to put in the Letter of Authorization as the party authorized to request a
               crossconnect. This field is required for Dedicated and Partner Interconnect, should not be specified
               for cross-cloud interconnect.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for this resource. These can only be added or modified by the setLabels
               method. Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: URL of the InterconnectLocation object that represents where this connection is to be provisioned.
               Specifies the location inside Google's Networks, should not be passed in case of cross-cloud interconnect.
        :param pulumi.Input['InterconnectMacsecArgs'] macsec: Configuration that enables Media Access Control security (MACsec) on the Cloud
               Interconnect connection between Google and your on-premises router.
               Structure is documented below.
        :param pulumi.Input[bool] macsec_enabled: Enable or disable MACsec on this Interconnect connection.
               MACsec enablement fails if the MACsec object is not specified.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] noc_contact_email: Email address to contact the customer NOC for operations and maintenance notifications
               regarding this Interconnect. If specified, this will be used for notifications in addition to
               all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications.
               This field is required for users who sign up for Cloud Interconnect using workforce identity
               federation.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] remote_location: Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside
               of Google's network that the interconnect is connected to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested_features: interconnects.list of features requested for this Interconnect connection. Options: IF_MACSEC (
               If specified then the connection is created on MACsec capable hardware ports. If not
               specified, the default value is false, which allocates non-MACsec capable ports first if
               available). Note that MACSEC is still technically allowed for compatibility reasons, but it
               does not work with the API, and will be removed in an upcoming major version.
               Each value may be one of: `MACSEC`, `IF_MACSEC`.
        """
        pulumi.set(__self__, "interconnect_type", interconnect_type)
        pulumi.set(__self__, "link_type", link_type)
        pulumi.set(__self__, "requested_link_count", requested_link_count)
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if customer_name is not None:
            pulumi.set(__self__, "customer_name", customer_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if macsec is not None:
            pulumi.set(__self__, "macsec", macsec)
        if macsec_enabled is not None:
            pulumi.set(__self__, "macsec_enabled", macsec_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if noc_contact_email is not None:
            pulumi.set(__self__, "noc_contact_email", noc_contact_email)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if remote_location is not None:
            pulumi.set(__self__, "remote_location", remote_location)
        if requested_features is not None:
            pulumi.set(__self__, "requested_features", requested_features)

    @property
    @pulumi.getter(name="interconnectType")
    def interconnect_type(self) -> pulumi.Input[str]:
        """
        Type of interconnect. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
        Can take one of the following values:
        - PARTNER: A partner-managed interconnection shared between customers though a partner.
        - DEDICATED: A dedicated physical interconnection with the customer.
        Possible values are: `DEDICATED`, `PARTNER`, `IT_PRIVATE`.


        - - -
        """
        return pulumi.get(self, "interconnect_type")

    @interconnect_type.setter
    def interconnect_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "interconnect_type", value)

    @property
    @pulumi.getter(name="linkType")
    def link_type(self) -> pulumi.Input[str]:
        """
        Type of link requested. Note that this field indicates the speed of each of the links in the
        bundle, not the speed of the entire bundle. Can take one of the following values:
        - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics.
        - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
        Possible values are: `LINK_TYPE_ETHERNET_10G_LR`, `LINK_TYPE_ETHERNET_100G_LR`.
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "link_type", value)

    @property
    @pulumi.getter(name="requestedLinkCount")
    def requested_link_count(self) -> pulumi.Input[int]:
        """
        Target number of physical links in the link bundle, as requested by the customer.
        """
        return pulumi.get(self, "requested_link_count")

    @requested_link_count.setter
    def requested_link_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "requested_link_count", value)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Administrative status of the interconnect. When this is set to true, the Interconnect is
        functional and can carry traffic. When set to false, no packets can be carried over the
        interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_enabled", value)

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Customer name, to put in the Letter of Authorization as the party authorized to request a
        crossconnect. This field is required for Dedicated and Partner Interconnect, should not be specified
        for cross-cloud interconnect.
        """
        return pulumi.get(self, "customer_name")

    @customer_name.setter
    def customer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels
        method. Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the InterconnectLocation object that represents where this connection is to be provisioned.
        Specifies the location inside Google's Networks, should not be passed in case of cross-cloud interconnect.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def macsec(self) -> Optional[pulumi.Input['InterconnectMacsecArgs']]:
        """
        Configuration that enables Media Access Control security (MACsec) on the Cloud
        Interconnect connection between Google and your on-premises router.
        Structure is documented below.
        """
        return pulumi.get(self, "macsec")

    @macsec.setter
    def macsec(self, value: Optional[pulumi.Input['InterconnectMacsecArgs']]):
        pulumi.set(self, "macsec", value)

    @property
    @pulumi.getter(name="macsecEnabled")
    def macsec_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable MACsec on this Interconnect connection.
        MACsec enablement fails if the MACsec object is not specified.
        """
        return pulumi.get(self, "macsec_enabled")

    @macsec_enabled.setter
    def macsec_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "macsec_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nocContactEmail")
    def noc_contact_email(self) -> Optional[pulumi.Input[str]]:
        """
        Email address to contact the customer NOC for operations and maintenance notifications
        regarding this Interconnect. If specified, this will be used for notifications in addition to
        all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications.
        This field is required for users who sign up for Cloud Interconnect using workforce identity
        federation.
        """
        return pulumi.get(self, "noc_contact_email")

    @noc_contact_email.setter
    def noc_contact_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "noc_contact_email", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="remoteLocation")
    def remote_location(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside
        of Google's network that the interconnect is connected to.
        """
        return pulumi.get(self, "remote_location")

    @remote_location.setter
    def remote_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_location", value)

    @property
    @pulumi.getter(name="requestedFeatures")
    def requested_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        interconnects.list of features requested for this Interconnect connection. Options: IF_MACSEC (
        If specified then the connection is created on MACsec capable hardware ports. If not
        specified, the default value is false, which allocates non-MACsec capable ports first if
        available). Note that MACSEC is still technically allowed for compatibility reasons, but it
        does not work with the API, and will be removed in an upcoming major version.
        Each value may be one of: `MACSEC`, `IF_MACSEC`.
        """
        return pulumi.get(self, "requested_features")

    @requested_features.setter
    def requested_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requested_features", value)


@pulumi.input_type
class _InterconnectState:
    def __init__(__self__, *,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 available_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 circuit_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectCircuitInfoArgs']]]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 expected_outages: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectExpectedOutageArgs']]]] = None,
                 google_ip_address: Optional[pulumi.Input[str]] = None,
                 google_reference_id: Optional[pulumi.Input[str]] = None,
                 interconnect_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 interconnect_type: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 link_type: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 macsec: Optional[pulumi.Input['InterconnectMacsecArgs']] = None,
                 macsec_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 noc_contact_email: Optional[pulumi.Input[str]] = None,
                 operational_status: Optional[pulumi.Input[str]] = None,
                 peer_ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 provisioned_link_count: Optional[pulumi.Input[int]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 remote_location: Optional[pulumi.Input[str]] = None,
                 requested_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requested_link_count: Optional[pulumi.Input[int]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Interconnect resources.
        :param pulumi.Input[bool] admin_enabled: Administrative status of the interconnect. When this is set to true, the Interconnect is
               functional and can carry traffic. When set to false, no packets can be carried over the
               interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_features: interconnects.list of features available for this Interconnect connection. Can take the value:
               MACSEC. If present then the Interconnect connection is provisioned on MACsec capable hardware
               ports. If not present then the Interconnect connection is provisioned on non-MACsec capable
               ports and MACsec isn't supported and enabling MACsec fails).
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectCircuitInfoArgs']]] circuit_infos: A list of CircuitInfo objects, that describe the individual circuits in this LAG.
               Structure is documented below.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] customer_name: Customer name, to put in the Letter of Authorization as the party authorized to request a
               crossconnect. This field is required for Dedicated and Partner Interconnect, should not be specified
               for cross-cloud interconnect.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectExpectedOutageArgs']]] expected_outages: A list of outages expected for this Interconnect.
               Structure is documented below.
        :param pulumi.Input[str] google_ip_address: IP address configured on the Google side of the Interconnect link.
               This can be used only for ping tests.
        :param pulumi.Input[str] google_reference_id: Google reference ID to be used when raising support tickets with Google or otherwise to debug
               backend connectivity issues.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] interconnect_attachments: A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
        :param pulumi.Input[str] interconnect_type: Type of interconnect. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
               Can take one of the following values:
               - PARTNER: A partner-managed interconnection shared between customers though a partner.
               - DEDICATED: A dedicated physical interconnection with the customer.
               Possible values are: `DEDICATED`, `PARTNER`, `IT_PRIVATE`.
               
               
               - - -
        :param pulumi.Input[str] label_fingerprint: A fingerprint for the labels being applied to this Interconnect, which is essentially a hash
               of the labels set used for optimistic locking. The fingerprint is initially generated by
               Compute Engine and changes after every request to modify or update labels.
               You must always provide an up-to-date fingerprint hash in order to update or change labels,
               otherwise the request will fail with error 412 conditionNotMet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for this resource. These can only be added or modified by the setLabels
               method. Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] link_type: Type of link requested. Note that this field indicates the speed of each of the links in the
               bundle, not the speed of the entire bundle. Can take one of the following values:
               - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics.
               - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
               Possible values are: `LINK_TYPE_ETHERNET_10G_LR`, `LINK_TYPE_ETHERNET_100G_LR`.
        :param pulumi.Input[str] location: URL of the InterconnectLocation object that represents where this connection is to be provisioned.
               Specifies the location inside Google's Networks, should not be passed in case of cross-cloud interconnect.
        :param pulumi.Input['InterconnectMacsecArgs'] macsec: Configuration that enables Media Access Control security (MACsec) on the Cloud
               Interconnect connection between Google and your on-premises router.
               Structure is documented below.
        :param pulumi.Input[bool] macsec_enabled: Enable or disable MACsec on this Interconnect connection.
               MACsec enablement fails if the MACsec object is not specified.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] noc_contact_email: Email address to contact the customer NOC for operations and maintenance notifications
               regarding this Interconnect. If specified, this will be used for notifications in addition to
               all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications.
               This field is required for users who sign up for Cloud Interconnect using workforce identity
               federation.
        :param pulumi.Input[str] operational_status: The current status of this Interconnect's functionality, which can take one of the following:
               - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may
               be provisioned on this Interconnect.
               - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be
               provisioned on this Interconnect.
               - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No
               attachments may be provisioned or updated on this Interconnect.
        :param pulumi.Input[str] peer_ip_address: IP address configured on the customer side of the Interconnect link.
               The customer should configure this IP address during turnup when prompted by Google NOC.
               This can be used only for ping tests.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] provisioned_link_count: Number of links actually provisioned in this interconnect.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] remote_location: Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside
               of Google's network that the interconnect is connected to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested_features: interconnects.list of features requested for this Interconnect connection. Options: IF_MACSEC (
               If specified then the connection is created on MACsec capable hardware ports. If not
               specified, the default value is false, which allocates non-MACsec capable ports first if
               available). Note that MACSEC is still technically allowed for compatibility reasons, but it
               does not work with the API, and will be removed in an upcoming major version.
               Each value may be one of: `MACSEC`, `IF_MACSEC`.
        :param pulumi.Input[int] requested_link_count: Target number of physical links in the link bundle, as requested by the customer.
        :param pulumi.Input[bool] satisfies_pzs: Reserved for future use.
        :param pulumi.Input[str] state: (Output)
               State of this notification. Note that the versions of this enum prefixed with "NS_" have
               been deprecated in favor of the unprefixed values. Can take one of the following values:
               - ACTIVE: This outage notification is active. The event could be in the past, present,
               or future. See startTime and endTime for scheduling.
               - CANCELLED: The outage associated with this notification was cancelled before the
               outage was due to start.
               - COMPLETED: The outage associated with this notification is complete.
        """
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if available_features is not None:
            pulumi.set(__self__, "available_features", available_features)
        if circuit_infos is not None:
            pulumi.set(__self__, "circuit_infos", circuit_infos)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if customer_name is not None:
            pulumi.set(__self__, "customer_name", customer_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if expected_outages is not None:
            pulumi.set(__self__, "expected_outages", expected_outages)
        if google_ip_address is not None:
            pulumi.set(__self__, "google_ip_address", google_ip_address)
        if google_reference_id is not None:
            pulumi.set(__self__, "google_reference_id", google_reference_id)
        if interconnect_attachments is not None:
            pulumi.set(__self__, "interconnect_attachments", interconnect_attachments)
        if interconnect_type is not None:
            pulumi.set(__self__, "interconnect_type", interconnect_type)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if link_type is not None:
            pulumi.set(__self__, "link_type", link_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if macsec is not None:
            pulumi.set(__self__, "macsec", macsec)
        if macsec_enabled is not None:
            pulumi.set(__self__, "macsec_enabled", macsec_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if noc_contact_email is not None:
            pulumi.set(__self__, "noc_contact_email", noc_contact_email)
        if operational_status is not None:
            pulumi.set(__self__, "operational_status", operational_status)
        if peer_ip_address is not None:
            pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if provisioned_link_count is not None:
            pulumi.set(__self__, "provisioned_link_count", provisioned_link_count)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if remote_location is not None:
            pulumi.set(__self__, "remote_location", remote_location)
        if requested_features is not None:
            pulumi.set(__self__, "requested_features", requested_features)
        if requested_link_count is not None:
            pulumi.set(__self__, "requested_link_count", requested_link_count)
        if satisfies_pzs is not None:
            pulumi.set(__self__, "satisfies_pzs", satisfies_pzs)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Administrative status of the interconnect. When this is set to true, the Interconnect is
        functional and can carry traffic. When set to false, no packets can be carried over the
        interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_enabled", value)

    @property
    @pulumi.getter(name="availableFeatures")
    def available_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        interconnects.list of features available for this Interconnect connection. Can take the value:
        MACSEC. If present then the Interconnect connection is provisioned on MACsec capable hardware
        ports. If not present then the Interconnect connection is provisioned on non-MACsec capable
        ports and MACsec isn't supported and enabling MACsec fails).
        """
        return pulumi.get(self, "available_features")

    @available_features.setter
    def available_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "available_features", value)

    @property
    @pulumi.getter(name="circuitInfos")
    def circuit_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectCircuitInfoArgs']]]]:
        """
        A list of CircuitInfo objects, that describe the individual circuits in this LAG.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_infos")

    @circuit_infos.setter
    def circuit_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectCircuitInfoArgs']]]]):
        pulumi.set(self, "circuit_infos", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Customer name, to put in the Letter of Authorization as the party authorized to request a
        crossconnect. This field is required for Dedicated and Partner Interconnect, should not be specified
        for cross-cloud interconnect.
        """
        return pulumi.get(self, "customer_name")

    @customer_name.setter
    def customer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="expectedOutages")
    def expected_outages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectExpectedOutageArgs']]]]:
        """
        A list of outages expected for this Interconnect.
        Structure is documented below.
        """
        return pulumi.get(self, "expected_outages")

    @expected_outages.setter
    def expected_outages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectExpectedOutageArgs']]]]):
        pulumi.set(self, "expected_outages", value)

    @property
    @pulumi.getter(name="googleIpAddress")
    def google_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address configured on the Google side of the Interconnect link.
        This can be used only for ping tests.
        """
        return pulumi.get(self, "google_ip_address")

    @google_ip_address.setter
    def google_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_ip_address", value)

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        Google reference ID to be used when raising support tickets with Google or otherwise to debug
        backend connectivity issues.
        """
        return pulumi.get(self, "google_reference_id")

    @google_reference_id.setter
    def google_reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_reference_id", value)

    @property
    @pulumi.getter(name="interconnectAttachments")
    def interconnect_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
        """
        return pulumi.get(self, "interconnect_attachments")

    @interconnect_attachments.setter
    def interconnect_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "interconnect_attachments", value)

    @property
    @pulumi.getter(name="interconnectType")
    def interconnect_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of interconnect. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
        Can take one of the following values:
        - PARTNER: A partner-managed interconnection shared between customers though a partner.
        - DEDICATED: A dedicated physical interconnection with the customer.
        Possible values are: `DEDICATED`, `PARTNER`, `IT_PRIVATE`.


        - - -
        """
        return pulumi.get(self, "interconnect_type")

    @interconnect_type.setter
    def interconnect_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interconnect_type", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        A fingerprint for the labels being applied to this Interconnect, which is essentially a hash
        of the labels set used for optimistic locking. The fingerprint is initially generated by
        Compute Engine and changes after every request to modify or update labels.
        You must always provide an up-to-date fingerprint hash in order to update or change labels,
        otherwise the request will fail with error 412 conditionNotMet.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels
        method. Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linkType")
    def link_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of link requested. Note that this field indicates the speed of each of the links in the
        bundle, not the speed of the entire bundle. Can take one of the following values:
        - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics.
        - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
        Possible values are: `LINK_TYPE_ETHERNET_10G_LR`, `LINK_TYPE_ETHERNET_100G_LR`.
        """
        return pulumi.get(self, "link_type")

    @link_type.setter
    def link_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_type", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the InterconnectLocation object that represents where this connection is to be provisioned.
        Specifies the location inside Google's Networks, should not be passed in case of cross-cloud interconnect.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def macsec(self) -> Optional[pulumi.Input['InterconnectMacsecArgs']]:
        """
        Configuration that enables Media Access Control security (MACsec) on the Cloud
        Interconnect connection between Google and your on-premises router.
        Structure is documented below.
        """
        return pulumi.get(self, "macsec")

    @macsec.setter
    def macsec(self, value: Optional[pulumi.Input['InterconnectMacsecArgs']]):
        pulumi.set(self, "macsec", value)

    @property
    @pulumi.getter(name="macsecEnabled")
    def macsec_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable MACsec on this Interconnect connection.
        MACsec enablement fails if the MACsec object is not specified.
        """
        return pulumi.get(self, "macsec_enabled")

    @macsec_enabled.setter
    def macsec_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "macsec_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nocContactEmail")
    def noc_contact_email(self) -> Optional[pulumi.Input[str]]:
        """
        Email address to contact the customer NOC for operations and maintenance notifications
        regarding this Interconnect. If specified, this will be used for notifications in addition to
        all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications.
        This field is required for users who sign up for Cloud Interconnect using workforce identity
        federation.
        """
        return pulumi.get(self, "noc_contact_email")

    @noc_contact_email.setter
    def noc_contact_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "noc_contact_email", value)

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of this Interconnect's functionality, which can take one of the following:
        - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may
        be provisioned on this Interconnect.
        - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be
        provisioned on this Interconnect.
        - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No
        attachments may be provisioned or updated on this Interconnect.
        """
        return pulumi.get(self, "operational_status")

    @operational_status.setter
    def operational_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operational_status", value)

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address configured on the customer side of the Interconnect link.
        The customer should configure this IP address during turnup when prompted by Google NOC.
        This can be used only for ping tests.
        """
        return pulumi.get(self, "peer_ip_address")

    @peer_ip_address.setter
    def peer_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_ip_address", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="provisionedLinkCount")
    def provisioned_link_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of links actually provisioned in this interconnect.
        """
        return pulumi.get(self, "provisioned_link_count")

    @provisioned_link_count.setter
    def provisioned_link_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_link_count", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="remoteLocation")
    def remote_location(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside
        of Google's network that the interconnect is connected to.
        """
        return pulumi.get(self, "remote_location")

    @remote_location.setter
    def remote_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_location", value)

    @property
    @pulumi.getter(name="requestedFeatures")
    def requested_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        interconnects.list of features requested for this Interconnect connection. Options: IF_MACSEC (
        If specified then the connection is created on MACsec capable hardware ports. If not
        specified, the default value is false, which allocates non-MACsec capable ports first if
        available). Note that MACSEC is still technically allowed for compatibility reasons, but it
        does not work with the API, and will be removed in an upcoming major version.
        Each value may be one of: `MACSEC`, `IF_MACSEC`.
        """
        return pulumi.get(self, "requested_features")

    @requested_features.setter
    def requested_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requested_features", value)

    @property
    @pulumi.getter(name="requestedLinkCount")
    def requested_link_count(self) -> Optional[pulumi.Input[int]]:
        """
        Target number of physical links in the link bundle, as requested by the customer.
        """
        return pulumi.get(self, "requested_link_count")

    @requested_link_count.setter
    def requested_link_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "requested_link_count", value)

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> Optional[pulumi.Input[bool]]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @satisfies_pzs.setter
    def satisfies_pzs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "satisfies_pzs", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        State of this notification. Note that the versions of this enum prefixed with "NS_" have
        been deprecated in favor of the unprefixed values. Can take one of the following values:
        - ACTIVE: This outage notification is active. The event could be in the past, present,
        or future. See startTime and endTime for scheduling.
        - CANCELLED: The outage associated with this notification was cancelled before the
        outage was due to start.
        - COMPLETED: The outage associated with this notification is complete.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class Interconnect(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 interconnect_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 link_type: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 macsec: Optional[pulumi.Input[Union['InterconnectMacsecArgs', 'InterconnectMacsecArgsDict']]] = None,
                 macsec_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 noc_contact_email: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_location: Optional[pulumi.Input[str]] = None,
                 requested_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requested_link_count: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Represents an Interconnect resource. The Interconnect resource is a dedicated connection between
        Google's network and your on-premises network.

        To get more information about Interconnect, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/interconnects)
        * How-to Guides
            * [Create a Dedicated Interconnect](https://cloud.google.com/network-connectivity/docs/interconnect/concepts/dedicated-overview)

        ## Example Usage

        ### Compute Interconnect Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_interconnect = gcp.compute.Interconnect("example-interconnect",
            name="example-interconnect",
            customer_name="example_customer",
            interconnect_type="DEDICATED",
            link_type="LINK_TYPE_ETHERNET_10G_LR",
            location=f"https://www.googleapis.com/compute/v1/projects/{project.name}/global/interconnectLocations/iad-zone1-1",
            requested_link_count=1)
        ```

        ## Import

        Interconnect can be imported using any of these accepted formats:

        * `projects/{{project}}/global/interconnects/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Interconnect can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/interconnect:Interconnect default projects/{{project}}/global/interconnects/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnect:Interconnect default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnect:Interconnect default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_enabled: Administrative status of the interconnect. When this is set to true, the Interconnect is
               functional and can carry traffic. When set to false, no packets can be carried over the
               interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
        :param pulumi.Input[str] customer_name: Customer name, to put in the Letter of Authorization as the party authorized to request a
               crossconnect. This field is required for Dedicated and Partner Interconnect, should not be specified
               for cross-cloud interconnect.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[str] interconnect_type: Type of interconnect. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
               Can take one of the following values:
               - PARTNER: A partner-managed interconnection shared between customers though a partner.
               - DEDICATED: A dedicated physical interconnection with the customer.
               Possible values are: `DEDICATED`, `PARTNER`, `IT_PRIVATE`.
               
               
               - - -
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for this resource. These can only be added or modified by the setLabels
               method. Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] link_type: Type of link requested. Note that this field indicates the speed of each of the links in the
               bundle, not the speed of the entire bundle. Can take one of the following values:
               - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics.
               - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
               Possible values are: `LINK_TYPE_ETHERNET_10G_LR`, `LINK_TYPE_ETHERNET_100G_LR`.
        :param pulumi.Input[str] location: URL of the InterconnectLocation object that represents where this connection is to be provisioned.
               Specifies the location inside Google's Networks, should not be passed in case of cross-cloud interconnect.
        :param pulumi.Input[Union['InterconnectMacsecArgs', 'InterconnectMacsecArgsDict']] macsec: Configuration that enables Media Access Control security (MACsec) on the Cloud
               Interconnect connection between Google and your on-premises router.
               Structure is documented below.
        :param pulumi.Input[bool] macsec_enabled: Enable or disable MACsec on this Interconnect connection.
               MACsec enablement fails if the MACsec object is not specified.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] noc_contact_email: Email address to contact the customer NOC for operations and maintenance notifications
               regarding this Interconnect. If specified, this will be used for notifications in addition to
               all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications.
               This field is required for users who sign up for Cloud Interconnect using workforce identity
               federation.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] remote_location: Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside
               of Google's network that the interconnect is connected to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested_features: interconnects.list of features requested for this Interconnect connection. Options: IF_MACSEC (
               If specified then the connection is created on MACsec capable hardware ports. If not
               specified, the default value is false, which allocates non-MACsec capable ports first if
               available). Note that MACSEC is still technically allowed for compatibility reasons, but it
               does not work with the API, and will be removed in an upcoming major version.
               Each value may be one of: `MACSEC`, `IF_MACSEC`.
        :param pulumi.Input[int] requested_link_count: Target number of physical links in the link bundle, as requested by the customer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterconnectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an Interconnect resource. The Interconnect resource is a dedicated connection between
        Google's network and your on-premises network.

        To get more information about Interconnect, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/interconnects)
        * How-to Guides
            * [Create a Dedicated Interconnect](https://cloud.google.com/network-connectivity/docs/interconnect/concepts/dedicated-overview)

        ## Example Usage

        ### Compute Interconnect Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_interconnect = gcp.compute.Interconnect("example-interconnect",
            name="example-interconnect",
            customer_name="example_customer",
            interconnect_type="DEDICATED",
            link_type="LINK_TYPE_ETHERNET_10G_LR",
            location=f"https://www.googleapis.com/compute/v1/projects/{project.name}/global/interconnectLocations/iad-zone1-1",
            requested_link_count=1)
        ```

        ## Import

        Interconnect can be imported using any of these accepted formats:

        * `projects/{{project}}/global/interconnects/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Interconnect can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/interconnect:Interconnect default projects/{{project}}/global/interconnects/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnect:Interconnect default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnect:Interconnect default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InterconnectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterconnectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 interconnect_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 link_type: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 macsec: Optional[pulumi.Input[Union['InterconnectMacsecArgs', 'InterconnectMacsecArgsDict']]] = None,
                 macsec_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 noc_contact_email: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_location: Optional[pulumi.Input[str]] = None,
                 requested_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requested_link_count: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterconnectArgs.__new__(InterconnectArgs)

            __props__.__dict__["admin_enabled"] = admin_enabled
            __props__.__dict__["customer_name"] = customer_name
            __props__.__dict__["description"] = description
            if interconnect_type is None and not opts.urn:
                raise TypeError("Missing required property 'interconnect_type'")
            __props__.__dict__["interconnect_type"] = interconnect_type
            __props__.__dict__["labels"] = labels
            if link_type is None and not opts.urn:
                raise TypeError("Missing required property 'link_type'")
            __props__.__dict__["link_type"] = link_type
            __props__.__dict__["location"] = location
            __props__.__dict__["macsec"] = macsec
            __props__.__dict__["macsec_enabled"] = macsec_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["noc_contact_email"] = noc_contact_email
            __props__.__dict__["project"] = project
            __props__.__dict__["remote_location"] = remote_location
            __props__.__dict__["requested_features"] = requested_features
            if requested_link_count is None and not opts.urn:
                raise TypeError("Missing required property 'requested_link_count'")
            __props__.__dict__["requested_link_count"] = requested_link_count
            __props__.__dict__["available_features"] = None
            __props__.__dict__["circuit_infos"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["expected_outages"] = None
            __props__.__dict__["google_ip_address"] = None
            __props__.__dict__["google_reference_id"] = None
            __props__.__dict__["interconnect_attachments"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["operational_status"] = None
            __props__.__dict__["peer_ip_address"] = None
            __props__.__dict__["provisioned_link_count"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["satisfies_pzs"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Interconnect, __self__).__init__(
            'gcp:compute/interconnect:Interconnect',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_enabled: Optional[pulumi.Input[bool]] = None,
            available_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            circuit_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectCircuitInfoArgs', 'InterconnectCircuitInfoArgsDict']]]]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            customer_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            expected_outages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectExpectedOutageArgs', 'InterconnectExpectedOutageArgsDict']]]]] = None,
            google_ip_address: Optional[pulumi.Input[str]] = None,
            google_reference_id: Optional[pulumi.Input[str]] = None,
            interconnect_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            interconnect_type: Optional[pulumi.Input[str]] = None,
            label_fingerprint: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            link_type: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            macsec: Optional[pulumi.Input[Union['InterconnectMacsecArgs', 'InterconnectMacsecArgsDict']]] = None,
            macsec_enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            noc_contact_email: Optional[pulumi.Input[str]] = None,
            operational_status: Optional[pulumi.Input[str]] = None,
            peer_ip_address: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            provisioned_link_count: Optional[pulumi.Input[int]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            remote_location: Optional[pulumi.Input[str]] = None,
            requested_features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            requested_link_count: Optional[pulumi.Input[int]] = None,
            satisfies_pzs: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'Interconnect':
        """
        Get an existing Interconnect resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_enabled: Administrative status of the interconnect. When this is set to true, the Interconnect is
               functional and can carry traffic. When set to false, no packets can be carried over the
               interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] available_features: interconnects.list of features available for this Interconnect connection. Can take the value:
               MACSEC. If present then the Interconnect connection is provisioned on MACsec capable hardware
               ports. If not present then the Interconnect connection is provisioned on non-MACsec capable
               ports and MACsec isn't supported and enabling MACsec fails).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectCircuitInfoArgs', 'InterconnectCircuitInfoArgsDict']]]] circuit_infos: A list of CircuitInfo objects, that describe the individual circuits in this LAG.
               Structure is documented below.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] customer_name: Customer name, to put in the Letter of Authorization as the party authorized to request a
               crossconnect. This field is required for Dedicated and Partner Interconnect, should not be specified
               for cross-cloud interconnect.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectExpectedOutageArgs', 'InterconnectExpectedOutageArgsDict']]]] expected_outages: A list of outages expected for this Interconnect.
               Structure is documented below.
        :param pulumi.Input[str] google_ip_address: IP address configured on the Google side of the Interconnect link.
               This can be used only for ping tests.
        :param pulumi.Input[str] google_reference_id: Google reference ID to be used when raising support tickets with Google or otherwise to debug
               backend connectivity issues.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] interconnect_attachments: A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
        :param pulumi.Input[str] interconnect_type: Type of interconnect. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
               Can take one of the following values:
               - PARTNER: A partner-managed interconnection shared between customers though a partner.
               - DEDICATED: A dedicated physical interconnection with the customer.
               Possible values are: `DEDICATED`, `PARTNER`, `IT_PRIVATE`.
               
               
               - - -
        :param pulumi.Input[str] label_fingerprint: A fingerprint for the labels being applied to this Interconnect, which is essentially a hash
               of the labels set used for optimistic locking. The fingerprint is initially generated by
               Compute Engine and changes after every request to modify or update labels.
               You must always provide an up-to-date fingerprint hash in order to update or change labels,
               otherwise the request will fail with error 412 conditionNotMet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for this resource. These can only be added or modified by the setLabels
               method. Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] link_type: Type of link requested. Note that this field indicates the speed of each of the links in the
               bundle, not the speed of the entire bundle. Can take one of the following values:
               - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics.
               - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
               Possible values are: `LINK_TYPE_ETHERNET_10G_LR`, `LINK_TYPE_ETHERNET_100G_LR`.
        :param pulumi.Input[str] location: URL of the InterconnectLocation object that represents where this connection is to be provisioned.
               Specifies the location inside Google's Networks, should not be passed in case of cross-cloud interconnect.
        :param pulumi.Input[Union['InterconnectMacsecArgs', 'InterconnectMacsecArgsDict']] macsec: Configuration that enables Media Access Control security (MACsec) on the Cloud
               Interconnect connection between Google and your on-premises router.
               Structure is documented below.
        :param pulumi.Input[bool] macsec_enabled: Enable or disable MACsec on this Interconnect connection.
               MACsec enablement fails if the MACsec object is not specified.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] noc_contact_email: Email address to contact the customer NOC for operations and maintenance notifications
               regarding this Interconnect. If specified, this will be used for notifications in addition to
               all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications.
               This field is required for users who sign up for Cloud Interconnect using workforce identity
               federation.
        :param pulumi.Input[str] operational_status: The current status of this Interconnect's functionality, which can take one of the following:
               - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may
               be provisioned on this Interconnect.
               - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be
               provisioned on this Interconnect.
               - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No
               attachments may be provisioned or updated on this Interconnect.
        :param pulumi.Input[str] peer_ip_address: IP address configured on the customer side of the Interconnect link.
               The customer should configure this IP address during turnup when prompted by Google NOC.
               This can be used only for ping tests.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] provisioned_link_count: Number of links actually provisioned in this interconnect.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] remote_location: Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside
               of Google's network that the interconnect is connected to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested_features: interconnects.list of features requested for this Interconnect connection. Options: IF_MACSEC (
               If specified then the connection is created on MACsec capable hardware ports. If not
               specified, the default value is false, which allocates non-MACsec capable ports first if
               available). Note that MACSEC is still technically allowed for compatibility reasons, but it
               does not work with the API, and will be removed in an upcoming major version.
               Each value may be one of: `MACSEC`, `IF_MACSEC`.
        :param pulumi.Input[int] requested_link_count: Target number of physical links in the link bundle, as requested by the customer.
        :param pulumi.Input[bool] satisfies_pzs: Reserved for future use.
        :param pulumi.Input[str] state: (Output)
               State of this notification. Note that the versions of this enum prefixed with "NS_" have
               been deprecated in favor of the unprefixed values. Can take one of the following values:
               - ACTIVE: This outage notification is active. The event could be in the past, present,
               or future. See startTime and endTime for scheduling.
               - CANCELLED: The outage associated with this notification was cancelled before the
               outage was due to start.
               - COMPLETED: The outage associated with this notification is complete.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterconnectState.__new__(_InterconnectState)

        __props__.__dict__["admin_enabled"] = admin_enabled
        __props__.__dict__["available_features"] = available_features
        __props__.__dict__["circuit_infos"] = circuit_infos
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["customer_name"] = customer_name
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["expected_outages"] = expected_outages
        __props__.__dict__["google_ip_address"] = google_ip_address
        __props__.__dict__["google_reference_id"] = google_reference_id
        __props__.__dict__["interconnect_attachments"] = interconnect_attachments
        __props__.__dict__["interconnect_type"] = interconnect_type
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["link_type"] = link_type
        __props__.__dict__["location"] = location
        __props__.__dict__["macsec"] = macsec
        __props__.__dict__["macsec_enabled"] = macsec_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["noc_contact_email"] = noc_contact_email
        __props__.__dict__["operational_status"] = operational_status
        __props__.__dict__["peer_ip_address"] = peer_ip_address
        __props__.__dict__["project"] = project
        __props__.__dict__["provisioned_link_count"] = provisioned_link_count
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["remote_location"] = remote_location
        __props__.__dict__["requested_features"] = requested_features
        __props__.__dict__["requested_link_count"] = requested_link_count
        __props__.__dict__["satisfies_pzs"] = satisfies_pzs
        __props__.__dict__["state"] = state
        return Interconnect(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Administrative status of the interconnect. When this is set to true, the Interconnect is
        functional and can carry traffic. When set to false, no packets can be carried over the
        interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
        """
        return pulumi.get(self, "admin_enabled")

    @property
    @pulumi.getter(name="availableFeatures")
    def available_features(self) -> pulumi.Output[Sequence[str]]:
        """
        interconnects.list of features available for this Interconnect connection. Can take the value:
        MACSEC. If present then the Interconnect connection is provisioned on MACsec capable hardware
        ports. If not present then the Interconnect connection is provisioned on non-MACsec capable
        ports and MACsec isn't supported and enabling MACsec fails).
        """
        return pulumi.get(self, "available_features")

    @property
    @pulumi.getter(name="circuitInfos")
    def circuit_infos(self) -> pulumi.Output[Sequence['outputs.InterconnectCircuitInfo']]:
        """
        A list of CircuitInfo objects, that describe the individual circuits in this LAG.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_infos")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> pulumi.Output[Optional[str]]:
        """
        Customer name, to put in the Letter of Authorization as the party authorized to request a
        crossconnect. This field is required for Dedicated and Partner Interconnect, should not be specified
        for cross-cloud interconnect.
        """
        return pulumi.get(self, "customer_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="expectedOutages")
    def expected_outages(self) -> pulumi.Output[Sequence['outputs.InterconnectExpectedOutage']]:
        """
        A list of outages expected for this Interconnect.
        Structure is documented below.
        """
        return pulumi.get(self, "expected_outages")

    @property
    @pulumi.getter(name="googleIpAddress")
    def google_ip_address(self) -> pulumi.Output[str]:
        """
        IP address configured on the Google side of the Interconnect link.
        This can be used only for ping tests.
        """
        return pulumi.get(self, "google_ip_address")

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> pulumi.Output[str]:
        """
        Google reference ID to be used when raising support tickets with Google or otherwise to debug
        backend connectivity issues.
        """
        return pulumi.get(self, "google_reference_id")

    @property
    @pulumi.getter(name="interconnectAttachments")
    def interconnect_attachments(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
        """
        return pulumi.get(self, "interconnect_attachments")

    @property
    @pulumi.getter(name="interconnectType")
    def interconnect_type(self) -> pulumi.Output[str]:
        """
        Type of interconnect. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
        Can take one of the following values:
        - PARTNER: A partner-managed interconnection shared between customers though a partner.
        - DEDICATED: A dedicated physical interconnection with the customer.
        Possible values are: `DEDICATED`, `PARTNER`, `IT_PRIVATE`.


        - - -
        """
        return pulumi.get(self, "interconnect_type")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        A fingerprint for the labels being applied to this Interconnect, which is essentially a hash
        of the labels set used for optimistic locking. The fingerprint is initially generated by
        Compute Engine and changes after every request to modify or update labels.
        You must always provide an up-to-date fingerprint hash in order to update or change labels,
        otherwise the request will fail with error 412 conditionNotMet.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels
        method. Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linkType")
    def link_type(self) -> pulumi.Output[str]:
        """
        Type of link requested. Note that this field indicates the speed of each of the links in the
        bundle, not the speed of the entire bundle. Can take one of the following values:
        - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics.
        - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics.
        Possible values are: `LINK_TYPE_ETHERNET_10G_LR`, `LINK_TYPE_ETHERNET_100G_LR`.
        """
        return pulumi.get(self, "link_type")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        URL of the InterconnectLocation object that represents where this connection is to be provisioned.
        Specifies the location inside Google's Networks, should not be passed in case of cross-cloud interconnect.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def macsec(self) -> pulumi.Output[Optional['outputs.InterconnectMacsec']]:
        """
        Configuration that enables Media Access Control security (MACsec) on the Cloud
        Interconnect connection between Google and your on-premises router.
        Structure is documented below.
        """
        return pulumi.get(self, "macsec")

    @property
    @pulumi.getter(name="macsecEnabled")
    def macsec_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable or disable MACsec on this Interconnect connection.
        MACsec enablement fails if the MACsec object is not specified.
        """
        return pulumi.get(self, "macsec_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nocContactEmail")
    def noc_contact_email(self) -> pulumi.Output[Optional[str]]:
        """
        Email address to contact the customer NOC for operations and maintenance notifications
        regarding this Interconnect. If specified, this will be used for notifications in addition to
        all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications.
        This field is required for users who sign up for Cloud Interconnect using workforce identity
        federation.
        """
        return pulumi.get(self, "noc_contact_email")

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> pulumi.Output[str]:
        """
        The current status of this Interconnect's functionality, which can take one of the following:
        - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may
        be provisioned on this Interconnect.
        - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be
        provisioned on this Interconnect.
        - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No
        attachments may be provisioned or updated on this Interconnect.
        """
        return pulumi.get(self, "operational_status")

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> pulumi.Output[str]:
        """
        IP address configured on the customer side of the Interconnect link.
        The customer should configure this IP address during turnup when prompted by Google NOC.
        This can be used only for ping tests.
        """
        return pulumi.get(self, "peer_ip_address")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="provisionedLinkCount")
    def provisioned_link_count(self) -> pulumi.Output[int]:
        """
        Number of links actually provisioned in this interconnect.
        """
        return pulumi.get(self, "provisioned_link_count")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="remoteLocation")
    def remote_location(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates that this is a Cross-Cloud Interconnect. This field specifies the location outside
        of Google's network that the interconnect is connected to.
        """
        return pulumi.get(self, "remote_location")

    @property
    @pulumi.getter(name="requestedFeatures")
    def requested_features(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        interconnects.list of features requested for this Interconnect connection. Options: IF_MACSEC (
        If specified then the connection is created on MACsec capable hardware ports. If not
        specified, the default value is false, which allocates non-MACsec capable ports first if
        available). Note that MACSEC is still technically allowed for compatibility reasons, but it
        does not work with the API, and will be removed in an upcoming major version.
        Each value may be one of: `MACSEC`, `IF_MACSEC`.
        """
        return pulumi.get(self, "requested_features")

    @property
    @pulumi.getter(name="requestedLinkCount")
    def requested_link_count(self) -> pulumi.Output[int]:
        """
        Target number of physical links in the link bundle, as requested by the customer.
        """
        return pulumi.get(self, "requested_link_count")

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> pulumi.Output[bool]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Output)
        State of this notification. Note that the versions of this enum prefixed with "NS_" have
        been deprecated in favor of the unprefixed values. Can take one of the following values:
        - ACTIVE: This outage notification is active. The event could be in the past, present,
        or future. See startTime and endTime for scheduling.
        - CANCELLED: The outage associated with this notification was cancelled before the
        outage was due to start.
        - COMPLETED: The outage associated with this notification is complete.
        """
        return pulumi.get(self, "state")

