# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegionNetworkEndpointArgs', 'RegionNetworkEndpoint']

@pulumi.input_type
class RegionNetworkEndpointArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 region_network_endpoint_group: pulumi.Input[str],
                 client_destination_port: Optional[pulumi.Input[int]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RegionNetworkEndpoint resource.
        :param pulumi.Input[int] port: Port number of network endpoint.
        :param pulumi.Input[str] region_network_endpoint_group: The network endpoint group this endpoint is part of.
               
               
               - - -
        :param pulumi.Input[int] client_destination_port: Client destination port for the `GCE_VM_IP_PORTMAP` NEG.
        :param pulumi.Input[str] fqdn: Fully qualified domain name of network endpoint.
               This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
        :param pulumi.Input[str] instance: The name for a specific VM instance that the IP address belongs to.
               This is required for network endpoints of type GCE_VM_IP_PORTMAP.
        :param pulumi.Input[str] ip_address: IPv4 address external endpoint.
               This can only be specified when network_endpoint_type of the NEG is INTERNET_IP_PORT.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the containing network endpoint group is located.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "region_network_endpoint_group", region_network_endpoint_group)
        if client_destination_port is not None:
            pulumi.set(__self__, "client_destination_port", client_destination_port)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Port number of network endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="regionNetworkEndpointGroup")
    def region_network_endpoint_group(self) -> pulumi.Input[str]:
        """
        The network endpoint group this endpoint is part of.


        - - -
        """
        return pulumi.get(self, "region_network_endpoint_group")

    @region_network_endpoint_group.setter
    def region_network_endpoint_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_network_endpoint_group", value)

    @property
    @pulumi.getter(name="clientDestinationPort")
    def client_destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        Client destination port for the `GCE_VM_IP_PORTMAP` NEG.
        """
        return pulumi.get(self, "client_destination_port")

    @client_destination_port.setter
    def client_destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_destination_port", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified domain name of network endpoint.
        This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[str]]:
        """
        The name for a specific VM instance that the IP address belongs to.
        This is required for network endpoints of type GCE_VM_IP_PORTMAP.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address external endpoint.
        This can only be specified when network_endpoint_type of the NEG is INTERNET_IP_PORT.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the containing network endpoint group is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RegionNetworkEndpointState:
    def __init__(__self__, *,
                 client_destination_port: Optional[pulumi.Input[int]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_network_endpoint_group: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RegionNetworkEndpoint resources.
        :param pulumi.Input[int] client_destination_port: Client destination port for the `GCE_VM_IP_PORTMAP` NEG.
        :param pulumi.Input[str] fqdn: Fully qualified domain name of network endpoint.
               This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
        :param pulumi.Input[str] instance: The name for a specific VM instance that the IP address belongs to.
               This is required for network endpoints of type GCE_VM_IP_PORTMAP.
        :param pulumi.Input[str] ip_address: IPv4 address external endpoint.
               This can only be specified when network_endpoint_type of the NEG is INTERNET_IP_PORT.
        :param pulumi.Input[int] port: Port number of network endpoint.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the containing network endpoint group is located.
        :param pulumi.Input[str] region_network_endpoint_group: The network endpoint group this endpoint is part of.
               
               
               - - -
        """
        if client_destination_port is not None:
            pulumi.set(__self__, "client_destination_port", client_destination_port)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_network_endpoint_group is not None:
            pulumi.set(__self__, "region_network_endpoint_group", region_network_endpoint_group)

    @property
    @pulumi.getter(name="clientDestinationPort")
    def client_destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        Client destination port for the `GCE_VM_IP_PORTMAP` NEG.
        """
        return pulumi.get(self, "client_destination_port")

    @client_destination_port.setter
    def client_destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_destination_port", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified domain name of network endpoint.
        This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[str]]:
        """
        The name for a specific VM instance that the IP address belongs to.
        This is required for network endpoints of type GCE_VM_IP_PORTMAP.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address external endpoint.
        This can only be specified when network_endpoint_type of the NEG is INTERNET_IP_PORT.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number of network endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the containing network endpoint group is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="regionNetworkEndpointGroup")
    def region_network_endpoint_group(self) -> Optional[pulumi.Input[str]]:
        """
        The network endpoint group this endpoint is part of.


        - - -
        """
        return pulumi.get(self, "region_network_endpoint_group")

    @region_network_endpoint_group.setter
    def region_network_endpoint_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_network_endpoint_group", value)


class RegionNetworkEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_destination_port: Optional[pulumi.Input[int]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_network_endpoint_group: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Region network endpoint represents a IP address/FQDN and port combination that is
        part of a specific network endpoint group (NEG).

        > **NOTE**: Network endpoints cannot be created outside of a network endpoint group.

        To get more information about RegionNetworkEndpoint, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/regionNetworkEndpointGroups)
        * How-to Guides
            * [Internet NEGs Official Documentation](https://cloud.google.com/load-balancing/docs/negs/internet-neg-concepts)
            * [Official Documentation](https://cloud.google.com/load-balancing/docs/negs/)

        ## Example Usage

        ### Region Network Endpoint Internet Ip Port

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network",
            auto_create_subnetworks=False)
        group = gcp.compute.RegionNetworkEndpointGroup("group",
            name="ip-port-neg",
            network=default.id,
            region="us-central1",
            network_endpoint_type="INTERNET_IP_PORT")
        region_internet_ip_port_endpoint = gcp.compute.RegionNetworkEndpoint("region-internet-ip-port-endpoint",
            region_network_endpoint_group=group.name,
            region="us-central1",
            ip_address="8.8.8.8",
            port=443)
        ```
        ### Region Network Endpoint Internet Fqdn Port

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network",
            auto_create_subnetworks=False)
        group = gcp.compute.RegionNetworkEndpointGroup("group",
            name="fqdn-port-neg",
            network=default.id,
            region="us-central1",
            network_endpoint_type="INTERNET_FQDN_PORT")
        region_internet_fqdn_port_endpoint = gcp.compute.RegionNetworkEndpoint("region-internet-fqdn-port-endpoint",
            region_network_endpoint_group=group.name,
            region="us-central1",
            fqdn="backend.example.com",
            port=443)
        ```
        ### Region Network Endpoint Portmap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="subnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default.id)
        default_region_network_endpoint_group = gcp.compute.RegionNetworkEndpointGroup("default",
            name="portmap-neg",
            region="us-central1",
            network=default.id,
            subnetwork=default_subnetwork.id,
            network_endpoint_type="GCE_VM_IP_PORTMAP")
        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        default_instance = gcp.compute.Instance("default",
            network_interfaces=[{
                "access_configs": [{}],
                "subnetwork": default_subnetwork.id,
            }],
            name="instance",
            machine_type="e2-medium",
            zone="us-central1-a",
            boot_disk={
                "initialize_params": {
                    "image": my_image.self_link,
                },
            })
        region_network_endpoint_portmap = gcp.compute.RegionNetworkEndpoint("region_network_endpoint_portmap",
            region_network_endpoint_group=default_region_network_endpoint_group.name,
            region="us-central1",
            instance=default_instance.self_link,
            port=80,
            ip_address=default_instance.network_interfaces[0].network_ip,
            client_destination_port=8080)
        ```

        ## Import

        RegionNetworkEndpoint can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/networkEndpointGroups/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}`

        * `{{project}}/{{region}}/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}`

        * `{{region}}/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}`

        * `{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}`

        When using the `pulumi import` command, RegionNetworkEndpoint can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint default projects/{{project}}/regions/{{region}}/networkEndpointGroups/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint default {{project}}/{{region}}/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint default {{region}}/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint default {{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] client_destination_port: Client destination port for the `GCE_VM_IP_PORTMAP` NEG.
        :param pulumi.Input[str] fqdn: Fully qualified domain name of network endpoint.
               This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
        :param pulumi.Input[str] instance: The name for a specific VM instance that the IP address belongs to.
               This is required for network endpoints of type GCE_VM_IP_PORTMAP.
        :param pulumi.Input[str] ip_address: IPv4 address external endpoint.
               This can only be specified when network_endpoint_type of the NEG is INTERNET_IP_PORT.
        :param pulumi.Input[int] port: Port number of network endpoint.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the containing network endpoint group is located.
        :param pulumi.Input[str] region_network_endpoint_group: The network endpoint group this endpoint is part of.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionNetworkEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Region network endpoint represents a IP address/FQDN and port combination that is
        part of a specific network endpoint group (NEG).

        > **NOTE**: Network endpoints cannot be created outside of a network endpoint group.

        To get more information about RegionNetworkEndpoint, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/regionNetworkEndpointGroups)
        * How-to Guides
            * [Internet NEGs Official Documentation](https://cloud.google.com/load-balancing/docs/negs/internet-neg-concepts)
            * [Official Documentation](https://cloud.google.com/load-balancing/docs/negs/)

        ## Example Usage

        ### Region Network Endpoint Internet Ip Port

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network",
            auto_create_subnetworks=False)
        group = gcp.compute.RegionNetworkEndpointGroup("group",
            name="ip-port-neg",
            network=default.id,
            region="us-central1",
            network_endpoint_type="INTERNET_IP_PORT")
        region_internet_ip_port_endpoint = gcp.compute.RegionNetworkEndpoint("region-internet-ip-port-endpoint",
            region_network_endpoint_group=group.name,
            region="us-central1",
            ip_address="8.8.8.8",
            port=443)
        ```
        ### Region Network Endpoint Internet Fqdn Port

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network",
            auto_create_subnetworks=False)
        group = gcp.compute.RegionNetworkEndpointGroup("group",
            name="fqdn-port-neg",
            network=default.id,
            region="us-central1",
            network_endpoint_type="INTERNET_FQDN_PORT")
        region_internet_fqdn_port_endpoint = gcp.compute.RegionNetworkEndpoint("region-internet-fqdn-port-endpoint",
            region_network_endpoint_group=group.name,
            region="us-central1",
            fqdn="backend.example.com",
            port=443)
        ```
        ### Region Network Endpoint Portmap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="subnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default.id)
        default_region_network_endpoint_group = gcp.compute.RegionNetworkEndpointGroup("default",
            name="portmap-neg",
            region="us-central1",
            network=default.id,
            subnetwork=default_subnetwork.id,
            network_endpoint_type="GCE_VM_IP_PORTMAP")
        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        default_instance = gcp.compute.Instance("default",
            network_interfaces=[{
                "access_configs": [{}],
                "subnetwork": default_subnetwork.id,
            }],
            name="instance",
            machine_type="e2-medium",
            zone="us-central1-a",
            boot_disk={
                "initialize_params": {
                    "image": my_image.self_link,
                },
            })
        region_network_endpoint_portmap = gcp.compute.RegionNetworkEndpoint("region_network_endpoint_portmap",
            region_network_endpoint_group=default_region_network_endpoint_group.name,
            region="us-central1",
            instance=default_instance.self_link,
            port=80,
            ip_address=default_instance.network_interfaces[0].network_ip,
            client_destination_port=8080)
        ```

        ## Import

        RegionNetworkEndpoint can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/networkEndpointGroups/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}`

        * `{{project}}/{{region}}/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}`

        * `{{region}}/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}`

        * `{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}`

        When using the `pulumi import` command, RegionNetworkEndpoint can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint default projects/{{project}}/regions/{{region}}/networkEndpointGroups/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint default {{project}}/{{region}}/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint default {{region}}/{{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint default {{region_network_endpoint_group}}/{{ip_address}}/{{fqdn}}/{{port}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionNetworkEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionNetworkEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_destination_port: Optional[pulumi.Input[int]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 region_network_endpoint_group: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionNetworkEndpointArgs.__new__(RegionNetworkEndpointArgs)

            __props__.__dict__["client_destination_port"] = client_destination_port
            __props__.__dict__["fqdn"] = fqdn
            __props__.__dict__["instance"] = instance
            __props__.__dict__["ip_address"] = ip_address
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if region_network_endpoint_group is None and not opts.urn:
                raise TypeError("Missing required property 'region_network_endpoint_group'")
            __props__.__dict__["region_network_endpoint_group"] = region_network_endpoint_group
        super(RegionNetworkEndpoint, __self__).__init__(
            'gcp:compute/regionNetworkEndpoint:RegionNetworkEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_destination_port: Optional[pulumi.Input[int]] = None,
            fqdn: Optional[pulumi.Input[str]] = None,
            instance: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            region_network_endpoint_group: Optional[pulumi.Input[str]] = None) -> 'RegionNetworkEndpoint':
        """
        Get an existing RegionNetworkEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] client_destination_port: Client destination port for the `GCE_VM_IP_PORTMAP` NEG.
        :param pulumi.Input[str] fqdn: Fully qualified domain name of network endpoint.
               This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
        :param pulumi.Input[str] instance: The name for a specific VM instance that the IP address belongs to.
               This is required for network endpoints of type GCE_VM_IP_PORTMAP.
        :param pulumi.Input[str] ip_address: IPv4 address external endpoint.
               This can only be specified when network_endpoint_type of the NEG is INTERNET_IP_PORT.
        :param pulumi.Input[int] port: Port number of network endpoint.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the containing network endpoint group is located.
        :param pulumi.Input[str] region_network_endpoint_group: The network endpoint group this endpoint is part of.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionNetworkEndpointState.__new__(_RegionNetworkEndpointState)

        __props__.__dict__["client_destination_port"] = client_destination_port
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["instance"] = instance
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["port"] = port
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["region_network_endpoint_group"] = region_network_endpoint_group
        return RegionNetworkEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientDestinationPort")
    def client_destination_port(self) -> pulumi.Output[Optional[int]]:
        """
        Client destination port for the `GCE_VM_IP_PORTMAP` NEG.
        """
        return pulumi.get(self, "client_destination_port")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[Optional[str]]:
        """
        Fully qualified domain name of network endpoint.
        This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[Optional[str]]:
        """
        The name for a specific VM instance that the IP address belongs to.
        This is required for network endpoints of type GCE_VM_IP_PORTMAP.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        IPv4 address external endpoint.
        This can only be specified when network_endpoint_type of the NEG is INTERNET_IP_PORT.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Port number of network endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region where the containing network endpoint group is located.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="regionNetworkEndpointGroup")
    def region_network_endpoint_group(self) -> pulumi.Output[str]:
        """
        The network endpoint group this endpoint is part of.


        - - -
        """
        return pulumi.get(self, "region_network_endpoint_group")

