# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionNetworkEndpointGroupArgs', 'RegionNetworkEndpointGroup']

@pulumi.input_type
class RegionNetworkEndpointGroupArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 app_engine: Optional[pulumi.Input['RegionNetworkEndpointGroupAppEngineArgs']] = None,
                 cloud_function: Optional[pulumi.Input['RegionNetworkEndpointGroupCloudFunctionArgs']] = None,
                 cloud_run: Optional[pulumi.Input['RegionNetworkEndpointGroupCloudRunArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_endpoint_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_target_service: Optional[pulumi.Input[str]] = None,
                 serverless_deployment: Optional[pulumi.Input['RegionNetworkEndpointGroupServerlessDeploymentArgs']] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RegionNetworkEndpointGroup resource.
        :param pulumi.Input[str] region: A reference to the region where the regional NEGs reside.
               
               
               - - -
        :param pulumi.Input['RegionNetworkEndpointGroupAppEngineArgs'] app_engine: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input['RegionNetworkEndpointGroupCloudFunctionArgs'] cloud_function: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input['RegionNetworkEndpointGroupCloudRunArgs'] cloud_run: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] network: This field is only used for PSC and INTERNET NEGs.
               The URL of the network to which all network endpoints in the NEG belong. Uses
               "default" project network if unspecified.
        :param pulumi.Input[str] network_endpoint_type: Type of network endpoints in this network endpoint group. Defaults to SERVERLESS.
               Default value is `SERVERLESS`.
               Possible values are: `SERVERLESS`, `PRIVATE_SERVICE_CONNECT`, `INTERNET_IP_PORT`, `INTERNET_FQDN_PORT`, `GCE_VM_IP_PORTMAP`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] psc_target_service: This field is only used for PSC and INTERNET NEGs.
               The target service url used to set up private service connection to
               a Google API or a PSC Producer Service Attachment.
        :param pulumi.Input['RegionNetworkEndpointGroupServerlessDeploymentArgs'] serverless_deployment: This field is only used for SERVERLESS NEGs.
               Only one of cloudRun, appEngine, cloudFunction or serverlessDeployment may be set.
               Structure is documented below.
        :param pulumi.Input[str] subnetwork: This field is only used for PSC NEGs.
               Optional URL of the subnetwork to which all network endpoints in the NEG belong.
        """
        pulumi.set(__self__, "region", region)
        if app_engine is not None:
            pulumi.set(__self__, "app_engine", app_engine)
        if cloud_function is not None:
            pulumi.set(__self__, "cloud_function", cloud_function)
        if cloud_run is not None:
            pulumi.set(__self__, "cloud_run", cloud_run)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_endpoint_type is not None:
            pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_target_service is not None:
            pulumi.set(__self__, "psc_target_service", psc_target_service)
        if serverless_deployment is not None:
            pulumi.set(__self__, "serverless_deployment", serverless_deployment)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        A reference to the region where the regional NEGs reside.


        - - -
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="appEngine")
    def app_engine(self) -> Optional[pulumi.Input['RegionNetworkEndpointGroupAppEngineArgs']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "app_engine")

    @app_engine.setter
    def app_engine(self, value: Optional[pulumi.Input['RegionNetworkEndpointGroupAppEngineArgs']]):
        pulumi.set(self, "app_engine", value)

    @property
    @pulumi.getter(name="cloudFunction")
    def cloud_function(self) -> Optional[pulumi.Input['RegionNetworkEndpointGroupCloudFunctionArgs']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_function")

    @cloud_function.setter
    def cloud_function(self, value: Optional[pulumi.Input['RegionNetworkEndpointGroupCloudFunctionArgs']]):
        pulumi.set(self, "cloud_function", value)

    @property
    @pulumi.getter(name="cloudRun")
    def cloud_run(self) -> Optional[pulumi.Input['RegionNetworkEndpointGroupCloudRunArgs']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_run")

    @cloud_run.setter
    def cloud_run(self, value: Optional[pulumi.Input['RegionNetworkEndpointGroupCloudRunArgs']]):
        pulumi.set(self, "cloud_run", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        This field is only used for PSC and INTERNET NEGs.
        The URL of the network to which all network endpoints in the NEG belong. Uses
        "default" project network if unspecified.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of network endpoints in this network endpoint group. Defaults to SERVERLESS.
        Default value is `SERVERLESS`.
        Possible values are: `SERVERLESS`, `PRIVATE_SERVICE_CONNECT`, `INTERNET_IP_PORT`, `INTERNET_FQDN_PORT`, `GCE_VM_IP_PORTMAP`.
        """
        return pulumi.get(self, "network_endpoint_type")

    @network_endpoint_type.setter
    def network_endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_endpoint_type", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscTargetService")
    def psc_target_service(self) -> Optional[pulumi.Input[str]]:
        """
        This field is only used for PSC and INTERNET NEGs.
        The target service url used to set up private service connection to
        a Google API or a PSC Producer Service Attachment.
        """
        return pulumi.get(self, "psc_target_service")

    @psc_target_service.setter
    def psc_target_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psc_target_service", value)

    @property
    @pulumi.getter(name="serverlessDeployment")
    def serverless_deployment(self) -> Optional[pulumi.Input['RegionNetworkEndpointGroupServerlessDeploymentArgs']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloudRun, appEngine, cloudFunction or serverlessDeployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "serverless_deployment")

    @serverless_deployment.setter
    def serverless_deployment(self, value: Optional[pulumi.Input['RegionNetworkEndpointGroupServerlessDeploymentArgs']]):
        pulumi.set(self, "serverless_deployment", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        This field is only used for PSC NEGs.
        Optional URL of the subnetwork to which all network endpoints in the NEG belong.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class _RegionNetworkEndpointGroupState:
    def __init__(__self__, *,
                 app_engine: Optional[pulumi.Input['RegionNetworkEndpointGroupAppEngineArgs']] = None,
                 cloud_function: Optional[pulumi.Input['RegionNetworkEndpointGroupCloudFunctionArgs']] = None,
                 cloud_run: Optional[pulumi.Input['RegionNetworkEndpointGroupCloudRunArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_endpoint_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_target_service: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 serverless_deployment: Optional[pulumi.Input['RegionNetworkEndpointGroupServerlessDeploymentArgs']] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RegionNetworkEndpointGroup resources.
        :param pulumi.Input['RegionNetworkEndpointGroupAppEngineArgs'] app_engine: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input['RegionNetworkEndpointGroupCloudFunctionArgs'] cloud_function: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input['RegionNetworkEndpointGroupCloudRunArgs'] cloud_run: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] network: This field is only used for PSC and INTERNET NEGs.
               The URL of the network to which all network endpoints in the NEG belong. Uses
               "default" project network if unspecified.
        :param pulumi.Input[str] network_endpoint_type: Type of network endpoints in this network endpoint group. Defaults to SERVERLESS.
               Default value is `SERVERLESS`.
               Possible values are: `SERVERLESS`, `PRIVATE_SERVICE_CONNECT`, `INTERNET_IP_PORT`, `INTERNET_FQDN_PORT`, `GCE_VM_IP_PORTMAP`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] psc_target_service: This field is only used for PSC and INTERNET NEGs.
               The target service url used to set up private service connection to
               a Google API or a PSC Producer Service Attachment.
        :param pulumi.Input[str] region: A reference to the region where the regional NEGs reside.
               
               
               - - -
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input['RegionNetworkEndpointGroupServerlessDeploymentArgs'] serverless_deployment: This field is only used for SERVERLESS NEGs.
               Only one of cloudRun, appEngine, cloudFunction or serverlessDeployment may be set.
               Structure is documented below.
        :param pulumi.Input[str] subnetwork: This field is only used for PSC NEGs.
               Optional URL of the subnetwork to which all network endpoints in the NEG belong.
        """
        if app_engine is not None:
            pulumi.set(__self__, "app_engine", app_engine)
        if cloud_function is not None:
            pulumi.set(__self__, "cloud_function", cloud_function)
        if cloud_run is not None:
            pulumi.set(__self__, "cloud_run", cloud_run)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_endpoint_type is not None:
            pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if psc_target_service is not None:
            pulumi.set(__self__, "psc_target_service", psc_target_service)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if serverless_deployment is not None:
            pulumi.set(__self__, "serverless_deployment", serverless_deployment)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="appEngine")
    def app_engine(self) -> Optional[pulumi.Input['RegionNetworkEndpointGroupAppEngineArgs']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "app_engine")

    @app_engine.setter
    def app_engine(self, value: Optional[pulumi.Input['RegionNetworkEndpointGroupAppEngineArgs']]):
        pulumi.set(self, "app_engine", value)

    @property
    @pulumi.getter(name="cloudFunction")
    def cloud_function(self) -> Optional[pulumi.Input['RegionNetworkEndpointGroupCloudFunctionArgs']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_function")

    @cloud_function.setter
    def cloud_function(self, value: Optional[pulumi.Input['RegionNetworkEndpointGroupCloudFunctionArgs']]):
        pulumi.set(self, "cloud_function", value)

    @property
    @pulumi.getter(name="cloudRun")
    def cloud_run(self) -> Optional[pulumi.Input['RegionNetworkEndpointGroupCloudRunArgs']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_run")

    @cloud_run.setter
    def cloud_run(self, value: Optional[pulumi.Input['RegionNetworkEndpointGroupCloudRunArgs']]):
        pulumi.set(self, "cloud_run", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        This field is only used for PSC and INTERNET NEGs.
        The URL of the network to which all network endpoints in the NEG belong. Uses
        "default" project network if unspecified.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of network endpoints in this network endpoint group. Defaults to SERVERLESS.
        Default value is `SERVERLESS`.
        Possible values are: `SERVERLESS`, `PRIVATE_SERVICE_CONNECT`, `INTERNET_IP_PORT`, `INTERNET_FQDN_PORT`, `GCE_VM_IP_PORTMAP`.
        """
        return pulumi.get(self, "network_endpoint_type")

    @network_endpoint_type.setter
    def network_endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_endpoint_type", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pscTargetService")
    def psc_target_service(self) -> Optional[pulumi.Input[str]]:
        """
        This field is only used for PSC and INTERNET NEGs.
        The target service url used to set up private service connection to
        a Google API or a PSC Producer Service Attachment.
        """
        return pulumi.get(self, "psc_target_service")

    @psc_target_service.setter
    def psc_target_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "psc_target_service", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to the region where the regional NEGs reside.


        - - -
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serverlessDeployment")
    def serverless_deployment(self) -> Optional[pulumi.Input['RegionNetworkEndpointGroupServerlessDeploymentArgs']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloudRun, appEngine, cloudFunction or serverlessDeployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "serverless_deployment")

    @serverless_deployment.setter
    def serverless_deployment(self, value: Optional[pulumi.Input['RegionNetworkEndpointGroupServerlessDeploymentArgs']]):
        pulumi.set(self, "serverless_deployment", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        This field is only used for PSC NEGs.
        Optional URL of the subnetwork to which all network endpoints in the NEG belong.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


class RegionNetworkEndpointGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupAppEngineArgs', 'RegionNetworkEndpointGroupAppEngineArgsDict']]] = None,
                 cloud_function: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupCloudFunctionArgs', 'RegionNetworkEndpointGroupCloudFunctionArgsDict']]] = None,
                 cloud_run: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupCloudRunArgs', 'RegionNetworkEndpointGroupCloudRunArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_endpoint_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_target_service: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 serverless_deployment: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupServerlessDeploymentArgs', 'RegionNetworkEndpointGroupServerlessDeploymentArgsDict']]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A regional NEG that can support Serverless Products, proxying traffic to
        external backends and providing traffic to the PSC port mapping endpoints.

        To get more information about RegionNetworkEndpointGroup, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/regionNetworkEndpointGroups)
        * How-to Guides
            * [Internet NEGs Official Documentation](https://cloud.google.com/load-balancing/docs/negs/internet-neg-concepts)
            * [Serverless NEGs Official Documentation](https://cloud.google.com/load-balancing/docs/negs/serverless-neg-concepts)

        ## Example Usage

        ### Region Network Endpoint Group Functions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="cloudfunctions-function-example-bucket",
            location="US")
        archive = gcp.storage.BucketObject("archive",
            name="index.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("path/to/index.zip"))
        function_neg_function = gcp.cloudfunctions.Function("function_neg",
            name="function-neg",
            description="My function",
            runtime="nodejs10",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            timeout=60,
            entry_point="helloGET")
        # Cloud Functions Example
        function_neg = gcp.compute.RegionNetworkEndpointGroup("function_neg",
            name="function-neg",
            network_endpoint_type="SERVERLESS",
            region="us-central1",
            cloud_function={
                "function": function_neg_function.name,
            })
        ```
        ### Region Network Endpoint Group Cloudrun

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cloudrun_neg_service = gcp.cloudrun.Service("cloudrun_neg",
            name="cloudrun-neg",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        # Cloud Run Example
        cloudrun_neg = gcp.compute.RegionNetworkEndpointGroup("cloudrun_neg",
            name="cloudrun-neg",
            network_endpoint_type="SERVERLESS",
            region="us-central1",
            cloud_run={
                "service": cloudrun_neg_service.name,
            })
        ```
        ### Region Network Endpoint Group Appengine

        ```python
        import pulumi
        import pulumi_gcp as gcp

        appengine_neg_bucket = gcp.storage.Bucket("appengine_neg",
            name="appengine-neg",
            location="US")
        appengine_neg_bucket_object = gcp.storage.BucketObject("appengine_neg",
            name="hello-world.zip",
            bucket=appengine_neg_bucket.name,
            source=pulumi.FileAsset("./test-fixtures/hello-world.zip"))
        appengine_neg_flexible_app_version = gcp.appengine.FlexibleAppVersion("appengine_neg",
            version_id="v1",
            service="appengine-network-endpoint-group",
            runtime="nodejs",
            flexible_runtime_settings={
                "operating_system": "ubuntu22",
                "runtime_version": "20",
            },
            entrypoint={
                "shell": "node ./app.js",
            },
            deployment={
                "zip": {
                    "source_url": pulumi.Output.all(
                        appengineNegBucketName=appengine_neg_bucket.name,
                        appengineNegBucketObjectName=appengine_neg_bucket_object.name
        ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['appengineNegBucketName']}/{resolved_outputs['appengineNegBucketObjectName']}")
        ,
                },
            },
            liveness_check={
                "path": "/",
            },
            readiness_check={
                "path": "/",
            },
            env_variables={
                "port": "8080",
            },
            handlers=[{
                "url_regex": ".*\\\\/my-path\\\\/*",
                "security_level": "SECURE_ALWAYS",
                "login": "LOGIN_REQUIRED",
                "auth_fail_action": "AUTH_FAIL_ACTION_REDIRECT",
                "static_files": {
                    "path": "my-other-path",
                    "upload_path_regex": ".*\\\\/my-path\\\\/*",
                },
            }],
            automatic_scaling={
                "cool_down_period": "120s",
                "cpu_utilization": {
                    "target_utilization": 0.5,
                },
            },
            delete_service_on_destroy=True)
        # App Engine Example
        appengine_neg = gcp.compute.RegionNetworkEndpointGroup("appengine_neg",
            name="appengine-neg",
            network_endpoint_type="SERVERLESS",
            region="us-central1",
            app_engine={
                "service": appengine_neg_flexible_app_version.service,
                "version": appengine_neg_flexible_app_version.version_id,
            })
        ```
        ### Region Network Endpoint Group Appengine Empty

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # App Engine Example
        appengine_neg = gcp.compute.RegionNetworkEndpointGroup("appengine_neg",
            name="appengine-neg",
            network_endpoint_type="SERVERLESS",
            region="us-central1",
            app_engine={})
        ```
        ### Region Network Endpoint Group Psc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        psc_neg = gcp.compute.RegionNetworkEndpointGroup("psc_neg",
            name="psc-neg",
            region="asia-northeast3",
            network_endpoint_type="PRIVATE_SERVICE_CONNECT",
            psc_target_service="asia-northeast3-cloudkms.googleapis.com")
        ```
        ### Region Network Endpoint Group Psc Service Attachment

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="psc-network")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="psc-subnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="europe-west4",
            network=default.id)
        psc_subnetwork = gcp.compute.Subnetwork("psc_subnetwork",
            name="psc-subnetwork-nat",
            ip_cidr_range="10.1.0.0/16",
            region="europe-west4",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=default.id)
        default_health_check = gcp.compute.HealthCheck("default",
            name="psc-healthcheck",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            name="psc-backend",
            region="europe-west4",
            health_checks=default_health_check.id)
        default_forwarding_rule = gcp.compute.ForwardingRule("default",
            name="psc-forwarding-rule",
            region="europe-west4",
            load_balancing_scheme="INTERNAL",
            backend_service=default_region_backend_service.id,
            all_ports=True,
            network=default.name,
            subnetwork=default_subnetwork.name)
        default_service_attachment = gcp.compute.ServiceAttachment("default",
            name="psc-service-attachment",
            region="europe-west4",
            description="A service attachment configured with Terraform",
            enable_proxy_protocol=False,
            connection_preference="ACCEPT_AUTOMATIC",
            nat_subnets=[psc_subnetwork.self_link],
            target_service=default_forwarding_rule.self_link)
        psc_neg_service_attachment = gcp.compute.RegionNetworkEndpointGroup("psc_neg_service_attachment",
            name="psc-neg",
            region="europe-west4",
            network_endpoint_type="PRIVATE_SERVICE_CONNECT",
            psc_target_service=default_service_attachment.self_link,
            network=default.self_link,
            subnetwork=default_subnetwork.self_link)
        ```
        ### Region Network Endpoint Group Internet Ip Port

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        region_network_endpoint_group_internet_ip_port = gcp.compute.RegionNetworkEndpointGroup("region_network_endpoint_group_internet_ip_port",
            name="ip-port-neg",
            region="us-central1",
            network=default.id,
            network_endpoint_type="INTERNET_IP_PORT")
        ```
        ### Region Network Endpoint Group Internet Fqdn Port

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        region_network_endpoint_group_internet_fqdn_port = gcp.compute.RegionNetworkEndpointGroup("region_network_endpoint_group_internet_fqdn_port",
            name="ip-port-neg",
            region="us-central1",
            network=default.id,
            network_endpoint_type="INTERNET_FQDN_PORT")
        ```
        ### Region Network Endpoint Group Portmap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="subnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default.id)
        region_network_endpoint_group_portmap = gcp.compute.RegionNetworkEndpointGroup("region_network_endpoint_group_portmap",
            name="portmap-neg",
            region="us-central1",
            network=default.id,
            subnetwork=default_subnetwork.id,
            network_endpoint_type="GCE_VM_IP_PORTMAP")
        ```

        ## Import

        RegionNetworkEndpointGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/networkEndpointGroups/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionNetworkEndpointGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup default projects/{{project}}/regions/{{region}}/networkEndpointGroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegionNetworkEndpointGroupAppEngineArgs', 'RegionNetworkEndpointGroupAppEngineArgsDict']] app_engine: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input[Union['RegionNetworkEndpointGroupCloudFunctionArgs', 'RegionNetworkEndpointGroupCloudFunctionArgsDict']] cloud_function: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input[Union['RegionNetworkEndpointGroupCloudRunArgs', 'RegionNetworkEndpointGroupCloudRunArgsDict']] cloud_run: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] network: This field is only used for PSC and INTERNET NEGs.
               The URL of the network to which all network endpoints in the NEG belong. Uses
               "default" project network if unspecified.
        :param pulumi.Input[str] network_endpoint_type: Type of network endpoints in this network endpoint group. Defaults to SERVERLESS.
               Default value is `SERVERLESS`.
               Possible values are: `SERVERLESS`, `PRIVATE_SERVICE_CONNECT`, `INTERNET_IP_PORT`, `INTERNET_FQDN_PORT`, `GCE_VM_IP_PORTMAP`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] psc_target_service: This field is only used for PSC and INTERNET NEGs.
               The target service url used to set up private service connection to
               a Google API or a PSC Producer Service Attachment.
        :param pulumi.Input[str] region: A reference to the region where the regional NEGs reside.
               
               
               - - -
        :param pulumi.Input[Union['RegionNetworkEndpointGroupServerlessDeploymentArgs', 'RegionNetworkEndpointGroupServerlessDeploymentArgsDict']] serverless_deployment: This field is only used for SERVERLESS NEGs.
               Only one of cloudRun, appEngine, cloudFunction or serverlessDeployment may be set.
               Structure is documented below.
        :param pulumi.Input[str] subnetwork: This field is only used for PSC NEGs.
               Optional URL of the subnetwork to which all network endpoints in the NEG belong.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionNetworkEndpointGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A regional NEG that can support Serverless Products, proxying traffic to
        external backends and providing traffic to the PSC port mapping endpoints.

        To get more information about RegionNetworkEndpointGroup, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/beta/regionNetworkEndpointGroups)
        * How-to Guides
            * [Internet NEGs Official Documentation](https://cloud.google.com/load-balancing/docs/negs/internet-neg-concepts)
            * [Serverless NEGs Official Documentation](https://cloud.google.com/load-balancing/docs/negs/serverless-neg-concepts)

        ## Example Usage

        ### Region Network Endpoint Group Functions

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="cloudfunctions-function-example-bucket",
            location="US")
        archive = gcp.storage.BucketObject("archive",
            name="index.zip",
            bucket=bucket.name,
            source=pulumi.FileAsset("path/to/index.zip"))
        function_neg_function = gcp.cloudfunctions.Function("function_neg",
            name="function-neg",
            description="My function",
            runtime="nodejs10",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            timeout=60,
            entry_point="helloGET")
        # Cloud Functions Example
        function_neg = gcp.compute.RegionNetworkEndpointGroup("function_neg",
            name="function-neg",
            network_endpoint_type="SERVERLESS",
            region="us-central1",
            cloud_function={
                "function": function_neg_function.name,
            })
        ```
        ### Region Network Endpoint Group Cloudrun

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cloudrun_neg_service = gcp.cloudrun.Service("cloudrun_neg",
            name="cloudrun-neg",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        # Cloud Run Example
        cloudrun_neg = gcp.compute.RegionNetworkEndpointGroup("cloudrun_neg",
            name="cloudrun-neg",
            network_endpoint_type="SERVERLESS",
            region="us-central1",
            cloud_run={
                "service": cloudrun_neg_service.name,
            })
        ```
        ### Region Network Endpoint Group Appengine

        ```python
        import pulumi
        import pulumi_gcp as gcp

        appengine_neg_bucket = gcp.storage.Bucket("appengine_neg",
            name="appengine-neg",
            location="US")
        appengine_neg_bucket_object = gcp.storage.BucketObject("appengine_neg",
            name="hello-world.zip",
            bucket=appengine_neg_bucket.name,
            source=pulumi.FileAsset("./test-fixtures/hello-world.zip"))
        appengine_neg_flexible_app_version = gcp.appengine.FlexibleAppVersion("appengine_neg",
            version_id="v1",
            service="appengine-network-endpoint-group",
            runtime="nodejs",
            flexible_runtime_settings={
                "operating_system": "ubuntu22",
                "runtime_version": "20",
            },
            entrypoint={
                "shell": "node ./app.js",
            },
            deployment={
                "zip": {
                    "source_url": pulumi.Output.all(
                        appengineNegBucketName=appengine_neg_bucket.name,
                        appengineNegBucketObjectName=appengine_neg_bucket_object.name
        ).apply(lambda resolved_outputs: f"https://storage.googleapis.com/{resolved_outputs['appengineNegBucketName']}/{resolved_outputs['appengineNegBucketObjectName']}")
        ,
                },
            },
            liveness_check={
                "path": "/",
            },
            readiness_check={
                "path": "/",
            },
            env_variables={
                "port": "8080",
            },
            handlers=[{
                "url_regex": ".*\\\\/my-path\\\\/*",
                "security_level": "SECURE_ALWAYS",
                "login": "LOGIN_REQUIRED",
                "auth_fail_action": "AUTH_FAIL_ACTION_REDIRECT",
                "static_files": {
                    "path": "my-other-path",
                    "upload_path_regex": ".*\\\\/my-path\\\\/*",
                },
            }],
            automatic_scaling={
                "cool_down_period": "120s",
                "cpu_utilization": {
                    "target_utilization": 0.5,
                },
            },
            delete_service_on_destroy=True)
        # App Engine Example
        appengine_neg = gcp.compute.RegionNetworkEndpointGroup("appengine_neg",
            name="appengine-neg",
            network_endpoint_type="SERVERLESS",
            region="us-central1",
            app_engine={
                "service": appengine_neg_flexible_app_version.service,
                "version": appengine_neg_flexible_app_version.version_id,
            })
        ```
        ### Region Network Endpoint Group Appengine Empty

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # App Engine Example
        appengine_neg = gcp.compute.RegionNetworkEndpointGroup("appengine_neg",
            name="appengine-neg",
            network_endpoint_type="SERVERLESS",
            region="us-central1",
            app_engine={})
        ```
        ### Region Network Endpoint Group Psc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        psc_neg = gcp.compute.RegionNetworkEndpointGroup("psc_neg",
            name="psc-neg",
            region="asia-northeast3",
            network_endpoint_type="PRIVATE_SERVICE_CONNECT",
            psc_target_service="asia-northeast3-cloudkms.googleapis.com")
        ```
        ### Region Network Endpoint Group Psc Service Attachment

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="psc-network")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="psc-subnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="europe-west4",
            network=default.id)
        psc_subnetwork = gcp.compute.Subnetwork("psc_subnetwork",
            name="psc-subnetwork-nat",
            ip_cidr_range="10.1.0.0/16",
            region="europe-west4",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=default.id)
        default_health_check = gcp.compute.HealthCheck("default",
            name="psc-healthcheck",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        default_region_backend_service = gcp.compute.RegionBackendService("default",
            name="psc-backend",
            region="europe-west4",
            health_checks=default_health_check.id)
        default_forwarding_rule = gcp.compute.ForwardingRule("default",
            name="psc-forwarding-rule",
            region="europe-west4",
            load_balancing_scheme="INTERNAL",
            backend_service=default_region_backend_service.id,
            all_ports=True,
            network=default.name,
            subnetwork=default_subnetwork.name)
        default_service_attachment = gcp.compute.ServiceAttachment("default",
            name="psc-service-attachment",
            region="europe-west4",
            description="A service attachment configured with Terraform",
            enable_proxy_protocol=False,
            connection_preference="ACCEPT_AUTOMATIC",
            nat_subnets=[psc_subnetwork.self_link],
            target_service=default_forwarding_rule.self_link)
        psc_neg_service_attachment = gcp.compute.RegionNetworkEndpointGroup("psc_neg_service_attachment",
            name="psc-neg",
            region="europe-west4",
            network_endpoint_type="PRIVATE_SERVICE_CONNECT",
            psc_target_service=default_service_attachment.self_link,
            network=default.self_link,
            subnetwork=default_subnetwork.self_link)
        ```
        ### Region Network Endpoint Group Internet Ip Port

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        region_network_endpoint_group_internet_ip_port = gcp.compute.RegionNetworkEndpointGroup("region_network_endpoint_group_internet_ip_port",
            name="ip-port-neg",
            region="us-central1",
            network=default.id,
            network_endpoint_type="INTERNET_IP_PORT")
        ```
        ### Region Network Endpoint Group Internet Fqdn Port

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        region_network_endpoint_group_internet_fqdn_port = gcp.compute.RegionNetworkEndpointGroup("region_network_endpoint_group_internet_fqdn_port",
            name="ip-port-neg",
            region="us-central1",
            network=default.id,
            network_endpoint_type="INTERNET_FQDN_PORT")
        ```
        ### Region Network Endpoint Group Portmap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default", name="network")
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="subnetwork",
            ip_cidr_range="10.0.0.0/16",
            region="us-central1",
            network=default.id)
        region_network_endpoint_group_portmap = gcp.compute.RegionNetworkEndpointGroup("region_network_endpoint_group_portmap",
            name="portmap-neg",
            region="us-central1",
            network=default.id,
            subnetwork=default_subnetwork.id,
            network_endpoint_type="GCE_VM_IP_PORTMAP")
        ```

        ## Import

        RegionNetworkEndpointGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/networkEndpointGroups/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionNetworkEndpointGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup default projects/{{project}}/regions/{{region}}/networkEndpointGroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionNetworkEndpointGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionNetworkEndpointGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupAppEngineArgs', 'RegionNetworkEndpointGroupAppEngineArgsDict']]] = None,
                 cloud_function: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupCloudFunctionArgs', 'RegionNetworkEndpointGroupCloudFunctionArgsDict']]] = None,
                 cloud_run: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupCloudRunArgs', 'RegionNetworkEndpointGroupCloudRunArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_endpoint_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_target_service: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 serverless_deployment: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupServerlessDeploymentArgs', 'RegionNetworkEndpointGroupServerlessDeploymentArgsDict']]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionNetworkEndpointGroupArgs.__new__(RegionNetworkEndpointGroupArgs)

            __props__.__dict__["app_engine"] = app_engine
            __props__.__dict__["cloud_function"] = cloud_function
            __props__.__dict__["cloud_run"] = cloud_run
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["network_endpoint_type"] = network_endpoint_type
            __props__.__dict__["project"] = project
            __props__.__dict__["psc_target_service"] = psc_target_service
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["serverless_deployment"] = serverless_deployment
            __props__.__dict__["subnetwork"] = subnetwork
            __props__.__dict__["self_link"] = None
        super(RegionNetworkEndpointGroup, __self__).__init__(
            'gcp:compute/regionNetworkEndpointGroup:RegionNetworkEndpointGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_engine: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupAppEngineArgs', 'RegionNetworkEndpointGroupAppEngineArgsDict']]] = None,
            cloud_function: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupCloudFunctionArgs', 'RegionNetworkEndpointGroupCloudFunctionArgsDict']]] = None,
            cloud_run: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupCloudRunArgs', 'RegionNetworkEndpointGroupCloudRunArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            network_endpoint_type: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            psc_target_service: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            serverless_deployment: Optional[pulumi.Input[Union['RegionNetworkEndpointGroupServerlessDeploymentArgs', 'RegionNetworkEndpointGroupServerlessDeploymentArgsDict']]] = None,
            subnetwork: Optional[pulumi.Input[str]] = None) -> 'RegionNetworkEndpointGroup':
        """
        Get an existing RegionNetworkEndpointGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegionNetworkEndpointGroupAppEngineArgs', 'RegionNetworkEndpointGroupAppEngineArgsDict']] app_engine: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input[Union['RegionNetworkEndpointGroupCloudFunctionArgs', 'RegionNetworkEndpointGroupCloudFunctionArgsDict']] cloud_function: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input[Union['RegionNetworkEndpointGroupCloudRunArgs', 'RegionNetworkEndpointGroupCloudRunArgsDict']] cloud_run: This field is only used for SERVERLESS NEGs.
               Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
               Structure is documented below.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] network: This field is only used for PSC and INTERNET NEGs.
               The URL of the network to which all network endpoints in the NEG belong. Uses
               "default" project network if unspecified.
        :param pulumi.Input[str] network_endpoint_type: Type of network endpoints in this network endpoint group. Defaults to SERVERLESS.
               Default value is `SERVERLESS`.
               Possible values are: `SERVERLESS`, `PRIVATE_SERVICE_CONNECT`, `INTERNET_IP_PORT`, `INTERNET_FQDN_PORT`, `GCE_VM_IP_PORTMAP`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] psc_target_service: This field is only used for PSC and INTERNET NEGs.
               The target service url used to set up private service connection to
               a Google API or a PSC Producer Service Attachment.
        :param pulumi.Input[str] region: A reference to the region where the regional NEGs reside.
               
               
               - - -
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['RegionNetworkEndpointGroupServerlessDeploymentArgs', 'RegionNetworkEndpointGroupServerlessDeploymentArgsDict']] serverless_deployment: This field is only used for SERVERLESS NEGs.
               Only one of cloudRun, appEngine, cloudFunction or serverlessDeployment may be set.
               Structure is documented below.
        :param pulumi.Input[str] subnetwork: This field is only used for PSC NEGs.
               Optional URL of the subnetwork to which all network endpoints in the NEG belong.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionNetworkEndpointGroupState.__new__(_RegionNetworkEndpointGroupState)

        __props__.__dict__["app_engine"] = app_engine
        __props__.__dict__["cloud_function"] = cloud_function
        __props__.__dict__["cloud_run"] = cloud_run
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["network_endpoint_type"] = network_endpoint_type
        __props__.__dict__["project"] = project
        __props__.__dict__["psc_target_service"] = psc_target_service
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["serverless_deployment"] = serverless_deployment
        __props__.__dict__["subnetwork"] = subnetwork
        return RegionNetworkEndpointGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appEngine")
    def app_engine(self) -> pulumi.Output[Optional['outputs.RegionNetworkEndpointGroupAppEngine']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "app_engine")

    @property
    @pulumi.getter(name="cloudFunction")
    def cloud_function(self) -> pulumi.Output[Optional['outputs.RegionNetworkEndpointGroupCloudFunction']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_function")

    @property
    @pulumi.getter(name="cloudRun")
    def cloud_run(self) -> pulumi.Output[Optional['outputs.RegionNetworkEndpointGroupCloudRun']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloud_run, app_engine, cloud_function or serverless_deployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_run")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[str]]:
        """
        This field is only used for PSC and INTERNET NEGs.
        The URL of the network to which all network endpoints in the NEG belong. Uses
        "default" project network if unspecified.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of network endpoints in this network endpoint group. Defaults to SERVERLESS.
        Default value is `SERVERLESS`.
        Possible values are: `SERVERLESS`, `PRIVATE_SERVICE_CONNECT`, `INTERNET_IP_PORT`, `INTERNET_FQDN_PORT`, `GCE_VM_IP_PORTMAP`.
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pscTargetService")
    def psc_target_service(self) -> pulumi.Output[Optional[str]]:
        """
        This field is only used for PSC and INTERNET NEGs.
        The target service url used to set up private service connection to
        a Google API or a PSC Producer Service Attachment.
        """
        return pulumi.get(self, "psc_target_service")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        A reference to the region where the regional NEGs reside.


        - - -
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serverlessDeployment")
    def serverless_deployment(self) -> pulumi.Output[Optional['outputs.RegionNetworkEndpointGroupServerlessDeployment']]:
        """
        This field is only used for SERVERLESS NEGs.
        Only one of cloudRun, appEngine, cloudFunction or serverlessDeployment may be set.
        Structure is documented below.
        """
        return pulumi.get(self, "serverless_deployment")

    @property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[Optional[str]]:
        """
        This field is only used for PSC NEGs.
        Optional URL of the subnetwork to which all network endpoints in the NEG belong.
        """
        return pulumi.get(self, "subnetwork")

