# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResizeRequestArgs', 'ResizeRequest']

@pulumi.input_type
class ResizeRequestArgs:
    def __init__(__self__, *,
                 instance_group_manager: pulumi.Input[str],
                 resize_by: pulumi.Input[int],
                 zone: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 requested_run_duration: Optional[pulumi.Input['ResizeRequestRequestedRunDurationArgs']] = None):
        """
        The set of arguments for constructing a ResizeRequest resource.
        :param pulumi.Input[str] instance_group_manager: The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
               Authorization requires the following IAM permission on the specified resource instanceGroupManager:
               *compute.instanceGroupManagers.update
               
               
               - - -
        :param pulumi.Input[int] resize_by: The number of instances to be created by this resize request. The group's target size will be increased by this number.
        :param pulumi.Input[str] zone: Name of the compute zone scoping this request. Name should conform to RFC1035.
        :param pulumi.Input[str] description: An optional description of this resize-request.
        :param pulumi.Input[str] name: The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ResizeRequestRequestedRunDurationArgs'] requested_run_duration: Requested run duration for instances that will be created by this request. At the end of the run duration instance will be deleted.
               Structure is documented below.
        """
        pulumi.set(__self__, "instance_group_manager", instance_group_manager)
        pulumi.set(__self__, "resize_by", resize_by)
        pulumi.set(__self__, "zone", zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if requested_run_duration is not None:
            pulumi.set(__self__, "requested_run_duration", requested_run_duration)

    @property
    @pulumi.getter(name="instanceGroupManager")
    def instance_group_manager(self) -> pulumi.Input[str]:
        """
        The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
        Authorization requires the following IAM permission on the specified resource instanceGroupManager:
        *compute.instanceGroupManagers.update


        - - -
        """
        return pulumi.get(self, "instance_group_manager")

    @instance_group_manager.setter
    def instance_group_manager(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_group_manager", value)

    @property
    @pulumi.getter(name="resizeBy")
    def resize_by(self) -> pulumi.Input[int]:
        """
        The number of instances to be created by this resize request. The group's target size will be increased by this number.
        """
        return pulumi.get(self, "resize_by")

    @resize_by.setter
    def resize_by(self, value: pulumi.Input[int]):
        pulumi.set(self, "resize_by", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[str]:
        """
        Name of the compute zone scoping this request. Name should conform to RFC1035.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resize-request.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestedRunDuration")
    def requested_run_duration(self) -> Optional[pulumi.Input['ResizeRequestRequestedRunDurationArgs']]:
        """
        Requested run duration for instances that will be created by this request. At the end of the run duration instance will be deleted.
        Structure is documented below.
        """
        return pulumi.get(self, "requested_run_duration")

    @requested_run_duration.setter
    def requested_run_duration(self, value: Optional[pulumi.Input['ResizeRequestRequestedRunDurationArgs']]):
        pulumi.set(self, "requested_run_duration", value)


@pulumi.input_type
class _ResizeRequestState:
    def __init__(__self__, *,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_group_manager: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 requested_run_duration: Optional[pulumi.Input['ResizeRequestRequestedRunDurationArgs']] = None,
                 resize_by: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ResizeRequestStatusArgs']]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ResizeRequest resources.
        :param pulumi.Input[str] creation_timestamp: The creation timestamp for this resize request in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resize-request.
        :param pulumi.Input[str] instance_group_manager: The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
               Authorization requires the following IAM permission on the specified resource instanceGroupManager:
               *compute.instanceGroupManagers.update
               
               
               - - -
        :param pulumi.Input[str] name: The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ResizeRequestRequestedRunDurationArgs'] requested_run_duration: Requested run duration for instances that will be created by this request. At the end of the run duration instance will be deleted.
               Structure is documented below.
        :param pulumi.Input[int] resize_by: The number of instances to be created by this resize request. The group's target size will be increased by this number.
        :param pulumi.Input[str] state: [Output only] Current state of the request.
        :param pulumi.Input[Sequence[pulumi.Input['ResizeRequestStatusArgs']]] statuses: [Output only] Status of the request.
               Structure is documented below.
        :param pulumi.Input[str] zone: Name of the compute zone scoping this request. Name should conform to RFC1035.
        """
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_group_manager is not None:
            pulumi.set(__self__, "instance_group_manager", instance_group_manager)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if requested_run_duration is not None:
            pulumi.set(__self__, "requested_run_duration", requested_run_duration)
        if resize_by is not None:
            pulumi.set(__self__, "resize_by", resize_by)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The creation timestamp for this resize request in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resize-request.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceGroupManager")
    def instance_group_manager(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
        Authorization requires the following IAM permission on the specified resource instanceGroupManager:
        *compute.instanceGroupManagers.update


        - - -
        """
        return pulumi.get(self, "instance_group_manager")

    @instance_group_manager.setter
    def instance_group_manager(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_group_manager", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestedRunDuration")
    def requested_run_duration(self) -> Optional[pulumi.Input['ResizeRequestRequestedRunDurationArgs']]:
        """
        Requested run duration for instances that will be created by this request. At the end of the run duration instance will be deleted.
        Structure is documented below.
        """
        return pulumi.get(self, "requested_run_duration")

    @requested_run_duration.setter
    def requested_run_duration(self, value: Optional[pulumi.Input['ResizeRequestRequestedRunDurationArgs']]):
        pulumi.set(self, "requested_run_duration", value)

    @property
    @pulumi.getter(name="resizeBy")
    def resize_by(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances to be created by this resize request. The group's target size will be increased by this number.
        """
        return pulumi.get(self, "resize_by")

    @resize_by.setter
    def resize_by(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resize_by", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only] Current state of the request.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResizeRequestStatusArgs']]]]:
        """
        [Output only] Status of the request.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResizeRequestStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the compute zone scoping this request. Name should conform to RFC1035.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class ResizeRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_group_manager: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 requested_run_duration: Optional[pulumi.Input[Union['ResizeRequestRequestedRunDurationArgs', 'ResizeRequestRequestedRunDurationArgsDict']]] = None,
                 resize_by: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a Managed Instance Group Resize Request

        Resize Requests are the Managed Instance Group implementation of Dynamic Workload Scheduler Flex Start.

        With Dynamic Workload Scheduler in Flex Start mode, you submit a GPU capacity request for your AI/ML jobs by indicating how many you need, a duration, and your preferred region. Dynamic Workload Scheduler intelligently persists the request; once the capacity becomes available, it automatically provisions your VMs enabling your workloads to run continuously for the entire duration of the capacity allocation.

        To get more information about ResizeRequest, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagerResizeRequests)
        * How-to Guides
            * [QUICKSTART_TITLE](https://cloud.google.com/compute/docs/instance-groups/create-resize-requests-mig)

        ## Example Usage

        ### Compute Mig Resize Request

        ```python
        import pulumi
        import pulumi_gcp as gcp

        a3_dws = gcp.compute.RegionInstanceTemplate("a3_dws",
            name="a3-dws",
            region="us-central1",
            description="This template is used to create a mig instance that is compatible with DWS resize requests.",
            instance_description="A3 GPU",
            machine_type="a3-highgpu-8g",
            can_ip_forward=False,
            scheduling={
                "automatic_restart": False,
                "on_host_maintenance": "TERMINATE",
            },
            disks=[{
                "source_image": "cos-cloud/cos-105-lts",
                "auto_delete": True,
                "boot": True,
                "disk_type": "pd-ssd",
                "disk_size_gb": 960,
                "mode": "READ_WRITE",
            }],
            guest_accelerators=[{
                "type": "nvidia-h100-80gb",
                "count": 8,
            }],
            reservation_affinity={
                "type": "NO_RESERVATION",
            },
            shielded_instance_config={
                "enable_vtpm": True,
                "enable_integrity_monitoring": True,
            },
            network_interfaces=[{
                "network": "default",
            }])
        a3_dws_instance_group_manager = gcp.compute.InstanceGroupManager("a3_dws",
            name="a3-dws",
            base_instance_name="a3-dws",
            zone="us-central1-a",
            versions=[{
                "instance_template": a3_dws.self_link,
            }],
            instance_lifecycle_policy={
                "default_action_on_failure": "DO_NOTHING",
            },
            wait_for_instances=False)
        a3_resize_request = gcp.compute.ResizeRequest("a3_resize_request",
            name="a3-dws",
            instance_group_manager=a3_dws_instance_group_manager.name,
            zone="us-central1-a",
            description="Test resize request resource",
            resize_by=2,
            requested_run_duration={
                "seconds": "14400",
                "nanos": 0,
            })
        ```

        ## Import

        ResizeRequest can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instanceGroupManagers/{{instance_group_manager}}/resizeRequests/{{name}}`

        * `{{project}}/{{zone}}/{{instance_group_manager}}/{{name}}`

        * `{{zone}}/{{instance_group_manager}}/{{name}}`

        * `{{instance_group_manager}}/{{name}}`

        When using the `pulumi import` command, ResizeRequest can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/resizeRequest:ResizeRequest default projects/{{project}}/zones/{{zone}}/instanceGroupManagers/{{instance_group_manager}}/resizeRequests/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resizeRequest:ResizeRequest default {{project}}/{{zone}}/{{instance_group_manager}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resizeRequest:ResizeRequest default {{zone}}/{{instance_group_manager}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resizeRequest:ResizeRequest default {{instance_group_manager}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resize-request.
        :param pulumi.Input[str] instance_group_manager: The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
               Authorization requires the following IAM permission on the specified resource instanceGroupManager:
               *compute.instanceGroupManagers.update
               
               
               - - -
        :param pulumi.Input[str] name: The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ResizeRequestRequestedRunDurationArgs', 'ResizeRequestRequestedRunDurationArgsDict']] requested_run_duration: Requested run duration for instances that will be created by this request. At the end of the run duration instance will be deleted.
               Structure is documented below.
        :param pulumi.Input[int] resize_by: The number of instances to be created by this resize request. The group's target size will be increased by this number.
        :param pulumi.Input[str] zone: Name of the compute zone scoping this request. Name should conform to RFC1035.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResizeRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Managed Instance Group Resize Request

        Resize Requests are the Managed Instance Group implementation of Dynamic Workload Scheduler Flex Start.

        With Dynamic Workload Scheduler in Flex Start mode, you submit a GPU capacity request for your AI/ML jobs by indicating how many you need, a duration, and your preferred region. Dynamic Workload Scheduler intelligently persists the request; once the capacity becomes available, it automatically provisions your VMs enabling your workloads to run continuously for the entire duration of the capacity allocation.

        To get more information about ResizeRequest, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagerResizeRequests)
        * How-to Guides
            * [QUICKSTART_TITLE](https://cloud.google.com/compute/docs/instance-groups/create-resize-requests-mig)

        ## Example Usage

        ### Compute Mig Resize Request

        ```python
        import pulumi
        import pulumi_gcp as gcp

        a3_dws = gcp.compute.RegionInstanceTemplate("a3_dws",
            name="a3-dws",
            region="us-central1",
            description="This template is used to create a mig instance that is compatible with DWS resize requests.",
            instance_description="A3 GPU",
            machine_type="a3-highgpu-8g",
            can_ip_forward=False,
            scheduling={
                "automatic_restart": False,
                "on_host_maintenance": "TERMINATE",
            },
            disks=[{
                "source_image": "cos-cloud/cos-105-lts",
                "auto_delete": True,
                "boot": True,
                "disk_type": "pd-ssd",
                "disk_size_gb": 960,
                "mode": "READ_WRITE",
            }],
            guest_accelerators=[{
                "type": "nvidia-h100-80gb",
                "count": 8,
            }],
            reservation_affinity={
                "type": "NO_RESERVATION",
            },
            shielded_instance_config={
                "enable_vtpm": True,
                "enable_integrity_monitoring": True,
            },
            network_interfaces=[{
                "network": "default",
            }])
        a3_dws_instance_group_manager = gcp.compute.InstanceGroupManager("a3_dws",
            name="a3-dws",
            base_instance_name="a3-dws",
            zone="us-central1-a",
            versions=[{
                "instance_template": a3_dws.self_link,
            }],
            instance_lifecycle_policy={
                "default_action_on_failure": "DO_NOTHING",
            },
            wait_for_instances=False)
        a3_resize_request = gcp.compute.ResizeRequest("a3_resize_request",
            name="a3-dws",
            instance_group_manager=a3_dws_instance_group_manager.name,
            zone="us-central1-a",
            description="Test resize request resource",
            resize_by=2,
            requested_run_duration={
                "seconds": "14400",
                "nanos": 0,
            })
        ```

        ## Import

        ResizeRequest can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instanceGroupManagers/{{instance_group_manager}}/resizeRequests/{{name}}`

        * `{{project}}/{{zone}}/{{instance_group_manager}}/{{name}}`

        * `{{zone}}/{{instance_group_manager}}/{{name}}`

        * `{{instance_group_manager}}/{{name}}`

        When using the `pulumi import` command, ResizeRequest can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/resizeRequest:ResizeRequest default projects/{{project}}/zones/{{zone}}/instanceGroupManagers/{{instance_group_manager}}/resizeRequests/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resizeRequest:ResizeRequest default {{project}}/{{zone}}/{{instance_group_manager}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resizeRequest:ResizeRequest default {{zone}}/{{instance_group_manager}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/resizeRequest:ResizeRequest default {{instance_group_manager}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ResizeRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResizeRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_group_manager: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 requested_run_duration: Optional[pulumi.Input[Union['ResizeRequestRequestedRunDurationArgs', 'ResizeRequestRequestedRunDurationArgsDict']]] = None,
                 resize_by: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResizeRequestArgs.__new__(ResizeRequestArgs)

            __props__.__dict__["description"] = description
            if instance_group_manager is None and not opts.urn:
                raise TypeError("Missing required property 'instance_group_manager'")
            __props__.__dict__["instance_group_manager"] = instance_group_manager
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["requested_run_duration"] = requested_run_duration
            if resize_by is None and not opts.urn:
                raise TypeError("Missing required property 'resize_by'")
            __props__.__dict__["resize_by"] = resize_by
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["statuses"] = None
        super(ResizeRequest, __self__).__init__(
            'gcp:compute/resizeRequest:ResizeRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            instance_group_manager: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            requested_run_duration: Optional[pulumi.Input[Union['ResizeRequestRequestedRunDurationArgs', 'ResizeRequestRequestedRunDurationArgsDict']]] = None,
            resize_by: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResizeRequestStatusArgs', 'ResizeRequestStatusArgsDict']]]]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'ResizeRequest':
        """
        Get an existing ResizeRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_timestamp: The creation timestamp for this resize request in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resize-request.
        :param pulumi.Input[str] instance_group_manager: The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
               Authorization requires the following IAM permission on the specified resource instanceGroupManager:
               *compute.instanceGroupManagers.update
               
               
               - - -
        :param pulumi.Input[str] name: The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ResizeRequestRequestedRunDurationArgs', 'ResizeRequestRequestedRunDurationArgsDict']] requested_run_duration: Requested run duration for instances that will be created by this request. At the end of the run duration instance will be deleted.
               Structure is documented below.
        :param pulumi.Input[int] resize_by: The number of instances to be created by this resize request. The group's target size will be increased by this number.
        :param pulumi.Input[str] state: [Output only] Current state of the request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResizeRequestStatusArgs', 'ResizeRequestStatusArgsDict']]]] statuses: [Output only] Status of the request.
               Structure is documented below.
        :param pulumi.Input[str] zone: Name of the compute zone scoping this request. Name should conform to RFC1035.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResizeRequestState.__new__(_ResizeRequestState)

        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_group_manager"] = instance_group_manager
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["requested_run_duration"] = requested_run_duration
        __props__.__dict__["resize_by"] = resize_by
        __props__.__dict__["state"] = state
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["zone"] = zone
        return ResizeRequest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        The creation timestamp for this resize request in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resize-request.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceGroupManager")
    def instance_group_manager(self) -> pulumi.Output[str]:
        """
        The name of the managed instance group. The name should conform to RFC1035 or be a resource ID.
        Authorization requires the following IAM permission on the specified resource instanceGroupManager:
        *compute.instanceGroupManagers.update


        - - -
        """
        return pulumi.get(self, "instance_group_manager")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this resize request. The name must be 1-63 characters long, and comply with RFC1035.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestedRunDuration")
    def requested_run_duration(self) -> pulumi.Output[Optional['outputs.ResizeRequestRequestedRunDuration']]:
        """
        Requested run duration for instances that will be created by this request. At the end of the run duration instance will be deleted.
        Structure is documented below.
        """
        return pulumi.get(self, "requested_run_duration")

    @property
    @pulumi.getter(name="resizeBy")
    def resize_by(self) -> pulumi.Output[int]:
        """
        The number of instances to be created by this resize request. The group's target size will be increased by this number.
        """
        return pulumi.get(self, "resize_by")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        [Output only] Current state of the request.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.ResizeRequestStatus']]:
        """
        [Output only] Status of the request.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        Name of the compute zone scoping this request. Name should conform to RFC1035.
        """
        return pulumi.get(self, "zone")

