# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouterRoutePolicyArgs', 'RouterRoutePolicy']

@pulumi.input_type
class RouterRoutePolicyArgs:
    def __init__(__self__, *,
                 router: pulumi.Input[str],
                 terms: pulumi.Input[Sequence[pulumi.Input['RouterRoutePolicyTermArgs']]],
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RouterRoutePolicy resource.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this route policy will be configured.
        :param pulumi.Input[Sequence[pulumi.Input['RouterRoutePolicyTermArgs']]] terms: List of terms (the order in the list is not important, they are evaluated in order of priority).
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the route policy. This policy's name, which must be a resource ID segment and unique within all policies owned by the Router
        :param pulumi.Input[str] region: Region where the router and NAT reside.
        :param pulumi.Input[str] type: This is policy's type, which is one of IMPORT or EXPORT Possible values: ["ROUTE_POLICY_TYPE_IMPORT",
               "ROUTE_POLICY_TYPE_EXPORT"]
        """
        pulumi.set(__self__, "router", router)
        pulumi.set(__self__, "terms", terms)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def router(self) -> pulumi.Input[str]:
        """
        The name of the Cloud Router in which this route policy will be configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[str]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter
    def terms(self) -> pulumi.Input[Sequence[pulumi.Input['RouterRoutePolicyTermArgs']]]:
        """
        List of terms (the order in the list is not important, they are evaluated in order of priority).
        Structure is documented below.
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: pulumi.Input[Sequence[pulumi.Input['RouterRoutePolicyTermArgs']]]):
        pulumi.set(self, "terms", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the route policy. This policy's name, which must be a resource ID segment and unique within all policies owned by the Router
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        This is policy's type, which is one of IMPORT or EXPORT Possible values: ["ROUTE_POLICY_TYPE_IMPORT",
        "ROUTE_POLICY_TYPE_EXPORT"]
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _RouterRoutePolicyState:
    def __init__(__self__, *,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutePolicyTermArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RouterRoutePolicy resources.
        :param pulumi.Input[str] fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[str] name: Name of the route policy. This policy's name, which must be a resource ID segment and unique within all policies owned by the Router
        :param pulumi.Input[str] region: Region where the router and NAT reside.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this route policy will be configured.
        :param pulumi.Input[Sequence[pulumi.Input['RouterRoutePolicyTermArgs']]] terms: List of terms (the order in the list is not important, they are evaluated in order of priority).
               Structure is documented below.
        :param pulumi.Input[str] type: This is policy's type, which is one of IMPORT or EXPORT Possible values: ["ROUTE_POLICY_TYPE_IMPORT",
               "ROUTE_POLICY_TYPE_EXPORT"]
        """
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if terms is not None:
            pulumi.set(__self__, "terms", terms)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the route policy. This policy's name, which must be a resource ID segment and unique within all policies owned by the Router
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Cloud Router in which this route policy will be configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter
    def terms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutePolicyTermArgs']]]]:
        """
        List of terms (the order in the list is not important, they are evaluated in order of priority).
        Structure is documented below.
        """
        return pulumi.get(self, "terms")

    @terms.setter
    def terms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutePolicyTermArgs']]]]):
        pulumi.set(self, "terms", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        This is policy's type, which is one of IMPORT or EXPORT Possible values: ["ROUTE_POLICY_TYPE_IMPORT",
        "ROUTE_POLICY_TYPE_EXPORT"]
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class RouterRoutePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutePolicyTermArgs', 'RouterRoutePolicyTermArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Router Route Policy Export

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id)
        rp_export = gcp.compute.RouterRoutePolicy("rp-export",
            router=router.name,
            region=router.region,
            name="my-rp1",
            type="ROUTE_POLICY_TYPE_EXPORT",
            terms=[{
                "priority": 1,
                "match": {
                    "expression": "destination == '10.0.0.0/12'",
                },
                "actions": [{
                    "expression": "accept()",
                }],
            }])
        ```
        ### Router Route Policy Import

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id)
        rp_import = gcp.compute.RouterRoutePolicy("rp-import",
            name="my-rp2",
            router=router.name,
            region=router.region,
            type="ROUTE_POLICY_TYPE_IMPORT",
            terms=[{
                "priority": 2,
                "match": {
                    "expression": "destination == '10.0.0.0/12'",
                },
                "actions": [{
                    "expression": "accept()",
                }],
            }])
        ```

        ## Import

        RouterRoutePolicy can be imported using any of these accepted formats:

        * `{{project}}/{{region}}/{{router}}/routePolicies/{{name}}`

        * `{{project}}/{{region}}/{{router}}/{{name}}`

        * `{{region}}/{{router}}/{{name}}`

        * `{{router}}/{{name}}`

        When using the `pulumi import` command, RouterRoutePolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerRoutePolicy:RouterRoutePolicy default {{project}}/{{region}}/{{router}}/routePolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerRoutePolicy:RouterRoutePolicy default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerRoutePolicy:RouterRoutePolicy default {{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerRoutePolicy:RouterRoutePolicy default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the route policy. This policy's name, which must be a resource ID segment and unique within all policies owned by the Router
        :param pulumi.Input[str] region: Region where the router and NAT reside.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this route policy will be configured.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutePolicyTermArgs', 'RouterRoutePolicyTermArgsDict']]]] terms: List of terms (the order in the list is not important, they are evaluated in order of priority).
               Structure is documented below.
        :param pulumi.Input[str] type: This is policy's type, which is one of IMPORT or EXPORT Possible values: ["ROUTE_POLICY_TYPE_IMPORT",
               "ROUTE_POLICY_TYPE_EXPORT"]
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterRoutePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Router Route Policy Export

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id)
        rp_export = gcp.compute.RouterRoutePolicy("rp-export",
            router=router.name,
            region=router.region,
            name="my-rp1",
            type="ROUTE_POLICY_TYPE_EXPORT",
            terms=[{
                "priority": 1,
                "match": {
                    "expression": "destination == '10.0.0.0/12'",
                },
                "actions": [{
                    "expression": "accept()",
                }],
            }])
        ```
        ### Router Route Policy Import

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            network=net.id,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        router = gcp.compute.Router("router",
            name="my-router",
            region=subnet.region,
            network=net.id)
        rp_import = gcp.compute.RouterRoutePolicy("rp-import",
            name="my-rp2",
            router=router.name,
            region=router.region,
            type="ROUTE_POLICY_TYPE_IMPORT",
            terms=[{
                "priority": 2,
                "match": {
                    "expression": "destination == '10.0.0.0/12'",
                },
                "actions": [{
                    "expression": "accept()",
                }],
            }])
        ```

        ## Import

        RouterRoutePolicy can be imported using any of these accepted formats:

        * `{{project}}/{{region}}/{{router}}/routePolicies/{{name}}`

        * `{{project}}/{{region}}/{{router}}/{{name}}`

        * `{{region}}/{{router}}/{{name}}`

        * `{{router}}/{{name}}`

        When using the `pulumi import` command, RouterRoutePolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerRoutePolicy:RouterRoutePolicy default {{project}}/{{region}}/{{router}}/routePolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerRoutePolicy:RouterRoutePolicy default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerRoutePolicy:RouterRoutePolicy default {{region}}/{{router}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerRoutePolicy:RouterRoutePolicy default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RouterRoutePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterRoutePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutePolicyTermArgs', 'RouterRoutePolicyTermArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterRoutePolicyArgs.__new__(RouterRoutePolicyArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            if terms is None and not opts.urn:
                raise TypeError("Missing required property 'terms'")
            __props__.__dict__["terms"] = terms
            __props__.__dict__["type"] = type
            __props__.__dict__["fingerprint"] = None
        super(RouterRoutePolicy, __self__).__init__(
            'gcp:compute/routerRoutePolicy:RouterRoutePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            router: Optional[pulumi.Input[str]] = None,
            terms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutePolicyTermArgs', 'RouterRoutePolicyTermArgsDict']]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'RouterRoutePolicy':
        """
        Get an existing RouterRoutePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[str] name: Name of the route policy. This policy's name, which must be a resource ID segment and unique within all policies owned by the Router
        :param pulumi.Input[str] region: Region where the router and NAT reside.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this route policy will be configured.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutePolicyTermArgs', 'RouterRoutePolicyTermArgsDict']]]] terms: List of terms (the order in the list is not important, they are evaluated in order of priority).
               Structure is documented below.
        :param pulumi.Input[str] type: This is policy's type, which is one of IMPORT or EXPORT Possible values: ["ROUTE_POLICY_TYPE_IMPORT",
               "ROUTE_POLICY_TYPE_EXPORT"]
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterRoutePolicyState.__new__(_RouterRoutePolicyState)

        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["terms"] = terms
        __props__.__dict__["type"] = type
        return RouterRoutePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the route policy. This policy's name, which must be a resource ID segment and unique within all policies owned by the Router
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region where the router and NAT reside.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[str]:
        """
        The name of the Cloud Router in which this route policy will be configured.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter
    def terms(self) -> pulumi.Output[Sequence['outputs.RouterRoutePolicyTerm']]:
        """
        List of terms (the order in the list is not important, they are evaluated in order of priority).
        Structure is documented below.
        """
        return pulumi.get(self, "terms")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        This is policy's type, which is one of IMPORT or EXPORT Possible values: ["ROUTE_POLICY_TYPE_IMPORT",
        "ROUTE_POLICY_TYPE_EXPORT"]
        """
        return pulumi.get(self, "type")

