# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityPolicyRuleInitArgs', 'SecurityPolicyRule']

@pulumi.input_type
class SecurityPolicyRuleInitArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 security_policy: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 match: Optional[pulumi.Input['SecurityPolicyRuleMatchArgs']] = None,
                 preconfigured_waf_config: Optional[pulumi.Input['SecurityPolicyRulePreconfiguredWafConfigArgs']] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rate_limit_options: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']] = None):
        """
        The set of arguments for constructing a SecurityPolicyRule resource.
        :param pulumi.Input[str] action: The Action to perform when the rule is matched. The following are the valid actions:
               * allow: allow access to target.
               * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
               * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
               * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
               * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        :param pulumi.Input[int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[str] security_policy: The name of the security policy this rule belongs to.
               
               
               - - -
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['SecurityPolicyRuleMatchArgs'] match: A match condition that incoming traffic is evaluated against.
               If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input['SecurityPolicyRulePreconfiguredWafConfigArgs'] preconfigured_waf_config: Preconfigured WAF configuration to be applied for the rule.
               If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
               Structure is documented below.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs'] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
               Structure is documented below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "security_policy", security_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if preconfigured_waf_config is not None:
            pulumi.set(__self__, "preconfigured_waf_config", preconfigured_waf_config)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rate_limit_options is not None:
            pulumi.set(__self__, "rate_limit_options", rate_limit_options)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The Action to perform when the rule is matched. The following are the valid actions:
        * allow: allow access to target.
        * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
        * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
        * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
        * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Input[str]:
        """
        The name of the security policy this rule belongs to.


        - - -
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['SecurityPolicyRuleMatchArgs']]:
        """
        A match condition that incoming traffic is evaluated against.
        If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['SecurityPolicyRuleMatchArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter(name="preconfiguredWafConfig")
    def preconfigured_waf_config(self) -> Optional[pulumi.Input['SecurityPolicyRulePreconfiguredWafConfigArgs']]:
        """
        Preconfigured WAF configuration to be applied for the rule.
        If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
        Structure is documented below.
        """
        return pulumi.get(self, "preconfigured_waf_config")

    @preconfigured_waf_config.setter
    def preconfigured_waf_config(self, value: Optional[pulumi.Input['SecurityPolicyRulePreconfiguredWafConfigArgs']]):
        pulumi.set(self, "preconfigured_waf_config", value)

    @property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preview", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="rateLimitOptions")
    def rate_limit_options(self) -> Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']]:
        """
        Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        Structure is documented below.
        """
        return pulumi.get(self, "rate_limit_options")

    @rate_limit_options.setter
    def rate_limit_options(self, value: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']]):
        pulumi.set(self, "rate_limit_options", value)


@pulumi.input_type
class _SecurityPolicyRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 match: Optional[pulumi.Input['SecurityPolicyRuleMatchArgs']] = None,
                 preconfigured_waf_config: Optional[pulumi.Input['SecurityPolicyRulePreconfiguredWafConfigArgs']] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rate_limit_options: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']] = None,
                 security_policy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityPolicyRule resources.
        :param pulumi.Input[str] action: The Action to perform when the rule is matched. The following are the valid actions:
               * allow: allow access to target.
               * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
               * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
               * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
               * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['SecurityPolicyRuleMatchArgs'] match: A match condition that incoming traffic is evaluated against.
               If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input['SecurityPolicyRulePreconfiguredWafConfigArgs'] preconfigured_waf_config: Preconfigured WAF configuration to be applied for the rule.
               If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
               Structure is documented below.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs'] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
               Structure is documented below.
        :param pulumi.Input[str] security_policy: The name of the security policy this rule belongs to.
               
               
               - - -
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if preconfigured_waf_config is not None:
            pulumi.set(__self__, "preconfigured_waf_config", preconfigured_waf_config)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rate_limit_options is not None:
            pulumi.set(__self__, "rate_limit_options", rate_limit_options)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The Action to perform when the rule is matched. The following are the valid actions:
        * allow: allow access to target.
        * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
        * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
        * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
        * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['SecurityPolicyRuleMatchArgs']]:
        """
        A match condition that incoming traffic is evaluated against.
        If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['SecurityPolicyRuleMatchArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter(name="preconfiguredWafConfig")
    def preconfigured_waf_config(self) -> Optional[pulumi.Input['SecurityPolicyRulePreconfiguredWafConfigArgs']]:
        """
        Preconfigured WAF configuration to be applied for the rule.
        If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
        Structure is documented below.
        """
        return pulumi.get(self, "preconfigured_waf_config")

    @preconfigured_waf_config.setter
    def preconfigured_waf_config(self, value: Optional[pulumi.Input['SecurityPolicyRulePreconfiguredWafConfigArgs']]):
        pulumi.set(self, "preconfigured_waf_config", value)

    @property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preview", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="rateLimitOptions")
    def rate_limit_options(self) -> Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']]:
        """
        Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        Structure is documented below.
        """
        return pulumi.get(self, "rate_limit_options")

    @rate_limit_options.setter
    def rate_limit_options(self, value: Optional[pulumi.Input['SecurityPolicyRuleRateLimitOptionsArgs']]):
        pulumi.set(self, "rate_limit_options", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security policy this rule belongs to.


        - - -
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)


class SecurityPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 match: Optional[pulumi.Input[Union['SecurityPolicyRuleMatchArgs', 'SecurityPolicyRuleMatchArgsDict']]] = None,
                 preconfigured_waf_config: Optional[pulumi.Input[Union['SecurityPolicyRulePreconfiguredWafConfigArgs', 'SecurityPolicyRulePreconfiguredWafConfigArgsDict']]] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rate_limit_options: Optional[pulumi.Input[Union['SecurityPolicyRuleRateLimitOptionsArgs', 'SecurityPolicyRuleRateLimitOptionsArgsDict']]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A rule for the SecurityPolicy.

        To get more information about SecurityPolicyRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/securityPolicies/addRule)
        * How-to Guides
            * [Creating global security policy rules](https://cloud.google.com/armor/docs/configure-security-policies)

        ## Example Usage

        ### Security Policy Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.SecurityPolicy("default",
            name="policyruletest",
            description="basic global security policy",
            type="CLOUD_ARMOR")
        policy_rule = gcp.compute.SecurityPolicyRule("policy_rule",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Security Policy Rule Default Rule

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.SecurityPolicy("default",
            name="policyruletest",
            description="basic global security policy",
            type="CLOUD_ARMOR")
        # A default rule is generated when creating the security_policy resource, import is needed to patch it
        # import {
        #   id = "projects//global/securityPolicies/policyruletest/priority/2147483647"
        #   to = google_compute_security_policy_rule.default_rule
        # }
        default_rule = gcp.compute.SecurityPolicyRule("default_rule",
            security_policy=default.name,
            description="default rule",
            action="allow",
            priority=2147483647,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["*"],
                },
            })
        policy_rule = gcp.compute.SecurityPolicyRule("policy_rule",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Security Policy Rule Multiple Rules

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.SecurityPolicy("default",
            name="policywithmultiplerules",
            description="basic global security policy",
            type="CLOUD_ARMOR")
        policy_rule_one = gcp.compute.SecurityPolicyRule("policy_rule_one",
            security_policy=default.name,
            description="new rule one",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        policy_rule_two = gcp.compute.SecurityPolicyRule("policy_rule_two",
            security_policy=default.name,
            description="new rule two",
            priority=101,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": [
                        "192.168.0.0/16",
                        "10.0.0.0/8",
                    ],
                },
            },
            action="allow",
            preview=True)
        ```

        ## Import

        SecurityPolicyRule can be imported using any of these accepted formats:

        * `projects/{{project}}/global/securityPolicies/{{security_policy}}/priority/{{priority}}`

        * `{{project}}/{{security_policy}}/{{priority}}`

        * `{{security_policy}}/{{priority}}`

        When using the `pulumi import` command, SecurityPolicyRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/securityPolicyRule:SecurityPolicyRule default projects/{{project}}/global/securityPolicies/{{security_policy}}/priority/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/securityPolicyRule:SecurityPolicyRule default {{project}}/{{security_policy}}/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/securityPolicyRule:SecurityPolicyRule default {{security_policy}}/{{priority}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The Action to perform when the rule is matched. The following are the valid actions:
               * allow: allow access to target.
               * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
               * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
               * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
               * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['SecurityPolicyRuleMatchArgs', 'SecurityPolicyRuleMatchArgsDict']] match: A match condition that incoming traffic is evaluated against.
               If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[Union['SecurityPolicyRulePreconfiguredWafConfigArgs', 'SecurityPolicyRulePreconfiguredWafConfigArgsDict']] preconfigured_waf_config: Preconfigured WAF configuration to be applied for the rule.
               If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
               Structure is documented below.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SecurityPolicyRuleRateLimitOptionsArgs', 'SecurityPolicyRuleRateLimitOptionsArgsDict']] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
               Structure is documented below.
        :param pulumi.Input[str] security_policy: The name of the security policy this rule belongs to.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityPolicyRuleInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A rule for the SecurityPolicy.

        To get more information about SecurityPolicyRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/securityPolicies/addRule)
        * How-to Guides
            * [Creating global security policy rules](https://cloud.google.com/armor/docs/configure-security-policies)

        ## Example Usage

        ### Security Policy Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.SecurityPolicy("default",
            name="policyruletest",
            description="basic global security policy",
            type="CLOUD_ARMOR")
        policy_rule = gcp.compute.SecurityPolicyRule("policy_rule",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Security Policy Rule Default Rule

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.SecurityPolicy("default",
            name="policyruletest",
            description="basic global security policy",
            type="CLOUD_ARMOR")
        # A default rule is generated when creating the security_policy resource, import is needed to patch it
        # import {
        #   id = "projects//global/securityPolicies/policyruletest/priority/2147483647"
        #   to = google_compute_security_policy_rule.default_rule
        # }
        default_rule = gcp.compute.SecurityPolicyRule("default_rule",
            security_policy=default.name,
            description="default rule",
            action="allow",
            priority=2147483647,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["*"],
                },
            })
        policy_rule = gcp.compute.SecurityPolicyRule("policy_rule",
            security_policy=default.name,
            description="new rule",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        ```
        ### Security Policy Rule Multiple Rules

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.SecurityPolicy("default",
            name="policywithmultiplerules",
            description="basic global security policy",
            type="CLOUD_ARMOR")
        policy_rule_one = gcp.compute.SecurityPolicyRule("policy_rule_one",
            security_policy=default.name,
            description="new rule one",
            priority=100,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": ["10.10.0.0/16"],
                },
            },
            action="allow",
            preview=True)
        policy_rule_two = gcp.compute.SecurityPolicyRule("policy_rule_two",
            security_policy=default.name,
            description="new rule two",
            priority=101,
            match={
                "versioned_expr": "SRC_IPS_V1",
                "config": {
                    "src_ip_ranges": [
                        "192.168.0.0/16",
                        "10.0.0.0/8",
                    ],
                },
            },
            action="allow",
            preview=True)
        ```

        ## Import

        SecurityPolicyRule can be imported using any of these accepted formats:

        * `projects/{{project}}/global/securityPolicies/{{security_policy}}/priority/{{priority}}`

        * `{{project}}/{{security_policy}}/{{priority}}`

        * `{{security_policy}}/{{priority}}`

        When using the `pulumi import` command, SecurityPolicyRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/securityPolicyRule:SecurityPolicyRule default projects/{{project}}/global/securityPolicies/{{security_policy}}/priority/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/securityPolicyRule:SecurityPolicyRule default {{project}}/{{security_policy}}/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/securityPolicyRule:SecurityPolicyRule default {{security_policy}}/{{priority}}
        ```

        :param str resource_name: The name of the resource.
        :param SecurityPolicyRuleInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityPolicyRuleInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 match: Optional[pulumi.Input[Union['SecurityPolicyRuleMatchArgs', 'SecurityPolicyRuleMatchArgsDict']]] = None,
                 preconfigured_waf_config: Optional[pulumi.Input[Union['SecurityPolicyRulePreconfiguredWafConfigArgs', 'SecurityPolicyRulePreconfiguredWafConfigArgsDict']]] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rate_limit_options: Optional[pulumi.Input[Union['SecurityPolicyRuleRateLimitOptionsArgs', 'SecurityPolicyRuleRateLimitOptionsArgsDict']]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityPolicyRuleInitArgs.__new__(SecurityPolicyRuleInitArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            __props__.__dict__["match"] = match
            __props__.__dict__["preconfigured_waf_config"] = preconfigured_waf_config
            __props__.__dict__["preview"] = preview
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project"] = project
            __props__.__dict__["rate_limit_options"] = rate_limit_options
            if security_policy is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy'")
            __props__.__dict__["security_policy"] = security_policy
        super(SecurityPolicyRule, __self__).__init__(
            'gcp:compute/securityPolicyRule:SecurityPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            match: Optional[pulumi.Input[Union['SecurityPolicyRuleMatchArgs', 'SecurityPolicyRuleMatchArgsDict']]] = None,
            preconfigured_waf_config: Optional[pulumi.Input[Union['SecurityPolicyRulePreconfiguredWafConfigArgs', 'SecurityPolicyRulePreconfiguredWafConfigArgsDict']]] = None,
            preview: Optional[pulumi.Input[bool]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            rate_limit_options: Optional[pulumi.Input[Union['SecurityPolicyRuleRateLimitOptionsArgs', 'SecurityPolicyRuleRateLimitOptionsArgsDict']]] = None,
            security_policy: Optional[pulumi.Input[str]] = None) -> 'SecurityPolicyRule':
        """
        Get an existing SecurityPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The Action to perform when the rule is matched. The following are the valid actions:
               * allow: allow access to target.
               * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
               * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
               * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
               * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['SecurityPolicyRuleMatchArgs', 'SecurityPolicyRuleMatchArgsDict']] match: A match condition that incoming traffic is evaluated against.
               If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[Union['SecurityPolicyRulePreconfiguredWafConfigArgs', 'SecurityPolicyRulePreconfiguredWafConfigArgsDict']] preconfigured_waf_config: Preconfigured WAF configuration to be applied for the rule.
               If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
               Structure is documented below.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SecurityPolicyRuleRateLimitOptionsArgs', 'SecurityPolicyRuleRateLimitOptionsArgsDict']] rate_limit_options: Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
               Structure is documented below.
        :param pulumi.Input[str] security_policy: The name of the security policy this rule belongs to.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityPolicyRuleState.__new__(_SecurityPolicyRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["match"] = match
        __props__.__dict__["preconfigured_waf_config"] = preconfigured_waf_config
        __props__.__dict__["preview"] = preview
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project"] = project
        __props__.__dict__["rate_limit_options"] = rate_limit_options
        __props__.__dict__["security_policy"] = security_policy
        return SecurityPolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The Action to perform when the rule is matched. The following are the valid actions:
        * allow: allow access to target.
        * deny(STATUS): deny access to target, returns the HTTP response code specified. Valid values for STATUS are 403, 404, and 502.
        * rate_based_ban: limit client traffic to the configured threshold and ban the client if the traffic exceeds the threshold. Configure parameters for this action in RateLimitOptions. Requires rateLimitOptions to be set.
        * redirect: redirect to a different target. This can either be an internal reCAPTCHA redirect, or an external URL-based redirect via a 302 response. Parameters for this action can be configured via redirectOptions. This action is only supported in Global Security Policies of type CLOUD_ARMOR.
        * throttle: limit client traffic to the configured threshold. Configure parameters for this action in rateLimitOptions. Requires rateLimitOptions to be set for this.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def match(self) -> pulumi.Output[Optional['outputs.SecurityPolicyRuleMatch']]:
        """
        A match condition that incoming traffic is evaluated against.
        If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="preconfiguredWafConfig")
    def preconfigured_waf_config(self) -> pulumi.Output[Optional['outputs.SecurityPolicyRulePreconfiguredWafConfig']]:
        """
        Preconfigured WAF configuration to be applied for the rule.
        If the rule does not evaluate preconfigured WAF rules, i.e., if evaluatePreconfiguredWaf() is not used, this field will have no effect.
        Structure is documented below.
        """
        return pulumi.get(self, "preconfigured_waf_config")

    @property
    @pulumi.getter
    def preview(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="rateLimitOptions")
    def rate_limit_options(self) -> pulumi.Output[Optional['outputs.SecurityPolicyRuleRateLimitOptions']]:
        """
        Must be specified if the action is "rate_based_ban" or "throttle". Cannot be specified for any other actions.
        Structure is documented below.
        """
        return pulumi.get(self, "rate_limit_options")

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[str]:
        """
        The name of the security policy this rule belongs to.


        - - -
        """
        return pulumi.get(self, "security_policy")

