# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TargetPoolArgs', 'TargetPool']

@pulumi.input_type
class TargetPoolArgs:
    def __init__(__self__, *,
                 backup_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover_ratio: Optional[pulumi.Input[float]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TargetPool resource.
        :param pulumi.Input[str] backup_pool: URL to the backup target pool. Must also set
               failover_ratio.
        :param pulumi.Input[str] description: Textual description field.
        :param pulumi.Input[float] failover_ratio: Ratio (0 to 1) of failed nodes before using the
               backup pool (which must also be set).
        :param pulumi.Input[str] health_checks: List of zero or one health check name or self_link. Only
               legacy `compute.HttpHealthCheck` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: List of instances in the pool. They can be given as
               URLs, or in the form of "zone/name". Note that the instances need not exist
               at the time of target pool creation, so there is no need to use the
               interpolation to create a dependency on the instances from the
               target pool.
        :param pulumi.Input[str] name: A unique name for the resource, required by GCE. Changing
               this forces a new resource to be created.
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: Where the target pool resides. Defaults to project
               region.
        :param pulumi.Input[str] security_policy: The resource URL for the security policy associated with this target pool.
        :param pulumi.Input[str] session_affinity: How to distribute load. Options are "NONE" (no
               affinity). "CLIENT_IP" (hash of the source/dest addresses / ports), and
               "CLIENT_IP_PROTO" also includes the protocol (default "NONE").
        """
        if backup_pool is not None:
            pulumi.set(__self__, "backup_pool", backup_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failover_ratio is not None:
            pulumi.set(__self__, "failover_ratio", failover_ratio)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)

    @property
    @pulumi.getter(name="backupPool")
    def backup_pool(self) -> Optional[pulumi.Input[str]]:
        """
        URL to the backup target pool. Must also set
        failover_ratio.
        """
        return pulumi.get(self, "backup_pool")

    @backup_pool.setter
    def backup_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_pool", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Textual description field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="failoverRatio")
    def failover_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        Ratio (0 to 1) of failed nodes before using the
        backup pool (which must also be set).
        """
        return pulumi.get(self, "failover_ratio")

    @failover_ratio.setter
    def failover_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "failover_ratio", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[str]]:
        """
        List of zero or one health check name or self_link. Only
        legacy `compute.HttpHealthCheck` is supported.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of instances in the pool. They can be given as
        URLs, or in the form of "zone/name". Note that the instances need not exist
        at the time of target pool creation, so there is no need to use the
        interpolation to create a dependency on the instances from the
        target pool.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the resource, required by GCE. Changing
        this forces a new resource to be created.

        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Where the target pool resides. Defaults to project
        region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The resource URL for the security policy associated with this target pool.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        How to distribute load. Options are "NONE" (no
        affinity). "CLIENT_IP" (hash of the source/dest addresses / ports), and
        "CLIENT_IP_PROTO" also includes the protocol (default "NONE").
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)


@pulumi.input_type
class _TargetPoolState:
    def __init__(__self__, *,
                 backup_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover_ratio: Optional[pulumi.Input[float]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TargetPool resources.
        :param pulumi.Input[str] backup_pool: URL to the backup target pool. Must also set
               failover_ratio.
        :param pulumi.Input[str] description: Textual description field.
        :param pulumi.Input[float] failover_ratio: Ratio (0 to 1) of failed nodes before using the
               backup pool (which must also be set).
        :param pulumi.Input[str] health_checks: List of zero or one health check name or self_link. Only
               legacy `compute.HttpHealthCheck` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: List of instances in the pool. They can be given as
               URLs, or in the form of "zone/name". Note that the instances need not exist
               at the time of target pool creation, so there is no need to use the
               interpolation to create a dependency on the instances from the
               target pool.
        :param pulumi.Input[str] name: A unique name for the resource, required by GCE. Changing
               this forces a new resource to be created.
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: Where the target pool resides. Defaults to project
               region.
        :param pulumi.Input[str] security_policy: The resource URL for the security policy associated with this target pool.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] session_affinity: How to distribute load. Options are "NONE" (no
               affinity). "CLIENT_IP" (hash of the source/dest addresses / ports), and
               "CLIENT_IP_PROTO" also includes the protocol (default "NONE").
        """
        if backup_pool is not None:
            pulumi.set(__self__, "backup_pool", backup_pool)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failover_ratio is not None:
            pulumi.set(__self__, "failover_ratio", failover_ratio)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)

    @property
    @pulumi.getter(name="backupPool")
    def backup_pool(self) -> Optional[pulumi.Input[str]]:
        """
        URL to the backup target pool. Must also set
        failover_ratio.
        """
        return pulumi.get(self, "backup_pool")

    @backup_pool.setter
    def backup_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_pool", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Textual description field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="failoverRatio")
    def failover_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        Ratio (0 to 1) of failed nodes before using the
        backup pool (which must also be set).
        """
        return pulumi.get(self, "failover_ratio")

    @failover_ratio.setter
    def failover_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "failover_ratio", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[str]]:
        """
        List of zero or one health check name or self_link. Only
        legacy `compute.HttpHealthCheck` is supported.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of instances in the pool. They can be given as
        URLs, or in the form of "zone/name". Note that the instances need not exist
        at the time of target pool creation, so there is no need to use the
        interpolation to create a dependency on the instances from the
        target pool.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the resource, required by GCE. Changing
        this forces a new resource to be created.

        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Where the target pool resides. Defaults to project
        region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The resource URL for the security policy associated with this target pool.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        How to distribute load. Options are "NONE" (no
        affinity). "CLIENT_IP" (hash of the source/dest addresses / ports), and
        "CLIENT_IP_PROTO" also includes the protocol (default "NONE").
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)


class TargetPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover_ratio: Optional[pulumi.Input[float]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Target Pool within GCE. This is a collection of instances used as
        target of a network load balancer (Forwarding Rule). For more information see
        [the official
        documentation](https://cloud.google.com/compute/docs/load-balancing/network/target-pools)
        and [API](https://cloud.google.com/compute/docs/reference/latest/targetPools).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="default",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.TargetPool("default",
            name="instance-pool",
            instances=[
                "us-central1-a/myinstance1",
                "us-central1-b/myinstance2",
            ],
            health_checks=default_http_health_check.name)
        ```

        ## Import

        Target pools can be imported using any of the following formats:

        * `projects/{{project}}/regions/{{region}}/targetPools/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, target pools can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/targetPool:TargetPool default projects/{{project}}/regions/{{region}}/targetPools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetPool:TargetPool default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetPool:TargetPool default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetPool:TargetPool default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_pool: URL to the backup target pool. Must also set
               failover_ratio.
        :param pulumi.Input[str] description: Textual description field.
        :param pulumi.Input[float] failover_ratio: Ratio (0 to 1) of failed nodes before using the
               backup pool (which must also be set).
        :param pulumi.Input[str] health_checks: List of zero or one health check name or self_link. Only
               legacy `compute.HttpHealthCheck` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: List of instances in the pool. They can be given as
               URLs, or in the form of "zone/name". Note that the instances need not exist
               at the time of target pool creation, so there is no need to use the
               interpolation to create a dependency on the instances from the
               target pool.
        :param pulumi.Input[str] name: A unique name for the resource, required by GCE. Changing
               this forces a new resource to be created.
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: Where the target pool resides. Defaults to project
               region.
        :param pulumi.Input[str] security_policy: The resource URL for the security policy associated with this target pool.
        :param pulumi.Input[str] session_affinity: How to distribute load. Options are "NONE" (no
               affinity). "CLIENT_IP" (hash of the source/dest addresses / ports), and
               "CLIENT_IP_PROTO" also includes the protocol (default "NONE").
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TargetPoolArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Target Pool within GCE. This is a collection of instances used as
        target of a network load balancer (Forwarding Rule). For more information see
        [the official
        documentation](https://cloud.google.com/compute/docs/load-balancing/network/target-pools)
        and [API](https://cloud.google.com/compute/docs/reference/latest/targetPools).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_http_health_check = gcp.compute.HttpHealthCheck("default",
            name="default",
            request_path="/",
            check_interval_sec=1,
            timeout_sec=1)
        default = gcp.compute.TargetPool("default",
            name="instance-pool",
            instances=[
                "us-central1-a/myinstance1",
                "us-central1-b/myinstance2",
            ],
            health_checks=default_http_health_check.name)
        ```

        ## Import

        Target pools can be imported using any of the following formats:

        * `projects/{{project}}/regions/{{region}}/targetPools/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, target pools can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/targetPool:TargetPool default projects/{{project}}/regions/{{region}}/targetPools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetPool:TargetPool default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetPool:TargetPool default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/targetPool:TargetPool default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TargetPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_pool: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover_ratio: Optional[pulumi.Input[float]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetPoolArgs.__new__(TargetPoolArgs)

            __props__.__dict__["backup_pool"] = backup_pool
            __props__.__dict__["description"] = description
            __props__.__dict__["failover_ratio"] = failover_ratio
            __props__.__dict__["health_checks"] = health_checks
            __props__.__dict__["instances"] = instances
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["security_policy"] = security_policy
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["self_link"] = None
        super(TargetPool, __self__).__init__(
            'gcp:compute/targetPool:TargetPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_pool: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            failover_ratio: Optional[pulumi.Input[float]] = None,
            health_checks: Optional[pulumi.Input[str]] = None,
            instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_policy: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            session_affinity: Optional[pulumi.Input[str]] = None) -> 'TargetPool':
        """
        Get an existing TargetPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_pool: URL to the backup target pool. Must also set
               failover_ratio.
        :param pulumi.Input[str] description: Textual description field.
        :param pulumi.Input[float] failover_ratio: Ratio (0 to 1) of failed nodes before using the
               backup pool (which must also be set).
        :param pulumi.Input[str] health_checks: List of zero or one health check name or self_link. Only
               legacy `compute.HttpHealthCheck` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: List of instances in the pool. They can be given as
               URLs, or in the form of "zone/name". Note that the instances need not exist
               at the time of target pool creation, so there is no need to use the
               interpolation to create a dependency on the instances from the
               target pool.
        :param pulumi.Input[str] name: A unique name for the resource, required by GCE. Changing
               this forces a new resource to be created.
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[str] region: Where the target pool resides. Defaults to project
               region.
        :param pulumi.Input[str] security_policy: The resource URL for the security policy associated with this target pool.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] session_affinity: How to distribute load. Options are "NONE" (no
               affinity). "CLIENT_IP" (hash of the source/dest addresses / ports), and
               "CLIENT_IP_PROTO" also includes the protocol (default "NONE").
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetPoolState.__new__(_TargetPoolState)

        __props__.__dict__["backup_pool"] = backup_pool
        __props__.__dict__["description"] = description
        __props__.__dict__["failover_ratio"] = failover_ratio
        __props__.__dict__["health_checks"] = health_checks
        __props__.__dict__["instances"] = instances
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["security_policy"] = security_policy
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["session_affinity"] = session_affinity
        return TargetPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupPool")
    def backup_pool(self) -> pulumi.Output[Optional[str]]:
        """
        URL to the backup target pool. Must also set
        failover_ratio.
        """
        return pulumi.get(self, "backup_pool")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Textual description field.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="failoverRatio")
    def failover_ratio(self) -> pulumi.Output[Optional[float]]:
        """
        Ratio (0 to 1) of failed nodes before using the
        backup pool (which must also be set).
        """
        return pulumi.get(self, "failover_ratio")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> pulumi.Output[Optional[str]]:
        """
        List of zero or one health check name or self_link. Only
        legacy `compute.HttpHealthCheck` is supported.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter
    def instances(self) -> pulumi.Output[Sequence[str]]:
        """
        List of instances in the pool. They can be given as
        URLs, or in the form of "zone/name". Note that the instances need not exist
        at the time of target pool creation, so there is no need to use the
        interpolation to create a dependency on the instances from the
        target pool.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the resource, required by GCE. Changing
        this forces a new resource to be created.

        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Where the target pool resides. Defaults to project
        region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The resource URL for the security policy associated with this target pool.
        """
        return pulumi.get(self, "security_policy")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[Optional[str]]:
        """
        How to distribute load. Options are "NONE" (no
        affinity). "CLIENT_IP" (hash of the source/dest addresses / ports), and
        "CLIENT_IP_PROTO" also includes the protocol (default "NONE").
        """
        return pulumi.get(self, "session_affinity")

