# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsNodePoolArgs', 'AwsNodePool']

@pulumi.input_type
class AwsNodePoolArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['AwsNodePoolAutoscalingArgs'],
                 cluster: pulumi.Input[str],
                 config: pulumi.Input['AwsNodePoolConfigArgs'],
                 location: pulumi.Input[str],
                 max_pods_constraint: pulumi.Input['AwsNodePoolMaxPodsConstraintArgs'],
                 subnet_id: pulumi.Input[str],
                 version: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 management: Optional[pulumi.Input['AwsNodePoolManagementArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 update_settings: Optional[pulumi.Input['AwsNodePoolUpdateSettingsArgs']] = None):
        """
        The set of arguments for constructing a AwsNodePool resource.
        :param pulumi.Input['AwsNodePoolAutoscalingArgs'] autoscaling: Autoscaler configuration for this node pool.
        :param pulumi.Input[str] cluster: The awsCluster for the resource
        :param pulumi.Input['AwsNodePoolConfigArgs'] config: The configuration of the node pool.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input['AwsNodePoolMaxPodsConstraintArgs'] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[str] subnet_id: The subnet where the node pool node run.
        :param pulumi.Input[str] version: The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
               of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['AwsNodePoolManagementArgs'] management: The Management configuration for this node pool.
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input['AwsNodePoolUpdateSettingsArgs'] update_settings: Optional. Update settings control the speed and disruption of the node pool update.
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "max_pods_constraint", max_pods_constraint)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "version", version)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_settings is not None:
            pulumi.set(__self__, "update_settings", update_settings)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['AwsNodePoolAutoscalingArgs']:
        """
        Autoscaler configuration for this node pool.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['AwsNodePoolAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[str]:
        """
        The awsCluster for the resource
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['AwsNodePoolConfigArgs']:
        """
        The configuration of the node pool.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['AwsNodePoolConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> pulumi.Input['AwsNodePoolMaxPodsConstraintArgs']:
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @max_pods_constraint.setter
    def max_pods_constraint(self, value: pulumi.Input['AwsNodePoolMaxPodsConstraintArgs']):
        pulumi.set(self, "max_pods_constraint", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet where the node pool node run.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
        of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['AwsNodePoolManagementArgs']]:
        """
        The Management configuration for this node pool.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['AwsNodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateSettings")
    def update_settings(self) -> Optional[pulumi.Input['AwsNodePoolUpdateSettingsArgs']]:
        """
        Optional. Update settings control the speed and disruption of the node pool update.
        """
        return pulumi.get(self, "update_settings")

    @update_settings.setter
    def update_settings(self, value: Optional[pulumi.Input['AwsNodePoolUpdateSettingsArgs']]):
        pulumi.set(self, "update_settings", value)


@pulumi.input_type
class _AwsNodePoolState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 autoscaling: Optional[pulumi.Input['AwsNodePoolAutoscalingArgs']] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input['AwsNodePoolConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management: Optional[pulumi.Input['AwsNodePoolManagementArgs']] = None,
                 max_pods_constraint: Optional[pulumi.Input['AwsNodePoolMaxPodsConstraintArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_settings: Optional[pulumi.Input['AwsNodePoolUpdateSettingsArgs']] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AwsNodePool resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
               of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['AwsNodePoolAutoscalingArgs'] autoscaling: Autoscaler configuration for this node pool.
        :param pulumi.Input[str] cluster: The awsCluster for the resource
        :param pulumi.Input['AwsNodePoolConfigArgs'] config: The configuration of the node pool.
        :param pulumi.Input[str] create_time: Output only. The time at which this node pool was created.
        :param pulumi.Input[str] etag: Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input['AwsNodePoolManagementArgs'] management: The Management configuration for this node pool.
        :param pulumi.Input['AwsNodePoolMaxPodsConstraintArgs'] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] reconciling: Output only. If set, there are currently changes in flight to the node pool.
        :param pulumi.Input[str] state: Output only. The lifecycle state of the node pool. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        :param pulumi.Input[str] subnet_id: The subnet where the node pool node run.
        :param pulumi.Input[str] uid: Output only. A globally unique identifier for the node pool.
        :param pulumi.Input['AwsNodePoolUpdateSettingsArgs'] update_settings: Optional. Update settings control the speed and disruption of the node pool update.
        :param pulumi.Input[str] update_time: Output only. The time at which this node pool was last updated.
        :param pulumi.Input[str] version: The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if max_pods_constraint is not None:
            pulumi.set(__self__, "max_pods_constraint", max_pods_constraint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_settings is not None:
            pulumi.set(__self__, "update_settings", update_settings)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
        of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['AwsNodePoolAutoscalingArgs']]:
        """
        Autoscaler configuration for this node pool.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['AwsNodePoolAutoscalingArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[str]]:
        """
        The awsCluster for the resource
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['AwsNodePoolConfigArgs']]:
        """
        The configuration of the node pool.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['AwsNodePoolConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time at which this node pool was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['AwsNodePoolManagementArgs']]:
        """
        The Management configuration for this node pool.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['AwsNodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> Optional[pulumi.Input['AwsNodePoolMaxPodsConstraintArgs']]:
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @max_pods_constraint.setter
    def max_pods_constraint(self, value: Optional[pulumi.Input['AwsNodePoolMaxPodsConstraintArgs']]):
        pulumi.set(self, "max_pods_constraint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        Output only. If set, there are currently changes in flight to the node pool.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The lifecycle state of the node pool. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet where the node pool node run.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. A globally unique identifier for the node pool.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateSettings")
    def update_settings(self) -> Optional[pulumi.Input['AwsNodePoolUpdateSettingsArgs']]:
        """
        Optional. Update settings control the speed and disruption of the node pool update.
        """
        return pulumi.get(self, "update_settings")

    @update_settings.setter
    def update_settings(self, value: Optional[pulumi.Input['AwsNodePoolUpdateSettingsArgs']]):
        pulumi.set(self, "update_settings", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time at which this node pool was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class AwsNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 autoscaling: Optional[pulumi.Input[Union['AwsNodePoolAutoscalingArgs', 'AwsNodePoolAutoscalingArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Union['AwsNodePoolConfigArgs', 'AwsNodePoolConfigArgsDict']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management: Optional[pulumi.Input[Union['AwsNodePoolManagementArgs', 'AwsNodePoolManagementArgsDict']]] = None,
                 max_pods_constraint: Optional[pulumi.Input[Union['AwsNodePoolMaxPodsConstraintArgs', 'AwsNodePoolMaxPodsConstraintArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 update_settings: Optional[pulumi.Input[Union['AwsNodePoolUpdateSettingsArgs', 'AwsNodePoolUpdateSettingsArgsDict']]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An Anthos node pool running on AWS.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/kubernetes-engine/multi-cloud/docs)
        ## Example Usage

        ### Basic_aws_cluster
        A basic example of a containeraws node pool
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        primary_aws_node_pool = gcp.container.AwsNodePool("primary",
            autoscaling={
                "max_node_count": 5,
                "min_node_count": 1,
            },
            cluster=primary.name,
            config={
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-nodepool",
                "instance_type": "t3.medium",
                "labels": {
                    "label_one": "value-one",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "tag_one": "value-one",
                },
                "taints": [{
                    "effect": "PREFER_NO_SCHEDULE",
                    "key": "taint-key",
                    "value": "taint-value",
                }],
            },
            location="us-west1",
            max_pods_constraint={
                "max_pods_per_node": 110,
            },
            name="node-pool-name",
            subnet_id="subnet-00000000000000000",
            version=versions.valid_versions[0],
            annotations={
                "label-one": "value-one",
            },
            management={
                "auto_repair": True,
            },
            project="my-project-name")
        ```
        ### Basic_enum_aws_cluster
        A basic example of a containeraws node pool with lowercase enums
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        primary_aws_node_pool = gcp.container.AwsNodePool("primary",
            autoscaling={
                "max_node_count": 5,
                "min_node_count": 1,
            },
            cluster=primary.name,
            config={
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-nodepool",
                "instance_type": "t3.medium",
                "labels": {
                    "label_one": "value-one",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "tag_one": "value-one",
                },
                "taints": [{
                    "effect": "prefer_no_schedule",
                    "key": "taint-key",
                    "value": "taint-value",
                }],
            },
            location="us-west1",
            max_pods_constraint={
                "max_pods_per_node": 110,
            },
            name="node-pool-name",
            subnet_id="subnet-00000000000000000",
            version=versions.valid_versions[0],
            annotations={
                "label-one": "value-one",
            },
            project="my-project-name")
        ```
        ### Beta_basic_enum_aws_cluster
        A basic example of a containeraws node pool with lowercase enums (beta)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        primary_aws_node_pool = gcp.container.AwsNodePool("primary",
            autoscaling={
                "max_node_count": 5,
                "min_node_count": 1,
            },
            cluster=primary.name,
            config={
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-nodepool",
                "instance_type": "t3.medium",
                "labels": {
                    "label_one": "value-one",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "tag_one": "value-one",
                },
                "taints": [{
                    "effect": "prefer_no_schedule",
                    "key": "taint-key",
                    "value": "taint-value",
                }],
                "instance_placement": {
                    "tenancy": "dedicated",
                },
                "image_type": "ubuntu",
            },
            location="us-west1",
            max_pods_constraint={
                "max_pods_per_node": 110,
            },
            name="node-pool-name",
            subnet_id="subnet-00000000000000000",
            version=versions.valid_versions[0],
            annotations={
                "label-one": "value-one",
            },
            project="my-project-name")
        ```

        ## Import

        NodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/awsClusters/{{cluster}}/awsNodePools/{{name}}`

        * `{{project}}/{{location}}/{{cluster}}/{{name}}`

        * `{{location}}/{{cluster}}/{{name}}`

        When using the `pulumi import` command, NodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/awsNodePool:AwsNodePool default projects/{{project}}/locations/{{location}}/awsClusters/{{cluster}}/awsNodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/awsNodePool:AwsNodePool default {{project}}/{{location}}/{{cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/awsNodePool:AwsNodePool default {{location}}/{{cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
               of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['AwsNodePoolAutoscalingArgs', 'AwsNodePoolAutoscalingArgsDict']] autoscaling: Autoscaler configuration for this node pool.
        :param pulumi.Input[str] cluster: The awsCluster for the resource
        :param pulumi.Input[Union['AwsNodePoolConfigArgs', 'AwsNodePoolConfigArgsDict']] config: The configuration of the node pool.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[Union['AwsNodePoolManagementArgs', 'AwsNodePoolManagementArgsDict']] management: The Management configuration for this node pool.
        :param pulumi.Input[Union['AwsNodePoolMaxPodsConstraintArgs', 'AwsNodePoolMaxPodsConstraintArgsDict']] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] subnet_id: The subnet where the node pool node run.
        :param pulumi.Input[Union['AwsNodePoolUpdateSettingsArgs', 'AwsNodePoolUpdateSettingsArgsDict']] update_settings: Optional. Update settings control the speed and disruption of the node pool update.
        :param pulumi.Input[str] version: The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Anthos node pool running on AWS.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/kubernetes-engine/multi-cloud/docs)
        ## Example Usage

        ### Basic_aws_cluster
        A basic example of a containeraws node pool
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        primary_aws_node_pool = gcp.container.AwsNodePool("primary",
            autoscaling={
                "max_node_count": 5,
                "min_node_count": 1,
            },
            cluster=primary.name,
            config={
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-nodepool",
                "instance_type": "t3.medium",
                "labels": {
                    "label_one": "value-one",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "tag_one": "value-one",
                },
                "taints": [{
                    "effect": "PREFER_NO_SCHEDULE",
                    "key": "taint-key",
                    "value": "taint-value",
                }],
            },
            location="us-west1",
            max_pods_constraint={
                "max_pods_per_node": 110,
            },
            name="node-pool-name",
            subnet_id="subnet-00000000000000000",
            version=versions.valid_versions[0],
            annotations={
                "label-one": "value-one",
            },
            management={
                "auto_repair": True,
            },
            project="my-project-name")
        ```
        ### Basic_enum_aws_cluster
        A basic example of a containeraws node pool with lowercase enums
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        primary_aws_node_pool = gcp.container.AwsNodePool("primary",
            autoscaling={
                "max_node_count": 5,
                "min_node_count": 1,
            },
            cluster=primary.name,
            config={
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-nodepool",
                "instance_type": "t3.medium",
                "labels": {
                    "label_one": "value-one",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "tag_one": "value-one",
                },
                "taints": [{
                    "effect": "prefer_no_schedule",
                    "key": "taint-key",
                    "value": "taint-value",
                }],
            },
            location="us-west1",
            max_pods_constraint={
                "max_pods_per_node": 110,
            },
            name="node-pool-name",
            subnet_id="subnet-00000000000000000",
            version=versions.valid_versions[0],
            annotations={
                "label-one": "value-one",
            },
            project="my-project-name")
        ```
        ### Beta_basic_enum_aws_cluster
        A basic example of a containeraws node pool with lowercase enums (beta)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        primary_aws_node_pool = gcp.container.AwsNodePool("primary",
            autoscaling={
                "max_node_count": 5,
                "min_node_count": 1,
            },
            cluster=primary.name,
            config={
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-nodepool",
                "instance_type": "t3.medium",
                "labels": {
                    "label_one": "value-one",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "tag_one": "value-one",
                },
                "taints": [{
                    "effect": "prefer_no_schedule",
                    "key": "taint-key",
                    "value": "taint-value",
                }],
                "instance_placement": {
                    "tenancy": "dedicated",
                },
                "image_type": "ubuntu",
            },
            location="us-west1",
            max_pods_constraint={
                "max_pods_per_node": 110,
            },
            name="node-pool-name",
            subnet_id="subnet-00000000000000000",
            version=versions.valid_versions[0],
            annotations={
                "label-one": "value-one",
            },
            project="my-project-name")
        ```

        ## Import

        NodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/awsClusters/{{cluster}}/awsNodePools/{{name}}`

        * `{{project}}/{{location}}/{{cluster}}/{{name}}`

        * `{{location}}/{{cluster}}/{{name}}`

        When using the `pulumi import` command, NodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/awsNodePool:AwsNodePool default projects/{{project}}/locations/{{location}}/awsClusters/{{cluster}}/awsNodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/awsNodePool:AwsNodePool default {{project}}/{{location}}/{{cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/awsNodePool:AwsNodePool default {{location}}/{{cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AwsNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 autoscaling: Optional[pulumi.Input[Union['AwsNodePoolAutoscalingArgs', 'AwsNodePoolAutoscalingArgsDict']]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[Union['AwsNodePoolConfigArgs', 'AwsNodePoolConfigArgsDict']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management: Optional[pulumi.Input[Union['AwsNodePoolManagementArgs', 'AwsNodePoolManagementArgsDict']]] = None,
                 max_pods_constraint: Optional[pulumi.Input[Union['AwsNodePoolMaxPodsConstraintArgs', 'AwsNodePoolMaxPodsConstraintArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 update_settings: Optional[pulumi.Input[Union['AwsNodePoolUpdateSettingsArgs', 'AwsNodePoolUpdateSettingsArgsDict']]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsNodePoolArgs.__new__(AwsNodePoolArgs)

            __props__.__dict__["annotations"] = annotations
            if autoscaling is None and not opts.urn:
                raise TypeError("Missing required property 'autoscaling'")
            __props__.__dict__["autoscaling"] = autoscaling
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["management"] = management
            if max_pods_constraint is None and not opts.urn:
                raise TypeError("Missing required property 'max_pods_constraint'")
            __props__.__dict__["max_pods_constraint"] = max_pods_constraint
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["update_settings"] = update_settings
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(AwsNodePool, __self__).__init__(
            'gcp:container/awsNodePool:AwsNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            autoscaling: Optional[pulumi.Input[Union['AwsNodePoolAutoscalingArgs', 'AwsNodePoolAutoscalingArgsDict']]] = None,
            cluster: Optional[pulumi.Input[str]] = None,
            config: Optional[pulumi.Input[Union['AwsNodePoolConfigArgs', 'AwsNodePoolConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            management: Optional[pulumi.Input[Union['AwsNodePoolManagementArgs', 'AwsNodePoolManagementArgsDict']]] = None,
            max_pods_constraint: Optional[pulumi.Input[Union['AwsNodePoolMaxPodsConstraintArgs', 'AwsNodePoolMaxPodsConstraintArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_settings: Optional[pulumi.Input[Union['AwsNodePoolUpdateSettingsArgs', 'AwsNodePoolUpdateSettingsArgsDict']]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'AwsNodePool':
        """
        Get an existing AwsNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
               of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['AwsNodePoolAutoscalingArgs', 'AwsNodePoolAutoscalingArgsDict']] autoscaling: Autoscaler configuration for this node pool.
        :param pulumi.Input[str] cluster: The awsCluster for the resource
        :param pulumi.Input[Union['AwsNodePoolConfigArgs', 'AwsNodePoolConfigArgsDict']] config: The configuration of the node pool.
        :param pulumi.Input[str] create_time: Output only. The time at which this node pool was created.
        :param pulumi.Input[str] etag: Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[Union['AwsNodePoolManagementArgs', 'AwsNodePoolManagementArgsDict']] management: The Management configuration for this node pool.
        :param pulumi.Input[Union['AwsNodePoolMaxPodsConstraintArgs', 'AwsNodePoolMaxPodsConstraintArgsDict']] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] reconciling: Output only. If set, there are currently changes in flight to the node pool.
        :param pulumi.Input[str] state: Output only. The lifecycle state of the node pool. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        :param pulumi.Input[str] subnet_id: The subnet where the node pool node run.
        :param pulumi.Input[str] uid: Output only. A globally unique identifier for the node pool.
        :param pulumi.Input[Union['AwsNodePoolUpdateSettingsArgs', 'AwsNodePoolUpdateSettingsArgsDict']] update_settings: Optional. Update settings control the speed and disruption of the node pool update.
        :param pulumi.Input[str] update_time: Output only. The time at which this node pool was last updated.
        :param pulumi.Input[str] version: The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsNodePoolState.__new__(_AwsNodePoolState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["autoscaling"] = autoscaling
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["config"] = config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["management"] = management
        __props__.__dict__["max_pods_constraint"] = max_pods_constraint
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_settings"] = update_settings
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["version"] = version
        return AwsNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
        of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Output['outputs.AwsNodePoolAutoscaling']:
        """
        Autoscaler configuration for this node pool.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[str]:
        """
        The awsCluster for the resource
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.AwsNodePoolConfig']:
        """
        The configuration of the node pool.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. The time at which this node pool was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def management(self) -> pulumi.Output['outputs.AwsNodePoolManagement']:
        """
        The Management configuration for this node pool.
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> pulumi.Output['outputs.AwsNodePoolMaxPodsConstraint']:
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        Output only. If set, there are currently changes in flight to the node pool.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Output only. The lifecycle state of the node pool. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The subnet where the node pool node run.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. A globally unique identifier for the node pool.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateSettings")
    def update_settings(self) -> pulumi.Output['outputs.AwsNodePoolUpdateSettings']:
        """
        Optional. Update settings control the speed and disruption of the node pool update.
        """
        return pulumi.get(self, "update_settings")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The time at which this node pool was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
        """
        return pulumi.get(self, "version")

