# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AzureClientArgs', 'AzureClient']

@pulumi.input_type
class AzureClientArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 location: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzureClient resource.
        :param pulumi.Input[str] application_id: The Azure Active Directory Application ID.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] tenant_id: The Azure Active Directory Tenant ID.
               
               
               
               - - -
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The project for the resource
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        The Azure Active Directory Application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The Azure Active Directory Tenant ID.



        - - -
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AzureClientState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzureClient resources.
        :param pulumi.Input[str] application_id: The Azure Active Directory Application ID.
        :param pulumi.Input[str] certificate: Output only. The PEM encoded x509 certificate.
        :param pulumi.Input[str] create_time: Output only. The time at which this resource was created.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] tenant_id: The Azure Active Directory Tenant ID.
               
               
               
               - - -
        :param pulumi.Input[str] uid: Output only. A globally unique identifier for the client.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Active Directory Application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The PEM encoded x509 certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time at which this resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Active Directory Tenant ID.



        - - -
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. A globally unique identifier for the client.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


class AzureClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        AzureClient resources hold client authentication information needed by the Anthos Multi-Cloud API to manage Azure resources on your Azure subscription.When an AzureCluster is created, an AzureClient resource needs to be provided and all operations on Azure resources associated to that cluster will authenticate to Azure services using the given client.AzureClient resources are immutable and cannot be modified upon creation.Each AzureClient resource is bound to a single Azure Active Directory Application and tenant.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/kubernetes-engine/multi-cloud/docs)
        ## Example Usage

        ### Basic_azure_client
        A basic example of a containerazure azure client
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.AzureClient("primary",
            application_id="12345678-1234-1234-1234-123456789111",
            location="us-west1",
            name="client-name",
            tenant_id="12345678-1234-1234-1234-123456789111",
            project="my-project-name")
        ```

        ## Import

        Client can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/azureClients/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Client can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/azureClient:AzureClient default projects/{{project}}/locations/{{location}}/azureClients/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/azureClient:AzureClient default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/azureClient:AzureClient default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The Azure Active Directory Application ID.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] tenant_id: The Azure Active Directory Tenant ID.
               
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AzureClient resources hold client authentication information needed by the Anthos Multi-Cloud API to manage Azure resources on your Azure subscription.When an AzureCluster is created, an AzureClient resource needs to be provided and all operations on Azure resources associated to that cluster will authenticate to Azure services using the given client.AzureClient resources are immutable and cannot be modified upon creation.Each AzureClient resource is bound to a single Azure Active Directory Application and tenant.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/kubernetes-engine/multi-cloud/docs)
        ## Example Usage

        ### Basic_azure_client
        A basic example of a containerazure azure client
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.AzureClient("primary",
            application_id="12345678-1234-1234-1234-123456789111",
            location="us-west1",
            name="client-name",
            tenant_id="12345678-1234-1234-1234-123456789111",
            project="my-project-name")
        ```

        ## Import

        Client can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/azureClients/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Client can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/azureClient:AzureClient default projects/{{project}}/locations/{{location}}/azureClients/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/azureClient:AzureClient default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/azureClient:AzureClient default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AzureClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureClientArgs.__new__(AzureClientArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["certificate"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["uid"] = None
        super(AzureClient, __self__).__init__(
            'gcp:container/azureClient:AzureClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None) -> 'AzureClient':
        """
        Get an existing AzureClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: The Azure Active Directory Application ID.
        :param pulumi.Input[str] certificate: Output only. The PEM encoded x509 certificate.
        :param pulumi.Input[str] create_time: Output only. The time at which this resource was created.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] tenant_id: The Azure Active Directory Tenant ID.
               
               
               
               - - -
        :param pulumi.Input[str] uid: Output only. A globally unique identifier for the client.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureClientState.__new__(_AzureClientState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["uid"] = uid
        return AzureClient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[str]:
        """
        The Azure Active Directory Application ID.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        Output only. The PEM encoded x509 certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. The time at which this resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The Azure Active Directory Tenant ID.



        - - -
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. A globally unique identifier for the client.
        """
        return pulumi.get(self, "uid")

