# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionProfileAlloydb',
    'ConnectionProfileAlloydbSettings',
    'ConnectionProfileAlloydbSettingsInitialUser',
    'ConnectionProfileAlloydbSettingsPrimaryInstanceSettings',
    'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig',
    'ConnectionProfileCloudsql',
    'ConnectionProfileCloudsqlSettings',
    'ConnectionProfileCloudsqlSettingsIpConfig',
    'ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetwork',
    'ConnectionProfileError',
    'ConnectionProfileMysql',
    'ConnectionProfileMysqlSsl',
    'ConnectionProfileOracle',
    'ConnectionProfileOracleForwardSshConnectivity',
    'ConnectionProfileOraclePrivateConnectivity',
    'ConnectionProfileOracleSsl',
    'ConnectionProfileOracleStaticServiceIpConnectivity',
    'ConnectionProfilePostgresql',
    'ConnectionProfilePostgresqlSsl',
    'MigrationJobDumpFlags',
    'MigrationJobDumpFlagsDumpFlag',
    'MigrationJobError',
    'MigrationJobPerformanceConfig',
    'MigrationJobReverseSshConnectivity',
    'MigrationJobStaticIpConnectivity',
    'MigrationJobVpcPeeringConnectivity',
    'PrivateConnectionError',
    'PrivateConnectionVpcPeeringConfig',
]

@pulumi.output_type
class ConnectionProfileAlloydb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileAlloydb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileAlloydb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileAlloydb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: str,
                 settings: Optional['outputs.ConnectionProfileAlloydbSettings'] = None):
        """
        :param str cluster_id: Required. The AlloyDB cluster ID that this connection profile is associated with.
        :param 'ConnectionProfileAlloydbSettingsArgs' settings: Immutable. Metadata used to create the destination AlloyDB cluster.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        Required. The AlloyDB cluster ID that this connection profile is associated with.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.ConnectionProfileAlloydbSettings']:
        """
        Immutable. Metadata used to create the destination AlloyDB cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class ConnectionProfileAlloydbSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialUser":
            suggest = "initial_user"
        elif key == "vpcNetwork":
            suggest = "vpc_network"
        elif key == "primaryInstanceSettings":
            suggest = "primary_instance_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileAlloydbSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileAlloydbSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileAlloydbSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_user: 'outputs.ConnectionProfileAlloydbSettingsInitialUser',
                 vpc_network: str,
                 labels: Optional[Mapping[str, str]] = None,
                 primary_instance_settings: Optional['outputs.ConnectionProfileAlloydbSettingsPrimaryInstanceSettings'] = None):
        """
        :param 'ConnectionProfileAlloydbSettingsInitialUserArgs' initial_user: Required. Input only. Initial user to setup during cluster creation.
               Structure is documented below.
        :param str vpc_network: Required. The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
               It is specified in the form: 'projects/{project_number}/global/networks/{network_id}'. This is required to create a cluster.
        :param Mapping[str, str] labels: Labels for the AlloyDB cluster created by DMS.
        :param 'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs' primary_instance_settings: Settings for the cluster's primary instance
               Structure is documented below.
        """
        pulumi.set(__self__, "initial_user", initial_user)
        pulumi.set(__self__, "vpc_network", vpc_network)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if primary_instance_settings is not None:
            pulumi.set(__self__, "primary_instance_settings", primary_instance_settings)

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> 'outputs.ConnectionProfileAlloydbSettingsInitialUser':
        """
        Required. Input only. Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @property
    @pulumi.getter(name="vpcNetwork")
    def vpc_network(self) -> str:
        """
        Required. The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: 'projects/{project_number}/global/networks/{network_id}'. This is required to create a cluster.
        """
        return pulumi.get(self, "vpc_network")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Labels for the AlloyDB cluster created by DMS.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="primaryInstanceSettings")
    def primary_instance_settings(self) -> Optional['outputs.ConnectionProfileAlloydbSettingsPrimaryInstanceSettings']:
        """
        Settings for the cluster's primary instance
        Structure is documented below.
        """
        return pulumi.get(self, "primary_instance_settings")


@pulumi.output_type
class ConnectionProfileAlloydbSettingsInitialUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSet":
            suggest = "password_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileAlloydbSettingsInitialUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileAlloydbSettingsInitialUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileAlloydbSettingsInitialUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 user: str,
                 password_set: Optional[bool] = None):
        """
        :param str password: The initial password for the user.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str user: The database username.
        :param bool password_set: (Output)
               Output only. Indicates if the initialUser.password field has been set.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The database username.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[bool]:
        """
        (Output)
        Output only. Indicates if the initialUser.password field has been set.
        """
        return pulumi.get(self, "password_set")


@pulumi.output_type
class ConnectionProfileAlloydbSettingsPrimaryInstanceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineConfig":
            suggest = "machine_config"
        elif key == "databaseFlags":
            suggest = "database_flags"
        elif key == "privateIp":
            suggest = "private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileAlloydbSettingsPrimaryInstanceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileAlloydbSettingsPrimaryInstanceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileAlloydbSettingsPrimaryInstanceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 machine_config: 'outputs.ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig',
                 database_flags: Optional[Mapping[str, str]] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 private_ip: Optional[str] = None):
        """
        :param str id: The database username.
        :param 'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs' machine_config: Configuration for the machines that host the underlying database engine.
               Structure is documented below.
        :param Mapping[str, str] database_flags: Database flags to pass to AlloyDB when DMS is creating the AlloyDB cluster and instances. See the AlloyDB documentation for how these can be used.
        :param Mapping[str, str] labels: Labels for the AlloyDB primary instance created by DMS.
        :param str private_ip: (Output)
               Output only. The private IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "machine_config", machine_config)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The database username.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> 'outputs.ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig':
        """
        Configuration for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[Mapping[str, str]]:
        """
        Database flags to pass to AlloyDB when DMS is creating the AlloyDB cluster and instances. See the AlloyDB documentation for how these can be used.
        """
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Labels for the AlloyDB primary instance created by DMS.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        (Output)
        Output only. The private IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        return pulumi.get(self, "private_ip")


@pulumi.output_type
class ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: int):
        """
        :param int cpu_count: The number of CPU's in the VM instance.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> int:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")


@pulumi.output_type
class ConnectionProfileCloudsql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlId":
            suggest = "cloud_sql_id"
        elif key == "privateIp":
            suggest = "private_ip"
        elif key == "publicIp":
            suggest = "public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileCloudsql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileCloudsql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileCloudsql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_sql_id: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 public_ip: Optional[str] = None,
                 settings: Optional['outputs.ConnectionProfileCloudsqlSettings'] = None):
        """
        :param str cloud_sql_id: (Output)
               Output only. The Cloud SQL instance ID that this connection profile is associated with.
        :param str private_ip: (Output)
               Output only. The Cloud SQL database instance's private IP.
        :param str public_ip: (Output)
               Output only. The Cloud SQL database instance's public IP.
        :param 'ConnectionProfileCloudsqlSettingsArgs' settings: Immutable. Metadata used to create the destination Cloud SQL database.
               Structure is documented below.
        """
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[str]:
        """
        (Output)
        Output only. The Cloud SQL instance ID that this connection profile is associated with.
        """
        return pulumi.get(self, "cloud_sql_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        (Output)
        Output only. The Cloud SQL database instance's private IP.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        """
        (Output)
        Output only. The Cloud SQL database instance's public IP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.ConnectionProfileCloudsqlSettings']:
        """
        Immutable. Metadata used to create the destination Cloud SQL database.
        Structure is documented below.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class ConnectionProfileCloudsqlSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceId":
            suggest = "source_id"
        elif key == "activationPolicy":
            suggest = "activation_policy"
        elif key == "autoStorageIncrease":
            suggest = "auto_storage_increase"
        elif key == "cmekKeyName":
            suggest = "cmek_key_name"
        elif key == "dataDiskSizeGb":
            suggest = "data_disk_size_gb"
        elif key == "dataDiskType":
            suggest = "data_disk_type"
        elif key == "databaseFlags":
            suggest = "database_flags"
        elif key == "databaseVersion":
            suggest = "database_version"
        elif key == "ipConfig":
            suggest = "ip_config"
        elif key == "rootPassword":
            suggest = "root_password"
        elif key == "rootPasswordSet":
            suggest = "root_password_set"
        elif key == "storageAutoResizeLimit":
            suggest = "storage_auto_resize_limit"
        elif key == "userLabels":
            suggest = "user_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileCloudsqlSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileCloudsqlSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileCloudsqlSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_id: str,
                 activation_policy: Optional[str] = None,
                 auto_storage_increase: Optional[bool] = None,
                 cmek_key_name: Optional[str] = None,
                 collation: Optional[str] = None,
                 data_disk_size_gb: Optional[str] = None,
                 data_disk_type: Optional[str] = None,
                 database_flags: Optional[Mapping[str, str]] = None,
                 database_version: Optional[str] = None,
                 edition: Optional[str] = None,
                 ip_config: Optional['outputs.ConnectionProfileCloudsqlSettingsIpConfig'] = None,
                 root_password: Optional[str] = None,
                 root_password_set: Optional[bool] = None,
                 storage_auto_resize_limit: Optional[str] = None,
                 tier: Optional[str] = None,
                 user_labels: Optional[Mapping[str, str]] = None,
                 zone: Optional[str] = None):
        """
        :param str source_id: The Database Migration Service source connection profile ID, in the format: projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID
        :param str activation_policy: The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'.
               Possible values are: `ALWAYS`, `NEVER`.
        :param bool auto_storage_increase: If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity.
               If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        :param str cmek_key_name: The KMS key name used for the csql instance.
        :param str collation: The Cloud SQL default instance level collation.
        :param str data_disk_size_gb: The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        :param str data_disk_type: The type of storage.
               Possible values are: `PD_SSD`, `PD_HDD`.
        :param Mapping[str, str] database_flags: The database flags passed to the Cloud SQL instance at startup.
        :param str database_version: The database engine type and version.
               Currently supported values located at https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles#sqldatabaseversion
        :param str edition: The edition of the given Cloud SQL instance.
               Possible values are: `ENTERPRISE`, `ENTERPRISE_PLUS`.
        :param 'ConnectionProfileCloudsqlSettingsIpConfigArgs' ip_config: The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
               Structure is documented below.
        :param str root_password: Input only. Initial root password.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool root_password_set: (Output)
               Output only. Indicates If this connection profile root password is stored.
        :param str storage_auto_resize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param str tier: The tier (or machine type) for this instance, for example: db-n1-standard-1 (MySQL instances) or db-custom-1-3840 (PostgreSQL instances).
               For more information, see https://cloud.google.com/sql/docs/mysql/instance-settings
        :param Mapping[str, str] user_labels: The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs.
        :param str zone: The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        pulumi.set(__self__, "source_id", source_id)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if auto_storage_increase is not None:
            pulumi.set(__self__, "auto_storage_increase", auto_storage_increase)
        if cmek_key_name is not None:
            pulumi.set(__self__, "cmek_key_name", cmek_key_name)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if data_disk_size_gb is not None:
            pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if ip_config is not None:
            pulumi.set(__self__, "ip_config", ip_config)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if root_password_set is not None:
            pulumi.set(__self__, "root_password_set", root_password_set)
        if storage_auto_resize_limit is not None:
            pulumi.set(__self__, "storage_auto_resize_limit", storage_auto_resize_limit)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> str:
        """
        The Database Migration Service source connection profile ID, in the format: projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[str]:
        """
        The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'.
        Possible values are: `ALWAYS`, `NEVER`.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="autoStorageIncrease")
    def auto_storage_increase(self) -> Optional[bool]:
        """
        If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity.
        If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        """
        return pulumi.get(self, "auto_storage_increase")

    @property
    @pulumi.getter(name="cmekKeyName")
    def cmek_key_name(self) -> Optional[str]:
        """
        The KMS key name used for the csql instance.
        """
        return pulumi.get(self, "cmek_key_name")

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        The Cloud SQL default instance level collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> Optional[str]:
        """
        The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[str]:
        """
        The type of storage.
        Possible values are: `PD_SSD`, `PD_HDD`.
        """
        return pulumi.get(self, "data_disk_type")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[Mapping[str, str]]:
        """
        The database flags passed to the Cloud SQL instance at startup.
        """
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[str]:
        """
        The database engine type and version.
        Currently supported values located at https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles#sqldatabaseversion
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter
    def edition(self) -> Optional[str]:
        """
        The edition of the given Cloud SQL instance.
        Possible values are: `ENTERPRISE`, `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="ipConfig")
    def ip_config(self) -> Optional['outputs.ConnectionProfileCloudsqlSettingsIpConfig']:
        """
        The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
        Structure is documented below.
        """
        return pulumi.get(self, "ip_config")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[str]:
        """
        Input only. Initial root password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="rootPasswordSet")
    def root_password_set(self) -> Optional[bool]:
        """
        (Output)
        Output only. Indicates If this connection profile root password is stored.
        """
        return pulumi.get(self, "root_password_set")

    @property
    @pulumi.getter(name="storageAutoResizeLimit")
    def storage_auto_resize_limit(self) -> Optional[str]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "storage_auto_resize_limit")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier (or machine type) for this instance, for example: db-n1-standard-1 (MySQL instances) or db-custom-1-3840 (PostgreSQL instances).
        For more information, see https://cloud.google.com/sql/docs/mysql/instance-settings
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[Mapping[str, str]]:
        """
        The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ConnectionProfileCloudsqlSettingsIpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizedNetworks":
            suggest = "authorized_networks"
        elif key == "enableIpv4":
            suggest = "enable_ipv4"
        elif key == "privateNetwork":
            suggest = "private_network"
        elif key == "requireSsl":
            suggest = "require_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileCloudsqlSettingsIpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileCloudsqlSettingsIpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileCloudsqlSettingsIpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorized_networks: Optional[Sequence['outputs.ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetwork']] = None,
                 enable_ipv4: Optional[bool] = None,
                 private_network: Optional[str] = None,
                 require_ssl: Optional[bool] = None):
        """
        :param Sequence['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs'] authorized_networks: The list of external networks that are allowed to connect to the instance using the IP.
               Structure is documented below.
        :param bool enable_ipv4: Whether the instance should be assigned an IPv4 address or not.
        :param str private_network: The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               This setting can be updated, but it cannot be removed after it is set.
        :param bool require_ssl: Whether SSL connections over IP should be enforced or not.
        """
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if enable_ipv4 is not None:
            pulumi.set(__self__, "enable_ipv4", enable_ipv4)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[Sequence['outputs.ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetwork']]:
        """
        The list of external networks that are allowed to connect to the instance using the IP.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> Optional[bool]:
        """
        Whether the instance should be assigned an IPv4 address or not.
        """
        return pulumi.get(self, "enable_ipv4")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[str]:
        """
        The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[bool]:
        """
        Whether SSL connections over IP should be enforced or not.
        """
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 expire_time: Optional[str] = None,
                 label: Optional[str] = None,
                 ttl: Optional[str] = None):
        """
        :param str value: The allowlisted value for the access control list.
        :param str expire_time: The time when this access control entry expires in RFC 3339 format.
        :param str label: A label to identify this entry.
        :param str ttl: Input only. The time-to-leave of this access control entry.
        """
        pulumi.set(__self__, "value", value)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The allowlisted value for the access control list.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[str]:
        """
        The time when this access control entry expires in RFC 3339 format.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label to identify this entry.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[str]:
        """
        Input only. The time-to-leave of this access control entry.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ConnectionProfileError(dict):
    def __init__(__self__, *,
                 code: Optional[int] = None,
                 details: Optional[Sequence[Mapping[str, str]]] = None,
                 message: Optional[str] = None):
        """
        :param int code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: (Output)
               A list of messages that carry the error details.
        :param str message: (Output)
               Human readable message indicating details about the current status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, str]]]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ConnectionProfileMysql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlId":
            suggest = "cloud_sql_id"
        elif key == "passwordSet":
            suggest = "password_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileMysql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileMysql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileMysql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_sql_id: Optional[str] = None,
                 host: Optional[str] = None,
                 password: Optional[str] = None,
                 password_set: Optional[bool] = None,
                 port: Optional[int] = None,
                 ssl: Optional['outputs.ConnectionProfileMysqlSsl'] = None,
                 username: Optional[str] = None):
        """
        :param str cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param str host: The IP or hostname of the source MySQL database.
        :param str password: Input only. The password for the user that Database Migration Service will be using to connect to the database.
               This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool password_set: (Output)
               Output only. Indicates If this connection profile password is stored.
        :param int port: The network port of the source MySQL database.
        :param 'ConnectionProfileMysqlSslArgs' ssl: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        :param str username: The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[str]:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The IP or hostname of the source MySQL database.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[bool]:
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The network port of the source MySQL database.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def ssl(self) -> Optional['outputs.ConnectionProfileMysqlSsl']:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionProfileMysqlSsl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileMysqlSsl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileMysqlSsl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileMysqlSsl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: Optional[str] = None,
                 client_key: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str ca_certificate: Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
               The replica will use this certificate to verify it's connecting to the right host.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
               If this field is used then the 'clientKey' field is mandatory
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'clientCertificate' field is mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str type: (Output)
               The current connection profile state.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        The current connection profile state.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionProfileOracle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseService":
            suggest = "database_service"
        elif key == "forwardSshConnectivity":
            suggest = "forward_ssh_connectivity"
        elif key == "passwordSet":
            suggest = "password_set"
        elif key == "privateConnectivity":
            suggest = "private_connectivity"
        elif key == "staticServiceIpConnectivity":
            suggest = "static_service_ip_connectivity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileOracle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileOracle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileOracle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_service: str,
                 host: str,
                 password: str,
                 port: int,
                 username: str,
                 forward_ssh_connectivity: Optional['outputs.ConnectionProfileOracleForwardSshConnectivity'] = None,
                 password_set: Optional[bool] = None,
                 private_connectivity: Optional['outputs.ConnectionProfileOraclePrivateConnectivity'] = None,
                 ssl: Optional['outputs.ConnectionProfileOracleSsl'] = None,
                 static_service_ip_connectivity: Optional['outputs.ConnectionProfileOracleStaticServiceIpConnectivity'] = None):
        """
        :param str database_service: Required. Database service for the Oracle connection.
        :param str host: Required. The IP or hostname of the source Oracle database.
        :param str password: Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
               This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param int port: Required. The network port of the source Oracle database.
        :param str username: Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        :param 'ConnectionProfileOracleForwardSshConnectivityArgs' forward_ssh_connectivity: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        :param bool password_set: (Output)
               Output only. Indicates If this connection profile password is stored.
        :param 'ConnectionProfileOraclePrivateConnectivityArgs' private_connectivity: Configuration for using a private network to communicate with the source database
               Structure is documented below.
        :param 'ConnectionProfileOracleSslArgs' ssl: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        :param 'ConnectionProfileOracleStaticServiceIpConnectivityArgs' static_service_ip_connectivity: This object has no nested fields.
               Static IP address connectivity configured on service project.
        """
        pulumi.set(__self__, "database_service", database_service)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if forward_ssh_connectivity is not None:
            pulumi.set(__self__, "forward_ssh_connectivity", forward_ssh_connectivity)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)
        if private_connectivity is not None:
            pulumi.set(__self__, "private_connectivity", private_connectivity)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if static_service_ip_connectivity is not None:
            pulumi.set(__self__, "static_service_ip_connectivity", static_service_ip_connectivity)

    @property
    @pulumi.getter(name="databaseService")
    def database_service(self) -> str:
        """
        Required. Database service for the Oracle connection.
        """
        return pulumi.get(self, "database_service")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Required. The IP or hostname of the source Oracle database.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Required. The network port of the source Oracle database.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="forwardSshConnectivity")
    def forward_ssh_connectivity(self) -> Optional['outputs.ConnectionProfileOracleForwardSshConnectivity']:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_ssh_connectivity")

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[bool]:
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @property
    @pulumi.getter(name="privateConnectivity")
    def private_connectivity(self) -> Optional['outputs.ConnectionProfileOraclePrivateConnectivity']:
        """
        Configuration for using a private network to communicate with the source database
        Structure is documented below.
        """
        return pulumi.get(self, "private_connectivity")

    @property
    @pulumi.getter
    def ssl(self) -> Optional['outputs.ConnectionProfileOracleSsl']:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter(name="staticServiceIpConnectivity")
    def static_service_ip_connectivity(self) -> Optional['outputs.ConnectionProfileOracleStaticServiceIpConnectivity']:
        """
        This object has no nested fields.
        Static IP address connectivity configured on service project.
        """
        return pulumi.get(self, "static_service_ip_connectivity")


@pulumi.output_type
class ConnectionProfileOracleForwardSshConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileOracleForwardSshConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileOracleForwardSshConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileOracleForwardSshConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 port: int,
                 username: str,
                 password: Optional[str] = None,
                 private_key: Optional[str] = None):
        """
        :param str hostname: Required. Hostname for the SSH tunnel.
        :param int port: Port for the SSH tunnel, default value is 22.
        :param str username: Required. Username for the SSH tunnel.
        :param str password: Input only. SSH password. Only one of `password` and `private_key` can be configured.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str private_key: Input only. SSH private key. Only one of `password` and `private_key` can be configured.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Required. Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port for the SSH tunnel, default value is 22.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Required. Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Input only. SSH password. Only one of `password` and `private_key` can be configured.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[str]:
        """
        Input only. SSH private key. Only one of `password` and `private_key` can be configured.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")


@pulumi.output_type
class ConnectionProfileOraclePrivateConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateConnection":
            suggest = "private_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileOraclePrivateConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileOraclePrivateConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileOraclePrivateConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_connection: str):
        """
        :param str private_connection: Required. The resource name (URI) of the private connection.
        """
        pulumi.set(__self__, "private_connection", private_connection)

    @property
    @pulumi.getter(name="privateConnection")
    def private_connection(self) -> str:
        """
        Required. The resource name (URI) of the private connection.
        """
        return pulumi.get(self, "private_connection")


@pulumi.output_type
class ConnectionProfileOracleSsl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileOracleSsl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileOracleSsl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileOracleSsl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: Optional[str] = None,
                 client_key: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str ca_certificate: Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
               The replica will use this certificate to verify it's connecting to the right host.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
               If this field is used then the 'clientKey' field is mandatory
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'clientCertificate' field is mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str type: (Output)
               The current connection profile state.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        The current connection profile state.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionProfileOracleStaticServiceIpConnectivity(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class ConnectionProfilePostgresql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alloydbClusterId":
            suggest = "alloydb_cluster_id"
        elif key == "cloudSqlId":
            suggest = "cloud_sql_id"
        elif key == "networkArchitecture":
            suggest = "network_architecture"
        elif key == "passwordSet":
            suggest = "password_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfilePostgresql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfilePostgresql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfilePostgresql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alloydb_cluster_id: Optional[str] = None,
                 cloud_sql_id: Optional[str] = None,
                 host: Optional[str] = None,
                 network_architecture: Optional[str] = None,
                 password: Optional[str] = None,
                 password_set: Optional[bool] = None,
                 port: Optional[int] = None,
                 ssl: Optional['outputs.ConnectionProfilePostgresqlSsl'] = None,
                 username: Optional[str] = None):
        """
        :param str alloydb_cluster_id: If the connected database is an AlloyDB instance, use this field to provide the AlloyDB cluster ID.
        :param str cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param str host: The IP or hostname of the source MySQL database.
        :param str network_architecture: (Output)
               Output only. If the source is a Cloud SQL database, this field indicates the network architecture it's associated with.
        :param str password: Input only. The password for the user that Database Migration Service will be using to connect to the database.
               This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool password_set: (Output)
               Output only. Indicates If this connection profile password is stored.
        :param int port: The network port of the source MySQL database.
        :param 'ConnectionProfilePostgresqlSslArgs' ssl: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        :param str username: The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        if alloydb_cluster_id is not None:
            pulumi.set(__self__, "alloydb_cluster_id", alloydb_cluster_id)
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if network_architecture is not None:
            pulumi.set(__self__, "network_architecture", network_architecture)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="alloydbClusterId")
    def alloydb_cluster_id(self) -> Optional[str]:
        """
        If the connected database is an AlloyDB instance, use this field to provide the AlloyDB cluster ID.
        """
        return pulumi.get(self, "alloydb_cluster_id")

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[str]:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The IP or hostname of the source MySQL database.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="networkArchitecture")
    def network_architecture(self) -> Optional[str]:
        """
        (Output)
        Output only. If the source is a Cloud SQL database, this field indicates the network architecture it's associated with.
        """
        return pulumi.get(self, "network_architecture")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[bool]:
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The network port of the source MySQL database.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def ssl(self) -> Optional['outputs.ConnectionProfilePostgresqlSsl']:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionProfilePostgresqlSsl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfilePostgresqlSsl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfilePostgresqlSsl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfilePostgresqlSsl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: Optional[str] = None,
                 client_key: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str ca_certificate: Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
               The replica will use this certificate to verify it's connecting to the right host.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
               If this field is used then the 'clientKey' field is mandatory
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'clientCertificate' field is mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str type: (Output)
               The current connection profile state.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Output)
        The current connection profile state.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MigrationJobDumpFlags(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dumpFlags":
            suggest = "dump_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationJobDumpFlags. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationJobDumpFlags.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationJobDumpFlags.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dump_flags: Optional[Sequence['outputs.MigrationJobDumpFlagsDumpFlag']] = None):
        """
        :param Sequence['MigrationJobDumpFlagsDumpFlagArgs'] dump_flags: A list of dump flags
               Structure is documented below.
        """
        if dump_flags is not None:
            pulumi.set(__self__, "dump_flags", dump_flags)

    @property
    @pulumi.getter(name="dumpFlags")
    def dump_flags(self) -> Optional[Sequence['outputs.MigrationJobDumpFlagsDumpFlag']]:
        """
        A list of dump flags
        Structure is documented below.
        """
        return pulumi.get(self, "dump_flags")


@pulumi.output_type
class MigrationJobDumpFlagsDumpFlag(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: The name of the flag
        :param str value: The vale of the flag
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the flag
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The vale of the flag
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MigrationJobError(dict):
    def __init__(__self__, *,
                 code: Optional[int] = None,
                 details: Optional[Sequence[Mapping[str, str]]] = None,
                 message: Optional[str] = None):
        """
        :param int code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: (Output)
               A list of messages that carry the error details.
        :param str message: (Output)
               Human readable message indicating details about the current status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, str]]]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class MigrationJobPerformanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dumpParallelLevel":
            suggest = "dump_parallel_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationJobPerformanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationJobPerformanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationJobPerformanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dump_parallel_level: Optional[str] = None):
        """
        :param str dump_parallel_level: Initial dump parallelism level.
               Possible values are: `MIN`, `OPTIMAL`, `MAX`.
        """
        if dump_parallel_level is not None:
            pulumi.set(__self__, "dump_parallel_level", dump_parallel_level)

    @property
    @pulumi.getter(name="dumpParallelLevel")
    def dump_parallel_level(self) -> Optional[str]:
        """
        Initial dump parallelism level.
        Possible values are: `MIN`, `OPTIMAL`, `MAX`.
        """
        return pulumi.get(self, "dump_parallel_level")


@pulumi.output_type
class MigrationJobReverseSshConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmIp":
            suggest = "vm_ip"
        elif key == "vmPort":
            suggest = "vm_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationJobReverseSshConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationJobReverseSshConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationJobReverseSshConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm: Optional[str] = None,
                 vm_ip: Optional[str] = None,
                 vm_port: Optional[int] = None,
                 vpc: Optional[str] = None):
        """
        :param str vm: The name of the virtual machine (Compute Engine) used as the bastion server
               for the SSH tunnel.
        :param str vm_ip: The IP of the virtual machine (Compute Engine) used as the bastion server
               for the SSH tunnel.
        :param int vm_port: The forwarding port of the virtual machine (Compute Engine) used as the
               bastion server for the SSH tunnel.
        :param str vpc: The name of the VPC to peer with the Cloud SQL private network.
        """
        if vm is not None:
            pulumi.set(__self__, "vm", vm)
        if vm_ip is not None:
            pulumi.set(__self__, "vm_ip", vm_ip)
        if vm_port is not None:
            pulumi.set(__self__, "vm_port", vm_port)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def vm(self) -> Optional[str]:
        """
        The name of the virtual machine (Compute Engine) used as the bastion server
        for the SSH tunnel.
        """
        return pulumi.get(self, "vm")

    @property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> Optional[str]:
        """
        The IP of the virtual machine (Compute Engine) used as the bastion server
        for the SSH tunnel.
        """
        return pulumi.get(self, "vm_ip")

    @property
    @pulumi.getter(name="vmPort")
    def vm_port(self) -> Optional[int]:
        """
        The forwarding port of the virtual machine (Compute Engine) used as the
        bastion server for the SSH tunnel.
        """
        return pulumi.get(self, "vm_port")

    @property
    @pulumi.getter
    def vpc(self) -> Optional[str]:
        """
        The name of the VPC to peer with the Cloud SQL private network.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class MigrationJobStaticIpConnectivity(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class MigrationJobVpcPeeringConnectivity(dict):
    def __init__(__self__, *,
                 vpc: Optional[str] = None):
        """
        :param str vpc: The name of the VPC network to peer with the Cloud SQL private network.
        """
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[str]:
        """
        The name of the VPC network to peer with the Cloud SQL private network.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class PrivateConnectionError(dict):
    def __init__(__self__, *,
                 details: Optional[Mapping[str, str]] = None,
                 message: Optional[str] = None):
        """
        :param Mapping[str, str] details: A list of messages that carry the error details.
        :param str message: A message containing more information about the error that occurred.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def details(self) -> Optional[Mapping[str, str]]:
        """
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A message containing more information about the error that occurred.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class PrivateConnectionVpcPeeringConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcName":
            suggest = "vpc_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateConnectionVpcPeeringConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateConnectionVpcPeeringConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateConnectionVpcPeeringConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet: str,
                 vpc_name: str):
        """
        :param str subnet: A free subnet for peering. (CIDR of /29)
               
               - - -
        :param str vpc_name: Fully qualified name of the VPC that Database Migration Service will peer to.
               Format: projects/{project}/global/{networks}/{name}
        """
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        A free subnet for peering. (CIDR of /29)

        - - -
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> str:
        """
        Fully qualified name of the VPC that Database Migration Service will peer to.
        Format: projects/{project}/global/{networks}/{name}
        """
        return pulumi.get(self, "vpc_name")


