# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'PipelineScheduleInfo',
    'PipelineWorkload',
    'PipelineWorkloadDataflowFlexTemplateRequest',
    'PipelineWorkloadDataflowFlexTemplateRequestLaunchParameter',
    'PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment',
    'PipelineWorkloadDataflowLaunchTemplateRequest',
    'PipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters',
    'PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment',
]

@pulumi.output_type
class PipelineScheduleInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextJobTime":
            suggest = "next_job_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineScheduleInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineScheduleInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineScheduleInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_job_time: Optional[str] = None,
                 schedule: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        :param str next_job_time: (Output)
               When the next Scheduler job is going to run.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str schedule: Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        :param str time_zone: Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
        if next_job_time is not None:
            pulumi.set(__self__, "next_job_time", next_job_time)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="nextJobTime")
    def next_job_time(self) -> Optional[str]:
        """
        (Output)
        When the next Scheduler job is going to run.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "next_job_time")

    @property
    @pulumi.getter
    def schedule(self) -> Optional[str]:
        """
        Unix-cron format of the schedule. This information is retrieved from the linked Cloud Scheduler.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Timezone ID. This matches the timezone IDs used by the Cloud Scheduler API. If empty, UTC time is assumed.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class PipelineWorkload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataflowFlexTemplateRequest":
            suggest = "dataflow_flex_template_request"
        elif key == "dataflowLaunchTemplateRequest":
            suggest = "dataflow_launch_template_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineWorkload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineWorkload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineWorkload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataflow_flex_template_request: Optional['outputs.PipelineWorkloadDataflowFlexTemplateRequest'] = None,
                 dataflow_launch_template_request: Optional['outputs.PipelineWorkloadDataflowLaunchTemplateRequest'] = None):
        """
        :param 'PipelineWorkloadDataflowFlexTemplateRequestArgs' dataflow_flex_template_request: Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplaterequest
               Structure is documented below.
        :param 'PipelineWorkloadDataflowLaunchTemplateRequestArgs' dataflow_launch_template_request: Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplaterequest
               Structure is documented below.
        """
        if dataflow_flex_template_request is not None:
            pulumi.set(__self__, "dataflow_flex_template_request", dataflow_flex_template_request)
        if dataflow_launch_template_request is not None:
            pulumi.set(__self__, "dataflow_launch_template_request", dataflow_launch_template_request)

    @property
    @pulumi.getter(name="dataflowFlexTemplateRequest")
    def dataflow_flex_template_request(self) -> Optional['outputs.PipelineWorkloadDataflowFlexTemplateRequest']:
        """
        Template information and additional parameters needed to launch a Dataflow job using the flex launch API.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplaterequest
        Structure is documented below.
        """
        return pulumi.get(self, "dataflow_flex_template_request")

    @property
    @pulumi.getter(name="dataflowLaunchTemplateRequest")
    def dataflow_launch_template_request(self) -> Optional['outputs.PipelineWorkloadDataflowLaunchTemplateRequest']:
        """
        Template information and additional parameters needed to launch a Dataflow job using the standard launch API.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplaterequest
        Structure is documented below.
        """
        return pulumi.get(self, "dataflow_launch_template_request")


@pulumi.output_type
class PipelineWorkloadDataflowFlexTemplateRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchParameter":
            suggest = "launch_parameter"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "validateOnly":
            suggest = "validate_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineWorkloadDataflowFlexTemplateRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineWorkloadDataflowFlexTemplateRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineWorkloadDataflowFlexTemplateRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_parameter: 'outputs.PipelineWorkloadDataflowFlexTemplateRequestLaunchParameter',
                 location: str,
                 project_id: str,
                 validate_only: Optional[bool] = None):
        """
        :param 'PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterArgs' launch_parameter: Parameter to launch a job from a Flex Template.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplateparameter
               Structure is documented below.
        :param str location: The regional endpoint to which to direct the request. For example, us-central1, us-west1.
        :param str project_id: The ID of the Cloud Platform project that the job belongs to.
        :param bool validate_only: If true, the request is validated but not actually executed. Defaults to false.
        """
        pulumi.set(__self__, "launch_parameter", launch_parameter)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "project_id", project_id)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="launchParameter")
    def launch_parameter(self) -> 'outputs.PipelineWorkloadDataflowFlexTemplateRequestLaunchParameter':
        """
        Parameter to launch a job from a Flex Template.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchflextemplateparameter
        Structure is documented below.
        """
        return pulumi.get(self, "launch_parameter")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The regional endpoint to which to direct the request. For example, us-central1, us-west1.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[bool]:
        """
        If true, the request is validated but not actually executed. Defaults to false.
        """
        return pulumi.get(self, "validate_only")


@pulumi.output_type
class PipelineWorkloadDataflowFlexTemplateRequestLaunchParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobName":
            suggest = "job_name"
        elif key == "containerSpecGcsPath":
            suggest = "container_spec_gcs_path"
        elif key == "launchOptions":
            suggest = "launch_options"
        elif key == "transformNameMappings":
            suggest = "transform_name_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineWorkloadDataflowFlexTemplateRequestLaunchParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineWorkloadDataflowFlexTemplateRequestLaunchParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineWorkloadDataflowFlexTemplateRequestLaunchParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_name: str,
                 container_spec_gcs_path: Optional[str] = None,
                 environment: Optional['outputs.PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment'] = None,
                 launch_options: Optional[Mapping[str, str]] = None,
                 parameters: Optional[Mapping[str, str]] = None,
                 transform_name_mappings: Optional[Mapping[str, str]] = None,
                 update: Optional[bool] = None):
        """
        :param str job_name: The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        :param str container_spec_gcs_path: Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        :param 'PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironmentArgs' environment: The runtime environment for the Flex Template job.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexTemplateRuntimeEnvironment
               Structure is documented below.
        :param Mapping[str, str] launch_options: Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param Mapping[str, str] parameters: 'The parameters for the Flex Template. Example: {"numWorkers":"5"}'
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param Mapping[str, str] transform_name_mappings: 'Use this to pass transform name mappings for streaming update jobs. Example: {"oldTransformName":"newTransformName",...}'
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param bool update: Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
        pulumi.set(__self__, "job_name", job_name)
        if container_spec_gcs_path is not None:
            pulumi.set(__self__, "container_spec_gcs_path", container_spec_gcs_path)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if launch_options is not None:
            pulumi.set(__self__, "launch_options", launch_options)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if transform_name_mappings is not None:
            pulumi.set(__self__, "transform_name_mappings", transform_name_mappings)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> str:
        """
        The job name to use for the created job. For an update job request, the job name should be the same as the existing running job.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="containerSpecGcsPath")
    def container_spec_gcs_path(self) -> Optional[str]:
        """
        Cloud Storage path to a file with a JSON-serialized ContainerSpec as content.
        """
        return pulumi.get(self, "container_spec_gcs_path")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment']:
        """
        The runtime environment for the Flex Template job.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexTemplateRuntimeEnvironment
        Structure is documented below.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> Optional[Mapping[str, str]]:
        """
        Launch options for this Flex Template job. This is a common set of options across languages and templates. This should not be used to pass job parameters.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "launch_options")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        'The parameters for the Flex Template. Example: {"numWorkers":"5"}'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="transformNameMappings")
    def transform_name_mappings(self) -> Optional[Mapping[str, str]]:
        """
        'Use this to pass transform name mappings for streaming update jobs. Example: {"oldTransformName":"newTransformName",...}'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "transform_name_mappings")

    @property
    @pulumi.getter
    def update(self) -> Optional[bool]:
        """
        Set this to true if you are sending a request to update a running streaming job. When set, the job name should be the same as the running job.
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExperiments":
            suggest = "additional_experiments"
        elif key == "additionalUserLabels":
            suggest = "additional_user_labels"
        elif key == "enableStreamingEngine":
            suggest = "enable_streaming_engine"
        elif key == "flexrsGoal":
            suggest = "flexrs_goal"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "maxWorkers":
            suggest = "max_workers"
        elif key == "numWorkers":
            suggest = "num_workers"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "tempLocation":
            suggest = "temp_location"
        elif key == "workerRegion":
            suggest = "worker_region"
        elif key == "workerZone":
            suggest = "worker_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineWorkloadDataflowFlexTemplateRequestLaunchParameterEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_experiments: Optional[Sequence[str]] = None,
                 additional_user_labels: Optional[Mapping[str, str]] = None,
                 enable_streaming_engine: Optional[bool] = None,
                 flexrs_goal: Optional[str] = None,
                 ip_configuration: Optional[str] = None,
                 kms_key_name: Optional[str] = None,
                 machine_type: Optional[str] = None,
                 max_workers: Optional[int] = None,
                 network: Optional[str] = None,
                 num_workers: Optional[int] = None,
                 service_account_email: Optional[str] = None,
                 subnetwork: Optional[str] = None,
                 temp_location: Optional[str] = None,
                 worker_region: Optional[str] = None,
                 worker_zone: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param Sequence[str] additional_experiments: Additional experiment flags for the job.
        :param Mapping[str, str] additional_user_labels: Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
               'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param bool enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param str flexrs_goal: Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexResourceSchedulingGoal
               Possible values are: `FLEXRS_UNSPECIFIED`, `FLEXRS_SPEED_OPTIMIZED`, `FLEXRS_COST_OPTIMIZED`.
        :param str ip_configuration: Configuration for VM IPs.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
               Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        :param str kms_key_name: 'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        :param str machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param int max_workers: The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param str network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param int num_workers: The initial number of Compute Engine instances for the job.
        :param str service_account_email: The email address of the service account to run the job as.
        :param str subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param str temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param str worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        :param str worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        :param str zone: The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_user_labels is not None:
            pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if flexrs_goal is not None:
            pulumi.set(__self__, "flexrs_goal", flexrs_goal)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if worker_region is not None:
            pulumi.set(__self__, "worker_region", worker_region)
        if worker_zone is not None:
            pulumi.set(__self__, "worker_zone", worker_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[Sequence[str]]:
        """
        Additional experiment flags for the job.
        """
        return pulumi.get(self, "additional_experiments")

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Optional[Mapping[str, str]]:
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
        'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "additional_user_labels")

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[bool]:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @property
    @pulumi.getter(name="flexrsGoal")
    def flexrs_goal(self) -> Optional[str]:
        """
        Set FlexRS goal for the job. https://cloud.google.com/dataflow/docs/guides/flexrs
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#FlexResourceSchedulingGoal
        Possible values are: `FLEXRS_UNSPECIFIED`, `FLEXRS_SPEED_OPTIMIZED`, `FLEXRS_COST_OPTIMIZED`.
        """
        return pulumi.get(self, "flexrs_goal")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[str]:
        """
        Configuration for VM IPs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
        Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[int]:
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[int]:
        """
        The initial number of Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[str]:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[str]:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[str]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "temp_location")

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> Optional[str]:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> Optional[str]:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class PipelineWorkloadDataflowLaunchTemplateRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"
        elif key == "gcsPath":
            suggest = "gcs_path"
        elif key == "launchParameters":
            suggest = "launch_parameters"
        elif key == "validateOnly":
            suggest = "validate_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineWorkloadDataflowLaunchTemplateRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineWorkloadDataflowLaunchTemplateRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineWorkloadDataflowLaunchTemplateRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: str,
                 gcs_path: Optional[str] = None,
                 launch_parameters: Optional['outputs.PipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters'] = None,
                 location: Optional[str] = None,
                 validate_only: Optional[bool] = None):
        """
        :param str project_id: The ID of the Cloud Platform project that the job belongs to.
        :param str gcs_path: A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        :param 'PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersArgs' launch_parameters: The parameters of the template to launch. This should be part of the body of the POST request.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplateparameters
               Structure is documented below.
        :param str location: The regional endpoint to which to direct the request.
        :param bool validate_only: (Optional)
        """
        pulumi.set(__self__, "project_id", project_id)
        if gcs_path is not None:
            pulumi.set(__self__, "gcs_path", gcs_path)
        if launch_parameters is not None:
            pulumi.set(__self__, "launch_parameters", launch_parameters)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if validate_only is not None:
            pulumi.set(__self__, "validate_only", validate_only)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="gcsPath")
    def gcs_path(self) -> Optional[str]:
        """
        A Cloud Storage path to the template from which to create the job. Must be a valid Cloud Storage URL, beginning with 'gs://'.
        """
        return pulumi.get(self, "gcs_path")

    @property
    @pulumi.getter(name="launchParameters")
    def launch_parameters(self) -> Optional['outputs.PipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters']:
        """
        The parameters of the template to launch. This should be part of the body of the POST request.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#launchtemplateparameters
        Structure is documented below.
        """
        return pulumi.get(self, "launch_parameters")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The regional endpoint to which to direct the request.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="validateOnly")
    def validate_only(self) -> Optional[bool]:
        """
        (Optional)
        """
        return pulumi.get(self, "validate_only")


@pulumi.output_type
class PipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobName":
            suggest = "job_name"
        elif key == "transformNameMapping":
            suggest = "transform_name_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineWorkloadDataflowLaunchTemplateRequestLaunchParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_name: str,
                 environment: Optional['outputs.PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment'] = None,
                 parameters: Optional[Mapping[str, str]] = None,
                 transform_name_mapping: Optional[Mapping[str, str]] = None,
                 update: Optional[bool] = None):
        """
        :param str job_name: The job name to use for the created job.
        :param 'PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironmentArgs' environment: The runtime environment for the job.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#RuntimeEnvironment
               Structure is documented below.
        :param Mapping[str, str] parameters: The runtime parameters to pass to the job.
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param Mapping[str, str] transform_name_mapping: Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param bool update: If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
        pulumi.set(__self__, "job_name", job_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if transform_name_mapping is not None:
            pulumi.set(__self__, "transform_name_mapping", transform_name_mapping)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> str:
        """
        The job name to use for the created job.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter
    def environment(self) -> Optional['outputs.PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment']:
        """
        The runtime environment for the job.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#RuntimeEnvironment
        Structure is documented below.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        The runtime parameters to pass to the job.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> Optional[Mapping[str, str]]:
        """
        Map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job. Only applicable when updating a pipeline.
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "transform_name_mapping")

    @property
    @pulumi.getter
    def update(self) -> Optional[bool]:
        """
        If set, replace the existing pipeline with the name specified by jobName with this pipeline, preserving state.
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExperiments":
            suggest = "additional_experiments"
        elif key == "additionalUserLabels":
            suggest = "additional_user_labels"
        elif key == "bypassTempDirValidation":
            suggest = "bypass_temp_dir_validation"
        elif key == "enableStreamingEngine":
            suggest = "enable_streaming_engine"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "maxWorkers":
            suggest = "max_workers"
        elif key == "numWorkers":
            suggest = "num_workers"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "tempLocation":
            suggest = "temp_location"
        elif key == "workerRegion":
            suggest = "worker_region"
        elif key == "workerZone":
            suggest = "worker_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineWorkloadDataflowLaunchTemplateRequestLaunchParametersEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_experiments: Optional[Sequence[str]] = None,
                 additional_user_labels: Optional[Mapping[str, str]] = None,
                 bypass_temp_dir_validation: Optional[bool] = None,
                 enable_streaming_engine: Optional[bool] = None,
                 ip_configuration: Optional[str] = None,
                 kms_key_name: Optional[str] = None,
                 machine_type: Optional[str] = None,
                 max_workers: Optional[int] = None,
                 network: Optional[str] = None,
                 num_workers: Optional[int] = None,
                 service_account_email: Optional[str] = None,
                 subnetwork: Optional[str] = None,
                 temp_location: Optional[str] = None,
                 worker_region: Optional[str] = None,
                 worker_zone: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param Sequence[str] additional_experiments: Additional experiment flags for the job.
        :param Mapping[str, str] additional_user_labels: Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
               'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
               'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        :param bool bypass_temp_dir_validation: Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        :param bool enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param str ip_configuration: Configuration for VM IPs.
               https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
               Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        :param str kms_key_name: 'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        :param str machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param int max_workers: The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param str network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param int num_workers: The initial number of Compute Engine instances for the job.
        :param str service_account_email: The email address of the service account to run the job as.
        :param str subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param str temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        :param str worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        :param str worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        :param str zone: The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_user_labels is not None:
            pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        if bypass_temp_dir_validation is not None:
            pulumi.set(__self__, "bypass_temp_dir_validation", bypass_temp_dir_validation)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if worker_region is not None:
            pulumi.set(__self__, "worker_region", worker_region)
        if worker_zone is not None:
            pulumi.set(__self__, "worker_zone", worker_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[Sequence[str]]:
        """
        Additional experiment flags for the job.
        """
        return pulumi.get(self, "additional_experiments")

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Optional[Mapping[str, str]]:
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the labeling restrictions page. An object containing a list of key/value pairs.
        'Example: { "name": "wrench", "mass": "1kg", "count": "3" }.'
        'An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
        """
        return pulumi.get(self, "additional_user_labels")

    @property
    @pulumi.getter(name="bypassTempDirValidation")
    def bypass_temp_dir_validation(self) -> Optional[bool]:
        """
        Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        """
        return pulumi.get(self, "bypass_temp_dir_validation")

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[bool]:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[str]:
        """
        Configuration for VM IPs.
        https://cloud.google.com/dataflow/docs/reference/data-pipelines/rest/v1/projects.locations.pipelines#WorkerIPAddressConfiguration
        Possible values are: `WORKER_IP_UNSPECIFIED`, `WORKER_IP_PUBLIC`, `WORKER_IP_PRIVATE`.
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        'Name for the Cloud KMS key for the job. The key format is: projects//locations//keyRings//cryptoKeys/'
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[int]:
        """
        The maximum number of Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[int]:
        """
        The initial number of Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[str]:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[str]:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[str]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with gs://.
        """
        return pulumi.get(self, "temp_location")

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> Optional[str]:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with workerZone. If neither workerRegion nor workerZone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> Optional[str]:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with workerRegion. If neither workerRegion nor workerZone is specified, a zone in the control plane's region is chosen based on available capacity. If both workerZone and zone are set, workerZone takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The Compute Engine availability zone for launching worker instances to run your pipeline. In the future, workerZone will take precedence.
        """
        return pulumi.get(self, "zone")


