# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMetastoreServiceResult',
    'AwaitableGetMetastoreServiceResult',
    'get_metastore_service',
    'get_metastore_service_output',
]

@pulumi.output_type
class GetMetastoreServiceResult:
    """
    A collection of values returned by getMetastoreService.
    """
    def __init__(__self__, artifact_gcs_uri=None, database_type=None, deletion_protection=None, effective_labels=None, encryption_configs=None, endpoint_uri=None, hive_metastore_configs=None, id=None, labels=None, location=None, maintenance_windows=None, metadata_integrations=None, name=None, network=None, network_configs=None, port=None, project=None, pulumi_labels=None, release_channel=None, scaling_configs=None, scheduled_backups=None, service_id=None, state=None, state_message=None, telemetry_configs=None, tier=None, uid=None):
        if artifact_gcs_uri and not isinstance(artifact_gcs_uri, str):
            raise TypeError("Expected argument 'artifact_gcs_uri' to be a str")
        pulumi.set(__self__, "artifact_gcs_uri", artifact_gcs_uri)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if encryption_configs and not isinstance(encryption_configs, list):
            raise TypeError("Expected argument 'encryption_configs' to be a list")
        pulumi.set(__self__, "encryption_configs", encryption_configs)
        if endpoint_uri and not isinstance(endpoint_uri, str):
            raise TypeError("Expected argument 'endpoint_uri' to be a str")
        pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if hive_metastore_configs and not isinstance(hive_metastore_configs, list):
            raise TypeError("Expected argument 'hive_metastore_configs' to be a list")
        pulumi.set(__self__, "hive_metastore_configs", hive_metastore_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if metadata_integrations and not isinstance(metadata_integrations, list):
            raise TypeError("Expected argument 'metadata_integrations' to be a list")
        pulumi.set(__self__, "metadata_integrations", metadata_integrations)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if network_configs and not isinstance(network_configs, list):
            raise TypeError("Expected argument 'network_configs' to be a list")
        pulumi.set(__self__, "network_configs", network_configs)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if release_channel and not isinstance(release_channel, str):
            raise TypeError("Expected argument 'release_channel' to be a str")
        pulumi.set(__self__, "release_channel", release_channel)
        if scaling_configs and not isinstance(scaling_configs, list):
            raise TypeError("Expected argument 'scaling_configs' to be a list")
        pulumi.set(__self__, "scaling_configs", scaling_configs)
        if scheduled_backups and not isinstance(scheduled_backups, list):
            raise TypeError("Expected argument 'scheduled_backups' to be a list")
        pulumi.set(__self__, "scheduled_backups", scheduled_backups)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_message and not isinstance(state_message, str):
            raise TypeError("Expected argument 'state_message' to be a str")
        pulumi.set(__self__, "state_message", state_message)
        if telemetry_configs and not isinstance(telemetry_configs, list):
            raise TypeError("Expected argument 'telemetry_configs' to be a list")
        pulumi.set(__self__, "telemetry_configs", telemetry_configs)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="artifactGcsUri")
    def artifact_gcs_uri(self) -> str:
        return pulumi.get(self, "artifact_gcs_uri")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> str:
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="encryptionConfigs")
    def encryption_configs(self) -> Sequence['outputs.GetMetastoreServiceEncryptionConfigResult']:
        return pulumi.get(self, "encryption_configs")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> str:
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="hiveMetastoreConfigs")
    def hive_metastore_configs(self) -> Sequence['outputs.GetMetastoreServiceHiveMetastoreConfigResult']:
        return pulumi.get(self, "hive_metastore_configs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetMetastoreServiceMaintenanceWindowResult']:
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="metadataIntegrations")
    def metadata_integrations(self) -> Sequence['outputs.GetMetastoreServiceMetadataIntegrationResult']:
        return pulumi.get(self, "metadata_integrations")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> str:
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> Sequence['outputs.GetMetastoreServiceNetworkConfigResult']:
        return pulumi.get(self, "network_configs")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> str:
        return pulumi.get(self, "release_channel")

    @property
    @pulumi.getter(name="scalingConfigs")
    def scaling_configs(self) -> Sequence['outputs.GetMetastoreServiceScalingConfigResult']:
        return pulumi.get(self, "scaling_configs")

    @property
    @pulumi.getter(name="scheduledBackups")
    def scheduled_backups(self) -> Sequence['outputs.GetMetastoreServiceScheduledBackupResult']:
        return pulumi.get(self, "scheduled_backups")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> str:
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="telemetryConfigs")
    def telemetry_configs(self) -> Sequence['outputs.GetMetastoreServiceTelemetryConfigResult']:
        return pulumi.get(self, "telemetry_configs")

    @property
    @pulumi.getter
    def tier(self) -> str:
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def uid(self) -> str:
        return pulumi.get(self, "uid")


class AwaitableGetMetastoreServiceResult(GetMetastoreServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetastoreServiceResult(
            artifact_gcs_uri=self.artifact_gcs_uri,
            database_type=self.database_type,
            deletion_protection=self.deletion_protection,
            effective_labels=self.effective_labels,
            encryption_configs=self.encryption_configs,
            endpoint_uri=self.endpoint_uri,
            hive_metastore_configs=self.hive_metastore_configs,
            id=self.id,
            labels=self.labels,
            location=self.location,
            maintenance_windows=self.maintenance_windows,
            metadata_integrations=self.metadata_integrations,
            name=self.name,
            network=self.network,
            network_configs=self.network_configs,
            port=self.port,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            release_channel=self.release_channel,
            scaling_configs=self.scaling_configs,
            scheduled_backups=self.scheduled_backups,
            service_id=self.service_id,
            state=self.state,
            state_message=self.state_message,
            telemetry_configs=self.telemetry_configs,
            tier=self.tier,
            uid=self.uid)


def get_metastore_service(location: Optional[str] = None,
                          project: Optional[str] = None,
                          service_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetastoreServiceResult:
    """
    Get a Dataproc Metastore service from Google Cloud by its id and location.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.dataproc.get_metastore_service(service_id="foo-bar",
        location="global")
    ```


    :param str location: The location where the metastore service resides.
           
           - - -
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str service_id: The ID of the metastore service.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataproc/getMetastoreService:getMetastoreService', __args__, opts=opts, typ=GetMetastoreServiceResult).value

    return AwaitableGetMetastoreServiceResult(
        artifact_gcs_uri=pulumi.get(__ret__, 'artifact_gcs_uri'),
        database_type=pulumi.get(__ret__, 'database_type'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        encryption_configs=pulumi.get(__ret__, 'encryption_configs'),
        endpoint_uri=pulumi.get(__ret__, 'endpoint_uri'),
        hive_metastore_configs=pulumi.get(__ret__, 'hive_metastore_configs'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        metadata_integrations=pulumi.get(__ret__, 'metadata_integrations'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        network_configs=pulumi.get(__ret__, 'network_configs'),
        port=pulumi.get(__ret__, 'port'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        release_channel=pulumi.get(__ret__, 'release_channel'),
        scaling_configs=pulumi.get(__ret__, 'scaling_configs'),
        scheduled_backups=pulumi.get(__ret__, 'scheduled_backups'),
        service_id=pulumi.get(__ret__, 'service_id'),
        state=pulumi.get(__ret__, 'state'),
        state_message=pulumi.get(__ret__, 'state_message'),
        telemetry_configs=pulumi.get(__ret__, 'telemetry_configs'),
        tier=pulumi.get(__ret__, 'tier'),
        uid=pulumi.get(__ret__, 'uid'))


@_utilities.lift_output_func(get_metastore_service)
def get_metastore_service_output(location: Optional[pulumi.Input[str]] = None,
                                 project: Optional[pulumi.Input[Optional[str]]] = None,
                                 service_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetastoreServiceResult]:
    """
    Get a Dataproc Metastore service from Google Cloud by its id and location.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.dataproc.get_metastore_service(service_id="foo-bar",
        location="global")
    ```


    :param str location: The location where the metastore service resides.
           
           - - -
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str service_id: The ID of the metastore service.
    """
    ...
