# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetastoreServiceArgs', 'MetastoreService']

@pulumi.input_type
class MetastoreServiceArgs:
    def __init__(__self__, *,
                 service_id: pulumi.Input[str],
                 database_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 encryption_config: Optional[pulumi.Input['MetastoreServiceEncryptionConfigArgs']] = None,
                 hive_metastore_config: Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['MetastoreServiceMaintenanceWindowArgs']] = None,
                 metadata_integration: Optional[pulumi.Input['MetastoreServiceMetadataIntegrationArgs']] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input['MetastoreServiceNetworkConfigArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_channel: Optional[pulumi.Input[str]] = None,
                 scaling_config: Optional[pulumi.Input['MetastoreServiceScalingConfigArgs']] = None,
                 scheduled_backup: Optional[pulumi.Input['MetastoreServiceScheduledBackupArgs']] = None,
                 telemetry_config: Optional[pulumi.Input['MetastoreServiceTelemetryConfigArgs']] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MetastoreService resource.
        :param pulumi.Input[str] service_id: The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
               and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
               3 and 63 characters.
               
               
               - - -
        :param pulumi.Input[str] database_type: The database type that the Metastore service stores its data.
               Default value is `MYSQL`.
               Possible values are: `MYSQL`, `SPANNER`.
        :param pulumi.Input[bool] deletion_protection: Indicates if the dataproc metastore should be protected against accidental deletions.
        :param pulumi.Input['MetastoreServiceEncryptionConfigArgs'] encryption_config: Information used to configure the Dataproc Metastore service to encrypt
               customer data at rest.
               Structure is documented below.
        :param pulumi.Input['MetastoreServiceHiveMetastoreConfigArgs'] hive_metastore_config: Configuration information specific to running Hive metastore software as the metastore service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the metastore service.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location where the metastore service should reside.
               The default value is `global`.
        :param pulumi.Input['MetastoreServiceMaintenanceWindowArgs'] maintenance_window: The one hour maintenance window of the metastore service.
               This specifies when the service can be restarted for maintenance purposes in UTC time.
               Maintenance window is not needed for services with the `SPANNER` database type.
               Structure is documented below.
        :param pulumi.Input['MetastoreServiceMetadataIntegrationArgs'] metadata_integration: The setting that defines how metastore metadata should be integrated with external services and systems.
               Structure is documented below.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input['MetastoreServiceNetworkConfigArgs'] network_config: The configuration specifying the network settings for the Dataproc Metastore service.
               Structure is documented below.
        :param pulumi.Input[int] port: The TCP port at which the metastore service is reached. Default: 9083.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] release_channel: The release channel of the service. If unspecified, defaults to `STABLE`.
               Default value is `STABLE`.
               Possible values are: `CANARY`, `STABLE`.
        :param pulumi.Input['MetastoreServiceScalingConfigArgs'] scaling_config: Represents the scaling configuration of a metastore service.
               Structure is documented below.
        :param pulumi.Input['MetastoreServiceScheduledBackupArgs'] scheduled_backup: The configuration of scheduled backup for the metastore service.
               Structure is documented below.
        :param pulumi.Input['MetastoreServiceTelemetryConfigArgs'] telemetry_config: The configuration specifying telemetry settings for the Dataproc Metastore service. If unspecified defaults to JSON.
               Structure is documented below.
        :param pulumi.Input[str] tier: The tier of the service.
               Possible values are: `DEVELOPER`, `ENTERPRISE`.
        """
        pulumi.set(__self__, "service_id", service_id)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if hive_metastore_config is not None:
            pulumi.set(__self__, "hive_metastore_config", hive_metastore_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if metadata_integration is not None:
            pulumi.set(__self__, "metadata_integration", metadata_integration)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if release_channel is not None:
            pulumi.set(__self__, "release_channel", release_channel)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if scheduled_backup is not None:
            pulumi.set(__self__, "scheduled_backup", scheduled_backup)
        if telemetry_config is not None:
            pulumi.set(__self__, "telemetry_config", telemetry_config)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
        and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
        3 and 63 characters.


        - - -
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        The database type that the Metastore service stores its data.
        Default value is `MYSQL`.
        Possible values are: `MYSQL`, `SPANNER`.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the dataproc metastore should be protected against accidental deletions.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['MetastoreServiceEncryptionConfigArgs']]:
        """
        Information used to configure the Dataproc Metastore service to encrypt
        customer data at rest.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['MetastoreServiceEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="hiveMetastoreConfig")
    def hive_metastore_config(self) -> Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigArgs']]:
        """
        Configuration information specific to running Hive metastore software as the metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "hive_metastore_config")

    @hive_metastore_config.setter
    def hive_metastore_config(self, value: Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigArgs']]):
        pulumi.set(self, "hive_metastore_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for the metastore service.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the metastore service should reside.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MetastoreServiceMaintenanceWindowArgs']]:
        """
        The one hour maintenance window of the metastore service.
        This specifies when the service can be restarted for maintenance purposes in UTC time.
        Maintenance window is not needed for services with the `SPANNER` database type.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MetastoreServiceMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="metadataIntegration")
    def metadata_integration(self) -> Optional[pulumi.Input['MetastoreServiceMetadataIntegrationArgs']]:
        """
        The setting that defines how metastore metadata should be integrated with external services and systems.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_integration")

    @metadata_integration.setter
    def metadata_integration(self, value: Optional[pulumi.Input['MetastoreServiceMetadataIntegrationArgs']]):
        pulumi.set(self, "metadata_integration", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
        "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['MetastoreServiceNetworkConfigArgs']]:
        """
        The configuration specifying the network settings for the Dataproc Metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['MetastoreServiceNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP port at which the metastore service is reached. Default: 9083.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The release channel of the service. If unspecified, defaults to `STABLE`.
        Default value is `STABLE`.
        Possible values are: `CANARY`, `STABLE`.
        """
        return pulumi.get(self, "release_channel")

    @release_channel.setter
    def release_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_channel", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['MetastoreServiceScalingConfigArgs']]:
        """
        Represents the scaling configuration of a metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['MetastoreServiceScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="scheduledBackup")
    def scheduled_backup(self) -> Optional[pulumi.Input['MetastoreServiceScheduledBackupArgs']]:
        """
        The configuration of scheduled backup for the metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduled_backup")

    @scheduled_backup.setter
    def scheduled_backup(self, value: Optional[pulumi.Input['MetastoreServiceScheduledBackupArgs']]):
        pulumi.set(self, "scheduled_backup", value)

    @property
    @pulumi.getter(name="telemetryConfig")
    def telemetry_config(self) -> Optional[pulumi.Input['MetastoreServiceTelemetryConfigArgs']]:
        """
        The configuration specifying telemetry settings for the Dataproc Metastore service. If unspecified defaults to JSON.
        Structure is documented below.
        """
        return pulumi.get(self, "telemetry_config")

    @telemetry_config.setter
    def telemetry_config(self, value: Optional[pulumi.Input['MetastoreServiceTelemetryConfigArgs']]):
        pulumi.set(self, "telemetry_config", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier of the service.
        Possible values are: `DEVELOPER`, `ENTERPRISE`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class _MetastoreServiceState:
    def __init__(__self__, *,
                 artifact_gcs_uri: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 encryption_config: Optional[pulumi.Input['MetastoreServiceEncryptionConfigArgs']] = None,
                 endpoint_uri: Optional[pulumi.Input[str]] = None,
                 hive_metastore_config: Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['MetastoreServiceMaintenanceWindowArgs']] = None,
                 metadata_integration: Optional[pulumi.Input['MetastoreServiceMetadataIntegrationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input['MetastoreServiceNetworkConfigArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 release_channel: Optional[pulumi.Input[str]] = None,
                 scaling_config: Optional[pulumi.Input['MetastoreServiceScalingConfigArgs']] = None,
                 scheduled_backup: Optional[pulumi.Input['MetastoreServiceScheduledBackupArgs']] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_message: Optional[pulumi.Input[str]] = None,
                 telemetry_config: Optional[pulumi.Input['MetastoreServiceTelemetryConfigArgs']] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetastoreService resources.
        :param pulumi.Input[str] artifact_gcs_uri: A Cloud Storage URI (starting with gs://) that specifies where artifacts related to the metastore service are stored.
        :param pulumi.Input[str] database_type: The database type that the Metastore service stores its data.
               Default value is `MYSQL`.
               Possible values are: `MYSQL`, `SPANNER`.
        :param pulumi.Input[bool] deletion_protection: Indicates if the dataproc metastore should be protected against accidental deletions.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['MetastoreServiceEncryptionConfigArgs'] encryption_config: Information used to configure the Dataproc Metastore service to encrypt
               customer data at rest.
               Structure is documented below.
        :param pulumi.Input[str] endpoint_uri: The URI of the endpoint used to access the metastore service.
        :param pulumi.Input['MetastoreServiceHiveMetastoreConfigArgs'] hive_metastore_config: Configuration information specific to running Hive metastore software as the metastore service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the metastore service.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location where the metastore service should reside.
               The default value is `global`.
        :param pulumi.Input['MetastoreServiceMaintenanceWindowArgs'] maintenance_window: The one hour maintenance window of the metastore service.
               This specifies when the service can be restarted for maintenance purposes in UTC time.
               Maintenance window is not needed for services with the `SPANNER` database type.
               Structure is documented below.
        :param pulumi.Input['MetastoreServiceMetadataIntegrationArgs'] metadata_integration: The setting that defines how metastore metadata should be integrated with external services and systems.
               Structure is documented below.
        :param pulumi.Input[str] name: The relative resource name of the metastore service.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input['MetastoreServiceNetworkConfigArgs'] network_config: The configuration specifying the network settings for the Dataproc Metastore service.
               Structure is documented below.
        :param pulumi.Input[int] port: The TCP port at which the metastore service is reached. Default: 9083.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] release_channel: The release channel of the service. If unspecified, defaults to `STABLE`.
               Default value is `STABLE`.
               Possible values are: `CANARY`, `STABLE`.
        :param pulumi.Input['MetastoreServiceScalingConfigArgs'] scaling_config: Represents the scaling configuration of a metastore service.
               Structure is documented below.
        :param pulumi.Input['MetastoreServiceScheduledBackupArgs'] scheduled_backup: The configuration of scheduled backup for the metastore service.
               Structure is documented below.
        :param pulumi.Input[str] service_id: The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
               and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
               3 and 63 characters.
               
               
               - - -
        :param pulumi.Input[str] state: The current state of the metastore service.
        :param pulumi.Input[str] state_message: Additional information about the current state of the metastore service, if available.
        :param pulumi.Input['MetastoreServiceTelemetryConfigArgs'] telemetry_config: The configuration specifying telemetry settings for the Dataproc Metastore service. If unspecified defaults to JSON.
               Structure is documented below.
        :param pulumi.Input[str] tier: The tier of the service.
               Possible values are: `DEVELOPER`, `ENTERPRISE`.
        :param pulumi.Input[str] uid: The globally unique resource identifier of the metastore service.
        """
        if artifact_gcs_uri is not None:
            pulumi.set(__self__, "artifact_gcs_uri", artifact_gcs_uri)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if hive_metastore_config is not None:
            pulumi.set(__self__, "hive_metastore_config", hive_metastore_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if metadata_integration is not None:
            pulumi.set(__self__, "metadata_integration", metadata_integration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if release_channel is not None:
            pulumi.set(__self__, "release_channel", release_channel)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if scheduled_backup is not None:
            pulumi.set(__self__, "scheduled_backup", scheduled_backup)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if telemetry_config is not None:
            pulumi.set(__self__, "telemetry_config", telemetry_config)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="artifactGcsUri")
    def artifact_gcs_uri(self) -> Optional[pulumi.Input[str]]:
        """
        A Cloud Storage URI (starting with gs://) that specifies where artifacts related to the metastore service are stored.
        """
        return pulumi.get(self, "artifact_gcs_uri")

    @artifact_gcs_uri.setter
    def artifact_gcs_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_gcs_uri", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        The database type that the Metastore service stores its data.
        Default value is `MYSQL`.
        Possible values are: `MYSQL`, `SPANNER`.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the dataproc metastore should be protected against accidental deletions.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['MetastoreServiceEncryptionConfigArgs']]:
        """
        Information used to configure the Dataproc Metastore service to encrypt
        customer data at rest.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['MetastoreServiceEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the endpoint used to access the metastore service.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_uri", value)

    @property
    @pulumi.getter(name="hiveMetastoreConfig")
    def hive_metastore_config(self) -> Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigArgs']]:
        """
        Configuration information specific to running Hive metastore software as the metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "hive_metastore_config")

    @hive_metastore_config.setter
    def hive_metastore_config(self, value: Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigArgs']]):
        pulumi.set(self, "hive_metastore_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for the metastore service.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the metastore service should reside.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MetastoreServiceMaintenanceWindowArgs']]:
        """
        The one hour maintenance window of the metastore service.
        This specifies when the service can be restarted for maintenance purposes in UTC time.
        Maintenance window is not needed for services with the `SPANNER` database type.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MetastoreServiceMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="metadataIntegration")
    def metadata_integration(self) -> Optional[pulumi.Input['MetastoreServiceMetadataIntegrationArgs']]:
        """
        The setting that defines how metastore metadata should be integrated with external services and systems.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_integration")

    @metadata_integration.setter
    def metadata_integration(self, value: Optional[pulumi.Input['MetastoreServiceMetadataIntegrationArgs']]):
        pulumi.set(self, "metadata_integration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The relative resource name of the metastore service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
        "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['MetastoreServiceNetworkConfigArgs']]:
        """
        The configuration specifying the network settings for the Dataproc Metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['MetastoreServiceNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The TCP port at which the metastore service is reached. Default: 9083.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The release channel of the service. If unspecified, defaults to `STABLE`.
        Default value is `STABLE`.
        Possible values are: `CANARY`, `STABLE`.
        """
        return pulumi.get(self, "release_channel")

    @release_channel.setter
    def release_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_channel", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['MetastoreServiceScalingConfigArgs']]:
        """
        Represents the scaling configuration of a metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['MetastoreServiceScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="scheduledBackup")
    def scheduled_backup(self) -> Optional[pulumi.Input['MetastoreServiceScheduledBackupArgs']]:
        """
        The configuration of scheduled backup for the metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduled_backup")

    @scheduled_backup.setter
    def scheduled_backup(self, value: Optional[pulumi.Input['MetastoreServiceScheduledBackupArgs']]):
        pulumi.set(self, "scheduled_backup", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
        and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
        3 and 63 characters.


        - - -
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the metastore service.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current state of the metastore service, if available.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter(name="telemetryConfig")
    def telemetry_config(self) -> Optional[pulumi.Input['MetastoreServiceTelemetryConfigArgs']]:
        """
        The configuration specifying telemetry settings for the Dataproc Metastore service. If unspecified defaults to JSON.
        Structure is documented below.
        """
        return pulumi.get(self, "telemetry_config")

    @telemetry_config.setter
    def telemetry_config(self, value: Optional[pulumi.Input['MetastoreServiceTelemetryConfigArgs']]):
        pulumi.set(self, "telemetry_config", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier of the service.
        Possible values are: `DEVELOPER`, `ENTERPRISE`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The globally unique resource identifier of the metastore service.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


class MetastoreService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 encryption_config: Optional[pulumi.Input[Union['MetastoreServiceEncryptionConfigArgs', 'MetastoreServiceEncryptionConfigArgsDict']]] = None,
                 hive_metastore_config: Optional[pulumi.Input[Union['MetastoreServiceHiveMetastoreConfigArgs', 'MetastoreServiceHiveMetastoreConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MetastoreServiceMaintenanceWindowArgs', 'MetastoreServiceMaintenanceWindowArgsDict']]] = None,
                 metadata_integration: Optional[pulumi.Input[Union['MetastoreServiceMetadataIntegrationArgs', 'MetastoreServiceMetadataIntegrationArgsDict']]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input[Union['MetastoreServiceNetworkConfigArgs', 'MetastoreServiceNetworkConfigArgsDict']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_channel: Optional[pulumi.Input[str]] = None,
                 scaling_config: Optional[pulumi.Input[Union['MetastoreServiceScalingConfigArgs', 'MetastoreServiceScalingConfigArgsDict']]] = None,
                 scheduled_backup: Optional[pulumi.Input[Union['MetastoreServiceScheduledBackupArgs', 'MetastoreServiceScheduledBackupArgsDict']]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 telemetry_config: Optional[pulumi.Input[Union['MetastoreServiceTelemetryConfigArgs', 'MetastoreServiceTelemetryConfigArgsDict']]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A managed metastore service that serves metadata queries.

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/dataproc-metastore/docs/reference/rest/v1/projects.locations.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataproc-metastore/docs/overview)

        ## Example Usage

        ### Dataproc Metastore Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "2.3.6",
            },
            labels={
                "env": "test",
            })
        ```
        ### Dataproc Metastore Service Deletion Protection

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            deletion_protection=True,
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "2.3.6",
            },
            labels={
                "env": "test",
            })
        ```
        ### Dataproc Metastore Service Cmek Example

        ```python
        import pulumi
        import pulumi_gcp as gcp

        key_ring = gcp.kms.KeyRing("key_ring",
            name="example-keyring",
            location="us-central1")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="example-key",
            key_ring=key_ring.id,
            purpose="ENCRYPT_DECRYPT")
        default = gcp.dataproc.MetastoreService("default",
            service_id="example-service",
            location="us-central1",
            encryption_config={
                "kms_key": crypto_key.id,
            },
            hive_metastore_config={
                "version": "3.1.2",
            })
        ```
        ### Dataproc Metastore Service Private Service Connect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            region="us-central1",
            network=net.id,
            ip_cidr_range="10.0.0.0/22",
            private_ip_google_access=True)
        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            tier="DEVELOPER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            network_config={
                "consumers": [{
                    "subnetwork": subnet.id,
                }],
            })
        ```
        ### Dataproc Metastore Service Private Service Connect Custom Routes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            region="us-central1",
            network=net.id,
            ip_cidr_range="10.0.0.0/22",
            private_ip_google_access=True)
        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            hive_metastore_config={
                "version": "3.1.2",
            },
            network_config={
                "consumers": [{
                    "subnetwork": subnet.id,
                }],
                "custom_routes_enabled": True,
            })
        ```
        ### Dataproc Metastore Service Dpms2

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dpms2 = gcp.dataproc.MetastoreService("dpms2",
            service_id="ms-dpms2",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "instance_size": "EXTRA_SMALL",
            })
        ```
        ### Dataproc Metastore Service Dpms2 Scaling Factor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dpms2_scaling_factor = gcp.dataproc.MetastoreService("dpms2_scaling_factor",
            service_id="ms-dpms2sf",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "scaling_factor": 2,
            })
        ```
        ### Dataproc Metastore Service Scheduled Backup

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="backup",
            location="us-central1")
        backup = gcp.dataproc.MetastoreService("backup",
            service_id="backup",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "2.3.6",
            },
            scheduled_backup={
                "enabled": True,
                "cron_schedule": "0 0 * * *",
                "time_zone": "UTC",
                "backup_location": bucket.name.apply(lambda name: f"gs://{name}"),
            },
            labels={
                "env": "test",
            })
        ```
        ### Dataproc Metastore Service Autoscaling Max Scaling Factor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_resource = gcp.dataproc.MetastoreService("test_resource",
            service_id="test-service",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "autoscaling_config": {
                    "autoscaling_enabled": True,
                    "limit_config": {
                        "max_scaling_factor": 1,
                    },
                },
            })
        ```
        ### Dataproc Metastore Service Autoscaling Min And Max Scaling Factor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_resource = gcp.dataproc.MetastoreService("test_resource",
            service_id="test-service",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "autoscaling_config": {
                    "autoscaling_enabled": True,
                    "limit_config": {
                        "min_scaling_factor": 0.1,
                        "max_scaling_factor": 1,
                    },
                },
            })
        ```
        ### Dataproc Metastore Service Autoscaling Min Scaling Factor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_resource = gcp.dataproc.MetastoreService("test_resource",
            service_id="test-service",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "autoscaling_config": {
                    "autoscaling_enabled": True,
                    "limit_config": {
                        "min_scaling_factor": 0.1,
                    },
                },
            })
        ```
        ### Dataproc Metastore Service Autoscaling No Limit Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_resource = gcp.dataproc.MetastoreService("test_resource",
            service_id="test-service",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "autoscaling_config": {
                    "autoscaling_enabled": True,
                },
            })
        ```

        ## Import

        Service can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/services/{{service_id}}`

        * `{{project}}/{{location}}/{{service_id}}`

        * `{{location}}/{{service_id}}`

        When using the `pulumi import` command, Service can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/metastoreService:MetastoreService default projects/{{project}}/locations/{{location}}/services/{{service_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/metastoreService:MetastoreService default {{project}}/{{location}}/{{service_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/metastoreService:MetastoreService default {{location}}/{{service_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_type: The database type that the Metastore service stores its data.
               Default value is `MYSQL`.
               Possible values are: `MYSQL`, `SPANNER`.
        :param pulumi.Input[bool] deletion_protection: Indicates if the dataproc metastore should be protected against accidental deletions.
        :param pulumi.Input[Union['MetastoreServiceEncryptionConfigArgs', 'MetastoreServiceEncryptionConfigArgsDict']] encryption_config: Information used to configure the Dataproc Metastore service to encrypt
               customer data at rest.
               Structure is documented below.
        :param pulumi.Input[Union['MetastoreServiceHiveMetastoreConfigArgs', 'MetastoreServiceHiveMetastoreConfigArgsDict']] hive_metastore_config: Configuration information specific to running Hive metastore software as the metastore service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the metastore service.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location where the metastore service should reside.
               The default value is `global`.
        :param pulumi.Input[Union['MetastoreServiceMaintenanceWindowArgs', 'MetastoreServiceMaintenanceWindowArgsDict']] maintenance_window: The one hour maintenance window of the metastore service.
               This specifies when the service can be restarted for maintenance purposes in UTC time.
               Maintenance window is not needed for services with the `SPANNER` database type.
               Structure is documented below.
        :param pulumi.Input[Union['MetastoreServiceMetadataIntegrationArgs', 'MetastoreServiceMetadataIntegrationArgsDict']] metadata_integration: The setting that defines how metastore metadata should be integrated with external services and systems.
               Structure is documented below.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[Union['MetastoreServiceNetworkConfigArgs', 'MetastoreServiceNetworkConfigArgsDict']] network_config: The configuration specifying the network settings for the Dataproc Metastore service.
               Structure is documented below.
        :param pulumi.Input[int] port: The TCP port at which the metastore service is reached. Default: 9083.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] release_channel: The release channel of the service. If unspecified, defaults to `STABLE`.
               Default value is `STABLE`.
               Possible values are: `CANARY`, `STABLE`.
        :param pulumi.Input[Union['MetastoreServiceScalingConfigArgs', 'MetastoreServiceScalingConfigArgsDict']] scaling_config: Represents the scaling configuration of a metastore service.
               Structure is documented below.
        :param pulumi.Input[Union['MetastoreServiceScheduledBackupArgs', 'MetastoreServiceScheduledBackupArgsDict']] scheduled_backup: The configuration of scheduled backup for the metastore service.
               Structure is documented below.
        :param pulumi.Input[str] service_id: The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
               and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
               3 and 63 characters.
               
               
               - - -
        :param pulumi.Input[Union['MetastoreServiceTelemetryConfigArgs', 'MetastoreServiceTelemetryConfigArgsDict']] telemetry_config: The configuration specifying telemetry settings for the Dataproc Metastore service. If unspecified defaults to JSON.
               Structure is documented below.
        :param pulumi.Input[str] tier: The tier of the service.
               Possible values are: `DEVELOPER`, `ENTERPRISE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetastoreServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A managed metastore service that serves metadata queries.

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/dataproc-metastore/docs/reference/rest/v1/projects.locations.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataproc-metastore/docs/overview)

        ## Example Usage

        ### Dataproc Metastore Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "2.3.6",
            },
            labels={
                "env": "test",
            })
        ```
        ### Dataproc Metastore Service Deletion Protection

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            deletion_protection=True,
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "2.3.6",
            },
            labels={
                "env": "test",
            })
        ```
        ### Dataproc Metastore Service Cmek Example

        ```python
        import pulumi
        import pulumi_gcp as gcp

        key_ring = gcp.kms.KeyRing("key_ring",
            name="example-keyring",
            location="us-central1")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="example-key",
            key_ring=key_ring.id,
            purpose="ENCRYPT_DECRYPT")
        default = gcp.dataproc.MetastoreService("default",
            service_id="example-service",
            location="us-central1",
            encryption_config={
                "kms_key": crypto_key.id,
            },
            hive_metastore_config={
                "version": "3.1.2",
            })
        ```
        ### Dataproc Metastore Service Private Service Connect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            region="us-central1",
            network=net.id,
            ip_cidr_range="10.0.0.0/22",
            private_ip_google_access=True)
        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            tier="DEVELOPER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            network_config={
                "consumers": [{
                    "subnetwork": subnet.id,
                }],
            })
        ```
        ### Dataproc Metastore Service Private Service Connect Custom Routes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        net = gcp.compute.Network("net",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnetwork",
            region="us-central1",
            network=net.id,
            ip_cidr_range="10.0.0.0/22",
            private_ip_google_access=True)
        default = gcp.dataproc.MetastoreService("default",
            service_id="metastore-srv",
            location="us-central1",
            hive_metastore_config={
                "version": "3.1.2",
            },
            network_config={
                "consumers": [{
                    "subnetwork": subnet.id,
                }],
                "custom_routes_enabled": True,
            })
        ```
        ### Dataproc Metastore Service Dpms2

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dpms2 = gcp.dataproc.MetastoreService("dpms2",
            service_id="ms-dpms2",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "instance_size": "EXTRA_SMALL",
            })
        ```
        ### Dataproc Metastore Service Dpms2 Scaling Factor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dpms2_scaling_factor = gcp.dataproc.MetastoreService("dpms2_scaling_factor",
            service_id="ms-dpms2sf",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "scaling_factor": 2,
            })
        ```
        ### Dataproc Metastore Service Scheduled Backup

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="backup",
            location="us-central1")
        backup = gcp.dataproc.MetastoreService("backup",
            service_id="backup",
            location="us-central1",
            port=9080,
            tier="DEVELOPER",
            maintenance_window={
                "hour_of_day": 2,
                "day_of_week": "SUNDAY",
            },
            hive_metastore_config={
                "version": "2.3.6",
            },
            scheduled_backup={
                "enabled": True,
                "cron_schedule": "0 0 * * *",
                "time_zone": "UTC",
                "backup_location": bucket.name.apply(lambda name: f"gs://{name}"),
            },
            labels={
                "env": "test",
            })
        ```
        ### Dataproc Metastore Service Autoscaling Max Scaling Factor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_resource = gcp.dataproc.MetastoreService("test_resource",
            service_id="test-service",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "autoscaling_config": {
                    "autoscaling_enabled": True,
                    "limit_config": {
                        "max_scaling_factor": 1,
                    },
                },
            })
        ```
        ### Dataproc Metastore Service Autoscaling Min And Max Scaling Factor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_resource = gcp.dataproc.MetastoreService("test_resource",
            service_id="test-service",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "autoscaling_config": {
                    "autoscaling_enabled": True,
                    "limit_config": {
                        "min_scaling_factor": 0.1,
                        "max_scaling_factor": 1,
                    },
                },
            })
        ```
        ### Dataproc Metastore Service Autoscaling Min Scaling Factor

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_resource = gcp.dataproc.MetastoreService("test_resource",
            service_id="test-service",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "autoscaling_config": {
                    "autoscaling_enabled": True,
                    "limit_config": {
                        "min_scaling_factor": 0.1,
                    },
                },
            })
        ```
        ### Dataproc Metastore Service Autoscaling No Limit Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_resource = gcp.dataproc.MetastoreService("test_resource",
            service_id="test-service",
            location="us-central1",
            database_type="SPANNER",
            hive_metastore_config={
                "version": "3.1.2",
            },
            scaling_config={
                "autoscaling_config": {
                    "autoscaling_enabled": True,
                },
            })
        ```

        ## Import

        Service can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/services/{{service_id}}`

        * `{{project}}/{{location}}/{{service_id}}`

        * `{{location}}/{{service_id}}`

        When using the `pulumi import` command, Service can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataproc/metastoreService:MetastoreService default projects/{{project}}/locations/{{location}}/services/{{service_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/metastoreService:MetastoreService default {{project}}/{{location}}/{{service_id}}
        ```

        ```sh
        $ pulumi import gcp:dataproc/metastoreService:MetastoreService default {{location}}/{{service_id}}
        ```

        :param str resource_name: The name of the resource.
        :param MetastoreServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetastoreServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 encryption_config: Optional[pulumi.Input[Union['MetastoreServiceEncryptionConfigArgs', 'MetastoreServiceEncryptionConfigArgsDict']]] = None,
                 hive_metastore_config: Optional[pulumi.Input[Union['MetastoreServiceHiveMetastoreConfigArgs', 'MetastoreServiceHiveMetastoreConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MetastoreServiceMaintenanceWindowArgs', 'MetastoreServiceMaintenanceWindowArgsDict']]] = None,
                 metadata_integration: Optional[pulumi.Input[Union['MetastoreServiceMetadataIntegrationArgs', 'MetastoreServiceMetadataIntegrationArgsDict']]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input[Union['MetastoreServiceNetworkConfigArgs', 'MetastoreServiceNetworkConfigArgsDict']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_channel: Optional[pulumi.Input[str]] = None,
                 scaling_config: Optional[pulumi.Input[Union['MetastoreServiceScalingConfigArgs', 'MetastoreServiceScalingConfigArgsDict']]] = None,
                 scheduled_backup: Optional[pulumi.Input[Union['MetastoreServiceScheduledBackupArgs', 'MetastoreServiceScheduledBackupArgsDict']]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 telemetry_config: Optional[pulumi.Input[Union['MetastoreServiceTelemetryConfigArgs', 'MetastoreServiceTelemetryConfigArgsDict']]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetastoreServiceArgs.__new__(MetastoreServiceArgs)

            __props__.__dict__["database_type"] = database_type
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["encryption_config"] = encryption_config
            __props__.__dict__["hive_metastore_config"] = hive_metastore_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["metadata_integration"] = metadata_integration
            __props__.__dict__["network"] = network
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["port"] = port
            __props__.__dict__["project"] = project
            __props__.__dict__["release_channel"] = release_channel
            __props__.__dict__["scaling_config"] = scaling_config
            __props__.__dict__["scheduled_backup"] = scheduled_backup
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["telemetry_config"] = telemetry_config
            __props__.__dict__["tier"] = tier
            __props__.__dict__["artifact_gcs_uri"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["endpoint_uri"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MetastoreService, __self__).__init__(
            'gcp:dataproc/metastoreService:MetastoreService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            artifact_gcs_uri: Optional[pulumi.Input[str]] = None,
            database_type: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            encryption_config: Optional[pulumi.Input[Union['MetastoreServiceEncryptionConfigArgs', 'MetastoreServiceEncryptionConfigArgsDict']]] = None,
            endpoint_uri: Optional[pulumi.Input[str]] = None,
            hive_metastore_config: Optional[pulumi.Input[Union['MetastoreServiceHiveMetastoreConfigArgs', 'MetastoreServiceHiveMetastoreConfigArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MetastoreServiceMaintenanceWindowArgs', 'MetastoreServiceMaintenanceWindowArgsDict']]] = None,
            metadata_integration: Optional[pulumi.Input[Union['MetastoreServiceMetadataIntegrationArgs', 'MetastoreServiceMetadataIntegrationArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            network_config: Optional[pulumi.Input[Union['MetastoreServiceNetworkConfigArgs', 'MetastoreServiceNetworkConfigArgsDict']]] = None,
            port: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            release_channel: Optional[pulumi.Input[str]] = None,
            scaling_config: Optional[pulumi.Input[Union['MetastoreServiceScalingConfigArgs', 'MetastoreServiceScalingConfigArgsDict']]] = None,
            scheduled_backup: Optional[pulumi.Input[Union['MetastoreServiceScheduledBackupArgs', 'MetastoreServiceScheduledBackupArgsDict']]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_message: Optional[pulumi.Input[str]] = None,
            telemetry_config: Optional[pulumi.Input[Union['MetastoreServiceTelemetryConfigArgs', 'MetastoreServiceTelemetryConfigArgsDict']]] = None,
            tier: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None) -> 'MetastoreService':
        """
        Get an existing MetastoreService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] artifact_gcs_uri: A Cloud Storage URI (starting with gs://) that specifies where artifacts related to the metastore service are stored.
        :param pulumi.Input[str] database_type: The database type that the Metastore service stores its data.
               Default value is `MYSQL`.
               Possible values are: `MYSQL`, `SPANNER`.
        :param pulumi.Input[bool] deletion_protection: Indicates if the dataproc metastore should be protected against accidental deletions.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['MetastoreServiceEncryptionConfigArgs', 'MetastoreServiceEncryptionConfigArgsDict']] encryption_config: Information used to configure the Dataproc Metastore service to encrypt
               customer data at rest.
               Structure is documented below.
        :param pulumi.Input[str] endpoint_uri: The URI of the endpoint used to access the metastore service.
        :param pulumi.Input[Union['MetastoreServiceHiveMetastoreConfigArgs', 'MetastoreServiceHiveMetastoreConfigArgsDict']] hive_metastore_config: Configuration information specific to running Hive metastore software as the metastore service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the metastore service.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The location where the metastore service should reside.
               The default value is `global`.
        :param pulumi.Input[Union['MetastoreServiceMaintenanceWindowArgs', 'MetastoreServiceMaintenanceWindowArgsDict']] maintenance_window: The one hour maintenance window of the metastore service.
               This specifies when the service can be restarted for maintenance purposes in UTC time.
               Maintenance window is not needed for services with the `SPANNER` database type.
               Structure is documented below.
        :param pulumi.Input[Union['MetastoreServiceMetadataIntegrationArgs', 'MetastoreServiceMetadataIntegrationArgsDict']] metadata_integration: The setting that defines how metastore metadata should be integrated with external services and systems.
               Structure is documented below.
        :param pulumi.Input[str] name: The relative resource name of the metastore service.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[Union['MetastoreServiceNetworkConfigArgs', 'MetastoreServiceNetworkConfigArgsDict']] network_config: The configuration specifying the network settings for the Dataproc Metastore service.
               Structure is documented below.
        :param pulumi.Input[int] port: The TCP port at which the metastore service is reached. Default: 9083.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] release_channel: The release channel of the service. If unspecified, defaults to `STABLE`.
               Default value is `STABLE`.
               Possible values are: `CANARY`, `STABLE`.
        :param pulumi.Input[Union['MetastoreServiceScalingConfigArgs', 'MetastoreServiceScalingConfigArgsDict']] scaling_config: Represents the scaling configuration of a metastore service.
               Structure is documented below.
        :param pulumi.Input[Union['MetastoreServiceScheduledBackupArgs', 'MetastoreServiceScheduledBackupArgsDict']] scheduled_backup: The configuration of scheduled backup for the metastore service.
               Structure is documented below.
        :param pulumi.Input[str] service_id: The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
               and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
               3 and 63 characters.
               
               
               - - -
        :param pulumi.Input[str] state: The current state of the metastore service.
        :param pulumi.Input[str] state_message: Additional information about the current state of the metastore service, if available.
        :param pulumi.Input[Union['MetastoreServiceTelemetryConfigArgs', 'MetastoreServiceTelemetryConfigArgsDict']] telemetry_config: The configuration specifying telemetry settings for the Dataproc Metastore service. If unspecified defaults to JSON.
               Structure is documented below.
        :param pulumi.Input[str] tier: The tier of the service.
               Possible values are: `DEVELOPER`, `ENTERPRISE`.
        :param pulumi.Input[str] uid: The globally unique resource identifier of the metastore service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetastoreServiceState.__new__(_MetastoreServiceState)

        __props__.__dict__["artifact_gcs_uri"] = artifact_gcs_uri
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["encryption_config"] = encryption_config
        __props__.__dict__["endpoint_uri"] = endpoint_uri
        __props__.__dict__["hive_metastore_config"] = hive_metastore_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["metadata_integration"] = metadata_integration
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["port"] = port
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["release_channel"] = release_channel
        __props__.__dict__["scaling_config"] = scaling_config
        __props__.__dict__["scheduled_backup"] = scheduled_backup
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["telemetry_config"] = telemetry_config
        __props__.__dict__["tier"] = tier
        __props__.__dict__["uid"] = uid
        return MetastoreService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="artifactGcsUri")
    def artifact_gcs_uri(self) -> pulumi.Output[str]:
        """
        A Cloud Storage URI (starting with gs://) that specifies where artifacts related to the metastore service are stored.
        """
        return pulumi.get(self, "artifact_gcs_uri")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[Optional[str]]:
        """
        The database type that the Metastore service stores its data.
        Default value is `MYSQL`.
        Possible values are: `MYSQL`, `SPANNER`.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if the dataproc metastore should be protected against accidental deletions.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> pulumi.Output[Optional['outputs.MetastoreServiceEncryptionConfig']]:
        """
        Information used to configure the Dataproc Metastore service to encrypt
        customer data at rest.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> pulumi.Output[str]:
        """
        The URI of the endpoint used to access the metastore service.
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="hiveMetastoreConfig")
    def hive_metastore_config(self) -> pulumi.Output[Optional['outputs.MetastoreServiceHiveMetastoreConfig']]:
        """
        Configuration information specific to running Hive metastore software as the metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "hive_metastore_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        User-defined labels for the metastore service.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location where the metastore service should reside.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.MetastoreServiceMaintenanceWindow']]:
        """
        The one hour maintenance window of the metastore service.
        This specifies when the service can be restarted for maintenance purposes in UTC time.
        Maintenance window is not needed for services with the `SPANNER` database type.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="metadataIntegration")
    def metadata_integration(self) -> pulumi.Output[Optional['outputs.MetastoreServiceMetadataIntegration']]:
        """
        The setting that defines how metastore metadata should be integrated with external services and systems.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata_integration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The relative resource name of the metastore service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
        "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output[Optional['outputs.MetastoreServiceNetworkConfig']]:
        """
        The configuration specifying the network settings for the Dataproc Metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The TCP port at which the metastore service is reached. Default: 9083.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The release channel of the service. If unspecified, defaults to `STABLE`.
        Default value is `STABLE`.
        Possible values are: `CANARY`, `STABLE`.
        """
        return pulumi.get(self, "release_channel")

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Output[Optional['outputs.MetastoreServiceScalingConfig']]:
        """
        Represents the scaling configuration of a metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling_config")

    @property
    @pulumi.getter(name="scheduledBackup")
    def scheduled_backup(self) -> pulumi.Output[Optional['outputs.MetastoreServiceScheduledBackup']]:
        """
        The configuration of scheduled backup for the metastore service.
        Structure is documented below.
        """
        return pulumi.get(self, "scheduled_backup")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The ID of the metastore service. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
        and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
        3 and 63 characters.


        - - -
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the metastore service.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[str]:
        """
        Additional information about the current state of the metastore service, if available.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="telemetryConfig")
    def telemetry_config(self) -> pulumi.Output['outputs.MetastoreServiceTelemetryConfig']:
        """
        The configuration specifying telemetry settings for the Dataproc Metastore service. If unspecified defaults to JSON.
        Structure is documented below.
        """
        return pulumi.get(self, "telemetry_config")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[str]:
        """
        The tier of the service.
        Possible values are: `DEVELOPER`, `ENTERPRISE`.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        The globally unique resource identifier of the metastore service.
        """
        return pulumi.get(self, "uid")

