# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionProfileBigqueryProfile',
    'ConnectionProfileForwardSshConnectivity',
    'ConnectionProfileGcsProfile',
    'ConnectionProfileMysqlProfile',
    'ConnectionProfileMysqlProfileSslConfig',
    'ConnectionProfileOracleProfile',
    'ConnectionProfilePostgresqlProfile',
    'ConnectionProfilePrivateConnectivity',
    'ConnectionProfileSqlServerProfile',
    'PrivateConnectionError',
    'PrivateConnectionVpcPeeringConfig',
    'StreamBackfillAll',
    'StreamBackfillAllMysqlExcludedObjects',
    'StreamBackfillAllMysqlExcludedObjectsMysqlDatabase',
    'StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTable',
    'StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumn',
    'StreamBackfillAllOracleExcludedObjects',
    'StreamBackfillAllOracleExcludedObjectsOracleSchema',
    'StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTable',
    'StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableOracleColumn',
    'StreamBackfillAllPostgresqlExcludedObjects',
    'StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchema',
    'StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTable',
    'StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn',
    'StreamBackfillAllSqlServerExcludedObjects',
    'StreamBackfillAllSqlServerExcludedObjectsSchema',
    'StreamBackfillAllSqlServerExcludedObjectsSchemaTable',
    'StreamBackfillAllSqlServerExcludedObjectsSchemaTableColumn',
    'StreamBackfillNone',
    'StreamDestinationConfig',
    'StreamDestinationConfigBigqueryDestinationConfig',
    'StreamDestinationConfigBigqueryDestinationConfigAppendOnly',
    'StreamDestinationConfigBigqueryDestinationConfigMerge',
    'StreamDestinationConfigBigqueryDestinationConfigSingleTargetDataset',
    'StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasets',
    'StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsDatasetTemplate',
    'StreamDestinationConfigGcsDestinationConfig',
    'StreamDestinationConfigGcsDestinationConfigAvroFileFormat',
    'StreamDestinationConfigGcsDestinationConfigJsonFileFormat',
    'StreamSourceConfig',
    'StreamSourceConfigMysqlSourceConfig',
    'StreamSourceConfigMysqlSourceConfigExcludeObjects',
    'StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabase',
    'StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTable',
    'StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumn',
    'StreamSourceConfigMysqlSourceConfigIncludeObjects',
    'StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabase',
    'StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTable',
    'StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumn',
    'StreamSourceConfigOracleSourceConfig',
    'StreamSourceConfigOracleSourceConfigDropLargeObjects',
    'StreamSourceConfigOracleSourceConfigExcludeObjects',
    'StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchema',
    'StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTable',
    'StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableOracleColumn',
    'StreamSourceConfigOracleSourceConfigIncludeObjects',
    'StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchema',
    'StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTable',
    'StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableOracleColumn',
    'StreamSourceConfigOracleSourceConfigStreamLargeObjects',
    'StreamSourceConfigPostgresqlSourceConfig',
    'StreamSourceConfigPostgresqlSourceConfigExcludeObjects',
    'StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchema',
    'StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTable',
    'StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn',
    'StreamSourceConfigPostgresqlSourceConfigIncludeObjects',
    'StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchema',
    'StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTable',
    'StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn',
    'StreamSourceConfigSqlServerSourceConfig',
    'StreamSourceConfigSqlServerSourceConfigChangeTables',
    'StreamSourceConfigSqlServerSourceConfigExcludeObjects',
    'StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchema',
    'StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTable',
    'StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableColumn',
    'StreamSourceConfigSqlServerSourceConfigIncludeObjects',
    'StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchema',
    'StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTable',
    'StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableColumn',
    'StreamSourceConfigSqlServerSourceConfigTransactionLogs',
]

@pulumi.output_type
class ConnectionProfileBigqueryProfile(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class ConnectionProfileForwardSshConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileForwardSshConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileForwardSshConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileForwardSshConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 username: str,
                 password: Optional[str] = None,
                 port: Optional[int] = None,
                 private_key: Optional[str] = None):
        """
        :param str hostname: Hostname for the SSH tunnel.
        :param str username: Username for the SSH tunnel.
        :param str password: SSH password.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param int port: Port for the SSH tunnel.
        :param str private_key: SSH private key.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        SSH password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[str]:
        """
        SSH private key.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")


@pulumi.output_type
class ConnectionProfileGcsProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootPath":
            suggest = "root_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileGcsProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileGcsProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileGcsProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 root_path: Optional[str] = None):
        """
        :param str bucket: The Cloud Storage bucket name.
        :param str root_path: The root path inside the Cloud Storage bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        if root_path is not None:
            pulumi.set(__self__, "root_path", root_path)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="rootPath")
    def root_path(self) -> Optional[str]:
        """
        The root path inside the Cloud Storage bucket.
        """
        return pulumi.get(self, "root_path")


@pulumi.output_type
class ConnectionProfileMysqlProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslConfig":
            suggest = "ssl_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileMysqlProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileMysqlProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileMysqlProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 password: str,
                 username: str,
                 port: Optional[int] = None,
                 ssl_config: Optional['outputs.ConnectionProfileMysqlProfileSslConfig'] = None):
        """
        :param str hostname: Hostname for the MySQL connection.
        :param str password: Password for the MySQL connection.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: Username for the MySQL connection.
        :param int port: Port for the MySQL connection.
        :param 'ConnectionProfileMysqlProfileSslConfigArgs' ssl_config: SSL configuration for the MySQL connection.
               Structure is documented below.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl_config is not None:
            pulumi.set(__self__, "ssl_config", ssl_config)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the MySQL connection.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the MySQL connection.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the MySQL connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the MySQL connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> Optional['outputs.ConnectionProfileMysqlProfileSslConfig']:
        """
        SSL configuration for the MySQL connection.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_config")


@pulumi.output_type
class ConnectionProfileMysqlProfileSslConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "caCertificateSet":
            suggest = "ca_certificate_set"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientCertificateSet":
            suggest = "client_certificate_set"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clientKeySet":
            suggest = "client_key_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileMysqlProfileSslConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileMysqlProfileSslConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileMysqlProfileSslConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: Optional[str] = None,
                 ca_certificate_set: Optional[bool] = None,
                 client_certificate: Optional[str] = None,
                 client_certificate_set: Optional[bool] = None,
                 client_key: Optional[str] = None,
                 client_key_set: Optional[bool] = None):
        """
        :param str ca_certificate: PEM-encoded certificate of the CA that signed the source database
               server's certificate.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool ca_certificate_set: (Output)
               Indicates whether the clientKey field is set.
        :param str client_certificate: PEM-encoded certificate that will be used by the replica to
               authenticate against the source database server. If this field
               is used then the 'clientKey' and the 'caCertificate' fields are
               mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool client_certificate_set: (Output)
               Indicates whether the clientCertificate field is set.
        :param str client_key: PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'client_certificate' and the
               'ca_certificate' fields are mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool client_key_set: (Output)
               Indicates whether the clientKey field is set.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if ca_certificate_set is not None:
            pulumi.set(__self__, "ca_certificate_set", ca_certificate_set)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_certificate_set is not None:
            pulumi.set(__self__, "client_certificate_set", client_certificate_set)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if client_key_set is not None:
            pulumi.set(__self__, "client_key_set", client_key_set)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[str]:
        """
        PEM-encoded certificate of the CA that signed the source database
        server's certificate.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="caCertificateSet")
    def ca_certificate_set(self) -> Optional[bool]:
        """
        (Output)
        Indicates whether the clientKey field is set.
        """
        return pulumi.get(self, "ca_certificate_set")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        PEM-encoded certificate that will be used by the replica to
        authenticate against the source database server. If this field
        is used then the 'clientKey' and the 'caCertificate' fields are
        mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientCertificateSet")
    def client_certificate_set(self) -> Optional[bool]:
        """
        (Output)
        Indicates whether the clientCertificate field is set.
        """
        return pulumi.get(self, "client_certificate_set")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'client_certificate' and the
        'ca_certificate' fields are mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clientKeySet")
    def client_key_set(self) -> Optional[bool]:
        """
        (Output)
        Indicates whether the clientKey field is set.
        """
        return pulumi.get(self, "client_key_set")


@pulumi.output_type
class ConnectionProfileOracleProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseService":
            suggest = "database_service"
        elif key == "connectionAttributes":
            suggest = "connection_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileOracleProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileOracleProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileOracleProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_service: str,
                 hostname: str,
                 password: str,
                 username: str,
                 connection_attributes: Optional[Mapping[str, str]] = None,
                 port: Optional[int] = None):
        """
        :param str database_service: Database for the Oracle connection.
        :param str hostname: Hostname for the Oracle connection.
        :param str password: Password for the Oracle connection.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: Username for the Oracle connection.
        :param Mapping[str, str] connection_attributes: Connection string attributes
        :param int port: Port for the Oracle connection.
        """
        pulumi.set(__self__, "database_service", database_service)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if connection_attributes is not None:
            pulumi.set(__self__, "connection_attributes", connection_attributes)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="databaseService")
    def database_service(self) -> str:
        """
        Database for the Oracle connection.
        """
        return pulumi.get(self, "database_service")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the Oracle connection.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the Oracle connection.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the Oracle connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="connectionAttributes")
    def connection_attributes(self) -> Optional[Mapping[str, str]]:
        """
        Connection string attributes
        """
        return pulumi.get(self, "connection_attributes")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the Oracle connection.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ConnectionProfilePostgresqlProfile(dict):
    def __init__(__self__, *,
                 database: str,
                 hostname: str,
                 password: str,
                 username: str,
                 port: Optional[int] = None):
        """
        :param str database: Database for the PostgreSQL connection.
        :param str hostname: Hostname for the PostgreSQL connection.
        :param str password: Password for the PostgreSQL connection.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: Username for the PostgreSQL connection.
        :param int port: Port for the PostgreSQL connection.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database for the PostgreSQL connection.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the PostgreSQL connection.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the PostgreSQL connection.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the PostgreSQL connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the PostgreSQL connection.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ConnectionProfilePrivateConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateConnection":
            suggest = "private_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfilePrivateConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfilePrivateConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfilePrivateConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_connection: str):
        """
        :param str private_connection: A reference to a private connection resource. Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        """
        pulumi.set(__self__, "private_connection", private_connection)

    @property
    @pulumi.getter(name="privateConnection")
    def private_connection(self) -> str:
        """
        A reference to a private connection resource. Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        """
        return pulumi.get(self, "private_connection")


@pulumi.output_type
class ConnectionProfileSqlServerProfile(dict):
    def __init__(__self__, *,
                 database: str,
                 hostname: str,
                 password: str,
                 username: str,
                 port: Optional[int] = None):
        """
        :param str database: Database for the SQL Server connection.
        :param str hostname: Hostname for the SQL Server connection.
        :param str password: Password for the SQL Server connection.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: Username for the SQL Server connection.
        :param int port: Port for the SQL Server connection.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database for the SQL Server connection.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the SQL Server connection.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the SQL Server connection.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the SQL Server connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the SQL Server connection.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class PrivateConnectionError(dict):
    def __init__(__self__, *,
                 details: Optional[Mapping[str, str]] = None,
                 message: Optional[str] = None):
        """
        :param Mapping[str, str] details: A list of messages that carry the error details.
        :param str message: A message containing more information about the error that occurred.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def details(self) -> Optional[Mapping[str, str]]:
        """
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A message containing more information about the error that occurred.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class PrivateConnectionVpcPeeringConfig(dict):
    def __init__(__self__, *,
                 subnet: str,
                 vpc: str):
        """
        :param str subnet: A free subnet for peering. (CIDR of /29)
               
               - - -
        :param str vpc: Fully qualified name of the VPC that Datastream will peer to.
               Format: projects/{project}/global/{networks}/{name}
        """
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        A free subnet for peering. (CIDR of /29)

        - - -
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def vpc(self) -> str:
        """
        Fully qualified name of the VPC that Datastream will peer to.
        Format: projects/{project}/global/{networks}/{name}
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class StreamBackfillAll(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlExcludedObjects":
            suggest = "mysql_excluded_objects"
        elif key == "oracleExcludedObjects":
            suggest = "oracle_excluded_objects"
        elif key == "postgresqlExcludedObjects":
            suggest = "postgresql_excluded_objects"
        elif key == "sqlServerExcludedObjects":
            suggest = "sql_server_excluded_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAll. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAll.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAll.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mysql_excluded_objects: Optional['outputs.StreamBackfillAllMysqlExcludedObjects'] = None,
                 oracle_excluded_objects: Optional['outputs.StreamBackfillAllOracleExcludedObjects'] = None,
                 postgresql_excluded_objects: Optional['outputs.StreamBackfillAllPostgresqlExcludedObjects'] = None,
                 sql_server_excluded_objects: Optional['outputs.StreamBackfillAllSqlServerExcludedObjects'] = None):
        """
        :param 'StreamBackfillAllMysqlExcludedObjectsArgs' mysql_excluded_objects: MySQL data source objects to avoid backfilling.
               Structure is documented below.
        :param 'StreamBackfillAllOracleExcludedObjectsArgs' oracle_excluded_objects: PostgreSQL data source objects to avoid backfilling.
               Structure is documented below.
        :param 'StreamBackfillAllPostgresqlExcludedObjectsArgs' postgresql_excluded_objects: PostgreSQL data source objects to avoid backfilling.
               Structure is documented below.
        :param 'StreamBackfillAllSqlServerExcludedObjectsArgs' sql_server_excluded_objects: SQL Server data source objects to avoid backfilling.
               Structure is documented below.
        """
        if mysql_excluded_objects is not None:
            pulumi.set(__self__, "mysql_excluded_objects", mysql_excluded_objects)
        if oracle_excluded_objects is not None:
            pulumi.set(__self__, "oracle_excluded_objects", oracle_excluded_objects)
        if postgresql_excluded_objects is not None:
            pulumi.set(__self__, "postgresql_excluded_objects", postgresql_excluded_objects)
        if sql_server_excluded_objects is not None:
            pulumi.set(__self__, "sql_server_excluded_objects", sql_server_excluded_objects)

    @property
    @pulumi.getter(name="mysqlExcludedObjects")
    def mysql_excluded_objects(self) -> Optional['outputs.StreamBackfillAllMysqlExcludedObjects']:
        """
        MySQL data source objects to avoid backfilling.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_excluded_objects")

    @property
    @pulumi.getter(name="oracleExcludedObjects")
    def oracle_excluded_objects(self) -> Optional['outputs.StreamBackfillAllOracleExcludedObjects']:
        """
        PostgreSQL data source objects to avoid backfilling.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_excluded_objects")

    @property
    @pulumi.getter(name="postgresqlExcludedObjects")
    def postgresql_excluded_objects(self) -> Optional['outputs.StreamBackfillAllPostgresqlExcludedObjects']:
        """
        PostgreSQL data source objects to avoid backfilling.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_excluded_objects")

    @property
    @pulumi.getter(name="sqlServerExcludedObjects")
    def sql_server_excluded_objects(self) -> Optional['outputs.StreamBackfillAllSqlServerExcludedObjects']:
        """
        SQL Server data source objects to avoid backfilling.
        Structure is documented below.
        """
        return pulumi.get(self, "sql_server_excluded_objects")


@pulumi.output_type
class StreamBackfillAllMysqlExcludedObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlDatabases":
            suggest = "mysql_databases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllMysqlExcludedObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllMysqlExcludedObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllMysqlExcludedObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mysql_databases: Sequence['outputs.StreamBackfillAllMysqlExcludedObjectsMysqlDatabase']):
        """
        :param Sequence['StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseArgs'] mysql_databases: MySQL databases on the server
               Structure is documented below.
        """
        pulumi.set(__self__, "mysql_databases", mysql_databases)

    @property
    @pulumi.getter(name="mysqlDatabases")
    def mysql_databases(self) -> Sequence['outputs.StreamBackfillAllMysqlExcludedObjectsMysqlDatabase']:
        """
        MySQL databases on the server
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_databases")


@pulumi.output_type
class StreamBackfillAllMysqlExcludedObjectsMysqlDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlTables":
            suggest = "mysql_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllMysqlExcludedObjectsMysqlDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllMysqlExcludedObjectsMysqlDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllMysqlExcludedObjectsMysqlDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 mysql_tables: Optional[Sequence['outputs.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTable']] = None):
        """
        :param str database: Database name.
        :param Sequence['StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableArgs'] mysql_tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "database", database)
        if mysql_tables is not None:
            pulumi.set(__self__, "mysql_tables", mysql_tables)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="mysqlTables")
    def mysql_tables(self) -> Optional[Sequence['outputs.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_tables")


@pulumi.output_type
class StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlColumns":
            suggest = "mysql_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 mysql_columns: Optional[Sequence['outputs.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumnArgs'] mysql_columns: MySQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if mysql_columns is not None:
            pulumi.set(__self__, "mysql_columns", mysql_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="mysqlColumns")
    def mysql_columns(self) -> Optional[Sequence['outputs.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumn']]:
        """
        MySQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_columns")


@pulumi.output_type
class StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collation: Optional[str] = None,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 primary_key: Optional[bool] = None):
        """
        :param str collation: Column collation.
        :param str column: Column name.
        :param str data_type: The MySQL data type. Full data types list can be found here:
               https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        :param int length: (Output)
               Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param bool primary_key: Whether or not the column represents a primary key.
        """
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        Column collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The MySQL data type. Full data types list can be found here:
        https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")


@pulumi.output_type
class StreamBackfillAllOracleExcludedObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleSchemas":
            suggest = "oracle_schemas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllOracleExcludedObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllOracleExcludedObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllOracleExcludedObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oracle_schemas: Sequence['outputs.StreamBackfillAllOracleExcludedObjectsOracleSchema']):
        """
        :param Sequence['StreamBackfillAllOracleExcludedObjectsOracleSchemaArgs'] oracle_schemas: Oracle schemas/databases in the database server
               Structure is documented below.
        """
        pulumi.set(__self__, "oracle_schemas", oracle_schemas)

    @property
    @pulumi.getter(name="oracleSchemas")
    def oracle_schemas(self) -> Sequence['outputs.StreamBackfillAllOracleExcludedObjectsOracleSchema']:
        """
        Oracle schemas/databases in the database server
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_schemas")


@pulumi.output_type
class StreamBackfillAllOracleExcludedObjectsOracleSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleTables":
            suggest = "oracle_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllOracleExcludedObjectsOracleSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllOracleExcludedObjectsOracleSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllOracleExcludedObjectsOracleSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema: str,
                 oracle_tables: Optional[Sequence['outputs.StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTable']] = None):
        """
        :param str schema: Schema name.
        :param Sequence['StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableArgs'] oracle_tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if oracle_tables is not None:
            pulumi.set(__self__, "oracle_tables", oracle_tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="oracleTables")
    def oracle_tables(self) -> Optional[Sequence['outputs.StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_tables")


@pulumi.output_type
class StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleColumns":
            suggest = "oracle_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 oracle_columns: Optional[Sequence['outputs.StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableOracleColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableOracleColumnArgs'] oracle_columns: Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if oracle_columns is not None:
            pulumi.set(__self__, "oracle_columns", oracle_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="oracleColumns")
    def oracle_columns(self) -> Optional[Sequence['outputs.StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableOracleColumn']]:
        """
        Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_columns")


@pulumi.output_type
class StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableOracleColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableOracleColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableOracleColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllOracleExcludedObjectsOracleSchemaOracleTableOracleColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 encoding: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The Oracle data type. Full data types list can be found here:
               https://docs.oracle.com/en/database/oracle/oracle-database/21/sqlrf/Data-Types.html
        :param str encoding: (Output)
               Column encoding.
        :param int length: (Output)
               Column length.
        :param bool nullable: (Output)
               Whether or not the column can accept a null value.
        :param int ordinal_position: (Output)
               The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: (Output)
               Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The Oracle data type. Full data types list can be found here:
        https://docs.oracle.com/en/database/oracle/oracle-database/21/sqlrf/Data-Types.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        (Output)
        Column encoding.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        (Output)
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamBackfillAllPostgresqlExcludedObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlSchemas":
            suggest = "postgresql_schemas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllPostgresqlExcludedObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllPostgresqlExcludedObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllPostgresqlExcludedObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 postgresql_schemas: Sequence['outputs.StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchema']):
        """
        :param Sequence['StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaArgs'] postgresql_schemas: PostgreSQL schemas on the server
               Structure is documented below.
        """
        pulumi.set(__self__, "postgresql_schemas", postgresql_schemas)

    @property
    @pulumi.getter(name="postgresqlSchemas")
    def postgresql_schemas(self) -> Sequence['outputs.StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchema']:
        """
        PostgreSQL schemas on the server
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_schemas")


@pulumi.output_type
class StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlTables":
            suggest = "postgresql_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema: str,
                 postgresql_tables: Optional[Sequence['outputs.StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTable']] = None):
        """
        :param str schema: Database name.
        :param Sequence['StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTableArgs'] postgresql_tables: Tables in the schema.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if postgresql_tables is not None:
            pulumi.set(__self__, "postgresql_tables", postgresql_tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="postgresqlTables")
    def postgresql_tables(self) -> Optional[Sequence['outputs.StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTable']]:
        """
        Tables in the schema.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_tables")


@pulumi.output_type
class StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlColumns":
            suggest = "postgresql_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 postgresql_columns: Optional[Sequence['outputs.StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumnArgs'] postgresql_columns: PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if postgresql_columns is not None:
            pulumi.set(__self__, "postgresql_columns", postgresql_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="postgresqlColumns")
    def postgresql_columns(self) -> Optional[Sequence['outputs.StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn']]:
        """
        PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_columns")


@pulumi.output_type
class StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllPostgresqlExcludedObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The PostgreSQL data type. Full data types list can be found here:
               https://www.postgresql.org/docs/current/datatype.html
        :param int length: (Output)
               Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The PostgreSQL data type. Full data types list can be found here:
        https://www.postgresql.org/docs/current/datatype.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamBackfillAllSqlServerExcludedObjects(dict):
    def __init__(__self__, *,
                 schemas: Sequence['outputs.StreamBackfillAllSqlServerExcludedObjectsSchema']):
        """
        :param Sequence['StreamBackfillAllSqlServerExcludedObjectsSchemaArgs'] schemas: SQL Server schemas/databases in the database server
               Structure is documented below.
        """
        pulumi.set(__self__, "schemas", schemas)

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.StreamBackfillAllSqlServerExcludedObjectsSchema']:
        """
        SQL Server schemas/databases in the database server
        Structure is documented below.
        """
        return pulumi.get(self, "schemas")


@pulumi.output_type
class StreamBackfillAllSqlServerExcludedObjectsSchema(dict):
    def __init__(__self__, *,
                 schema: str,
                 tables: Optional[Sequence['outputs.StreamBackfillAllSqlServerExcludedObjectsSchemaTable']] = None):
        """
        :param str schema: Schema name.
        :param Sequence['StreamBackfillAllSqlServerExcludedObjectsSchemaTableArgs'] tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tables(self) -> Optional[Sequence['outputs.StreamBackfillAllSqlServerExcludedObjectsSchemaTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class StreamBackfillAllSqlServerExcludedObjectsSchemaTable(dict):
    def __init__(__self__, *,
                 table: str,
                 columns: Optional[Sequence['outputs.StreamBackfillAllSqlServerExcludedObjectsSchemaTableColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamBackfillAllSqlServerExcludedObjectsSchemaTableColumnArgs'] columns: SQL Server columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.StreamBackfillAllSqlServerExcludedObjectsSchemaTableColumn']]:
        """
        SQL Server columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class StreamBackfillAllSqlServerExcludedObjectsSchemaTableColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamBackfillAllSqlServerExcludedObjectsSchemaTableColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamBackfillAllSqlServerExcludedObjectsSchemaTableColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamBackfillAllSqlServerExcludedObjectsSchemaTableColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The SQL Server data type. Full data types list can be found here:
               https://learn.microsoft.com/en-us/sql/t-sql/data-types/data-types-transact-sql?view=sql-server-ver16
        :param int length: (Output)
               Column length.
        :param bool nullable: (Output)
               Whether or not the column can accept a null value.
        :param int ordinal_position: (Output)
               The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: (Output)
               Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The SQL Server data type. Full data types list can be found here:
        https://learn.microsoft.com/en-us/sql/t-sql/data-types/data-types-transact-sql?view=sql-server-ver16
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        (Output)
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamBackfillNone(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StreamDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationConnectionProfile":
            suggest = "destination_connection_profile"
        elif key == "bigqueryDestinationConfig":
            suggest = "bigquery_destination_config"
        elif key == "gcsDestinationConfig":
            suggest = "gcs_destination_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_connection_profile: str,
                 bigquery_destination_config: Optional['outputs.StreamDestinationConfigBigqueryDestinationConfig'] = None,
                 gcs_destination_config: Optional['outputs.StreamDestinationConfigGcsDestinationConfig'] = None):
        """
        :param str destination_connection_profile: Destination connection profile resource. Format: projects/{project}/locations/{location}/connectionProfiles/{name}
        :param 'StreamDestinationConfigBigqueryDestinationConfigArgs' bigquery_destination_config: A configuration for how data should be loaded to Google BigQuery.
               Structure is documented below.
        :param 'StreamDestinationConfigGcsDestinationConfigArgs' gcs_destination_config: A configuration for how data should be loaded to Cloud Storage.
               Structure is documented below.
        """
        pulumi.set(__self__, "destination_connection_profile", destination_connection_profile)
        if bigquery_destination_config is not None:
            pulumi.set(__self__, "bigquery_destination_config", bigquery_destination_config)
        if gcs_destination_config is not None:
            pulumi.set(__self__, "gcs_destination_config", gcs_destination_config)

    @property
    @pulumi.getter(name="destinationConnectionProfile")
    def destination_connection_profile(self) -> str:
        """
        Destination connection profile resource. Format: projects/{project}/locations/{location}/connectionProfiles/{name}
        """
        return pulumi.get(self, "destination_connection_profile")

    @property
    @pulumi.getter(name="bigqueryDestinationConfig")
    def bigquery_destination_config(self) -> Optional['outputs.StreamDestinationConfigBigqueryDestinationConfig']:
        """
        A configuration for how data should be loaded to Google BigQuery.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_destination_config")

    @property
    @pulumi.getter(name="gcsDestinationConfig")
    def gcs_destination_config(self) -> Optional['outputs.StreamDestinationConfigGcsDestinationConfig']:
        """
        A configuration for how data should be loaded to Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_destination_config")


@pulumi.output_type
class StreamDestinationConfigBigqueryDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appendOnly":
            suggest = "append_only"
        elif key == "dataFreshness":
            suggest = "data_freshness"
        elif key == "singleTargetDataset":
            suggest = "single_target_dataset"
        elif key == "sourceHierarchyDatasets":
            suggest = "source_hierarchy_datasets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamDestinationConfigBigqueryDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamDestinationConfigBigqueryDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamDestinationConfigBigqueryDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 append_only: Optional['outputs.StreamDestinationConfigBigqueryDestinationConfigAppendOnly'] = None,
                 data_freshness: Optional[str] = None,
                 merge: Optional['outputs.StreamDestinationConfigBigqueryDestinationConfigMerge'] = None,
                 single_target_dataset: Optional['outputs.StreamDestinationConfigBigqueryDestinationConfigSingleTargetDataset'] = None,
                 source_hierarchy_datasets: Optional['outputs.StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasets'] = None):
        """
        :param 'StreamDestinationConfigBigqueryDestinationConfigAppendOnlyArgs' append_only: AppendOnly mode defines that the stream of changes (INSERT, UPDATE-INSERT, UPDATE-DELETE and DELETE
               events) to a source table will be written to the destination Google BigQuery table, retaining the
               historical state of the data.
        :param str data_freshness: The guaranteed data freshness (in seconds) when querying tables created by the stream.
               Editing this field will only affect new tables created in the future, but existing tables
               will not be impacted. Lower values mean that queries will return fresher data, but may result in higher cost.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
        :param 'StreamDestinationConfigBigqueryDestinationConfigMergeArgs' merge: Merge mode defines that all changes to a table will be merged at the destination Google BigQuery
               table. This is the default write mode. When selected, BigQuery reflects the way the data is stored
               in the source database. With Merge mode, no historical record of the change events is kept.
        :param 'StreamDestinationConfigBigqueryDestinationConfigSingleTargetDatasetArgs' single_target_dataset: A single target dataset to which all data will be streamed.
               Structure is documented below.
        :param 'StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsArgs' source_hierarchy_datasets: Destination datasets are created so that hierarchy of the destination data objects matches the source hierarchy.
               Structure is documented below.
        """
        if append_only is not None:
            pulumi.set(__self__, "append_only", append_only)
        if data_freshness is not None:
            pulumi.set(__self__, "data_freshness", data_freshness)
        if merge is not None:
            pulumi.set(__self__, "merge", merge)
        if single_target_dataset is not None:
            pulumi.set(__self__, "single_target_dataset", single_target_dataset)
        if source_hierarchy_datasets is not None:
            pulumi.set(__self__, "source_hierarchy_datasets", source_hierarchy_datasets)

    @property
    @pulumi.getter(name="appendOnly")
    def append_only(self) -> Optional['outputs.StreamDestinationConfigBigqueryDestinationConfigAppendOnly']:
        """
        AppendOnly mode defines that the stream of changes (INSERT, UPDATE-INSERT, UPDATE-DELETE and DELETE
        events) to a source table will be written to the destination Google BigQuery table, retaining the
        historical state of the data.
        """
        return pulumi.get(self, "append_only")

    @property
    @pulumi.getter(name="dataFreshness")
    def data_freshness(self) -> Optional[str]:
        """
        The guaranteed data freshness (in seconds) when querying tables created by the stream.
        Editing this field will only affect new tables created in the future, but existing tables
        will not be impacted. Lower values mean that queries will return fresher data, but may result in higher cost.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
        """
        return pulumi.get(self, "data_freshness")

    @property
    @pulumi.getter
    def merge(self) -> Optional['outputs.StreamDestinationConfigBigqueryDestinationConfigMerge']:
        """
        Merge mode defines that all changes to a table will be merged at the destination Google BigQuery
        table. This is the default write mode. When selected, BigQuery reflects the way the data is stored
        in the source database. With Merge mode, no historical record of the change events is kept.
        """
        return pulumi.get(self, "merge")

    @property
    @pulumi.getter(name="singleTargetDataset")
    def single_target_dataset(self) -> Optional['outputs.StreamDestinationConfigBigqueryDestinationConfigSingleTargetDataset']:
        """
        A single target dataset to which all data will be streamed.
        Structure is documented below.
        """
        return pulumi.get(self, "single_target_dataset")

    @property
    @pulumi.getter(name="sourceHierarchyDatasets")
    def source_hierarchy_datasets(self) -> Optional['outputs.StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasets']:
        """
        Destination datasets are created so that hierarchy of the destination data objects matches the source hierarchy.
        Structure is documented below.
        """
        return pulumi.get(self, "source_hierarchy_datasets")


@pulumi.output_type
class StreamDestinationConfigBigqueryDestinationConfigAppendOnly(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StreamDestinationConfigBigqueryDestinationConfigMerge(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StreamDestinationConfigBigqueryDestinationConfigSingleTargetDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamDestinationConfigBigqueryDestinationConfigSingleTargetDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamDestinationConfigBigqueryDestinationConfigSingleTargetDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamDestinationConfigBigqueryDestinationConfigSingleTargetDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str):
        """
        :param str dataset_id: Dataset ID in the format projects/{project}/datasets/{dataset_id} or
               {project}:{dataset_id}
        """
        pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        Dataset ID in the format projects/{project}/datasets/{dataset_id} or
        {project}:{dataset_id}
        """
        return pulumi.get(self, "dataset_id")


@pulumi.output_type
class StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetTemplate":
            suggest = "dataset_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_template: 'outputs.StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsDatasetTemplate'):
        """
        :param 'StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsDatasetTemplateArgs' dataset_template: Dataset template used for dynamic dataset creation.
               Structure is documented below.
        """
        pulumi.set(__self__, "dataset_template", dataset_template)

    @property
    @pulumi.getter(name="datasetTemplate")
    def dataset_template(self) -> 'outputs.StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsDatasetTemplate':
        """
        Dataset template used for dynamic dataset creation.
        Structure is documented below.
        """
        return pulumi.get(self, "dataset_template")


@pulumi.output_type
class StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsDatasetTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetIdPrefix":
            suggest = "dataset_id_prefix"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsDatasetTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsDatasetTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamDestinationConfigBigqueryDestinationConfigSourceHierarchyDatasetsDatasetTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 dataset_id_prefix: Optional[str] = None,
                 kms_key_name: Optional[str] = None):
        """
        :param str location: The geographic location where the dataset should reside.
               See https://cloud.google.com/bigquery/docs/locations for supported locations.
        :param str dataset_id_prefix: If supplied, every created dataset will have its name prefixed by the provided value.
               The prefix and name will be separated by an underscore. i.e. _.
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery
               table. The BigQuery Service Account associated with your project requires access to this
               encryption key. i.e. projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
               See https://cloud.google.com/bigquery/docs/customer-managed-encryption for more information.
               
               - - -
        """
        pulumi.set(__self__, "location", location)
        if dataset_id_prefix is not None:
            pulumi.set(__self__, "dataset_id_prefix", dataset_id_prefix)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geographic location where the dataset should reside.
        See https://cloud.google.com/bigquery/docs/locations for supported locations.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="datasetIdPrefix")
    def dataset_id_prefix(self) -> Optional[str]:
        """
        If supplied, every created dataset will have its name prefixed by the provided value.
        The prefix and name will be separated by an underscore. i.e. _.
        """
        return pulumi.get(self, "dataset_id_prefix")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery
        table. The BigQuery Service Account associated with your project requires access to this
        encryption key. i.e. projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}.
        See https://cloud.google.com/bigquery/docs/customer-managed-encryption for more information.

        - - -
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class StreamDestinationConfigGcsDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "avroFileFormat":
            suggest = "avro_file_format"
        elif key == "fileRotationInterval":
            suggest = "file_rotation_interval"
        elif key == "fileRotationMb":
            suggest = "file_rotation_mb"
        elif key == "jsonFileFormat":
            suggest = "json_file_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamDestinationConfigGcsDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamDestinationConfigGcsDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamDestinationConfigGcsDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 avro_file_format: Optional['outputs.StreamDestinationConfigGcsDestinationConfigAvroFileFormat'] = None,
                 file_rotation_interval: Optional[str] = None,
                 file_rotation_mb: Optional[int] = None,
                 json_file_format: Optional['outputs.StreamDestinationConfigGcsDestinationConfigJsonFileFormat'] = None,
                 path: Optional[str] = None):
        """
        :param 'StreamDestinationConfigGcsDestinationConfigAvroFileFormatArgs' avro_file_format: AVRO file format configuration.
        :param str file_rotation_interval: The maximum duration for which new events are added before a file is closed and a new file is created.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
        :param int file_rotation_mb: The maximum file size to be saved in the bucket.
        :param 'StreamDestinationConfigGcsDestinationConfigJsonFileFormatArgs' json_file_format: JSON file format configuration.
               Structure is documented below.
        :param str path: Path inside the Cloud Storage bucket to write data to.
        """
        if avro_file_format is not None:
            pulumi.set(__self__, "avro_file_format", avro_file_format)
        if file_rotation_interval is not None:
            pulumi.set(__self__, "file_rotation_interval", file_rotation_interval)
        if file_rotation_mb is not None:
            pulumi.set(__self__, "file_rotation_mb", file_rotation_mb)
        if json_file_format is not None:
            pulumi.set(__self__, "json_file_format", json_file_format)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="avroFileFormat")
    def avro_file_format(self) -> Optional['outputs.StreamDestinationConfigGcsDestinationConfigAvroFileFormat']:
        """
        AVRO file format configuration.
        """
        return pulumi.get(self, "avro_file_format")

    @property
    @pulumi.getter(name="fileRotationInterval")
    def file_rotation_interval(self) -> Optional[str]:
        """
        The maximum duration for which new events are added before a file is closed and a new file is created.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
        """
        return pulumi.get(self, "file_rotation_interval")

    @property
    @pulumi.getter(name="fileRotationMb")
    def file_rotation_mb(self) -> Optional[int]:
        """
        The maximum file size to be saved in the bucket.
        """
        return pulumi.get(self, "file_rotation_mb")

    @property
    @pulumi.getter(name="jsonFileFormat")
    def json_file_format(self) -> Optional['outputs.StreamDestinationConfigGcsDestinationConfigJsonFileFormat']:
        """
        JSON file format configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "json_file_format")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path inside the Cloud Storage bucket to write data to.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class StreamDestinationConfigGcsDestinationConfigAvroFileFormat(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StreamDestinationConfigGcsDestinationConfigJsonFileFormat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemaFileFormat":
            suggest = "schema_file_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamDestinationConfigGcsDestinationConfigJsonFileFormat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamDestinationConfigGcsDestinationConfigJsonFileFormat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamDestinationConfigGcsDestinationConfigJsonFileFormat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compression: Optional[str] = None,
                 schema_file_format: Optional[str] = None):
        """
        :param str compression: Compression of the loaded JSON file.
               Possible values are: `NO_COMPRESSION`, `GZIP`.
        :param str schema_file_format: The schema file format along JSON data files.
               Possible values are: `NO_SCHEMA_FILE`, `AVRO_SCHEMA_FILE`.
        """
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if schema_file_format is not None:
            pulumi.set(__self__, "schema_file_format", schema_file_format)

    @property
    @pulumi.getter
    def compression(self) -> Optional[str]:
        """
        Compression of the loaded JSON file.
        Possible values are: `NO_COMPRESSION`, `GZIP`.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="schemaFileFormat")
    def schema_file_format(self) -> Optional[str]:
        """
        The schema file format along JSON data files.
        Possible values are: `NO_SCHEMA_FILE`, `AVRO_SCHEMA_FILE`.
        """
        return pulumi.get(self, "schema_file_format")


@pulumi.output_type
class StreamSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceConnectionProfile":
            suggest = "source_connection_profile"
        elif key == "mysqlSourceConfig":
            suggest = "mysql_source_config"
        elif key == "oracleSourceConfig":
            suggest = "oracle_source_config"
        elif key == "postgresqlSourceConfig":
            suggest = "postgresql_source_config"
        elif key == "sqlServerSourceConfig":
            suggest = "sql_server_source_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_connection_profile: str,
                 mysql_source_config: Optional['outputs.StreamSourceConfigMysqlSourceConfig'] = None,
                 oracle_source_config: Optional['outputs.StreamSourceConfigOracleSourceConfig'] = None,
                 postgresql_source_config: Optional['outputs.StreamSourceConfigPostgresqlSourceConfig'] = None,
                 sql_server_source_config: Optional['outputs.StreamSourceConfigSqlServerSourceConfig'] = None):
        """
        :param str source_connection_profile: Source connection profile resource. Format: projects/{project}/locations/{location}/connectionProfiles/{name}
        :param 'StreamSourceConfigMysqlSourceConfigArgs' mysql_source_config: MySQL data source configuration.
               Structure is documented below.
        :param 'StreamSourceConfigOracleSourceConfigArgs' oracle_source_config: MySQL data source configuration.
               Structure is documented below.
        :param 'StreamSourceConfigPostgresqlSourceConfigArgs' postgresql_source_config: PostgreSQL data source configuration.
               Structure is documented below.
        :param 'StreamSourceConfigSqlServerSourceConfigArgs' sql_server_source_config: SQL Server data source configuration.
               Structure is documented below.
        """
        pulumi.set(__self__, "source_connection_profile", source_connection_profile)
        if mysql_source_config is not None:
            pulumi.set(__self__, "mysql_source_config", mysql_source_config)
        if oracle_source_config is not None:
            pulumi.set(__self__, "oracle_source_config", oracle_source_config)
        if postgresql_source_config is not None:
            pulumi.set(__self__, "postgresql_source_config", postgresql_source_config)
        if sql_server_source_config is not None:
            pulumi.set(__self__, "sql_server_source_config", sql_server_source_config)

    @property
    @pulumi.getter(name="sourceConnectionProfile")
    def source_connection_profile(self) -> str:
        """
        Source connection profile resource. Format: projects/{project}/locations/{location}/connectionProfiles/{name}
        """
        return pulumi.get(self, "source_connection_profile")

    @property
    @pulumi.getter(name="mysqlSourceConfig")
    def mysql_source_config(self) -> Optional['outputs.StreamSourceConfigMysqlSourceConfig']:
        """
        MySQL data source configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_source_config")

    @property
    @pulumi.getter(name="oracleSourceConfig")
    def oracle_source_config(self) -> Optional['outputs.StreamSourceConfigOracleSourceConfig']:
        """
        MySQL data source configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_source_config")

    @property
    @pulumi.getter(name="postgresqlSourceConfig")
    def postgresql_source_config(self) -> Optional['outputs.StreamSourceConfigPostgresqlSourceConfig']:
        """
        PostgreSQL data source configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_source_config")

    @property
    @pulumi.getter(name="sqlServerSourceConfig")
    def sql_server_source_config(self) -> Optional['outputs.StreamSourceConfigSqlServerSourceConfig']:
        """
        SQL Server data source configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "sql_server_source_config")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeObjects":
            suggest = "exclude_objects"
        elif key == "includeObjects":
            suggest = "include_objects"
        elif key == "maxConcurrentBackfillTasks":
            suggest = "max_concurrent_backfill_tasks"
        elif key == "maxConcurrentCdcTasks":
            suggest = "max_concurrent_cdc_tasks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_objects: Optional['outputs.StreamSourceConfigMysqlSourceConfigExcludeObjects'] = None,
                 include_objects: Optional['outputs.StreamSourceConfigMysqlSourceConfigIncludeObjects'] = None,
                 max_concurrent_backfill_tasks: Optional[int] = None,
                 max_concurrent_cdc_tasks: Optional[int] = None):
        """
        :param 'StreamSourceConfigMysqlSourceConfigExcludeObjectsArgs' exclude_objects: MySQL objects to exclude from the stream.
               Structure is documented below.
        :param 'StreamSourceConfigMysqlSourceConfigIncludeObjectsArgs' include_objects: MySQL objects to retrieve from the source.
               Structure is documented below.
        :param int max_concurrent_backfill_tasks: Maximum number of concurrent backfill tasks. The number should be non negative.
               If not set (or set to 0), the system's default value will be used.
        :param int max_concurrent_cdc_tasks: Maximum number of concurrent CDC tasks. The number should be non negative.
               If not set (or set to 0), the system's default value will be used.
        """
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if max_concurrent_backfill_tasks is not None:
            pulumi.set(__self__, "max_concurrent_backfill_tasks", max_concurrent_backfill_tasks)
        if max_concurrent_cdc_tasks is not None:
            pulumi.set(__self__, "max_concurrent_cdc_tasks", max_concurrent_cdc_tasks)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional['outputs.StreamSourceConfigMysqlSourceConfigExcludeObjects']:
        """
        MySQL objects to exclude from the stream.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional['outputs.StreamSourceConfigMysqlSourceConfigIncludeObjects']:
        """
        MySQL objects to retrieve from the source.
        Structure is documented below.
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="maxConcurrentBackfillTasks")
    def max_concurrent_backfill_tasks(self) -> Optional[int]:
        """
        Maximum number of concurrent backfill tasks. The number should be non negative.
        If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_backfill_tasks")

    @property
    @pulumi.getter(name="maxConcurrentCdcTasks")
    def max_concurrent_cdc_tasks(self) -> Optional[int]:
        """
        Maximum number of concurrent CDC tasks. The number should be non negative.
        If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_cdc_tasks")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfigExcludeObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlDatabases":
            suggest = "mysql_databases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfigExcludeObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfigExcludeObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfigExcludeObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mysql_databases: Sequence['outputs.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabase']):
        """
        :param Sequence['StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseArgs'] mysql_databases: MySQL databases on the server
               Structure is documented below.
        """
        pulumi.set(__self__, "mysql_databases", mysql_databases)

    @property
    @pulumi.getter(name="mysqlDatabases")
    def mysql_databases(self) -> Sequence['outputs.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabase']:
        """
        MySQL databases on the server
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_databases")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlTables":
            suggest = "mysql_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 mysql_tables: Optional[Sequence['outputs.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTable']] = None):
        """
        :param str database: Database name.
        :param Sequence['StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableArgs'] mysql_tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "database", database)
        if mysql_tables is not None:
            pulumi.set(__self__, "mysql_tables", mysql_tables)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="mysqlTables")
    def mysql_tables(self) -> Optional[Sequence['outputs.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_tables")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlColumns":
            suggest = "mysql_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 mysql_columns: Optional[Sequence['outputs.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumnArgs'] mysql_columns: MySQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if mysql_columns is not None:
            pulumi.set(__self__, "mysql_columns", mysql_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="mysqlColumns")
    def mysql_columns(self) -> Optional[Sequence['outputs.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumn']]:
        """
        MySQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_columns")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collation: Optional[str] = None,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 primary_key: Optional[bool] = None):
        """
        :param str collation: Column collation.
        :param str column: Column name.
        :param str data_type: The MySQL data type. Full data types list can be found here:
               https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        :param int length: (Output)
               Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param bool primary_key: Whether or not the column represents a primary key.
        """
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        Column collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The MySQL data type. Full data types list can be found here:
        https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfigIncludeObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlDatabases":
            suggest = "mysql_databases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfigIncludeObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfigIncludeObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfigIncludeObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mysql_databases: Sequence['outputs.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabase']):
        """
        :param Sequence['StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseArgs'] mysql_databases: MySQL databases on the server
               Structure is documented below.
        """
        pulumi.set(__self__, "mysql_databases", mysql_databases)

    @property
    @pulumi.getter(name="mysqlDatabases")
    def mysql_databases(self) -> Sequence['outputs.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabase']:
        """
        MySQL databases on the server
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_databases")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlTables":
            suggest = "mysql_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: str,
                 mysql_tables: Optional[Sequence['outputs.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTable']] = None):
        """
        :param str database: Database name.
        :param Sequence['StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableArgs'] mysql_tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "database", database)
        if mysql_tables is not None:
            pulumi.set(__self__, "mysql_tables", mysql_tables)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="mysqlTables")
    def mysql_tables(self) -> Optional[Sequence['outputs.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_tables")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mysqlColumns":
            suggest = "mysql_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 mysql_columns: Optional[Sequence['outputs.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumnArgs'] mysql_columns: MySQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if mysql_columns is not None:
            pulumi.set(__self__, "mysql_columns", mysql_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="mysqlColumns")
    def mysql_columns(self) -> Optional[Sequence['outputs.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumn']]:
        """
        MySQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql_columns")


@pulumi.output_type
class StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collation: Optional[str] = None,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 primary_key: Optional[bool] = None):
        """
        :param str collation: Column collation.
        :param str column: Column name.
        :param str data_type: The MySQL data type. Full data types list can be found here:
               https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        :param int length: (Output)
               Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param bool primary_key: Whether or not the column represents a primary key.
        """
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        Column collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The MySQL data type. Full data types list can be found here:
        https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropLargeObjects":
            suggest = "drop_large_objects"
        elif key == "excludeObjects":
            suggest = "exclude_objects"
        elif key == "includeObjects":
            suggest = "include_objects"
        elif key == "maxConcurrentBackfillTasks":
            suggest = "max_concurrent_backfill_tasks"
        elif key == "maxConcurrentCdcTasks":
            suggest = "max_concurrent_cdc_tasks"
        elif key == "streamLargeObjects":
            suggest = "stream_large_objects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drop_large_objects: Optional['outputs.StreamSourceConfigOracleSourceConfigDropLargeObjects'] = None,
                 exclude_objects: Optional['outputs.StreamSourceConfigOracleSourceConfigExcludeObjects'] = None,
                 include_objects: Optional['outputs.StreamSourceConfigOracleSourceConfigIncludeObjects'] = None,
                 max_concurrent_backfill_tasks: Optional[int] = None,
                 max_concurrent_cdc_tasks: Optional[int] = None,
                 stream_large_objects: Optional['outputs.StreamSourceConfigOracleSourceConfigStreamLargeObjects'] = None):
        """
        :param 'StreamSourceConfigOracleSourceConfigDropLargeObjectsArgs' drop_large_objects: Configuration to drop large object values.
        :param 'StreamSourceConfigOracleSourceConfigExcludeObjectsArgs' exclude_objects: Oracle objects to exclude from the stream.
               Structure is documented below.
        :param 'StreamSourceConfigOracleSourceConfigIncludeObjectsArgs' include_objects: Oracle objects to retrieve from the source.
               Structure is documented below.
        :param int max_concurrent_backfill_tasks: Maximum number of concurrent backfill tasks. The number should be non negative.
               If not set (or set to 0), the system's default value will be used.
        :param int max_concurrent_cdc_tasks: Maximum number of concurrent CDC tasks. The number should be non negative.
               If not set (or set to 0), the system's default value will be used.
        :param 'StreamSourceConfigOracleSourceConfigStreamLargeObjectsArgs' stream_large_objects: Configuration to drop large object values.
        """
        if drop_large_objects is not None:
            pulumi.set(__self__, "drop_large_objects", drop_large_objects)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if max_concurrent_backfill_tasks is not None:
            pulumi.set(__self__, "max_concurrent_backfill_tasks", max_concurrent_backfill_tasks)
        if max_concurrent_cdc_tasks is not None:
            pulumi.set(__self__, "max_concurrent_cdc_tasks", max_concurrent_cdc_tasks)
        if stream_large_objects is not None:
            pulumi.set(__self__, "stream_large_objects", stream_large_objects)

    @property
    @pulumi.getter(name="dropLargeObjects")
    def drop_large_objects(self) -> Optional['outputs.StreamSourceConfigOracleSourceConfigDropLargeObjects']:
        """
        Configuration to drop large object values.
        """
        return pulumi.get(self, "drop_large_objects")

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional['outputs.StreamSourceConfigOracleSourceConfigExcludeObjects']:
        """
        Oracle objects to exclude from the stream.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional['outputs.StreamSourceConfigOracleSourceConfigIncludeObjects']:
        """
        Oracle objects to retrieve from the source.
        Structure is documented below.
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="maxConcurrentBackfillTasks")
    def max_concurrent_backfill_tasks(self) -> Optional[int]:
        """
        Maximum number of concurrent backfill tasks. The number should be non negative.
        If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_backfill_tasks")

    @property
    @pulumi.getter(name="maxConcurrentCdcTasks")
    def max_concurrent_cdc_tasks(self) -> Optional[int]:
        """
        Maximum number of concurrent CDC tasks. The number should be non negative.
        If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_cdc_tasks")

    @property
    @pulumi.getter(name="streamLargeObjects")
    def stream_large_objects(self) -> Optional['outputs.StreamSourceConfigOracleSourceConfigStreamLargeObjects']:
        """
        Configuration to drop large object values.
        """
        return pulumi.get(self, "stream_large_objects")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigDropLargeObjects(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigExcludeObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleSchemas":
            suggest = "oracle_schemas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfigExcludeObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfigExcludeObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfigExcludeObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oracle_schemas: Sequence['outputs.StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchema']):
        """
        :param Sequence['StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaArgs'] oracle_schemas: Oracle schemas/databases in the database server
               Structure is documented below.
        """
        pulumi.set(__self__, "oracle_schemas", oracle_schemas)

    @property
    @pulumi.getter(name="oracleSchemas")
    def oracle_schemas(self) -> Sequence['outputs.StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchema']:
        """
        Oracle schemas/databases in the database server
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_schemas")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleTables":
            suggest = "oracle_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema: str,
                 oracle_tables: Optional[Sequence['outputs.StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTable']] = None):
        """
        :param str schema: Schema name.
        :param Sequence['StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableArgs'] oracle_tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if oracle_tables is not None:
            pulumi.set(__self__, "oracle_tables", oracle_tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="oracleTables")
    def oracle_tables(self) -> Optional[Sequence['outputs.StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_tables")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleColumns":
            suggest = "oracle_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 oracle_columns: Optional[Sequence['outputs.StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableOracleColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableOracleColumnArgs'] oracle_columns: Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if oracle_columns is not None:
            pulumi.set(__self__, "oracle_columns", oracle_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="oracleColumns")
    def oracle_columns(self) -> Optional[Sequence['outputs.StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableOracleColumn']]:
        """
        Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_columns")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableOracleColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableOracleColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableOracleColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfigExcludeObjectsOracleSchemaOracleTableOracleColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 encoding: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The Oracle data type. Full data types list can be found here:
               https://docs.oracle.com/en/database/oracle/oracle-database/21/sqlrf/Data-Types.html
        :param str encoding: (Output)
               Column encoding.
        :param int length: (Output)
               Column length.
        :param bool nullable: (Output)
               Whether or not the column can accept a null value.
        :param int ordinal_position: (Output)
               The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: (Output)
               Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The Oracle data type. Full data types list can be found here:
        https://docs.oracle.com/en/database/oracle/oracle-database/21/sqlrf/Data-Types.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        (Output)
        Column encoding.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        (Output)
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigIncludeObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleSchemas":
            suggest = "oracle_schemas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfigIncludeObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfigIncludeObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfigIncludeObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oracle_schemas: Sequence['outputs.StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchema']):
        """
        :param Sequence['StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaArgs'] oracle_schemas: Oracle schemas/databases in the database server
               Structure is documented below.
        """
        pulumi.set(__self__, "oracle_schemas", oracle_schemas)

    @property
    @pulumi.getter(name="oracleSchemas")
    def oracle_schemas(self) -> Sequence['outputs.StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchema']:
        """
        Oracle schemas/databases in the database server
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_schemas")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleTables":
            suggest = "oracle_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema: str,
                 oracle_tables: Optional[Sequence['outputs.StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTable']] = None):
        """
        :param str schema: Schema name.
        :param Sequence['StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableArgs'] oracle_tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if oracle_tables is not None:
            pulumi.set(__self__, "oracle_tables", oracle_tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="oracleTables")
    def oracle_tables(self) -> Optional[Sequence['outputs.StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_tables")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oracleColumns":
            suggest = "oracle_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 oracle_columns: Optional[Sequence['outputs.StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableOracleColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableOracleColumnArgs'] oracle_columns: Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if oracle_columns is not None:
            pulumi.set(__self__, "oracle_columns", oracle_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="oracleColumns")
    def oracle_columns(self) -> Optional[Sequence['outputs.StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableOracleColumn']]:
        """
        Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle_columns")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableOracleColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableOracleColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableOracleColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigOracleSourceConfigIncludeObjectsOracleSchemaOracleTableOracleColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 encoding: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The Oracle data type. Full data types list can be found here:
               https://docs.oracle.com/en/database/oracle/oracle-database/21/sqlrf/Data-Types.html
        :param str encoding: (Output)
               Column encoding.
        :param int length: (Output)
               Column length.
        :param bool nullable: (Output)
               Whether or not the column can accept a null value.
        :param int ordinal_position: (Output)
               The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: (Output)
               Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The Oracle data type. Full data types list can be found here:
        https://docs.oracle.com/en/database/oracle/oracle-database/21/sqlrf/Data-Types.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        (Output)
        Column encoding.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        (Output)
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamSourceConfigOracleSourceConfigStreamLargeObjects(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationSlot":
            suggest = "replication_slot"
        elif key == "excludeObjects":
            suggest = "exclude_objects"
        elif key == "includeObjects":
            suggest = "include_objects"
        elif key == "maxConcurrentBackfillTasks":
            suggest = "max_concurrent_backfill_tasks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publication: str,
                 replication_slot: str,
                 exclude_objects: Optional['outputs.StreamSourceConfigPostgresqlSourceConfigExcludeObjects'] = None,
                 include_objects: Optional['outputs.StreamSourceConfigPostgresqlSourceConfigIncludeObjects'] = None,
                 max_concurrent_backfill_tasks: Optional[int] = None):
        """
        :param str publication: The name of the publication that includes the set of all tables
               that are defined in the stream's include_objects.
        :param str replication_slot: The name of the logical replication slot that's configured with
               the pgoutput plugin.
        :param 'StreamSourceConfigPostgresqlSourceConfigExcludeObjectsArgs' exclude_objects: PostgreSQL objects to exclude from the stream.
               Structure is documented below.
        :param 'StreamSourceConfigPostgresqlSourceConfigIncludeObjectsArgs' include_objects: PostgreSQL objects to retrieve from the source.
               Structure is documented below.
        :param int max_concurrent_backfill_tasks: Maximum number of concurrent backfill tasks. The number should be non
               negative. If not set (or set to 0), the system's default value will be used.
        """
        pulumi.set(__self__, "publication", publication)
        pulumi.set(__self__, "replication_slot", replication_slot)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if max_concurrent_backfill_tasks is not None:
            pulumi.set(__self__, "max_concurrent_backfill_tasks", max_concurrent_backfill_tasks)

    @property
    @pulumi.getter
    def publication(self) -> str:
        """
        The name of the publication that includes the set of all tables
        that are defined in the stream's include_objects.
        """
        return pulumi.get(self, "publication")

    @property
    @pulumi.getter(name="replicationSlot")
    def replication_slot(self) -> str:
        """
        The name of the logical replication slot that's configured with
        the pgoutput plugin.
        """
        return pulumi.get(self, "replication_slot")

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional['outputs.StreamSourceConfigPostgresqlSourceConfigExcludeObjects']:
        """
        PostgreSQL objects to exclude from the stream.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional['outputs.StreamSourceConfigPostgresqlSourceConfigIncludeObjects']:
        """
        PostgreSQL objects to retrieve from the source.
        Structure is documented below.
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="maxConcurrentBackfillTasks")
    def max_concurrent_backfill_tasks(self) -> Optional[int]:
        """
        Maximum number of concurrent backfill tasks. The number should be non
        negative. If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_backfill_tasks")


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfigExcludeObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlSchemas":
            suggest = "postgresql_schemas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfigExcludeObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfigExcludeObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfigExcludeObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 postgresql_schemas: Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchema']):
        """
        :param Sequence['StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaArgs'] postgresql_schemas: PostgreSQL schemas on the server
               Structure is documented below.
        """
        pulumi.set(__self__, "postgresql_schemas", postgresql_schemas)

    @property
    @pulumi.getter(name="postgresqlSchemas")
    def postgresql_schemas(self) -> Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchema']:
        """
        PostgreSQL schemas on the server
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_schemas")


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlTables":
            suggest = "postgresql_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema: str,
                 postgresql_tables: Optional[Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTable']] = None):
        """
        :param str schema: Database name.
        :param Sequence['StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTableArgs'] postgresql_tables: Tables in the schema.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if postgresql_tables is not None:
            pulumi.set(__self__, "postgresql_tables", postgresql_tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="postgresqlTables")
    def postgresql_tables(self) -> Optional[Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTable']]:
        """
        Tables in the schema.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_tables")


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlColumns":
            suggest = "postgresql_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 postgresql_columns: Optional[Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumnArgs'] postgresql_columns: PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if postgresql_columns is not None:
            pulumi.set(__self__, "postgresql_columns", postgresql_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="postgresqlColumns")
    def postgresql_columns(self) -> Optional[Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn']]:
        """
        PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_columns")


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfigExcludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The PostgreSQL data type. Full data types list can be found here:
               https://www.postgresql.org/docs/current/datatype.html
        :param int length: (Output)
               Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The PostgreSQL data type. Full data types list can be found here:
        https://www.postgresql.org/docs/current/datatype.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfigIncludeObjects(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlSchemas":
            suggest = "postgresql_schemas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfigIncludeObjects. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfigIncludeObjects.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfigIncludeObjects.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 postgresql_schemas: Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchema']):
        """
        :param Sequence['StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaArgs'] postgresql_schemas: PostgreSQL schemas on the server
               Structure is documented below.
        """
        pulumi.set(__self__, "postgresql_schemas", postgresql_schemas)

    @property
    @pulumi.getter(name="postgresqlSchemas")
    def postgresql_schemas(self) -> Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchema']:
        """
        PostgreSQL schemas on the server
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_schemas")


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlTables":
            suggest = "postgresql_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schema: str,
                 postgresql_tables: Optional[Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTable']] = None):
        """
        :param str schema: Database name.
        :param Sequence['StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTableArgs'] postgresql_tables: Tables in the schema.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if postgresql_tables is not None:
            pulumi.set(__self__, "postgresql_tables", postgresql_tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Database name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="postgresqlTables")
    def postgresql_tables(self) -> Optional[Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTable']]:
        """
        Tables in the schema.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_tables")


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postgresqlColumns":
            suggest = "postgresql_columns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table: str,
                 postgresql_columns: Optional[Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumnArgs'] postgresql_columns: PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if postgresql_columns is not None:
            pulumi.set(__self__, "postgresql_columns", postgresql_columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="postgresqlColumns")
    def postgresql_columns(self) -> Optional[Sequence['outputs.StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn']]:
        """
        PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql_columns")


@pulumi.output_type
class StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigPostgresqlSourceConfigIncludeObjectsPostgresqlSchemaPostgresqlTablePostgresqlColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The PostgreSQL data type. Full data types list can be found here:
               https://www.postgresql.org/docs/current/datatype.html
        :param int length: (Output)
               Column length.
        :param bool nullable: Whether or not the column can accept a null value.
        :param int ordinal_position: The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The PostgreSQL data type. Full data types list can be found here:
        https://www.postgresql.org/docs/current/datatype.html
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "changeTables":
            suggest = "change_tables"
        elif key == "excludeObjects":
            suggest = "exclude_objects"
        elif key == "includeObjects":
            suggest = "include_objects"
        elif key == "maxConcurrentBackfillTasks":
            suggest = "max_concurrent_backfill_tasks"
        elif key == "maxConcurrentCdcTasks":
            suggest = "max_concurrent_cdc_tasks"
        elif key == "transactionLogs":
            suggest = "transaction_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigSqlServerSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigSqlServerSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigSqlServerSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 change_tables: Optional['outputs.StreamSourceConfigSqlServerSourceConfigChangeTables'] = None,
                 exclude_objects: Optional['outputs.StreamSourceConfigSqlServerSourceConfigExcludeObjects'] = None,
                 include_objects: Optional['outputs.StreamSourceConfigSqlServerSourceConfigIncludeObjects'] = None,
                 max_concurrent_backfill_tasks: Optional[int] = None,
                 max_concurrent_cdc_tasks: Optional[int] = None,
                 transaction_logs: Optional['outputs.StreamSourceConfigSqlServerSourceConfigTransactionLogs'] = None):
        """
        :param 'StreamSourceConfigSqlServerSourceConfigChangeTablesArgs' change_tables: CDC reader reads from change tables.
        :param 'StreamSourceConfigSqlServerSourceConfigExcludeObjectsArgs' exclude_objects: SQL Server objects to exclude from the stream.
               Structure is documented below.
        :param 'StreamSourceConfigSqlServerSourceConfigIncludeObjectsArgs' include_objects: SQL Server objects to retrieve from the source.
               Structure is documented below.
        :param int max_concurrent_backfill_tasks: Max concurrent backfill tasks.
        :param int max_concurrent_cdc_tasks: Max concurrent CDC tasks.
        :param 'StreamSourceConfigSqlServerSourceConfigTransactionLogsArgs' transaction_logs: CDC reader reads from transaction logs.
        """
        if change_tables is not None:
            pulumi.set(__self__, "change_tables", change_tables)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if max_concurrent_backfill_tasks is not None:
            pulumi.set(__self__, "max_concurrent_backfill_tasks", max_concurrent_backfill_tasks)
        if max_concurrent_cdc_tasks is not None:
            pulumi.set(__self__, "max_concurrent_cdc_tasks", max_concurrent_cdc_tasks)
        if transaction_logs is not None:
            pulumi.set(__self__, "transaction_logs", transaction_logs)

    @property
    @pulumi.getter(name="changeTables")
    def change_tables(self) -> Optional['outputs.StreamSourceConfigSqlServerSourceConfigChangeTables']:
        """
        CDC reader reads from change tables.
        """
        return pulumi.get(self, "change_tables")

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional['outputs.StreamSourceConfigSqlServerSourceConfigExcludeObjects']:
        """
        SQL Server objects to exclude from the stream.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional['outputs.StreamSourceConfigSqlServerSourceConfigIncludeObjects']:
        """
        SQL Server objects to retrieve from the source.
        Structure is documented below.
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="maxConcurrentBackfillTasks")
    def max_concurrent_backfill_tasks(self) -> Optional[int]:
        """
        Max concurrent backfill tasks.
        """
        return pulumi.get(self, "max_concurrent_backfill_tasks")

    @property
    @pulumi.getter(name="maxConcurrentCdcTasks")
    def max_concurrent_cdc_tasks(self) -> Optional[int]:
        """
        Max concurrent CDC tasks.
        """
        return pulumi.get(self, "max_concurrent_cdc_tasks")

    @property
    @pulumi.getter(name="transactionLogs")
    def transaction_logs(self) -> Optional['outputs.StreamSourceConfigSqlServerSourceConfigTransactionLogs']:
        """
        CDC reader reads from transaction logs.
        """
        return pulumi.get(self, "transaction_logs")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigChangeTables(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigExcludeObjects(dict):
    def __init__(__self__, *,
                 schemas: Sequence['outputs.StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchema']):
        """
        :param Sequence['StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaArgs'] schemas: SQL Server schemas/databases in the database server
               Structure is documented below.
        """
        pulumi.set(__self__, "schemas", schemas)

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchema']:
        """
        SQL Server schemas/databases in the database server
        Structure is documented below.
        """
        return pulumi.get(self, "schemas")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchema(dict):
    def __init__(__self__, *,
                 schema: str,
                 tables: Optional[Sequence['outputs.StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTable']] = None):
        """
        :param str schema: Schema name.
        :param Sequence['StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableArgs'] tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tables(self) -> Optional[Sequence['outputs.StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTable(dict):
    def __init__(__self__, *,
                 table: str,
                 columns: Optional[Sequence['outputs.StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableColumnArgs'] columns: SQL Server columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableColumn']]:
        """
        SQL Server columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigSqlServerSourceConfigExcludeObjectsSchemaTableColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The SQL Server data type. Full data types list can be found here:
               https://learn.microsoft.com/en-us/sql/t-sql/data-types/data-types-transact-sql?view=sql-server-ver16
        :param int length: (Output)
               Column length.
        :param bool nullable: (Output)
               Whether or not the column can accept a null value.
        :param int ordinal_position: (Output)
               The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: (Output)
               Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The SQL Server data type. Full data types list can be found here:
        https://learn.microsoft.com/en-us/sql/t-sql/data-types/data-types-transact-sql?view=sql-server-ver16
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        (Output)
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigIncludeObjects(dict):
    def __init__(__self__, *,
                 schemas: Sequence['outputs.StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchema']):
        """
        :param Sequence['StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaArgs'] schemas: SQL Server schemas/databases in the database server
               Structure is documented below.
        """
        pulumi.set(__self__, "schemas", schemas)

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchema']:
        """
        SQL Server schemas/databases in the database server
        Structure is documented below.
        """
        return pulumi.get(self, "schemas")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchema(dict):
    def __init__(__self__, *,
                 schema: str,
                 tables: Optional[Sequence['outputs.StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTable']] = None):
        """
        :param str schema: Schema name.
        :param Sequence['StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableArgs'] tables: Tables in the database.
               Structure is documented below.
        """
        pulumi.set(__self__, "schema", schema)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tables(self) -> Optional[Sequence['outputs.StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTable']]:
        """
        Tables in the database.
        Structure is documented below.
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTable(dict):
    def __init__(__self__, *,
                 table: str,
                 columns: Optional[Sequence['outputs.StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableColumn']] = None):
        """
        :param str table: Table name.
        :param Sequence['StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableColumnArgs'] columns: SQL Server columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
               Structure is documented below.
        """
        pulumi.set(__self__, "table", table)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableColumn']]:
        """
        SQL Server columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        Structure is documented below.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "ordinalPosition":
            suggest = "ordinal_position"
        elif key == "primaryKey":
            suggest = "primary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamSourceConfigSqlServerSourceConfigIncludeObjectsSchemaTableColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column: Optional[str] = None,
                 data_type: Optional[str] = None,
                 length: Optional[int] = None,
                 nullable: Optional[bool] = None,
                 ordinal_position: Optional[int] = None,
                 precision: Optional[int] = None,
                 primary_key: Optional[bool] = None,
                 scale: Optional[int] = None):
        """
        :param str column: Column name.
        :param str data_type: The SQL Server data type. Full data types list can be found here:
               https://learn.microsoft.com/en-us/sql/t-sql/data-types/data-types-transact-sql?view=sql-server-ver16
        :param int length: (Output)
               Column length.
        :param bool nullable: (Output)
               Whether or not the column can accept a null value.
        :param int ordinal_position: (Output)
               The ordinal position of the column in the table.
        :param int precision: (Output)
               Column precision.
        :param bool primary_key: (Output)
               Whether or not the column represents a primary key.
        :param int scale: (Output)
               Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The SQL Server data type. Full data types list can be found here:
        https://learn.microsoft.com/en-us/sql/t-sql/data-types/data-types-transact-sql?view=sql-server-ver16
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def length(self) -> Optional[int]:
        """
        (Output)
        Column length.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[int]:
        """
        (Output)
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        (Output)
        Column precision.
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[bool]:
        """
        (Output)
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def scale(self) -> Optional[int]:
        """
        (Output)
        Column scale.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class StreamSourceConfigSqlServerSourceConfigTransactionLogs(dict):
    def __init__(__self__):
        pass


