# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectionGithubConfigArgs',
    'ConnectionGithubConfigArgsDict',
    'ConnectionGithubConfigAuthorizerCredentialArgs',
    'ConnectionGithubConfigAuthorizerCredentialArgsDict',
    'ConnectionInstallationStateArgs',
    'ConnectionInstallationStateArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectionGithubConfigArgsDict(TypedDict):
        github_app: pulumi.Input[str]
        """
        Required. Immutable. The GitHub Application that was installed to
        the GitHub user or organization.
        Possible values:
        GIT_HUB_APP_UNSPECIFIED
        DEVELOPER_CONNECT
        FIREBASE"
        """
        app_installation_id: NotRequired[pulumi.Input[str]]
        """
        Optional. GitHub App installation id.
        """
        authorizer_credential: NotRequired[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgsDict']]
        """
        Represents an OAuth token of the account that authorized the Connection,and
        associated metadata.
        Structure is documented below.
        """
        installation_uri: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The URI to navigate to in order to manage the installation
        associated with this GitHubConfig.
        """
elif False:
    ConnectionGithubConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGithubConfigArgs:
    def __init__(__self__, *,
                 github_app: pulumi.Input[str],
                 app_installation_id: Optional[pulumi.Input[str]] = None,
                 authorizer_credential: Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']] = None,
                 installation_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] github_app: Required. Immutable. The GitHub Application that was installed to
               the GitHub user or organization.
               Possible values:
               GIT_HUB_APP_UNSPECIFIED
               DEVELOPER_CONNECT
               FIREBASE"
        :param pulumi.Input[str] app_installation_id: Optional. GitHub App installation id.
        :param pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs'] authorizer_credential: Represents an OAuth token of the account that authorized the Connection,and
               associated metadata.
               Structure is documented below.
        :param pulumi.Input[str] installation_uri: (Output)
               Output only. The URI to navigate to in order to manage the installation
               associated with this GitHubConfig.
        """
        pulumi.set(__self__, "github_app", github_app)
        if app_installation_id is not None:
            pulumi.set(__self__, "app_installation_id", app_installation_id)
        if authorizer_credential is not None:
            pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        if installation_uri is not None:
            pulumi.set(__self__, "installation_uri", installation_uri)

    @property
    @pulumi.getter(name="githubApp")
    def github_app(self) -> pulumi.Input[str]:
        """
        Required. Immutable. The GitHub Application that was installed to
        the GitHub user or organization.
        Possible values:
        GIT_HUB_APP_UNSPECIFIED
        DEVELOPER_CONNECT
        FIREBASE"
        """
        return pulumi.get(self, "github_app")

    @github_app.setter
    def github_app(self, value: pulumi.Input[str]):
        pulumi.set(self, "github_app", value)

    @property
    @pulumi.getter(name="appInstallationId")
    def app_installation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. GitHub App installation id.
        """
        return pulumi.get(self, "app_installation_id")

    @app_installation_id.setter
    def app_installation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_installation_id", value)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']]:
        """
        Represents an OAuth token of the account that authorized the Connection,and
        associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @authorizer_credential.setter
    def authorizer_credential(self, value: Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']]):
        pulumi.set(self, "authorizer_credential", value)

    @property
    @pulumi.getter(name="installationUri")
    def installation_uri(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The URI to navigate to in order to manage the installation
        associated with this GitHubConfig.
        """
        return pulumi.get(self, "installation_uri")

    @installation_uri.setter
    def installation_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "installation_uri", value)


if not MYPY:
    class ConnectionGithubConfigAuthorizerCredentialArgsDict(TypedDict):
        oauth_token_secret_version: pulumi.Input[str]
        """
        Required. A SecretManager resource containing the OAuth token
        that authorizes the connection.
        Format: `projects/*/secrets/*/versions/*`.
        """
        username: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. The username associated with this token.
        """
elif False:
    ConnectionGithubConfigAuthorizerCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGithubConfigAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 oauth_token_secret_version: pulumi.Input[str],
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] oauth_token_secret_version: Required. A SecretManager resource containing the OAuth token
               that authorizes the connection.
               Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[str] username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "oauth_token_secret_version", oauth_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="oauthTokenSecretVersion")
    def oauth_token_secret_version(self) -> pulumi.Input[str]:
        """
        Required. A SecretManager resource containing the OAuth token
        that authorizes the connection.
        Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "oauth_token_secret_version")

    @oauth_token_secret_version.setter
    def oauth_token_secret_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "oauth_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionInstallationStateArgsDict(TypedDict):
        action_uri: NotRequired[pulumi.Input[str]]
        """
        Output only. Link to follow for next action. Empty string if the
        installation is already complete.
        """
        message: NotRequired[pulumi.Input[str]]
        """
        Output only. Message of what the user should do next to continue
        the installation.Empty string if the installation is already complete.
        """
        stage: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Output only. Current step of the installation process.
        Possible values:
        STAGE_UNSPECIFIED
        PENDING_CREATE_APP
        PENDING_USER_OAUTH
        PENDING_INSTALL_APP
        COMPLETE
        """
elif False:
    ConnectionInstallationStateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionInstallationStateArgs:
    def __init__(__self__, *,
                 action_uri: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 stage: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action_uri: Output only. Link to follow for next action. Empty string if the
               installation is already complete.
        :param pulumi.Input[str] message: Output only. Message of what the user should do next to continue
               the installation.Empty string if the installation is already complete.
        :param pulumi.Input[str] stage: (Output)
               Output only. Current step of the installation process.
               Possible values:
               STAGE_UNSPECIFIED
               PENDING_CREATE_APP
               PENDING_USER_OAUTH
               PENDING_INSTALL_APP
               COMPLETE
        """
        if action_uri is not None:
            pulumi.set(__self__, "action_uri", action_uri)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="actionUri")
    def action_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Link to follow for next action. Empty string if the
        installation is already complete.
        """
        return pulumi.get(self, "action_uri")

    @action_uri.setter
    def action_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_uri", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Message of what the user should do next to continue
        the installation.Empty string if the installation is already complete.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def stage(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Output only. Current step of the installation process.
        Possible values:
        STAGE_UNSPECIFIED
        PENDING_CREATE_APP
        PENDING_USER_OAUTH
        PENDING_INSTALL_APP
        COMPLETE
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stage", value)


