# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionGithubConfig',
    'ConnectionGithubConfigAuthorizerCredential',
    'ConnectionInstallationState',
]

@pulumi.output_type
class ConnectionGithubConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "githubApp":
            suggest = "github_app"
        elif key == "appInstallationId":
            suggest = "app_installation_id"
        elif key == "authorizerCredential":
            suggest = "authorizer_credential"
        elif key == "installationUri":
            suggest = "installation_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGithubConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGithubConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGithubConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 github_app: str,
                 app_installation_id: Optional[str] = None,
                 authorizer_credential: Optional['outputs.ConnectionGithubConfigAuthorizerCredential'] = None,
                 installation_uri: Optional[str] = None):
        """
        :param str github_app: Required. Immutable. The GitHub Application that was installed to
               the GitHub user or organization.
               Possible values:
               GIT_HUB_APP_UNSPECIFIED
               DEVELOPER_CONNECT
               FIREBASE"
        :param str app_installation_id: Optional. GitHub App installation id.
        :param 'ConnectionGithubConfigAuthorizerCredentialArgs' authorizer_credential: Represents an OAuth token of the account that authorized the Connection,and
               associated metadata.
               Structure is documented below.
        :param str installation_uri: (Output)
               Output only. The URI to navigate to in order to manage the installation
               associated with this GitHubConfig.
        """
        pulumi.set(__self__, "github_app", github_app)
        if app_installation_id is not None:
            pulumi.set(__self__, "app_installation_id", app_installation_id)
        if authorizer_credential is not None:
            pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        if installation_uri is not None:
            pulumi.set(__self__, "installation_uri", installation_uri)

    @property
    @pulumi.getter(name="githubApp")
    def github_app(self) -> str:
        """
        Required. Immutable. The GitHub Application that was installed to
        the GitHub user or organization.
        Possible values:
        GIT_HUB_APP_UNSPECIFIED
        DEVELOPER_CONNECT
        FIREBASE"
        """
        return pulumi.get(self, "github_app")

    @property
    @pulumi.getter(name="appInstallationId")
    def app_installation_id(self) -> Optional[str]:
        """
        Optional. GitHub App installation id.
        """
        return pulumi.get(self, "app_installation_id")

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> Optional['outputs.ConnectionGithubConfigAuthorizerCredential']:
        """
        Represents an OAuth token of the account that authorized the Connection,and
        associated metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @property
    @pulumi.getter(name="installationUri")
    def installation_uri(self) -> Optional[str]:
        """
        (Output)
        Output only. The URI to navigate to in order to manage the installation
        associated with this GitHubConfig.
        """
        return pulumi.get(self, "installation_uri")


@pulumi.output_type
class ConnectionGithubConfigAuthorizerCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oauthTokenSecretVersion":
            suggest = "oauth_token_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionGithubConfigAuthorizerCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionGithubConfigAuthorizerCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionGithubConfigAuthorizerCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oauth_token_secret_version: str,
                 username: Optional[str] = None):
        """
        :param str oauth_token_secret_version: Required. A SecretManager resource containing the OAuth token
               that authorizes the connection.
               Format: `projects/*/secrets/*/versions/*`.
        :param str username: (Output)
               Output only. The username associated with this token.
        """
        pulumi.set(__self__, "oauth_token_secret_version", oauth_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="oauthTokenSecretVersion")
    def oauth_token_secret_version(self) -> str:
        """
        Required. A SecretManager resource containing the OAuth token
        that authorizes the connection.
        Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "oauth_token_secret_version")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        (Output)
        Output only. The username associated with this token.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionInstallationState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionUri":
            suggest = "action_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionInstallationState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionInstallationState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionInstallationState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_uri: Optional[str] = None,
                 message: Optional[str] = None,
                 stage: Optional[str] = None):
        """
        :param str action_uri: Output only. Link to follow for next action. Empty string if the
               installation is already complete.
        :param str message: Output only. Message of what the user should do next to continue
               the installation.Empty string if the installation is already complete.
        :param str stage: (Output)
               Output only. Current step of the installation process.
               Possible values:
               STAGE_UNSPECIFIED
               PENDING_CREATE_APP
               PENDING_USER_OAUTH
               PENDING_INSTALL_APP
               COMPLETE
        """
        if action_uri is not None:
            pulumi.set(__self__, "action_uri", action_uri)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="actionUri")
    def action_uri(self) -> Optional[str]:
        """
        Output only. Link to follow for next action. Empty string if the
        installation is already complete.
        """
        return pulumi.get(self, "action_uri")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Output only. Message of what the user should do next to continue
        the installation.Empty string if the installation is already complete.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def stage(self) -> Optional[str]:
        """
        (Output)
        Output only. Current step of the installation process.
        Possible values:
        STAGE_UNSPECIFIED
        PENDING_CREATE_APP
        PENDING_USER_OAUTH
        PENDING_INSTALL_APP
        COMPLETE
        """
        return pulumi.get(self, "stage")


