# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxAgentArgs', 'CxAgent']

@pulumi.input_type
class CxAgentArgs:
    def __init__(__self__, *,
                 default_language_code: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 location: pulumi.Input[str],
                 time_zone: pulumi.Input[str],
                 advanced_settings: Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']] = None,
                 avatar_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None,
                 git_integration_settings: Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']] = None,
                 supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_to_speech_settings: Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']] = None):
        """
        The set of arguments for constructing a CxAgent resource.
        :param pulumi.Input[str] default_language_code: The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
               for a list of the currently supported language codes. This field cannot be updated after creation.
        :param pulumi.Input[str] display_name: The human-readable name of the agent, unique within the location.
        :param pulumi.Input[str] location: The name of the location this agent is located in.
               > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
               This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
               Another options is to use global location so you don't need to manually configure location settings.
        :param pulumi.Input[str] time_zone: The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
               Europe/Paris.
               
               
               - - -
        :param pulumi.Input['CxAgentAdvancedSettingsArgs'] advanced_settings: Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        :param pulumi.Input[str] description: The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[bool] enable_stackdriver_logging: Determines whether this agent should log conversation queries.
        :param pulumi.Input['CxAgentGitIntegrationSettingsArgs'] git_integration_settings: Git integration settings for this agent.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] security_settings: Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input['CxAgentSpeechToTextSettingsArgs'] speech_to_text_settings: Settings related to speech recognition.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_language_codes: The list of all languages supported by this agent (except for the default_language_code).
        :param pulumi.Input['CxAgentTextToSpeechSettingsArgs'] text_to_speech_settings: Settings related to speech synthesizing.
               Structure is documented below.
        """
        pulumi.set(__self__, "default_language_code", default_language_code)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "time_zone", time_zone)
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if avatar_uri is not None:
            pulumi.set(__self__, "avatar_uri", avatar_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_spell_correction is not None:
            pulumi.set(__self__, "enable_spell_correction", enable_spell_correction)
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)
        if git_integration_settings is not None:
            pulumi.set(__self__, "git_integration_settings", git_integration_settings)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if speech_to_text_settings is not None:
            pulumi.set(__self__, "speech_to_text_settings", speech_to_text_settings)
        if supported_language_codes is not None:
            pulumi.set(__self__, "supported_language_codes", supported_language_codes)
        if text_to_speech_settings is not None:
            pulumi.set(__self__, "text_to_speech_settings", text_to_speech_settings)

    @property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> pulumi.Input[str]:
        """
        The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
        for a list of the currently supported language codes. This field cannot be updated after creation.
        """
        return pulumi.get(self, "default_language_code")

    @default_language_code.setter
    def default_language_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_language_code", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The human-readable name of the agent, unique within the location.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The name of the location this agent is located in.
        > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
        This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
        Another options is to use global location so you don't need to manually configure location settings.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[str]:
        """
        The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
        Europe/Paris.


        - - -
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']]:
        """
        Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']]):
        pulumi.set(self, "advanced_settings", value)

    @property
    @pulumi.getter(name="avatarUri")
    def avatar_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        """
        return pulumi.get(self, "avatar_uri")

    @avatar_uri.setter
    def avatar_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @enable_spell_correction.setter
    def enable_spell_correction(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_spell_correction", value)

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether this agent should log conversation queries.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)

    @property
    @pulumi.getter(name="gitIntegrationSettings")
    def git_integration_settings(self) -> Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']]:
        """
        Git integration settings for this agent.
        Structure is documented below.
        """
        return pulumi.get(self, "git_integration_settings")

    @git_integration_settings.setter
    def git_integration_settings(self, value: Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']]):
        pulumi.set(self, "git_integration_settings", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_settings", value)

    @property
    @pulumi.getter(name="speechToTextSettings")
    def speech_to_text_settings(self) -> Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']]:
        """
        Settings related to speech recognition.
        Structure is documented below.
        """
        return pulumi.get(self, "speech_to_text_settings")

    @speech_to_text_settings.setter
    def speech_to_text_settings(self, value: Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']]):
        pulumi.set(self, "speech_to_text_settings", value)

    @property
    @pulumi.getter(name="supportedLanguageCodes")
    def supported_language_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of all languages supported by this agent (except for the default_language_code).
        """
        return pulumi.get(self, "supported_language_codes")

    @supported_language_codes.setter
    def supported_language_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "supported_language_codes", value)

    @property
    @pulumi.getter(name="textToSpeechSettings")
    def text_to_speech_settings(self) -> Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']]:
        """
        Settings related to speech synthesizing.
        Structure is documented below.
        """
        return pulumi.get(self, "text_to_speech_settings")

    @text_to_speech_settings.setter
    def text_to_speech_settings(self, value: Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']]):
        pulumi.set(self, "text_to_speech_settings", value)


@pulumi.input_type
class _CxAgentState:
    def __init__(__self__, *,
                 advanced_settings: Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']] = None,
                 avatar_uri: Optional[pulumi.Input[str]] = None,
                 default_language_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None,
                 git_integration_settings: Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']] = None,
                 start_flow: Optional[pulumi.Input[str]] = None,
                 supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_to_speech_settings: Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CxAgent resources.
        :param pulumi.Input['CxAgentAdvancedSettingsArgs'] advanced_settings: Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        :param pulumi.Input[str] default_language_code: The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
               for a list of the currently supported language codes. This field cannot be updated after creation.
        :param pulumi.Input[str] description: The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[str] display_name: The human-readable name of the agent, unique within the location.
        :param pulumi.Input[bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[bool] enable_stackdriver_logging: Determines whether this agent should log conversation queries.
        :param pulumi.Input['CxAgentGitIntegrationSettingsArgs'] git_integration_settings: Git integration settings for this agent.
               Structure is documented below.
        :param pulumi.Input[str] location: The name of the location this agent is located in.
               > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
               This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
               Another options is to use global location so you don't need to manually configure location settings.
        :param pulumi.Input[str] name: The unique identifier of the agent.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] security_settings: Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input['CxAgentSpeechToTextSettingsArgs'] speech_to_text_settings: Settings related to speech recognition.
               Structure is documented below.
        :param pulumi.Input[str] start_flow: Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_language_codes: The list of all languages supported by this agent (except for the default_language_code).
        :param pulumi.Input['CxAgentTextToSpeechSettingsArgs'] text_to_speech_settings: Settings related to speech synthesizing.
               Structure is documented below.
        :param pulumi.Input[str] time_zone: The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
               Europe/Paris.
               
               
               - - -
        """
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if avatar_uri is not None:
            pulumi.set(__self__, "avatar_uri", avatar_uri)
        if default_language_code is not None:
            pulumi.set(__self__, "default_language_code", default_language_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_spell_correction is not None:
            pulumi.set(__self__, "enable_spell_correction", enable_spell_correction)
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)
        if git_integration_settings is not None:
            pulumi.set(__self__, "git_integration_settings", git_integration_settings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if speech_to_text_settings is not None:
            pulumi.set(__self__, "speech_to_text_settings", speech_to_text_settings)
        if start_flow is not None:
            pulumi.set(__self__, "start_flow", start_flow)
        if supported_language_codes is not None:
            pulumi.set(__self__, "supported_language_codes", supported_language_codes)
        if text_to_speech_settings is not None:
            pulumi.set(__self__, "text_to_speech_settings", text_to_speech_settings)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']]:
        """
        Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']]):
        pulumi.set(self, "advanced_settings", value)

    @property
    @pulumi.getter(name="avatarUri")
    def avatar_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        """
        return pulumi.get(self, "avatar_uri")

    @avatar_uri.setter
    def avatar_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_uri", value)

    @property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> Optional[pulumi.Input[str]]:
        """
        The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
        for a list of the currently supported language codes. This field cannot be updated after creation.
        """
        return pulumi.get(self, "default_language_code")

    @default_language_code.setter
    def default_language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_language_code", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of the agent, unique within the location.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @enable_spell_correction.setter
    def enable_spell_correction(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_spell_correction", value)

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether this agent should log conversation queries.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)

    @property
    @pulumi.getter(name="gitIntegrationSettings")
    def git_integration_settings(self) -> Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']]:
        """
        Git integration settings for this agent.
        Structure is documented below.
        """
        return pulumi.get(self, "git_integration_settings")

    @git_integration_settings.setter
    def git_integration_settings(self, value: Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']]):
        pulumi.set(self, "git_integration_settings", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the location this agent is located in.
        > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
        This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
        Another options is to use global location so you don't need to manually configure location settings.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_settings", value)

    @property
    @pulumi.getter(name="speechToTextSettings")
    def speech_to_text_settings(self) -> Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']]:
        """
        Settings related to speech recognition.
        Structure is documented below.
        """
        return pulumi.get(self, "speech_to_text_settings")

    @speech_to_text_settings.setter
    def speech_to_text_settings(self, value: Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']]):
        pulumi.set(self, "speech_to_text_settings", value)

    @property
    @pulumi.getter(name="startFlow")
    def start_flow(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "start_flow")

    @start_flow.setter
    def start_flow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_flow", value)

    @property
    @pulumi.getter(name="supportedLanguageCodes")
    def supported_language_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of all languages supported by this agent (except for the default_language_code).
        """
        return pulumi.get(self, "supported_language_codes")

    @supported_language_codes.setter
    def supported_language_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "supported_language_codes", value)

    @property
    @pulumi.getter(name="textToSpeechSettings")
    def text_to_speech_settings(self) -> Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']]:
        """
        Settings related to speech synthesizing.
        Structure is documented below.
        """
        return pulumi.get(self, "text_to_speech_settings")

    @text_to_speech_settings.setter
    def text_to_speech_settings(self, value: Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']]):
        pulumi.set(self, "text_to_speech_settings", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
        Europe/Paris.


        - - -
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class CxAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_settings: Optional[pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']]] = None,
                 avatar_uri: Optional[pulumi.Input[str]] = None,
                 default_language_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None,
                 git_integration_settings: Optional[pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']]] = None,
                 supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_to_speech_settings: Optional[pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Agents are best described as Natural Language Understanding (NLU) modules that transform user requests into actionable data. You can include agents in your app, product, or service to determine user intent and respond to the user in a natural way.

        To get more information about Agent, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Agent Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        full_agent = gcp.diagflow.CxAgent("full_agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            },
            advanced_settings={
                "audio_export_gcs_destination": {
                    "uri": bucket.url.apply(lambda url: f"{url}/prefix-"),
                },
                "dtmf_settings": {
                    "enabled": True,
                    "max_digits": 1,
                    "finish_digit": "#",
                },
            },
            git_integration_settings={
                "github_settings": {
                    "display_name": "Github Repo",
                    "repository_uri": "https://api.github.com/repos/githubtraining/hellogitworld",
                    "tracking_branch": "main",
                    "access_token": "secret-token",
                    "branches": ["main"],
                },
            },
            text_to_speech_settings={
                "synthesize_speech_configs": json.dumps({
                    "en": {
                        "voice": {
                            "name": "en-US-Neural2-A",
                        },
                    },
                    "fr": {
                        "voice": {
                            "name": "fr-CA-Neural2-A",
                        },
                    },
                }),
            })
        ```

        ## Import

        Agent can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/agents/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Agent can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default projects/{{project}}/locations/{{location}}/agents/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']] advanced_settings: Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        :param pulumi.Input[str] default_language_code: The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
               for a list of the currently supported language codes. This field cannot be updated after creation.
        :param pulumi.Input[str] description: The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[str] display_name: The human-readable name of the agent, unique within the location.
        :param pulumi.Input[bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[bool] enable_stackdriver_logging: Determines whether this agent should log conversation queries.
        :param pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']] git_integration_settings: Git integration settings for this agent.
               Structure is documented below.
        :param pulumi.Input[str] location: The name of the location this agent is located in.
               > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
               This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
               Another options is to use global location so you don't need to manually configure location settings.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] security_settings: Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']] speech_to_text_settings: Settings related to speech recognition.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_language_codes: The list of all languages supported by this agent (except for the default_language_code).
        :param pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']] text_to_speech_settings: Settings related to speech synthesizing.
               Structure is documented below.
        :param pulumi.Input[str] time_zone: The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
               Europe/Paris.
               
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Agents are best described as Natural Language Understanding (NLU) modules that transform user requests into actionable data. You can include agents in your app, product, or service to determine user intent and respond to the user in a natural way.

        To get more information about Agent, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Agent Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        full_agent = gcp.diagflow.CxAgent("full_agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            },
            advanced_settings={
                "audio_export_gcs_destination": {
                    "uri": bucket.url.apply(lambda url: f"{url}/prefix-"),
                },
                "dtmf_settings": {
                    "enabled": True,
                    "max_digits": 1,
                    "finish_digit": "#",
                },
            },
            git_integration_settings={
                "github_settings": {
                    "display_name": "Github Repo",
                    "repository_uri": "https://api.github.com/repos/githubtraining/hellogitworld",
                    "tracking_branch": "main",
                    "access_token": "secret-token",
                    "branches": ["main"],
                },
            },
            text_to_speech_settings={
                "synthesize_speech_configs": json.dumps({
                    "en": {
                        "voice": {
                            "name": "en-US-Neural2-A",
                        },
                    },
                    "fr": {
                        "voice": {
                            "name": "fr-CA-Neural2-A",
                        },
                    },
                }),
            })
        ```

        ## Import

        Agent can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/agents/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Agent can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default projects/{{project}}/locations/{{location}}/agents/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_settings: Optional[pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']]] = None,
                 avatar_uri: Optional[pulumi.Input[str]] = None,
                 default_language_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None,
                 git_integration_settings: Optional[pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']]] = None,
                 supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 text_to_speech_settings: Optional[pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxAgentArgs.__new__(CxAgentArgs)

            __props__.__dict__["advanced_settings"] = advanced_settings
            __props__.__dict__["avatar_uri"] = avatar_uri
            if default_language_code is None and not opts.urn:
                raise TypeError("Missing required property 'default_language_code'")
            __props__.__dict__["default_language_code"] = default_language_code
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_spell_correction"] = enable_spell_correction
            __props__.__dict__["enable_stackdriver_logging"] = enable_stackdriver_logging
            __props__.__dict__["git_integration_settings"] = git_integration_settings
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["security_settings"] = security_settings
            __props__.__dict__["speech_to_text_settings"] = speech_to_text_settings
            __props__.__dict__["supported_language_codes"] = supported_language_codes
            __props__.__dict__["text_to_speech_settings"] = text_to_speech_settings
            if time_zone is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone'")
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["name"] = None
            __props__.__dict__["start_flow"] = None
        super(CxAgent, __self__).__init__(
            'gcp:diagflow/cxAgent:CxAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_settings: Optional[pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']]] = None,
            avatar_uri: Optional[pulumi.Input[str]] = None,
            default_language_code: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enable_spell_correction: Optional[pulumi.Input[bool]] = None,
            enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None,
            git_integration_settings: Optional[pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            security_settings: Optional[pulumi.Input[str]] = None,
            speech_to_text_settings: Optional[pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']]] = None,
            start_flow: Optional[pulumi.Input[str]] = None,
            supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            text_to_speech_settings: Optional[pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']]] = None,
            time_zone: Optional[pulumi.Input[str]] = None) -> 'CxAgent':
        """
        Get an existing CxAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']] advanced_settings: Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        :param pulumi.Input[str] default_language_code: The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
               for a list of the currently supported language codes. This field cannot be updated after creation.
        :param pulumi.Input[str] description: The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[str] display_name: The human-readable name of the agent, unique within the location.
        :param pulumi.Input[bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[bool] enable_stackdriver_logging: Determines whether this agent should log conversation queries.
        :param pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']] git_integration_settings: Git integration settings for this agent.
               Structure is documented below.
        :param pulumi.Input[str] location: The name of the location this agent is located in.
               > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
               This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
               Another options is to use global location so you don't need to manually configure location settings.
        :param pulumi.Input[str] name: The unique identifier of the agent.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] security_settings: Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']] speech_to_text_settings: Settings related to speech recognition.
               Structure is documented below.
        :param pulumi.Input[str] start_flow: Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_language_codes: The list of all languages supported by this agent (except for the default_language_code).
        :param pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']] text_to_speech_settings: Settings related to speech synthesizing.
               Structure is documented below.
        :param pulumi.Input[str] time_zone: The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
               Europe/Paris.
               
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxAgentState.__new__(_CxAgentState)

        __props__.__dict__["advanced_settings"] = advanced_settings
        __props__.__dict__["avatar_uri"] = avatar_uri
        __props__.__dict__["default_language_code"] = default_language_code
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_spell_correction"] = enable_spell_correction
        __props__.__dict__["enable_stackdriver_logging"] = enable_stackdriver_logging
        __props__.__dict__["git_integration_settings"] = git_integration_settings
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["security_settings"] = security_settings
        __props__.__dict__["speech_to_text_settings"] = speech_to_text_settings
        __props__.__dict__["start_flow"] = start_flow
        __props__.__dict__["supported_language_codes"] = supported_language_codes
        __props__.__dict__["text_to_speech_settings"] = text_to_speech_settings
        __props__.__dict__["time_zone"] = time_zone
        return CxAgent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> pulumi.Output['outputs.CxAgentAdvancedSettings']:
        """
        Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @property
    @pulumi.getter(name="avatarUri")
    def avatar_uri(self) -> pulumi.Output[Optional[str]]:
        """
        The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        """
        return pulumi.get(self, "avatar_uri")

    @property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> pulumi.Output[str]:
        """
        The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
        for a list of the currently supported language codes. This field cannot be updated after creation.
        """
        return pulumi.get(self, "default_language_code")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The human-readable name of the agent, unique within the location.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether this agent should log conversation queries.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @property
    @pulumi.getter(name="gitIntegrationSettings")
    def git_integration_settings(self) -> pulumi.Output[Optional['outputs.CxAgentGitIntegrationSettings']]:
        """
        Git integration settings for this agent.
        Structure is documented below.
        """
        return pulumi.get(self, "git_integration_settings")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The name of the location this agent is located in.
        > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
        This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
        Another options is to use global location so you don't need to manually configure location settings.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique identifier of the agent.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="speechToTextSettings")
    def speech_to_text_settings(self) -> pulumi.Output[Optional['outputs.CxAgentSpeechToTextSettings']]:
        """
        Settings related to speech recognition.
        Structure is documented below.
        """
        return pulumi.get(self, "speech_to_text_settings")

    @property
    @pulumi.getter(name="startFlow")
    def start_flow(self) -> pulumi.Output[str]:
        """
        Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "start_flow")

    @property
    @pulumi.getter(name="supportedLanguageCodes")
    def supported_language_codes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of all languages supported by this agent (except for the default_language_code).
        """
        return pulumi.get(self, "supported_language_codes")

    @property
    @pulumi.getter(name="textToSpeechSettings")
    def text_to_speech_settings(self) -> pulumi.Output[Optional['outputs.CxAgentTextToSpeechSettings']]:
        """
        Settings related to speech synthesizing.
        Structure is documented below.
        """
        return pulumi.get(self, "text_to_speech_settings")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
        Europe/Paris.


        - - -
        """
        return pulumi.get(self, "time_zone")

