# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxFlowArgs', 'CxFlow']

@pulumi.input_type
class CxFlowArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 advanced_settings: Optional[pulumi.Input['CxFlowAdvancedSettingsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowEventHandlerArgs']]]] = None,
                 is_default_start_flow: Optional[pulumi.Input[bool]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 nlu_settings: Optional[pulumi.Input['CxFlowNluSettingsArgs']] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowTransitionRouteArgs']]]] = None):
        """
        The set of arguments for constructing a CxFlow resource.
        :param pulumi.Input[str] display_name: The human-readable name of the flow.
               
               
               - - -
        :param pulumi.Input['CxFlowAdvancedSettingsArgs'] advanced_settings: Hierarchical advanced settings for this flow. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[str] description: The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[Sequence[pulumi.Input['CxFlowEventHandlerArgs']]] event_handlers: A flow's event handlers serve two purposes:
               They are responsible for handling events (e.g. no match, webhook errors) in the flow.
               They are inherited by every page's [event handlers][Page.event_handlers], which can be used to handle common events regardless of the current page. Event handlers defined in the page have higher priority than those defined in the flow.
               Unlike transitionRoutes, these handlers are evaluated on a first-match basis. The first one that matches the event get executed, with the rest being ignored.
               Structure is documented below.
        :param pulumi.Input[bool] is_default_start_flow: Marks this as the [Default Start Flow](https://cloud.google.com/dialogflow/cx/docs/concept/flow#start) for an agent. When you create an agent, the Default Start Flow is created automatically.
               The Default Start Flow cannot be deleted; deleting the `diagflow.CxFlow` resource does nothing to the underlying GCP resources.
               
               > Avoid having multiple `diagflow.CxFlow` resources linked to the same agent with `is_default_start_flow = true` because they will compete to control a single Default Start Flow resource in GCP.
        :param pulumi.Input[str] language_code: The language of the following fields in flow:
               Flow.event_handlers.trigger_fulfillment.messages
               Flow.event_handlers.trigger_fulfillment.conditional_cases
               Flow.transition_routes.trigger_fulfillment.messages
               Flow.transition_routes.trigger_fulfillment.conditional_cases
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input['CxFlowNluSettingsArgs'] nlu_settings: NLU related settings of the flow.
               Structure is documented below.
        :param pulumi.Input[str] parent: The agent to create a flow for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transition_route_groups: A flow's transition route group serve two purposes:
               They are responsible for matching the user's first utterances in the flow.
               They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
               Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        :param pulumi.Input[Sequence[pulumi.Input['CxFlowTransitionRouteArgs']]] transition_routes: A flow's transition routes serve two purposes:
               They are responsible for matching the user's first utterances in the flow.
               They are inherited by every page's [transition routes][Page.transition_routes] and can support use cases such as the user saying "help" or "can I talk to a human?", which can be handled in a common way regardless of the current page. Transition routes defined in the page have higher priority than those defined in the flow.
               TransitionRoutes are evalauted in the following order:
               TransitionRoutes with intent specified.
               TransitionRoutes with only condition specified.
               TransitionRoutes with intent specified are inherited by pages in the flow.
               Structure is documented below.
        """
        pulumi.set(__self__, "display_name", display_name)
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_handlers is not None:
            pulumi.set(__self__, "event_handlers", event_handlers)
        if is_default_start_flow is not None:
            pulumi.set(__self__, "is_default_start_flow", is_default_start_flow)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if nlu_settings is not None:
            pulumi.set(__self__, "nlu_settings", nlu_settings)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if transition_route_groups is not None:
            pulumi.set(__self__, "transition_route_groups", transition_route_groups)
        if transition_routes is not None:
            pulumi.set(__self__, "transition_routes", transition_routes)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The human-readable name of the flow.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input['CxFlowAdvancedSettingsArgs']]:
        """
        Hierarchical advanced settings for this flow. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input['CxFlowAdvancedSettingsArgs']]):
        pulumi.set(self, "advanced_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowEventHandlerArgs']]]]:
        """
        A flow's event handlers serve two purposes:
        They are responsible for handling events (e.g. no match, webhook errors) in the flow.
        They are inherited by every page's [event handlers][Page.event_handlers], which can be used to handle common events regardless of the current page. Event handlers defined in the page have higher priority than those defined in the flow.
        Unlike transitionRoutes, these handlers are evaluated on a first-match basis. The first one that matches the event get executed, with the rest being ignored.
        Structure is documented below.
        """
        return pulumi.get(self, "event_handlers")

    @event_handlers.setter
    def event_handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowEventHandlerArgs']]]]):
        pulumi.set(self, "event_handlers", value)

    @property
    @pulumi.getter(name="isDefaultStartFlow")
    def is_default_start_flow(self) -> Optional[pulumi.Input[bool]]:
        """
        Marks this as the [Default Start Flow](https://cloud.google.com/dialogflow/cx/docs/concept/flow#start) for an agent. When you create an agent, the Default Start Flow is created automatically.
        The Default Start Flow cannot be deleted; deleting the `diagflow.CxFlow` resource does nothing to the underlying GCP resources.

        > Avoid having multiple `diagflow.CxFlow` resources linked to the same agent with `is_default_start_flow = true` because they will compete to control a single Default Start Flow resource in GCP.
        """
        return pulumi.get(self, "is_default_start_flow")

    @is_default_start_flow.setter
    def is_default_start_flow(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_start_flow", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        The language of the following fields in flow:
        Flow.event_handlers.trigger_fulfillment.messages
        Flow.event_handlers.trigger_fulfillment.conditional_cases
        Flow.transition_routes.trigger_fulfillment.messages
        Flow.transition_routes.trigger_fulfillment.conditional_cases
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="nluSettings")
    def nlu_settings(self) -> Optional[pulumi.Input['CxFlowNluSettingsArgs']]:
        """
        NLU related settings of the flow.
        Structure is documented below.
        """
        return pulumi.get(self, "nlu_settings")

    @nlu_settings.setter
    def nlu_settings(self, value: Optional[pulumi.Input['CxFlowNluSettingsArgs']]):
        pulumi.set(self, "nlu_settings", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The agent to create a flow for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A flow's transition route group serve two purposes:
        They are responsible for matching the user's first utterances in the flow.
        They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
        Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        """
        return pulumi.get(self, "transition_route_groups")

    @transition_route_groups.setter
    def transition_route_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transition_route_groups", value)

    @property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowTransitionRouteArgs']]]]:
        """
        A flow's transition routes serve two purposes:
        They are responsible for matching the user's first utterances in the flow.
        They are inherited by every page's [transition routes][Page.transition_routes] and can support use cases such as the user saying "help" or "can I talk to a human?", which can be handled in a common way regardless of the current page. Transition routes defined in the page have higher priority than those defined in the flow.
        TransitionRoutes are evalauted in the following order:
        TransitionRoutes with intent specified.
        TransitionRoutes with only condition specified.
        TransitionRoutes with intent specified are inherited by pages in the flow.
        Structure is documented below.
        """
        return pulumi.get(self, "transition_routes")

    @transition_routes.setter
    def transition_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowTransitionRouteArgs']]]]):
        pulumi.set(self, "transition_routes", value)


@pulumi.input_type
class _CxFlowState:
    def __init__(__self__, *,
                 advanced_settings: Optional[pulumi.Input['CxFlowAdvancedSettingsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowEventHandlerArgs']]]] = None,
                 is_default_start_flow: Optional[pulumi.Input[bool]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nlu_settings: Optional[pulumi.Input['CxFlowNluSettingsArgs']] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowTransitionRouteArgs']]]] = None):
        """
        Input properties used for looking up and filtering CxFlow resources.
        :param pulumi.Input['CxFlowAdvancedSettingsArgs'] advanced_settings: Hierarchical advanced settings for this flow. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[str] description: The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[str] display_name: The human-readable name of the flow.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input['CxFlowEventHandlerArgs']]] event_handlers: A flow's event handlers serve two purposes:
               They are responsible for handling events (e.g. no match, webhook errors) in the flow.
               They are inherited by every page's [event handlers][Page.event_handlers], which can be used to handle common events regardless of the current page. Event handlers defined in the page have higher priority than those defined in the flow.
               Unlike transitionRoutes, these handlers are evaluated on a first-match basis. The first one that matches the event get executed, with the rest being ignored.
               Structure is documented below.
        :param pulumi.Input[bool] is_default_start_flow: Marks this as the [Default Start Flow](https://cloud.google.com/dialogflow/cx/docs/concept/flow#start) for an agent. When you create an agent, the Default Start Flow is created automatically.
               The Default Start Flow cannot be deleted; deleting the `diagflow.CxFlow` resource does nothing to the underlying GCP resources.
               
               > Avoid having multiple `diagflow.CxFlow` resources linked to the same agent with `is_default_start_flow = true` because they will compete to control a single Default Start Flow resource in GCP.
        :param pulumi.Input[str] language_code: The language of the following fields in flow:
               Flow.event_handlers.trigger_fulfillment.messages
               Flow.event_handlers.trigger_fulfillment.conditional_cases
               Flow.transition_routes.trigger_fulfillment.messages
               Flow.transition_routes.trigger_fulfillment.conditional_cases
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[str] name: The unique identifier of the flow.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input['CxFlowNluSettingsArgs'] nlu_settings: NLU related settings of the flow.
               Structure is documented below.
        :param pulumi.Input[str] parent: The agent to create a flow for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transition_route_groups: A flow's transition route group serve two purposes:
               They are responsible for matching the user's first utterances in the flow.
               They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
               Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        :param pulumi.Input[Sequence[pulumi.Input['CxFlowTransitionRouteArgs']]] transition_routes: A flow's transition routes serve two purposes:
               They are responsible for matching the user's first utterances in the flow.
               They are inherited by every page's [transition routes][Page.transition_routes] and can support use cases such as the user saying "help" or "can I talk to a human?", which can be handled in a common way regardless of the current page. Transition routes defined in the page have higher priority than those defined in the flow.
               TransitionRoutes are evalauted in the following order:
               TransitionRoutes with intent specified.
               TransitionRoutes with only condition specified.
               TransitionRoutes with intent specified are inherited by pages in the flow.
               Structure is documented below.
        """
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if event_handlers is not None:
            pulumi.set(__self__, "event_handlers", event_handlers)
        if is_default_start_flow is not None:
            pulumi.set(__self__, "is_default_start_flow", is_default_start_flow)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nlu_settings is not None:
            pulumi.set(__self__, "nlu_settings", nlu_settings)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if transition_route_groups is not None:
            pulumi.set(__self__, "transition_route_groups", transition_route_groups)
        if transition_routes is not None:
            pulumi.set(__self__, "transition_routes", transition_routes)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input['CxFlowAdvancedSettingsArgs']]:
        """
        Hierarchical advanced settings for this flow. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input['CxFlowAdvancedSettingsArgs']]):
        pulumi.set(self, "advanced_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of the flow.


        - - -
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowEventHandlerArgs']]]]:
        """
        A flow's event handlers serve two purposes:
        They are responsible for handling events (e.g. no match, webhook errors) in the flow.
        They are inherited by every page's [event handlers][Page.event_handlers], which can be used to handle common events regardless of the current page. Event handlers defined in the page have higher priority than those defined in the flow.
        Unlike transitionRoutes, these handlers are evaluated on a first-match basis. The first one that matches the event get executed, with the rest being ignored.
        Structure is documented below.
        """
        return pulumi.get(self, "event_handlers")

    @event_handlers.setter
    def event_handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowEventHandlerArgs']]]]):
        pulumi.set(self, "event_handlers", value)

    @property
    @pulumi.getter(name="isDefaultStartFlow")
    def is_default_start_flow(self) -> Optional[pulumi.Input[bool]]:
        """
        Marks this as the [Default Start Flow](https://cloud.google.com/dialogflow/cx/docs/concept/flow#start) for an agent. When you create an agent, the Default Start Flow is created automatically.
        The Default Start Flow cannot be deleted; deleting the `diagflow.CxFlow` resource does nothing to the underlying GCP resources.

        > Avoid having multiple `diagflow.CxFlow` resources linked to the same agent with `is_default_start_flow = true` because they will compete to control a single Default Start Flow resource in GCP.
        """
        return pulumi.get(self, "is_default_start_flow")

    @is_default_start_flow.setter
    def is_default_start_flow(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_start_flow", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        The language of the following fields in flow:
        Flow.event_handlers.trigger_fulfillment.messages
        Flow.event_handlers.trigger_fulfillment.conditional_cases
        Flow.transition_routes.trigger_fulfillment.messages
        Flow.transition_routes.trigger_fulfillment.conditional_cases
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the flow.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nluSettings")
    def nlu_settings(self) -> Optional[pulumi.Input['CxFlowNluSettingsArgs']]:
        """
        NLU related settings of the flow.
        Structure is documented below.
        """
        return pulumi.get(self, "nlu_settings")

    @nlu_settings.setter
    def nlu_settings(self, value: Optional[pulumi.Input['CxFlowNluSettingsArgs']]):
        pulumi.set(self, "nlu_settings", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The agent to create a flow for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A flow's transition route group serve two purposes:
        They are responsible for matching the user's first utterances in the flow.
        They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
        Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        """
        return pulumi.get(self, "transition_route_groups")

    @transition_route_groups.setter
    def transition_route_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transition_route_groups", value)

    @property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowTransitionRouteArgs']]]]:
        """
        A flow's transition routes serve two purposes:
        They are responsible for matching the user's first utterances in the flow.
        They are inherited by every page's [transition routes][Page.transition_routes] and can support use cases such as the user saying "help" or "can I talk to a human?", which can be handled in a common way regardless of the current page. Transition routes defined in the page have higher priority than those defined in the flow.
        TransitionRoutes are evalauted in the following order:
        TransitionRoutes with intent specified.
        TransitionRoutes with only condition specified.
        TransitionRoutes with intent specified are inherited by pages in the flow.
        Structure is documented below.
        """
        return pulumi.get(self, "transition_routes")

    @transition_routes.setter
    def transition_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxFlowTransitionRouteArgs']]]]):
        pulumi.set(self, "transition_routes", value)


class CxFlow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_settings: Optional[pulumi.Input[Union['CxFlowAdvancedSettingsArgs', 'CxFlowAdvancedSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxFlowEventHandlerArgs', 'CxFlowEventHandlerArgsDict']]]]] = None,
                 is_default_start_flow: Optional[pulumi.Input[bool]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 nlu_settings: Optional[pulumi.Input[Union['CxFlowNluSettingsArgs', 'CxFlowNluSettingsArgsDict']]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxFlowTransitionRouteArgs', 'CxFlowTransitionRouteArgsDict']]]]] = None,
                 __props__=None):
        """
        Flows represents the conversation flows when you build your chatbot agent.

        To get more information about Flow, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.flows)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Flow Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        basic_flow = gcp.diagflow.CxFlow("basic_flow",
            parent=agent.id,
            display_name="MyFlow",
            description="Test Flow",
            nlu_settings={
                "classification_threshold": 0.3,
                "model_type": "MODEL_TYPE_STANDARD",
            },
            event_handlers=[
                {
                    "event": "custom-event",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["I didn't get that. Can you say it again?"],
                            },
                        }],
                    },
                },
                {
                    "event": "sys.no-match-default",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["Sorry, could you say that again?"],
                            },
                        }],
                    },
                },
                {
                    "event": "sys.no-input-default",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["One more time?"],
                            },
                        }],
                    },
                },
            ])
        ```
        ### Dialogflowcx Flow Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        basic_flow = gcp.diagflow.CxFlow("basic_flow",
            parent=agent.id,
            display_name="MyFlow",
            description="Test Flow",
            nlu_settings={
                "classification_threshold": 0.3,
                "model_type": "MODEL_TYPE_STANDARD",
            },
            event_handlers=[
                {
                    "event": "custom-event",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["I didn't get that. Can you say it again?"],
                            },
                        }],
                    },
                },
                {
                    "event": "sys.no-match-default",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["Sorry, could you say that again?"],
                            },
                        }],
                    },
                },
                {
                    "event": "sys.no-input-default",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["One more time?"],
                            },
                        }],
                    },
                },
                {
                    "event": "another-event",
                    "trigger_fulfillment": {
                        "return_partial_responses": True,
                        "messages": [
                            {
                                "channel": "some-channel",
                                "text": {
                                    "texts": ["Some text"],
                                },
                            },
                            {
                                "payload": "          {\\"some-key\\": \\"some-value\\", \\"other-key\\": [\\"other-value\\"]}\\n",
                            },
                            {
                                "conversation_success": {
                                    "metadata": "            {\\"some-metadata-key\\": \\"some-value\\", \\"other-metadata-key\\": 1234}\\n",
                                },
                            },
                            {
                                "output_audio_text": {
                                    "text": "some output text",
                                },
                            },
                            {
                                "output_audio_text": {
                                    "ssml": "            <speak>Some example <say-as interpret-as=\\"characters\\">SSML XML</say-as></speak>\\n",
                                },
                            },
                            {
                                "live_agent_handoff": {
                                    "metadata": "            {\\"some-metadata-key\\": \\"some-value\\", \\"other-metadata-key\\": 1234}\\n",
                                },
                            },
                            {
                                "play_audio": {
                                    "audio_uri": "http://example.com/some-audio-file.mp3",
                                },
                            },
                            {
                                "telephony_transfer_call": {
                                    "phone_number": "1-234-567-8901",
                                },
                            },
                        ],
                        "set_parameter_actions": [
                            {
                                "parameter": "some-param",
                                "value": "123.45",
                            },
                            {
                                "parameter": "another-param",
                                "value": json.dumps("abc"),
                            },
                            {
                                "parameter": "other-param",
                                "value": json.dumps(["foo"]),
                            },
                        ],
                        "conditional_cases": [{
                            "cases": json.dumps([
                                {
                                    "condition": "$sys.func.RAND() < 0.5",
                                    "case_content": [
                                        {
                                            "message": {
                                                "text": {
                                                    "text": ["First case"],
                                                },
                                            },
                                        },
                                        {
                                            "additionalCases": {
                                                "cases": [{
                                                    "condition": "$sys.func.RAND() < 0.2",
                                                    "caseContent": [{
                                                        "message": {
                                                            "text": {
                                                                "text": ["Nested case"],
                                                            },
                                                        },
                                                    }],
                                                }],
                                            },
                                        },
                                    ],
                                },
                                {
                                    "caseContent": [{
                                        "message": {
                                            "text": {
                                                "text": ["Final case"],
                                            },
                                        },
                                    }],
                                },
                            ]),
                        }],
                    },
                },
            ],
            transition_routes=[{
                "condition": "true",
                "trigger_fulfillment": {
                    "return_partial_responses": True,
                    "messages": [
                        {
                            "channel": "some-channel",
                            "text": {
                                "texts": ["Some text"],
                            },
                        },
                        {
                            "payload": "          {\\"some-key\\": \\"some-value\\", \\"other-key\\": [\\"other-value\\"]}\\n",
                        },
                        {
                            "conversation_success": {
                                "metadata": "            {\\"some-metadata-key\\": \\"some-value\\", \\"other-metadata-key\\": 1234}\\n",
                            },
                        },
                        {
                            "output_audio_text": {
                                "text": "some output text",
                            },
                        },
                        {
                            "output_audio_text": {
                                "ssml": "            <speak>Some example <say-as interpret-as=\\"characters\\">SSML XML</say-as></speak>\\n",
                            },
                        },
                        {
                            "live_agent_handoff": {
                                "metadata": "            {\\"some-metadata-key\\": \\"some-value\\", \\"other-metadata-key\\": 1234}\\n",
                            },
                        },
                        {
                            "play_audio": {
                                "audio_uri": "http://example.com/some-audio-file.mp3",
                            },
                        },
                        {
                            "telephony_transfer_call": {
                                "phone_number": "1-234-567-8901",
                            },
                        },
                    ],
                    "set_parameter_actions": [
                        {
                            "parameter": "some-param",
                            "value": "123.45",
                        },
                        {
                            "parameter": "another-param",
                            "value": json.dumps("abc"),
                        },
                        {
                            "parameter": "other-param",
                            "value": json.dumps(["foo"]),
                        },
                    ],
                    "conditional_cases": [{
                        "cases": json.dumps([
                            {
                                "condition": "$sys.func.RAND() < 0.5",
                                "case_content": [
                                    {
                                        "message": {
                                            "text": {
                                                "text": ["First case"],
                                            },
                                        },
                                    },
                                    {
                                        "additionalCases": {
                                            "cases": [{
                                                "condition": "$sys.func.RAND() < 0.2",
                                                "caseContent": [{
                                                    "message": {
                                                        "text": {
                                                            "text": ["Nested case"],
                                                        },
                                                    },
                                                }],
                                            }],
                                        },
                                    },
                                ],
                            },
                            {
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["Final case"],
                                        },
                                    },
                                }],
                            },
                        ]),
                    }],
                },
                "target_flow": agent.start_flow,
            }],
            advanced_settings={
                "audio_export_gcs_destination": {
                    "uri": bucket.url.apply(lambda url: f"{url}/prefix-"),
                },
                "dtmf_settings": {
                    "enabled": True,
                    "max_digits": 1,
                    "finish_digit": "#",
                },
            })
        ```

        ## Import

        Flow can be imported using any of these accepted formats:

        * `{{parent}}/flows/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Flow can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxFlow:CxFlow default {{parent}}/flows/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxFlow:CxFlow default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxFlowAdvancedSettingsArgs', 'CxFlowAdvancedSettingsArgsDict']] advanced_settings: Hierarchical advanced settings for this flow. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[str] description: The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[str] display_name: The human-readable name of the flow.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxFlowEventHandlerArgs', 'CxFlowEventHandlerArgsDict']]]] event_handlers: A flow's event handlers serve two purposes:
               They are responsible for handling events (e.g. no match, webhook errors) in the flow.
               They are inherited by every page's [event handlers][Page.event_handlers], which can be used to handle common events regardless of the current page. Event handlers defined in the page have higher priority than those defined in the flow.
               Unlike transitionRoutes, these handlers are evaluated on a first-match basis. The first one that matches the event get executed, with the rest being ignored.
               Structure is documented below.
        :param pulumi.Input[bool] is_default_start_flow: Marks this as the [Default Start Flow](https://cloud.google.com/dialogflow/cx/docs/concept/flow#start) for an agent. When you create an agent, the Default Start Flow is created automatically.
               The Default Start Flow cannot be deleted; deleting the `diagflow.CxFlow` resource does nothing to the underlying GCP resources.
               
               > Avoid having multiple `diagflow.CxFlow` resources linked to the same agent with `is_default_start_flow = true` because they will compete to control a single Default Start Flow resource in GCP.
        :param pulumi.Input[str] language_code: The language of the following fields in flow:
               Flow.event_handlers.trigger_fulfillment.messages
               Flow.event_handlers.trigger_fulfillment.conditional_cases
               Flow.transition_routes.trigger_fulfillment.messages
               Flow.transition_routes.trigger_fulfillment.conditional_cases
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[Union['CxFlowNluSettingsArgs', 'CxFlowNluSettingsArgsDict']] nlu_settings: NLU related settings of the flow.
               Structure is documented below.
        :param pulumi.Input[str] parent: The agent to create a flow for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transition_route_groups: A flow's transition route group serve two purposes:
               They are responsible for matching the user's first utterances in the flow.
               They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
               Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxFlowTransitionRouteArgs', 'CxFlowTransitionRouteArgsDict']]]] transition_routes: A flow's transition routes serve two purposes:
               They are responsible for matching the user's first utterances in the flow.
               They are inherited by every page's [transition routes][Page.transition_routes] and can support use cases such as the user saying "help" or "can I talk to a human?", which can be handled in a common way regardless of the current page. Transition routes defined in the page have higher priority than those defined in the flow.
               TransitionRoutes are evalauted in the following order:
               TransitionRoutes with intent specified.
               TransitionRoutes with only condition specified.
               TransitionRoutes with intent specified are inherited by pages in the flow.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxFlowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Flows represents the conversation flows when you build your chatbot agent.

        To get more information about Flow, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.flows)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Flow Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        basic_flow = gcp.diagflow.CxFlow("basic_flow",
            parent=agent.id,
            display_name="MyFlow",
            description="Test Flow",
            nlu_settings={
                "classification_threshold": 0.3,
                "model_type": "MODEL_TYPE_STANDARD",
            },
            event_handlers=[
                {
                    "event": "custom-event",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["I didn't get that. Can you say it again?"],
                            },
                        }],
                    },
                },
                {
                    "event": "sys.no-match-default",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["Sorry, could you say that again?"],
                            },
                        }],
                    },
                },
                {
                    "event": "sys.no-input-default",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["One more time?"],
                            },
                        }],
                    },
                },
            ])
        ```
        ### Dialogflowcx Flow Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        basic_flow = gcp.diagflow.CxFlow("basic_flow",
            parent=agent.id,
            display_name="MyFlow",
            description="Test Flow",
            nlu_settings={
                "classification_threshold": 0.3,
                "model_type": "MODEL_TYPE_STANDARD",
            },
            event_handlers=[
                {
                    "event": "custom-event",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["I didn't get that. Can you say it again?"],
                            },
                        }],
                    },
                },
                {
                    "event": "sys.no-match-default",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["Sorry, could you say that again?"],
                            },
                        }],
                    },
                },
                {
                    "event": "sys.no-input-default",
                    "trigger_fulfillment": {
                        "return_partial_responses": False,
                        "messages": [{
                            "text": {
                                "texts": ["One more time?"],
                            },
                        }],
                    },
                },
                {
                    "event": "another-event",
                    "trigger_fulfillment": {
                        "return_partial_responses": True,
                        "messages": [
                            {
                                "channel": "some-channel",
                                "text": {
                                    "texts": ["Some text"],
                                },
                            },
                            {
                                "payload": "          {\\"some-key\\": \\"some-value\\", \\"other-key\\": [\\"other-value\\"]}\\n",
                            },
                            {
                                "conversation_success": {
                                    "metadata": "            {\\"some-metadata-key\\": \\"some-value\\", \\"other-metadata-key\\": 1234}\\n",
                                },
                            },
                            {
                                "output_audio_text": {
                                    "text": "some output text",
                                },
                            },
                            {
                                "output_audio_text": {
                                    "ssml": "            <speak>Some example <say-as interpret-as=\\"characters\\">SSML XML</say-as></speak>\\n",
                                },
                            },
                            {
                                "live_agent_handoff": {
                                    "metadata": "            {\\"some-metadata-key\\": \\"some-value\\", \\"other-metadata-key\\": 1234}\\n",
                                },
                            },
                            {
                                "play_audio": {
                                    "audio_uri": "http://example.com/some-audio-file.mp3",
                                },
                            },
                            {
                                "telephony_transfer_call": {
                                    "phone_number": "1-234-567-8901",
                                },
                            },
                        ],
                        "set_parameter_actions": [
                            {
                                "parameter": "some-param",
                                "value": "123.45",
                            },
                            {
                                "parameter": "another-param",
                                "value": json.dumps("abc"),
                            },
                            {
                                "parameter": "other-param",
                                "value": json.dumps(["foo"]),
                            },
                        ],
                        "conditional_cases": [{
                            "cases": json.dumps([
                                {
                                    "condition": "$sys.func.RAND() < 0.5",
                                    "case_content": [
                                        {
                                            "message": {
                                                "text": {
                                                    "text": ["First case"],
                                                },
                                            },
                                        },
                                        {
                                            "additionalCases": {
                                                "cases": [{
                                                    "condition": "$sys.func.RAND() < 0.2",
                                                    "caseContent": [{
                                                        "message": {
                                                            "text": {
                                                                "text": ["Nested case"],
                                                            },
                                                        },
                                                    }],
                                                }],
                                            },
                                        },
                                    ],
                                },
                                {
                                    "caseContent": [{
                                        "message": {
                                            "text": {
                                                "text": ["Final case"],
                                            },
                                        },
                                    }],
                                },
                            ]),
                        }],
                    },
                },
            ],
            transition_routes=[{
                "condition": "true",
                "trigger_fulfillment": {
                    "return_partial_responses": True,
                    "messages": [
                        {
                            "channel": "some-channel",
                            "text": {
                                "texts": ["Some text"],
                            },
                        },
                        {
                            "payload": "          {\\"some-key\\": \\"some-value\\", \\"other-key\\": [\\"other-value\\"]}\\n",
                        },
                        {
                            "conversation_success": {
                                "metadata": "            {\\"some-metadata-key\\": \\"some-value\\", \\"other-metadata-key\\": 1234}\\n",
                            },
                        },
                        {
                            "output_audio_text": {
                                "text": "some output text",
                            },
                        },
                        {
                            "output_audio_text": {
                                "ssml": "            <speak>Some example <say-as interpret-as=\\"characters\\">SSML XML</say-as></speak>\\n",
                            },
                        },
                        {
                            "live_agent_handoff": {
                                "metadata": "            {\\"some-metadata-key\\": \\"some-value\\", \\"other-metadata-key\\": 1234}\\n",
                            },
                        },
                        {
                            "play_audio": {
                                "audio_uri": "http://example.com/some-audio-file.mp3",
                            },
                        },
                        {
                            "telephony_transfer_call": {
                                "phone_number": "1-234-567-8901",
                            },
                        },
                    ],
                    "set_parameter_actions": [
                        {
                            "parameter": "some-param",
                            "value": "123.45",
                        },
                        {
                            "parameter": "another-param",
                            "value": json.dumps("abc"),
                        },
                        {
                            "parameter": "other-param",
                            "value": json.dumps(["foo"]),
                        },
                    ],
                    "conditional_cases": [{
                        "cases": json.dumps([
                            {
                                "condition": "$sys.func.RAND() < 0.5",
                                "case_content": [
                                    {
                                        "message": {
                                            "text": {
                                                "text": ["First case"],
                                            },
                                        },
                                    },
                                    {
                                        "additionalCases": {
                                            "cases": [{
                                                "condition": "$sys.func.RAND() < 0.2",
                                                "caseContent": [{
                                                    "message": {
                                                        "text": {
                                                            "text": ["Nested case"],
                                                        },
                                                    },
                                                }],
                                            }],
                                        },
                                    },
                                ],
                            },
                            {
                                "caseContent": [{
                                    "message": {
                                        "text": {
                                            "text": ["Final case"],
                                        },
                                    },
                                }],
                            },
                        ]),
                    }],
                },
                "target_flow": agent.start_flow,
            }],
            advanced_settings={
                "audio_export_gcs_destination": {
                    "uri": bucket.url.apply(lambda url: f"{url}/prefix-"),
                },
                "dtmf_settings": {
                    "enabled": True,
                    "max_digits": 1,
                    "finish_digit": "#",
                },
            })
        ```

        ## Import

        Flow can be imported using any of these accepted formats:

        * `{{parent}}/flows/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Flow can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxFlow:CxFlow default {{parent}}/flows/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxFlow:CxFlow default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxFlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxFlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_settings: Optional[pulumi.Input[Union['CxFlowAdvancedSettingsArgs', 'CxFlowAdvancedSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxFlowEventHandlerArgs', 'CxFlowEventHandlerArgsDict']]]]] = None,
                 is_default_start_flow: Optional[pulumi.Input[bool]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 nlu_settings: Optional[pulumi.Input[Union['CxFlowNluSettingsArgs', 'CxFlowNluSettingsArgsDict']]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxFlowTransitionRouteArgs', 'CxFlowTransitionRouteArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxFlowArgs.__new__(CxFlowArgs)

            __props__.__dict__["advanced_settings"] = advanced_settings
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["event_handlers"] = event_handlers
            __props__.__dict__["is_default_start_flow"] = is_default_start_flow
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["nlu_settings"] = nlu_settings
            __props__.__dict__["parent"] = parent
            __props__.__dict__["transition_route_groups"] = transition_route_groups
            __props__.__dict__["transition_routes"] = transition_routes
            __props__.__dict__["name"] = None
        super(CxFlow, __self__).__init__(
            'gcp:diagflow/cxFlow:CxFlow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_settings: Optional[pulumi.Input[Union['CxFlowAdvancedSettingsArgs', 'CxFlowAdvancedSettingsArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            event_handlers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxFlowEventHandlerArgs', 'CxFlowEventHandlerArgsDict']]]]] = None,
            is_default_start_flow: Optional[pulumi.Input[bool]] = None,
            language_code: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nlu_settings: Optional[pulumi.Input[Union['CxFlowNluSettingsArgs', 'CxFlowNluSettingsArgsDict']]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            transition_route_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            transition_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxFlowTransitionRouteArgs', 'CxFlowTransitionRouteArgsDict']]]]] = None) -> 'CxFlow':
        """
        Get an existing CxFlow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxFlowAdvancedSettingsArgs', 'CxFlowAdvancedSettingsArgsDict']] advanced_settings: Hierarchical advanced settings for this flow. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[str] description: The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[str] display_name: The human-readable name of the flow.
               
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxFlowEventHandlerArgs', 'CxFlowEventHandlerArgsDict']]]] event_handlers: A flow's event handlers serve two purposes:
               They are responsible for handling events (e.g. no match, webhook errors) in the flow.
               They are inherited by every page's [event handlers][Page.event_handlers], which can be used to handle common events regardless of the current page. Event handlers defined in the page have higher priority than those defined in the flow.
               Unlike transitionRoutes, these handlers are evaluated on a first-match basis. The first one that matches the event get executed, with the rest being ignored.
               Structure is documented below.
        :param pulumi.Input[bool] is_default_start_flow: Marks this as the [Default Start Flow](https://cloud.google.com/dialogflow/cx/docs/concept/flow#start) for an agent. When you create an agent, the Default Start Flow is created automatically.
               The Default Start Flow cannot be deleted; deleting the `diagflow.CxFlow` resource does nothing to the underlying GCP resources.
               
               > Avoid having multiple `diagflow.CxFlow` resources linked to the same agent with `is_default_start_flow = true` because they will compete to control a single Default Start Flow resource in GCP.
        :param pulumi.Input[str] language_code: The language of the following fields in flow:
               Flow.event_handlers.trigger_fulfillment.messages
               Flow.event_handlers.trigger_fulfillment.conditional_cases
               Flow.transition_routes.trigger_fulfillment.messages
               Flow.transition_routes.trigger_fulfillment.conditional_cases
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[str] name: The unique identifier of the flow.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Union['CxFlowNluSettingsArgs', 'CxFlowNluSettingsArgsDict']] nlu_settings: NLU related settings of the flow.
               Structure is documented below.
        :param pulumi.Input[str] parent: The agent to create a flow for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transition_route_groups: A flow's transition route group serve two purposes:
               They are responsible for matching the user's first utterances in the flow.
               They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
               Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxFlowTransitionRouteArgs', 'CxFlowTransitionRouteArgsDict']]]] transition_routes: A flow's transition routes serve two purposes:
               They are responsible for matching the user's first utterances in the flow.
               They are inherited by every page's [transition routes][Page.transition_routes] and can support use cases such as the user saying "help" or "can I talk to a human?", which can be handled in a common way regardless of the current page. Transition routes defined in the page have higher priority than those defined in the flow.
               TransitionRoutes are evalauted in the following order:
               TransitionRoutes with intent specified.
               TransitionRoutes with only condition specified.
               TransitionRoutes with intent specified are inherited by pages in the flow.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxFlowState.__new__(_CxFlowState)

        __props__.__dict__["advanced_settings"] = advanced_settings
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["event_handlers"] = event_handlers
        __props__.__dict__["is_default_start_flow"] = is_default_start_flow
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["name"] = name
        __props__.__dict__["nlu_settings"] = nlu_settings
        __props__.__dict__["parent"] = parent
        __props__.__dict__["transition_route_groups"] = transition_route_groups
        __props__.__dict__["transition_routes"] = transition_routes
        return CxFlow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> pulumi.Output[Optional['outputs.CxFlowAdvancedSettings']]:
        """
        Hierarchical advanced settings for this flow. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The human-readable name of the flow.


        - - -
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> pulumi.Output[Sequence['outputs.CxFlowEventHandler']]:
        """
        A flow's event handlers serve two purposes:
        They are responsible for handling events (e.g. no match, webhook errors) in the flow.
        They are inherited by every page's [event handlers][Page.event_handlers], which can be used to handle common events regardless of the current page. Event handlers defined in the page have higher priority than those defined in the flow.
        Unlike transitionRoutes, these handlers are evaluated on a first-match basis. The first one that matches the event get executed, with the rest being ignored.
        Structure is documented below.
        """
        return pulumi.get(self, "event_handlers")

    @property
    @pulumi.getter(name="isDefaultStartFlow")
    def is_default_start_flow(self) -> pulumi.Output[Optional[bool]]:
        """
        Marks this as the [Default Start Flow](https://cloud.google.com/dialogflow/cx/docs/concept/flow#start) for an agent. When you create an agent, the Default Start Flow is created automatically.
        The Default Start Flow cannot be deleted; deleting the `diagflow.CxFlow` resource does nothing to the underlying GCP resources.

        > Avoid having multiple `diagflow.CxFlow` resources linked to the same agent with `is_default_start_flow = true` because they will compete to control a single Default Start Flow resource in GCP.
        """
        return pulumi.get(self, "is_default_start_flow")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[Optional[str]]:
        """
        The language of the following fields in flow:
        Flow.event_handlers.trigger_fulfillment.messages
        Flow.event_handlers.trigger_fulfillment.conditional_cases
        Flow.transition_routes.trigger_fulfillment.messages
        Flow.transition_routes.trigger_fulfillment.conditional_cases
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique identifier of the flow.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nluSettings")
    def nlu_settings(self) -> pulumi.Output[Optional['outputs.CxFlowNluSettings']]:
        """
        NLU related settings of the flow.
        Structure is documented below.
        """
        return pulumi.get(self, "nlu_settings")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[str]]:
        """
        The agent to create a flow for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A flow's transition route group serve two purposes:
        They are responsible for matching the user's first utterances in the flow.
        They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
        Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
        """
        return pulumi.get(self, "transition_route_groups")

    @property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> pulumi.Output[Optional[Sequence['outputs.CxFlowTransitionRoute']]]:
        """
        A flow's transition routes serve two purposes:
        They are responsible for matching the user's first utterances in the flow.
        They are inherited by every page's [transition routes][Page.transition_routes] and can support use cases such as the user saying "help" or "can I talk to a human?", which can be handled in a common way regardless of the current page. Transition routes defined in the page have higher priority than those defined in the flow.
        TransitionRoutes are evalauted in the following order:
        TransitionRoutes with intent specified.
        TransitionRoutes with only condition specified.
        TransitionRoutes with intent specified are inherited by pages in the flow.
        Structure is documented below.
        """
        return pulumi.get(self, "transition_routes")

