# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ChatEngineArgs', 'ChatEngine']

@pulumi.input_type
class ChatEngineArgs:
    def __init__(__self__, *,
                 chat_engine_config: pulumi.Input['ChatEngineChatEngineConfigArgs'],
                 collection_id: pulumi.Input[str],
                 data_store_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 display_name: pulumi.Input[str],
                 engine_id: pulumi.Input[str],
                 location: pulumi.Input[str],
                 common_config: Optional[pulumi.Input['ChatEngineCommonConfigArgs']] = None,
                 industry_vertical: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ChatEngine resource.
        :param pulumi.Input['ChatEngineChatEngineConfigArgs'] chat_engine_config: Configurations for a chat Engine.
               Structure is documented below.
        :param pulumi.Input[str] collection_id: The collection ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_store_ids: The data stores associated with this engine. Multiple DataStores in the same Collection can be associated here. All listed DataStores must be `SOLUTION_TYPE_CHAT`. Adding or removing data stores will force recreation.
        :param pulumi.Input[str] display_name: The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[str] engine_id: The ID to use for chat engine.
        :param pulumi.Input[str] location: Location.
        :param pulumi.Input['ChatEngineCommonConfigArgs'] common_config: Common config spec that specifies the metadata of the engine.
        :param pulumi.Input[str] industry_vertical: The industry vertical that the chat engine registers. Vertical on Engine has to match vertical of the DataStore linked
               to the engine. Default value: "GENERIC" Possible values: ["GENERIC"]
        """
        pulumi.set(__self__, "chat_engine_config", chat_engine_config)
        pulumi.set(__self__, "collection_id", collection_id)
        pulumi.set(__self__, "data_store_ids", data_store_ids)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "engine_id", engine_id)
        pulumi.set(__self__, "location", location)
        if common_config is not None:
            pulumi.set(__self__, "common_config", common_config)
        if industry_vertical is not None:
            pulumi.set(__self__, "industry_vertical", industry_vertical)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="chatEngineConfig")
    def chat_engine_config(self) -> pulumi.Input['ChatEngineChatEngineConfigArgs']:
        """
        Configurations for a chat Engine.
        Structure is documented below.
        """
        return pulumi.get(self, "chat_engine_config")

    @chat_engine_config.setter
    def chat_engine_config(self, value: pulumi.Input['ChatEngineChatEngineConfigArgs']):
        pulumi.set(self, "chat_engine_config", value)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Input[str]:
        """
        The collection ID.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "collection_id", value)

    @property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The data stores associated with this engine. Multiple DataStores in the same Collection can be associated here. All listed DataStores must be `SOLUTION_TYPE_CHAT`. Adding or removing data stores will force recreation.
        """
        return pulumi.get(self, "data_store_ids")

    @data_store_ids.setter
    def data_store_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "data_store_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Input[str]:
        """
        The ID to use for chat engine.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        Location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> Optional[pulumi.Input['ChatEngineCommonConfigArgs']]:
        """
        Common config spec that specifies the metadata of the engine.
        """
        return pulumi.get(self, "common_config")

    @common_config.setter
    def common_config(self, value: Optional[pulumi.Input['ChatEngineCommonConfigArgs']]):
        pulumi.set(self, "common_config", value)

    @property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> Optional[pulumi.Input[str]]:
        """
        The industry vertical that the chat engine registers. Vertical on Engine has to match vertical of the DataStore linked
        to the engine. Default value: "GENERIC" Possible values: ["GENERIC"]
        """
        return pulumi.get(self, "industry_vertical")

    @industry_vertical.setter
    def industry_vertical(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "industry_vertical", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ChatEngineState:
    def __init__(__self__, *,
                 chat_engine_config: Optional[pulumi.Input['ChatEngineChatEngineConfigArgs']] = None,
                 chat_engine_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ChatEngineChatEngineMetadataArgs']]]] = None,
                 collection_id: Optional[pulumi.Input[str]] = None,
                 common_config: Optional[pulumi.Input['ChatEngineCommonConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 engine_id: Optional[pulumi.Input[str]] = None,
                 industry_vertical: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ChatEngine resources.
        :param pulumi.Input['ChatEngineChatEngineConfigArgs'] chat_engine_config: Configurations for a chat Engine.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ChatEngineChatEngineMetadataArgs']]] chat_engine_metadatas: Additional information of the Chat Engine.
               Structure is documented below.
        :param pulumi.Input[str] collection_id: The collection ID.
        :param pulumi.Input['ChatEngineCommonConfigArgs'] common_config: Common config spec that specifies the metadata of the engine.
        :param pulumi.Input[str] create_time: Timestamp the Engine was created at.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_store_ids: The data stores associated with this engine. Multiple DataStores in the same Collection can be associated here. All listed DataStores must be `SOLUTION_TYPE_CHAT`. Adding or removing data stores will force recreation.
        :param pulumi.Input[str] display_name: The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[str] engine_id: The ID to use for chat engine.
        :param pulumi.Input[str] industry_vertical: The industry vertical that the chat engine registers. Vertical on Engine has to match vertical of the DataStore linked
               to the engine. Default value: "GENERIC" Possible values: ["GENERIC"]
        :param pulumi.Input[str] location: Location.
        :param pulumi.Input[str] name: The unique full resource name of the chat engine. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[str] update_time: Timestamp the Engine was last updated.
        """
        if chat_engine_config is not None:
            pulumi.set(__self__, "chat_engine_config", chat_engine_config)
        if chat_engine_metadatas is not None:
            pulumi.set(__self__, "chat_engine_metadatas", chat_engine_metadatas)
        if collection_id is not None:
            pulumi.set(__self__, "collection_id", collection_id)
        if common_config is not None:
            pulumi.set(__self__, "common_config", common_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_store_ids is not None:
            pulumi.set(__self__, "data_store_ids", data_store_ids)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if engine_id is not None:
            pulumi.set(__self__, "engine_id", engine_id)
        if industry_vertical is not None:
            pulumi.set(__self__, "industry_vertical", industry_vertical)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="chatEngineConfig")
    def chat_engine_config(self) -> Optional[pulumi.Input['ChatEngineChatEngineConfigArgs']]:
        """
        Configurations for a chat Engine.
        Structure is documented below.
        """
        return pulumi.get(self, "chat_engine_config")

    @chat_engine_config.setter
    def chat_engine_config(self, value: Optional[pulumi.Input['ChatEngineChatEngineConfigArgs']]):
        pulumi.set(self, "chat_engine_config", value)

    @property
    @pulumi.getter(name="chatEngineMetadatas")
    def chat_engine_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChatEngineChatEngineMetadataArgs']]]]:
        """
        Additional information of the Chat Engine.
        Structure is documented below.
        """
        return pulumi.get(self, "chat_engine_metadatas")

    @chat_engine_metadatas.setter
    def chat_engine_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChatEngineChatEngineMetadataArgs']]]]):
        pulumi.set(self, "chat_engine_metadatas", value)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The collection ID.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_id", value)

    @property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> Optional[pulumi.Input['ChatEngineCommonConfigArgs']]:
        """
        Common config spec that specifies the metadata of the engine.
        """
        return pulumi.get(self, "common_config")

    @common_config.setter
    def common_config(self, value: Optional[pulumi.Input['ChatEngineCommonConfigArgs']]):
        pulumi.set(self, "common_config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp the Engine was created at.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The data stores associated with this engine. Multiple DataStores in the same Collection can be associated here. All listed DataStores must be `SOLUTION_TYPE_CHAT`. Adding or removing data stores will force recreation.
        """
        return pulumi.get(self, "data_store_ids")

    @data_store_ids.setter
    def data_store_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "data_store_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for chat engine.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_id", value)

    @property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> Optional[pulumi.Input[str]]:
        """
        The industry vertical that the chat engine registers. Vertical on Engine has to match vertical of the DataStore linked
        to the engine. Default value: "GENERIC" Possible values: ["GENERIC"]
        """
        return pulumi.get(self, "industry_vertical")

    @industry_vertical.setter
    def industry_vertical(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "industry_vertical", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique full resource name of the chat engine. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp the Engine was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class ChatEngine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chat_engine_config: Optional[pulumi.Input[Union['ChatEngineChatEngineConfigArgs', 'ChatEngineChatEngineConfigArgsDict']]] = None,
                 collection_id: Optional[pulumi.Input[str]] = None,
                 common_config: Optional[pulumi.Input[Union['ChatEngineCommonConfigArgs', 'ChatEngineCommonConfigArgsDict']]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 engine_id: Optional[pulumi.Input[str]] = None,
                 industry_vertical: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Vertex chat and Conversation Engine Chat type

        To get more information about ChatEngine, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.engines)
        * How-to Guides
            * [Vertex AI Conversation](https://cloud.google.com/dialogflow/cx/docs/concept/generative)

        ## Example Usage

        ### Discoveryengine Chat Engine Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_data_store = gcp.discoveryengine.DataStore("test_data_store",
            location="global",
            data_store_id="data-store",
            display_name="Structured datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_CHAT"])
        test_data_store2 = gcp.discoveryengine.DataStore("test_data_store_2",
            location=test_data_store.location,
            data_store_id="data-store-2",
            display_name="Structured datastore 2",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_CHAT"])
        primary = gcp.discoveryengine.ChatEngine("primary",
            engine_id="chat-engine-id",
            collection_id="default_collection",
            location=test_data_store.location,
            display_name="Chat engine",
            industry_vertical="GENERIC",
            data_store_ids=[
                test_data_store.data_store_id,
                test_data_store2.data_store_id,
            ],
            common_config={
                "company_name": "test-company",
            },
            chat_engine_config={
                "agent_creation_config": {
                    "business": "test business name",
                    "default_language_code": "en",
                    "time_zone": "America/Los_Angeles",
                },
            })
        ```

        ## Import

        ChatEngine can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}`

        * `{{project}}/{{location}}/{{collection_id}}/{{engine_id}}`

        * `{{location}}/{{collection_id}}/{{engine_id}}`

        When using the `pulumi import` command, ChatEngine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/chatEngine:ChatEngine default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/chatEngine:ChatEngine default {{project}}/{{location}}/{{collection_id}}/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/chatEngine:ChatEngine default {{location}}/{{collection_id}}/{{engine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ChatEngineChatEngineConfigArgs', 'ChatEngineChatEngineConfigArgsDict']] chat_engine_config: Configurations for a chat Engine.
               Structure is documented below.
        :param pulumi.Input[str] collection_id: The collection ID.
        :param pulumi.Input[Union['ChatEngineCommonConfigArgs', 'ChatEngineCommonConfigArgsDict']] common_config: Common config spec that specifies the metadata of the engine.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_store_ids: The data stores associated with this engine. Multiple DataStores in the same Collection can be associated here. All listed DataStores must be `SOLUTION_TYPE_CHAT`. Adding or removing data stores will force recreation.
        :param pulumi.Input[str] display_name: The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[str] engine_id: The ID to use for chat engine.
        :param pulumi.Input[str] industry_vertical: The industry vertical that the chat engine registers. Vertical on Engine has to match vertical of the DataStore linked
               to the engine. Default value: "GENERIC" Possible values: ["GENERIC"]
        :param pulumi.Input[str] location: Location.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChatEngineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Vertex chat and Conversation Engine Chat type

        To get more information about ChatEngine, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.engines)
        * How-to Guides
            * [Vertex AI Conversation](https://cloud.google.com/dialogflow/cx/docs/concept/generative)

        ## Example Usage

        ### Discoveryengine Chat Engine Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_data_store = gcp.discoveryengine.DataStore("test_data_store",
            location="global",
            data_store_id="data-store",
            display_name="Structured datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_CHAT"])
        test_data_store2 = gcp.discoveryengine.DataStore("test_data_store_2",
            location=test_data_store.location,
            data_store_id="data-store-2",
            display_name="Structured datastore 2",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_CHAT"])
        primary = gcp.discoveryengine.ChatEngine("primary",
            engine_id="chat-engine-id",
            collection_id="default_collection",
            location=test_data_store.location,
            display_name="Chat engine",
            industry_vertical="GENERIC",
            data_store_ids=[
                test_data_store.data_store_id,
                test_data_store2.data_store_id,
            ],
            common_config={
                "company_name": "test-company",
            },
            chat_engine_config={
                "agent_creation_config": {
                    "business": "test business name",
                    "default_language_code": "en",
                    "time_zone": "America/Los_Angeles",
                },
            })
        ```

        ## Import

        ChatEngine can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}`

        * `{{project}}/{{location}}/{{collection_id}}/{{engine_id}}`

        * `{{location}}/{{collection_id}}/{{engine_id}}`

        When using the `pulumi import` command, ChatEngine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/chatEngine:ChatEngine default projects/{{project}}/locations/{{location}}/collections/{{collection_id}}/engines/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/chatEngine:ChatEngine default {{project}}/{{location}}/{{collection_id}}/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/chatEngine:ChatEngine default {{location}}/{{collection_id}}/{{engine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ChatEngineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChatEngineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chat_engine_config: Optional[pulumi.Input[Union['ChatEngineChatEngineConfigArgs', 'ChatEngineChatEngineConfigArgsDict']]] = None,
                 collection_id: Optional[pulumi.Input[str]] = None,
                 common_config: Optional[pulumi.Input[Union['ChatEngineCommonConfigArgs', 'ChatEngineCommonConfigArgsDict']]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 engine_id: Optional[pulumi.Input[str]] = None,
                 industry_vertical: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChatEngineArgs.__new__(ChatEngineArgs)

            if chat_engine_config is None and not opts.urn:
                raise TypeError("Missing required property 'chat_engine_config'")
            __props__.__dict__["chat_engine_config"] = chat_engine_config
            if collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'collection_id'")
            __props__.__dict__["collection_id"] = collection_id
            __props__.__dict__["common_config"] = common_config
            if data_store_ids is None and not opts.urn:
                raise TypeError("Missing required property 'data_store_ids'")
            __props__.__dict__["data_store_ids"] = data_store_ids
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if engine_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_id'")
            __props__.__dict__["engine_id"] = engine_id
            __props__.__dict__["industry_vertical"] = industry_vertical
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["chat_engine_metadatas"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(ChatEngine, __self__).__init__(
            'gcp:discoveryengine/chatEngine:ChatEngine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            chat_engine_config: Optional[pulumi.Input[Union['ChatEngineChatEngineConfigArgs', 'ChatEngineChatEngineConfigArgsDict']]] = None,
            chat_engine_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChatEngineChatEngineMetadataArgs', 'ChatEngineChatEngineMetadataArgsDict']]]]] = None,
            collection_id: Optional[pulumi.Input[str]] = None,
            common_config: Optional[pulumi.Input[Union['ChatEngineCommonConfigArgs', 'ChatEngineCommonConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            engine_id: Optional[pulumi.Input[str]] = None,
            industry_vertical: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'ChatEngine':
        """
        Get an existing ChatEngine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ChatEngineChatEngineConfigArgs', 'ChatEngineChatEngineConfigArgsDict']] chat_engine_config: Configurations for a chat Engine.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChatEngineChatEngineMetadataArgs', 'ChatEngineChatEngineMetadataArgsDict']]]] chat_engine_metadatas: Additional information of the Chat Engine.
               Structure is documented below.
        :param pulumi.Input[str] collection_id: The collection ID.
        :param pulumi.Input[Union['ChatEngineCommonConfigArgs', 'ChatEngineCommonConfigArgsDict']] common_config: Common config spec that specifies the metadata of the engine.
        :param pulumi.Input[str] create_time: Timestamp the Engine was created at.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_store_ids: The data stores associated with this engine. Multiple DataStores in the same Collection can be associated here. All listed DataStores must be `SOLUTION_TYPE_CHAT`. Adding or removing data stores will force recreation.
        :param pulumi.Input[str] display_name: The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[str] engine_id: The ID to use for chat engine.
        :param pulumi.Input[str] industry_vertical: The industry vertical that the chat engine registers. Vertical on Engine has to match vertical of the DataStore linked
               to the engine. Default value: "GENERIC" Possible values: ["GENERIC"]
        :param pulumi.Input[str] location: Location.
        :param pulumi.Input[str] name: The unique full resource name of the chat engine. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024
               characters.
        :param pulumi.Input[str] update_time: Timestamp the Engine was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChatEngineState.__new__(_ChatEngineState)

        __props__.__dict__["chat_engine_config"] = chat_engine_config
        __props__.__dict__["chat_engine_metadatas"] = chat_engine_metadatas
        __props__.__dict__["collection_id"] = collection_id
        __props__.__dict__["common_config"] = common_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_store_ids"] = data_store_ids
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["engine_id"] = engine_id
        __props__.__dict__["industry_vertical"] = industry_vertical
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return ChatEngine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="chatEngineConfig")
    def chat_engine_config(self) -> pulumi.Output['outputs.ChatEngineChatEngineConfig']:
        """
        Configurations for a chat Engine.
        Structure is documented below.
        """
        return pulumi.get(self, "chat_engine_config")

    @property
    @pulumi.getter(name="chatEngineMetadatas")
    def chat_engine_metadatas(self) -> pulumi.Output[Sequence['outputs.ChatEngineChatEngineMetadata']]:
        """
        Additional information of the Chat Engine.
        Structure is documented below.
        """
        return pulumi.get(self, "chat_engine_metadatas")

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Output[str]:
        """
        The collection ID.
        """
        return pulumi.get(self, "collection_id")

    @property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> pulumi.Output[Optional['outputs.ChatEngineCommonConfig']]:
        """
        Common config spec that specifies the metadata of the engine.
        """
        return pulumi.get(self, "common_config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Timestamp the Engine was created at.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The data stores associated with this engine. Multiple DataStores in the same Collection can be associated here. All listed DataStores must be `SOLUTION_TYPE_CHAT`. Adding or removing data stores will force recreation.
        """
        return pulumi.get(self, "data_store_ids")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Output[str]:
        """
        The ID to use for chat engine.
        """
        return pulumi.get(self, "engine_id")

    @property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> pulumi.Output[Optional[str]]:
        """
        The industry vertical that the chat engine registers. Vertical on Engine has to match vertical of the DataStore linked
        to the engine. Default value: "GENERIC" Possible values: ["GENERIC"]
        """
        return pulumi.get(self, "industry_vertical")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique full resource name of the chat engine. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection_id}/engines/{engine_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024
        characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Timestamp the Engine was last updated.
        """
        return pulumi.get(self, "update_time")

