# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterAuthorizationArgs',
    'ClusterAuthorizationArgsDict',
    'ClusterAuthorizationAdminUsersArgs',
    'ClusterAuthorizationAdminUsersArgsDict',
    'ClusterControlPlaneArgs',
    'ClusterControlPlaneArgsDict',
    'ClusterControlPlaneEncryptionArgs',
    'ClusterControlPlaneEncryptionArgsDict',
    'ClusterControlPlaneEncryptionKmsStatusArgs',
    'ClusterControlPlaneEncryptionKmsStatusArgsDict',
    'ClusterControlPlaneLocalArgs',
    'ClusterControlPlaneLocalArgsDict',
    'ClusterControlPlaneRemoteArgs',
    'ClusterControlPlaneRemoteArgsDict',
    'ClusterFleetArgs',
    'ClusterFleetArgsDict',
    'ClusterMaintenanceEventArgs',
    'ClusterMaintenanceEventArgsDict',
    'ClusterMaintenancePolicyArgs',
    'ClusterMaintenancePolicyArgsDict',
    'ClusterMaintenancePolicyMaintenanceExclusionArgs',
    'ClusterMaintenancePolicyMaintenanceExclusionArgsDict',
    'ClusterMaintenancePolicyMaintenanceExclusionWindowArgs',
    'ClusterMaintenancePolicyMaintenanceExclusionWindowArgsDict',
    'ClusterMaintenancePolicyWindowArgs',
    'ClusterMaintenancePolicyWindowArgsDict',
    'ClusterMaintenancePolicyWindowRecurringWindowArgs',
    'ClusterMaintenancePolicyWindowRecurringWindowArgsDict',
    'ClusterMaintenancePolicyWindowRecurringWindowWindowArgs',
    'ClusterMaintenancePolicyWindowRecurringWindowWindowArgsDict',
    'ClusterNetworkingArgs',
    'ClusterNetworkingArgsDict',
    'ClusterSystemAddonsConfigArgs',
    'ClusterSystemAddonsConfigArgsDict',
    'ClusterSystemAddonsConfigIngressArgs',
    'ClusterSystemAddonsConfigIngressArgsDict',
    'NodePoolLocalDiskEncryptionArgs',
    'NodePoolLocalDiskEncryptionArgsDict',
    'NodePoolNodeConfigArgs',
    'NodePoolNodeConfigArgsDict',
    'VpnConnectionDetailArgs',
    'VpnConnectionDetailArgsDict',
    'VpnConnectionDetailCloudRouterArgs',
    'VpnConnectionDetailCloudRouterArgsDict',
    'VpnConnectionDetailCloudVpnArgs',
    'VpnConnectionDetailCloudVpnArgsDict',
    'VpnConnectionVpcProjectArgs',
    'VpnConnectionVpcProjectArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterAuthorizationArgsDict(TypedDict):
        admin_users: pulumi.Input['ClusterAuthorizationAdminUsersArgsDict']
        """
        User that will be granted the cluster-admin role on the cluster, providing
        full access to the cluster. Currently, this is a singular field, but will
        be expanded to allow multiple admins in the future.
        Structure is documented below.
        """
elif False:
    ClusterAuthorizationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAuthorizationArgs:
    def __init__(__self__, *,
                 admin_users: pulumi.Input['ClusterAuthorizationAdminUsersArgs']):
        """
        :param pulumi.Input['ClusterAuthorizationAdminUsersArgs'] admin_users: User that will be granted the cluster-admin role on the cluster, providing
               full access to the cluster. Currently, this is a singular field, but will
               be expanded to allow multiple admins in the future.
               Structure is documented below.
        """
        pulumi.set(__self__, "admin_users", admin_users)

    @property
    @pulumi.getter(name="adminUsers")
    def admin_users(self) -> pulumi.Input['ClusterAuthorizationAdminUsersArgs']:
        """
        User that will be granted the cluster-admin role on the cluster, providing
        full access to the cluster. Currently, this is a singular field, but will
        be expanded to allow multiple admins in the future.
        Structure is documented below.
        """
        return pulumi.get(self, "admin_users")

    @admin_users.setter
    def admin_users(self, value: pulumi.Input['ClusterAuthorizationAdminUsersArgs']):
        pulumi.set(self, "admin_users", value)


if not MYPY:
    class ClusterAuthorizationAdminUsersArgsDict(TypedDict):
        username: pulumi.Input[str]
        """
        An active Google username.

        - - -
        """
elif False:
    ClusterAuthorizationAdminUsersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAuthorizationAdminUsersArgs:
    def __init__(__self__, *,
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] username: An active Google username.
               
               - - -
        """
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        An active Google username.

        - - -
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ClusterControlPlaneArgsDict(TypedDict):
        local: NotRequired[pulumi.Input['ClusterControlPlaneLocalArgsDict']]
        """
        Local control plane configuration.
        Structure is documented below.
        """
        remote: NotRequired[pulumi.Input['ClusterControlPlaneRemoteArgsDict']]
        """
        Remote control plane configuration.
        Structure is documented below.
        """
elif False:
    ClusterControlPlaneArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterControlPlaneArgs:
    def __init__(__self__, *,
                 local: Optional[pulumi.Input['ClusterControlPlaneLocalArgs']] = None,
                 remote: Optional[pulumi.Input['ClusterControlPlaneRemoteArgs']] = None):
        """
        :param pulumi.Input['ClusterControlPlaneLocalArgs'] local: Local control plane configuration.
               Structure is documented below.
        :param pulumi.Input['ClusterControlPlaneRemoteArgs'] remote: Remote control plane configuration.
               Structure is documented below.
        """
        if local is not None:
            pulumi.set(__self__, "local", local)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input['ClusterControlPlaneLocalArgs']]:
        """
        Local control plane configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input['ClusterControlPlaneLocalArgs']]):
        pulumi.set(self, "local", value)

    @property
    @pulumi.getter
    def remote(self) -> Optional[pulumi.Input['ClusterControlPlaneRemoteArgs']]:
        """
        Remote control plane configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "remote")

    @remote.setter
    def remote(self, value: Optional[pulumi.Input['ClusterControlPlaneRemoteArgs']]):
        pulumi.set(self, "remote", value)


if not MYPY:
    class ClusterControlPlaneEncryptionArgsDict(TypedDict):
        kms_key: NotRequired[pulumi.Input[str]]
        """
        The Cloud KMS CryptoKey e.g.
        projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
        to use for protecting control plane disks. If not specified, a
        Google-managed key will be used instead.
        """
        kms_key_active_version: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The Cloud KMS CryptoKeyVersion currently in use for protecting control
        plane disks. Only applicable if kms_key is set.
        """
        kms_key_state: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
        nodes may go offline as they cannot access their local data. This can be
        caused by a lack of permissions to use the key, or if the key is disabled
        or deleted.
        """
        kms_statuses: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterControlPlaneEncryptionKmsStatusArgsDict']]]]
        """
        (Output)
        Error status returned by Cloud KMS when using this key. This field may be
        populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
        If populated, this field contains the error status reported by Cloud KMS.
        Structure is documented below.


        <a name="nested_kms_status"></a>The `kms_status` block contains:
        """
elif False:
    ClusterControlPlaneEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterControlPlaneEncryptionArgs:
    def __init__(__self__, *,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 kms_key_active_version: Optional[pulumi.Input[str]] = None,
                 kms_key_state: Optional[pulumi.Input[str]] = None,
                 kms_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterControlPlaneEncryptionKmsStatusArgs']]]] = None):
        """
        :param pulumi.Input[str] kms_key: The Cloud KMS CryptoKey e.g.
               projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
               to use for protecting control plane disks. If not specified, a
               Google-managed key will be used instead.
        :param pulumi.Input[str] kms_key_active_version: (Output)
               The Cloud KMS CryptoKeyVersion currently in use for protecting control
               plane disks. Only applicable if kms_key is set.
        :param pulumi.Input[str] kms_key_state: (Output)
               Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
               nodes may go offline as they cannot access their local data. This can be
               caused by a lack of permissions to use the key, or if the key is disabled
               or deleted.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterControlPlaneEncryptionKmsStatusArgs']]] kms_statuses: (Output)
               Error status returned by Cloud KMS when using this key. This field may be
               populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
               If populated, this field contains the error status reported by Cloud KMS.
               Structure is documented below.
               
               
               <a name="nested_kms_status"></a>The `kms_status` block contains:
        """
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if kms_key_active_version is not None:
            pulumi.set(__self__, "kms_key_active_version", kms_key_active_version)
        if kms_key_state is not None:
            pulumi.set(__self__, "kms_key_state", kms_key_state)
        if kms_statuses is not None:
            pulumi.set(__self__, "kms_statuses", kms_statuses)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud KMS CryptoKey e.g.
        projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
        to use for protecting control plane disks. If not specified, a
        Google-managed key will be used instead.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter(name="kmsKeyActiveVersion")
    def kms_key_active_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The Cloud KMS CryptoKeyVersion currently in use for protecting control
        plane disks. Only applicable if kms_key is set.
        """
        return pulumi.get(self, "kms_key_active_version")

    @kms_key_active_version.setter
    def kms_key_active_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_active_version", value)

    @property
    @pulumi.getter(name="kmsKeyState")
    def kms_key_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Availability of the Cloud KMS CryptoKey. If not `KEY_AVAILABLE`, then
        nodes may go offline as they cannot access their local data. This can be
        caused by a lack of permissions to use the key, or if the key is disabled
        or deleted.
        """
        return pulumi.get(self, "kms_key_state")

    @kms_key_state.setter
    def kms_key_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_state", value)

    @property
    @pulumi.getter(name="kmsStatuses")
    def kms_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterControlPlaneEncryptionKmsStatusArgs']]]]:
        """
        (Output)
        Error status returned by Cloud KMS when using this key. This field may be
        populated only if `kms_key_state` is not `KMS_KEY_STATE_KEY_AVAILABLE`.
        If populated, this field contains the error status reported by Cloud KMS.
        Structure is documented below.


        <a name="nested_kms_status"></a>The `kms_status` block contains:
        """
        return pulumi.get(self, "kms_statuses")

    @kms_statuses.setter
    def kms_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterControlPlaneEncryptionKmsStatusArgs']]]]):
        pulumi.set(self, "kms_statuses", value)


if not MYPY:
    class ClusterControlPlaneEncryptionKmsStatusArgsDict(TypedDict):
        code: NotRequired[pulumi.Input[int]]
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        message: NotRequired[pulumi.Input[str]]
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
elif False:
    ClusterControlPlaneEncryptionKmsStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterControlPlaneEncryptionKmsStatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] code: The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[str] message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


if not MYPY:
    class ClusterControlPlaneLocalArgsDict(TypedDict):
        machine_filter: NotRequired[pulumi.Input[str]]
        """
        Only machines matching this filter will be allowed to host control
        plane nodes. The filtering language accepts strings like "name=<name>",
        and is documented here: [AIP-160](https://google.aip.dev/160).
        """
        node_count: NotRequired[pulumi.Input[int]]
        """
        The number of nodes to serve as replicas of the Control Plane.
        Only 1 and 3 are supported.
        """
        node_location: NotRequired[pulumi.Input[str]]
        """
        Name of the Google Distributed Cloud Edge zones where this node pool
        will be created. For example: `us-central1-edge-customer-a`.
        """
        shared_deployment_policy: NotRequired[pulumi.Input[str]]
        """
        Policy configuration about how user applications are deployed.
        Possible values are: `SHARED_DEPLOYMENT_POLICY_UNSPECIFIED`, `ALLOWED`, `DISALLOWED`.
        """
elif False:
    ClusterControlPlaneLocalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterControlPlaneLocalArgs:
    def __init__(__self__, *,
                 machine_filter: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_location: Optional[pulumi.Input[str]] = None,
                 shared_deployment_policy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] machine_filter: Only machines matching this filter will be allowed to host control
               plane nodes. The filtering language accepts strings like "name=<name>",
               and is documented here: [AIP-160](https://google.aip.dev/160).
        :param pulumi.Input[int] node_count: The number of nodes to serve as replicas of the Control Plane.
               Only 1 and 3 are supported.
        :param pulumi.Input[str] node_location: Name of the Google Distributed Cloud Edge zones where this node pool
               will be created. For example: `us-central1-edge-customer-a`.
        :param pulumi.Input[str] shared_deployment_policy: Policy configuration about how user applications are deployed.
               Possible values are: `SHARED_DEPLOYMENT_POLICY_UNSPECIFIED`, `ALLOWED`, `DISALLOWED`.
        """
        if machine_filter is not None:
            pulumi.set(__self__, "machine_filter", machine_filter)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_location is not None:
            pulumi.set(__self__, "node_location", node_location)
        if shared_deployment_policy is not None:
            pulumi.set(__self__, "shared_deployment_policy", shared_deployment_policy)

    @property
    @pulumi.getter(name="machineFilter")
    def machine_filter(self) -> Optional[pulumi.Input[str]]:
        """
        Only machines matching this filter will be allowed to host control
        plane nodes. The filtering language accepts strings like "name=<name>",
        and is documented here: [AIP-160](https://google.aip.dev/160).
        """
        return pulumi.get(self, "machine_filter")

    @machine_filter.setter
    def machine_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_filter", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes to serve as replicas of the Control Plane.
        Only 1 and 3 are supported.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeLocation")
    def node_location(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Google Distributed Cloud Edge zones where this node pool
        will be created. For example: `us-central1-edge-customer-a`.
        """
        return pulumi.get(self, "node_location")

    @node_location.setter
    def node_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_location", value)

    @property
    @pulumi.getter(name="sharedDeploymentPolicy")
    def shared_deployment_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Policy configuration about how user applications are deployed.
        Possible values are: `SHARED_DEPLOYMENT_POLICY_UNSPECIFIED`, `ALLOWED`, `DISALLOWED`.
        """
        return pulumi.get(self, "shared_deployment_policy")

    @shared_deployment_policy.setter
    def shared_deployment_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_deployment_policy", value)


if not MYPY:
    class ClusterControlPlaneRemoteArgsDict(TypedDict):
        node_location: NotRequired[pulumi.Input[str]]
        """
        Name of the Google Distributed Cloud Edge zones where this node pool
        will be created. For example: `us-central1-edge-customer-a`.
        """
elif False:
    ClusterControlPlaneRemoteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterControlPlaneRemoteArgs:
    def __init__(__self__, *,
                 node_location: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] node_location: Name of the Google Distributed Cloud Edge zones where this node pool
               will be created. For example: `us-central1-edge-customer-a`.
        """
        if node_location is not None:
            pulumi.set(__self__, "node_location", node_location)

    @property
    @pulumi.getter(name="nodeLocation")
    def node_location(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Google Distributed Cloud Edge zones where this node pool
        will be created. For example: `us-central1-edge-customer-a`.
        """
        return pulumi.get(self, "node_location")

    @node_location.setter
    def node_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_location", value)


if not MYPY:
    class ClusterFleetArgsDict(TypedDict):
        project: pulumi.Input[str]
        """
        The name of the Fleet host project where this cluster will be registered.
        Project names are formatted as
        `projects/<project-number>`.
        """
        membership: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The name of the managed Hub Membership resource associated to this cluster.
        Membership names are formatted as
        `projects/<project-number>/locations/global/membership/<cluster-id>`.
        """
elif False:
    ClusterFleetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterFleetArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 membership: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] project: The name of the Fleet host project where this cluster will be registered.
               Project names are formatted as
               `projects/<project-number>`.
        :param pulumi.Input[str] membership: (Output)
               The name of the managed Hub Membership resource associated to this cluster.
               Membership names are formatted as
               `projects/<project-number>/locations/global/membership/<cluster-id>`.
        """
        pulumi.set(__self__, "project", project)
        if membership is not None:
            pulumi.set(__self__, "membership", membership)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The name of the Fleet host project where this cluster will be registered.
        Project names are formatted as
        `projects/<project-number>`.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def membership(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The name of the managed Hub Membership resource associated to this cluster.
        Membership names are formatted as
        `projects/<project-number>/locations/global/membership/<cluster-id>`.
        """
        return pulumi.get(self, "membership")

    @membership.setter
    def membership(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "membership", value)


if not MYPY:
    class ClusterMaintenanceEventArgsDict(TypedDict):
        create_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The time when the maintenance event request was created.
        """
        end_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The time when the maintenance event ended, either successfully or not. If
        the maintenance event is split into multiple maintenance windows,
        end_time is only updated when the whole flow ends.
        """
        operation: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The operation for running the maintenance event. Specified in the format
        projects/*/locations/*/operations/*. If the maintenance event is split
        into multiple operations (e.g. due to maintenance windows), the latest
        one is recorded.
        """
        schedule: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The schedule of the maintenance event.
        """
        start_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The time when the maintenance event started.
        """
        state: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Indicates the maintenance event state.
        """
        target_version: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The target version of the cluster.
        """
        type: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Indicates the maintenance event type.
        """
        update_time: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The time when the maintenance event message was updated.
        """
        uuid: NotRequired[pulumi.Input[str]]
        """
        (Output)
        UUID of the maintenance event.
        """
elif False:
    ClusterMaintenanceEventArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenanceEventArgs:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create_time: (Output)
               The time when the maintenance event request was created.
        :param pulumi.Input[str] end_time: (Output)
               The time when the maintenance event ended, either successfully or not. If
               the maintenance event is split into multiple maintenance windows,
               end_time is only updated when the whole flow ends.
        :param pulumi.Input[str] operation: (Output)
               The operation for running the maintenance event. Specified in the format
               projects/*/locations/*/operations/*. If the maintenance event is split
               into multiple operations (e.g. due to maintenance windows), the latest
               one is recorded.
        :param pulumi.Input[str] schedule: (Output)
               The schedule of the maintenance event.
        :param pulumi.Input[str] start_time: (Output)
               The time when the maintenance event started.
        :param pulumi.Input[str] state: (Output)
               Indicates the maintenance event state.
        :param pulumi.Input[str] target_version: (Output)
               The target version of the cluster.
        :param pulumi.Input[str] type: (Output)
               Indicates the maintenance event type.
        :param pulumi.Input[str] update_time: (Output)
               The time when the maintenance event message was updated.
        :param pulumi.Input[str] uuid: (Output)
               UUID of the maintenance event.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The time when the maintenance event request was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The time when the maintenance event ended, either successfully or not. If
        the maintenance event is split into multiple maintenance windows,
        end_time is only updated when the whole flow ends.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The operation for running the maintenance event. Specified in the format
        projects/*/locations/*/operations/*. If the maintenance event is split
        into multiple operations (e.g. due to maintenance windows), the latest
        one is recorded.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The schedule of the maintenance event.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The time when the maintenance event started.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Indicates the maintenance event state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The target version of the cluster.
        """
        return pulumi.get(self, "target_version")

    @target_version.setter
    def target_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_version", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Indicates the maintenance event type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The time when the maintenance event message was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        UUID of the maintenance event.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)


if not MYPY:
    class ClusterMaintenancePolicyArgsDict(TypedDict):
        window: pulumi.Input['ClusterMaintenancePolicyWindowArgsDict']
        """
        Specifies the maintenance window in which maintenance may be performed.
        Structure is documented below.
        """
        maintenance_exclusions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionArgsDict']]]]
        """
        Exclusions to automatic maintenance. Non-emergency maintenance should not occur
        in these windows. Each exclusion has a unique name and may be active or expired.
        The max number of maintenance exclusions allowed at a given time is 3.
        Structure is documented below.
        """
elif False:
    ClusterMaintenancePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyArgs:
    def __init__(__self__, *,
                 window: pulumi.Input['ClusterMaintenancePolicyWindowArgs'],
                 maintenance_exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionArgs']]]] = None):
        """
        :param pulumi.Input['ClusterMaintenancePolicyWindowArgs'] window: Specifies the maintenance window in which maintenance may be performed.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionArgs']]] maintenance_exclusions: Exclusions to automatic maintenance. Non-emergency maintenance should not occur
               in these windows. Each exclusion has a unique name and may be active or expired.
               The max number of maintenance exclusions allowed at a given time is 3.
               Structure is documented below.
        """
        pulumi.set(__self__, "window", window)
        if maintenance_exclusions is not None:
            pulumi.set(__self__, "maintenance_exclusions", maintenance_exclusions)

    @property
    @pulumi.getter
    def window(self) -> pulumi.Input['ClusterMaintenancePolicyWindowArgs']:
        """
        Specifies the maintenance window in which maintenance may be performed.
        Structure is documented below.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: pulumi.Input['ClusterMaintenancePolicyWindowArgs']):
        pulumi.set(self, "window", value)

    @property
    @pulumi.getter(name="maintenanceExclusions")
    def maintenance_exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionArgs']]]]:
        """
        Exclusions to automatic maintenance. Non-emergency maintenance should not occur
        in these windows. Each exclusion has a unique name and may be active or expired.
        The max number of maintenance exclusions allowed at a given time is 3.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_exclusions")

    @maintenance_exclusions.setter
    def maintenance_exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionArgs']]]]):
        pulumi.set(self, "maintenance_exclusions", value)


if not MYPY:
    class ClusterMaintenancePolicyMaintenanceExclusionArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[str]]
        """
        A unique (per cluster) id for the window.
        """
        window: NotRequired[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionWindowArgsDict']]
        """
        Represents an arbitrary window of time.
        Structure is documented below.
        """
elif False:
    ClusterMaintenancePolicyMaintenanceExclusionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyMaintenanceExclusionArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 window: Optional[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionWindowArgs']] = None):
        """
        :param pulumi.Input[str] id: A unique (per cluster) id for the window.
        :param pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionWindowArgs'] window: Represents an arbitrary window of time.
               Structure is documented below.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique (per cluster) id for the window.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionWindowArgs']]:
        """
        Represents an arbitrary window of time.
        Structure is documented below.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input['ClusterMaintenancePolicyMaintenanceExclusionWindowArgs']]):
        pulumi.set(self, "window", value)


if not MYPY:
    class ClusterMaintenancePolicyMaintenanceExclusionWindowArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[str]]
        """
        The time that the window ends. The end time must take place after the
        start time.
        """
        start_time: NotRequired[pulumi.Input[str]]
        """
        The time that the window first starts.
        """
elif False:
    ClusterMaintenancePolicyMaintenanceExclusionWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyMaintenanceExclusionWindowArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_time: The time that the window ends. The end time must take place after the
               start time.
        :param pulumi.Input[str] start_time: The time that the window first starts.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the window ends. The end time must take place after the
        start time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the window first starts.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ClusterMaintenancePolicyWindowArgsDict(TypedDict):
        recurring_window: pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowArgsDict']
        """
        Represents an arbitrary window of time that recurs.
        Structure is documented below.
        """
elif False:
    ClusterMaintenancePolicyWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyWindowArgs:
    def __init__(__self__, *,
                 recurring_window: pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowArgs']):
        """
        :param pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowArgs'] recurring_window: Represents an arbitrary window of time that recurs.
               Structure is documented below.
        """
        pulumi.set(__self__, "recurring_window", recurring_window)

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowArgs']:
        """
        Represents an arbitrary window of time that recurs.
        Structure is documented below.
        """
        return pulumi.get(self, "recurring_window")

    @recurring_window.setter
    def recurring_window(self, value: pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowArgs']):
        pulumi.set(self, "recurring_window", value)


if not MYPY:
    class ClusterMaintenancePolicyWindowRecurringWindowArgsDict(TypedDict):
        recurrence: NotRequired[pulumi.Input[str]]
        """
        An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
        this window recurs. They go on for the span of time between the start and
        end time.
        """
        window: NotRequired[pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowWindowArgsDict']]
        """
        Represents an arbitrary window of time.
        Structure is documented below.
        """
elif False:
    ClusterMaintenancePolicyWindowRecurringWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyWindowRecurringWindowArgs:
    def __init__(__self__, *,
                 recurrence: Optional[pulumi.Input[str]] = None,
                 window: Optional[pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowWindowArgs']] = None):
        """
        :param pulumi.Input[str] recurrence: An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
               this window recurs. They go on for the span of time between the start and
               end time.
        :param pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowWindowArgs'] window: Represents an arbitrary window of time.
               Structure is documented below.
        """
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input[str]]:
        """
        An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
        this window recurs. They go on for the span of time between the start and
        end time.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowWindowArgs']]:
        """
        Represents an arbitrary window of time.
        Structure is documented below.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input['ClusterMaintenancePolicyWindowRecurringWindowWindowArgs']]):
        pulumi.set(self, "window", value)


if not MYPY:
    class ClusterMaintenancePolicyWindowRecurringWindowWindowArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[str]]
        """
        The time that the window ends. The end time must take place after the
        start time.
        """
        start_time: NotRequired[pulumi.Input[str]]
        """
        The time that the window first starts.
        """
elif False:
    ClusterMaintenancePolicyWindowRecurringWindowWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintenancePolicyWindowRecurringWindowWindowArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_time: The time that the window ends. The end time must take place after the
               start time.
        :param pulumi.Input[str] start_time: The time that the window first starts.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the window ends. The end time must take place after the
        start time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the window first starts.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ClusterNetworkingArgsDict(TypedDict):
        cluster_ipv4_cidr_blocks: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        All pods in the cluster are assigned an RFC1918 IPv4 address from these
        blocks. Only a single block is supported. This field cannot be changed
        after creation.
        """
        services_ipv4_cidr_blocks: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        All services in the cluster are assigned an RFC1918 IPv4 address from these
        blocks. Only a single block is supported. This field cannot be changed
        after creation.
        """
        cluster_ipv6_cidr_blocks: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        If specified, dual stack mode is enabled and all pods in the cluster are
        assigned an IPv6 address from these blocks alongside from an IPv4
        address. Only a single block is supported. This field cannot be changed
        after creation.
        """
        network_type: NotRequired[pulumi.Input[str]]
        """
        (Output)
        IP addressing type of this cluster i.e. SINGLESTACK_V4 vs DUALSTACK_V4_V6.
        """
        services_ipv6_cidr_blocks: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        If specified, dual stack mode is enabled and all services in the cluster are
        assigned an IPv6 address from these blocks alongside from an IPv4
        address. Only a single block is supported. This field cannot be changed
        after creation.
        """
elif False:
    ClusterNetworkingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNetworkingArgs:
    def __init__(__self__, *,
                 cluster_ipv4_cidr_blocks: pulumi.Input[Sequence[pulumi.Input[str]]],
                 services_ipv4_cidr_blocks: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cluster_ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 services_ipv6_cidr_blocks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_ipv4_cidr_blocks: All pods in the cluster are assigned an RFC1918 IPv4 address from these
               blocks. Only a single block is supported. This field cannot be changed
               after creation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] services_ipv4_cidr_blocks: All services in the cluster are assigned an RFC1918 IPv4 address from these
               blocks. Only a single block is supported. This field cannot be changed
               after creation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_ipv6_cidr_blocks: If specified, dual stack mode is enabled and all pods in the cluster are
               assigned an IPv6 address from these blocks alongside from an IPv4
               address. Only a single block is supported. This field cannot be changed
               after creation.
        :param pulumi.Input[str] network_type: (Output)
               IP addressing type of this cluster i.e. SINGLESTACK_V4 vs DUALSTACK_V4_V6.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] services_ipv6_cidr_blocks: If specified, dual stack mode is enabled and all services in the cluster are
               assigned an IPv6 address from these blocks alongside from an IPv4
               address. Only a single block is supported. This field cannot be changed
               after creation.
        """
        pulumi.set(__self__, "cluster_ipv4_cidr_blocks", cluster_ipv4_cidr_blocks)
        pulumi.set(__self__, "services_ipv4_cidr_blocks", services_ipv4_cidr_blocks)
        if cluster_ipv6_cidr_blocks is not None:
            pulumi.set(__self__, "cluster_ipv6_cidr_blocks", cluster_ipv6_cidr_blocks)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if services_ipv6_cidr_blocks is not None:
            pulumi.set(__self__, "services_ipv6_cidr_blocks", services_ipv6_cidr_blocks)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlocks")
    def cluster_ipv4_cidr_blocks(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        All pods in the cluster are assigned an RFC1918 IPv4 address from these
        blocks. Only a single block is supported. This field cannot be changed
        after creation.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_blocks")

    @cluster_ipv4_cidr_blocks.setter
    def cluster_ipv4_cidr_blocks(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "cluster_ipv4_cidr_blocks", value)

    @property
    @pulumi.getter(name="servicesIpv4CidrBlocks")
    def services_ipv4_cidr_blocks(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        All services in the cluster are assigned an RFC1918 IPv4 address from these
        blocks. Only a single block is supported. This field cannot be changed
        after creation.
        """
        return pulumi.get(self, "services_ipv4_cidr_blocks")

    @services_ipv4_cidr_blocks.setter
    def services_ipv4_cidr_blocks(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "services_ipv4_cidr_blocks", value)

    @property
    @pulumi.getter(name="clusterIpv6CidrBlocks")
    def cluster_ipv6_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If specified, dual stack mode is enabled and all pods in the cluster are
        assigned an IPv6 address from these blocks alongside from an IPv4
        address. Only a single block is supported. This field cannot be changed
        after creation.
        """
        return pulumi.get(self, "cluster_ipv6_cidr_blocks")

    @cluster_ipv6_cidr_blocks.setter
    def cluster_ipv6_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_ipv6_cidr_blocks", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        IP addressing type of this cluster i.e. SINGLESTACK_V4 vs DUALSTACK_V4_V6.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="servicesIpv6CidrBlocks")
    def services_ipv6_cidr_blocks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If specified, dual stack mode is enabled and all services in the cluster are
        assigned an IPv6 address from these blocks alongside from an IPv4
        address. Only a single block is supported. This field cannot be changed
        after creation.
        """
        return pulumi.get(self, "services_ipv6_cidr_blocks")

    @services_ipv6_cidr_blocks.setter
    def services_ipv6_cidr_blocks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "services_ipv6_cidr_blocks", value)


if not MYPY:
    class ClusterSystemAddonsConfigArgsDict(TypedDict):
        ingress: NotRequired[pulumi.Input['ClusterSystemAddonsConfigIngressArgsDict']]
        """
        Config for the Ingress add-on which allows customers to create an Ingress
        object to manage external access to the servers in a cluster. The add-on
        consists of istiod and istio-ingress.
        Structure is documented below.
        """
elif False:
    ClusterSystemAddonsConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSystemAddonsConfigArgs:
    def __init__(__self__, *,
                 ingress: Optional[pulumi.Input['ClusterSystemAddonsConfigIngressArgs']] = None):
        """
        :param pulumi.Input['ClusterSystemAddonsConfigIngressArgs'] ingress: Config for the Ingress add-on which allows customers to create an Ingress
               object to manage external access to the servers in a cluster. The add-on
               consists of istiod and istio-ingress.
               Structure is documented below.
        """
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input['ClusterSystemAddonsConfigIngressArgs']]:
        """
        Config for the Ingress add-on which allows customers to create an Ingress
        object to manage external access to the servers in a cluster. The add-on
        consists of istiod and istio-ingress.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input['ClusterSystemAddonsConfigIngressArgs']]):
        pulumi.set(self, "ingress", value)


if not MYPY:
    class ClusterSystemAddonsConfigIngressArgsDict(TypedDict):
        disabled: NotRequired[pulumi.Input[bool]]
        """
        Whether Ingress is disabled.
        """
        ipv4_vip: NotRequired[pulumi.Input[str]]
        """
        Ingress VIP.
        """
elif False:
    ClusterSystemAddonsConfigIngressArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterSystemAddonsConfigIngressArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 ipv4_vip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] disabled: Whether Ingress is disabled.
        :param pulumi.Input[str] ipv4_vip: Ingress VIP.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if ipv4_vip is not None:
            pulumi.set(__self__, "ipv4_vip", ipv4_vip)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Ingress is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="ipv4Vip")
    def ipv4_vip(self) -> Optional[pulumi.Input[str]]:
        """
        Ingress VIP.
        """
        return pulumi.get(self, "ipv4_vip")

    @ipv4_vip.setter
    def ipv4_vip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_vip", value)


if not MYPY:
    class NodePoolLocalDiskEncryptionArgsDict(TypedDict):
        kms_key: NotRequired[pulumi.Input[str]]
        """
        The Cloud KMS CryptoKey e.g. projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey} to use for protecting node local disks.
        If not specified, a Google-managed key will be used instead.
        """
        kms_key_active_version: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The Cloud KMS CryptoKeyVersion currently in use for protecting node local disks. Only applicable if kmsKey is set.
        """
        kms_key_state: NotRequired[pulumi.Input[str]]
        """
        (Output)
        Availability of the Cloud KMS CryptoKey. If not KEY_AVAILABLE, then nodes may go offline as they cannot access their local data.
        This can be caused by a lack of permissions to use the key, or if the key is disabled or deleted.
        """
elif False:
    NodePoolLocalDiskEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodePoolLocalDiskEncryptionArgs:
    def __init__(__self__, *,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 kms_key_active_version: Optional[pulumi.Input[str]] = None,
                 kms_key_state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key: The Cloud KMS CryptoKey e.g. projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey} to use for protecting node local disks.
               If not specified, a Google-managed key will be used instead.
        :param pulumi.Input[str] kms_key_active_version: (Output)
               The Cloud KMS CryptoKeyVersion currently in use for protecting node local disks. Only applicable if kmsKey is set.
        :param pulumi.Input[str] kms_key_state: (Output)
               Availability of the Cloud KMS CryptoKey. If not KEY_AVAILABLE, then nodes may go offline as they cannot access their local data.
               This can be caused by a lack of permissions to use the key, or if the key is disabled or deleted.
        """
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if kms_key_active_version is not None:
            pulumi.set(__self__, "kms_key_active_version", kms_key_active_version)
        if kms_key_state is not None:
            pulumi.set(__self__, "kms_key_state", kms_key_state)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud KMS CryptoKey e.g. projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey} to use for protecting node local disks.
        If not specified, a Google-managed key will be used instead.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter(name="kmsKeyActiveVersion")
    def kms_key_active_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The Cloud KMS CryptoKeyVersion currently in use for protecting node local disks. Only applicable if kmsKey is set.
        """
        return pulumi.get(self, "kms_key_active_version")

    @kms_key_active_version.setter
    def kms_key_active_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_active_version", value)

    @property
    @pulumi.getter(name="kmsKeyState")
    def kms_key_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        Availability of the Cloud KMS CryptoKey. If not KEY_AVAILABLE, then nodes may go offline as they cannot access their local data.
        This can be caused by a lack of permissions to use the key, or if the key is disabled or deleted.
        """
        return pulumi.get(self, "kms_key_state")

    @kms_key_state.setter
    def kms_key_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_state", value)


if not MYPY:
    class NodePoolNodeConfigArgsDict(TypedDict):
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        "The Kubernetes node labels"
        """
elif False:
    NodePoolNodeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodePoolNodeConfigArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: "The Kubernetes node labels"
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        "The Kubernetes node labels"
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


if not MYPY:
    class VpnConnectionDetailArgsDict(TypedDict):
        cloud_routers: NotRequired[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudRouterArgsDict']]]]
        """
        (Output)
        The Cloud Router info.
        Structure is documented below.
        """
        cloud_vpns: NotRequired[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudVpnArgsDict']]]]
        """
        (Output)
        Each connection has multiple Cloud VPN gateways.
        Structure is documented below.
        """
        error: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The error message. This is only populated when state=ERROR.
        """
        state: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The current connection state.
        """
elif False:
    VpnConnectionDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpnConnectionDetailArgs:
    def __init__(__self__, *,
                 cloud_routers: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudRouterArgs']]]] = None,
                 cloud_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudVpnArgs']]]] = None,
                 error: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudRouterArgs']]] cloud_routers: (Output)
               The Cloud Router info.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudVpnArgs']]] cloud_vpns: (Output)
               Each connection has multiple Cloud VPN gateways.
               Structure is documented below.
        :param pulumi.Input[str] error: (Output)
               The error message. This is only populated when state=ERROR.
        :param pulumi.Input[str] state: (Output)
               The current connection state.
        """
        if cloud_routers is not None:
            pulumi.set(__self__, "cloud_routers", cloud_routers)
        if cloud_vpns is not None:
            pulumi.set(__self__, "cloud_vpns", cloud_vpns)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="cloudRouters")
    def cloud_routers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudRouterArgs']]]]:
        """
        (Output)
        The Cloud Router info.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_routers")

    @cloud_routers.setter
    def cloud_routers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudRouterArgs']]]]):
        pulumi.set(self, "cloud_routers", value)

    @property
    @pulumi.getter(name="cloudVpns")
    def cloud_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudVpnArgs']]]]:
        """
        (Output)
        Each connection has multiple Cloud VPN gateways.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_vpns")

    @cloud_vpns.setter
    def cloud_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionDetailCloudVpnArgs']]]]):
        pulumi.set(self, "cloud_vpns", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The error message. This is only populated when state=ERROR.
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The current connection state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class VpnConnectionDetailCloudRouterArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[str]]
        """
        The resource name of VPN connection
        """
elif False:
    VpnConnectionDetailCloudRouterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpnConnectionDetailCloudRouterArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The resource name of VPN connection
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of VPN connection
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class VpnConnectionDetailCloudVpnArgsDict(TypedDict):
        gateway: NotRequired[pulumi.Input[str]]
        """
        (Output)
        The created Cloud VPN gateway name.
        """
elif False:
    VpnConnectionDetailCloudVpnArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpnConnectionDetailCloudVpnArgs:
    def __init__(__self__, *,
                 gateway: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] gateway: (Output)
               The created Cloud VPN gateway name.
        """
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        (Output)
        The created Cloud VPN gateway name.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)


if not MYPY:
    class VpnConnectionVpcProjectArgsDict(TypedDict):
        project_id: NotRequired[pulumi.Input[str]]
        """
        The project of the VPC to connect to. If not specified, it is the same as the cluster project.
        """
elif False:
    VpnConnectionVpcProjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpnConnectionVpcProjectArgs:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] project_id: The project of the VPC to connect to. If not specified, it is the same as the cluster project.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The project of the VPC to connect to. If not specified, it is the same as the cluster project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


