# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubnetArgs', 'Subnet']

@pulumi.input_type
class SubnetArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 network: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 zone: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 ipv4_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Subnet resource.
        :param pulumi.Input[str] location: The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
        :param pulumi.Input[str] network: The ID of the network to which this router belongs.
               Must be of the form: `projects/{{project}}/locations/{{location}}/zones/{{zone}}/networks/{{network_id}}`
        :param pulumi.Input[str] subnet_id: A unique ID that identifies this subnet.
               
               
               - - -
        :param pulumi.Input[str] zone: The name of the target Distributed Cloud Edge zone.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv4_cidrs: The ranges of ipv4 addresses that are owned by this subnetwork, in CIDR format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_cidrs: The ranges of ipv6 addresses that are owned by this subnetwork, in CIDR format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels associated with this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[int] vlan_id: VLAN ID for this subnetwork. If not specified, one is assigned automatically.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "zone", zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ipv4_cidrs is not None:
            pulumi.set(__self__, "ipv4_cidrs", ipv4_cidrs)
        if ipv6_cidrs is not None:
            pulumi.set(__self__, "ipv6_cidrs", ipv6_cidrs)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        The ID of the network to which this router belongs.
        Must be of the form: `projects/{{project}}/locations/{{location}}/zones/{{zone}}/networks/{{network_id}}`
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        A unique ID that identifies this subnet.


        - - -
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[str]:
        """
        The name of the target Distributed Cloud Edge zone.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipv4Cidrs")
    def ipv4_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ranges of ipv4 addresses that are owned by this subnetwork, in CIDR format.
        """
        return pulumi.get(self, "ipv4_cidrs")

    @ipv4_cidrs.setter
    def ipv4_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv4_cidrs", value)

    @property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ranges of ipv6 addresses that are owned by this subnetwork, in CIDR format.
        """
        return pulumi.get(self, "ipv6_cidrs")

    @ipv6_cidrs.setter
    def ipv6_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_cidrs", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels associated with this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        VLAN ID for this subnetwork. If not specified, one is assigned automatically.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.input_type
class _SubnetState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ipv4_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Subnet resources.
        :param pulumi.Input[str] create_time: The time when the subnet was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv4_cidrs: The ranges of ipv4 addresses that are owned by this subnetwork, in CIDR format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_cidrs: The ranges of ipv6 addresses that are owned by this subnetwork, in CIDR format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels associated with this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
        :param pulumi.Input[str] name: The canonical name of this resource, with format
               `projects/{{project}}/locations/{{location}}/zones/{{zone}}/subnets/{{subnet_id}}`
        :param pulumi.Input[str] network: The ID of the network to which this router belongs.
               Must be of the form: `projects/{{project}}/locations/{{location}}/zones/{{zone}}/networks/{{network_id}}`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] state: Current stage of the resource to the device by config push.
        :param pulumi.Input[str] subnet_id: A unique ID that identifies this subnet.
               
               
               - - -
        :param pulumi.Input[str] update_time: The time when the subnet was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        :param pulumi.Input[int] vlan_id: VLAN ID for this subnetwork. If not specified, one is assigned automatically.
        :param pulumi.Input[str] zone: The name of the target Distributed Cloud Edge zone.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if ipv4_cidrs is not None:
            pulumi.set(__self__, "ipv4_cidrs", ipv4_cidrs)
        if ipv6_cidrs is not None:
            pulumi.set(__self__, "ipv6_cidrs", ipv6_cidrs)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the subnet was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="ipv4Cidrs")
    def ipv4_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ranges of ipv4 addresses that are owned by this subnetwork, in CIDR format.
        """
        return pulumi.get(self, "ipv4_cidrs")

    @ipv4_cidrs.setter
    def ipv4_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv4_cidrs", value)

    @property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ranges of ipv6 addresses that are owned by this subnetwork, in CIDR format.
        """
        return pulumi.get(self, "ipv6_cidrs")

    @ipv6_cidrs.setter
    def ipv6_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_cidrs", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels associated with this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical name of this resource, with format
        `projects/{{project}}/locations/{{location}}/zones/{{zone}}/subnets/{{subnet_id}}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the network to which this router belongs.
        Must be of the form: `projects/{{project}}/locations/{{location}}/zones/{{zone}}/networks/{{network_id}}`
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Current stage of the resource to the device by config push.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique ID that identifies this subnet.


        - - -
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the subnet was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        VLAN ID for this subnetwork. If not specified, one is assigned automatically.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target Distributed Cloud Edge zone.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Subnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ipv4_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Distributed Cloud Edge subnet, which provides L2 isolation within a network.

        To get more information about Subnet, see:

        * [API documentation](https://cloud.google.com/distributed-cloud/edge/latest/docs/reference/network/rest/v1/projects.locations.zones.subnets)
        * How-to Guides
            * [Create and manage subnetworks](https://cloud.google.com/distributed-cloud/edge/latest/docs/subnetworks#api)

        ## Example Usage

        ### Edgenetwork Subnet

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_network = gcp.edgenetwork.Network("example_network",
            network_id="example-network",
            location="us-west1",
            zone="",
            description="Example network.",
            mtu=9000)
        example_subnet = gcp.edgenetwork.Subnet("example_subnet",
            subnet_id="example-subnet",
            location="us-west1",
            zone="",
            description="Example subnet.",
            network=example_network.id,
            ipv4_cidrs=["4.4.4.1/24"],
            labels={
                "environment": "dev",
            })
        ```
        ### Edgenetwork Subnet With Vlan Id

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_network = gcp.edgenetwork.Network("example_network",
            network_id="example-network",
            location="us-west1",
            zone="",
            description="Example network.",
            mtu=9000)
        example_subnet_with_vlan_id = gcp.edgenetwork.Subnet("example_subnet_with_vlan_id",
            subnet_id="example-subnet-with-vlan-id",
            location="us-west1",
            zone="",
            description="Example subnet with VLAN ID.",
            network=example_network.id,
            ipv6_cidrs=["4444:4444:4444:4444::1/64"],
            vlan_id=44,
            labels={
                "environment": "dev",
            })
        ```

        ## Import

        Subnet can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/zones/{{zone}}/subnets/{{subnet_id}}`

        * `{{project}}/{{location}}/{{zone}}/{{subnet_id}}`

        * `{{location}}/{{zone}}/{{subnet_id}}`

        * `{{location}}/{{subnet_id}}`

        * `{{name}}`

        When using the `pulumi import` command, Subnet can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default projects/{{project}}/locations/{{location}}/zones/{{zone}}/subnets/{{subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default {{project}}/{{location}}/{{zone}}/{{subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default {{location}}/{{zone}}/{{subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default {{location}}/{{subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv4_cidrs: The ranges of ipv4 addresses that are owned by this subnetwork, in CIDR format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_cidrs: The ranges of ipv6 addresses that are owned by this subnetwork, in CIDR format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels associated with this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
        :param pulumi.Input[str] network: The ID of the network to which this router belongs.
               Must be of the form: `projects/{{project}}/locations/{{location}}/zones/{{zone}}/networks/{{network_id}}`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] subnet_id: A unique ID that identifies this subnet.
               
               
               - - -
        :param pulumi.Input[int] vlan_id: VLAN ID for this subnetwork. If not specified, one is assigned automatically.
        :param pulumi.Input[str] zone: The name of the target Distributed Cloud Edge zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Distributed Cloud Edge subnet, which provides L2 isolation within a network.

        To get more information about Subnet, see:

        * [API documentation](https://cloud.google.com/distributed-cloud/edge/latest/docs/reference/network/rest/v1/projects.locations.zones.subnets)
        * How-to Guides
            * [Create and manage subnetworks](https://cloud.google.com/distributed-cloud/edge/latest/docs/subnetworks#api)

        ## Example Usage

        ### Edgenetwork Subnet

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_network = gcp.edgenetwork.Network("example_network",
            network_id="example-network",
            location="us-west1",
            zone="",
            description="Example network.",
            mtu=9000)
        example_subnet = gcp.edgenetwork.Subnet("example_subnet",
            subnet_id="example-subnet",
            location="us-west1",
            zone="",
            description="Example subnet.",
            network=example_network.id,
            ipv4_cidrs=["4.4.4.1/24"],
            labels={
                "environment": "dev",
            })
        ```
        ### Edgenetwork Subnet With Vlan Id

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_network = gcp.edgenetwork.Network("example_network",
            network_id="example-network",
            location="us-west1",
            zone="",
            description="Example network.",
            mtu=9000)
        example_subnet_with_vlan_id = gcp.edgenetwork.Subnet("example_subnet_with_vlan_id",
            subnet_id="example-subnet-with-vlan-id",
            location="us-west1",
            zone="",
            description="Example subnet with VLAN ID.",
            network=example_network.id,
            ipv6_cidrs=["4444:4444:4444:4444::1/64"],
            vlan_id=44,
            labels={
                "environment": "dev",
            })
        ```

        ## Import

        Subnet can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/zones/{{zone}}/subnets/{{subnet_id}}`

        * `{{project}}/{{location}}/{{zone}}/{{subnet_id}}`

        * `{{location}}/{{zone}}/{{subnet_id}}`

        * `{{location}}/{{subnet_id}}`

        * `{{name}}`

        When using the `pulumi import` command, Subnet can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default projects/{{project}}/locations/{{location}}/zones/{{zone}}/subnets/{{subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default {{project}}/{{location}}/{{zone}}/{{subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default {{location}}/{{zone}}/{{subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default {{location}}/{{subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:edgenetwork/subnet:Subnet default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ipv4_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetArgs.__new__(SubnetArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["ipv4_cidrs"] = ipv4_cidrs
            __props__.__dict__["ipv6_cidrs"] = ipv6_cidrs
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["vlan_id"] = vlan_id
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Subnet, __self__).__init__(
            'gcp:edgenetwork/subnet:Subnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ipv4_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ipv6_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vlan_id: Optional[pulumi.Input[int]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Subnet':
        """
        Get an existing Subnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The time when the subnet was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        :param pulumi.Input[str] description: A free-text description of the resource. Max length 1024 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv4_cidrs: The ranges of ipv4 addresses that are owned by this subnetwork, in CIDR format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_cidrs: The ranges of ipv6 addresses that are owned by this subnetwork, in CIDR format.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels associated with this resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[str] location: The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
        :param pulumi.Input[str] name: The canonical name of this resource, with format
               `projects/{{project}}/locations/{{location}}/zones/{{zone}}/subnets/{{subnet_id}}`
        :param pulumi.Input[str] network: The ID of the network to which this router belongs.
               Must be of the form: `projects/{{project}}/locations/{{location}}/zones/{{zone}}/networks/{{network_id}}`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[str] state: Current stage of the resource to the device by config push.
        :param pulumi.Input[str] subnet_id: A unique ID that identifies this subnet.
               
               
               - - -
        :param pulumi.Input[str] update_time: The time when the subnet was last updated.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        :param pulumi.Input[int] vlan_id: VLAN ID for this subnetwork. If not specified, one is assigned automatically.
        :param pulumi.Input[str] zone: The name of the target Distributed Cloud Edge zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetState.__new__(_SubnetState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["ipv4_cidrs"] = ipv4_cidrs
        __props__.__dict__["ipv6_cidrs"] = ipv6_cidrs
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["zone"] = zone
        return Subnet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the subnet was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A free-text description of the resource. Max length 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="ipv4Cidrs")
    def ipv4_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The ranges of ipv4 addresses that are owned by this subnetwork, in CIDR format.
        """
        return pulumi.get(self, "ipv4_cidrs")

    @property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The ranges of ipv6 addresses that are owned by this subnetwork, in CIDR format.
        """
        return pulumi.get(self, "ipv6_cidrs")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels associated with this resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The canonical name of this resource, with format
        `projects/{{project}}/locations/{{location}}/zones/{{zone}}/subnets/{{subnet_id}}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The ID of the network to which this router belongs.
        Must be of the form: `projects/{{project}}/locations/{{location}}/zones/{{zone}}/networks/{{network_id}}`
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current stage of the resource to the device by config push.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        A unique ID that identifies this subnet.


        - - -
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time when the subnet was last updated.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[int]:
        """
        VLAN ID for this subnetwork. If not specified, one is assigned automatically.
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of the target Distributed Cloud Edge zone.
        """
        return pulumi.get(self, "zone")

